package WWW::Hetzner::Robot::CLI::Cmd::Reset;
our $VERSION = '0.001';
our $AUTHORITY = 'cpan:GETTY';

# ABSTRACT: Reset a dedicated server

use Moo;
use MooX::Cmd;
use MooX::Options protect_argv => 0, usage_string => 'USAGE: hrobot.pl reset <server-number> [--type sw|hw|man]';


option type => (
    is      => 'ro',
    format  => 's',
    short   => 't',
    doc     => 'Reset type: sw (software), hw (hardware), man (manual)',
    default => 'sw',
);

sub execute {
    my ($self, $args, $chain) = @_;
    my $root = $chain->[0];
    my $robot = $root->robot;

    my $server_number = $args->[0] or die "Usage: hrobot.pl reset <server-number> [--type sw|hw|man]\n";

    my $result = $robot->reset->execute($server_number, $self->type);

    if ($root->output eq 'json') {
        require JSON::MaybeXS;
        print JSON::MaybeXS::encode_json($result);
        print "\n";
    } else {
        print "Reset initiated for server $server_number (type: ", $self->type, ")\n";
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WWW::Hetzner::Robot::CLI::Cmd::Reset - Reset a dedicated server

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    hrobot.pl reset <server-number>
    hrobot.pl reset 123456
    hrobot.pl reset 123456 --type hw
    hrobot.pl reset 123456 -t man

=head1 DESCRIPTION

Triggers a reset of a dedicated server. Supports different reset types:

=over 4

=item B<sw> - Software reset (default, graceful)

=item B<hw> - Hardware reset (immediate power cycle)

=item B<man> - Manual reset (request technician intervention)

=back

=head1 NAME

hrobot.pl reset - Reset a dedicated server

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/Getty/p5-www-hetzner>

  git clone https://github.com/Getty/p5-www-hetzner.git

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
