# Pod::WikiDoc - check module loading and create testing directory

use Test::More;
use IO::String;
use lib "./t";
use Casefiles;

use Pod::WikiDoc;

#--------------------------------------------------------------------------#
# parser setup
#--------------------------------------------------------------------------#

my $parser = Pod::WikiDoc->new ();

#--------------------------------------------------------------------------#
# case file runner
#--------------------------------------------------------------------------#

my $cases = Casefiles->new( "t/filter_pod" );

plan tests => 2 + $cases->files();

#--------------------------------------------------------------------------#
# test "Generated by" line
#--------------------------------------------------------------------------#

{
    my $match = qr{\A# Generated by Pod::WikiDoc version};
    my $in_fh = IO::String->new("foo");
    my $out_fh = IO::String->new();
    $parser->_filter_podfile( $in_fh, $out_fh );
    seek $out_fh, 0, 0;
    my $version = $parser->VERSION();
    my $output = ${$out_fh->string_ref()};
    like(   
        $output,
        $match,
        "'Generated by' string found"
    );
    my ($found_version) = $output =~ m{$match\s+([0-9._]+)};
    # Too many ways to compare versions -- fall back to numeric and pray
    is( 0 + $found_version, 0 + $version,
        "'Generated by' had expected version"
    );
}
#--------------------------------------------------------------------------#
# run test cases
#--------------------------------------------------------------------------#

$cases->run_tests( 
    sub { 
        my $input_string = shift;
        my $input_fh = IO::String->new( $input_string );
        my $output_fh = IO::String->new();
        $parser->_filter_podfile( $input_fh, $output_fh );
        my $got = ${ $output_fh->string_ref() };
        $got =~ s{\A [^\n]+ \n \n}{}xms; # strip "Generated by" line
        return $got;
    }
);

