# Copyright (C) 2002 Rob Brown (bbb@cpan.org)
# Generic rpm SPEC file generator.

use strict;

my $p = $1 if $0 =~ m%([^/]*)$%;
my $output = shift or die "create what?";

### Extract $VERSION from VERSION_FROM
my $name;
my $version;
$INC{"ExtUtils/MakeMaker.pm"} = 1;
sub WriteMakefile {
  my %props = @_;
  $name = $props{NAME} || die "Makefile.PL: Missing NAME";
  if ($version = $props{VERSION}) {
    # done
  } elsif (my $version_from = $props{VERSION_FROM}) {
    $@ = "";
    $version = eval qq{
      do "$version_from";
      \$$name\::VERSION || die "$version_from: Missing VERSION";
    };
    die $@ if $@;
    if (!defined $version) {
      die "$version_from: Missing VERSION";
    }
  } else {
    die "Makefile.PL: Could not determine version!";
  }
}
do "Makefile.PL";
if ($name) {
  $name =~ s/::/-/g;
} else {
  die "Makefile.PL: Missing WriteMakefile";
}

$version || die "No version!";
local $/ = undef;
$_ = <DATA>;
s/\@NAME\@/$name/g;
s/\@VERSION\@/$version/g;

open SPEC, ">$output" or die "$output: $!";
print SPEC "# Automatically generated by $p\n";
print SPEC;
close SPEC;

__DATA__
%define perlmod @NAME@
Summary:	%{perlmod} perl module
Name:		perl-%{perlmod}
Version:	@VERSION@
Release:	1
License:	GPL
Group:		Development/Languages/Perl
Source0:	http://www.cpan.org./authors/id/B/BB/BBB/%{perlmod}-%{version}.tar.gz
Packager:	Rob Brown <bbb@cpan.org>
Prefix: 	/usr
BuildRequires:	perl
Requires:	perl
BuildRoot:	/var/tmp/%{name}-%{version}-root-%(id -u -n)
Provides:	%{perlmod} = %{version}

%description
%{perlmod} Perl Module

%prep
%setup -q -n %{perlmod}-%{version}

%build
perl Makefile.PL
make
make test

%install
rm -rf $RPM_BUILD_ROOT
make PREFIX=$RPM_BUILD_ROOT%{prefix} install
[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress
find $RPM_BUILD_ROOT%{prefix} -type f -print | perl -ne "print if s@^$RPM_BUILD_ROOT@@g && !/perllocal|packlist/" > %{name}-filelist

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-filelist
%defattr(-,root,root)
%doc README

%post

%changelog
* Sat Apr 06 2002 Rob Brown <bbb@cpan.org>
- initial creation
