package Net::Async::Spotify::Object::Generated::RecommendationSeed;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::RecommendationSeed - Package representing Spotify RecommendationSeed Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify RecommendationSeed Object attributes:

=over 4

=item afterFilteringSize

Type:Integer
Description:The number of tracks available after min_* and max_* filters have been applied.

=item afterRelinkingSize

Type:Integer
Description:The number of tracks available after relinking for regional availability.

=item href

Type:String
Description:A link to the full track or artist data for this seed. For tracks this will be a link to a Track Object. For artists a link to an Artist Object. For genre seeds, this value will be null.

=item id

Type:String
Description:The id used to select this seed. This will be the same as the string used in the seed_artists, seed_tracks or seed_genres parameter.

=item initialPoolSize

Type:Integer
Description:The number of recommended tracks available for this seed.

=item type

Type:String
Description:The entity type of this seed. One of artist, track or genre.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        afterFilteringSize => 'Integer',
        afterRelinkingSize => 'Integer',
        href => 'String',
        id => 'String',
        initialPoolSize => 'Integer',
        type => 'String',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
