# Generated by default/object.tt
package Paws::Connect::HoursOfOperationConfig;
  use Moose;
  has Day => (is => 'ro', isa => 'Str');
  has EndTime => (is => 'ro', isa => 'Paws::Connect::HoursOfOperationTimeSlice');
  has StartTime => (is => 'ro', isa => 'Paws::Connect::HoursOfOperationTimeSlice');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::HoursOfOperationConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::HoursOfOperationConfig object:

  $service_obj->Method(Att1 => { Day => $value, ..., StartTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::HoursOfOperationConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Day

=head1 DESCRIPTION

Contains information about the hours of operation.

=head1 ATTRIBUTES


=head2 Day => Str

The day that the hours of operation applies to.


=head2 EndTime => L<Paws::Connect::HoursOfOperationTimeSlice>

The end time that your contact center is closes.


=head2 StartTime => L<Paws::Connect::HoursOfOperationTimeSlice>

The start time that your contact center is open.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

