use 5.012;
use lib 't/lib';
use MyTest;
use Test::More;
use Test::Catch;
use Protocol::HTTP::Request;
use Protocol::HTTP::Message;

catch_run('[parse-compression]');

subtest "Accept-Encoding: gzip" => sub {
    my $p = Protocol::HTTP::RequestParser->new;

    my ($req, $state, $pos, $err) = $p->parse(
        "GET / HTTP/1.0\r\n".
        "Accept-Encoding: gzip\r\n".
        "\r\n"
    );

    is $state, Protocol::HTTP::Message::STATE_DONE;
    ok !$err;
    is $req->method, Protocol::HTTP::Request::METHOD_GET;
    is $req->http_version, 10;
    is $req->uri, "/";
    ok $req->allowed_compression & Protocol::HTTP::Compression::gzip;
    ok $req->allowed_compression & Protocol::HTTP::Compression::identity;
    is $req->compression, Protocol::HTTP::Compression::identity;
};

subtest "missing Accept-Encoding" => sub {
    my $p = Protocol::HTTP::RequestParser->new;

    my ($req, $state, $pos, $err) = $p->parse(
        "GET / HTTP/1.0\r\n".
        "Accept-Encoding: gzip\r\n".
        "\r\n"
    );

    is $state, Protocol::HTTP::Message::STATE_DONE;
    ok !$err;
    ok $req->allowed_compression & Protocol::HTTP::Compression::identity;
    is $req->compression, Protocol::HTTP::Compression::identity;
};


subtest "gzip encoded" => sub {
    my $p = Protocol::HTTP::RequestParser->new;
    my $data = pack("C*",
        0x50, 0x4f, 0x53, 0x54, 0x20, 0x2f, 0x20, 0x48,
        0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x31, 0x0d,
        0x0a, 0x48, 0x6f, 0x73, 0x74, 0x3a, 0x20, 0x31,
        0x32, 0x37, 0x2e, 0x30, 0x2e, 0x30, 0x2e, 0x31,
        0x0d, 0x0a, 0x55, 0x73, 0x65, 0x72, 0x2d, 0x41,
        0x67, 0x65, 0x6e, 0x74, 0x3a, 0x20, 0x63, 0x75,
        0x72, 0x6c, 0x2f, 0x37, 0x2e, 0x36, 0x37, 0x2e,
        0x30, 0x0d, 0x0a, 0x41, 0x63, 0x63, 0x65, 0x70,
        0x74, 0x3a, 0x20, 0x2a, 0x2f, 0x2a, 0x0d, 0x0a,
        0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d,
        0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
        0x3a, 0x20, 0x67, 0x7a, 0x69, 0x70, 0x0d, 0x0a,
        0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d,
        0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x3a, 0x20,
        0x33, 0x38, 0x0d, 0x0a, 0x43, 0x6f, 0x6e, 0x74,
        0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65,
        0x3a, 0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
        0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x78, 0x2d,
        0x77, 0x77, 0x77, 0x2d, 0x66, 0x6f, 0x72, 0x6d,
        0x2d, 0x75, 0x72, 0x6c, 0x65, 0x6e, 0x63, 0x6f,
        0x64, 0x65, 0x64, 0x0d, 0x0a, 0x0d, 0x0a, 0x1f,
        0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x03, 0xf3, 0xc9, 0x2f, 0x4a, 0xcd, 0x55, 0xc8,
        0x2c, 0x28, 0x2e, 0xcd, 0x55, 0x48, 0xc9, 0xcf,
        0xc9, 0x2f, 0xe2, 0x02, 0x00, 0xe8, 0xd0, 0x4e,
        0xfa, 0x12, 0x00, 0x00, 0x00
    );
    my ($req, $state, $pos, $err) = $p->parse($data);

    is $state, Protocol::HTTP::Message::STATE_DONE;
    ok !$err;
    is $req->compression, Protocol::HTTP::Compression::gzip;
};

done_testing;
