### base class of e.g. functor algorithms derived

sub new {
    my $class = shift;

    $self = { bitmapmatrix => undef, componentsbag => undef };
    
    bless $self, $class;
}

sub init {
    my ($self, $bitmapmatrix) = @_;

    $self->{bitmapmatrix} = $bitmapmatrix;
    $self->{componentsbag} = OnePassBitmapAlgorithmComponentsBag->new;
}

### NOTE : see pass function below
sub getBitmap {
  my $self = shift;

  return $self->{bitmapmatrix};
}

sub getBag {
  my $self = shift;

  return $self->{componentsbag};
}

### NOTE sets first element
sub addToBag {
  my ($self, $bagel) = @_;

  $self->{componentsbag}->addBagElement1($bagel1);
}

sub pass {
    my ($self, $onepasssystem) = @_;

    return $onepasssystem->run($self);
}

1;
