use Test::More;
use strict;
use warnings;
our ( $sub, $globref );

BEGIN {
	use_ok('String::Locale::YAML');
	$sub     = sub { };
	$globref = \*globref;
}
subtest 'new' => sub {
	plan tests => 3;
	ok( my $obj = String::Locale::YAML->new( {} ),
		q{my $obj = String::Locale::YAML->new({})}
	);
	ok( $obj = String::Locale::YAML->new(),
		q{$obj = String::Locale::YAML->new()}
	);
	isa_ok( $obj, 'String::Locale::YAML' );
};
subtest 'extends \"String\:\:Locale\:\:Object\"' => sub {
	plan tests => 1;
	ok( my $obj = String::Locale::YAML->new( {} ),
		q{my $obj = String::Locale::YAML->new({})}
	);
};
subtest 'has file' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::YAML->new( {} ),
		q{my $obj = String::Locale::YAML->new({})}
	);
	can_ok( $obj, 'file' );
	eval { $obj->file( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->file([])} );
	eval { $obj->file( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->file(\1)} );
};
subtest 'load_file' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::YAML->new( {} ),
		q{my $obj = String::Locale::YAML->new({})}
	);
	can_ok( $obj, 'load_file' );
	eval { $obj->load_file( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->load_file([])} );
	eval { $obj->load_file( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->load_file(\1)} );
};
subtest 'write_file' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::YAML->new( {} ),
		q{my $obj = String::Locale::YAML->new({})}
	);
	can_ok( $obj, 'write_file' );
	eval { $obj->write_file( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file([])} );
	eval { $obj->write_file( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file(\1)} );
};
done_testing();
