#include "tkWinInt.h"
/* We keep a char here to emulate ToAscii later. Note that ToAscii
   is used before any WM_CHAR is recieved to init the map. We hope
   for the best here. */
char StashedKey;
HWND tmpParent;

/*
 *----------------------------------------------------------------------
 *
 * OS2Tcl_WaitForEvent --
 *
 *	This procedure does the lowest level wait for events in a
 *	platform-specific manner.  It uses information provided by
 *	previous calls to Tcl_WatchFile, plus the timePtr argument,
 *	to determine what to wait for and how long to wait.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	May put the process to sleep for a while, depending on timePtr.
 *	When this procedure returns, an event of interest to the application
 *	has probably, but not necessarily, occurred.
 *
 *----------------------------------------------------------------------
 */

int
OS2Tcl_WaitForEvent(n, maskPtr, timePtr)
    int n;
    long *maskPtr;		/* file part, not used so far. */
    Tcl_Time *timePtr;		/* Specifies the maximum amount of time
				 * that this procedure should block before
				 * returning.  The time is given as an
				 * interval, not an absolute wakeup time.
				 * NULL means block forever. */
{
    MSG msg;
    int foundEvent = 1;

    /*
     * If we are ignoring events from the system, just return immediately.
     */
/*
    if (ignoreEvents) {
	return 0;
    }
*/
    /*
     * Set up the asynchronous select handlers for any sockets we
     * are watching.
     */

    /* TclWinNotifySocket(); */

    /*
     * Look for an event, setting a timer so we don't block forever.
     */

    if (timePtr != NULL) {
	UINT ms;
	ms = timePtr->sec * 1000;
	ms += timePtr->usec / 1000;

	if (ms > 0) {
	    UINT timerHandle = SetTimer(tmpParent, 0, ms, NULL);
	    GetMessage(&msg, NULL, 0, 0);
	    KillTimer(tmpParent, timerHandle);
	} else {

	    /*
	     * If the timeout is too small, we just poll.
	     */

	    foundEvent = PeekMessage(&msg, NULL, 0, 0, PM_REMOVE);
	}
    } else {
	GetMessage(&msg, NULL, 0, 0);
    }

    /*
     * Dispatch the message, if we found one.  If we are exiting, be
     * sure to inform Tcl so we can clean up properly.
     */

    if (foundEvent) {
	if (msg.message == WM_QUIT) {
	    Tcl_Exit(0);
	}
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }
    return 1;
}

#undef ReleaseDC
#undef GetDC

#ifdef 0 /* Paints black on black? */

static HWND hwndDesktop;

int        
MyReleaseDC( HWND h, HDC dc)
{ 
  if (h) return ReleaseDC(h,dc);
  return ReleaseDC(hwndDesktop,dc);
}


HDC        
MyGetDC( HWND h)
{ 
  static HDC dc;

  if (h) return GetDC(h);
  if (!hwndDesktop) hwndDesktop = GetDesktopWindow();
  return GetDC(hwndDesktop);
}

#else /* ! 0 */

int        
MyReleaseDC( HWND h, HDC dc)
{ 
  if (h) return ReleaseDC(h,dc);
  return 0;
}


HDC        
MyGetDC( HWND h)
{ 
  static HDC dc;

  if (h) return GetDC(h);
  if (!dc) dc = GetDC(h);
  return dc;
}


#endif /* !0 */

/* Here we put some stubs for functions called from TKGEN. */

#undef XFlush
#undef XFree
#undef XGrabServer
#undef XNoOp
#undef XUngrabServer
#undef XSynchronize
#undef XSync
#undef XVisualIDFromVisual

#ifndef SvREFCNT

void XFlush(Display *display) {}
void XFree(void *data) {if ((data) != NULL) ckfree((char *) (data));}
void XGrabServer(Display *display) {}
void XNoOp(Display *display) {display->request++;}
void XUngrabServer(Display *display) {}
int (*XSynchronize(Display *display, int i))() {display->request++; return NULL;}
void XSync(Display *display, int i) {display->request++;}
VisualID XVisualIDFromVisual(Visual *visual) {return visual->visualid;}

#endif

/* Cursor stuff */

#include <rc/cursors.h>

HCURSOR
os2LoadCursor(module, name)
    HMODULE module;
    char*   name;
{
    myCursor *curPtr = cursors;
    while (curPtr->name) {
	if (strcmp(curPtr->name, name) == 0) {
	    break;
	}
	curPtr++;
    }
    if (curPtr->name) {
	return LoadCursor(module, curPtr->id);
    } else {
	return NULL;
    }
}

HICON
os2LoadIcon(module, name)
    HMODULE module;
    char*   name;
{
    myCursor *curPtr = cursors;
    while (curPtr->name) {
	if (strcmp(curPtr->name, name) == 0) {
	    break;
	}
	curPtr++;
    }
    if (curPtr->name) {
	return LoadIcon(module, curPtr->id);
    } else {
	return NULL;
    }
}
