package GDB::bt;

=head1 NAME

GDB::bt - Get perl backtraces from coredump files

=head1 SYNOPSIS

    $ gdb-bt.pl core.17373
    Reading symbols from perl...
    [New LWP 17373]
    [Thread debugging using libthread_db enabled]
    Using host libthread_db library "/usr/lib/libthread_db.so.1".
    Core was generated by `rpc                                    '.
    Program terminated with signal SIGABRT, Aborted.
    #0  __GI_raise (sig=sig@entry=6) at ../sysdeps/unix/sysv/linux/raise.c:50
        50../sysdeps/unix/sysv/linux/raise.c: No such file or directory.
    Perl version =  32 ' '
    [0] 0x5597599303b2 "lib/Panda/XServer/RPC/Async/WClientImpl.pm":119
    [1] 0x5597599303b2 "lib/Panda/XServer/RPC/Async/WClientImpl.pm":63
    [2] 0x559757a89492 "lib/Panda/XServer/RPC/WClientImpl.pm":162
    [3] 0x559757a89492 "lib/Panda/XServer/RPC/WClientImpl.pm":106
    [4] 0x5597560d1e12 "t/03-xserver/01-rpc-async.t":35
    [5] 0x5597575113f2 "lib/Panda/Timer.pm":48
    [6] 0x559756ca0c42 "/home/b/development/crazy-panda/core-dev/t/lib/Panda/TestEnvironment.pm":192
    [7] 0x559756ca0c42 "/home/b/development/crazy-panda/core-dev/t/lib/Panda/TestEnvironment.pm":192
    [8] 0x5597560d1e12 "t/03-xserver/01-rpc-async.t":56


=head1 DESCRIPTION

If your perl program segfaults you can easily extract C<C> backtraces, however perl bactraces are
not available. Usually you can I<guess> correctly them (e.g. from logs), but that takes time
and it is error-prone. The proposed script solves at least partially solves the problem.

The script target audience is: XS-modules writers and bug-reporters (for perl core and XS-modules).

=head1 LIMITATIONS

Currently it was tested on the following configurations:

=over

=item 5.30 (non threaded, linux)

=item 5.32 (non-threaded, linux)

=back

If it works on your perl and it is not listed here, please, let us know.

=head1 INTERNALS

The main script is written in Python, as gdb out of the box has official Python-bindings.
To extend it, you should look a the perl sources somewhere around C<pp_ctl.c / caller_cx>
and duplicate the code in the Python script. Yes, you have to expand all perl macroses,
undocumented perl internals etc., to let it work. There is no other way. 

=head1 AUTHOR

Ivan Baidakou <dmol@cpan.org>, Crazy Panda LTD

=head1 LICENSE

You may distribute this code under the same terms as Perl itself.


=cut

1;
