
/****************************************************************************/

#define STRICT

#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "..\common\plugin.h"		// Breeze Designer Plug-In interface
#include "..\common\pitools.h"  	// Breeze Designer Plug-In tools
#include "..\common\piutils.h"  	// Breeze Designer Misc utilities
#include "pisample.h"
#include "resource.h"
#include "utils.h"

/*
 * This sample plugin implements stubs for a number of plugin type
 * In total stubs for 7 different plugin types or class are contained
 * in this sample. Common handlers are also implemented for various
 * plugin messages.
 *
 */

#define PLUGIN_FUNCTION_COUNT 7
#define PLUGIN_FILE_FILTER 	"Test File (*.txt) |*.txt||"
#define PLUGIN_INFORMATION		"Test plugin"
#define PLUGIN_BITMAP				IDB_SAMPLE

static PLUGINFUNCTIONS gPlugInFunctions[] =
	{
	PICLASS_UTIL   ,"TestUtil"	   ,"Test Utility",
	PICLASS_LOAD   ,"TestLoad"	   ,"Test Load",
	PICLASS_SAVE   ,"TestSave"	   ,"Test Save",
	PICLASS_BUILD  ,"TestBuild"	,"Test Build",
	PICLASS_XFORM  ,"TestXform"	,"Test Transform",
	PICLASS_SCREEN ,"TestScreen"  ,"Test Screen",
	NULL		      ,NULL		      ,NULL
	};                            

static HINSTANCE gInstance = NULL;

/*
 * The following data is used to support the plugin property interface. 
 * Plugins may publish a list of properties that may be modified by
 * Breeze Designer, user macros or other plugins.
 */
enum SampleProperties
{
	SAMPLE_VERSION,
	SAMPLE_EN_PREVIEW,
};

static PIPROPERTY gProperty[] =
	{
	1,	"Version", 			{ sizeof(BDVAR), BDVAR_UINT,   0, 0,  1 },
	1,	"EnablePreview",	{ sizeof(BDVAR), BDVAR_UINT,   0, 0,  0 },
	0,	0,			0
	};

#define VALUE(n)  BDVAR_GETUINT( gProperty[n].varValue )
#define VALUEF(n) BDVAR_GETDOUBLE( gProperty[n].varValue )


/****************************************************************************
*
*   Plug-In Filter Sample for Breeze Designer
*   Written by Neville Richards
*
*   Copyright (C) 1994-1997 Neville Richards. All Rights Reserved.
*
*****************************************************************************/

#ifdef _WIN32
/******************************************************************************\
*
*  FUNCTION:    DllMain
*
*  INPUTS:      hDLL       - handle of DLL
*	       dwReason   - indicates why DLL called
*	       lpReserved - reserved
*
*  RETURNS:     TRUE (always, in this example.)
*
*	       Note that the retuRn value is used only when
*	       dwReason = DLL_PROCESS_ATTACH.
*
*	       Normally the function would return TRUE if DLL initial-
*	       ization succeeded, or FALSE it it failed.
*
*  GLOBAL VARS: ghMod - handle of DLL (initialized when PROCESS_ATTACHes)
*
*  COMMENTS:    The function will display a dialog box informing user of
*	       each notification message & the name of the attaching/
*	       detaching process/thread. For more information see
*	       "DllMain" in the Win32 API reference.
*
\******************************************************************************/

BOOL WINAPI DllMain (HINSTANCE hDLL, DWORD dwReason, LPVOID lpReserved)
{
  switch (dwReason)
  {
    case DLL_PROCESS_ATTACH:
		gInstance = hDLL;
      break;

    case DLL_THREAD_ATTACH:
      break;

    case DLL_THREAD_DETACH:
      break;

    case DLL_PROCESS_DETACH:
      break;
  }

return TRUE;
}
#else
/****************************************************************************
   FUNCTION: LibMain(HANDLE, WORD, WORD, LPSTR)

   PURPOSE:  Is called by LibEntry.  LibEntry is called by Windows when
	     the DLL is loaded.  The LibEntry routine is provided in
	     the LIBENTRY.OBJ in the SDK Link Libraries disk.  (The
	     source LIBENTRY.ASM is also provided.)

	     LibEntry initializes the DLL's heap, if a HEAPSIZE value is
	     specified in the DLL's DEF file.  Then LibEntry calls
	     LibMain.  The LibMain function below satisfies that call.

	     The LibMain function should perform additional initialization
	     tasks required by the DLL.  In this example, no initialization
	     tasks are required.  LibMain should return a value of 1 if
	     the initialization is successful.

*******************************************************************************/
int FAR PASCAL LibMain(HANDLE hModule, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
	return 1;
}

/****************************************************************************
*    FUNCTION:  WEP(int)
*
*    PURPOSE:  Performs cleanup tasks when the DLL is unloaded.  WEP() is
*	      called automatically by Windows when the DLL is unloaded (no
*	      remaining tasks still have the DLL loaded).  It is strongly
*	      recommended that a DLL have a WEP() function, even if it does
*	      nothing but returns success (1), as in this example.
*
*/
int FAR PASCAL EXPORT _WEP (int bSystemExit)
{
    return(1);
}
#endif

#ifdef LOCAL

static PICALLBACK gFunction = NULL;

/*
 * The following functions are available in the plug-in tools (piTools) DLL.
 * and have been listed here in the event that additional initialisation
 * or validation are required for a plug-in.
 */

///////////////////////////////////////////////////////////////////////
//
BOOL piLibInit( UINT nVersion, LPPLUGININFO lpInfo, LPPIFNS lpFunctions, UINT nFunctions )
{
	//
	// Check for version number. Fail if the interface version is different
	//
	if (nVersion != PIVERSION)
		{
		TRACE("Plug-in Init failed: incorrect version");

		return FALSE;
		}
	//
	// Assign local function table for return
	//
	lpInfo->lpFunctions    = lpFunctions;
	lpInfo->nFunctionCount = nFunctions;

	//
	// No local data block used. A local data block may be allocated
	// here and returned to the host. This will be passed back to
	// this plug-in in subsequent calls. This may be used to store
	// state global information.
	//
	lpInfo->lpPlugInData   = NULL;

	gFunction = lpInfo->lpCallBack;

	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL piLibFuncInit( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData, UINT nMode )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	if (lpCall->nPluginDataSize != sizeof(PLUGINDATA))
		{
		return FALSE;
		}

	//
	// If basic then TRUE only for get data operations. If we can only
	// handle basic fuctions ie GETDATA then return appropriately.
	//
	if (nMode == PIFUNC_BASIC)
		{
		return (nOperation == PI_GETDATA ? TRUE : FALSE);
		}

	return TRUE;
}
#endif


#define MESSAGE(x) LOWORD(x)

/****************************************************************************
*
*  ExecDialog
*/
WINAPI dlgSetup(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
		{
		case WM_INITDIALOG:
			CheckDlgButton( hDlg, IDC_EN_PREVIEW, (VALUE( SAMPLE_EN_PREVIEW ) ? MF_CHECKED : MF_UNCHECKED) );
		   return TRUE;
			break;

		case WM_COMMAND:

			switch ( MESSAGE(wParam))
				{
				case IDOK:

				VALUE( SAMPLE_EN_PREVIEW ) = IsDlgButtonChecked( hDlg, IDC_EN_PREVIEW );

				case IDCANCEL:
					EndDialog(hDlg, TRUE);
					return (TRUE);
					break;
				}
		}
   return FALSE;
}

/****************************************************************************
*
*  ExecDialog
*/
BOOL ExecDialog( HWND hWnd, FARPROC lpProc, HINSTANCE hInst, WORD idResource )
{
	DLGPROC lpProcDlg;

	lpProcDlg = (DLGPROC)MakeProcInstance(lpProc, hInst);

	DialogBox(hInst,		/* current instance       */
		MAKEINTRESOURCE(idResource),
		hWnd,     /* parent handle       */
		lpProcDlg);			/* Dlg() instance address */

	FreeProcInstance( (FARPROC)lpProcDlg );

	return TRUE;
}

/****************************************************************************
*/
BOOL OnConfig( LPPLUGINDATA lpCall )
{
	return ExecDialog( (HWND)lpCall->lpData, dlgSetup, gInstance, IDD_SETTINGS );
}

/****************************************************************************
*/
BOOL OnGetCaps( LPPLUGINDATA lpCall )
{
	//
	// Return capabilities flag
	//
	lpCall->nDataType = PIDATA_FLAGS;
	lpCall->nDataSize = (PI_GETCAPS|PI_GETINFO|PI_CONFIG|PI_GETDATA);

	return TRUE;
}

/****************************************************************************
*/
BOOL OnGetInfo( LPPLUGINDATA lpCall )
{
	//
	// Return function information string. The information string
	// may be used to provide the name of the plugin and a short
	// description if appropriate.
	//
	lpCall->nDataType = PIDATA_STRING;
	lpCall->nDataSize = lstrlen(PLUGIN_INFORMATION);
	lpCall->lpData    = PLUGIN_INFORMATION;

	return TRUE;
}

/****************************************************************************
*/
BOOL OnGetIcon( LPPLUGINDATA lpCall )
{
	//
	// Return function icon string. This function should return
	// the name of a bitmap resource.
	//
	lpCall->nDataType = PIDATA_HANDLE;
	lpCall->lpData    = (LPSTR)PLUGIN_BITMAP;
	lpCall->nDataSize = sizeof(DWORD);

	return TRUE;
}

/****************************************************************************
*/
BOOL OnGetFilter( LPPLUGINDATA lpCall )
{
	//
	// Return file filter information. This information is used
	// for plugins that implement file based interfaces.
	//
	lpCall->nDataType = PIDATA_STRING;
	lpCall->nDataSize = lstrlen(PLUGIN_FILE_FILTER);
	lpCall->lpData    = PLUGIN_FILE_FILTER;

	return TRUE;
}

/****************************************************************************
*/
BOOL OnGetProperty( LPPLUGINDATA lpCall )
{
	if (lpCall == NULL || lpCall->lpData == NULL)
		{
		TRACE("OnSetProperty: invalid argument\n");

		return FALSE;
		}

	return piGetLocalPluginProperty( (LPPIPROPERTY)lpCall->lpData, gProperty );
}

/****************************************************************************
*/
BOOL OnSetProperty( LPPLUGINDATA lpCall )
{
	if (lpCall == NULL || lpCall->lpData == NULL)
		{
		TRACE("OnSetProperty: invalid argument\n");

		return FALSE;
		}

	return piSetLocalPluginProperty( (LPPIPROPERTY)lpCall->lpData, gProperty );
}

/****************************************************************************
*
* Initialize one time state.
*
*/
PIAPI piInit( UINT nVersion, LPPLUGININFO lpInfo )
{
	return piLibInit( nVersion, lpInfo, gPlugInFunctions, PLUGIN_FUNCTION_COUNT  );
}

/****************************************************************************
*
*   Clean up before unloading.
*/
PIAPI piExit( LPVOID lpLocalData )
{
	//
	// Free local data block if required
	//
	return TRUE;
}

/****************************************************************************
*/
PIAPI DefaultPluginHandler( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	switch (nOperation)
		{
		case PI_GETCAPS:
			return OnGetCaps( lpCall );
			break;

		case PI_GETINFO:
			return OnGetInfo( lpCall );
			break;

		case PI_GETICON:
			return OnGetIcon( lpCall );
			break;

		case PI_GETFILTER:
			return OnGetFilter( lpCall );
			break;

		case PI_GETPROPERTY:
			return OnGetProperty( lpCall );
			break;

		case PI_SETPROPERTY:
			return OnSetProperty( lpCall );
			break;

		default:
			return FALSE;
			break;
		}
	return FALSE;
}

/****************************************************************************
*/
PIAPI TestUtil( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	return TRUE;
}

/****************************************************************************
*/
PIAPI TestLoad( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	switch (nOperation)
		{
		case PI_GETDATA:
			//
			// Create new object(s)
			//
			TRACE("Loading file: %s\n", (LPSTR)lpCall->lpData );

			break;

		default:
			return DefaultPluginHandler( nOperation, lpLocalData, lpData );
			break;
		}

	return FALSE;
}

/****************************************************************************
*/
PIAPI TestSave( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	switch (nOperation)
		{
		case PI_PUTDATA:
			//
			// Get local objects and write out
			//
			TRACE("Saving file: %s\n", (LPSTR)lpCall->lpData );

			break;

		default:
			return DefaultPluginHandler( nOperation, lpLocalData, lpData );
			break;
		}

	return FALSE;
}

/****************************************************************************
*/
PIAPI TestBuild( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	switch (nOperation)
		{
		case PI_CONFIG:
		  /*
			* Call local configuration functions
			*/
			return OnConfig( lpCall );

			break;

		case PI_GETDATA:
			/*
			 * Create new object(s)
			 */
			return CreateTetrahedron();

			break;

		default:
			return DefaultPluginHandler( nOperation, lpLocalData, lpData );
			break;
		}
	return FALSE;
}

/****************************************************************************
*/
PIAPI TestXform( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	switch (nOperation)
		{
		default:
			return DefaultPluginHandler( nOperation, lpLocalData, lpData );
			break;
		}
	return FALSE;
}

/****************************************************************************
*/
BOOL OnGetFlags( LPPLUGINDATA lpCall )
{
	//
	// Return capabilities flag
	//
	lpCall->nDataType = PIDATA_FLAGS;
	lpCall->nDataSize = 0;

	return TRUE;
}

/****************************************************************************
*/
PIAPI TestScreen( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	switch (nOperation)
		{
		case PI_GETFLAGS:
			return OnGetFlags( lpCall );
			break;

		case PI_GETDATA:
			/* 
			 * Overload the default preview screen generator
			 */
			if ( VALUE( SAMPLE_EN_PREVIEW ) == 0)
				{
				return FALSE;
				}
			return RenderPreviewScene( lpCall );
			break;

		default:
			return DefaultPluginHandler( nOperation, lpLocalData, lpData );
			break;
		}
	return FALSE;
}

/****************************************************************************/


