// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item expanded "><a href="index.html"><strong aria-hidden="true">1.</strong> Introduction</a></li><li class="chapter-item expanded "><a href="installation.html"><strong aria-hidden="true">2.</strong> Installation</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="vs_code.html"><strong aria-hidden="true">2.1.</strong> VS Code</a></li><li class="chapter-item expanded "><a href="rust_analyzer_binary.html"><strong aria-hidden="true">2.2.</strong> rust-analyzer Binary</a></li><li class="chapter-item expanded "><a href="other_editors.html"><strong aria-hidden="true">2.3.</strong> Other Editors</a></li></ol></li><li class="chapter-item expanded "><a href="troubleshooting.html"><strong aria-hidden="true">3.</strong> Troubleshooting</a></li><li class="chapter-item expanded "><a href="configuration.html"><strong aria-hidden="true">4.</strong> Configuration</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="non_cargo_based_projects.html"><strong aria-hidden="true">4.1.</strong> Non-Cargo Based Projects</a></li></ol></li><li class="chapter-item expanded "><a href="security.html"><strong aria-hidden="true">5.</strong> Security</a></li><li class="chapter-item expanded "><a href="privacy.html"><strong aria-hidden="true">6.</strong> Privacy</a></li><li class="chapter-item expanded "><a href="features.html"><strong aria-hidden="true">7.</strong> Features</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="assists.html"><strong aria-hidden="true">7.1.</strong> Assists (Code Actions)</a></li><li class="chapter-item expanded "><a href="diagnostics.html"><strong aria-hidden="true">7.2.</strong> Diagnostics</a></li></ol></li><li class="chapter-item expanded "><a href="editor_features.html"><strong aria-hidden="true">8.</strong> Editor Features</a></li><li class="chapter-item expanded "><a href="contributing/index.html"><strong aria-hidden="true">9.</strong> Contributing</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item expanded "><a href="contributing/architecture.html"><strong aria-hidden="true">9.1.</strong> Architecture</a></li><li class="chapter-item expanded "><a href="contributing/debugging.html"><strong aria-hidden="true">9.2.</strong> Debugging</a></li><li class="chapter-item expanded "><a href="contributing/guide.html"><strong aria-hidden="true">9.3.</strong> Guide</a></li><li class="chapter-item expanded "><a href="contributing/lsp-extensions.html"><strong aria-hidden="true">9.4.</strong> LSP Extensions</a></li><li class="chapter-item expanded "><a href="contributing/setup.html"><strong aria-hidden="true">9.5.</strong> Setup</a></li><li class="chapter-item expanded "><a href="contributing/style.html"><strong aria-hidden="true">9.6.</strong> Style</a></li><li class="chapter-item expanded "><a href="contributing/syntax.html"><strong aria-hidden="true">9.7.</strong> Syntax</a></li></ol></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0].split("?")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
