%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.4/input/regression/alternative-nest-end-end-segno2.ly"
\sourcefileline 0
\version "2.23.6"

#(ly:set-option 'warning-as-error #t)

\header {
  texidoc="This case nests one @code{\\alternative} within another at
the tail end of a @code{\\repeat segno}.  Alternative bar numbering is
enabled.

The outer alternative receives a coda mark, no volta bracket, and
normal bar numbering.

The inner alternative receives volta brackets.  Alternative bar
numbering is used because they are the outermost volta brackets.

The music unfolds to ABC ABD AE."
}

\layout {
  \context {
    \Score
    alternativeNumberingStyle = #'numbers-with-letters
    \override BarNumber.break-visibility = #all-visible
  }
}

piece = \new Voice \fixed c' {
  \repeat segno 3 {
    s1_"A"
    { % This extra {} shows that it isn't necessary for the
      % \alternative music to be the child of the \repeat music.
      \alternative {
        \volta 1,2 {
          s1_"B"
          \alternative {
            \volta 1 s1_"C"
            \volta 2 s1_"D"
          }
        }
        \volta 3 <>
      }
    }
  }
  \sectionLabel "Coda"
  s1_"E"
}

\new Score { \piece }
\new Score { \unfoldRepeats \piece }



% ****************************************************************
% end ly snippet
% ****************************************************************
