/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class EnvotechProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$").number("dd").expression("...,").number("(x+),").number("x+,").number("(x+),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("xx").number("(dd)").number("d{5},").number("(ddd)").number("(ddd),").number("(xx)").number("(xx),").number("(xxx)?").number("(xxx)?,").number("(x{8}),").expression("[^']*'").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)").number("(d)").number("(d+)(d{5})([NS])").number("(d+)(d{5})([EW])").number("(ddd)").number("(ddd)").any().compile();

    public EnvotechProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        int event = parser.nextHexInt();
        switch (event) {
            case 96: {
                position.addAlarm("lock");
                break;
            }
            case 97: {
                position.addAlarm("unlock");
            }
        }
        position.set("event", event);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setDeviceTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.set("rssi", parser.nextInt());
        position.set("power", (double)parser.nextInt().intValue() * 0.01);
        position.set("battery", (double)parser.nextInt().intValue() * 0.01);
        position.set("input", parser.nextHexInt());
        position.set("out", parser.nextHexInt());
        position.set("fuel", parser.nextHexInt());
        position.set("weight", parser.nextHexInt());
        position.set("status", parser.nextHexLong());
        position.setFixTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(parser.nextInt() > 0);
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_DEG_HEM));
        position.setSpeed(parser.nextInt().intValue());
        position.setCourse(parser.nextInt().intValue());
        return position;
    }
}

