/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.DescribeTransactionsRequestData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeTransactionsResponse;

public class DescribeTransactionsRequest
extends AbstractRequest {
    private final DescribeTransactionsRequestData data;

    private DescribeTransactionsRequest(DescribeTransactionsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_TRANSACTIONS, version);
        this.data = data;
    }

    @Override
    public DescribeTransactionsRequestData data() {
        return this.data;
    }

    @Override
    public DescribeTransactionsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        DescribeTransactionsResponseData response = new DescribeTransactionsResponseData().setThrottleTimeMs(throttleTimeMs);
        for (String transactionalId : this.data.transactionalIds()) {
            DescribeTransactionsResponseData.TransactionState transactionState = new DescribeTransactionsResponseData.TransactionState().setTransactionalId(transactionalId).setErrorCode(error.code());
            response.transactionStates().add(transactionState);
        }
        return new DescribeTransactionsResponse(response);
    }

    public static DescribeTransactionsRequest parse(Readable readable, short version) {
        return new DescribeTransactionsRequest(new DescribeTransactionsRequestData(readable, version), version);
    }

    @Override
    public String toString(boolean verbose) {
        return this.data.toString();
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeTransactionsRequest> {
        public final DescribeTransactionsRequestData data;

        public Builder(DescribeTransactionsRequestData data) {
            super(ApiKeys.DESCRIBE_TRANSACTIONS);
            this.data = data;
        }

        @Override
        public DescribeTransactionsRequest build(short version) {
            return new DescribeTransactionsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

