/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.table.AbstractTableModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;

public abstract class TabTableModel
extends AbstractTableModel {
    protected final TabDataModel tabModel;

    protected TabTableModel(TabDataModel tabDataModel) {
        this.tabModel = tabDataModel;
    }

    public static TabTableModel create(TabDataModel tabDataModel, int n) {
        if (n == 2 || n == 4) {
            return new ColumnTableModel(tabDataModel);
        }
        return new RowTableModel(tabDataModel);
    }

    public static TabTableModel create(TabDataModel tabDataModel, List<Integer> list) {
        return new MapTableModel(tabDataModel, list);
    }

    @Override
    public final Object getValueAt(int n, int n2) {
        TabData tabData = null;
        int n3 = this.toTabIndex(n, n2);
        if (n3 >= 0 && n3 < this.tabModel.size()) {
            tabData = this.tabModel.getTab(n3);
        }
        return tabData;
    }

    public final Class getColumnClass(int n) {
        return TabData.class;
    }

    protected abstract int toTabIndex(int var1, int var2);

    protected abstract int toColumnIndex(int var1);

    protected abstract int toRowIndex(int var1);

    private static class MapTableModel
    extends TabTableModel {
        private final List<Integer> tabIndexes;

        public MapTableModel(TabDataModel tabDataModel, List<Integer> list) {
            super(tabDataModel);
            this.tabIndexes = list;
        }

        @Override
        protected int toTabIndex(int n, int n2) {
            int n3 = -1;
            if (n2 >= 0 && n2 < this.tabIndexes.size()) {
                n3 = this.tabIndexes.get(n2);
            }
            return n3;
        }

        @Override
        protected int toColumnIndex(int n) {
            int n2 = 0;
            for (Integer n3 : this.tabIndexes) {
                if (n3 == n) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        @Override
        protected int toRowIndex(int n) {
            return 0;
        }

        @Override
        public int getRowCount() {
            return this.tabIndexes.isEmpty() ? 0 : 1;
        }

        @Override
        public int getColumnCount() {
            return this.tabIndexes.size();
        }
    }

    private static class ColumnTableModel
    extends DefaultTabTableModel {
        public ColumnTableModel(TabDataModel tabDataModel) {
            super(tabDataModel);
        }

        @Override
        protected int toTabIndex(int n, int n2) {
            return n;
        }

        @Override
        public int getRowCount() {
            return this.tabModel.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        protected int toColumnIndex(int n) {
            return 0;
        }

        @Override
        protected int toRowIndex(int n) {
            return n;
        }
    }

    private static class RowTableModel
    extends DefaultTabTableModel {
        public RowTableModel(TabDataModel tabDataModel) {
            super(tabDataModel);
        }

        @Override
        protected int toTabIndex(int n, int n2) {
            return n2;
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public int getColumnCount() {
            return this.tabModel.size();
        }

        @Override
        protected int toColumnIndex(int n) {
            return n;
        }

        @Override
        protected int toRowIndex(int n) {
            return 0;
        }
    }

    private static abstract class DefaultTabTableModel
    extends TabTableModel
    implements ComplexListDataListener {
        DefaultTabTableModel(TabDataModel tabDataModel) {
            super(tabDataModel);
            tabDataModel.addComplexListDataListener((ComplexListDataListener)this);
        }

        public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
            this.fireTableStructureChanged();
        }

        public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
            this.fireTableStructureChanged();
        }

        public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
            this.fireTableStructureChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableStructureChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableStructureChanged();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }
    }
}

