/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserTable;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCompound;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementProcedure;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSet;
import org.hsqldb.StatementSignal;
import org.hsqldb.StatementSimple;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ParserRoutine
extends ParserTable {
    static String[] featureStrings = new String[]{"H901_03"};

    ParserRoutine(Session session, Scanner scanner) {
        super(session, scanner);
    }

    Statement compileOpenCursorStatement(StatementCompound statementCompound) {
        this.readThis(206);
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        this.read();
        for (int i = 0; i < statementCompound.cursors.length; ++i) {
            if (!statementCompound.cursors[i].getCursorName().name.equals(string)) continue;
            return statementCompound.cursors[i];
        }
        throw Error.parseError(4680, null, this.scanner.getLineNumber());
    }

    Statement compileSelectSingleRowStatement(RangeGroup[] rangeGroupArray) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        LongDeque longDeque = new LongDeque();
        this.compileContext.setOuterRanges(rangeGroupArray);
        QuerySpecification querySpecification = this.XreadSelect();
        this.readThis(151);
        RangeVariable[] rangeVariableArray = rangeGroupArray[0].getRangeVariables();
        this.readTargetSpecificationList(orderedHashSet, rangeVariableArray, longDeque);
        this.XreadTableExpression(querySpecification);
        querySpecification.setReturningResult();
        int[] nArray = new int[longDeque.size()];
        longDeque.toArray(nArray);
        Object[] objectArray = new Expression[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        Type[] typeArray = new Type[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (((Expression)objectArray[i]).getColumn().getParameterMode() == 1) {
                throw Error.parseError(2500, null, this.scanner.getLineNumber());
            }
            typeArray[i] = ((Expression)objectArray[i]).getDataType();
        }
        querySpecification.setReturningResult();
        querySpecification.resolve(this.session, rangeGroupArray, typeArray);
        if (querySpecification.getColumnCount() != objectArray.length) {
            throw Error.error(5564, "INTO");
        }
        StatementSet statementSet = new StatementSet(this.session, (Expression[])objectArray, querySpecification, nArray, this.compileContext);
        return statementSet;
    }

    Statement compileGetStatement(RangeGroup[] rangeGroupArray) {
        int n;
        this.read();
        this.readThis(412);
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        LongDeque longDeque = new LongDeque();
        RangeVariable[] rangeVariableArray = rangeGroupArray[0].getRangeVariables();
        this.readGetClauseList(rangeVariableArray, orderedHashSet, longDeque, hsqlArrayList);
        if (hsqlArrayList.size() > 1) {
            throw Error.parseError(5602, null, this.scanner.getLineNumber());
        }
        Expression expression = (Expression)hsqlArrayList.get(0);
        if (expression.getDegree() != orderedHashSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] nArray = new int[longDeque.size()];
        longDeque.toArray(nArray);
        Object[] objectArray = new Expression[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            this.resolveOuterReferencesAndTypes(rangeGroupArray, (Expression)objectArray[n]);
        }
        this.resolveOuterReferencesAndTypes(rangeGroupArray, expression);
        for (n = 0; n < objectArray.length; ++n) {
            if (((Expression)objectArray[n]).getColumn().getParameterMode() == 1) {
                throw Error.parseError(2500, null, this.scanner.getLineNumber());
            }
            if (((Expression)objectArray[n]).getDataType().canBeAssignedFrom(expression.getNodeDataType(n))) continue;
            throw Error.parseError(5561, null, this.scanner.getLineNumber());
        }
        StatementSet statementSet = new StatementSet(this.session, (Expression[])objectArray, expression, nArray, this.compileContext);
        return statementSet;
    }

    StatementSet compileSetStatement(RangeGroup[] rangeGroupArray, RangeVariable[] rangeVariableArray) {
        int n;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        LongDeque longDeque = new LongDeque();
        this.readSetClauseList(rangeVariableArray, orderedHashSet, longDeque, hsqlArrayList);
        if (hsqlArrayList.size() > 1) {
            throw Error.parseError(5602, null, this.scanner.getLineNumber());
        }
        Expression expression = (Expression)hsqlArrayList.get(0);
        if (expression.getDegree() != orderedHashSet.size()) {
            throw Error.error(5546, "SET");
        }
        int[] nArray = new int[longDeque.size()];
        longDeque.toArray(nArray);
        Object[] objectArray = new Expression[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            this.resolveOuterReferencesAndTypes(rangeGroupArray, (Expression)objectArray[n]);
        }
        this.resolveOuterReferencesAndTypes(rangeGroupArray, expression);
        for (n = 0; n < objectArray.length; ++n) {
            ColumnSchema columnSchema = ((Expression)objectArray[n]).getColumn();
            if (columnSchema.getParameterMode() == 1) {
                throw Error.error(2500, columnSchema.getName().statementName);
            }
            if (((Expression)objectArray[n]).getDataType().canBeAssignedFrom(expression.getNodeDataType(n))) continue;
            throw Error.parseError(5561, null, this.scanner.getLineNumber());
        }
        StatementSet statementSet = new StatementSet(this.session, (Expression[])objectArray, expression, nArray, this.compileContext);
        return statementSet;
    }

    StatementDMQL compileTriggerSetStatement(Table table, RangeGroup[] rangeGroupArray) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        RangeVariable[] rangeVariableArray = new RangeVariable[]{rangeGroupArray[0].getRangeVariables()[1]};
        LongDeque longDeque = new LongDeque();
        this.readSetClauseList(rangeVariableArray, orderedHashSet, longDeque, hsqlArrayList);
        int[] nArray = new int[longDeque.size()];
        longDeque.toArray(nArray);
        Object[] objectArray = new Expression[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.resolveOuterReferencesAndTypes(RangeGroup.emptyArray, (Expression)objectArray[i]);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        this.resolveUpdateExpressions(table, RangeGroup.emptyGroup, nArray, expressionArray, rangeGroupArray);
        StatementSet statementSet = new StatementSet(this.session, (Expression[])objectArray, table, rangeGroupArray[0].getRangeVariables(), nArray, expressionArray, this.compileContext);
        return statementSet;
    }

    StatementSchema compileAlterSpecificRoutine() {
        Object[] objectArray;
        boolean bl = false;
        this.readThis(273);
        this.readThis(513);
        Routine routine = (Routine)this.readSchemaObjectName(24);
        routine = routine.duplicate();
        this.readRoutineCharacteristics(routine);
        bl = this.readIfThis(507);
        if (bl && !(objectArray = this.database.schemaManager.getReferencesTo(routine.getSpecificName())).isEmpty()) {
            throw Error.parseError(5502, null, this.scanner.getLineNumber());
        }
        if (this.token.tokenType == 590) {
            this.read();
        } else if (this.token.tokenType == 467) {
            this.read();
        }
        this.readRoutineBody(routine);
        routine.resetAlteredRoutineSettings();
        routine.resolve(this.session);
        objectArray = new Object[]{routine};
        String string = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema(string, 4, objectArray, null, this.database.schemaManager.getCatalogNameArray());
        return statementSchema;
    }

    StatementSchema compileCreateProcedureOrFunction(boolean bl) {
        Routine routine = this.readCreateProcedureOrFunction();
        Object[] objectArray = new Object[]{routine};
        String string = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema(string, 69, objectArray, null, this.database.schemaManager.getCatalogNameArray());
        return statementSchema;
    }

    Routine readCreateProcedureOrFunction() {
        Routine routine = this.readProcedureOrFunctionDeclaration();
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    Routine readProcedureOrFunctionDeclaration() {
        boolean bl = false;
        if (this.token.tokenType == 582) {
            bl = true;
            this.read();
            if (this.token.tokenType == 229) {
                throw this.unexpectedToken();
            }
        }
        int n = this.token.tokenType == 229 ? 17 : 16;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(n, true);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        Routine routine = new Routine(n);
        routine.setName(hsqlName);
        routine.setAggregate(bl);
        this.readRoutineArguments(routine);
        if (n != 17) {
            this.readThis(252);
            if (this.token.tokenType == 294) {
                this.read();
                TableDerived tableDerived = new TableDerived(this.database, SqlInvariants.MODULE_HSQLNAME, 11);
                this.readTableDefinition(routine, tableDerived);
                routine.setReturnTable(tableDerived);
            } else {
                Type type = this.readTypeDefinition(false, true);
                routine.setReturnType(type);
            }
        }
        this.readRoutineCharacteristics(routine);
        return routine;
    }

    void readRoutineArguments(Routine routine) {
        this.readThis(936);
        if (this.token.tokenType == 922) {
            this.read();
        } else {
            while (true) {
                ColumnSchema columnSchema = this.readRoutineParameter(routine, true);
                routine.addParameter(columnSchema);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            this.readThis(922);
        }
    }

    Routine readCreatePasswordCheckFunction() {
        Routine routine = new Routine(16);
        if (this.token.tokenType == 191) {
            this.read();
            return null;
        }
        if (this.token.tokenType == 112) {
            routine.setLanguage(1);
            routine.setDataImpact(1);
        } else {
            routine.setLanguage(2);
            routine.setDataImpact(2);
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName("PASSWORD", false, 16);
        hsqlName.setSchemaIfNull(SqlInvariants.SYSTEM_SCHEMA_HSQLNAME);
        routine.setName(hsqlName);
        hsqlName = this.database.nameManager.newHsqlName("PASSWORD", false, 23);
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, Type.SQL_VARCHAR, false, false, null);
        routine.addParameter(columnSchema);
        routine.setReturnType(Type.SQL_BOOLEAN);
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    Routine readCreateDatabaseAuthenticationFunction() {
        Routine routine = new Routine(16);
        if (this.token.tokenType == 191) {
            this.read();
            return null;
        }
        this.checkIsThis(112);
        routine.setLanguage(1);
        routine.setDataImpact(1);
        routine.setName(this.database.nameManager.newHsqlName("AUTHENTICATION", false, 16));
        for (int i = 0; i < 3; ++i) {
            ColumnSchema columnSchema = new ColumnSchema(null, Type.SQL_VARCHAR, false, false, null);
            routine.addParameter(columnSchema);
        }
        routine.setReturnType(new ArrayType(Type.SQL_VARCHAR_DEFAULT, 1024));
        this.readRoutineBody(routine);
        routine.resolve(this.session);
        return routine;
    }

    private void readTableDefinition(Routine routine, Table table) {
        this.readThis(936);
        int n = 0;
        while (true) {
            ColumnSchema columnSchema;
            if ((columnSchema = this.readRoutineParameter(routine, false)).getName() == null) {
                throw this.unexpectedToken();
            }
            table.addColumn(columnSchema);
            if (this.token.tokenType != 924) break;
            this.read();
            ++n;
        }
        this.readThis(922);
        table.createPrimaryKey();
    }

    private void readRoutineCharacteristics(Routine routine) {
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        boolean bl = false;
        block16: while (!bl) {
            switch (this.token.tokenType) {
                case 156: {
                    if (!orderedIntHashSet.add(156)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 447) {
                        this.read();
                        routine.setLanguage(1);
                        continue block16;
                    }
                    if (this.token.tokenType == 275) {
                        this.read();
                        routine.setLanguage(2);
                        continue block16;
                    }
                    throw this.unexpectedToken();
                }
                case 214: {
                    if (!orderedIntHashSet.add(214)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(541);
                    if (this.token.tokenType == 447) {
                        this.read();
                        routine.setParameterStyle(1);
                        continue block16;
                    }
                    this.readThis(275);
                    routine.setParameterStyle(2);
                    continue block16;
                }
                case 273: {
                    if (!orderedIntHashSet.add(273)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(24, false);
                    routine.setSpecificName(hsqlName);
                    continue block16;
                }
                case 88: {
                    if (!orderedIntHashSet.add(88)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    routine.setDeterministic(true);
                    continue block16;
                }
                case 193: {
                    if (!orderedIntHashSet.add(88)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(88);
                    routine.setDeterministic(false);
                    continue block16;
                }
                case 181: {
                    if (!orderedIntHashSet.add(275)) {
                        throw this.unexpectedToken();
                    }
                    if (routine.getType() == 16) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(275);
                    this.readThis(399);
                    routine.setDataImpact(4);
                    continue block16;
                }
                case 190: {
                    if (!orderedIntHashSet.add(275)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(275);
                    routine.setDataImpact(1);
                    continue block16;
                }
                case 232: {
                    if (!orderedIntHashSet.add(275)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(275);
                    this.readThis(399);
                    routine.setDataImpact(3);
                    continue block16;
                }
                case 52: {
                    if (!orderedIntHashSet.add(275)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(275);
                    routine.setDataImpact(2);
                    continue block16;
                }
                case 252: {
                    if (!orderedIntHashSet.add(196) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    if (routine.isAggregate()) {
                        throw Error.error(5604, this.token.tokenString);
                    }
                    this.read();
                    this.readThis(196);
                    this.readThis(204);
                    this.readThis(196);
                    this.readThis(441);
                    routine.setNullInputOutput(true);
                    continue block16;
                }
                case 29: {
                    if (!orderedIntHashSet.add(196) || routine.isProcedure()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(204);
                    this.readThis(196);
                    this.readThis(441);
                    routine.setNullInputOutput(false);
                    continue block16;
                }
                case 94: {
                    if (!orderedIntHashSet.add(250) || routine.isFunction()) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(250);
                    this.readThis(532);
                    int n = this.readInteger();
                    if (n < 0 || n > 16) {
                        throw Error.error(5604, String.valueOf(n));
                    }
                    routine.setMaxDynamicResults(n);
                    continue block16;
                }
                case 189: {
                    if (routine.getType() == 16 || !orderedIntHashSet.add(260)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(260);
                    this.readThis(454);
                    routine.setNewSavepointLevel(true);
                    continue block16;
                }
                case 203: {
                    if (routine.getType() == 16 || !orderedIntHashSet.add(260)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(260);
                    this.readThis(454);
                    routine.setNewSavepointLevel(false);
                    throw this.unsupportedFeature("OLD");
                }
            }
            bl = true;
        }
    }

    void readRoutineBody(Routine routine) {
        if (this.token.tokenType == 112) {
            this.readRoutineJavaBody(routine);
        } else {
            this.readRoutineSQLBody(routine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readRoutineSQLBody(Routine routine) {
        this.startRecording();
        this.session.sessionContext.pushRoutineTables();
        try {
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
            if (statement == null) {
                throw this.unexpectedToken();
            }
            Token[] tokenArray = this.getRecordedStatement();
            String string = Token.getSQL(tokenArray);
            statement.setSQL(string);
            routine.setProcedure(statement);
        }
        finally {
            this.session.sessionContext.popRoutineTables();
        }
    }

    void readRoutineJavaBody(Routine routine) {
        if (routine.getLanguage() != 1) {
            throw this.unexpectedToken();
        }
        this.read();
        this.readThis(467);
        this.checkIsQuotedString();
        routine.setMethodURL((String)this.token.tokenValue);
        this.read();
        if (this.token.tokenType == 214) {
            this.read();
            this.readThis(541);
            this.readThis(447);
        }
    }

    Object[] readLocalDeclarationList(Routine routine, StatementCompound statementCompound) {
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        int n = 0;
        RangeGroup[] rangeGroupArray = new RangeGroup[]{statementCompound == null ? routine : statementCompound};
        this.compileContext.setOuterRanges(rangeGroupArray);
        while (this.token.tokenType == 82) {
            object = null;
            if (n == 0) {
                object = this.readLocalTableVariableDeclarationOrNull(routine);
                if (object == null) {
                    n = 1;
                    continue;
                }
                hsqlArrayList.add(object);
                this.readThis(941);
                continue;
            }
            if (n == 1) {
                object = this.readLocalVariableDeclarationOrNull();
                if (object == null) {
                    n = 2;
                    continue;
                }
                hsqlArrayList.addAll((Object[])object);
                continue;
            }
            if (n == 2) {
                object = this.compileDeclareCursorOrNull(rangeGroupArray, true);
                if (object == null) {
                    n = 3;
                    continue;
                }
                hsqlArrayList.add(object);
                this.readThis(941);
                continue;
            }
            if (n != 3) continue;
            object = this.compileLocalHandlerDeclaration(routine, statementCompound);
            hsqlArrayList.add(object);
        }
        object = new Object[hsqlArrayList.size()];
        hsqlArrayList.toArray(object);
        return object;
    }

    Table readLocalTableVariableDeclarationOrNull(Routine routine) {
        int n = this.getPosition();
        this.readThis(82);
        if (this.token.tokenType == 294) {
            this.read();
            HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
            hsqlName.schema = SqlInvariants.MODULE_HSQLNAME;
            Table table = new Table(this.database, hsqlName, 3);
            table.persistenceScope = 20;
            this.readTableDefinition(routine, table);
            this.session.sessionContext.addSessionTable(table);
            return table;
        }
        this.rewind(n);
        return null;
    }

    ColumnSchema[] readLocalVariableDeclarationOrNull() {
        Type type;
        Object object;
        int n = this.getPosition();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        try {
            this.readThis(82);
            if (this.isReservedKey()) {
                this.rewind(n);
                return null;
            }
            while (true) {
                object = this.readNewSchemaObjectName(22, false);
                if (this.token.tokenType == 49) {
                    this.rewind(n);
                    return null;
                }
                hsqlArrayList.add(object);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            type = this.readTypeDefinition(false, true);
        }
        catch (HsqlException hsqlException) {
            this.rewind(n);
            return null;
        }
        object = null;
        if (this.token.tokenType == 83) {
            this.read();
            object = this.readDefaultClause(type);
        }
        ColumnSchema[] columnSchemaArray = new ColumnSchema[hsqlArrayList.size()];
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            columnSchemaArray[i] = new ColumnSchema((HsqlNameManager.HsqlName)hsqlArrayList.get(i), type, true, false, (Expression)object);
            columnSchemaArray[i].setParameterMode((byte)2);
        }
        this.readThis(941);
        return columnSchemaArray;
    }

    private StatementHandler compileLocalHandlerDeclaration(Routine routine, StatementCompound statementCompound) {
        int n;
        this.readThis(82);
        switch (this.token.tokenType) {
            case 397: {
                this.read();
                n = 5;
                break;
            }
            case 110: {
                this.read();
                n = 6;
                break;
            }
            case 313: {
                this.read();
                n = 7;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(134);
        this.readThis(120);
        StatementHandler statementHandler = new StatementHandler(n);
        boolean bl = false;
        boolean bl2 = true;
        block12: while (!bl) {
            int n2 = 0;
            switch (this.token.tokenType) {
                case 924: {
                    if (bl2) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl2 = true;
                    continue block12;
                }
                case 277: {
                    n2 = 4;
                }
                case 276: {
                    if (n2 == 0) {
                        n2 = 1;
                    }
                }
                case 278: {
                    if (n2 == 0) {
                        n2 = 2;
                    }
                }
                case 193: {
                    if (n2 == 0) {
                        n2 = 3;
                    }
                    if (!bl2) {
                        throw this.unexpectedToken();
                    }
                    bl2 = false;
                    this.read();
                    if (n2 == 3) {
                        this.readThis(426);
                    } else if (n2 == 4) {
                        String string = this.parseSQLStateValue();
                        statementHandler.addConditionState(string);
                        continue block12;
                    }
                    statementHandler.addConditionType(n2);
                    continue block12;
                }
            }
            if (bl2) {
                throw this.unexpectedToken();
            }
            bl = true;
        }
        if (this.token.tokenType == 941) {
            this.read();
        } else {
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, statementCompound);
            if (statement == null) {
                throw this.unexpectedToken();
            }
            this.readThis(941);
            statementHandler.addStatement(statement);
        }
        return statementHandler;
    }

    String parseSQLStateValue() {
        this.readIfThis(323);
        this.checkIsQuotedString();
        String string = this.token.tokenString;
        if (string.length() != 5) {
            throw Error.parseError(5607, null, this.scanner.getLineNumber());
        }
        this.read();
        return string;
    }

    String parseSQLFeatureValue() {
        if (!this.isUndelimitedSimpleName()) {
            throw Error.parseError(5555, this.token.tokenString, this.scanner.getLineNumber());
        }
        String string = this.token.tokenString;
        int n = ArrayUtil.find(featureStrings, string);
        if (n < 0) {
            throw Error.parseError(5555, this.token.tokenString, this.scanner.getLineNumber());
        }
        this.read();
        return string;
    }

    Statement compileCompoundStatement(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(18);
        this.readThis(15);
        hsqlName = this.createLabelIfNull(statementCompound, hsqlName);
        StatementCompound statementCompound2 = new StatementCompound(99, hsqlName, statementCompound);
        statementCompound2.setAtomic(true);
        statementCompound2.setRoot(routine);
        Object[] objectArray = this.readLocalDeclarationList(routine, statementCompound);
        statementCompound2.setLocalDeclarations(objectArray);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound2);
        statementCompound2.setStatements(statementArray);
        this.readThis(99);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        return statementCompound2;
    }

    HsqlNameManager.HsqlName createLabelIfNull(StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName != null) {
            return hsqlName;
        }
        StatementCompound statementCompound2 = statementCompound;
        int n = 0;
        while (statementCompound2 != null) {
            ++n;
            statementCompound2 = statementCompound2.parent;
        }
        String string = "_" + n;
        hsqlName = this.session.database.nameManager.newHsqlName(string, false, 21);
        return hsqlName;
    }

    Statement[] compileSQLProcedureStatementList(Routine routine, StatementCompound statementCompound) {
        Statement statement;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while ((statement = this.compileSQLProcedureStatementOrNull(routine, statementCompound)) != null) {
            this.readThis(941);
            hsqlArrayList.add(statement);
        }
        if (hsqlArrayList.size() == 0) {
            throw this.unexpectedToken();
        }
        Statement[] statementArray = new Statement[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementArray);
        return statementArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Statement compileSQLProcedureStatementOrNull(Routine routine, StatementCompound statementCompound) {
        Statement statement = null;
        HsqlNameManager.HsqlName hsqlName = null;
        RangeGroup rangeGroup = statementCompound == null ? routine : statementCompound;
        RangeGroup[] rangeGroupArray = new RangeGroup[]{rangeGroup};
        if (!routine.isTrigger() && this.isSimpleName() && !this.isReservedKey()) {
            hsqlName = this.readLabel();
        }
        this.compileContext.reset();
        HsqlNameManager.HsqlName hsqlName2 = this.session.getCurrentSchemaHsqlName();
        this.session.setCurrentSchemaHsqlName(routine.getSchemaName());
        try {
            switch (this.token.tokenType) {
                case 206: {
                    if (routine.dataImpact == 2) {
                        throw Error.error(5602, routine.getDataImpactString());
                    }
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileOpenCursorStatement(statementCompound);
                    break;
                }
                case 265: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileSelectSingleRowStatement(rangeGroupArray);
                    break;
                }
                case 145: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileInsertStatement(rangeGroupArray);
                    break;
                }
                case 319: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileUpdateStatement(rangeGroupArray);
                    break;
                }
                case 84: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileDeleteStatement(rangeGroupArray);
                    break;
                }
                case 311: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileTruncateStatement();
                    break;
                }
                case 176: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileMergeStatement(rangeGroupArray);
                    break;
                }
                case 268: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (routine.isTrigger()) {
                        if (routine.triggerType == 4 && routine.triggerOperation != 19) {
                            int n = this.getPosition();
                            try {
                                statement = this.compileTriggerSetStatement(routine.triggerTable, rangeGroupArray);
                                break;
                            }
                            catch (HsqlException hsqlException) {
                                this.rewind(n);
                                statement = this.compileSetStatement(rangeGroupArray, rangeGroup.getRangeVariables());
                            }
                        } else {
                            statement = this.compileSetStatement(rangeGroupArray, rangeGroup.getRangeVariables());
                        }
                        ((StatementSet)statement).checkIsNotColumnTarget();
                        break;
                    }
                    statement = this.compileSetStatement(rangeGroupArray, rangeGroup.getRangeVariables());
                    break;
                }
                case 128: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileGetStatement(rangeGroupArray);
                    break;
                }
                case 28: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileCallStatement(rangeGroupArray, true);
                    Routine routine2 = ((StatementProcedure)statement).procedure;
                    if (routine2 == null) break;
                    switch (routine.dataImpact) {
                        case 2: {
                            if (routine2.dataImpact != 3 && routine2.dataImpact != 4) break;
                            throw Error.error(5602, routine.getDataImpactString());
                        }
                        case 3: {
                            if (routine2.dataImpact != 4) break;
                            throw Error.error(5602, routine.getDataImpactString());
                        }
                    }
                    break;
                }
                case 251: {
                    if (routine.isTrigger() || hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    statement = this.compileReturnValue(routine, statementCompound);
                    break;
                }
                case 18: {
                    statement = this.compileCompoundStatement(routine, statementCompound, hsqlName);
                    break;
                }
                case 339: {
                    if (routine.isTrigger()) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileWhile(routine, statementCompound, hsqlName);
                    break;
                }
                case 248: {
                    statement = this.compileRepeat(routine, statementCompound, hsqlName);
                    break;
                }
                case 170: {
                    statement = this.compileLoop(routine, statementCompound, hsqlName);
                    break;
                }
                case 120: {
                    statement = this.compileFor(routine, statementCompound, hsqlName);
                    break;
                }
                case 153: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileIterate();
                    break;
                }
                case 162: {
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    statement = this.compileLeave(routine, statementCompound);
                    break;
                }
                case 434: {
                    statement = this.compileIf(routine, statementCompound);
                    break;
                }
                case 32: {
                    statement = this.compileCase(routine, statementCompound);
                    break;
                }
                case 269: {
                    statement = this.compileSignal(routine, statementCompound, hsqlName);
                    break;
                }
                case 249: {
                    statement = this.compileResignal(routine, statementCompound, hsqlName);
                    break;
                }
                default: {
                    Statement statement2 = null;
                    return statement2;
                }
            }
            statement.setRoot(routine);
            statement.setParent(statementCompound);
            Statement statement3 = statement;
            return statement3;
        }
        finally {
            this.session.setCurrentSchemaHsqlName(hsqlName2);
        }
    }

    HsqlNameManager.HsqlName readLabel() {
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(21, false);
        if (this.token.tokenType != 923) {
            throw this.unexpectedToken(hsqlName.getNameString());
        }
        this.readThis(923);
        return hsqlName;
    }

    Statement compileReturnValue(Routine routine, StatementCompound statementCompound) {
        RangeGroup[] rangeGroupArray = new RangeGroup[]{statementCompound == null ? routine : statementCompound};
        this.compileContext.setOuterRanges(rangeGroupArray);
        Expression expression = this.XreadValueExpressionOrNull();
        if (expression == null) {
            throw this.unexpectedToken();
        }
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        if (routine.isProcedure()) {
            throw Error.parseError(5602, null, this.scanner.getLineNumber());
        }
        if (routine.returnsTable() && expression.getType() != 23) {
            throw Error.parseError(5611, null, this.scanner.getLineNumber());
        }
        RowType rowType = new RowType(expression.getNodeDataTypes());
        Type type = routine.getReturnType();
        if (!type.isRowType()) {
            type = new RowType(new Type[]{routine.getReturnType()});
        }
        if (type.getDegree() != ((Type)rowType).getDegree()) {
            throw Error.parseError(5564, null, this.scanner.getLineNumber());
        }
        if (!type.canBeAssignedFrom(rowType)) {
            throw Error.parseError(5611, null, this.scanner.getLineNumber());
        }
        return new StatementExpression(this.session, this.compileContext, 62, expression);
    }

    Statement compileIterate() {
        this.readThis(153);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(103, hsqlName);
    }

    Statement compileLeave(Routine routine, StatementCompound statementCompound) {
        this.readThis(162);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(21, false);
        return new StatementSimple(104, hsqlName);
    }

    Statement compileWhile(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(339);
        Expression expression = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1211, expression);
        this.readThis(91);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(99);
        this.readThis(339);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(110, hsqlName, statementCompound);
        statementCompound2.setStatements(statementArray);
        statementCompound2.setCondition(statementExpression);
        return statementCompound2;
    }

    Statement compileRepeat(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(248);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(318);
        Expression expression = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1211, expression);
        this.readThis(99);
        this.readThis(248);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(107, hsqlName, statementCompound);
        statementCompound2.setStatements(statementArray);
        statementCompound2.setCondition(statementExpression);
        return statementCompound2;
    }

    Statement compileLoop(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        this.readThis(170);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        this.readThis(99);
        this.readThis(170);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        StatementCompound statementCompound2 = new StatementCompound(105, hsqlName, statementCompound);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    Statement compileFor(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        RangeGroup[] rangeGroupArray = new RangeGroup[]{statementCompound == null ? routine : statementCompound};
        this.compileContext.setOuterRanges(rangeGroupArray);
        this.readThis(120);
        StatementQuery statementQuery = this.compileCursorSpecification(rangeGroupArray, 0, false);
        this.readThis(91);
        StatementCompound statementCompound2 = new StatementCompound(101, hsqlName, statementCompound);
        statementCompound2.setAtomic(true);
        statementCompound2.setRoot(routine);
        statementCompound2.setLoopStatement(null, statementQuery);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound2);
        this.readThis(99);
        this.readThis(120);
        if (this.isSimpleName() && !this.isReservedKey()) {
            if (hsqlName == null) {
                throw this.unexpectedToken();
            }
            if (!hsqlName.name.equals(this.token.tokenString)) {
                throw Error.error(5508, this.token.tokenString);
            }
            this.read();
        }
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    Statement compileIf(Routine routine, StatementCompound statementCompound) {
        int n;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.readThis(434);
        Expression expression = this.XreadBooleanValueExpression();
        this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1211, expression);
        hsqlArrayList.add(statementExpression);
        this.readThis(296);
        Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
        for (n = 0; n < statementArray.length; ++n) {
            hsqlArrayList.add(statementArray[n]);
        }
        while (this.token.tokenType == 98) {
            this.read();
            expression = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
            statementExpression = new StatementExpression(this.session, this.compileContext, 1211, expression);
            hsqlArrayList.add(statementExpression);
            this.readThis(296);
            statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (n = 0; n < statementArray.length; ++n) {
                hsqlArrayList.add(statementArray[n]);
            }
        }
        if (this.token.tokenType == 97) {
            this.read();
            expression = Expression.EXPR_TRUE;
            statementExpression = new StatementExpression(this.session, this.compileContext, 1211, expression);
            hsqlArrayList.add(statementExpression);
            statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (n = 0; n < statementArray.length; ++n) {
                hsqlArrayList.add(statementArray[n]);
            }
        }
        this.readThis(99);
        this.readThis(434);
        statementArray = new Statement[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementArray);
        StatementCompound statementCompound2 = new StatementCompound(102, null, statementCompound);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    Statement compileCase(Routine routine, StatementCompound statementCompound) {
        Statement[] statementArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        this.readThis(32);
        hsqlArrayList = this.token.tokenType == 331 ? this.readCaseWhen(routine, statementCompound) : this.readSimpleCaseWhen(routine, statementCompound);
        if (this.token.tokenType == 97) {
            this.read();
            expression = Expression.EXPR_TRUE;
            StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1211, expression);
            hsqlArrayList.add(statementExpression);
            statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (int i = 0; i < statementArray.length; ++i) {
                hsqlArrayList.add(statementArray[i]);
            }
        }
        this.readThis(99);
        this.readThis(32);
        statementArray = new Statement[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementArray);
        StatementCompound statementCompound2 = new StatementCompound(102, null, statementCompound);
        statementCompound2.setStatements(statementArray);
        return statementCompound2;
    }

    HsqlArrayList readSimpleCaseWhen(Routine routine, StatementCompound statementCompound) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        Expression expression2 = this.XreadRowValuePredicand();
        do {
            this.readThis(331);
            while (true) {
                Expression expression3;
                if (expression2 == (expression3 = this.XreadPredicateRightPart(expression2))) {
                    expression3 = new ExpressionLogical(expression2, this.XreadRowValuePredicand());
                }
                this.resolveOuterReferencesAndTypes(routine, statementCompound, expression3);
                expression = expression == null ? expression3 : new ExpressionLogical(50, expression, expression3);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1211, expression);
            hsqlArrayList.add(statementExpression);
            this.readThis(296);
            Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (int i = 0; i < statementArray.length; ++i) {
                hsqlArrayList.add(statementArray[i]);
            }
        } while (this.token.tokenType == 331);
        return hsqlArrayList;
    }

    HsqlArrayList readCaseWhen(Routine routine, StatementCompound statementCompound) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Expression expression = null;
        do {
            this.readThis(331);
            expression = this.XreadBooleanValueExpression();
            this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
            StatementExpression statementExpression = new StatementExpression(this.session, this.compileContext, 1211, expression);
            hsqlArrayList.add(statementExpression);
            this.readThis(296);
            Statement[] statementArray = this.compileSQLProcedureStatementList(routine, statementCompound);
            for (int i = 0; i < statementArray.length; ++i) {
                hsqlArrayList.add(statementArray[i]);
            }
        } while (this.token.tokenType == 331);
        return hsqlArrayList;
    }

    Statement compileSignal(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        Expression expression = null;
        this.readThis(269);
        this.readThis(277);
        String string = this.parseSQLStateValue();
        if (this.readIfThis(268)) {
            this.readThis(463);
            this.readThis(417);
            expression = this.XreadSimpleValueSpecificationOrNull();
            if (expression == null) {
                throw this.unexpectedToken();
            }
            this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
        }
        StatementSignal statementSignal = new StatementSignal(108, string, expression);
        return statementSignal;
    }

    private Statement compileResignal(Routine routine, StatementCompound statementCompound, HsqlNameManager.HsqlName hsqlName) {
        String string = null;
        Expression expression = null;
        this.readThis(249);
        if (this.readIfThis(277)) {
            string = this.parseSQLStateValue();
            if (this.readIfThis(268)) {
                this.readThis(463);
                this.readThis(417);
                expression = this.XreadSimpleValueSpecificationOrNull();
                if (expression == null) {
                    throw this.unexpectedToken();
                }
                this.resolveOuterReferencesAndTypes(routine, statementCompound, expression);
            }
        }
        StatementSignal statementSignal = new StatementSignal(106, string, expression);
        return statementSignal;
    }

    ColumnSchema readRoutineParameter(Routine routine, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = null;
        int n = this.readRoutineParameterMode(routine.routineType, routine.isAggregate);
        if (!this.isReservedKey()) {
            hsqlName = this.readNewDependentSchemaObjectName(routine.getName(), 23);
        }
        Type type = this.readTypeDefinition(false, true);
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, true, false, null);
        if (bl) {
            columnSchema.setParameterMode((byte)n);
        }
        return columnSchema;
    }

    int readRoutineParameterMode(int n, boolean bl) {
        int n2 = 1;
        switch (this.token.tokenType) {
            case 140: {
                this.read();
                break;
            }
            case 209: {
                if (n != 17) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 4;
                break;
            }
            case 143: {
                if (n != 17 && !bl) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 2;
                break;
            }
        }
        return n2;
    }

    void resolveOuterReferencesAndTypes(Routine routine, StatementCompound statementCompound, Expression expression) {
        RangeGroup rangeGroup = statementCompound == null ? routine : statementCompound;
        this.resolveOuterReferencesAndTypes(new RangeGroup[]{rangeGroup}, expression);
    }

    StatementSchema compileCreateTrigger(boolean bl) {
        HsqlNameManager.HsqlName[] hsqlNameArray;
        Object[] objectArray;
        Object object;
        int n;
        int n2;
        Boolean bl2 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        HsqlNameManager.HsqlName hsqlName = null;
        OrderedHashSet orderedHashSet = null;
        int[] nArray = null;
        this.read();
        Boolean bl5 = this.readIfNotExists();
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(8, true);
        switch (this.token.tokenType) {
            case 444: {
                n2 = TriggerDef.getTiming(444);
                this.read();
                this.readThis(201);
                break;
            }
            case 357: 
            case 364: {
                n2 = TriggerDef.getTiming(this.token.tokenType);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (this.token.tokenType) {
            case 84: 
            case 145: {
                n = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                break;
            }
            case 319: {
                n = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                if (this.token.tokenType != 201 || n2 == 6) break;
                this.read();
                orderedHashSet = new OrderedHashSet();
                this.readColumnNameList(orderedHashSet, null, false);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(204);
        Table table = this.readTableName();
        if (this.token.tokenType == 364) {
            this.read();
            this.checkIsSimpleName();
            hsqlName = this.readNewSchemaObjectName(8, true);
        }
        hsqlName2.setSchemaIfNull(table.getSchemaName());
        this.checkSchemaUpdateAuthorisation(hsqlName2.schema);
        if (n2 == 6 ? !table.isView() || ((View)table).getCheckOption() == 2 : table.isView()) {
            throw Error.error(5538, hsqlName2.schema.name);
        }
        if (hsqlName2.schema != table.getSchemaName()) {
            throw Error.error(5505, hsqlName2.schema.name);
        }
        hsqlName2.parent = table.getName();
        this.database.schemaManager.checkSchemaObjectNotExists(hsqlName2);
        if (orderedHashSet != null) {
            nArray = table.getColumnIndexes(orderedHashSet);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != -1) continue;
                throw Error.error(5544, (String)orderedHashSet.get(i));
            }
        }
        Expression expression = null;
        HsqlNameManager.SimpleName simpleName = null;
        HsqlNameManager.SimpleName simpleName2 = null;
        HsqlNameManager.SimpleName simpleName3 = null;
        HsqlNameManager.SimpleName simpleName4 = null;
        Table[] tableArray = new Table[4];
        RangeVariable[] rangeVariableArray = new RangeVariable[4];
        String string = null;
        RangeGroup[] rangeGroupArray = new RangeGroup[]{new RangeGroup.RangeGroupSimple(rangeVariableArray, false)};
        if (this.token.tokenType == 237) {
            this.read();
            if (this.token.tokenType != 203 && this.token.tokenType != 189) {
                throw this.unexpectedToken();
            }
            while (true) {
                HsqlNameManager.SimpleName simpleName5;
                if (this.token.tokenType == 203) {
                    if (n == 55) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 294) {
                        if (Boolean.TRUE.equals(bl2) || simpleName != null || n2 == 4) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readIfThis(11);
                        this.checkIsSimpleName();
                        this.read();
                        simpleName5 = simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                        if (simpleName5.equals(simpleName2) || simpleName5.equals(simpleName3) || simpleName5.equals(simpleName4)) {
                            throw this.unexpectedToken();
                        }
                        bl2 = Boolean.FALSE;
                        object = this.database.nameManager.newHsqlName(table.getSchemaName(), simpleName5.name, this.isDelimitedIdentifier(), 10);
                        objectArray = new Table(table, (HsqlNameManager.HsqlName)object);
                        hsqlNameArray = new RangeVariable((Table)objectArray, null, null, null, this.compileContext);
                        tableArray[2] = objectArray;
                        rangeVariableArray[2] = hsqlNameArray;
                        continue;
                    }
                    if (Boolean.FALSE.equals(bl2) || simpleName3 != null) {
                        throw this.unexpectedToken();
                    }
                    this.readIfThis(257);
                    this.readIfThis(11);
                    this.checkIsSimpleName();
                    simpleName3 = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    simpleName5 = simpleName3;
                    if (simpleName5.equals(simpleName2) || simpleName5.equals(simpleName) || simpleName5.equals(simpleName4)) {
                        throw this.unexpectedToken();
                    }
                    bl2 = Boolean.TRUE;
                    object = new RangeVariable(table.columnList, simpleName3, false, 2);
                    ((RangeVariable)object).rangePosition = 0;
                    tableArray[0] = null;
                    rangeVariableArray[0] = object;
                    continue;
                }
                if (this.token.tokenType != 189) break;
                if (n == 19) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 294) {
                    if (Boolean.TRUE.equals(bl2) || simpleName2 != null || n2 == 4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readIfThis(11);
                    this.checkIsSimpleName();
                    simpleName2 = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                    this.read();
                    bl2 = Boolean.FALSE;
                    simpleName5 = simpleName2;
                    if (simpleName5.equals(simpleName) || simpleName5.equals(simpleName3) || simpleName5.equals(simpleName4)) {
                        throw this.unexpectedToken();
                    }
                    object = this.database.nameManager.newHsqlName(table.getSchemaName(), simpleName5.name, this.isDelimitedIdentifier(), 10);
                    objectArray = new Table(table, (HsqlNameManager.HsqlName)object);
                    hsqlNameArray = new RangeVariable((Table)objectArray, null, null, null, this.compileContext);
                    tableArray[3] = objectArray;
                    rangeVariableArray[3] = hsqlNameArray;
                    continue;
                }
                if (Boolean.FALSE.equals(bl2) || simpleName4 != null) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(257);
                this.readIfThis(11);
                this.checkIsSimpleName();
                simpleName4 = HsqlNameManager.getSimpleName(this.token.tokenString, this.token.isDelimitedIdentifier);
                this.read();
                simpleName5 = simpleName4;
                if (simpleName5.equals(simpleName) || simpleName5.equals(simpleName2) || simpleName5.equals(simpleName3)) {
                    throw this.unexpectedToken();
                }
                bl2 = Boolean.TRUE;
                object = new RangeVariable(table.columnList, simpleName4, false, 2);
                ((RangeVariable)object).rangePosition = 1;
                tableArray[1] = null;
                rangeVariableArray[1] = object;
            }
        }
        if (Boolean.TRUE.equals(bl2) && this.token.tokenType != 120) {
            throw this.unexpectedTokenRequire("FOR");
        }
        if (this.token.tokenType == 120) {
            this.read();
            this.readThis(95);
            if (this.token.tokenType == 257) {
                if (Boolean.FALSE.equals(bl2)) {
                    throw this.unexpectedToken();
                }
                bl2 = Boolean.TRUE;
            } else if (this.token.tokenType == 539) {
                if (Boolean.TRUE.equals(bl2) || n2 == 4) {
                    throw this.unexpectedToken();
                }
                bl2 = Boolean.FALSE;
            } else {
                throw this.unexpectedToken();
            }
            this.read();
        }
        if (rangeVariableArray[2] != null) {
            // empty if block
        }
        if (rangeVariableArray[3] != null) {
            // empty if block
        }
        if ("QUEUE".equals(this.token.tokenString)) {
            this.read();
            n3 = this.readInteger();
            bl4 = true;
        }
        if ("NOWAIT".equals(this.token.tokenString)) {
            this.read();
            bl3 = true;
        }
        if (this.token.tokenType == 331 && n2 != 6) {
            this.read();
            this.readThis(936);
            int n4 = this.getPosition();
            this.isCheckOrTriggerCondition = true;
            expression = this.XreadBooleanValueExpression();
            string = this.getLastPart(n4);
            this.isCheckOrTriggerCondition = false;
            this.readThis(922);
            object = expression.resolveColumnReferences(this.session, rangeGroupArray[0], rangeGroupArray, null);
            ExpressionColumn.checkColumnsResolved((HsqlList)object);
            expression.resolveTypes(this.session, null);
            if (expression.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        if (this.token.tokenType == 28) {
            int n5 = this.getPosition();
            try {
                this.read();
                this.checkIsSimpleName();
                this.checkIsDelimitedIdentifier();
                String string2 = this.token.tokenString;
                this.read();
                if (this.token.tokenType == 936) {
                    throw this.unexpectedToken();
                }
                TriggerDef triggerDef = new TriggerDef(hsqlName2, n2, n, bl2, table, tableArray, rangeVariableArray, expression, string, nArray, string2, bl3, n3);
                object = this.getLastPart();
                objectArray = new Object[]{triggerDef, hsqlName, bl5};
                hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
                return new StatementSchema((String)object, 90, objectArray, null, hsqlNameArray);
            }
            catch (HsqlException hsqlException) {
                this.rewind(n5);
            }
        }
        if (bl4) {
            throw this.unexpectedToken("QUEUE");
        }
        if (bl3) {
            throw this.unexpectedToken("NOWAIT");
        }
        Routine routine = this.compileTriggerRoutine(table, rangeVariableArray, n2, n);
        TriggerDefSQL triggerDefSQL = new TriggerDefSQL(hsqlName2, n2, n, bl2, table, tableArray, rangeVariableArray, expression, string, nArray, routine);
        object = this.getLastPart();
        objectArray = new Object[]{triggerDefSQL, hsqlName, bl5};
        return new StatementSchema((String)object, 90, objectArray, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Routine compileTriggerRoutine(Table table, RangeVariable[] rangeVariableArray, int n, int n2) {
        int n3 = n == 4 ? 3 : 4;
        Routine routine = new Routine(table, rangeVariableArray, n3, n, n2);
        this.session.sessionContext.pushRoutineTables();
        try {
            this.startRecording();
            StatementCompound statementCompound = new StatementCompound(99, null, null);
            statementCompound.rangeVariables = rangeVariableArray;
            Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
            if (statement == null) {
                throw this.unexpectedToken();
            }
            Token[] tokenArray = this.getRecordedStatement();
            String string = Token.getSQL(tokenArray);
            statement.setSQL(string);
            routine.setProcedure(statement);
            routine.resolve(this.session);
        }
        finally {
            this.session.sessionContext.popRoutineTables();
        }
        return routine;
    }

    void checkSchemaUpdateAuthorisation(HsqlNameManager.HsqlName hsqlName) {
        if (this.session.isProcessingLog()) {
            return;
        }
        SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
        if (this.isSchemaDefinition) {
            if (hsqlName != this.session.getCurrentSchemaHsqlName()) {
                throw Error.error(5505);
            }
        } else {
            this.session.getGrantee().checkSchemaUpdateOrGrantRights(hsqlName.name);
        }
        this.session.checkDDLWrite();
    }
}

