/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.tools.dotc.profile.ChromeTrace$ArrayContext$;
import dotty.tools.dotc.profile.ChromeTrace$ObjectContext$;
import dotty.tools.dotc.profile.ChromeTrace$TopContext$;
import dotty.tools.dotc.profile.ChromeTrace$ValueContext$;
import dotty.tools.dotc.profile.FileUtils;
import dotty.tools.dotc.profile.FileUtils$;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ChromeTrace
implements Closeable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ChromeTrace.class.getDeclaredField("TopContext$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ChromeTrace.class.getDeclaredField("ValueContext$lzy1"));
    private final FileUtils.LineWriter traceWriter;
    private final Stack<JsonContext> context;
    private final ThreadLocal<String> tidCache;
    private final String pid;
    public final ChromeTrace$ArrayContext$ ArrayContext$lzy1 = new ChromeTrace$ArrayContext$(this);
    public final ChromeTrace$ObjectContext$ ObjectContext$lzy1 = new ChromeTrace$ObjectContext$(this);
    private volatile Object ValueContext$lzy1;
    private volatile Object TopContext$lzy1;

    public ChromeTrace(Path f) {
        this.traceWriter = FileUtils$.MODULE$.newAsyncBufferedWriter(f, FileUtils$.MODULE$.newAsyncBufferedWriter$default$2(), FileUtils$.MODULE$.newAsyncBufferedWriter$default$3(), FileUtils$.MODULE$.newAsyncBufferedWriter$default$4());
        this.context = (Stack)Stack$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonContext[]{this.TopContext()}));
        this.tidCache = new ThreadLocal<String>(){

            public String initialValue() {
                return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%05d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Thread.currentThread().getId())}));
            }
        };
        this.objStart();
        this.fld("traceEvents");
        this.context.push((Object)this.ValueContext());
        this.arrStart();
        this.traceWriter.newLine();
        this.pid = ManagementFactory.getRuntimeMXBean().getName().replaceAll("@.*", "");
    }

    @Override
    public void close() {
        this.arrEnd();
        this.objEnd();
        this.context.pop();
        this.tidCache.remove();
        this.traceWriter.close();
    }

    public void traceDurationEvent(String name, long startNanos, long durationNanos, String tid, String pidSuffix) {
        long durationMicros = this.nanosToMicros(durationNanos);
        long startMicros = this.nanosToMicros(startNanos);
        this.objStart();
        this.str("cat", "scalac");
        this.str("name", name);
        this.str("ph", "X");
        this.str("tid", tid);
        this.writePid(pidSuffix);
        this.lng("ts", startMicros);
        this.lng("dur", durationMicros);
        this.objEnd();
        this.traceWriter.newLine();
    }

    public String traceDurationEvent$default$4() {
        return this.tid();
    }

    public String traceDurationEvent$default$5() {
        return "";
    }

    private void writePid(String pidSuffix) {
        String string = pidSuffix;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.str("pid", this.pid);
            return;
        }
        this.str2("pid", this.pid, "-", pidSuffix);
    }

    public void traceCounterEvent(String name, String counterName, long count, boolean processWide) {
        this.objStart();
        this.str("cat", "scalac");
        this.str("name", name);
        this.str("ph", "C");
        this.str("tid", this.tid());
        this.writePid(processWide ? "" : this.tid());
        this.lng("ts", this.microTime());
        this.fld("args");
        this.objStart();
        this.lng(counterName, count);
        this.objEnd();
        this.objEnd();
        this.traceWriter.newLine();
    }

    public void traceDurationEventStart(String cat, String name, String colour, String pidSuffix) {
        this.traceDurationEventStartEnd("B", cat, name, colour, pidSuffix);
    }

    public String traceDurationEventStart$default$3() {
        return "";
    }

    public String traceDurationEventStart$default$4() {
        return this.tid();
    }

    public void traceDurationEventEnd(String cat, String name, String colour, String pidSuffix) {
        this.traceDurationEventStartEnd("E", cat, name, colour, pidSuffix);
    }

    public String traceDurationEventEnd$default$3() {
        return "";
    }

    public String traceDurationEventEnd$default$4() {
        return this.tid();
    }

    private void traceDurationEventStartEnd(String eventType, String cat, String name, String colour, String pidSuffix) {
        this.objStart();
        this.str("cat", cat);
        this.str("name", name);
        this.str("ph", eventType);
        this.writePid(pidSuffix);
        this.str("tid", this.tid());
        this.lng("ts", this.microTime());
        String string = colour;
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.str("cname", colour);
        }
        this.objEnd();
        this.traceWriter.newLine();
    }

    private String traceDurationEventStartEnd$default$5() {
        return "";
    }

    private String tid() {
        return this.tidCache.get();
    }

    private long nanosToMicros(long t) {
        return TimeUnit.NANOSECONDS.toMicros(t);
    }

    private long microTime() {
        return this.nanosToMicros(System.nanoTime());
    }

    private final ChromeTrace$ArrayContext$ ArrayContext() {
        return this.ArrayContext$lzy1;
    }

    private final ChromeTrace$ObjectContext$ ObjectContext() {
        return this.ObjectContext$lzy1;
    }

    private final ChromeTrace$ValueContext$ ValueContext() {
        Object object = this.ValueContext$lzy1;
        if (object instanceof ChromeTrace$ValueContext$) {
            return (ChromeTrace$ValueContext$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ChromeTrace$ValueContext$)this.ValueContext$lzyINIT1();
    }

    private Object ValueContext$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ValueContext$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ChromeTrace$ValueContext$ chromeTrace$ValueContext$ = null;
                    try {
                        chromeTrace$ValueContext$ = new ChromeTrace$ValueContext$(this);
                        object2 = chromeTrace$ValueContext$ == null ? LazyVals.NullValue$.MODULE$ : chromeTrace$ValueContext$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ValueContext$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return chromeTrace$ValueContext$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final ChromeTrace$TopContext$ TopContext() {
        Object object = this.TopContext$lzy1;
        if (object instanceof ChromeTrace$TopContext$) {
            return (ChromeTrace$TopContext$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ChromeTrace$TopContext$)this.TopContext$lzyINIT1();
    }

    private Object TopContext$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.TopContext$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ChromeTrace$TopContext$ chromeTrace$TopContext$ = null;
                    try {
                        chromeTrace$TopContext$ = new ChromeTrace$TopContext$(this);
                        object2 = chromeTrace$TopContext$ == null ? LazyVals.NullValue$.MODULE$ : chromeTrace$TopContext$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.TopContext$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return chromeTrace$TopContext$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private void str(String name, String value) {
        this.fld(name);
        this.traceWriter.write("\"");
        this.traceWriter.write(value);
        this.traceWriter.write("\"");
    }

    private void str2(String name, String value, String valueContinued1, String valueContinued2) {
        this.fld(name);
        this.traceWriter.write("\"");
        this.traceWriter.write(value);
        this.traceWriter.write(valueContinued1);
        this.traceWriter.write(valueContinued2);
        this.traceWriter.write("\"");
    }

    private void lng(String name, long value) {
        this.fld(name);
        this.traceWriter.write(String.valueOf(value));
        this.traceWriter.write("");
    }

    private void objStart() {
        JsonContext jsonContext = (JsonContext)this.context.top();
        if (jsonContext instanceof ArrayContext && ((ArrayContext)jsonContext).dotty$tools$dotc$profile$ChromeTrace$ArrayContext$$$outer() == this) {
            boolean bl;
            ArrayContext arrayContext = (ArrayContext)jsonContext;
            ArrayContext arrayContext2 = this.ArrayContext().unapply(arrayContext);
            boolean first = bl = arrayContext2._1();
            ArrayContext ac = arrayContext;
            if (first) {
                ac.first_$eq(false);
            } else {
                this.traceWriter.write(",");
            }
        }
        this.context.push((Object)this.ObjectContext().apply(true));
        this.traceWriter.write("{");
    }

    private void objEnd() {
        this.traceWriter.write("}");
        this.context.pop();
    }

    private void arrStart() {
        this.traceWriter.write("[");
        this.context.push((Object)this.ArrayContext().apply(true));
    }

    private void arrEnd() {
        this.traceWriter.write("]");
        this.context.pop();
    }

    private void fld(String name) {
        JsonContext topContext = (JsonContext)this.context.top();
        JsonContext jsonContext = topContext;
        if (jsonContext instanceof ObjectContext && ((ObjectContext)jsonContext).dotty$tools$dotc$profile$ChromeTrace$ObjectContext$$$outer() == this) {
            boolean bl;
            ObjectContext objectContext = (ObjectContext)jsonContext;
            ObjectContext objectContext2 = this.ObjectContext().unapply(objectContext);
            boolean first = bl = objectContext2._1();
            ObjectContext oc = objectContext;
            if (first) {
                oc.first_$eq(false);
            } else {
                this.traceWriter.write(",");
            }
        } else {
            JsonContext context = jsonContext;
            throw new IllegalStateException(new StringBuilder(15).append("Wrong context: ").append(context).toString());
        }
        this.traceWriter.write("\"");
        this.traceWriter.write(name);
        this.traceWriter.write("\"");
        this.traceWriter.write(":");
    }

    public class ArrayContext
    extends JsonContext
    implements Product,
    Serializable {
        private boolean first;
        private final /* synthetic */ ChromeTrace $outer;

        public ArrayContext(ChromeTrace $outer, boolean first) {
            this.first = first;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.first() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ArrayContext)) return false;
            if (((ArrayContext)object).dotty$tools$dotc$profile$ChromeTrace$ArrayContext$$$outer() != this.$outer) return false;
            ArrayContext arrayContext = (ArrayContext)object;
            if (this.first() != arrayContext.first()) return false;
            if (!arrayContext.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ArrayContext;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ArrayContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "first";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean first() {
            return this.first;
        }

        public void first_$eq(boolean x$1) {
            this.first = x$1;
        }

        public ArrayContext copy(boolean first) {
            return new ArrayContext(this.$outer, first);
        }

        public boolean copy$default$1() {
            return this.first();
        }

        public boolean _1() {
            return this.first();
        }

        public final /* synthetic */ ChromeTrace dotty$tools$dotc$profile$ChromeTrace$ArrayContext$$$outer() {
            return this.$outer;
        }
    }

    public abstract class JsonContext {
    }

    public class ObjectContext
    extends JsonContext
    implements Product,
    Serializable {
        private boolean first;
        private final /* synthetic */ ChromeTrace $outer;

        public ObjectContext(ChromeTrace $outer, boolean first) {
            this.first = first;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.first() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ObjectContext)) return false;
            if (((ObjectContext)object).dotty$tools$dotc$profile$ChromeTrace$ObjectContext$$$outer() != this.$outer) return false;
            ObjectContext objectContext = (ObjectContext)object;
            if (this.first() != objectContext.first()) return false;
            if (!objectContext.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ObjectContext;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ObjectContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "first";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean first() {
            return this.first;
        }

        public void first_$eq(boolean x$1) {
            this.first = x$1;
        }

        public ObjectContext copy(boolean first) {
            return new ObjectContext(this.$outer, first);
        }

        public boolean copy$default$1() {
            return this.first();
        }

        public boolean _1() {
            return this.first();
        }

        public final /* synthetic */ ChromeTrace dotty$tools$dotc$profile$ChromeTrace$ObjectContext$$$outer() {
            return this.$outer;
        }
    }
}

