/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mondrianinput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mondrianinput.MondrianData;
import org.pentaho.di.trans.steps.mondrianinput.MondrianHelper;
import org.pentaho.di.trans.steps.mondrianinput.MondrianInput;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MondrianInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String sql;
    private String catalog;
    private boolean variableReplacementActive;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public boolean isVariableReplacementActive() {
        return this.variableReplacementActive;
    }

    public void setVariableReplacementActive(boolean variableReplacementActive) {
        this.variableReplacementActive = variableReplacementActive;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        MondrianInputMeta retval = (MondrianInputMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            this.sql = XMLHandler.getTagValue((Node)stepnode, (String)"sql");
            this.catalog = XMLHandler.getTagValue((Node)stepnode, (String)"catalog");
            this.variableReplacementActive = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"variables_active"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.sql = "select\n {([Gender].[F], [Measures].[Unit Sales]),\n  ([Gender].[M], [Measures].[Store Sales]),\n  ([Gender].[F], [Measures].[Unit Sales])} on columns,\n CrossJoin([Marital Status].Members,\n           [Product].Children) on rows\nfrom [Sales]";
        this.variableReplacementActive = false;
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (this.databaseMeta == null) {
            return;
        }
        RowMetaInterface add = null;
        try {
            MondrianHelper helper = new MondrianHelper(this.databaseMeta, this.catalog, this.sql, space);
            add = helper.getCachedRowMeta();
            if (add == null) {
                helper.openQuery();
                helper.createRectangularOutput();
                add = helper.getOutputRowMeta();
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleStepException("Unable to get query result for MDX query: " + Const.CR + this.sql, (Throwable)dbe);
        }
        for (int i = 0; i < add.size(); ++i) {
            ValueMetaInterface v = add.getValueMeta(i);
            v.setOrigin(origin);
        }
        row.addRowMeta(add);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    " + XMLHandler.addTagValue((String)"catalog", (String)this.catalog));
        retval.append("    " + XMLHandler.addTagValue((String)"variables_active", (boolean)this.variableReplacementActive));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (long)id_connection);
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.catalog = rep.getStepAttributeString(id_step, "catalog");
            this.variableReplacementActive = rep.getStepAttributeBoolean(id_step, "variables_active");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.catalog);
            rep.saveStepAttribute(id_transformation, id_step, "variables_active", this.variableReplacementActive);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (this.databaseMeta != null) {
            CheckResult cr = new CheckResult(1, "Connection exists", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, "Please select or create a connection to use", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new MondrianInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MondrianData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) throws KettleStepException {
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject;
            if (Const.isEmpty((String)this.catalog) && (fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.catalog))).exists()) {
                this.catalog = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
                return this.catalog;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

