/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Autoload;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Load;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Primitives;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class AutoloadGeneralizedReference
extends Autoload {
    Symbol indicator;
    static final Symbol SETF_EXPANDER = Lisp.PACKAGE_SYS.intern("SETF-EXPANDER");
    public static final Primitive AUTOLOAD_SETF_EXPANDER = new pf_autoload_setf_expander();
    static final Symbol SETF_FUNCTION = Lisp.PACKAGE_SYS.intern("SETF-FUNCTION");
    public static final Primitive AUTOLOAD_SETF_FUNCTION = new pf_autoload_setf_function();
    public static final Primitive AUTOLOAD_REF_P = new pf_autoload_ref_p();

    private AutoloadGeneralizedReference(Symbol symbol, Symbol indicator, String filename) {
        super(symbol, filename, null);
        this.indicator = indicator;
    }

    @Override
    public void load() {
        Load.loadSystemFile(this.getFileName(), true);
    }

    private static final LispObject installAutoloadGeneralizedReference(LispObject first, Symbol indicator, String filename) {
        if (first instanceof Symbol) {
            Symbol symbol = Lisp.checkSymbol(first);
            AutoloadGeneralizedReference.install(symbol, indicator, filename);
            return Lisp.T;
        }
        if (first instanceof Cons) {
            for (LispObject list = first; list != Lisp.NIL; list = list.cdr()) {
                Symbol symbol = Lisp.checkSymbol(list.car());
                AutoloadGeneralizedReference.install(symbol, indicator, filename);
            }
            return Lisp.T;
        }
        return Lisp.error(new TypeError(first));
    }

    private static LispObject install(Symbol symbol, Symbol indicator, String filename) {
        if (Lisp.get(symbol, indicator) == Lisp.NIL) {
            return Primitives.PUT.execute(symbol, indicator, new AutoloadGeneralizedReference(symbol, indicator, filename));
        }
        return Lisp.NIL;
    }

    @Override
    public LispObject execute() {
        this.load();
        return Lisp.get(this.symbol, this.indicator, null).execute();
    }

    @Override
    public LispObject execute(LispObject arg) {
        this.load();
        return Lisp.get(this.symbol, this.indicator, null).execute(arg);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second) {
        this.load();
        return Lisp.get(this.symbol, this.indicator, null).execute(first, second);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        this.load();
        return Lisp.get(this.symbol, this.indicator, null).execute(first, second, third);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        this.load();
        return Lisp.get(this.symbol, this.indicator, null).execute(first, second, third, fourth);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        this.load();
        return Lisp.get(this.symbol, this.indicator, null).execute(first, second, third, fourth, fifth);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        this.load();
        return Lisp.get(this.symbol, this.indicator, null).execute(first, second, third, fourth, fifth, sixth);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        this.load();
        return this.symbol.execute(first, second, third, fourth, fifth, sixth, seventh);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        this.load();
        return Lisp.get(this.symbol, this.indicator, null).execute(first, second, third, fourth, fifth, sixth, seventh, eighth);
    }

    @Override
    public LispObject execute(LispObject[] args) {
        this.load();
        return Lisp.get(this.symbol, this.indicator, null).execute(args);
    }

    @DocString(name="autoload-ref-p", args="symbol", doc="Boolean predicate for whether SYMBOL has generalized reference functions which need to be resolved.")
    private static final class pf_autoload_ref_p
    extends Primitive {
        pf_autoload_ref_p() {
            super("autoload-ref-p", Lisp.PACKAGE_EXT, true, "symbol");
        }

        @Override
        public LispObject execute(LispObject arg) {
            for (LispObject list = Lisp.checkSymbol(arg).getPropertyList(); list != Lisp.NIL; list = list.cdr()) {
                if (!(list.car() instanceof AutoloadGeneralizedReference)) continue;
                return Lisp.T;
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="autoload-setf-function", args="symbol-or-symbols filename", doc="Setup the autoload for SYMBOL-OR-SYMBOLS on the setf-function from FILENAME.")
    private static final class pf_autoload_setf_function
    extends Primitive {
        pf_autoload_setf_function() {
            super("autoload-setf-function", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            String filename = second.getStringValue();
            return AutoloadGeneralizedReference.installAutoloadGeneralizedReference(first, SETF_FUNCTION, filename);
        }
    }

    @DocString(name="autoload-setf-expander", args="symbol-or-symbols filename", doc="Setup the autoload for SYMBOL-OR-SYMBOLS on the setf-expander from FILENAME.")
    private static final class pf_autoload_setf_expander
    extends Primitive {
        pf_autoload_setf_expander() {
            super("autoload-setf-expander", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            String filename = second.getStringValue();
            return AutoloadGeneralizedReference.installAutoloadGeneralizedReference(first, SETF_EXPANDER, filename);
        }
    }
}

