/*	$NetBSD: linux_socket_generic.h,v 1.1 2014/01/25 13:49:27 njoly Exp $	*/

#ifndef _LINUX_SOCKET_GENERIC_H
#define _LINUX_SOCKET_GENERIC_H

/*-
 * Copyright (c) 2014 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* From <asm-generic/socket.h> */

#define LINUX_SOL_SOCKET	1

#define LINUX_SO_DEBUG		1
#define LINUX_SO_REUSEADDR	2
#define LINUX_SO_TYPE		3
#define LINUX_SO_ERROR		4
#define LINUX_SO_DONTROUTE	5
#define LINUX_SO_BROADCAST	6
#define LINUX_SO_SNDBUF		7
#define LINUX_SO_RCVBUF		8
#define LINUX_SO_KEEPALIVE	9
#define LINUX_SO_OOBINLINE	10
#define LINUX_SO_NO_CHECK	11
#define LINUX_SO_PRIORITY	12
#define LINUX_SO_LINGER		13
#define LINUX_SO_BSDCOMPAT	14
/* #define LINUX_SO_REUSEPORT 15 */
#define LINUX_SO_PASSCRED	16
#define LINUX_SO_PEERCRED	17
#define LINUX_SO_RCVLOWAT	18
#define LINUX_SO_SNDLOWAT	19
#define LINUX_SO_RCVTIMEO	20
#define LINUX_SO_SNDTIMEO	21
#define LINUX_SO_SECURITY_AUTHENTICATION	22
#define LINUX_SO_SECURITY_ENCRYPTION_TRANSPORT	23
#define LINUX_SO_SECURITY_ENCRYPTION_NETWORK	24
#define LINUX_SO_BINDTODEVICE	25
#define LINUX_SO_ATTACH_FILTER	26
#define LINUX_SO_DETACH_FILTER	27
#define LINUX_SO_GET_FILTER	LINUX_SO_ATTACH_FILTER
#define LINUX_SO_PEERNAME	28
#define LINUX_SO_TIMESTAMP	29
#define LINUX_SO_ACCEPTCONN	30
#define LINUX_SO_PEERSEC	31
#define LINUX_SO_SNDBUFFORCE	32
#define LINUX_SO_RCVBUFFORCE	33
#define LINUX_SO_PASSSEC	34
#define LINUX_SO_TIMESTAMPNS	35
#define LINUX_SO_MARK		36
#define LINUX_SO_TIMESTAMPING	37
#define LINUX_SO_PROTOCOL	38
#define LINUX_SO_DOMAIN		39
#define LINUX_SO_RXQ_OVFL	40
#define LINUX_SO_WIFI_STATUS	41
#define LINUX_SO_PEEK_OFF	42
#define LINUX_SO_NOFCS		43

#endif /* !_LINUX_SOCKET_GENERIC_H */
