/* $NetBSD: tegra124_xusbpadreg.h,v 1.3 2017/09/22 20:23:22 jakllsch Exp $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_TEGRA_TEGRA124_XUSBPADREG_H
#define _ARM_TEGRA_TEGRA124_XUSBPADREG_H

#define XUSB_PADCTL_BOOT_MEDIA_REG			0x000
#define XUSB_PADCTL_USB2_PAD_MUX_REG			0x004
#define XUSB_PADCTL_USB2_PORT_CAP_REG			0x008
#define XUSB_PADCTL_SNPS_OC_MAP_REG			0x00c
#define XUSB_PADCTL_USB2_OC_MAP_REG			0x010
#define XUSB_PADCTL_SS_PORT_MAP_REG			0x014
#define XUSB_PADCTL_OC_DET_REG				0x018
#define XUSB_PADCTL_ELPG_PROGRAM_REG			0x01c
#define XUSB_PADCTL_USB2_BATTERY_CHRG_OTGPAD0_CTL0_REG	0x020
#define XUSB_PADCTL_USB2_BATTERY_CHRG_OTGPAD0_CTL1_REG	0x024
#define XUSB_PADCTL_USB2_BATTERY_CHRG_OTGPAD1_CTL0_REG	0x028
#define XUSB_PADCTL_USB2_BATTERY_CHRG_OTGPAD1_CTL1_REG	0x02c
#define XUSB_PADCTL_USB2_BATTERY_CHRG_OTGPAD2_CTL0_REG	0x030
#define XUSB_PADCTL_USB2_BATTERY_CHRG_OTGPAD2_CTL1_REG	0x034
#define XUSB_PADCTL_USB2_BATTERY_CHRG_BIASPAD_REG	0x038
#define XUSB_PADCTL_USB2_BATTERY_CHRG_TDCD_DBNC_TIMER_REG 0x03c
#define XUSB_PADCTL_IOPHY_PLL_P0_CTL1_REG		0x040
#define XUSB_PADCTL_IOPHY_PLL_P0_CTL2_REG		0x044
#define XUSB_PADCTL_IOPHY_PLL_P0_CTL3_REG		0x048
#define XUSB_PADCTL_IOPHY_PLL_P0_CTL4_REG		0x04c
#define XUSB_PADCTL_IOPHY_USB3_PAD0_CTL1_REG		0x050
#define XUSB_PADCTL_IOPHY_USB3_PAD1_CTL1_REG		0x054
#define XUSB_PADCTL_IOPHY_USB3_PAD0_CTL2_REG		0x058
#define XUSB_PADCTL_IOPHY_USB3_PAD1_CTL2_REG		0x05c
#define XUSB_PADCTL_IOPHY_USB3_PAD0_CTL3_REG		0x060
#define XUSB_PADCTL_IOPHY_USB3_PAD1_CTL3_REG		0x064
#define XUSB_PADCTL_IOPHY_USB3_PAD0_CTL4_REG		0x068
#define XUSB_PADCTL_IOPHY_USB3_PAD1_CTL4_REG		0x06c
#define XUSB_PADCTL_IOPHY_MISC_PAD_P0_CTL1_REG		0x070
#define XUSB_PADCTL_IOPHY_MISC_PAD_P1_CTL1_REG		0x074
#define XUSB_PADCTL_IOPHY_MISC_PAD_P0_CTL2_REG		0x078
#define XUSB_PADCTL_IOPHY_MISC_PAD_P1_CTL2_REG		0x07c
#define XUSB_PADCTL_IOPHY_MISC_PAD_P0_CTL3_REG		0x080
#define XUSB_PADCTL_IOPHY_MISC_PAD_P1_CTL3_REG		0x084
#define XUSB_PADCTL_IOPHY_MISC_PAD_P0_CTL4_REG		0x088
#define XUSB_PADCTL_IOPHY_MISC_PAD_P1_CTL4_REG		0x08c
#define XUSB_PADCTL_IOPHY_MISC_PAD_P0_CTL5_REG		0x090
#define XUSB_PADCTL_IOPHY_MISC_PAD_P1_CTL5_REG		0x094
#define XUSB_PADCTL_IOPHY_MISC_PAD_P0_CTL6_REG		0x098
#define XUSB_PADCTL_IOPHY_MISC_PAD_P1_CTL6_REG		0x09c
#define XUSB_PADCTL_USB2_OTG_PAD0_CTL0_REG		0x0a0
#define XUSB_PADCTL_USB2_OTG_PAD1_CTL0_REG		0x0a4
#define XUSB_PADCTL_USB2_OTG_PAD2_CTL0_REG		0x0a8
#define XUSB_PADCTL_USB2_OTG_PAD0_CTL1_REG		0x0ac
#define XUSB_PADCTL_USB2_OTG_PAD1_CTL1_REG		0x0b0
#define XUSB_PADCTL_USB2_OTG_PAD2_CTL1_REG		0x0b4
#define XUSB_PADCTL_USB2_BIAS_PAD_CTL0_REG		0x0b8
#define XUSB_PADCTL_USB2_BIAS_PAD_CTL1_REG		0x0bc
#define XUSB_PADCTL_HSIC_PAD0_CTL0_REG			0x0c0
#define XUSB_PADCTL_HSIC_PAD1_CTL0_REG			0x0c4
#define XUSB_PADCTL_HSIC_PAD0_CTL1_REG			0x0c8
#define XUSB_PADCTL_HSIC_PAD1_CTL1_REG			0x0cc
#define XUSB_PADCTL_HSIC_PAD0_CTL2_REG			0x0d0
#define XUSB_PADCTL_HSIC_PAD1_CTL2_REG			0x0d4
#define XUSB_PADCTL_ULPI_LINK_TRIM_CONTROL_REG		0x0d8
#define XUSB_PADCTL_ULPI_NULL_CLK_TRIM_CONTROL_REG	0x0dc
#define XUSB_PADCTL_HSIC_STRB_TRIM_CONTROL_REG		0x0e0
#define XUSB_PADCTL_WAKE_CTRL_REG			0x0e4
#define XUSB_PADCTL_PM_SPARE_REG			0x0e8
#define XUSB_PADCTL_IOPHY_MISC_PAD_P2_CTL1_REG		0x0ec
#define XUSB_PADCTL_IOPHY_MISC_PAD_P3_CTL1_REG		0x0f0
#define XUSB_PADCTL_IOPHY_MISC_PAD_P4_CTL1_REG		0x0f4
#define XUSB_PADCTL_IOPHY_MISC_PAD_P2_CTL2_REG		0x0f8
#define XUSB_PADCTL_IOPHY_MISC_PAD_P3_CTL2_REG		0x0fc
#define XUSB_PADCTL_IOPHY_MISC_PAD_P4_CTL2_REG		0x100
#define XUSB_PADCTL_IOPHY_MISC_PAD_P2_CTL3_REG		0x104
#define XUSB_PADCTL_IOPHY_MISC_PAD_P3_CTL3_REG		0x108
#define XUSB_PADCTL_IOPHY_MISC_PAD_P4_CTL3_REG		0x10c
#define XUSB_PADCTL_IOPHY_MISC_PAD_P2_CTL4_REG		0x110
#define XUSB_PADCTL_IOPHY_MISC_PAD_P3_CTL4_REG		0x114
#define XUSB_PADCTL_IOPHY_MISC_PAD_P4_CTL4_REG		0x118
#define XUSB_PADCTL_IOPHY_MISC_PAD_P2_CTL5_REG		0x11c
#define XUSB_PADCTL_IOPHY_MISC_PAD_P3_CTL5_REG		0x120
#define XUSB_PADCTL_IOPHY_MISC_PAD_P4_CTL5_REG		0x124
#define XUSB_PADCTL_IOPHY_MISC_PAD_P2_CTL6_REG		0x128
#define XUSB_PADCTL_IOPHY_MISC_PAD_P3_CTL6_REG		0x12c
#define XUSB_PADCTL_IOPHY_MISC_PAD_P4_CTL6_REG		0x130
#define XUSB_PADCTL_USB3_PAD_MUX_REG			0x134
#define XUSB_PADCTL_IOPHY_PLL_S0_CTL1_REG		0x138
#define XUSB_PADCTL_IOPHY_PLL_S0_CTL2_REG		0x13c
#define XUSB_PADCTL_IOPHY_PLL_S0_CTL3_REG		0x140
#define XUSB_PADCTL_IOPHY_PLL_S0_CTL4_REG		0x144
#define XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL1_REG		0x148
#define XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL2_REG		0x14c
#define XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL3_REG		0x150
#define XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL4_REG		0x154
#define XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL5_REG		0x158
#define XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL6_REG		0x15c

#define XUSB_PADCTL_OC_DET_OC_DETECTED_VBUS_PAD2		__BIT(22)
#define XUSB_PADCTL_OC_DET_OC_DETECTED_VBUS_PAD1		__BIT(21)
#define XUSB_PADCTL_OC_DET_OC_DETECTED_VBUS_PAD0		__BIT(20)
#define XUSB_PADCTL_OC_DET_OC_DETECTED3				__BIT(19)
#define XUSB_PADCTL_OC_DET_OC_DETECTED2				__BIT(18)
#define XUSB_PADCTL_OC_DET_OC_DETECTED1				__BIT(17)
#define XUSB_PADCTL_OC_DET_OC_DETECTED0				__BIT(16)
#define XUSB_PADCTL_OC_DET_VBUS_ENABLE1				__BIT(9)
#define XUSB_PADCTL_OC_DET_VBUS_ENABLE0				__BIT(8)
#define XUSB_PADCTL_OC_DET_VBUS_ENABLE2				__BIT(4)

#define XUSB_PADCTL_ELPG_PROGRAM_AUX_MUX_LP0_VCORE_DOWN		__BIT(26)
#define XUSB_PADCTL_ELPG_PROGRAM_AUX_MUX_LP0_CLAMP_EN_EARLY	__BIT(25)
#define XUSB_PADCTL_ELPG_PROGRAM_AUX_MUX_LP0_CLAMP_EN		__BIT(24)
#define XUSB_PADCTL_ELPG_PROGRAM_SSP1_ELPG_VCORE_DOWN		__BIT(22)
#define XUSB_PADCTL_ELPG_PROGRAM_SSP1_ELPG_CLAMP_EN_EARLY	__BIT(21)
#define XUSB_PADCTL_ELPG_PROGRAM_SSP1_ELPG_CLAMP_EN		__BIT(20)
#define XUSB_PADCTL_ELPG_PROGRAM_SSP0_ELPG_VCORE_DOWN		__BIT(18)
#define XUSB_PADCTL_ELPG_PROGRAM_SSP0_ELPG_CLAMP_EN_EARLY	__BIT(17)
#define XUSB_PADCTL_ELPG_PROGRAM_SSP0_ELPG_CLAMP_EN		__BIT(16)

#define XUSB_PADCTL_USB2_OTG_PAD_CTL0_PD_ZI 			__BIT(21)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL0_PD2			__BIT(20)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL0_PD			__BIT(19)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL0_LS_RSLEW			__BITS(15,14)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL0_LS_RSLEW_VAL(pad)		((pad >= 1) ? 0x0 : 0x3)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL0_HS_SLEW			__BITS(11,6)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL0_HS_SLEW_VAL		0x0e
#define XUSB_PADCTL_USB2_OTG_PAD_CTL0_HS_CURR_LEVEL		__BITS(5,0)

#define XUSB_PADCTL_USB2_OTG_PAD_CTL1_HS_IREF_CAP		__BITS(10,9)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL1_TERM_RANGE_ADJ		__BITS(6,3)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL1_PD_DR			__BIT(2)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL1_PD_DISC_FORCE_POWERUP	__BIT(1)
#define XUSB_PADCTL_USB2_OTG_PAD_CTL1_PD_CHRP_FORCE_POWERUP	__BIT(0)

#define XUSB_PADCTL_USB2_BIAS_PAD_CTL0_PD_TRK			__BIT(13)
#define XUSB_PADCTL_USB2_BIAS_PAD_CTL0_PD			__BIT(12)
#define XUSB_PADCTL_USB2_BIAS_PAD_CTL0_HS_DISCON_LEVEL		__BITS(4,2)
#define XUSB_PADCTL_USB2_BIAS_PAD_CTL0_HS_DISCON_LEVEL_VAL	0x5
#define XUSB_PADCTL_USB2_BIAS_PAD_CTL0_HS_SQUELCH_LEVEL		__BITS(1,0)

#define XUSB_PADCTL_USB3_PAD_MUX_SATA_PAD_LANE0		__BITS(27,26)
#define XUSB_PADCTL_USB3_PAD_MUX_SATA_PAD_LANE0_PCIE	0
#define XUSB_PADCTL_USB3_PAD_MUX_SATA_PAD_LANE0_USB3_SS	1
#define XUSB_PADCTL_USB3_PAD_MUX_SATA_PAD_LANE0_SATA	2
#define XUSB_PADCTL_USB3_PAD_MUX_FORCE_SATA_PAD_IDDQ_DISABLE_MASK0 __BIT(6)

#define XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PLL1_LOCKDET	__BIT(27)
#define XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PLL1_MODE		__BIT(24)
#define XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PWR_OVRD		__BIT(3)
#define XUSB_PADCTL_IOPHY_PLL_S0_CTL1_PLL_RST		__BIT(1)
#define XUSB_PADCTL_IOPHY_PLL_S0_CTL1_IDDQ		__BIT(0)

#define XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL1_IDDQ_OVRD	__BIT(1)
#define XUSB_PADCTL_IOPHY_MISC_PAD_S0_CTL1_IDDQ		__BIT(0)

#endif /* _ARM_TEGRA_TEGRA124_XUSBPADREG_H */
