package Apps::Checkbook::MySOAP;

use strict;
use warnings;

use base 'Apps::Checkbook::GEN::MySOAP';

#-----------------------------------------------------------------
# $self->namespace(  )
#-----------------------------------------------------------------
# This method inherited from Apps::Checkbook::GEN::MySOAP

#-----------------------------------------------------------------
# $self->get_soap_ops(  )
#-----------------------------------------------------------------
# This method inherited from Apps::Checkbook::GEN::MySOAP

#-----------------------------------------------------------------
# $self->do_greet(  )
#-----------------------------------------------------------------
sub do_greet {
    my ( $self ) = @_;

    my $params = $self->params();  # easy way

    my $name = $params->{ name };

# hard way:
#    my $xmlobj   = XML::LibXML->new();
#    my $dom      = $xmlobj->parse_string( $self->get_post_body() )
#            or return return_error( "Mal-formed XML request: $!" );
#
#    my ( $name_node ) = $dom->getElementsByLocalName( 'name' );
#    my $name          = $name_node->textContent;

    my $greeting;

    my $time = $self->soap_current_time();

    my $ret_struct = [
        {
            GantrySoapServiceResponse => [
                { greeting => $greeting },
            ]
        }
    ];

    $self->soap_namespace_set(
        'http://usegantry.org/soapservice'
    );

    return $self->soap_out( $ret_struct, 'internal', 'pretty' );
} # END do_greet

#-----------------------------------------------------------------
# $self->do_cube_root(  )
#-----------------------------------------------------------------
sub do_cube_root {
    my ( $self ) = @_;

    my $params = $self->params();  # easy way

    my $target = $params->{ target };
    my $tolerance = $params->{ tolerance };

# hard way:
#    my $xmlobj   = XML::LibXML->new();
#    my $dom      = $xmlobj->parse_string( $self->get_post_body() )
#            or return return_error( "Mal-formed XML request: $!" );
#
#    my ( $target_node ) = $dom->getElementsByLocalName( 'target' );
#    my $target          = $target_node->textContent;
#    my ( $tolerance_node ) = $dom->getElementsByLocalName( 'tolerance' );
#    my $tolerance          = $tolerance_node->textContent;

    my $answer;

    my $time = $self->soap_current_time();

    my $ret_struct = [
        {
            GantrySoapServiceResponse => [
                { answer => $answer },
            ]
        }
    ];

    $self->soap_namespace_set(
        'http://usegantry.org/soapservice'
    );

    return $self->soap_out( $ret_struct, 'internal', 'pretty' );
} # END do_cube_root


1;

=head1 NAME

Apps::Checkbook::MySOAP - A controller in the Apps::Checkbook application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use Apps::Checkbook::MySOAP;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/someurl' => 'Apps::Checkbook::MySOAP',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use Apps::Checkbook::MySOAP;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler Apps::Checkbook::MySOAP
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module was originally generated by Bigtop.  But feel free to edit it.
You might even want to describe the table this module controls here.

=head1 METHODS

=over 4

=item do_greet

=item do_cube_root


=back


=head1 METHODS INHERITED FROM Apps::Checkbook::GEN::MySOAP

=over 4

=item namespace

=item get_soap_ops


=back


=head1 DEPENDENCIES

    Apps::Checkbook
    Apps::Checkbook::GEN::MySOAP

=head1 AUTHOR

Phil Crow, E<lt>mail@example.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright  Phil Crow

All rights reserved.

=cut
