#!/usr/bin/perl

package eBay::API::XML::Call::GetCategory2CS;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCategory2CS.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCategory2CS

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCategory2CS inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetCategory2CS::GetCategory2CSRequestType;
use eBay::API::XML::Call::GetCategory2CS::GetCategory2CSResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetCategory2CS';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetCategory2CS::GetCategory2CSRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetCategory2CS::GetCategory2CSResponseType';
}

#
# input properties
#

=head2 setAttributeSystemVersion()

A version of the mappings for the site.
Typically, an application passes the version value that was returned the last
time the application executed this call.
Filter that causes the call to return only the categories
for which the mappings have changed since the specified version.
If not specified, all category-to-characteristics set mappings are returned.
This value changes each time changes are made to the mappings.
The current version value is not necessarily greater than the previous
value. Therefore, when comparing versions, only compare whether the
value has changed.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrGC2CS
Title: Retrieving Category-to-Meta-Data Mappings

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setAttributeSystemVersion {
   my $self   = shift;
   my $sAttributeSystemVersion = shift;
   $self->getRequestDataType()->setAttributeSystemVersion($sAttributeSystemVersion);
}

=head2 setCategoryID()

ID of a category for which to retrieve mappings.
If not specified, the call
retrieves a map for all categories.

MaxLength: 10

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setCategoryID {
   my $self   = shift;
   my $sCategoryID = shift;
   $self->getRequestDataType()->setCategoryID($sCategoryID);
}



#
# output properties
#

=head2 getAttributeSystemVersion()

Current version of the mappings for the site.
This value changes each time changes are made to the mappings.
The current version value is not necessarily greater than the previous
value. Therefore, when comparing versions, only compare whether the
value has changed.

  Returned: Always
  Details: DetailLevel: none, ReturnAll
#    Returns: 'xs:string'

=cut
       
sub getAttributeSystemVersion {
   my $self = shift;
   return $self->getResponseDataType()->getAttributeSystemVersion();
}

=head2 getMappedCategoryArray()

Contains data about categories that are mapped to characteristics sets.
Use this data to determine:<br>
- The names and IDs of the characteristics sets<br>
- The availability of the Pre-filled Item Information feature for listings in that category
(i.e., whether the category is catalog-enabled)<br>
- For catalog-enabled categories, the available product search methods<br>
- The current version information for the complete mapping<br>
- The version information for each characteristics set

  Returned: Conditionally
  Details: DetailLevel: ReturnAll
#    Returns: 'ns:CategoryArrayType'

=cut
       
sub getMappedCategoryArray {
   my $self = shift;
   return $self->getResponseDataType()->getMappedCategoryArray();
}

=head2 getSiteWideCharacteristicSets()

A list of one or more characteristics sets mapped to the category, if any. Use this
information when working with Item Specifics (Attributes) and Pre-filled Item
Information (Catalogs) functionality.

  Returned: Conditionally
  Details: DetailLevel: ReturnAll
#    Returns: reference to an array  
                      of 'ns:SiteWideCharacteristicsType'

=cut
       
sub getSiteWideCharacteristicSets {
   my $self = shift;
   return $self->getResponseDataType()->getSiteWideCharacteristicSets();
}

=head2 getUnmappedCategoryArray()

Contains data about categories (if any) whose characteristics set mappings have changed
since the version specified in the request. When a characteristics set mapping
changes, the data appears in both the UnmappedCategoryArray object
(to indicate that the change occurred) and the MappedCategoryArray object.

  Returned: Conditionally
  Details: DetailLevel: ReturnAll
#    Returns: 'ns:CategoryArrayType'

=cut
       
sub getUnmappedCategoryArray {
   my $self = shift;
   return $self->getResponseDataType()->getUnmappedCategoryArray();
}





1;   
