#!perl -T
use warnings; use strict;
use Test::More;
use Test::Fatal;

use Bb::Collaborate::V3;
use Bb::Collaborate::V3::Session;

use lib '.';
use t::Bb::Collaborate::V3;

my $t = Test::More->builder();

my $class = 'Bb::Collaborate::V3::Session' ;

use Carp;
use Scalar::Util;
use Try::Tiny;

my $MODULE = 'Test::Taint';
eval "use $MODULE";
plan skip_all => "$MODULE not available for taint tests"
    if $@;

plan tests => 12;
#
# restrict our user tests to the mock connections. Live updates
# are just to dangerous. There is also the possibility that the
# live site is running LDAP, in which case user access becomes
# read only.
#

SKIP: {

    my $skippable = 12;

    my %result = t::Bb::Collaborate::V3->test_connection();
    my $auth = $result{auth};

    skip ($result{reason} || 'skipping live tests', $skippable)
	unless $auth && @$auth;

    my $connection_class = $result{class};
    my $connection = $connection_class->connect(@$auth);
    Bb::Collaborate::V3->connection($connection);

    taint_checking_ok();

    my $session_start = Elive::Util::next_quarter_hour();
    my $session_end = Elive::Util::next_quarter_hour( $session_start );

    my $session_name_untainted = 'test session, generated by t/soap-taint-mode.t(' . t::Bb::Collaborate::V3::generate_id() . ')';
    taint( my $session_name_tainted = $session_name_untainted);

    my %session_data = (
	sessionName => $session_name_untainted,
	creatorId => $connection->user,
	startTime =>  $session_start . '000',
	endTime => $session_end . '000',
	permissionsOn => 1,
	chairList => [$connection->user],
    );

    my $session;

    is( exception {$session = $class->insert(\%session_data);} => undef,
	     'insert with no tainted data - lives');

    $session_data{sessionName} = $session_name_tainted;
    isnt( sub {$session = $class->insert(\%session_data);} => undef,
	     'insert with tainted Str data - dies');

    isa_ok($session, $class, 'session');

    my $chair_notes_untainted = 'this is a test';
    taint(my $chair_notes_tainted = $chair_notes_untainted);

    my %update_data = (
	chairNotes => $chair_notes_tainted,
	);

    isnt( exception {$session->update(\%update_data)} => undef, 'update with tainted Str data - dies');

    $update_data{chairNotes} = $chair_notes_untainted;

    is( exception {$session->update(\%update_data)} => undef, 'update with no tainted data - lives');

    my $session_id = $session->sessionId;

    $session = undef;

    my $sessions;

    isnt (sub {$sessions = Bb::Collaborate::V3::Session->list(filter => {sessionName => $session_name_tainted})} => undef,
	'List with tainted filter - dies');
  
    is ( exception {$sessions = Bb::Collaborate::V3::Session->list(filter => {sessionName => $session_name_untainted})} => undef,
	'List with untainted filter - lives');
  
    is(scalar @$sessions, 1, 'list returns unique session');

    is( try {$sessions->[0]->sessionId}, $session_id, 'listed sessionId as expected');
    $sessions = undef;

    ok ($session = Bb::Collaborate::V3::Session->retrieve($session_id),
	'Refetch of session');

    is( exception {$session->delete} => undef, 'session deletion - lives');

}

Bb::Collaborate::V3->disconnect;
