/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public final class XSLSequence
extends StyleElement {
    private Expression select;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.select == null) {
            return AnyItemType.getInstance();
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return this.select.getItemType(th);
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public boolean mayContainFallback() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        } else {
            this.reportAbsence("select");
            this.select = Literal.makeEmptySequence();
        }
    }

    public void validate(Declaration decl) throws XPathException {
        Object child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLFallback) continue;
            this.compileError("The only child node allowed for xsl:sequence is an xsl:fallback instruction", "XTSE0010");
            break;
        }
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Executable exec, Declaration decl) {
        return this.select;
    }
}

