/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import java.io.InputStream;
import java.net.URL;

public class ResourceUtil {
    public static String getResourcePath(String localName) {
        String classPath = ResourceUtil.class.getName().replace('.', '/');
        String classPackage = classPath.substring(0, classPath.lastIndexOf("/"));
        String projectPackage = classPackage.substring(0, classPackage.lastIndexOf("/"));
        return projectPackage + "/" + localName;
    }

    public static String getExtension(String path) {
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(46) + 1);
        }
        return null;
    }

    public static InputStream getResourceStream(String resourcePath) {
        ClassLoader loader = ResourceUtil.class.getClassLoader();
        if (loader == null) {
            return ClassLoader.getSystemResourceAsStream(resourcePath);
        }
        return loader.getResourceAsStream(resourcePath);
    }

    public static URL getResourceURL(String resourcePath) {
        ClassLoader loader = ResourceUtil.class.getClassLoader();
        if (loader == null) {
            return ClassLoader.getSystemResource(resourcePath);
        }
        return loader.getResource(resourcePath);
    }
}

