use Const::XS qw/all/;
use Test::More;
const my $foo => 'a scalar value';
const my @bar => qw/a list value/, { hash => 1, deep => { one => 'nope' } }, [ 'nested', { hash => 2 } ];
const my %buz => (a => 'hash', of => 'something', array => [ 'nested', { hash => 1 } ], hash => { hash => 2, deep => { one => 'nope' } } );
const my $sub => sub { return 1 };
const my $ref => { a => 1, b => 2 };

is(is_readonly($foo), 1);

my $test = 'abc';
is(is_readonly($test), 0);

is(is_readonly(@bar[3]), 1);

is(is_readonly($buz{array}), 1);

is(is_readonly(\%buz), 0);

is(is_readonly($sub), 1);

my $other_sub = sub { return 2 };

is(is_readonly($other_sub), 0);

is(is_readonly($ref), 1);

my $array = [ $foo ];

is(is_readonly($array), 0);

#my $string = "abc";
#is(is_readonly($string), 0); # 0;
#make_readonly($string);
#is(is_readonly($string), 1); # 1;
#unmake_readonly($string);
#is(is_readonly($string), 0);

my $hash = { a => 1, b => 2, c => 3 };
is(is_readonly($hash), 0); # 0;
make_readonly($hash);
is(is_readonly($hash), 1);
unmake_readonly($hash);
is(is_readonly($hash), 0);

my $array = [ qw/1 2 3/, { deep => { deeper => { one => 1 } } } ];
is(is_readonly($array), 0); # 0;
make_readonly($array);
is(is_readonly($array), 1);
unmake_readonly($array);
is(is_readonly($array), 0);

done_testing();
