#!/usr/bin/env perl

use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/../lib";

use SMS::API::VoIP::MS;

die "Usage: $0 <login> <api_key> <from_did> <to_did> <file to attach> <message>\n"
    if !@ARGV || @ARGV < 6;

my ( $username, $key, $from, $to, $file ) = @ARGV;
my $message                               = join q{ }, splice( @ARGV, 5 );

my $obj = SMS::API::VoIP::MS->new(
    username => $username,
    api_key  => $key,
    did      => $from,
);

print 'From: ' . $obj->did . "\n";;
print "To: $to\n\n";
print "$message\n";

$obj->send_mms(
    to     => $to,
    media3 => $file,

    $message,
);
