/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.AbstractProgramRunner;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LatexRunner
extends AbstractProgramRunner {
    private static final int MAX_LINE_LENGTH = 79;
    private Stack<String> parsingStack = new Stack();
    private boolean alreadyShowError;

    protected String getWindowsProgramName() {
        return "latex.exe";
    }

    protected String getUnixProgramName() {
        return "latex";
    }

    public String getDescription() {
        return "Latex program";
    }

    public String getDefaultArguments() {
        return "-interaction=nonstopmode --src-specials %input";
    }

    public String getInputFormat() {
        return "tex";
    }

    public String getOutputFormat() {
        return "dvi";
    }

    protected String[] getQueryString() {
        return new String[]{"\nPlease type another input file name:", "\nEnter file name:"};
    }

    private void addProblemMarker(String error, String causingSourceFile, int linenr, int severity, IResource resource, boolean layout) {
        IProject project = resource.getProject();
        IContainer sourceDir = TexlipseProperties.getProjectSourceDir(project);
        IResource extResource = null;
        if (causingSourceFile != null) {
            Path p = new Path(causingSourceFile);
            if (p.isAbsolute()) {
                if (sourceDir.getLocation().isPrefixOf((IPath)p)) {
                    p = p.makeRelativeTo(sourceDir.getLocation());
                } else if (resource.getParent().getLocation().isPrefixOf((IPath)p)) {
                    p = p.makeRelativeTo(resource.getParent().getLocation());
                }
            }
            if ((extResource = sourceDir.findMember((IPath)p)) == null) {
                extResource = resource.getParent().findMember((IPath)p);
            }
        }
        if (extResource == null) {
            LatexRunner.createMarker(resource, null, String.valueOf(error) + (causingSourceFile != null ? " (Occurance: " + causingSourceFile + ")" : ""), severity);
        } else if (linenr >= 0) {
            if (layout) {
                LatexRunner.createLayoutMarker(extResource, new Integer(linenr), error);
            } else {
                LatexRunner.createMarker(extResource, new Integer(linenr), error, severity);
            }
        } else {
            LatexRunner.createMarker(extResource, null, error, severity);
        }
    }

    protected boolean parseErrors(IResource resource, String output) {
        TexlipseProperties.setSessionProperty((IResource)resource.getProject(), "rerunLatex", null);
        TexlipseProperties.setSessionProperty((IResource)resource.getProject(), "rerunBibtex", null);
        this.parsingStack.clear();
        boolean errorsFound = false;
        boolean citeNotfound = false;
        this.alreadyShowError = false;
        StringTokenizer st = new StringTokenizer(output, "\r\n");
        Pattern LATEXERROR = Pattern.compile("^! LaTeX Error: (.*)$");
        Pattern LATEXCERROR = Pattern.compile("^(.+?\\.\\w{3}):(\\d+): (.+)$");
        Pattern TEXERROR = Pattern.compile("^!\\s+(.*)$");
        Pattern FULLBOX = Pattern.compile("^(?:Over|Under)full \\\\[hv]box .* at lines? (\\d+)-?-?(\\d+)?");
        Pattern WARNING = Pattern.compile("^.+[Ww]arning.*: (.*)$");
        Pattern ATLINE = Pattern.compile("^l\\.(\\d+)(.*)$");
        Pattern ATLINE2 = Pattern.compile(".* line (\\d+).*");
        Pattern NOBIBFILE = Pattern.compile("^No file .+\\.bbl\\.$");
        Pattern NOTOCFILE = Pattern.compile("^No file .+\\.toc\\.$");
        boolean hasProblem = false;
        String error = null;
        int severity = 1;
        int linenr = -1;
        String occurance = null;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            while (!line.endsWith("...") && st.hasMoreTokens() && line.length() % 79 == 0) {
                line = String.valueOf(line) + st.nextToken();
            }
            Matcher m = LATEXCERROR.matcher(line = line.replaceAll(" {2,}", " ").trim());
            if (m.matches()) {
                this.addProblemMarker(m.group(3), m.group(1), Integer.parseInt(m.group(2)), 2, resource, false);
                if (!this.parsingStack.isEmpty()) continue;
                this.parsingStack.push("(" + m.group(1));
                continue;
            }
            m = TEXERROR.matcher(line);
            if (m.matches() && line.toLowerCase().indexOf("warning") == -1) {
                if (hasProblem) {
                    this.addProblemMarker(error, occurance, linenr, severity, resource, false);
                    linenr = -1;
                }
                hasProblem = true;
                errorsFound = true;
                severity = 2;
                occurance = this.determineSourceFile();
                Matcher m2 = LATEXERROR.matcher(line);
                if (m2.matches()) {
                    error = m2.group(1);
                    String part2 = st.nextToken().trim();
                    if (Character.isLowerCase(part2.charAt(0))) {
                        error = String.valueOf(error) + ' ' + part2;
                    }
                    this.updateParsedFile(part2);
                    continue;
                }
                if (line.startsWith("! Undefined control sequence.")) {
                    error = "Undefined control sequence: ";
                    continue;
                }
                m2 = WARNING.matcher(line);
                if (m2.matches()) {
                    severity = 1;
                }
                error = m.group(1);
                continue;
            }
            m = WARNING.matcher(line);
            if (m.matches()) {
                Matcher pM;
                if (hasProblem) {
                    this.addProblemMarker(error, occurance, linenr, severity, resource, false);
                    linenr = -1;
                    hasProblem = false;
                }
                if (line.indexOf("Label(s) may have changed.") > -1) {
                    TexlipseProperties.setSessionProperty((IResource)resource.getProject(), "rerunLatex", "true");
                    continue;
                }
                if (line.indexOf("There were undefined") > -1) {
                    if (!citeNotfound) continue;
                    TexlipseProperties.setSessionProperty((IResource)resource.getProject(), "rerunBibtex", "true");
                    continue;
                }
                if (line.indexOf("Warning: Reference ") > -1) continue;
                if (line.indexOf("Warning: Citation ") > -1) {
                    citeNotfound = true;
                    continue;
                }
                severity = 1;
                occurance = this.determineSourceFile();
                hasProblem = true;
                if (line.startsWith("LaTeX Warning: ") || line.indexOf("pdfTeX warning") != -1) {
                    String nextLine;
                    error = m.group(1);
                    pM = ATLINE2.matcher(line);
                    if (pM.matches()) {
                        linenr = Integer.parseInt(pM.group(1));
                    }
                    if ((pM = ATLINE2.matcher(nextLine = st.nextToken().replaceAll(" {2,}", " "))).matches()) {
                        linenr = Integer.parseInt(pM.group(1));
                    }
                    this.updateParsedFile(nextLine);
                    error = String.valueOf(error) + nextLine;
                    if (linenr == -1) continue;
                    this.addProblemMarker(line, occurance, linenr, severity, resource, false);
                    hasProblem = false;
                    linenr = -1;
                    continue;
                }
                error = m.group(1);
                pM = ATLINE2.matcher(line);
                if (!pM.matches()) continue;
                linenr = Integer.parseInt(pM.group(1));
                continue;
            }
            m = FULLBOX.matcher(line);
            if (m.matches()) {
                if (hasProblem) {
                    this.addProblemMarker(error, occurance, linenr, severity, resource, false);
                    linenr = -1;
                    hasProblem = false;
                }
                severity = 1;
                occurance = this.determineSourceFile();
                error = line;
                linenr = Integer.parseInt(m.group(1));
                this.addProblemMarker(line, occurance, linenr, severity, resource, true);
                hasProblem = false;
                linenr = -1;
                continue;
            }
            m = NOBIBFILE.matcher(line);
            if (m.matches()) {
                TexlipseProperties.setSessionProperty((IResource)resource.getProject(), "rerunBibtex", "true");
                continue;
            }
            m = NOTOCFILE.matcher(line);
            if (m.matches()) {
                TexlipseProperties.setSessionProperty((IResource)resource.getProject(), "rerunLatex", "true");
                continue;
            }
            m = ATLINE.matcher(line);
            if (hasProblem && m.matches()) {
                linenr = Integer.parseInt(m.group(1));
                String part2 = st.nextToken();
                int index = line.indexOf(32);
                if (index > -1) {
                    error = String.valueOf(error) + " " + line.substring(index).trim() + " (followed by: " + part2.trim() + ")";
                    this.addProblemMarker(error, occurance, linenr, severity, resource, false);
                    linenr = -1;
                    hasProblem = false;
                    continue;
                }
            }
            m = ATLINE2.matcher(line);
            if (hasProblem && m.matches()) {
                linenr = Integer.parseInt(m.group(1));
                this.addProblemMarker(error, occurance, linenr, severity, resource, false);
                linenr = -1;
                hasProblem = false;
                continue;
            }
            this.updateParsedFile(line);
        }
        if (hasProblem) {
            this.addProblemMarker(error, occurance, linenr, severity, resource, false);
        }
        return errorsFound;
    }

    private void updateParsedFile(String logLine) {
        if (logLine.indexOf(40) == -1 && logLine.indexOf(41) == -1) {
            return;
        }
        int i = 0;
        while (i < logLine.length()) {
            if (logLine.charAt(i) == '(') {
                int j = i + 1;
                while (j < logLine.length() && this.isAllowedinName(logLine.charAt(j))) {
                    ++j;
                }
                this.parsingStack.push(logLine.substring(i, j).trim());
                i = j - 1;
            } else if (logLine.charAt(i) == ')' && !this.parsingStack.isEmpty()) {
                this.parsingStack.pop();
            } else if (logLine.charAt(i) == ')' && !this.alreadyShowError) {
                this.alreadyShowError = true;
                TexlipsePlugin.log("Error while parsing the LaTeX output. Please consult the console output", null);
            }
            ++i;
        }
    }

    private boolean isAllowedinName(char c) {
        return c != '(' && c != ')' && c != '[';
    }

    private static boolean isValidName(String name) {
        int p = name.lastIndexOf(46);
        if (p < 0) {
            return false;
        }
        return name.length() - p <= 10;
    }

    private String determineSourceFile() {
        int i = this.parsingStack.size() - 1;
        while (i >= 0) {
            String fileName = ((String)this.parsingStack.get(i)).substring(1);
            if (fileName.startsWith("\"") && fileName.endsWith("\"")) {
                fileName = fileName.substring(1, fileName.length() - 1);
            }
            if (LatexRunner.isValidName(fileName)) {
                return fileName;
            }
            --i;
        }
        return null;
    }
}

