/* subrange.c - Subrange Types
   Time-stamp: "97/01/03 17:48:22 mik"

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <limits.h>

#include "common.h"

typedef struct
{
  long lb;
  long ub;
  const char *type_name;
} subrange_t;

static const subrange_t subrange_table[] =
{
  -128l, 127l, "_c4p_s8",
  0l, 255l, "_c4p_u8",
  -32768, 32767l, "_c4p_s16",
  0l, 65535l, "_c4p_u16",
  -2147483648l, 2147483647l, "_c4p_s32"
};

const char *
subrange (long lb,
	  long ub)

{
  const subrange_t *s = subrange_table;
  int i = sizeof (subrange_table) / sizeof (subrange_table[0]);

  for (; i--; s++)
    {
      if (s->lb <= lb && lb <= s->ub && ub <= s->ub)
	return (s->type_name);
    }
  return ("_c4p_u32");
}
