/*
 * Stand: 21.03.1995
 *
 * allgemeine Vereinbarungen fuer xtexshell.c
 */

#ifdef USE_Xaw_TOOLKIT
#else
#endif USE_Xaw_TOOLKIT



#include <X11/Intrinsic.h>	
#include <X11/StringDefs.h>
#include <X11/Xatom.h>

#ifdef USE_Xaw_TOOLKIT
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/StripChart.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Cardinals.h>
#else
#include <Xol/OpenLook.h>
#include <Xol/OlCursors.h>	/* GetOlQuestionCursor() */
#include <Xol/OlDnDVCX.h>
#include <Xol/Button.h>
#include <Xol/Caption.h>
#include <Xol/CheckBox.h>
#include <Xol/ControlAre.h>
#include <Xol/DropTarget.h>
#include <Xol/Exclusives.h>
#include <Xol/FExclusive.h>
#include <Xol/FNonexclus.h>
#include <Xol/FooterPane.h>
#include <Xol/Form.h>
#include <Xol/MenuButton.h>
#include <Xol/Nonexclusi.h>
#include <Xol/Notice.h>
#include <Xol/OblongButt.h>
#include <Xol/PopupWindo.h>
#include <Xol/RectButton.h>
#include <Xol/RubberTile.h>
#include <Xol/Scrollbar.h>
#include <Xol/ScrolledWi.h>
#include <Xol/ScrollingL.h>
#include <Xol/StaticText.h>
#include <Xol/Stub.h>
#include <Xol/TextEdit.h>
#include <Xol/TextField.h>
#include <Xol/textbuff.h>
#endif USE_Xaw_TOOLKIT


#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <sys/wait.h>

#include <malloc.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <signal.h>

#include "xtexshell.icon"
#include "common.h"
#include "defaults.h"
#include "config.h"


/*                 RE - Definitions                            */
#define bcopy(s, d, n)	(void)	memcpy (d, s, n)
#define bcmp(s, d, n)	(int)	memcmp (s, d, n)
#define bzero(d, n)	(void)	memset (d, 0, n)
#define killpg(p,s)	(int)	kill   (-p, s)
/*              End:  RE - Definitions                         */


#ifdef USE_Xaw_TOOLKIT
#define captionWidgetClass		boxWidgetClass 
#define checkBoxWidgetClass		toggleWidgetClass
#define controlAreaWidgetClass		formWidgetClass /* boxWidgetClass */
#define flatExclusivesWidgetClass	toggleWidgetClass
#define flatNonexclusivesWidgetClass	toggleWidgetClass
#define footerPanelWidgetClass		panedWidgetClass /* boxWidgetClass */
/* #define formWidgetClass		formWidgetClass */
#define menuButtonGadgetClass		menuButtonWidgetClass
/* #define menuButtonWidgetClass	menuButtonWidgetClass */
#define noticeShellWidgetClass		transientShellWidgetClass
#define oblongButtonGadgetClass		commandWidgetClass
#define oblongButtonWidgetClass		commandWidgetClass
#define popupWindowShellWidgetClass	transientShellWidgetClass
#define rubberTileWidgetClass		panedWidgetClass
#define scrolledWindowWidgetClass	panedWidgetClass /* boxWidgetClass */ /* pannerWidgetClass */
#define scrollingListWidgetClass	listWidgetClass
#define staticTextWidgetClass		labelWidgetClass
#define stubWidgetClass			gripWidgetClass
#define textEditWidgetClass		asciiTextWidgetClass
#define textFieldWidgetClass		asciiTextWidgetClass
#endif USE_Xaw_TOOLKIT

#ifdef USE_Xaw_TOOLKIT
#define popupMenuButtonWidgetClass	smeBSBObjectClass
#define popupMenuButtonGadgetClass	smeBSBObjectClass
#else
#define popupMenuButtonWidgetClass	oblongButtonWidgetClass
#define popupMenuButtonGadgetClass	oblongButtonGadgetClass
#endif USE_Xaw_TOOLKIT

#ifdef USE_Xaw_TOOLKIT
#define OL_CENTER		7
#define OL_LEFT			35
#define OL_OUT			50
#define OL_STRING		63
#define OL_TOP			68

#define  XtNrecomputeSize  "recomputeSize"
#define  XtNpushpin        "pushpin"
#define  XtNlabelType      "labelType"
#define  XtNset   	   "state"   /* "set" */
#define  XtNapply   	   "apply"
#define  XtNsetDefaults    "setDefaults"
#define  XtNreset   	   "reset"
#define  XtNresetFactory   "resetFactory"
#define  XtNitems   	   "items"
#define  XtNnumItems       "numItems"
#define  XtNitemFields     "itemFields"
#define  XtNnumItemFields  "numItemFields"
#define  XtNgravity        "gravity"
#define  XtNunselect       "unselect"
/*
#define     ""
#define     ""
*/
#define XtNselectProc       "selectProc"
#define XtNunselectProc     "unselectProc"
#define XtNclientData       "clientData"
#define XtNalignment        "alignment"
#define XtNemanateWidget    "emanateWidget"
#define XtNvSliderMoved     "vSliderMoved"
#define XtNhSliderMoved     "hSliderMoved"
#define XtNtextArea         "textArea"
#define XtNcontrolArea      "controlArea"
#define XtNmodifyVerification "modifyVerification"
#define XtNforceVerticalSB  "forceVerticalSB"
#define XtNhStepSize        "hStepSize"
#define XtNvStepSize        "vStepSize"
#define XtNexpose     	    "expose"
#define XtNlabelJustify     "labelJustify"
#define XtNverify           "verify"
#define XtNupperControlArea "upperControlArea"
#define XtNlowerControlArea "lowerControlArea"
#define XtNfooterPanel      "footerPanel"
#define XtNviewHeight       "viewHeight"
#define XtNselectable       "selectable"
#define XtNapplAddItem      "applAddItem"
#define XtNapplTouchItem	"applTouchItem"
#define XtNapplUpdateView	"applUpdateView"
#define XtNapplDeleteItem	"applDeleteItem"
#define XtNapplViewItem		"applViewItem"
#define XtNuserMakeCurrent	"userMakeCurrent"
#define XtNsource      	    "source"
#define XtNverification     "verification"
#define XtNselect     	    "callback"

#define XtNxResizable       "xResizable"
#define XtNxAttachRight     "xAttachRight"
#define XtNmaximumSize	    "length"

#define XtNxRefName         "fromHoriz"
#define XtNyRefName         "fromVert"
#define XtNxRefWidget       "fromHoriz"
#define XtNyRefWidget       "fromVert"
#define XtNxOffset          "horizDistance"
#define XtNyOffset          "vertDistance"
#define XtNxAddWidth        "xAddWidth"
#define XtNyAddHeight       "yAddWidth"
#endif USE_Xaw_TOOLKIT

/*
 * PointToPixel() scales to the current screen resolution.
 */
#define HORIZONTAL 30
#define VERTICAL   70

#define DPY (Display *)XtDisplay(toplevel)
#define SCR (DPY)->default_screen

#define ScreenPointToPixel(direction, value) \
	(0.352777777 * (double)(value) * (double)(direction == HORIZONTAL ? \
	((double)XDisplayWidth(DPY, SCR)  / (double)XDisplayWidthMM(DPY, SCR))  :\
	((double)XDisplayHeight(DPY, SCR) / (double)XDisplayHeightMM(DPY, SCR))))

#ifdef linux
#define H_PIXEL(x)	x
#define V_PIXEL(x)	x
#else
#define H_PIXEL(x)	ScreenPointToPixel(HORIZONTAL,	x)
#define V_PIXEL(x)	ScreenPointToPixel(VERTICAL,	x)
#endif linux

/*
 * Defines
 */
#define	MAXTEXT			(1000)
#define	MAXBUF			(100)
#define ESC                     '\033'
#define DEL                     '\177'
#define C_RET			'\r'
#define Control(c)              ((c) - 0x40)
#define SPOOLSIZE		4500000


extern char *sys_errlist[];
extern int errno;

typedef struct Popupdata {
  Widget tf;    /* TextField  */
  Widget tf2;   /* TextField  */
  Widget te;    /* TextEdit   */
  Widget st;    /* StaticText */
} popupdata;

typedef struct PrintPopupdata {
  Widget tf11;    /* TextField  */
  Widget tf12;    /* TextField  */
  Widget tf21;    /* TextField  */
  Widget tf31;    /* TextField  */
  Widget tf32;    /* TextField  */
  Widget st;      /* StaticText */
} print_popupdata;

typedef struct {
  XtArgVal label;
  XtArgVal selectProc;
  XtArgVal unselectProc;
  XtArgVal clientData;
} FlatItems;

FlatItems formatItems[5], languageItems[4], utilprogItems[2],
	  runItems[3], resolutionItems[6],
          previewerItems[4], shrinkItems[4], displayItems[2];

FlatItems printzweiseitigItems[2], printresolutionItems[2],
	  printlanguageItems[2], printdeviceItems[4];

FlatItems document_VorlageItems[4];

String FlatFields[] = {
  XtNlabel,
  XtNselectProc,
  XtNunselectProc,
  XtNclientData,
};

#define BIBTEXINDEX 0
#define MAKEINDEXINDEX 1

#define ODDPAGESINDEX 0
#define EVENPAGESINDEX 1

static Boolean popdown = TRUE;
static popupdata pd;
static print_popupdata print_pd;

/*
 * Fuer die Liste der Files im Directory:
 */
#ifdef USE_Xaw_TOOLKIT
Boolean (*AddItem)();
void        (*DeleteItem)();
void        (*TouchItem)();
void        (*UpdateView)();
void        (*ViewItem)();

typedef struct _file {
  String         filename;
  struct _file *next;
} file;

file *head = NULL;     /* head of the list */

#else
OlListToken (*AddItem)();
void        (*DeleteItem)();
void        (*TouchItem)();
void        (*UpdateView)();
void        (*ViewItem)();

typedef struct _file {
  String         filename;
  OlListToken    token;
  struct _file *next;
} file;

file *head = NULL;     /* head of the list */
OlListToken lasttoken = NULL;
#endif USE_Xaw_TOOLKIT

/*
 * Global variables
 */
static Pixel    red_pixel,
                blue_pixel,
                purple_pixel,
                green_pixel,
                yellow_pixel,
                orange_pixel,
                skyblue_pixel,
                background_pixel;

