/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGGElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGGElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGGElementTableValues[] =
{
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementXmllang), (intptr_t)setJSSVGGElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementXmlspace), (intptr_t)setJSSVGGElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGGElementTable = { 34, 31, JSSVGGElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGGElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGGElementConstructorTable = { 1, 0, JSSVGGElementConstructorTableValues, 0 };
const ClassInfo JSSVGGElementConstructor::s_info = { "SVGGElementConstructor", &Base::s_info, &JSSVGGElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGGElementConstructor) };

JSSVGGElementConstructor::JSSVGGElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGGElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGGElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGGElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGGElementConstructor, JSDOMWrapper>(exec, &JSSVGGElementConstructorTable, jsCast<JSSVGGElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGGElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGGElementConstructor, JSDOMWrapper>(exec, &JSSVGGElementConstructorTable, jsCast<JSSVGGElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGGElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGGElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGGElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGGElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGGElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGGElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGGElementPrototypeTable = { 17, 15, JSSVGGElementPrototypeTableValues, 0 };
const ClassInfo JSSVGGElementPrototype::s_info = { "SVGGElementPrototype", &Base::s_info, &JSSVGGElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGGElementPrototype) };

JSObject* JSSVGGElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGGElement>(exec, globalObject);
}

bool JSSVGGElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGGElementPrototype* thisObject = jsCast<JSSVGGElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGGElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGGElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGGElementPrototype* thisObject = jsCast<JSSVGGElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGGElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGGElement::s_info = { "SVGGElement", &Base::s_info, &JSSVGGElementTable, 0 , CREATE_METHOD_TABLE(JSSVGGElement) };

JSSVGGElement::JSSVGGElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGGElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGGElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGGElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGGElementPrototype::create(exec->globalData(), globalObject, JSSVGGElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGGElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGGElement* thisObject = jsCast<JSSVGGElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGGElement, Base>(exec, &JSSVGGElementTable, thisObject, propertyName, slot);
}

bool JSSVGGElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGGElement* thisObject = jsCast<JSSVGGElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGGElement, Base>(exec, &JSSVGGElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGGElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGGElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGGElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGGElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGGElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGGElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGGElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGGElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGGElement* domObject = jsCast<JSSVGGElement*>(asObject(slotBase));
    return JSSVGGElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGGElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGGElement* thisObject = jsCast<JSSVGGElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGGElement, Base>(exec, propertyName, value, &JSSVGGElementTable, thisObject, slot);
}

void setJSSVGGElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(thisObject);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGGElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(thisObject);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGGElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGGElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGGElement::s_info);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGGElement::s_info);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGGElement::s_info);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGGElement::s_info);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGGElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGGElement* castedThis = jsCast<JSSVGGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGGElement::s_info);
    SVGGElement* impl = static_cast<SVGGElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
