/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSJavaScriptCallFrame_h
#define JSJavaScriptCallFrame_h

#if ENABLE(JAVASCRIPT_DEBUGGER)

#include "JSDOMBinding.h"
#include "JavaScriptCallFrame.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSJavaScriptCallFrame : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSJavaScriptCallFrame* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<JavaScriptCallFrame> impl)
    {
        JSJavaScriptCallFrame* ptr = new (NotNull, JSC::allocateCell<JSJavaScriptCallFrame>(globalObject->globalData().heap)) JSJavaScriptCallFrame(structure, globalObject, impl);
        ptr->finishCreation(globalObject->globalData());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void destroy(JSC::JSCell*);
    ~JSJavaScriptCallFrame();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }


    // Custom attributes
    JSC::JSValue scopeChain(JSC::ExecState*) const;
    JSC::JSValue thisObject(JSC::ExecState*) const;
    JSC::JSValue type(JSC::ExecState*) const;

    // Custom functions
    JSC::JSValue evaluate(JSC::ExecState*);
    JSC::JSValue restart(JSC::ExecState*);
    JSC::JSValue setVariableValue(JSC::ExecState*);
    JSC::JSValue scopeType(JSC::ExecState*);
    JavaScriptCallFrame* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull() { if (m_impl) { m_impl->deref(); m_impl = 0; } }

private:
    JavaScriptCallFrame* m_impl;
protected:
    JSJavaScriptCallFrame(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<JavaScriptCallFrame>);
    void finishCreation(JSC::JSGlobalData&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | Base::StructureFlags;
};

class JSJavaScriptCallFrameOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, JavaScriptCallFrame*)
{
    DEFINE_STATIC_LOCAL(JSJavaScriptCallFrameOwner, jsJavaScriptCallFrameOwner, ());
    return &jsJavaScriptCallFrameOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, JavaScriptCallFrame*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, JavaScriptCallFrame*);
JavaScriptCallFrame* toJavaScriptCallFrame(JSC::JSValue);

class JSJavaScriptCallFramePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSJavaScriptCallFramePrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSJavaScriptCallFramePrototype* ptr = new (NotNull, JSC::allocateCell<JSJavaScriptCallFramePrototype>(globalData.heap)) JSJavaScriptCallFramePrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSJavaScriptCallFramePrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionEvaluate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionRestart(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionSetVariableValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionScopeType(JSC::ExecState*);
// Attributes

JSC::JSValue jsJavaScriptCallFrameCaller(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameSourceID(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameLine(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameColumn(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameScopeChain(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameThisObject(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameFunctionName(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameType(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
// Constants

JSC::JSValue jsJavaScriptCallFrameGLOBAL_SCOPE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameLOCAL_SCOPE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameWITH_SCOPE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameCLOSURE_SCOPE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsJavaScriptCallFrameCATCH_SCOPE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#endif
