/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPolylineElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGPointList.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGPointList.h"
#include "SVGPolylineElement.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPolylineElementTableValues[] =
{
    { "points", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementPoints), (intptr_t)0, NoIntrinsic },
    { "animatedPoints", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementAnimatedPoints), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementXmllang), (intptr_t)setJSSVGPolylineElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementXmlspace), (intptr_t)setJSSVGPolylineElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPolylineElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPolylineElementTable = { 34, 31, JSSVGPolylineElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPolylineElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPolylineElementConstructorTable = { 1, 0, JSSVGPolylineElementConstructorTableValues, 0 };
const ClassInfo JSSVGPolylineElementConstructor::s_info = { "SVGPolylineElementConstructor", &Base::s_info, &JSSVGPolylineElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPolylineElementConstructor) };

JSSVGPolylineElementConstructor::JSSVGPolylineElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPolylineElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGPolylineElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGPolylineElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPolylineElementConstructor, JSDOMWrapper>(exec, &JSSVGPolylineElementConstructorTable, jsCast<JSSVGPolylineElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGPolylineElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPolylineElementConstructor, JSDOMWrapper>(exec, &JSSVGPolylineElementConstructorTable, jsCast<JSSVGPolylineElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPolylineElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolylineElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolylineElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolylineElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolylineElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPolylineElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPolylineElementPrototypeTable = { 17, 15, JSSVGPolylineElementPrototypeTableValues, 0 };
const ClassInfo JSSVGPolylineElementPrototype::s_info = { "SVGPolylineElementPrototype", &Base::s_info, &JSSVGPolylineElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPolylineElementPrototype) };

JSObject* JSSVGPolylineElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPolylineElement>(exec, globalObject);
}

bool JSSVGPolylineElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPolylineElementPrototype* thisObject = jsCast<JSSVGPolylineElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPolylineElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGPolylineElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPolylineElementPrototype* thisObject = jsCast<JSSVGPolylineElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPolylineElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGPolylineElement::s_info = { "SVGPolylineElement", &Base::s_info, &JSSVGPolylineElementTable, 0 , CREATE_METHOD_TABLE(JSSVGPolylineElement) };

JSSVGPolylineElement::JSSVGPolylineElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPolylineElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGPolylineElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPolylineElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPolylineElementPrototype::create(exec->globalData(), globalObject, JSSVGPolylineElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGPolylineElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPolylineElement* thisObject = jsCast<JSSVGPolylineElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPolylineElement, Base>(exec, &JSSVGPolylineElementTable, thisObject, propertyName, slot);
}

bool JSSVGPolylineElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPolylineElement* thisObject = jsCast<JSSVGPolylineElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPolylineElement, Base>(exec, &JSSVGPolylineElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPolylineElementPoints(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->points()));
    return result;
}


JSValue jsSVGPolylineElementAnimatedPoints(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->animatedPoints()));
    return result;
}


JSValue jsSVGPolylineElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGPolylineElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGPolylineElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGPolylineElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGPolylineElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGPolylineElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGPolylineElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGPolylineElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGPolylineElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGPolylineElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPolylineElement* domObject = jsCast<JSSVGPolylineElement*>(asObject(slotBase));
    return JSSVGPolylineElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGPolylineElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGPolylineElement* thisObject = jsCast<JSSVGPolylineElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGPolylineElement, Base>(exec, propertyName, value, &JSSVGPolylineElementTable, thisObject, slot);
}

void setJSSVGPolylineElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(thisObject);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGPolylineElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(thisObject);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGPolylineElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPolylineElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolylineElement::s_info);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolylineElement::s_info);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolylineElement::s_info);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolylineElement::s_info);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPolylineElement* castedThis = jsCast<JSSVGPolylineElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPolylineElement::s_info);
    SVGPolylineElement* impl = static_cast<SVGPolylineElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
