/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEFloodElement.h"

#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEFloodElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEFloodElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEFloodElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEFloodElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEFloodElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEFloodElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEFloodElementResult), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEFloodElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEFloodElementTable = { 17, 15, JSSVGFEFloodElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEFloodElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEFloodElementConstructorTable = { 1, 0, JSSVGFEFloodElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEFloodElementConstructor::s_info = { "SVGFEFloodElementConstructor", &Base::s_info, &JSSVGFEFloodElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEFloodElementConstructor) };

JSSVGFEFloodElementConstructor::JSSVGFEFloodElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEFloodElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFEFloodElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFEFloodElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEFloodElementConstructor, JSDOMWrapper>(exec, &JSSVGFEFloodElementConstructorTable, jsCast<JSSVGFEFloodElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEFloodElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEFloodElementConstructor, JSDOMWrapper>(exec, &JSSVGFEFloodElementConstructorTable, jsCast<JSSVGFEFloodElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEFloodElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEFloodElementPrototypeTable = { 1, 0, JSSVGFEFloodElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEFloodElementPrototype::s_info = { "SVGFEFloodElementPrototype", &Base::s_info, &JSSVGFEFloodElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEFloodElementPrototype) };

JSObject* JSSVGFEFloodElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEFloodElement>(exec, globalObject);
}

const ClassInfo JSSVGFEFloodElement::s_info = { "SVGFEFloodElement", &Base::s_info, &JSSVGFEFloodElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEFloodElement) };

JSSVGFEFloodElement::JSSVGFEFloodElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEFloodElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGFEFloodElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEFloodElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEFloodElementPrototype::create(exec->globalData(), globalObject, JSSVGFEFloodElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEFloodElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEFloodElement* thisObject = jsCast<JSSVGFEFloodElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEFloodElement, Base>(exec, &JSSVGFEFloodElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEFloodElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEFloodElement* thisObject = jsCast<JSSVGFEFloodElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEFloodElement, Base>(exec, &JSSVGFEFloodElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEFloodElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEFloodElement* castedThis = jsCast<JSSVGFEFloodElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEFloodElement* impl = static_cast<SVGFEFloodElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEFloodElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEFloodElement* castedThis = jsCast<JSSVGFEFloodElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEFloodElement* impl = static_cast<SVGFEFloodElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEFloodElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEFloodElement* castedThis = jsCast<JSSVGFEFloodElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEFloodElement* impl = static_cast<SVGFEFloodElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEFloodElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEFloodElement* castedThis = jsCast<JSSVGFEFloodElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEFloodElement* impl = static_cast<SVGFEFloodElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEFloodElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEFloodElement* castedThis = jsCast<JSSVGFEFloodElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEFloodElement* impl = static_cast<SVGFEFloodElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEFloodElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEFloodElement* domObject = jsCast<JSSVGFEFloodElement*>(asObject(slotBase));
    return JSSVGFEFloodElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEFloodElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEFloodElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
