/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLStyleElement.h"

#include "HTMLNames.h"
#include "HTMLStyleElement.h"
#include "JSStyleSheet.h"
#include "KURL.h"
#include "StyleSheet.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLStyleElementTableValues[] =
{
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLStyleElementDisabled), (intptr_t)setJSHTMLStyleElementDisabled, NoIntrinsic },
#if ENABLE(STYLE_SCOPED)
    { "scoped", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLStyleElementScoped), (intptr_t)setJSHTMLStyleElementScoped, NoIntrinsic },
#endif
    { "media", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLStyleElementMedia), (intptr_t)setJSHTMLStyleElementMedia, NoIntrinsic },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLStyleElementType), (intptr_t)setJSHTMLStyleElementType, NoIntrinsic },
    { "sheet", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLStyleElementSheet), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLStyleElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLStyleElementTable = { 17, 15, JSHTMLStyleElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLStyleElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLStyleElementConstructorTable = { 1, 0, JSHTMLStyleElementConstructorTableValues, 0 };
const ClassInfo JSHTMLStyleElementConstructor::s_info = { "HTMLStyleElementConstructor", &Base::s_info, &JSHTMLStyleElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLStyleElementConstructor) };

JSHTMLStyleElementConstructor::JSHTMLStyleElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLStyleElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLStyleElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLStyleElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLStyleElementConstructor, JSDOMWrapper>(exec, &JSHTMLStyleElementConstructorTable, jsCast<JSHTMLStyleElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLStyleElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLStyleElementConstructor, JSDOMWrapper>(exec, &JSHTMLStyleElementConstructorTable, jsCast<JSHTMLStyleElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLStyleElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLStyleElementPrototypeTable = { 1, 0, JSHTMLStyleElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLStyleElementPrototype::s_info = { "HTMLStyleElementPrototype", &Base::s_info, &JSHTMLStyleElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLStyleElementPrototype) };

JSObject* JSHTMLStyleElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLStyleElement>(exec, globalObject);
}

const ClassInfo JSHTMLStyleElement::s_info = { "HTMLStyleElement", &Base::s_info, &JSHTMLStyleElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLStyleElement) };

JSHTMLStyleElement::JSHTMLStyleElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLStyleElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLStyleElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLStyleElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLStyleElementPrototype::create(exec->globalData(), globalObject, JSHTMLStyleElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLStyleElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLStyleElement* thisObject = jsCast<JSHTMLStyleElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLStyleElement, Base>(exec, &JSHTMLStyleElementTable, thisObject, propertyName, slot);
}

bool JSHTMLStyleElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLStyleElement* thisObject = jsCast<JSHTMLStyleElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLStyleElement, Base>(exec, &JSHTMLStyleElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLStyleElementDisabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLStyleElement* castedThis = jsCast<JSHTMLStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLStyleElement* impl = static_cast<HTMLStyleElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->disabled());
    return result;
}


#if ENABLE(STYLE_SCOPED)
JSValue jsHTMLStyleElementScoped(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLStyleElement* castedThis = jsCast<JSHTMLStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLStyleElement* impl = static_cast<HTMLStyleElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->scoped());
    return result;
}

#endif

JSValue jsHTMLStyleElementMedia(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLStyleElement* castedThis = jsCast<JSHTMLStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLStyleElement* impl = static_cast<HTMLStyleElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::mediaAttr));
    return result;
}


JSValue jsHTMLStyleElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLStyleElement* castedThis = jsCast<JSHTMLStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLStyleElement* impl = static_cast<HTMLStyleElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::typeAttr));
    return result;
}


JSValue jsHTMLStyleElementSheet(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLStyleElement* castedThis = jsCast<JSHTMLStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLStyleElement* impl = static_cast<HTMLStyleElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->sheet()));
    return result;
}


JSValue jsHTMLStyleElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLStyleElement* domObject = jsCast<JSHTMLStyleElement*>(asObject(slotBase));
    return JSHTMLStyleElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLStyleElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLStyleElement* thisObject = jsCast<JSHTMLStyleElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLStyleElement, Base>(exec, propertyName, value, &JSHTMLStyleElementTable, thisObject, slot);
}

void setJSHTMLStyleElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLStyleElement* castedThis = jsCast<JSHTMLStyleElement*>(thisObject);
    HTMLStyleElement* impl = static_cast<HTMLStyleElement*>(castedThis->impl());
    impl->setDisabled(value.toBoolean(exec));
}


#if ENABLE(STYLE_SCOPED)
void setJSHTMLStyleElementScoped(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLStyleElement* castedThis = jsCast<JSHTMLStyleElement*>(thisObject);
    HTMLStyleElement* impl = static_cast<HTMLStyleElement*>(castedThis->impl());
    impl->setScoped(value.toBoolean(exec));
}

#endif

void setJSHTMLStyleElementMedia(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLStyleElement* castedThis = jsCast<JSHTMLStyleElement*>(thisObject);
    HTMLStyleElement* impl = static_cast<HTMLStyleElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::mediaAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLStyleElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLStyleElement* castedThis = jsCast<JSHTMLStyleElement*>(thisObject);
    HTMLStyleElement* impl = static_cast<HTMLStyleElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::typeAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLStyleElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLStyleElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
