/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSRuleList.h"

#include "CSSRule.h"
#include "CSSRuleList.h"
#include "ExceptionCode.h"
#include "JSCSSRule.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSRuleListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSRuleListTable = { 5, 3, JSCSSRuleListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSRuleListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSRuleListConstructorTable = { 1, 0, JSCSSRuleListConstructorTableValues, 0 };
const ClassInfo JSCSSRuleListConstructor::s_info = { "CSSRuleListConstructor", &Base::s_info, &JSCSSRuleListConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSRuleListConstructor) };

JSCSSRuleListConstructor::JSCSSRuleListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSRuleListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCSSRuleListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSRuleListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSRuleListConstructor, JSDOMWrapper>(exec, &JSCSSRuleListConstructorTable, jsCast<JSCSSRuleListConstructor*>(cell), propertyName, slot);
}

bool JSCSSRuleListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSRuleListConstructor, JSDOMWrapper>(exec, &JSCSSRuleListConstructorTable, jsCast<JSCSSRuleListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSRuleListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSRuleListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSRuleListPrototypeTable = { 2, 1, JSCSSRuleListPrototypeTableValues, 0 };
const ClassInfo JSCSSRuleListPrototype::s_info = { "CSSRuleListPrototype", &Base::s_info, &JSCSSRuleListPrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSRuleListPrototype) };

JSObject* JSCSSRuleListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSRuleList>(exec, globalObject);
}

bool JSCSSRuleListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSRuleListPrototype* thisObject = jsCast<JSCSSRuleListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSRuleListPrototypeTable, thisObject, propertyName, slot);
}

bool JSCSSRuleListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSRuleListPrototype* thisObject = jsCast<JSCSSRuleListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCSSRuleListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCSSRuleList::s_info = { "CSSRuleList", &Base::s_info, &JSCSSRuleListTable, 0 , CREATE_METHOD_TABLE(JSCSSRuleList) };

JSCSSRuleList::JSCSSRuleList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSRuleList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSCSSRuleList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSRuleList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSRuleListPrototype::create(exec->globalData(), globalObject, JSCSSRuleListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSCSSRuleList::destroy(JSC::JSCell* cell)
{
    JSCSSRuleList* thisObject = static_cast<JSCSSRuleList*>(cell);
    thisObject->JSCSSRuleList::~JSCSSRuleList();
}

JSCSSRuleList::~JSCSSRuleList()
{
    releaseImplIfNotNull();
}

bool JSCSSRuleList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSRuleList* thisObject = jsCast<JSCSSRuleList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSCSSRuleList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<CSSRuleList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSCSSRuleList, Base>(exec, &JSCSSRuleListTable, thisObject, propertyName, slot);
}

bool JSCSSRuleList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSRuleList* thisObject = jsCast<JSCSSRuleList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSCSSRuleListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<CSSRuleList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSCSSRuleList, Base>(exec, &JSCSSRuleListTable, thisObject, propertyName, descriptor);
}

bool JSCSSRuleList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSCSSRuleList* thisObject = jsCast<JSCSSRuleList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<CSSRuleList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsCSSRuleListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSRuleList* castedThis = jsCast<JSCSSRuleList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSRuleList* impl = static_cast<CSSRuleList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsCSSRuleListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSRuleList* domObject = jsCast<JSCSSRuleList*>(asObject(slotBase));
    return JSCSSRuleList::getConstructor(exec, domObject->globalObject());
}

void JSCSSRuleList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSCSSRuleList* thisObject = jsCast<JSCSSRuleList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<CSSRuleList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSCSSRuleList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSRuleListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSRuleListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSRuleList::s_info))
        return throwVMTypeError(exec);
    JSCSSRuleList* castedThis = jsCast<JSCSSRuleList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSRuleList::s_info);
    CSSRuleList* impl = static_cast<CSSRuleList*>(castedThis->impl());
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSCSSRuleList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSCSSRuleList* thisObj = jsCast<JSCSSRuleList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<CSSRuleList*>(thisObj->impl())->item(index));
}

void JSCSSRuleListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSCSSRuleList* jsCSSRuleList = jsCast<JSCSSRuleList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCSSRuleList->impl(), jsCSSRuleList);
    jsCSSRuleList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, CSSRuleList* impl)
{
    return wrap<JSCSSRuleList>(exec, globalObject, impl);
}

CSSRuleList* toCSSRuleList(JSC::JSValue value)
{
    return value.inherits(&JSCSSRuleList::s_info) ? jsCast<JSCSSRuleList*>(asObject(value))->impl() : 0;
}

}
