#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>
#include <string.h>
#include <sys/errno.h>

void *test (void *arg);

int
main (int argc, char *argv[])
{
  int err;
  pthread_t thread;
  void *threadrv;

  if ((err = pthread_create (&thread, NULL, test, NULL)) != 0)
    {
      printf ("Error on pthread_create %d:%s\n", err, strerror (err));
      exit (1);
    }

  if ((err = pthread_join (thread, &threadrv)) != 0)
    {
      printf ("Error on pthread_join %d:%s\n", err, strerror (err));
      exit (1);
    }
  return 0;
}

void *
test (void *arg)
{
  int pid;

  pid = fork ();
  if (pid < 0)
    {
      printf ("FORKFAILED\n");
    }
  else if (pid == 0)
    {
      printf ("FORKCHILD: mypid=%d\n", getpid ());
    }
  else
    {
      printf ("FORKPARENT: mypid=%d childpid=%d\n", getpid (), pid);
    }
}

