/* ======================================================= *
 * Copyright 1998-2005 Stephen C. Grubb                    *
 * http://ploticus.sourceforge.net                         *
 * Covered by GPL; see the file ./Copyright for details.   *
 * ======================================================= */

/* PROC VENN - render a venn diagram */

#include "pl.h"

#define TWOPI 6.2831854
#define HALFPI 1.5707963
#define PI 3.141592653589793238462643

extern double GL_rand();
extern int PLG_circle();

int
PLP_venndisk()
{
int i, j;
char attr[NAMEMAXLEN], val[256];
char *line, *lineval;
int first, nt, lvp;
double x, y, area, radius;
char color[COLORLEN];
char label[128];
double dotx, doty, dx, dy, sqrt();
int ndots;
double densfact;
char outline[128];
double ofs;

TDH_errprog( "pl proc venn" );

x = y = area = -1.0;
densfact = 1.0;
strcpy( label, "" );
strcpy( color, "red" );
strcpy( outline, "" );
ofs = 0.0;

/* get attributes.. */

first = 1;
while( 1 ) {
	line = getnextattr( first, attr, val, &lvp, &nt );
	if( line == NULL ) break;
	first = 0;
	lineval = &line[lvp];

	if( stricmp( attr, "location" )==0 ) getcoords( "location", lineval, &x, &y );
	else if( stricmp( attr, "area" )==0 ) area = atof( val );        /* square inches */
	else if( stricmp( attr, "color" )==0 ) strcpy( color, val );
	else if( stricmp( attr, "label" )==0 ) strcpy( label, lineval );
	else if( stricmp( attr, "density" )==0 ) densfact = atof( val );
	else if( stricmp( attr, "outline" )==0 ) strcpy( outline, lineval );
	else if( stricmp( attr, "dotsize" )==0 ) ofs = atof( val );

	else Eerr( 1, "attribute not recognized", attr );
	}


if( x < 0.0 || y < 0.0 || area < 0.0 ) return( Eerr( 428, "The attributes x, y, and area must all be specified", "" ) );


/* now do the plotting work.. */

/* convert area to a radius in inches.. */
radius = sqrt( area / PI );
if( PLS.usingcm ) { x /= 2.54; y /= 2.54; ofs /= 2.54; radius /= 2.54; }
area = PI * radius * radius;  /* standardize area into square inches.. we'll use it for dot density */

ndots = (int)(area * 2000 * densfact);

sprintf( val, "color=%s width=0.3", color );
linedet( "dots", val, 1.0 );

if( Edev == 's' && ofs == 0.0 ) ofs = 0.008;
if( densfact > 0.0 ) 
     for( i = 0; i < ndots; i++ ) {
	/* random location of candidate dot.. */
	dotx = x - radius + (GL_rand() * radius * 2);
	doty = y - radius + (GL_rand() * radius * 2);
	
	/* if dot is outside the disk skip it.. */
	dx = fabs( dotx - x );
        dy = fabs( doty - y );
	if( sqrt( (dx*dx) + (dy*dy) ) > (radius-ofs) ) continue;

	if( ofs == 0.0 ) { Emov( dotx, doty ); Elin( dotx, doty+ofs ); }
	else	{   /* randomized tiny line segment direction.. */
		j = (int) (GL_rand() * 3.0);
		if( j == 0 ) { Emov( dotx, doty ); Elin( dotx, doty+ofs ); }
		else if( j == 1 ) { Emov( dotx, doty ); Elin( dotx+ofs, doty+ofs ); }
		else if( j == 2 ) { Emov( dotx, doty ); Elin( dotx+ofs, doty-ofs ); }
		}
	}

if( stricmp( outline, "no" ) != 0 ) {
	if( stricmp( outline, "yes" )==0 ) strcpy( outline, "" ); 
	if( ! GL_slmember( outline, "*color=" )) { sprintf( val, " color=%s ", color ); strcat( outline, val ); }
	linedet( "outline", outline, 0.3 );
	PLG_circle( x, y, radius, "", 1, 60 );
	}

if( label[0] != '\0' ) PL_add_legent( LEGEND_COLOR, label, "", color, "", "" );

return( 0 );
}

/* ======================================================= *
 * Copyright 1998-2005 Stephen C. Grubb                    *
 * http://ploticus.sourceforge.net                         *
 * Covered by GPL; see the file ./Copyright for details.   *
 * ======================================================= */
