// This file is auto-generated. Do not edit!

#include "precomp.hpp"
#include "opencl_kernels.hpp"

namespace cv
{
namespace ocl
{
const struct ProgramEntry arithm_LUT={"arithm_LUT",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void LUT_C1( __global const srcT * src, __global const dstT *lut,\n"
"__global dstT *dst,\n"
"int cols1, int rows,\n"
"int src_offset1,\n"
"int lut_offset1,\n"
"int dst_offset1,\n"
"int src_step1, int dst_step1)\n"
"{\n"
"int x1 = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x1 < cols1 && y < rows)\n"
"{\n"
"int src_index = mad24(y, src_step1, src_offset1 + x1);\n"
"int dst_index = mad24(y, dst_step1, dst_offset1 + x1);\n"
"dst[dst_index] = lut[lut_offset1 + src[src_index]];\n"
"}\n"
"}\n"
"__kernel void LUT_C2( __global const srcT * src, __global const dstT *lut,\n"
"__global dstT *dst,\n"
"int cols1, int rows,\n"
"int src_offset1,\n"
"int lut_offset1,\n"
"int dst_offset1,\n"
"int src_step1, int dst_step1)\n"
"{\n"
"int x1 = get_global_id(0) << 1;\n"
"int y = get_global_id(1);\n"
"if (x1 < cols1 && y < rows)\n"
"{\n"
"int src_index = mad24(y, src_step1, src_offset1 + x1);\n"
"int dst_index = mad24(y, dst_step1, dst_offset1 + x1);\n"
"dst[dst_index    ] =                  lut[lut_offset1 + (src[src_index    ] << 1)    ];\n"
"dst[dst_index + 1] = x1 + 1 < cols1 ? lut[lut_offset1 + (src[src_index + 1] << 1) + 1] : dst[dst_index + 1];\n"
"}\n"
"}\n"
"__kernel void LUT_C4( __global const srcT * src, __global const dstT *lut,\n"
"__global dstT *dst,\n"
"int cols1, int rows,\n"
"int src_offset1,\n"
"int lut_offset1,\n"
"int dst_offset1,\n"
"int src_step1, int dst_step1)\n"
"{\n"
"int x1 = get_global_id(0) << 2;\n"
"int y = get_global_id(1);\n"
"if (x1 < cols1 && y < rows)\n"
"{\n"
"int src_index = mad24(y, src_step1, src_offset1 + x1);\n"
"int dst_index = mad24(y, dst_step1, dst_offset1 + x1);\n"
"dst[dst_index    ] =                  lut[lut_offset1 + (src[src_index    ] << 2)    ];\n"
"dst[dst_index + 1] = x1 + 1 < cols1 ? lut[lut_offset1 + (src[src_index + 1] << 2) + 1] : dst[dst_index + 1];\n"
"dst[dst_index + 2] = x1 + 2 < cols1 ? lut[lut_offset1 + (src[src_index + 2] << 2) + 2] : dst[dst_index + 2];\n"
"dst[dst_index + 3] = x1 + 3 < cols1 ? lut[lut_offset1 + (src[src_index + 3] << 2) + 3] : dst[dst_index + 3];\n"
"}\n"
"}\n"
, "afd02da735fe96c1be560841a0616208"};
const struct ProgramEntry arithm_absdiff_nonsaturate={"arithm_absdiff_nonsaturate",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#ifdef BINARY\n"
"__kernel void arithm_absdiff_nonsaturate_binary(__global srcT *src1, int src1_step, int src1_offset,\n"
"__global srcT *src2, int src2_step, int src2_offset,\n"
"__global dstT *dst, int dst_step, int dst_offset,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset);\n"
"int dst_index  = mad24(y, dst_step, x + dst_offset);\n"
"#ifdef INTEL_DEVICE\n"
"if(src1_index >= 0 && src2_index >= 0)\n"
"#endif\n"
"{\n"
"dstT t0 = convertToDstT(src1[src1_index]);\n"
"dstT t1 = convertToDstT(src2[src2_index]);\n"
"dstT t2 = t0 - t1;\n"
"dst[dst_index] = t2 >= (dstT)(0) ? t2 : -t2;\n"
"}\n"
"}\n"
"}\n"
"#else\n"
"__kernel void arithm_absdiff_nonsaturate(__global srcT *src1, int src1_step, int src1_offset,\n"
"__global dstT *dst, int dst_step, int dst_offset,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int dst_index  = mad24(y, dst_step, x + dst_offset);\n"
"#ifdef INTEL_DEVICE\n"
"if(src1_index >= 0)\n"
"#endif\n"
"{\n"
"dstT t0 = convertToDstT(src1[src1_index]);\n"
"dst[dst_index] = t0 >= (dstT)(0) ? t0 : -t0;\n"
"}\n"
"}\n"
"}\n"
"#endif\n"
, "3f15259dde8b84d419a8748dead572f0"};
const struct ProgramEntry arithm_add={"arithm_add",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#if defined (FUNC_ADD)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) + convertToWT(src2[src2_index]));\n"
"#endif\n"
"#if defined (FUNC_SUB)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) - convertToWT(src2[src2_index]));\n"
"#endif\n"
"#if defined (FUNC_MUL)\n"
"#if defined (HAVE_SCALAR)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) * scalar * convertToWT(src2[src2_index]));\n"
"#else\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) * convertToWT(src2[src2_index]));\n"
"#endif\n"
"#endif\n"
"#if defined (FUNC_DIV)\n"
"#if defined (HAVE_SCALAR)\n"
"#define EXPRESSION T zero = (T)(0); \\\n"
"dst[dst_index] = src2[src2_index] == zero ? zero : \\\n"
"convertToT(convertToWT(src1[src1_index]) * scalar / convertToWT(src2[src2_index]));\n"
"#else\n"
"#define EXPRESSION T zero = (T)(0); \\\n"
"dst[dst_index] = src2[src2_index] == zero ? zero : \\\n"
"convertToT(convertToWT(src1[src1_index]) / convertToWT(src2[src2_index]));\n"
"#endif\n"
"#endif\n"
"#if defined (FUNC_ABS_DIFF)\n"
"#define EXPRESSION WT value = convertToWT(src1[src1_index]) - convertToWT(src2[src2_index]); \\\n"
"value = value > (WT)(0) ? value : -value; \\\n"
"dst[dst_index] = convertToT(value);\n"
"#endif\n"
"#if defined (FUNC_MIN)\n"
"#define EXPRESSION dst[dst_index] = min( src1[src1_index], src2[src2_index] );\n"
"#endif\n"
"#if defined (FUNC_MAX)\n"
"#define EXPRESSION dst[dst_index] = max( src1[src1_index], src2[src2_index] );\n"
"#endif\n"
"#ifndef HAVE_SCALAR\n"
"__kernel void arithm_binary_op_mat(__global T *src1, int src1_step, int src1_offset,\n"
"__global T *src2, int src2_step, int src2_offset,\n"
"__global T *dst, int dst_step, int dst_offset,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset);\n"
"int dst_index  = mad24(y, dst_step, x + dst_offset);\n"
"EXPRESSION\n"
"}\n"
"}\n"
"#else\n"
"__kernel void arithm_binary_op_mat_scalar(__global T *src1, int src1_step, int src1_offset,\n"
"__global T *src2, int src2_step, int src2_offset,\n"
"WT scalar,\n"
"__global T *dst, int dst_step,  int dst_offset,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset);\n"
"int dst_index = mad24(y, dst_step, x + dst_offset);\n"
"EXPRESSION\n"
"}\n"
"}\n"
"#endif\n"
, "6fd43f6cf03580fec25aef52bea680a2"};
const struct ProgramEntry arithm_addWeighted={"arithm_addWeighted",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void addWeighted(__global T * src1, int src1_step1, int src1_offset1,\n"
"__global T * src2, int src2_step1, int src2_offset1,\n"
"__global T * dst, int dst_step1, int dst_offset1,\n"
"WT alpha, WT beta, WT gama,\n"
"int cols1, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols1 && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step1, x + src1_offset1);\n"
"int src2_index = mad24(y, src2_step1, x + src2_offset1);\n"
"int dst_index = mad24(y, dst_step1, x + dst_offset1);\n"
"dst[dst_index] = convertToT(src1[src1_index]*alpha + src2[src2_index]*beta + gama);\n"
"}\n"
"}\n"
, "8ef56ec47d035ad8ba7181337797571e"};
const struct ProgramEntry arithm_add_mask={"arithm_add_mask",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#if defined (FUNC_ADD)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) + convertToWT(src2[src2_index]));\n"
"#endif\n"
"#if defined (FUNC_SUB)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) - convertToWT(src2[src2_index]));\n"
"#endif\n"
"#if defined (FUNC_MUL)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) * convertToWT(src2[src2_index]));\n"
"#endif\n"
"#if defined (FUNC_DIV)\n"
"#define EXPRESSION T zero = (T)(0); \\\n"
"dst[dst_index] = src2[src2_index] == zero ? zero : \\\n"
"convertToT(convertToWT(src1[src1_index]) / convertToWT(src2[src2_index]));\n"
"#endif\n"
"__kernel void arithm_binary_op_mat_mask(__global T * src1, int src1_step, int src1_offset,\n"
"__global T * src2, int src2_step, int src2_offset,\n"
"__global uchar * mask, int mask_step, int mask_offset,\n"
"__global T * dst, int dst_step, int dst_offset,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int mask_index = mad24(y, mask_step, x + mask_offset);\n"
"if (mask[mask_index])\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset);\n"
"int dst_index  = mad24(y, dst_step, dst_offset + x);\n"
"EXPRESSION\n"
"}\n"
"}\n"
"}\n"
, "6f293dea131291749c2be083eafe6839"};
const struct ProgramEntry arithm_add_scalar={"arithm_add_scalar",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#if defined (FUNC_ADD)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) + scalar);\n"
"#endif\n"
"#if defined (FUNC_SUB)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) - scalar);\n"
"#endif\n"
"#if defined (FUNC_MUL)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) * scalar);\n"
"#endif\n"
"#if defined (FUNC_DIV)\n"
"#define EXPRESSION T zero = (T)(0); \\\n"
"dst[dst_index] = src1[src1_index] == zero ? zero : convertToT(scalar / convertToWT(src1[src1_index]));\n"
"#endif\n"
"#if defined (FUNC_ABS)\n"
"#define EXPRESSION \\\n"
"T value = src1[src1_index] > (T)(0) ? src1[src1_index] : -src1[src1_index]; \\\n"
"dst[dst_index] = value;\n"
"#endif\n"
"#if defined (FUNC_ABS_DIFF)\n"
"#define EXPRESSION WT value = convertToWT(src1[src1_index]) - scalar; \\\n"
"value = value > (WT)(0) ? value : -value; \\\n"
"dst[dst_index] = convertToT(value);\n"
"#endif\n"
"__kernel void arithm_binary_op_scalar (__global T *src1, int src1_step, int src1_offset,\n"
"WT scalar,\n"
"__global T *dst,  int dst_step,  int dst_offset,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int dst_index = mad24(y, dst_step, x + dst_offset);\n"
"EXPRESSION\n"
"}\n"
"}\n"
, "247f201b03d2ae30ab341fefb9d8bf9f"};
const struct ProgramEntry arithm_add_scalar_mask={"arithm_add_scalar_mask",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#if defined (FUNC_ADD)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) + scalar);\n"
"#endif\n"
"#if defined (FUNC_SUB)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) - scalar);\n"
"#endif\n"
"#if defined (FUNC_MUL)\n"
"#define EXPRESSION dst[dst_index] = convertToT(convertToWT(src1[src1_index]) * scalar);\n"
"#endif\n"
"#if defined (FUNC_DIV)\n"
"#define EXPRESSION T zero = (T)(0); \\\n"
"dst[dst_index] = src2[src2_index] == zero ? zero : \\\n"
"convertToT(convertToWT(src1[src1_index]) / scalar[0]);\n"
"#endif\n"
"__kernel void arithm_binary_op_scalar_mask(__global T *src1, int src1_step, int src1_offset,\n"
"WT scalar,\n"
"__global uchar *mask, int mask_step, int mask_offset,\n"
"__global T *dst,  int dst_step,  int dst_offset,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int mask_index = mad24(y, mask_step, x + mask_offset);\n"
"if (mask[mask_index])\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int dst_index = mad24(y, dst_step, dst_offset + x);\n"
"EXPRESSION\n"
"}\n"
"}\n"
"}\n"
, "8288be1429ee6b66e7cf0c2a3afa9028"};
const struct ProgramEntry arithm_bitwise={"arithm_bitwise",
"__kernel void arithm_bitwise(__global uchar * src1ptr, int src1_step, int src1_offset,\n"
"#ifdef OP_BINARY\n"
"__global uchar * src2ptr, int src2_step, int src2_offset,\n"
"#elif defined HAVE_SCALAR\n"
"T scalar,\n"
"#endif\n"
"#ifdef HAVE_MASK\n"
"__global uchar * mask, int mask_step, int mask_offset,\n"
"#endif\n"
"__global uchar * dstptr, int dst_step, int dst_offset, int dst_rows, int dst_cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"#ifdef HAVE_MASK\n"
"mask += mad24(y, mask_step, x + mask_offset);\n"
"if (mask[0])\n"
"#endif\n"
"{\n"
"int src1_index = mad24(y, src1_step, mad24(x, (int)sizeof(T), src1_offset));\n"
"#ifdef OP_BINARY\n"
"int src2_index = mad24(y, src2_step, mad24(x, (int)sizeof(T), src2_offset));\n"
"#endif\n"
"int dst_index = mad24(y, dst_step, mad24(x, (int)sizeof(T), dst_offset));\n"
"__global const T * src1 = (__global const T *)(src1ptr + src1_index);\n"
"#ifdef OP_BINARY\n"
"__global const T * src2 = (__global const T *)(src2ptr + src2_index);\n"
"#endif\n"
"__global T * dst = (__global T *)(dstptr + dst_index);\n"
"#ifdef OP_BINARY\n"
"dst[0] = src1[0] Operation src2[0];\n"
"#elif defined HAVE_SCALAR\n"
"dst[0] = src1[0] Operation scalar;\n"
"#else\n"
"dst[0] = Operation src1[0];\n"
"#endif\n"
"}\n"
"}\n"
"}\n"
, "7dfc3e052a5289cb3de59d38f374d10d"};
const struct ProgramEntry arithm_cartToPolar={"arithm_cartToPolar",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define CV_PI M_PI\n"
"#else\n"
"#define CV_PI M_PI_F\n"
"#endif\n"
"__kernel void arithm_cartToPolar_D5 (__global float *src1, int src1_step, int src1_offset,\n"
"__global float *src2, int src2_step, int src2_offset,\n"
"__global float *dst1, int dst1_step, int dst1_offset,\n"
"__global float *dst2, int dst2_step, int dst2_offset,\n"
"int rows, int cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset);\n"
"int dst1_index = mad24(y, dst1_step, x + dst1_offset);\n"
"int dst2_index = mad24(y, dst2_step, x + dst2_offset);\n"
"float x = src1[src1_index];\n"
"float y = src2[src2_index];\n"
"float x2 = x * x;\n"
"float y2 = y * y;\n"
"float magnitude = sqrt(x2 + y2);\n"
"float tmp = y >= 0 ? 0 : CV_PI*2;\n"
"tmp = x < 0 ? CV_PI : tmp;\n"
"float tmp1 = y >= 0 ? CV_PI*0.5f : CV_PI*1.5f;\n"
"float cartToPolar = y2 <= x2 ? x*y/(x2 + 0.28f*y2 + FLT_EPSILON) + tmp :\n"
"tmp1 - x*y/(y2 + 0.28f*x2 + FLT_EPSILON);\n"
"#ifdef DEGREE\n"
"cartToPolar *= (180/CV_PI);\n"
"#endif\n"
"dst1[dst1_index] = magnitude;\n"
"dst2[dst2_index] = cartToPolar;\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void arithm_cartToPolar_D6 (__global double *src1, int src1_step, int src1_offset,\n"
"__global double *src2, int src2_step, int src2_offset,\n"
"__global double *dst1, int dst1_step, int dst1_offset,\n"
"__global double *dst2, int dst2_step, int dst2_offset,\n"
"int rows, int cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset);\n"
"int dst1_index = mad24(y, dst1_step, x + dst1_offset);\n"
"int dst2_index = mad24(y, dst2_step, x + dst2_offset);\n"
"double x = src1[src1_index];\n"
"double y = src2[src2_index];\n"
"double x2 = x * x;\n"
"double y2 = y * y;\n"
"double magnitude = sqrt(x2 + y2);\n"
"float tmp = y >= 0 ? 0 : CV_PI*2;\n"
"tmp = x < 0 ? CV_PI : tmp;\n"
"float tmp1 = y >= 0 ? CV_PI*0.5 : CV_PI*1.5;\n"
"double cartToPolar = y2 <= x2 ? x*y/(x2 + 0.28f*y2 + DBL_EPSILON)  + tmp :\n"
"tmp1 - x*y/(y2 + 0.28f*x2 + DBL_EPSILON);\n"
"#ifdef DEGREE\n"
"cartToPolar *= (180/CV_PI);\n"
"#endif\n"
"dst1[dst1_index] = magnitude;\n"
"dst2[dst2_index] = cartToPolar;\n"
"}\n"
"}\n"
"#endif\n"
, "a43471e45195c432df267f55f46bba02"};
const struct ProgramEntry arithm_compare={"arithm_compare",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void arithm_compare(__global T * src1, int src1_step1, int src1_offset1,\n"
"__global T * src2, int src2_step1, int src2_offset1,\n"
"__global uchar * dst, int dst_step1, int dst_offset1,\n"
"int cols1, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols1 && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step1, x + src1_offset1);\n"
"int src2_index = mad24(y, src2_step1, x + src2_offset1);\n"
"int dst_index = mad24(y, dst_step1, x + dst_offset1);\n"
"dst[dst_index] = convert_uchar(src1[src1_index] Operation src2[src2_index] ? 255 : 0);\n"
"}\n"
"}\n"
, "3bf172a1e9d43fc31ca2a20d4c48b567"};
const struct ProgramEntry arithm_exp={"arithm_exp",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void arithm_exp_C1(__global srcT *src, __global srcT *dst,\n"
"int cols1, int rows,\n"
"int srcOffset1, int dstOffset1,\n"
"int srcStep1, int dstStep1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < cols1 && y < rows)\n"
"{\n"
"int srcIdx = mad24(y, srcStep1, x + srcOffset1);\n"
"int dstIdx = mad24(y, dstStep1, x + dstOffset1);\n"
"dst[dstIdx] = exp(src[srcIdx]);\n"
"}\n"
"}\n"
"__kernel void arithm_exp_C2(__global srcT *src, __global srcT *dst,\n"
"int cols1, int rows,\n"
"int srcOffset1, int dstOffset1,\n"
"int srcStep1, int dstStep1)\n"
"{\n"
"int x1 = get_global_id(0) << 1;\n"
"int y = get_global_id(1);\n"
"if(x1 < cols1 && y < rows)\n"
"{\n"
"int srcIdx = mad24(y, srcStep1, x1 + srcOffset1);\n"
"int dstIdx = mad24(y, dstStep1, x1 + dstOffset1);\n"
"dst[dstIdx] =                      exp(src[srcIdx]);\n"
"dst[dstIdx + 1] = x1 + 1 < cols1 ? exp(src[srcIdx + 1]) : dst[dstIdx + 1];\n"
"}\n"
"}\n"
"__kernel void arithm_exp_C4(__global srcT *src, __global srcT *dst,\n"
"int cols1, int rows,\n"
"int srcOffset1, int dstOffset1,\n"
"int srcStep1, int dstStep1)\n"
"{\n"
"int x1 = get_global_id(0) << 2;\n"
"int y = get_global_id(1);\n"
"if(x1 < cols1 && y < rows)\n"
"{\n"
"int srcIdx = mad24(y, srcStep1, x1 + srcOffset1);\n"
"int dstIdx = mad24(y, dstStep1, x1 + dstOffset1);\n"
"dst[dstIdx] =                      exp(src[srcIdx]);\n"
"dst[dstIdx + 1] = x1 + 1 < cols1 ? exp(src[srcIdx + 1]) : dst[dstIdx + 1];\n"
"dst[dstIdx + 2] = x1 + 2 < cols1 ? exp(src[srcIdx + 2]) : dst[dstIdx + 2];\n"
"dst[dstIdx + 3] = x1 + 3 < cols1 ? exp(src[srcIdx + 3]) : dst[dstIdx + 3];\n"
"}\n"
"}\n"
, "606622bd16248ee57812ed0da18de6f8"};
const struct ProgramEntry arithm_flip={"arithm_flip",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void arithm_flip_rows(__global T * src, int src_step, int src_offset,\n"
"__global T * dst, int dst_step, int dst_offset,\n"
"int rows, int cols, int thread_rows, int thread_cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < thread_rows)\n"
"{\n"
"int src_index_0 = mad24(y,            src_step, x + src_offset);\n"
"int src_index_1 = mad24(rows - y - 1, src_step, x + src_offset);\n"
"int dst_index_0 = mad24(y,            dst_step, x + dst_offset);\n"
"int dst_index_1 = mad24(rows - y - 1, dst_step, x + dst_offset);\n"
"T data0 = src[src_index_0], data1 = src[src_index_1];\n"
"dst[dst_index_0] = data1;\n"
"dst[dst_index_1] = data0;\n"
"}\n"
"}\n"
"__kernel void arithm_flip_rows_cols(__global T * src, int src_step, int src_offset,\n"
"__global T * dst, int dst_step, int dst_offset,\n"
"int rows, int cols, int thread_rows, int thread_cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < thread_rows)\n"
"{\n"
"int src_index_0 = mad24(y,            src_step, x            + src_offset);\n"
"int dst_index_0 = mad24(rows - y - 1, dst_step, cols - x - 1 + dst_offset);\n"
"int src_index_1 = mad24(rows - y - 1, src_step, cols - x - 1 + src_offset);\n"
"int dst_index_1 = mad24(y,            dst_step, x            + dst_offset);\n"
"T data0 = src[src_index_0], data1 = src[src_index_1];\n"
"dst[dst_index_0] = data0;\n"
"dst[dst_index_1] = data1;\n"
"}\n"
"}\n"
"__kernel void arithm_flip_cols(__global T * src, int src_step, int src_offset,\n"
"__global T * dst, int dst_step, int dst_offset,\n"
"int rows, int cols, int thread_rows, int thread_cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < thread_cols && y < rows)\n"
"{\n"
"int src_index_0 = mad24(y, src_step, x            + src_offset);\n"
"int dst_index_0 = mad24(y, dst_step, cols - x - 1 + dst_offset);\n"
"int src_index_1 = mad24(y, src_step, cols - x - 1 + src_offset);\n"
"int dst_index_1 = mad24(y, dst_step, x            + dst_offset);\n"
"T data0 = src[src_index_0], data1 = src[src_index_1];\n"
"dst[dst_index_1] = data1;\n"
"dst[dst_index_0] = data0;\n"
"}\n"
"}\n"
, "1a13aef3910e62cabcd190131cc9fe56"};
const struct ProgramEntry arithm_log={"arithm_log",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void arithm_log_C1(__global srcT *src, __global srcT *dst,\n"
"int cols1, int rows,\n"
"int srcOffset1, int dstOffset1,\n"
"int srcStep1, int dstStep1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < cols1 && y < rows)\n"
"{\n"
"int srcIdx = mad24(y, srcStep1, x + srcOffset1);\n"
"int dstIdx = mad24(y, dstStep1, x + dstOffset1);\n"
"dst[dstIdx] = log(src[srcIdx]);\n"
"}\n"
"}\n"
"__kernel void arithm_log_C2(__global srcT *src, __global srcT *dst,\n"
"int cols1, int rows,\n"
"int srcOffset1, int dstOffset1,\n"
"int srcStep1, int dstStep1)\n"
"{\n"
"int x1 = get_global_id(0) << 1;\n"
"int y = get_global_id(1);\n"
"if(x1 < cols1 && y < rows)\n"
"{\n"
"int srcIdx = mad24(y, srcStep1, x1 + srcOffset1);\n"
"int dstIdx = mad24(y, dstStep1, x1 + dstOffset1);\n"
"dst[dstIdx] =                      log(src[srcIdx]);\n"
"dst[dstIdx + 1] = x1 + 1 < cols1 ? log(src[srcIdx + 1]) : dst[dstIdx + 1];\n"
"}\n"
"}\n"
"__kernel void arithm_log_C4(__global srcT *src, __global srcT *dst,\n"
"int cols1, int rows,\n"
"int srcOffset1, int dstOffset1,\n"
"int srcStep1, int dstStep1)\n"
"{\n"
"int x1 = get_global_id(0) << 2;\n"
"int y = get_global_id(1);\n"
"if(x1 < cols1 && y < rows)\n"
"{\n"
"int srcIdx = mad24(y, srcStep1, x1 + srcOffset1);\n"
"int dstIdx = mad24(y, dstStep1, x1 + dstOffset1);\n"
"dst[dstIdx] =                      log(src[srcIdx]);\n"
"dst[dstIdx + 1] = x1 + 1 < cols1 ? log(src[srcIdx + 1]) : dst[dstIdx + 1];\n"
"dst[dstIdx + 2] = x1 + 2 < cols1 ? log(src[srcIdx + 2]) : dst[dstIdx + 2];\n"
"dst[dstIdx + 3] = x1 + 3 < cols1 ? log(src[srcIdx + 3]) : dst[dstIdx + 3];\n"
"}\n"
"}\n"
, "576799ef2a4fec6719bfe812cfbeb270"};
const struct ProgramEntry arithm_magnitude={"arithm_magnitude",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void arithm_magnitude(__global T *src1, int src1_step, int src1_offset,\n"
"__global T *src2, int src2_step, int src2_offset,\n"
"__global T *dst,  int dst_step,  int dst_offset,\n"
"int rows, int cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset);\n"
"int dst_index  = mad24(y, dst_step,  x + dst_offset);\n"
"T data1 = src1[src1_index];\n"
"T data2 = src2[src2_index];\n"
"T tmp = hypot(data1, data2);\n"
"dst[dst_index] = tmp;\n"
"}\n"
"}\n"
, "1e7ac19c4313a240ab431d2249537d09"};
const struct ProgramEntry arithm_minMax={"arithm_minMax",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#ifdef DEPTH_5\n"
"#define MIN_VAL (-FLT_MAX)\n"
"#define MAX_VAL FLT_MAX\n"
"#elif defined DEPTH_6\n"
"#define MIN_VAL (-DBL_MAX)\n"
"#define MAX_VAL DBL_MAX\n"
"#endif\n"
"__kernel void arithm_op_minMax(__global const T * src, int src_step, int src_offset, int src_rows, int src_cols,\n"
"int total, int groupnum, __global T * dst\n"
"#ifdef WITH_MASK\n"
", __global const uchar * mask, int mask_step, int mask_offset\n"
"#endif\n"
")\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"int id = get_global_id(0);\n"
"__local T localmem_max[128], localmem_min[128];\n"
"T minval = (T)(MAX_VAL), maxval = (T)(MIN_VAL), temp;\n"
"int y, x;\n"
"for (int grainSize = groupnum << 8; id < total; id += grainSize)\n"
"{\n"
"y = id / src_cols;\n"
"x = id % src_cols;\n"
"#ifdef WITH_MASK\n"
"if (mask[mad24(y, mask_step, x + mask_offset)])\n"
"#endif\n"
"{\n"
"temp = src[mad24(y, src_step, x + src_offset)];\n"
"minval = min(minval, temp);\n"
"maxval = max(maxval, temp);\n"
"}\n"
"}\n"
"if (lid > 127)\n"
"{\n"
"localmem_min[lid - 128] = minval;\n"
"localmem_max[lid - 128] = maxval;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lid < 128)\n"
"{\n"
"localmem_min[lid] = min(minval, localmem_min[lid]);\n"
"localmem_max[lid] = max(maxval, localmem_max[lid]);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for (int lsize = 64; lsize > 0; lsize >>= 1)\n"
"{\n"
"if (lid < lsize)\n"
"{\n"
"int lid2 = lsize + lid;\n"
"localmem_min[lid] = min(localmem_min[lid], localmem_min[lid2]);\n"
"localmem_max[lid] = max(localmem_max[lid], localmem_max[lid2]);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"if (lid == 0)\n"
"{\n"
"dst[gid] = localmem_min[0];\n"
"dst[gid + groupnum] = localmem_max[0];\n"
"}\n"
"}\n"
, "d62572e14800b115334df5c2e2937529"};
const struct ProgramEntry arithm_minMaxLoc={"arithm_minMaxLoc",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define RES_TYPE double4\n"
"#define CONVERT_RES_TYPE convert_double4\n"
"#else\n"
"#define RES_TYPE float4\n"
"#define CONVERT_RES_TYPE convert_float4\n"
"#endif\n"
"#if defined (DEPTH_0)\n"
"#define VEC_TYPE uchar4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_uchar4\n"
"#define CONDITION_FUNC(a,b,c) (convert_int4(a) ? b : c)\n"
"#define MIN_VAL 0\n"
"#define MAX_VAL 255\n"
"#endif\n"
"#if defined (DEPTH_1)\n"
"#define VEC_TYPE char4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_char4\n"
"#define CONDITION_FUNC(a,b,c) (convert_int4(a) ? b : c)\n"
"#define MIN_VAL -128\n"
"#define MAX_VAL 127\n"
"#endif\n"
"#if defined (DEPTH_2)\n"
"#define VEC_TYPE ushort4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_ushort4\n"
"#define CONDITION_FUNC(a,b,c) (convert_int4(a) ? b : c)\n"
"#define MIN_VAL 0\n"
"#define MAX_VAL 65535\n"
"#endif\n"
"#if defined (DEPTH_3)\n"
"#define VEC_TYPE short4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_short4\n"
"#define CONDITION_FUNC(a,b,c) (convert_int4(a) ? b : c)\n"
"#define MIN_VAL -32768\n"
"#define MAX_VAL 32767\n"
"#endif\n"
"#if defined (DEPTH_4)\n"
"#define VEC_TYPE int4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_int4\n"
"#define CONDITION_FUNC(a,b,c) ((a) ? b : c)\n"
"#define MIN_VAL INT_MIN\n"
"#define MAX_VAL INT_MAX\n"
"#endif\n"
"#if defined (DEPTH_5)\n"
"#define VEC_TYPE float4\n"
"#define VEC_TYPE_LOC float4\n"
"#define CONVERT_TYPE convert_float4\n"
"#define CONDITION_FUNC(a,b,c) ((a) ? b : c)\n"
"#define MIN_VAL (-FLT_MAX)\n"
"#define MAX_VAL FLT_MAX\n"
"#endif\n"
"#if defined (DEPTH_6)\n"
"#define VEC_TYPE double4\n"
"#define VEC_TYPE_LOC double4\n"
"#define CONVERT_TYPE convert_double4\n"
"#define CONDITION_FUNC(a,b,c) ((a) ? b : c)\n"
"#define MIN_VAL (-DBL_MAX)\n"
"#define MAX_VAL DBL_MAX\n"
"#endif\n"
"#if defined (REPEAT_S0)\n"
"#define repeat_s(a) a=a;\n"
"#endif\n"
"#if defined (REPEAT_S1)\n"
"#define repeat_s(a) a.s0 = a.s1;\n"
"#endif\n"
"#if defined (REPEAT_S2)\n"
"#define repeat_s(a) a.s0 = a.s2;a.s1 = a.s2;\n"
"#endif\n"
"#if defined (REPEAT_S3)\n"
"#define repeat_s(a) a.s0 = a.s3;a.s1 = a.s3;a.s2 = a.s3;\n"
"#endif\n"
"#if defined (REPEAT_E0)\n"
"#define repeat_e(a) a=a;\n"
"#endif\n"
"#if defined (REPEAT_E1)\n"
"#define repeat_e(a) a.s3 = a.s2;\n"
"#endif\n"
"#if defined (REPEAT_E2)\n"
"#define repeat_e(a) a.s3 = a.s1;a.s2 = a.s1;\n"
"#endif\n"
"#if defined (REPEAT_E3)\n"
"#define repeat_e(a) a.s3 = a.s0;a.s2 = a.s0;a.s1 = a.s0;\n"
"#endif\n"
"__kernel void arithm_op_minMaxLoc(int cols, int invalid_cols, int offset, int elemnum, int groupnum,\n"
"__global VEC_TYPE *src, __global RES_TYPE *dst)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"int  id = get_global_id(0);\n"
"int idx = offset + id + (id / cols) * invalid_cols;\n"
"__local VEC_TYPE localmem_max[128], localmem_min[128];\n"
"VEC_TYPE minval, maxval, temp;\n"
"__local VEC_TYPE_LOC localmem_maxloc[128], localmem_minloc[128];\n"
"VEC_TYPE_LOC minloc, maxloc, temploc, negative = -1;\n"
"int idx_c;\n"
"if (id < elemnum)\n"
"{\n"
"temp = src[idx];\n"
"idx_c = idx << 2;\n"
"temploc = (VEC_TYPE_LOC)(idx_c, idx_c + 1, idx_c + 2, idx_c + 3);\n"
"if (id % cols == 0 )\n"
"{\n"
"repeat_s(temp);\n"
"repeat_s(temploc);\n"
"}\n"
"if (id % cols == cols - 1)\n"
"{\n"
"repeat_e(temp);\n"
"repeat_e(temploc);\n"
"}\n"
"minval = temp;\n"
"maxval = temp;\n"
"minloc = temploc;\n"
"maxloc = temploc;\n"
"}\n"
"else\n"
"{\n"
"minval = MAX_VAL;\n"
"maxval = MIN_VAL;\n"
"minloc = negative;\n"
"maxloc = negative;\n"
"}\n"
"int grainSize = (groupnum << 8);\n"
"for (id = id + grainSize; id < elemnum; id = id + grainSize)\n"
"{\n"
"idx = offset + id + (id / cols) * invalid_cols;\n"
"temp = src[idx];\n"
"idx_c = idx << 2;\n"
"temploc = (VEC_TYPE_LOC)(idx_c, idx_c+1, idx_c+2, idx_c+3);\n"
"if (id % cols == 0 )\n"
"{\n"
"repeat_s(temp);\n"
"repeat_s(temploc);\n"
"}\n"
"if (id % cols == cols - 1)\n"
"{\n"
"repeat_e(temp);\n"
"repeat_e(temploc);\n"
"}\n"
"minval = min(minval, temp);\n"
"maxval = max(maxval, temp);\n"
"minloc = CONDITION_FUNC(minval == temp, temploc, minloc);\n"
"maxloc = CONDITION_FUNC(maxval == temp, temploc, maxloc);\n"
"}\n"
"if (lid > 127)\n"
"{\n"
"localmem_min[lid - 128] = minval;\n"
"localmem_max[lid - 128] = maxval;\n"
"localmem_minloc[lid - 128] = minloc;\n"
"localmem_maxloc[lid - 128] = maxloc;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lid < 128)\n"
"{\n"
"localmem_min[lid] = min(minval,localmem_min[lid]);\n"
"localmem_max[lid] = max(maxval,localmem_max[lid]);\n"
"VEC_TYPE minVal = localmem_min[lid], maxVal = localmem_max[lid];\n"
"localmem_minloc[lid] = CONDITION_FUNC(minVal == minval, minloc, localmem_minloc[lid]);\n"
"localmem_maxloc[lid] = CONDITION_FUNC(maxVal == maxval, maxloc, localmem_maxloc[lid]);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for (int lsize = 64; lsize > 0; lsize >>= 1)\n"
"{\n"
"if (lid < lsize)\n"
"{\n"
"int lid2 = lsize + lid;\n"
"localmem_min[lid] = min(localmem_min[lid], localmem_min[lid2]);\n"
"localmem_max[lid] = max(localmem_max[lid], localmem_max[lid2]);\n"
"VEC_TYPE min1 = localmem_min[lid], min2 = localmem_min[lid2];\n"
"localmem_minloc[lid] = CONDITION_FUNC(min1 == min2, localmem_minloc[lid2], localmem_minloc[lid]);\n"
"VEC_TYPE max1 = localmem_max[lid], max2 = localmem_max[lid2];\n"
"localmem_maxloc[lid] = CONDITION_FUNC(max1 == max2, localmem_maxloc[lid2], localmem_maxloc[lid]);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"if ( lid == 0)\n"
"{\n"
"dst[gid] = CONVERT_RES_TYPE(localmem_min[0]);\n"
"dst[gid + groupnum] = CONVERT_RES_TYPE(localmem_max[0]);\n"
"dst[gid + 2 * groupnum] = CONVERT_RES_TYPE(localmem_minloc[0]);\n"
"dst[gid + 3 * groupnum] = CONVERT_RES_TYPE(localmem_maxloc[0]);\n"
"}\n"
"}\n"
, "a59ab29ff6ebd4dcab6304a7547f4cf3"};
const struct ProgramEntry arithm_minMaxLoc_mask={"arithm_minMaxLoc_mask",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define RES_TYPE double4\n"
"#define CONVERT_RES_TYPE convert_double4\n"
"#else\n"
"#define RES_TYPE float4\n"
"#define CONVERT_RES_TYPE convert_float4\n"
"#endif\n"
"#if defined (DEPTH_0)\n"
"#define TYPE uchar\n"
"#define VEC_TYPE uchar4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_uchar4\n"
"#define CONDITION_FUNC(a,b,c) (convert_int4(a) ? b : c)\n"
"#define MIN_VAL 0\n"
"#define MAX_VAL 255\n"
"#endif\n"
"#if defined (DEPTH_1)\n"
"#define TYPE char\n"
"#define VEC_TYPE char4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_char4\n"
"#define CONDITION_FUNC(a,b,c) (convert_int4(a) ? b : c)\n"
"#define MIN_VAL -128\n"
"#define MAX_VAL 127\n"
"#endif\n"
"#if defined (DEPTH_2)\n"
"#define TYPE ushort\n"
"#define VEC_TYPE ushort4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_ushort4\n"
"#define CONDITION_FUNC(a,b,c) (convert_int4(a) ? b : c)\n"
"#define MIN_VAL 0\n"
"#define MAX_VAL 65535\n"
"#endif\n"
"#if defined (DEPTH_3)\n"
"#define TYPE short\n"
"#define VEC_TYPE short4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_short4\n"
"#define CONDITION_FUNC(a,b,c) (convert_int4(a) ? b : c)\n"
"#define MIN_VAL -32768\n"
"#define MAX_VAL 32767\n"
"#endif\n"
"#if defined (DEPTH_4)\n"
"#define TYPE int\n"
"#define VEC_TYPE int4\n"
"#define VEC_TYPE_LOC int4\n"
"#define CONVERT_TYPE convert_int4\n"
"#define CONDITION_FUNC(a,b,c) ((a) ? b : c)\n"
"#define MIN_VAL INT_MIN\n"
"#define MAX_VAL INT_MAX\n"
"#endif\n"
"#if defined (DEPTH_5)\n"
"#define TYPE float\n"
"#define VEC_TYPE float4\n"
"#define VEC_TYPE_LOC float4\n"
"#define CONVERT_TYPE convert_float4\n"
"#define CONDITION_FUNC(a,b,c) ((a) ? b : c)\n"
"#define MIN_VAL (-FLT_MAX)\n"
"#define MAX_VAL FLT_MAX\n"
"#endif\n"
"#if defined (DEPTH_6)\n"
"#define TYPE double\n"
"#define VEC_TYPE double4\n"
"#define VEC_TYPE_LOC double4\n"
"#define CONVERT_TYPE convert_double4\n"
"#define CONDITION_FUNC(a,b,c) ((a) ? b : c)\n"
"#define MIN_VAL (-DBL_MAX)\n"
"#define MAX_VAL DBL_MAX\n"
"#endif\n"
"#if defined (REPEAT_E0)\n"
"#define repeat_e(a) a=a;\n"
"#endif\n"
"#if defined (REPEAT_E1)\n"
"#define repeat_e(a) a.s3 = a.s2;\n"
"#endif\n"
"#if defined (REPEAT_E2)\n"
"#define repeat_e(a) a.s3 = a.s1;a.s2 = a.s1;\n"
"#endif\n"
"#if defined (REPEAT_E3)\n"
"#define repeat_e(a) a.s3 = a.s0;a.s2 = a.s0;a.s1 = a.s0;\n"
"#endif\n"
"#if defined (REPEAT_E0)\n"
"#define repeat_me(a) a = a;\n"
"#endif\n"
"#if defined (REPEAT_E1)\n"
"#define repeat_me(a) a.s3 = 0;\n"
"#endif\n"
"#if defined (REPEAT_E2)\n"
"#define repeat_me(a) a.s3 = 0;a.s2 = 0;\n"
"#endif\n"
"#if defined (REPEAT_E3)\n"
"#define repeat_me(a) a.s3 = 0;a.s2 = 0;a.s1 = 0;\n"
"#endif\n"
"__kernel void arithm_op_minMaxLoc_mask (int cols,int invalid_cols,int offset,int elemnum,int groupnum,__global TYPE *src,\n"
"int minvalid_cols,int moffset,__global uchar *mask,__global RES_TYPE  *dst)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"int  id = get_global_id(0);\n"
"int idx = id + (id / cols) * invalid_cols;\n"
"int midx = id + (id / cols) * minvalid_cols;\n"
"__local VEC_TYPE lm_max[128],lm_min[128];\n"
"VEC_TYPE minval, maxval, temp, m_temp, zeroVal = (VEC_TYPE)(0);\n"
"__local VEC_TYPE_LOC lm_maxloc[128], lm_minloc[128];\n"
"VEC_TYPE_LOC minloc, maxloc, temploc, negative = -1, one = 1, zero = 0;\n"
"if(id < elemnum)\n"
"{\n"
"temp = vload4(idx, &src[offset]);\n"
"m_temp = CONVERT_TYPE(vload4(midx,&mask[moffset]));\n"
"int idx_c = (idx << 2) + offset;\n"
"temploc = (VEC_TYPE_LOC)(idx_c,idx_c+1,idx_c+2,idx_c+3);\n"
"if (id % cols == cols - 1)\n"
"{\n"
"repeat_me(m_temp);\n"
"repeat_e(temploc);\n"
"}\n"
"minval = m_temp != zeroVal ? temp : (VEC_TYPE)MAX_VAL;\n"
"maxval = m_temp != zeroVal ? temp : (VEC_TYPE)MIN_VAL;\n"
"minloc = CONDITION_FUNC(m_temp != zeroVal, temploc , negative);\n"
"maxloc = minloc;\n"
"}\n"
"else\n"
"{\n"
"minval = MAX_VAL;\n"
"maxval = MIN_VAL;\n"
"minloc = negative;\n"
"maxloc = negative;\n"
"}\n"
"for(id=id + (groupnum << 8); id < elemnum;id = id + (groupnum << 8))\n"
"{\n"
"idx = id + (id / cols) * invalid_cols;\n"
"midx = id + (id / cols) * minvalid_cols;\n"
"temp = vload4(idx, &src[offset]);\n"
"m_temp = CONVERT_TYPE(vload4(midx,&mask[moffset]));\n"
"int idx_c = (idx << 2) + offset;\n"
"temploc = (VEC_TYPE_LOC)(idx_c,idx_c+1,idx_c+2,idx_c+3);\n"
"if (id % cols == cols - 1)\n"
"{\n"
"repeat_me(m_temp);\n"
"repeat_e(temploc);\n"
"}\n"
"minval = min(minval, m_temp != zeroVal ? temp : minval);\n"
"maxval = max(maxval, m_temp != zeroVal ? temp : maxval);\n"
"minloc = CONDITION_FUNC(minval == temp && m_temp != zeroVal, temploc , minloc);\n"
"maxloc = CONDITION_FUNC(maxval == temp && m_temp != zeroVal, temploc , maxloc);\n"
"}\n"
"if(lid > 127)\n"
"{\n"
"lm_min[lid - 128] = minval;\n"
"lm_max[lid - 128] = maxval;\n"
"lm_minloc[lid - 128] = minloc;\n"
"lm_maxloc[lid - 128] = maxloc;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid < 128)\n"
"{\n"
"lm_min[lid] = min(minval, lm_min[lid]);\n"
"lm_max[lid] = max(maxval, lm_max[lid]);\n"
"VEC_TYPE con_min = CONVERT_TYPE(minloc != negative ? one : zero);\n"
"VEC_TYPE con_max = CONVERT_TYPE(maxloc != negative ? one : zero);\n"
"VEC_TYPE lmMinVal = lm_min[lid], lmMaxVal = lm_max[lid];\n"
"lm_minloc[lid] = CONDITION_FUNC(lmMinVal == minval && con_min != zeroVal, minloc , lm_minloc[lid]);\n"
"lm_maxloc[lid] = CONDITION_FUNC(lmMaxVal == maxval && con_max != zeroVal, maxloc , lm_maxloc[lid]);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for(int lsize = 64; lsize > 0; lsize >>= 1)\n"
"{\n"
"if(lid < lsize)\n"
"{\n"
"int lid2 = lsize + lid;\n"
"lm_min[lid] = min(lm_min[lid], lm_min[lid2]);\n"
"lm_max[lid] = max(lm_max[lid], lm_max[lid2]);\n"
"VEC_TYPE con_min = CONVERT_TYPE(lm_minloc[lid2] != negative ? one : zero);\n"
"VEC_TYPE con_max = CONVERT_TYPE(lm_maxloc[lid2] != negative ? one : zero);\n"
"VEC_TYPE lmMinVal1 = lm_min[lid], lmMinVal2 = lm_min[lid2];\n"
"VEC_TYPE lmMaxVal1 = lm_max[lid], lmMaxVal2 = lm_max[lid2];\n"
"lm_minloc[lid] = CONDITION_FUNC(lmMinVal1 == lmMinVal2 && con_min != zeroVal, lm_minloc[lid2] , lm_minloc[lid]);\n"
"lm_maxloc[lid] = CONDITION_FUNC(lmMaxVal1 == lmMaxVal2 && con_max != zeroVal, lm_maxloc[lid2] , lm_maxloc[lid]);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"if( lid == 0)\n"
"{\n"
"dst[gid] = CONVERT_RES_TYPE(lm_min[0]);\n"
"dst[gid + groupnum] = CONVERT_RES_TYPE(lm_max[0]);\n"
"dst[gid + 2 * groupnum] = CONVERT_RES_TYPE(lm_minloc[0]);\n"
"dst[gid + 3 * groupnum] = CONVERT_RES_TYPE(lm_maxloc[0]);\n"
"}\n"
"}\n"
, "a2ac711cf5b963637b561e0c868b7f04"};
const struct ProgramEntry arithm_nonzero={"arithm_nonzero",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void arithm_op_nonzero(__global srcT * src, int src_step, int src_offset, int src_cols,\n"
"int total, int groupnum, __global dstT * dst)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"int  id = get_global_id(0);\n"
"__local dstT localmem_nonzero[128];\n"
"dstT nonzero = (dstT)(0);\n"
"for (int grain = groupnum << 8; id < total; id += grain)\n"
"nonzero += convertToDstT(src[mad24(id / src_cols, src_step, id % src_cols + src_offset)] == (srcT)(0)) ? (dstT)(0) : (dstT)(1);\n"
"if (lid > 127)\n"
"localmem_nonzero[lid - 128] = nonzero;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lid < 128)\n"
"localmem_nonzero[lid] = nonzero + localmem_nonzero[lid];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for (int lsize = 64; lsize > 0; lsize >>= 1)\n"
"{\n"
"if (lid < lsize)\n"
"{\n"
"int lid2 = lsize + lid;\n"
"localmem_nonzero[lid] = localmem_nonzero[lid] + localmem_nonzero[lid2];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"if (lid == 0)\n"
"dst[gid] = localmem_nonzero[0];\n"
"}\n"
, "650573f3600f3c0f0a6a87ab3d29e803"};
const struct ProgramEntry arithm_phase={"arithm_phase",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define CV_PI M_PI\n"
"#define CV_2PI (2 * CV_PI)\n"
"#else\n"
"#define CV_PI M_PI_F\n"
"#define CV_2PI (2 * CV_PI)\n"
"#endif\n"
"__kernel void arithm_phase_inradians_D5(__global float *src1, int src1_step1, int src1_offset1,\n"
"__global float *src2, int src2_step1, int src2_offset1,\n"
"__global float *dst,  int dst_step1,  int dst_offset1,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step1, x + src1_offset1);\n"
"int src2_index = mad24(y, src2_step1, x + src2_offset1);\n"
"int dst_index  = mad24(y, dst_step1, x + dst_offset1);\n"
"float data1 = src1[src1_index];\n"
"float data2 = src2[src2_index];\n"
"float tmp = atan2(data2, data1);\n"
"if (tmp < 0)\n"
"tmp += CV_2PI;\n"
"dst[dst_index] = tmp;\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void arithm_phase_inradians_D6(__global double *src1, int src1_step1, int src1_offset1,\n"
"__global double *src2, int src2_step1, int src2_offset1,\n"
"__global double *dst,  int dst_step1,  int dst_offset1,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step1, x + src1_offset1);\n"
"int src2_index = mad24(y, src2_step1, x + src2_offset1);\n"
"int dst_index  = mad24(y, dst_step1, x + dst_offset1);\n"
"double data1 = src1[src1_index];\n"
"double data2 = src2[src2_index];\n"
"double tmp = atan2(data2, data1);\n"
"if (tmp < 0)\n"
"tmp += CV_2PI;\n"
"dst[dst_index] = tmp;\n"
"}\n"
"}\n"
"#endif\n"
"__kernel void arithm_phase_indegrees_D5(__global float *src1, int src1_step1, int src1_offset1,\n"
"__global float *src2, int src2_step1, int src2_offset1,\n"
"__global float *dst,  int dst_step1,  int dst_offset1,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step1, x + src1_offset1);\n"
"int src2_index = mad24(y, src2_step1, x + src2_offset1);\n"
"int dst_index  = mad24(y, dst_step1, x + dst_offset1);\n"
"float data1 = src1[src1_index];\n"
"float data2 = src2[src2_index];\n"
"float tmp = atan2(data2, data1);\n"
"tmp = 180 * tmp / CV_PI;\n"
"if (tmp < 0)\n"
"tmp += 360;\n"
"dst[dst_index] = tmp;\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void arithm_phase_indegrees_D6 (__global double *src1, int src1_step1, int src1_offset1,\n"
"__global double *src2, int src2_step1, int src2_offset1,\n"
"__global double *dst,  int dst_step1,  int dst_offset1,\n"
"int cols, int rows)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step1, x + src1_offset1);\n"
"int src2_index = mad24(y, src2_step1, x + src2_offset1);\n"
"int dst_index  = mad24(y, dst_step1, x + dst_offset1);\n"
"double data1 = src1[src1_index];\n"
"double data2 = src2[src2_index];\n"
"double tmp = atan2(data2, data1);\n"
"tmp = 180 * tmp / CV_PI;\n"
"if (tmp < 0)\n"
"tmp += 360;\n"
"dst[dst_index] = tmp;\n"
"}\n"
"}\n"
"#endif\n"
, "74e75b6750558dabe4856b6557b6ae41"};
const struct ProgramEntry arithm_polarToCart={"arithm_polarToCart",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define CV_PI M_PI\n"
"#else\n"
"#define CV_PI M_PI_F\n"
"#endif\n"
"__kernel void arithm_polarToCart_mag_D5 (__global float *src1, int src1_step, int src1_offset,\n"
"__global float *src2, int src2_step, int src2_offset,\n"
"__global float *dst1, int dst1_step, int dst1_offset,\n"
"__global float *dst2, int dst2_step, int dst2_offset,\n"
"int rows, int cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset);\n"
"int dst1_index = mad24(y, dst1_step, x + dst1_offset);\n"
"int dst2_index = mad24(y, dst2_step, x + dst2_offset);\n"
"float x = src1[src1_index];\n"
"float y = src2[src2_index];\n"
"#ifdef DEGREE\n"
"float ascale = CV_PI/180.0f;\n"
"float alpha = y * ascale;\n"
"#else\n"
"float alpha = y;\n"
"#endif\n"
"float a = cos(alpha) * x;\n"
"float b = sin(alpha) * x;\n"
"dst1[dst1_index] = a;\n"
"dst2[dst2_index] = b;\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void arithm_polarToCart_mag_D6 (__global double *src1, int src1_step, int src1_offset,\n"
"__global double *src2, int src2_step, int src2_offset,\n"
"__global double *dst1, int dst1_step, int dst1_offset,\n"
"__global double *dst2, int dst2_step, int dst2_offset,\n"
"int rows, int cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, x + src1_offset);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset);\n"
"int dst1_index = mad24(y, dst1_step, x + dst1_offset);\n"
"int dst2_index = mad24(y, dst2_step, x + dst2_offset);\n"
"double x = src1[src1_index];\n"
"double y = src2[src2_index];\n"
"#ifdef DEGREE\n"
"float ascale = CV_PI/180.0;\n"
"float alpha = y * ascale;\n"
"#else\n"
"float alpha = y;\n"
"#endif\n"
"double a = cos(alpha) * x;\n"
"double b = sin(alpha) * x;\n"
"dst1[dst1_index] = a;\n"
"dst2[dst2_index] = b;\n"
"}\n"
"}\n"
"#endif\n"
"__kernel void arithm_polarToCart_D5 (__global float *src,  int src_step,  int src_offset,\n"
"__global float *dst1, int dst1_step, int dst1_offset,\n"
"__global float *dst2, int dst2_step, int dst2_offset,\n"
"int rows, int cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src_index  = mad24(y, src_step,  x + src_offset);\n"
"int dst1_index = mad24(y, dst1_step, x + dst1_offset);\n"
"int dst2_index = mad24(y, dst2_step, x + dst2_offset);\n"
"float y = src[src_index];\n"
"#ifdef DEGREE\n"
"float ascale = CV_PI/180.0f;\n"
"float alpha = y * ascale;\n"
"#else\n"
"float alpha = y;\n"
"#endif\n"
"float a = cos(alpha);\n"
"float b = sin(alpha);\n"
"dst1[dst1_index] = a;\n"
"dst2[dst2_index] = b;\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void arithm_polarToCart_D6 (__global float *src,  int src_step,  int src_offset,\n"
"__global float *dst1, int dst1_step, int dst1_offset,\n"
"__global float *dst2, int dst2_step, int dst2_offset,\n"
"int rows, int cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src_index  = mad24(y, src_step,  x + src_offset);\n"
"int dst1_index = mad24(y, dst1_step, x + dst1_offset);\n"
"int dst2_index = mad24(y, dst2_step, x + dst2_offset);\n"
"double y = src[src_index];\n"
"#ifdef DEGREE\n"
"float ascale = CV_PI/180.0f;\n"
"float alpha = y * ascale;\n"
"#else\n"
"float alpha = y;\n"
"#endif\n"
"double a = cos(alpha);\n"
"double b = sin(alpha);\n"
"dst1[dst1_index] = a;\n"
"dst2[dst2_index] = b;\n"
"}\n"
"}\n"
"#endif\n"
, "3b9f767242239556823d43460957858f"};
const struct ProgramEntry arithm_pow={"arithm_pow",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void arithm_pow(__global VT * src, int src_step, int src_offset,\n"
"__global VT * dst, int dst_step, int dst_offset,\n"
"int rows, int cols, T p)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src_index = mad24(y, src_step, x + src_offset);\n"
"int dst_index = mad24(y, dst_step, x + dst_offset);\n"
"VT src_data = src[src_index];\n"
"VT tmp = src_data > (VT)0 ? (VT)exp(p * log(src_data)) : (src_data == (VT)0 ? (VT)0 : (VT)exp(p * log(fabs(src_data))));\n"
"dst[dst_index] = tmp;\n"
"}\n"
"}\n"
, "a79b90c5a25fec8fe4d5af644308c7c5"};
const struct ProgramEntry arithm_setidentity={"arithm_setidentity",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void setIdentity(__global T * src, int src_step, int src_offset,\n"
"int cols, int rows, __global const T * scalar)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src_index = mad24(y, src_step, src_offset + x);\n"
"if (x == y)\n"
"src[src_index] = *scalar;\n"
"else\n"
"src[src_index] = 0;\n"
"}\n"
"}\n"
, "bc19dcbca5a8d384082c7d000b806e1b"};
const struct ProgramEntry arithm_sum={"arithm_sum",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#if FUNC_SUM\n"
"#define FUNC(a, b) b += a;\n"
"#elif FUNC_ABS_SUM\n"
"#define FUNC(a, b) b += a >= (dstT)(0) ? a : -a;\n"
"#elif FUNC_SQR_SUM\n"
"#define FUNC(a, b) b += a * a;\n"
"#else\n"
"#error No sum function\n"
"#endif\n"
"__kernel void arithm_op_sum(__global srcT * src, int src_step, int src_offset, int src_cols,\n"
"int total, int groupnum, __global dstT * dst)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"int id = get_global_id(0);\n"
"__local dstT localmem_sum[128];\n"
"dstT sum = (dstT)(0), temp;\n"
"for (int grainSize = groupnum << 8; id < total; id += grainSize)\n"
"{\n"
"temp = convertToDstT(src[mad24(id / src_cols, src_step, id % src_cols + src_offset)]);\n"
"FUNC(temp, sum);\n"
"}\n"
"if (lid > 127)\n"
"localmem_sum[lid - 128] = sum;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lid < 128)\n"
"localmem_sum[lid] = sum + localmem_sum[lid];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for (int lsize = 64; lsize > 0; lsize >>= 1)\n"
"{\n"
"if (lid < lsize)\n"
"{\n"
"int lid2 = lsize + lid;\n"
"localmem_sum[lid] = localmem_sum[lid] + localmem_sum[lid2];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"if (lid == 0)\n"
"dst[gid] = localmem_sum[0];\n"
"}\n"
, "6183a9be49fc10d3d55fa959093a607f"};
const struct ProgramEntry arithm_transpose={"arithm_transpose",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#define TILE_DIM      32\n"
"#define BLOCK_ROWS    8\n"
"#define LDS_STEP      TILE_DIM\n"
"__kernel void transpose(__global const T* src, __global T* dst,\n"
"int src_cols, int src_rows,\n"
"int src_step, int dst_step,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int gp_x = get_group_id(0),   gp_y = get_group_id(1);\n"
"int gs_x = get_num_groups(0), gs_y = get_num_groups(1);\n"
"int groupId_x, groupId_y;\n"
"if(src_rows == src_cols)\n"
"{\n"
"groupId_y = gp_x;\n"
"groupId_x = (gp_x + gp_y) % gs_x;\n"
"}\n"
"else\n"
"{\n"
"int bid = gp_x + gs_x * gp_y;\n"
"groupId_y =  bid % gs_y;\n"
"groupId_x = ((bid / gs_y) + groupId_y) % gs_x;\n"
"}\n"
"int lx = get_local_id(0);\n"
"int ly = get_local_id(1);\n"
"int x = groupId_x * TILE_DIM + lx;\n"
"int y = groupId_y * TILE_DIM + ly;\n"
"int x_index = groupId_y * TILE_DIM + lx;\n"
"int y_index = groupId_x * TILE_DIM + ly;\n"
"__local T title[TILE_DIM * LDS_STEP];\n"
"if (x < src_cols && y < src_rows)\n"
"{\n"
"int index_src = mad24(y, src_step, x);\n"
"for(int i = 0; i < TILE_DIM; i += BLOCK_ROWS)\n"
"{\n"
"if (y + i < src_rows)\n"
"{\n"
"title[(ly + i) * LDS_STEP + lx] = src[src_offset + index_src];\n"
"index_src = mad24(BLOCK_ROWS, src_step, index_src);\n"
"}\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (x_index < src_rows && y_index < src_cols)\n"
"{\n"
"int index_dst = mad24(y_index, dst_step, x_index);\n"
"for(int i = 0; i < TILE_DIM; i += BLOCK_ROWS)\n"
"{\n"
"if ((y_index + i) < src_cols)\n"
"{\n"
"dst[dst_offset + index_dst] = title[lx * LDS_STEP + ly + i];\n"
"index_dst +=  dst_step * BLOCK_ROWS;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"__kernel void transpose_inplace(__global T* src, __global T* dst,\n"
"int src_cols, int src_rows,\n"
"int src_step, int dst_step,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < src_rows && x < y)\n"
"{\n"
"int srcIdx = mad24(y, src_step, src_offset + x);\n"
"int dstIdx = mad24(x, dst_step, dst_offset + y);\n"
"T tmp = dst[dstIdx];\n"
"dst[dstIdx] = src[srcIdx];\n"
"src[srcIdx] = tmp;\n"
"}\n"
"}\n"
, "bd4ecb4b23c96b7c71399c6faa7a71f4"};
const struct ProgramEntry bgfg_mog={"bgfg_mog",
"#if defined (CN1)\n"
"#define T_FRAME uchar\n"
"#define T_MEAN_VAR float\n"
"#define CONVERT_TYPE convert_uchar_sat\n"
"#define F_ZERO (0.0f)\n"
"float cvt(uchar val)\n"
"{\n"
"return val;\n"
"}\n"
"float sqr(float val)\n"
"{\n"
"return val * val;\n"
"}\n"
"float sum(float val)\n"
"{\n"
"return val;\n"
"}\n"
"float clamp1(float var, float learningRate, float diff, float minVar)\n"
"{\n"
"return fmax(var + learningRate * (diff * diff - var), minVar);\n"
"}\n"
"#else\n"
"#define T_FRAME uchar4\n"
"#define T_MEAN_VAR float4\n"
"#define CONVERT_TYPE convert_uchar4_sat\n"
"#define F_ZERO (0.0f, 0.0f, 0.0f, 0.0f)\n"
"float4 cvt(const uchar4 val)\n"
"{\n"
"float4 result;\n"
"result.x = val.x;\n"
"result.y = val.y;\n"
"result.z = val.z;\n"
"result.w = val.w;\n"
"return result;\n"
"}\n"
"float sqr(const float4 val)\n"
"{\n"
"return val.x * val.x + val.y * val.y + val.z * val.z;\n"
"}\n"
"float sum(const float4 val)\n"
"{\n"
"return (val.x + val.y + val.z);\n"
"}\n"
"void swap4(__global float4* ptr, int x, int y, int k, int rows, int ptr_step)\n"
"{\n"
"float4 val = ptr[(k * rows + y) * ptr_step + x];\n"
"ptr[(k * rows + y) * ptr_step + x] = ptr[((k + 1) * rows + y) * ptr_step + x];\n"
"ptr[((k + 1) * rows + y) * ptr_step + x] = val;\n"
"}\n"
"float4 clamp1(const float4 var, float learningRate, const float4 diff, float minVar)\n"
"{\n"
"float4 result;\n"
"result.x = fmax(var.x + learningRate * (diff.x * diff.x - var.x), minVar);\n"
"result.y = fmax(var.y + learningRate * (diff.y * diff.y - var.y), minVar);\n"
"result.z = fmax(var.z + learningRate * (diff.z * diff.z - var.z), minVar);\n"
"result.w = 0.0f;\n"
"return result;\n"
"}\n"
"#endif\n"
"typedef struct\n"
"{\n"
"float c_Tb;\n"
"float c_TB;\n"
"float c_Tg;\n"
"float c_varInit;\n"
"float c_varMin;\n"
"float c_varMax;\n"
"float c_tau;\n"
"uchar c_shadowVal;\n"
"} con_srtuct_t;\n"
"void swap(__global float* ptr, int x, int y, int k, int rows, int ptr_step)\n"
"{\n"
"float val = ptr[(k * rows + y) * ptr_step + x];\n"
"ptr[(k * rows + y) * ptr_step + x] = ptr[((k + 1) * rows + y) * ptr_step + x];\n"
"ptr[((k + 1) * rows + y) * ptr_step + x] = val;\n"
"}\n"
"__kernel void mog_withoutLearning_kernel(__global T_FRAME* frame, __global uchar* fgmask,\n"
"__global float* weight, __global T_MEAN_VAR* mean, __global T_MEAN_VAR* var,\n"
"int frame_row, int frame_col, int frame_step, int fgmask_step,\n"
"int weight_step, int mean_step, int var_step,\n"
"float varThreshold, float backgroundRatio, int fgmask_offset_x,\n"
"int fgmask_offset_y, int frame_offset_x, int frame_offset_y)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < frame_col && y < frame_row)\n"
"{\n"
"T_MEAN_VAR pix = cvt(frame[(y + frame_offset_y) * frame_step + (x + frame_offset_x)]);\n"
"int kHit = -1;\n"
"int kForeground = -1;\n"
"for (int k = 0; k < (NMIXTURES); ++k)\n"
"{\n"
"if (weight[(k * frame_row + y) * weight_step + x] < 1.192092896e-07f)\n"
"break;\n"
"T_MEAN_VAR mu = mean[(k * frame_row + y) * mean_step + x];\n"
"T_MEAN_VAR _var = var[(k * frame_row + y) + var_step + x];\n"
"T_MEAN_VAR diff = pix - mu;\n"
"if (sqr(diff) < varThreshold * sum(_var))\n"
"{\n"
"kHit = k;\n"
"break;\n"
"}\n"
"}\n"
"if (kHit >= 0)\n"
"{\n"
"float wsum = 0.0f;\n"
"for (int k = 0; k < (NMIXTURES); ++k)\n"
"{\n"
"wsum += weight[(k * frame_row + y) * weight_step + x];\n"
"if (wsum > backgroundRatio)\n"
"{\n"
"kForeground = k + 1;\n"
"break;\n"
"}\n"
"}\n"
"}\n"
"if(kHit < 0 || kHit >= kForeground)\n"
"fgmask[(y + fgmask_offset_y) * fgmask_step + (x + fgmask_offset_x)] = (uchar) (-1);\n"
"else\n"
"fgmask[(y + fgmask_offset_y) * fgmask_step + (x + fgmask_offset_x)] = (uchar) (0);\n"
"}\n"
"}\n"
"__kernel void mog_withLearning_kernel(__global T_FRAME* frame, __global int* fgmask,\n"
"__global float* weight, __global float* sortKey, __global T_MEAN_VAR* mean,\n"
"__global T_MEAN_VAR* var, int frame_row, int frame_col, int frame_step, int fgmask_step,\n"
"int weight_step, int sortKey_step, int mean_step, int var_step,\n"
"float varThreshold, float backgroundRatio, float learningRate, float minVar,\n"
"int fgmask_offset_x, int fgmask_offset_y, int frame_offset_x, int frame_offset_y)\n"
"{\n"
"const float w0 = 0.05f;\n"
"const float sk0 = w0 / 30.0f;\n"
"const float var0 = 900.f;\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x >= frame_col || y >= frame_row) return;\n"
"float wsum = 0.0f;\n"
"int kHit = -1;\n"
"int kForeground = -1;\n"
"int k = 0;\n"
"T_MEAN_VAR pix = cvt(frame[(y + frame_offset_y) * frame_step + (x + frame_offset_x)]);\n"
"for (; k < (NMIXTURES); ++k)\n"
"{\n"
"float w = weight[(k * frame_row + y) * weight_step + x];\n"
"wsum += w;\n"
"if (w < 1.192092896e-07f)\n"
"break;\n"
"T_MEAN_VAR mu = mean[(k * frame_row + y) * mean_step + x];\n"
"T_MEAN_VAR _var = var[(k * frame_row + y) * var_step + x];\n"
"float sortKey_prev, weight_prev;\n"
"T_MEAN_VAR mean_prev, var_prev;\n"
"if (sqr(pix - mu) < varThreshold * sum(_var))\n"
"{\n"
"wsum -= w;\n"
"float dw = learningRate * (1.0f - w);\n"
"_var = clamp1(_var, learningRate, pix - mu, minVar);\n"
"sortKey_prev = w / sqr(sum(_var));\n"
"sortKey[(k * frame_row + y) * sortKey_step + x] = sortKey_prev;\n"
"weight_prev = w + dw;\n"
"weight[(k * frame_row + y) * weight_step + x] = weight_prev;\n"
"mean_prev = mu + learningRate * (pix - mu);\n"
"mean[(k * frame_row + y) * mean_step + x] = mean_prev;\n"
"var_prev = _var;\n"
"var[(k * frame_row + y) * var_step + x] = var_prev;\n"
"}\n"
"int k1 = k - 1;\n"
"if (k1 >= 0 && sqr(pix - mu) < varThreshold * sum(_var))\n"
"{\n"
"float sortKey_next = sortKey[(k1 * frame_row + y) * sortKey_step + x];\n"
"float weight_next = weight[(k1 * frame_row + y) * weight_step + x];\n"
"T_MEAN_VAR mean_next = mean[(k1 * frame_row + y) * mean_step + x];\n"
"T_MEAN_VAR var_next = var[(k1 * frame_row + y) * var_step + x];\n"
"for (; sortKey_next < sortKey_prev && k1 >= 0; --k1)\n"
"{\n"
"sortKey[(k1 * frame_row + y) * sortKey_step + x] = sortKey_prev;\n"
"sortKey[((k1 + 1) * frame_row + y) * sortKey_step + x] = sortKey_next;\n"
"weight[(k1 * frame_row + y) * weight_step + x] = weight_prev;\n"
"weight[((k1 + 1) * frame_row + y) * weight_step + x] = weight_next;\n"
"mean[(k1 * frame_row + y) * mean_step + x] = mean_prev;\n"
"mean[((k1 + 1) * frame_row + y) * mean_step + x] = mean_next;\n"
"var[(k1 * frame_row + y) * var_step + x] = var_prev;\n"
"var[((k1 + 1) * frame_row + y) * var_step + x] = var_next;\n"
"sortKey_prev = sortKey_next;\n"
"sortKey_next = k1 > 0 ? sortKey[((k1 - 1) * frame_row + y) * sortKey_step + x] : 0.0f;\n"
"weight_prev = weight_next;\n"
"weight_next = k1 > 0 ? weight[((k1 - 1) * frame_row + y) * weight_step + x] : 0.0f;\n"
"mean_prev = mean_next;\n"
"mean_next = k1 > 0 ? mean[((k1 - 1) * frame_row + y) * mean_step + x] : (T_MEAN_VAR)F_ZERO;\n"
"var_prev = var_next;\n"
"var_next = k1 > 0 ? var[((k1 - 1) * frame_row + y) * var_step + x] : (T_MEAN_VAR)F_ZERO;\n"
"}\n"
"}\n"
"kHit = k1 + 1;\n"
"break;\n"
"}\n"
"if (kHit < 0)\n"
"{\n"
"kHit = k = k < ((NMIXTURES) - 1) ? k : ((NMIXTURES) - 1);\n"
"wsum += w0 - weight[(k * frame_row + y) * weight_step + x];\n"
"weight[(k * frame_row + y) * weight_step + x] = w0;\n"
"mean[(k * frame_row + y) * mean_step + x] = pix;\n"
"#if defined (CN1)\n"
"var[(k * frame_row + y) * var_step + x] = (T_MEAN_VAR)(var0);\n"
"#else\n"
"var[(k * frame_row + y) * var_step + x] = (T_MEAN_VAR)(var0, var0, var0, var0);\n"
"#endif\n"
"sortKey[(k * frame_row + y) * sortKey_step + x] = sk0;\n"
"}\n"
"else\n"
"{\n"
"for( ; k < (NMIXTURES); k++)\n"
"wsum += weight[(k * frame_row + y) * weight_step + x];\n"
"}\n"
"float wscale = 1.0f / wsum;\n"
"wsum = 0;\n"
"for (k = 0; k < (NMIXTURES); ++k)\n"
"{\n"
"float w = weight[(k * frame_row + y) * weight_step + x];\n"
"w *= wscale;\n"
"wsum += w;\n"
"weight[(k * frame_row + y) * weight_step + x] = w;\n"
"sortKey[(k * frame_row + y) * sortKey_step + x] *= wscale;\n"
"kForeground = select(kForeground, k + 1, wsum > backgroundRatio && kForeground < 0);\n"
"}\n"
"fgmask[(y + fgmask_offset_y) * fgmask_step + (x + fgmask_offset_x)] = (uchar)(-(kHit >= kForeground));\n"
"}\n"
"__kernel void getBackgroundImage_kernel(__global float* weight, __global T_MEAN_VAR* mean, __global T_FRAME* dst,\n"
"int dst_row, int dst_col, int weight_step, int mean_step, int dst_step,\n"
"float backgroundRatio)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < dst_col && y < dst_row)\n"
"{\n"
"T_MEAN_VAR meanVal = (T_MEAN_VAR)F_ZERO;\n"
"float totalWeight = 0.0f;\n"
"for (int mode = 0; mode < (NMIXTURES); ++mode)\n"
"{\n"
"float _weight = weight[(mode * dst_row + y) * weight_step + x];\n"
"T_MEAN_VAR _mean = mean[(mode * dst_row + y) * mean_step + x];\n"
"meanVal = meanVal + _weight * _mean;\n"
"totalWeight += _weight;\n"
"if(totalWeight > backgroundRatio)\n"
"break;\n"
"}\n"
"meanVal = meanVal * (1.f / totalWeight);\n"
"dst[y * dst_step + x] = CONVERT_TYPE(meanVal);\n"
"}\n"
"}\n"
"__kernel void mog2_kernel(__global T_FRAME * frame, __global int* fgmask, __global float* weight, __global T_MEAN_VAR * mean,\n"
"__global int* modesUsed, __global float* variance, int frame_row, int frame_col, int frame_step,\n"
"int fgmask_step, int weight_step, int mean_step, int modesUsed_step, int var_step, float alphaT, float alpha1, float prune,\n"
"int detectShadows_flag, int fgmask_offset_x, int fgmask_offset_y, int frame_offset_x, int frame_offset_y, __constant con_srtuct_t* constants)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < frame_col && y < frame_row)\n"
"{\n"
"T_MEAN_VAR pix = cvt(frame[(y + frame_offset_y) * frame_step + x + frame_offset_x]);\n"
"bool background = false;\n"
"bool fitsPDF = false;\n"
"int nmodes = modesUsed[y * modesUsed_step + x];\n"
"int nNewModes = nmodes;\n"
"float totalWeight = 0.0f;\n"
"for (int mode = 0; mode < nmodes; ++mode)\n"
"{\n"
"float _weight = alpha1 * weight[(mode * frame_row + y) * weight_step + x] + prune;\n"
"int swap_count = 0;\n"
"if (!fitsPDF)\n"
"{\n"
"float var = variance[(mode * frame_row + y) * var_step + x];\n"
"T_MEAN_VAR _mean = mean[(mode * frame_row + y) * mean_step + x];\n"
"T_MEAN_VAR diff = _mean - pix;\n"
"float dist2 = sqr(diff);\n"
"if (totalWeight < constants -> c_TB && dist2 < constants -> c_Tb * var)\n"
"background = true;\n"
"if (dist2 < constants -> c_Tg * var)\n"
"{\n"
"fitsPDF = true;\n"
"_weight += alphaT;\n"
"float k = alphaT / _weight;\n"
"mean[(mode * frame_row + y) * mean_step + x] = _mean - k * diff;\n"
"float varnew = var + k * (dist2 - var);\n"
"varnew = fmax(varnew, constants -> c_varMin);\n"
"varnew = fmin(varnew, constants -> c_varMax);\n"
"variance[(mode * frame_row + y) * var_step + x] = varnew;\n"
"for (int i = mode; i > 0; --i)\n"
"{\n"
"if (_weight < weight[((i - 1) * frame_row + y) * weight_step + x])\n"
"break;\n"
"swap_count++;\n"
"swap(weight, x, y, i - 1, frame_row, weight_step);\n"
"swap(variance, x, y, i - 1, frame_row, var_step);\n"
"#if defined (CN1)\n"
"swap(mean, x, y, i - 1, frame_row, mean_step);\n"
"#else\n"
"swap4(mean, x, y, i - 1, frame_row, mean_step);\n"
"#endif\n"
"}\n"
"}\n"
"}\n"
"if (_weight < -prune)\n"
"{\n"
"_weight = 0.0f;\n"
"nmodes--;\n"
"}\n"
"weight[((mode - swap_count) * frame_row + y) * weight_step + x] = _weight;\n"
"totalWeight += _weight;\n"
"}\n"
"totalWeight = 1.f / totalWeight;\n"
"for (int mode = 0; mode < nmodes; ++mode)\n"
"weight[(mode * frame_row + y) * weight_step + x] *= totalWeight;\n"
"nmodes = nNewModes;\n"
"if (!fitsPDF)\n"
"{\n"
"int mode = nmodes == (NMIXTURES) ? (NMIXTURES) - 1 : nmodes++;\n"
"if (nmodes == 1)\n"
"weight[(mode * frame_row + y) * weight_step + x] = 1.f;\n"
"else\n"
"{\n"
"weight[(mode * frame_row + y) * weight_step + x] = alphaT;\n"
"for (int i = 0; i < nmodes - 1; ++i)\n"
"weight[(i * frame_row + y) * weight_step + x] *= alpha1;\n"
"}\n"
"mean[(mode * frame_row + y) * mean_step + x] = pix;\n"
"variance[(mode * frame_row + y) * var_step + x] = constants -> c_varInit;\n"
"for (int i = nmodes - 1; i > 0; --i)\n"
"{\n"
"if (alphaT < weight[((i - 1) * frame_row + y) * weight_step + x])\n"
"break;\n"
"swap(weight, x, y, i - 1, frame_row, weight_step);\n"
"swap(variance, x, y, i - 1, frame_row, var_step);\n"
"#if defined (CN1)\n"
"swap(mean, x, y, i - 1, frame_row, mean_step);\n"
"#else\n"
"swap4(mean, x, y, i - 1, frame_row, mean_step);\n"
"#endif\n"
"}\n"
"}\n"
"modesUsed[y * modesUsed_step + x] = nmodes;\n"
"bool isShadow = false;\n"
"if (detectShadows_flag && !background)\n"
"{\n"
"float tWeight = 0.0f;\n"
"for (int mode = 0; mode < nmodes; ++mode)\n"
"{\n"
"T_MEAN_VAR _mean = mean[(mode * frame_row + y) * mean_step + x];\n"
"T_MEAN_VAR pix_mean = pix * _mean;\n"
"float numerator = sum(pix_mean);\n"
"float denominator = sqr(_mean);\n"
"if (denominator == 0)\n"
"break;\n"
"if (numerator <= denominator && numerator >= constants -> c_tau * denominator)\n"
"{\n"
"float a = numerator / denominator;\n"
"T_MEAN_VAR dD = a * _mean - pix;\n"
"if (sqr(dD) < constants -> c_Tb * variance[(mode * frame_row + y) * var_step + x] * a * a)\n"
"{\n"
"isShadow = true;\n"
"break;\n"
"}\n"
"}\n"
"tWeight += weight[(mode * frame_row + y) * weight_step + x];\n"
"if (tWeight > constants -> c_TB)\n"
"break;\n"
"}\n"
"}\n"
"fgmask[(y + fgmask_offset_y) * fgmask_step + x + fgmask_offset_x] = background ? 0 : isShadow ? constants -> c_shadowVal : 255;\n"
"}\n"
"}\n"
"__kernel void getBackgroundImage2_kernel(__global int* modesUsed, __global float* weight, __global T_MEAN_VAR* mean,\n"
"__global T_FRAME* dst, float c_TB, int modesUsed_row, int modesUsed_col, int modesUsed_step, int weight_step,\n"
"int mean_step, int dst_step, int dst_x, int dst_y)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < modesUsed_col && y < modesUsed_row)\n"
"{\n"
"int nmodes = modesUsed[y * modesUsed_step + x];\n"
"T_MEAN_VAR meanVal = (T_MEAN_VAR)F_ZERO;\n"
"float totalWeight = 0.0f;\n"
"for (int mode = 0; mode < nmodes; ++mode)\n"
"{\n"
"float _weight = weight[(mode * modesUsed_row + y) * weight_step + x];\n"
"T_MEAN_VAR _mean = mean[(mode * modesUsed_row + y) * mean_step + x];\n"
"meanVal = meanVal + _weight * _mean;\n"
"totalWeight += _weight;\n"
"if(totalWeight > c_TB)\n"
"break;\n"
"}\n"
"meanVal = meanVal * (1.f / totalWeight);\n"
"dst[(y + dst_y) * dst_step + x + dst_x] = CONVERT_TYPE(meanVal);\n"
"}\n"
"}\n"
, "7fd1eedde22b5fad55ba5eb9cac67955"};
const struct ProgramEntry blend_linear={"blend_linear",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void blendLinear(__global const T * src1, int src1_offset, int src1_step,\n"
"__global const T * src2, int src2_offset, int src2_step,\n"
"__global const float * weight1, int weight1_offset, int weight1_step,\n"
"__global const float * weight2, int weight2_offset, int weight2_step,\n"
"__global T * dst, int dst_offset, int dst_step,\n"
"int rows, int cols)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int src1_index = mad24(y, src1_step, src1_offset + x);\n"
"int src2_index = mad24(y, src2_step, src2_offset + x);\n"
"int weight1_index = mad24(y, weight1_step, weight1_offset + x);\n"
"int weight2_index = mad24(y, weight2_step, weight2_offset + x);\n"
"int dst_index = mad24(y, dst_step, dst_offset + x);\n"
"FT w1 = (FT)(weight1[weight1_index]), w2 = (FT)(weight2[weight2_index]);\n"
"FT den = w1 + w2 + (FT)(1e-5f);\n"
"FT num = w1 * convertToFT(src1[src1_index]) + w2 * convertToFT(src2[src2_index]);\n"
"dst[dst_index] = convertToT(num / den);\n"
"}\n"
"}\n"
, "282ca434c43357705cd20966671a57ef"};
const struct ProgramEntry brute_force_match={"brute_force_match",
"#pragma OPENCL EXTENSION cl_khr_global_int32_base_atomics:enable\n"
"#define MAX_FLOAT 3.40282e+038f\n"
"#ifndef T\n"
"#define T float\n"
"#endif\n"
"#ifndef BLOCK_SIZE\n"
"#define BLOCK_SIZE 16\n"
"#endif\n"
"#ifndef MAX_DESC_LEN\n"
"#define MAX_DESC_LEN 64\n"
"#endif\n"
"#ifndef DIST_TYPE\n"
"#define DIST_TYPE 0\n"
"#endif\n"
"#if   (DIST_TYPE == 0)\n"
"#   ifdef T_FLOAT\n"
"#       define DIST(x, y) fabs((x) - (y))\n"
"typedef float value_type;\n"
"typedef float result_type;\n"
"#   else\n"
"#       define DIST(x, y) abs((x) - (y))\n"
"typedef int value_type;\n"
"typedef int result_type;\n"
"#   endif\n"
"#define DIST_RES(x) (x)\n"
"#elif (DIST_TYPE == 1)\n"
"#define DIST(x, y) (((x) - (y)) * ((x) - (y)))\n"
"typedef float value_type;\n"
"typedef float result_type;\n"
"#define DIST_RES(x) sqrt(x)\n"
"#elif (DIST_TYPE == 2)\n"
"int bit1Count(int v)\n"
"{\n"
"v = v - ((v >> 1) & 0x55555555);\n"
"v = (v & 0x33333333) + ((v >> 2) & 0x33333333);\n"
"return ((v + (v >> 4) & 0xF0F0F0F) * 0x1010101) >> 24;\n"
"}\n"
"#define DIST(x, y) bit1Count( (x) ^ (y) )\n"
"typedef int value_type;\n"
"typedef int result_type;\n"
"#define DIST_RES(x) (x)\n"
"#endif\n"
"result_type reduce_block(\n"
"__local value_type *s_query,\n"
"__local value_type *s_train,\n"
"int lidx,\n"
"int lidy\n"
")\n"
"{\n"
"result_type result = 0;\n"
"#pragma unroll\n"
"for (int j = 0 ; j < BLOCK_SIZE ; j++)\n"
"{\n"
"result += DIST(\n"
"s_query[lidy * BLOCK_SIZE + j],\n"
"s_train[j * BLOCK_SIZE + lidx]);\n"
"}\n"
"return DIST_RES(result);\n"
"}\n"
"result_type reduce_block_match(\n"
"__local value_type *s_query,\n"
"__local value_type *s_train,\n"
"int lidx,\n"
"int lidy\n"
")\n"
"{\n"
"result_type result = 0;\n"
"#pragma unroll\n"
"for (int j = 0 ; j < BLOCK_SIZE ; j++)\n"
"{\n"
"result += DIST(\n"
"s_query[lidy * BLOCK_SIZE + j],\n"
"s_train[j * BLOCK_SIZE + lidx]);\n"
"}\n"
"return (result);\n"
"}\n"
"result_type reduce_multi_block(\n"
"__local value_type *s_query,\n"
"__local value_type *s_train,\n"
"int block_index,\n"
"int lidx,\n"
"int lidy\n"
")\n"
"{\n"
"result_type result = 0;\n"
"#pragma unroll\n"
"for (int j = 0 ; j < BLOCK_SIZE ; j++)\n"
"{\n"
"result += DIST(\n"
"s_query[lidy * MAX_DESC_LEN + block_index * BLOCK_SIZE + j],\n"
"s_train[j * BLOCK_SIZE + lidx]);\n"
"}\n"
"return result;\n"
"}\n"
"__kernel void BruteForceMatch_UnrollMatch(\n"
"__global T *query,\n"
"__global T *train,\n"
"__global int *bestTrainIdx,\n"
"__global float *bestDistance,\n"
"__local float *sharebuffer,\n"
"int query_rows,\n"
"int query_cols,\n"
"int train_rows,\n"
"int train_cols,\n"
"int step\n"
")\n"
"{\n"
"const int lidx = get_local_id(0);\n"
"const int lidy = get_local_id(1);\n"
"const int groupidx = get_group_id(0);\n"
"__local value_type *s_query = (__local value_type *)sharebuffer;\n"
"__local value_type *s_train = (__local value_type *)sharebuffer + BLOCK_SIZE * MAX_DESC_LEN;\n"
"int queryIdx = groupidx * BLOCK_SIZE + lidy;\n"
"#pragma unroll\n"
"for (int i = 0 ;  i <  MAX_DESC_LEN / BLOCK_SIZE; i ++)\n"
"{\n"
"int loadx = lidx + i * BLOCK_SIZE;\n"
"s_query[lidy * MAX_DESC_LEN + loadx] = loadx < query_cols ? query[min(queryIdx, query_rows - 1)  * (step / sizeof(T)) + loadx] : 0;\n"
"}\n"
"float myBestDistance = MAX_FLOAT;\n"
"int myBestTrainIdx = -1;\n"
"for (int t = 0, endt = (train_rows + BLOCK_SIZE - 1) / BLOCK_SIZE; t < endt; t++)\n"
"{\n"
"result_type result = 0;\n"
"#pragma unroll\n"
"for (int i = 0 ; i < MAX_DESC_LEN / BLOCK_SIZE ; i++)\n"
"{\n"
"const int loadx = lidx + i * BLOCK_SIZE;\n"
"s_train[lidx * BLOCK_SIZE + lidy] = loadx < train_cols ? train[min(t * BLOCK_SIZE + lidy, train_rows - 1) * (step / sizeof(T)) + loadx] : 0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"result += reduce_multi_block(s_query, s_train, i, lidx, lidy);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"result = DIST_RES(result);\n"
"int trainIdx = t * BLOCK_SIZE + lidx;\n"
"if (queryIdx < query_rows && trainIdx < train_rows && result < myBestDistance)\n"
"{\n"
"myBestDistance = result;\n"
"myBestTrainIdx = trainIdx;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"__local float *s_distance = (__local float*)(sharebuffer);\n"
"__local int* s_trainIdx = (__local int *)(sharebuffer + BLOCK_SIZE * BLOCK_SIZE);\n"
"s_distance += lidy * BLOCK_SIZE;\n"
"s_trainIdx += lidy * BLOCK_SIZE;\n"
"s_distance[lidx] = myBestDistance;\n"
"s_trainIdx[lidx] = myBestTrainIdx;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"#pragma unroll\n"
"for (int k = 0 ; k < BLOCK_SIZE; k++)\n"
"{\n"
"if (myBestDistance > s_distance[k])\n"
"{\n"
"myBestDistance = s_distance[k];\n"
"myBestTrainIdx = s_trainIdx[k];\n"
"}\n"
"}\n"
"if (queryIdx < query_rows && lidx == 0)\n"
"{\n"
"bestTrainIdx[queryIdx] = myBestTrainIdx;\n"
"bestDistance[queryIdx] = myBestDistance;\n"
"}\n"
"}\n"
"__kernel void BruteForceMatch_Match(\n"
"__global T *query,\n"
"__global T *train,\n"
"__global int *bestTrainIdx,\n"
"__global float *bestDistance,\n"
"__local float *sharebuffer,\n"
"int query_rows,\n"
"int query_cols,\n"
"int train_rows,\n"
"int train_cols,\n"
"int step\n"
")\n"
"{\n"
"const int lidx = get_local_id(0);\n"
"const int lidy = get_local_id(1);\n"
"const int groupidx = get_group_id(0);\n"
"const int queryIdx = groupidx * BLOCK_SIZE + lidy;\n"
"float myBestDistance = MAX_FLOAT;\n"
"int myBestTrainIdx = -1;\n"
"__local value_type *s_query = (__local value_type *)sharebuffer;\n"
"__local value_type *s_train = (__local value_type *)sharebuffer + BLOCK_SIZE * BLOCK_SIZE;\n"
"for (int t = 0 ;  t < (train_rows + BLOCK_SIZE - 1) / BLOCK_SIZE ; t++)\n"
"{\n"
"result_type result = 0;\n"
"for (int i = 0 ; i < (query_cols + BLOCK_SIZE - 1) / BLOCK_SIZE ; i++)\n"
"{\n"
"const int loadx = lidx + i * BLOCK_SIZE;\n"
"s_query[lidy * BLOCK_SIZE + lidx] = 0;\n"
"s_train[lidx * BLOCK_SIZE + lidy] = 0;\n"
"if (loadx < query_cols)\n"
"{\n"
"s_query[lidy * BLOCK_SIZE + lidx] = query[min(queryIdx, query_rows - 1) * (step / sizeof(T)) + loadx];\n"
"s_train[lidx * BLOCK_SIZE + lidy] = train[min(t * BLOCK_SIZE + lidy, train_rows - 1) * (step / sizeof(T)) + loadx];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"result += reduce_block_match(s_query, s_train, lidx, lidy);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"result = DIST_RES(result);\n"
"const int trainIdx = t * BLOCK_SIZE + lidx;\n"
"if (queryIdx < query_rows && trainIdx < train_rows && result < myBestDistance )\n"
"{\n"
"myBestDistance = result;\n"
"myBestTrainIdx = trainIdx;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"__local float *s_distance = (__local float *)sharebuffer;\n"
"__local int *s_trainIdx = (__local int *)(sharebuffer + BLOCK_SIZE * BLOCK_SIZE);\n"
"s_distance += lidy * BLOCK_SIZE;\n"
"s_trainIdx += lidy * BLOCK_SIZE;\n"
"s_distance[lidx] = myBestDistance;\n"
"s_trainIdx[lidx] = myBestTrainIdx;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for (int k = 0 ; k < BLOCK_SIZE; k++)\n"
"{\n"
"if (myBestDistance > s_distance[k])\n"
"{\n"
"myBestDistance = s_distance[k];\n"
"myBestTrainIdx = s_trainIdx[k];\n"
"}\n"
"}\n"
"if (queryIdx < query_rows && lidx == 0)\n"
"{\n"
"bestTrainIdx[queryIdx] = myBestTrainIdx;\n"
"bestDistance[queryIdx] = myBestDistance;\n"
"}\n"
"}\n"
"__kernel void BruteForceMatch_RadiusUnrollMatch(\n"
"__global T *query,\n"
"__global T *train,\n"
"float maxDistance,\n"
"__global int *bestTrainIdx,\n"
"__global float *bestDistance,\n"
"__global int *nMatches,\n"
"__local float *sharebuffer,\n"
"int query_rows,\n"
"int query_cols,\n"
"int train_rows,\n"
"int train_cols,\n"
"int bestTrainIdx_cols,\n"
"int step,\n"
"int ostep\n"
")\n"
"{\n"
"const int lidx = get_local_id(0);\n"
"const int lidy = get_local_id(1);\n"
"const int groupidx = get_group_id(0);\n"
"const int groupidy = get_group_id(1);\n"
"const int queryIdx = groupidy * BLOCK_SIZE + lidy;\n"
"const int trainIdx = groupidx * BLOCK_SIZE + lidx;\n"
"__local value_type *s_query = (__local value_type *)sharebuffer;\n"
"__local value_type *s_train = (__local value_type *)sharebuffer + BLOCK_SIZE * BLOCK_SIZE;\n"
"result_type result = 0;\n"
"for (int i = 0 ; i < MAX_DESC_LEN / BLOCK_SIZE ; ++i)\n"
"{\n"
"const int loadx = lidx + i * BLOCK_SIZE;\n"
"s_query[lidy * BLOCK_SIZE + lidx] = loadx < query_cols ? query[min(queryIdx, query_rows - 1)  * (step / sizeof(T)) + loadx] : 0;\n"
"s_train[lidx * BLOCK_SIZE + lidy] = loadx < query_cols ? train[min(groupidx * BLOCK_SIZE + lidy, train_rows - 1)  * (step / sizeof(T)) + loadx] : 0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"result += reduce_block(s_query, s_train, lidx, lidy);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"if (queryIdx < query_rows && trainIdx < train_rows &&\n"
"convert_float(result) < maxDistance)\n"
"{\n"
"int ind = atom_inc(nMatches + queryIdx);\n"
"if(ind < bestTrainIdx_cols)\n"
"{\n"
"bestTrainIdx[queryIdx * (ostep / sizeof(int)) + ind] = trainIdx;\n"
"bestDistance[queryIdx * (ostep / sizeof(float)) + ind] = result;\n"
"}\n"
"}\n"
"}\n"
"__kernel void BruteForceMatch_RadiusMatch(\n"
"__global T *query,\n"
"__global T *train,\n"
"float maxDistance,\n"
"__global int *bestTrainIdx,\n"
"__global float *bestDistance,\n"
"__global int *nMatches,\n"
"__local float *sharebuffer,\n"
"int query_rows,\n"
"int query_cols,\n"
"int train_rows,\n"
"int train_cols,\n"
"int bestTrainIdx_cols,\n"
"int step,\n"
"int ostep\n"
")\n"
"{\n"
"const int lidx = get_local_id(0);\n"
"const int lidy = get_local_id(1);\n"
"const int groupidx = get_group_id(0);\n"
"const int groupidy = get_group_id(1);\n"
"const int queryIdx = groupidy * BLOCK_SIZE + lidy;\n"
"const int trainIdx = groupidx * BLOCK_SIZE + lidx;\n"
"__local value_type *s_query = (__local value_type *)sharebuffer;\n"
"__local value_type *s_train = (__local value_type *)sharebuffer + BLOCK_SIZE * BLOCK_SIZE;\n"
"result_type result = 0;\n"
"for (int i = 0 ; i < (query_cols + BLOCK_SIZE - 1) / BLOCK_SIZE ; ++i)\n"
"{\n"
"const int loadx = lidx + i * BLOCK_SIZE;\n"
"s_query[lidy * BLOCK_SIZE + lidx] = loadx < query_cols ? query[min(queryIdx, query_rows - 1)  * (step / sizeof(T)) + loadx] : 0;\n"
"s_train[lidx * BLOCK_SIZE + lidy] = loadx < query_cols ? train[min(groupidx * BLOCK_SIZE + lidy, train_rows - 1)  * (step / sizeof(T)) + loadx] : 0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"result += reduce_block(s_query, s_train, lidx, lidy);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"if (queryIdx < query_rows && trainIdx < train_rows &&\n"
"convert_float(result) < maxDistance)\n"
"{\n"
"int ind = atom_inc(nMatches + queryIdx);\n"
"if(ind < bestTrainIdx_cols)\n"
"{\n"
"bestTrainIdx[queryIdx * (ostep / sizeof(int)) + ind] = trainIdx;\n"
"bestDistance[queryIdx * (ostep / sizeof(float)) + ind] = result;\n"
"}\n"
"}\n"
"}\n"
"__kernel void BruteForceMatch_knnUnrollMatch(\n"
"__global T *query,\n"
"__global T *train,\n"
"__global int2 *bestTrainIdx,\n"
"__global float2 *bestDistance,\n"
"__local float *sharebuffer,\n"
"int query_rows,\n"
"int query_cols,\n"
"int train_rows,\n"
"int train_cols,\n"
"int step\n"
")\n"
"{\n"
"const int lidx = get_local_id(0);\n"
"const int lidy = get_local_id(1);\n"
"const int groupidx = get_group_id(0);\n"
"const int queryIdx = groupidx * BLOCK_SIZE + lidy;\n"
"__local value_type *s_query = (__local value_type *)sharebuffer;\n"
"__local value_type *s_train = (__local value_type *)sharebuffer + BLOCK_SIZE * MAX_DESC_LEN;\n"
"for (int i = 0 ;  i <  MAX_DESC_LEN / BLOCK_SIZE; i ++)\n"
"{\n"
"int loadx = lidx + i * BLOCK_SIZE;\n"
"s_query[lidy * MAX_DESC_LEN + loadx] = loadx < query_cols ? query[min(queryIdx, query_rows - 1)  * (step / sizeof(T)) + loadx] : 0;\n"
"}\n"
"float myBestDistance1 = MAX_FLOAT;\n"
"float myBestDistance2 = MAX_FLOAT;\n"
"int myBestTrainIdx1 = -1;\n"
"int myBestTrainIdx2 = -1;\n"
"for (int t = 0 ; t < (train_rows + BLOCK_SIZE - 1) / BLOCK_SIZE ; t++)\n"
"{\n"
"result_type result = 0;\n"
"for (int i = 0 ; i < MAX_DESC_LEN / BLOCK_SIZE ; i++)\n"
"{\n"
"const int loadx = lidx + i * BLOCK_SIZE;\n"
"s_train[lidx * BLOCK_SIZE + lidy] = loadx < train_cols ? train[min(t * BLOCK_SIZE + lidy, train_rows - 1) * (step / sizeof(T)) + loadx] : 0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"result += reduce_multi_block(s_query, s_train, i, lidx, lidy);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"result = DIST_RES(result);\n"
"const int trainIdx = t * BLOCK_SIZE + lidx;\n"
"if (queryIdx < query_rows && trainIdx < train_rows)\n"
"{\n"
"if (result < myBestDistance1)\n"
"{\n"
"myBestDistance2 = myBestDistance1;\n"
"myBestTrainIdx2 = myBestTrainIdx1;\n"
"myBestDistance1 = result;\n"
"myBestTrainIdx1 = trainIdx;\n"
"}\n"
"else if (result < myBestDistance2)\n"
"{\n"
"myBestDistance2 = result;\n"
"myBestTrainIdx2 = trainIdx;\n"
"}\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"__local float *s_distance = (local float *)sharebuffer;\n"
"__local int *s_trainIdx = (local int *)(sharebuffer + BLOCK_SIZE * BLOCK_SIZE);\n"
"s_distance += lidy * BLOCK_SIZE;\n"
"s_trainIdx += lidy * BLOCK_SIZE;\n"
"s_distance[lidx] = myBestDistance1;\n"
"s_trainIdx[lidx] = myBestTrainIdx1;\n"
"float bestDistance1 = MAX_FLOAT;\n"
"float bestDistance2 = MAX_FLOAT;\n"
"int bestTrainIdx1 = -1;\n"
"int bestTrainIdx2 = -1;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lidx == 0)\n"
"{\n"
"for (int i = 0 ; i < BLOCK_SIZE ; i++)\n"
"{\n"
"float val = s_distance[i];\n"
"if (val < bestDistance1)\n"
"{\n"
"bestDistance2 = bestDistance1;\n"
"bestTrainIdx2 = bestTrainIdx1;\n"
"bestDistance1 = val;\n"
"bestTrainIdx1 = s_trainIdx[i];\n"
"}\n"
"else if (val < bestDistance2)\n"
"{\n"
"bestDistance2 = val;\n"
"bestTrainIdx2 = s_trainIdx[i];\n"
"}\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"s_distance[lidx] = myBestDistance2;\n"
"s_trainIdx[lidx] = myBestTrainIdx2;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lidx == 0)\n"
"{\n"
"for (int i = 0 ; i < BLOCK_SIZE ; i++)\n"
"{\n"
"float val = s_distance[i];\n"
"if (val < bestDistance2)\n"
"{\n"
"bestDistance2 = val;\n"
"bestTrainIdx2 = s_trainIdx[i];\n"
"}\n"
"}\n"
"}\n"
"myBestDistance1 = bestDistance1;\n"
"myBestDistance2 = bestDistance2;\n"
"myBestTrainIdx1 = bestTrainIdx1;\n"
"myBestTrainIdx2 = bestTrainIdx2;\n"
"if (queryIdx < query_rows && lidx == 0)\n"
"{\n"
"bestTrainIdx[queryIdx] = (int2)(myBestTrainIdx1, myBestTrainIdx2);\n"
"bestDistance[queryIdx] = (float2)(myBestDistance1, myBestDistance2);\n"
"}\n"
"}\n"
"__kernel void BruteForceMatch_knnMatch(\n"
"__global T *query,\n"
"__global T *train,\n"
"__global int2 *bestTrainIdx,\n"
"__global float2 *bestDistance,\n"
"__local float *sharebuffer,\n"
"int query_rows,\n"
"int query_cols,\n"
"int train_rows,\n"
"int train_cols,\n"
"int step\n"
")\n"
"{\n"
"const int lidx = get_local_id(0);\n"
"const int lidy = get_local_id(1);\n"
"const int groupidx = get_group_id(0);\n"
"const int queryIdx = groupidx * BLOCK_SIZE + lidy;\n"
"__local value_type *s_query = (__local value_type *)sharebuffer;\n"
"__local value_type *s_train = (__local value_type *)sharebuffer + BLOCK_SIZE * BLOCK_SIZE;\n"
"float myBestDistance1 = MAX_FLOAT;\n"
"float myBestDistance2 = MAX_FLOAT;\n"
"int myBestTrainIdx1 = -1;\n"
"int myBestTrainIdx2 = -1;\n"
"for (int  t = 0 ; t < (train_rows + BLOCK_SIZE - 1) / BLOCK_SIZE ; t++)\n"
"{\n"
"result_type result = 0.0f;\n"
"for (int i = 0 ; i < (query_cols + BLOCK_SIZE -1) / BLOCK_SIZE ; i++)\n"
"{\n"
"const int loadx = lidx + i * BLOCK_SIZE;\n"
"s_query[lidy * BLOCK_SIZE + lidx] = 0;\n"
"s_train[lidx * BLOCK_SIZE + lidy] = 0;\n"
"if (loadx < query_cols)\n"
"{\n"
"s_query[lidy * BLOCK_SIZE + lidx] = query[min(queryIdx, query_rows - 1) * (step / sizeof(T)) + loadx];\n"
"s_train[lidx * BLOCK_SIZE + lidy] = train[min(t * BLOCK_SIZE + lidy, train_rows - 1) * (step / sizeof(T)) + loadx];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"result += reduce_block_match(s_query, s_train, lidx, lidy);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"result = DIST_RES(result);\n"
"const int trainIdx = t * BLOCK_SIZE + lidx;\n"
"if (queryIdx < query_rows && trainIdx < train_rows )\n"
"{\n"
"if (result < myBestDistance1)\n"
"{\n"
"myBestDistance2 = myBestDistance1;\n"
"myBestTrainIdx2 = myBestTrainIdx1;\n"
"myBestDistance1 = result;\n"
"myBestTrainIdx1 = trainIdx;\n"
"}\n"
"else if (result < myBestDistance2)\n"
"{\n"
"myBestDistance2 = result;\n"
"myBestTrainIdx2 = trainIdx;\n"
"}\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"__local float *s_distance = (__local float *)sharebuffer;\n"
"__local int *s_trainIdx = (__local int *)(sharebuffer + BLOCK_SIZE * BLOCK_SIZE);\n"
"s_distance += lidy * BLOCK_SIZE;\n"
"s_trainIdx += lidy * BLOCK_SIZE;\n"
"s_distance[lidx] = myBestDistance1;\n"
"s_trainIdx[lidx] = myBestTrainIdx1;\n"
"float bestDistance1 = MAX_FLOAT;\n"
"float bestDistance2 = MAX_FLOAT;\n"
"int bestTrainIdx1 = -1;\n"
"int bestTrainIdx2 = -1;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lidx == 0)\n"
"{\n"
"for (int i = 0 ; i < BLOCK_SIZE ; i++)\n"
"{\n"
"float val = s_distance[i];\n"
"if (val < bestDistance1)\n"
"{\n"
"bestDistance2 = bestDistance1;\n"
"bestTrainIdx2 = bestTrainIdx1;\n"
"bestDistance1 = val;\n"
"bestTrainIdx1 = s_trainIdx[i];\n"
"}\n"
"else if (val < bestDistance2)\n"
"{\n"
"bestDistance2 = val;\n"
"bestTrainIdx2 = s_trainIdx[i];\n"
"}\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"s_distance[lidx] = myBestDistance2;\n"
"s_trainIdx[lidx] = myBestTrainIdx2;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lidx == 0)\n"
"{\n"
"for (int i = 0 ; i < BLOCK_SIZE ; i++)\n"
"{\n"
"float val = s_distance[i];\n"
"if (val < bestDistance2)\n"
"{\n"
"bestDistance2 = val;\n"
"bestTrainIdx2 = s_trainIdx[i];\n"
"}\n"
"}\n"
"}\n"
"myBestDistance1 = bestDistance1;\n"
"myBestDistance2 = bestDistance2;\n"
"myBestTrainIdx1 = bestTrainIdx1;\n"
"myBestTrainIdx2 = bestTrainIdx2;\n"
"if (queryIdx < query_rows && lidx == 0)\n"
"{\n"
"bestTrainIdx[queryIdx] = (int2)(myBestTrainIdx1, myBestTrainIdx2);\n"
"bestDistance[queryIdx] = (float2)(myBestDistance1, myBestDistance2);\n"
"}\n"
"}\n"
"kernel void BruteForceMatch_calcDistanceUnrolled(\n"
"__global T *query,\n"
"__global T *train,\n"
"__global float *allDist,\n"
"__local float *sharebuffer,\n"
"int query_rows,\n"
"int query_cols,\n"
"int train_rows,\n"
"int train_cols,\n"
"int step)\n"
"{\n"
"}\n"
"kernel void BruteForceMatch_calcDistance(\n"
"__global T *query,\n"
"__global T *train,\n"
"__global float *allDist,\n"
"__local float *sharebuffer,\n"
"int query_rows,\n"
"int query_cols,\n"
"int train_rows,\n"
"int train_cols,\n"
"int step)\n"
"{\n"
"}\n"
"kernel void BruteForceMatch_findBestMatch(\n"
"__global float *allDist,\n"
"__global int *bestTrainIdx,\n"
"__global float *bestDistance,\n"
"int k\n"
")\n"
"{\n"
"}\n"
, "14abdacaf283cc25bdb9a58eb651a26b"};
const struct ProgramEntry build_warps={"build_warps",
"__kernel void buildWarpPlaneMaps(__global float * xmap, __global float * ymap,\n"
"__constant float * KRT,\n"
"int tl_u, int tl_v,\n"
"int cols, int rows,\n"
"int xmap_step, int ymap_step,\n"
"int xmap_offset, int ymap_offset,\n"
"float scale)\n"
"{\n"
"int du = get_global_id(0);\n"
"int dv = get_global_id(1);\n"
"__constant float * ck_rinv = KRT;\n"
"__constant float * ct      = KRT + 9;\n"
"if (du < cols && dv < rows)\n"
"{\n"
"int xmap_index = mad24(dv, xmap_step, xmap_offset + du);\n"
"int ymap_index = mad24(dv, ymap_step, ymap_offset + du);\n"
"float u = tl_u + du;\n"
"float v = tl_v + dv;\n"
"float x, y;\n"
"float x_ = u / scale - ct[0];\n"
"float y_ = v / scale - ct[1];\n"
"float z;\n"
"x = ck_rinv[0] * x_ + ck_rinv[1] * y_ + ck_rinv[2] * (1 - ct[2]);\n"
"y = ck_rinv[3] * x_ + ck_rinv[4] * y_ + ck_rinv[5] * (1 - ct[2]);\n"
"z = ck_rinv[6] * x_ + ck_rinv[7] * y_ + ck_rinv[8] * (1 - ct[2]);\n"
"x /= z;\n"
"y /= z;\n"
"xmap[xmap_index] = x;\n"
"ymap[ymap_index] = y;\n"
"}\n"
"}\n"
"__kernel void buildWarpCylindricalMaps(__global float * xmap, __global float * ymap,\n"
"__constant float * ck_rinv,\n"
"int tl_u, int tl_v,\n"
"int cols, int rows,\n"
"int xmap_step, int ymap_step,\n"
"int xmap_offset, int ymap_offset,\n"
"float scale)\n"
"{\n"
"int du = get_global_id(0);\n"
"int dv = get_global_id(1);\n"
"if (du < cols && dv < rows)\n"
"{\n"
"int xmap_index = mad24(dv, xmap_step, xmap_offset + du);\n"
"int ymap_index = mad24(dv, ymap_step, ymap_offset + du);\n"
"float u = tl_u + du;\n"
"float v = tl_v + dv;\n"
"float x, y;\n"
"u /= scale;\n"
"float x_ = sin(u);\n"
"float y_ = v / scale;\n"
"float z_ = cos(u);\n"
"float z;\n"
"x = ck_rinv[0] * x_ + ck_rinv[1] * y_ + ck_rinv[2] * z_;\n"
"y = ck_rinv[3] * x_ + ck_rinv[4] * y_ + ck_rinv[5] * z_;\n"
"z = ck_rinv[6] * x_ + ck_rinv[7] * y_ + ck_rinv[8] * z_;\n"
"if (z > 0) { x /= z; y /= z; }\n"
"else x = y = -1;\n"
"xmap[xmap_index] = x;\n"
"ymap[ymap_index] = y;\n"
"}\n"
"}\n"
"__kernel void buildWarpSphericalMaps(__global float * xmap, __global float * ymap,\n"
"__constant float * ck_rinv,\n"
"int tl_u, int tl_v,\n"
"int cols, int rows,\n"
"int xmap_step, int ymap_step,\n"
"int xmap_offset, int ymap_offset,\n"
"float scale)\n"
"{\n"
"int du = get_global_id(0);\n"
"int dv = get_global_id(1);\n"
"if (du < cols && dv < rows)\n"
"{\n"
"int xmap_index = mad24(dv, xmap_step, xmap_offset + du);\n"
"int ymap_index = mad24(dv, ymap_step, ymap_offset + du);\n"
"float u = tl_u + du;\n"
"float v = tl_v + dv;\n"
"float x, y;\n"
"v /= scale;\n"
"u /= scale;\n"
"float sinv = sin(v);\n"
"float x_ = sinv * sin(u);\n"
"float y_ = - cos(v);\n"
"float z_ = sinv * cos(u);\n"
"float z;\n"
"x = ck_rinv[0] * x_ + ck_rinv[1] * y_ + ck_rinv[2] * z_;\n"
"y = ck_rinv[3] * x_ + ck_rinv[4] * y_ + ck_rinv[5] * z_;\n"
"z = ck_rinv[6] * x_ + ck_rinv[7] * y_ + ck_rinv[8] * z_;\n"
"if (z > 0) { x /= z; y /= z; }\n"
"else x = y = -1;\n"
"xmap[xmap_index] = x;\n"
"ymap[ymap_index] = y;\n"
"}\n"
"}\n"
"__kernel void buildWarpAffineMaps(__global float * xmap, __global float * ymap,\n"
"__constant float * c_warpMat,\n"
"int cols, int rows,\n"
"int xmap_step, int ymap_step,\n"
"int xmap_offset, int ymap_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int xmap_index = mad24(y, xmap_step, x + xmap_offset);\n"
"int ymap_index = mad24(y, ymap_step, x + ymap_offset);\n"
"float xcoo = c_warpMat[0] * x + c_warpMat[1] * y + c_warpMat[2];\n"
"float ycoo = c_warpMat[3] * x + c_warpMat[4] * y + c_warpMat[5];\n"
"xmap[xmap_index] = xcoo;\n"
"ymap[ymap_index] = ycoo;\n"
"}\n"
"}\n"
"__kernel void buildWarpPerspectiveMaps(__global float * xmap, __global float * ymap,\n"
"__constant float * c_warpMat,\n"
"int cols, int rows,\n"
"int xmap_step, int ymap_step,\n"
"int xmap_offset, int ymap_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int xmap_index = mad24(y, xmap_step, x + xmap_offset);\n"
"int ymap_index = mad24(y, ymap_step, x + ymap_offset);\n"
"float coeff = 1.0f / (c_warpMat[6] * x + c_warpMat[7] * y + c_warpMat[8]);\n"
"float xcoo = coeff * (c_warpMat[0] * x + c_warpMat[1] * y + c_warpMat[2]);\n"
"float ycoo = coeff * (c_warpMat[3] * x + c_warpMat[4] * y + c_warpMat[5]);\n"
"xmap[xmap_index] = xcoo;\n"
"ymap[ymap_index] = ycoo;\n"
"}\n"
"}\n"
, "67d1271eae72e28991ae6632b3b9bd1f"};
const struct ProgramEntry convertC3C4={"convertC3C4",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void convertC3C4(__global const GENTYPE4 * restrict src, __global GENTYPE4 *dst,\n"
"int cols, int rows,\n"
"int dstStep_in_piexl, int pixel_end)\n"
"{\n"
"int id = get_global_id(0);\n"
"int3 pixelid = (int3)(mul24(id,3),mad24(id,3,1),mad24(id,3,2));\n"
"pixelid = clamp(pixelid,0,pixel_end);\n"
"GENTYPE4 pixel0, pixel1, pixel2, outpix0,outpix1,outpix2,outpix3;\n"
"pixel0 = src[pixelid.x];\n"
"pixel1 = src[pixelid.y];\n"
"pixel2 = src[pixelid.z];\n"
"outpix0 = (GENTYPE4)(pixel0.x,pixel0.y,pixel0.z,0);\n"
"outpix1 = (GENTYPE4)(pixel0.w,pixel1.x,pixel1.y,0);\n"
"outpix2 = (GENTYPE4)(pixel1.z,pixel1.w,pixel2.x,0);\n"
"outpix3 = (GENTYPE4)(pixel2.y,pixel2.z,pixel2.w,0);\n"
"int4 outy = (id<<2)/cols;\n"
"int4 outx = (id<<2)%cols;\n"
"outx += (int4)(0, 1, 2, 3);\n"
"outy = select(outy, outy+1, outx>=cols);\n"
"outx = select(outx, outx-cols, outx>=cols);\n"
"outy = select(outy, outy + 1, outx >= cols);\n"
"outx = select(outx, outx-cols, outx >= cols);\n"
"outy = select(outy, outy + 1, outx >= cols);\n"
"outx = select(outx, outx-cols, outx >= cols);\n"
"int4 addr = mad24(outy,(int4)dstStep_in_piexl,outx);\n"
"if(outx.w<cols && outy.w<rows)\n"
"{\n"
"dst[addr.x] = outpix0;\n"
"dst[addr.y] = outpix1;\n"
"dst[addr.z] = outpix2;\n"
"dst[addr.w] = outpix3;\n"
"}\n"
"else if(outx.z<cols && outy.z<rows)\n"
"{\n"
"dst[addr.x] = outpix0;\n"
"dst[addr.y] = outpix1;\n"
"dst[addr.z] = outpix2;\n"
"}\n"
"else if(outx.y<cols && outy.y<rows)\n"
"{\n"
"dst[addr.x] = outpix0;\n"
"dst[addr.y] = outpix1;\n"
"}\n"
"else if(outx.x<cols && outy.x<rows)\n"
"dst[addr.x] = outpix0;\n"
"}\n"
"__kernel void convertC4C3(__global const GENTYPE4 * restrict src, __global GENTYPE4 *dst,\n"
"int cols, int rows,\n"
"int srcStep_in_pixel, int pixel_end)\n"
"{\n"
"int id = get_global_id(0)<<2;\n"
"int y = id / cols;\n"
"int x = id % cols;\n"
"int4 x4 = (int4)(x,x+1,x+2,x+3);\n"
"int4 y4 = select((int4)y,(int4)(y+1),x4>=(int4)cols);\n"
"x4 = select(x4,x4-(int4)cols,x4>=(int4)cols);\n"
"y4 = select(y4, y4 + 1,x4>=(int4)cols);\n"
"x4 = select(x4, x4 - (int4)cols,x4>=(int4)cols);\n"
"y4 = select(y4, y4 + 1,x4>=(int4)cols);\n"
"x4 = select(x4, x4-(int4)cols,x4>=(int4)cols);\n"
"y4=clamp(y4,(int4)0,(int4)(rows-1));\n"
"int4 addr = mad24(y4, (int4)srcStep_in_pixel, x4);\n"
"GENTYPE4 pixel0,pixel1,pixel2,pixel3, outpixel1, outpixel2;\n"
"pixel0 = src[addr.x];\n"
"pixel1 = src[addr.y];\n"
"pixel2 = src[addr.z];\n"
"pixel3 = src[addr.w];\n"
"pixel0.w = pixel1.x;\n"
"outpixel1.x = pixel1.y;\n"
"outpixel1.y = pixel1.z;\n"
"outpixel1.z = pixel2.x;\n"
"outpixel1.w = pixel2.y;\n"
"outpixel2.x = pixel2.z;\n"
"outpixel2.y = pixel3.x;\n"
"outpixel2.z = pixel3.y;\n"
"outpixel2.w = pixel3.z;\n"
"int4 outaddr = mul24(id>>2 , 3);\n"
"outaddr.y++;\n"
"outaddr.z+=2;\n"
"if(outaddr.z <= pixel_end)\n"
"{\n"
"dst[outaddr.x] = pixel0;\n"
"dst[outaddr.y] = outpixel1;\n"
"dst[outaddr.z] = outpixel2;\n"
"}\n"
"else if(outaddr.y <= pixel_end)\n"
"{\n"
"dst[outaddr.x] = pixel0;\n"
"dst[outaddr.y] = outpixel1;\n"
"}\n"
"else if(outaddr.x <= pixel_end)\n"
"dst[outaddr.x] = pixel0;\n"
"}\n"
, "bb9cf383213d95e505f8677a285ee329"};
const struct ProgramEntry cvt_color={"cvt_color",
"#ifndef hscale\n"
"#define hscale 0\n"
"#endif\n"
"#ifndef hrange\n"
"#define hrange 0\n"
"#endif\n"
"#ifdef DEPTH_0\n"
"#define DATA_TYPE uchar\n"
"#define VECTOR2 uchar2\n"
"#define VECTOR4 uchar4\n"
"#define VECTOR8 uchar8\n"
"#define VECTOR16 uchar16\n"
"#define COEFF_TYPE int\n"
"#define MAX_NUM  255\n"
"#define HALF_MAX 128\n"
"#define SAT_CAST(num) convert_uchar_sat_rte(num)\n"
"#define SAT_CAST2(num) convert_uchar2_sat(num)\n"
"#define SAT_CAST4(num) convert_uchar4_sat(num)\n"
"#endif\n"
"#ifdef DEPTH_2\n"
"#define DATA_TYPE ushort\n"
"#define VECTOR2 ushort2\n"
"#define VECTOR4 ushort4\n"
"#define VECTOR8 ushort8\n"
"#define VECTOR16 ushort16\n"
"#define COEFF_TYPE int\n"
"#define MAX_NUM  65535\n"
"#define HALF_MAX 32768\n"
"#define SAT_CAST(num) convert_ushort_sat_rte(num)\n"
"#define SAT_CAST2(num) convert_ushort2_sat(num)\n"
"#define SAT_CAST4(num) convert_ushort4_sat(num)\n"
"#endif\n"
"#ifdef DEPTH_5\n"
"#define DATA_TYPE float\n"
"#define VECTOR2 float2\n"
"#define VECTOR4 float4\n"
"#define VECTOR8 float8\n"
"#define VECTOR16 float16\n"
"#define COEFF_TYPE float\n"
"#define MAX_NUM  1.0f\n"
"#define HALF_MAX 0.5f\n"
"#define SAT_CAST(num) (num)\n"
"#endif\n"
"#ifndef bidx\n"
"#define bidx 0\n"
"#endif\n"
"#ifndef pixels_per_work_item\n"
"#define pixels_per_work_item 1\n"
"#endif\n"
"#define CV_DESCALE(x, n) (((x) + (1 << ((n)-1))) >> (n))\n"
"enum\n"
"{\n"
"yuv_shift  = 14,\n"
"xyz_shift  = 12,\n"
"hsv_shift  = 12,\n"
"R2Y        = 4899,\n"
"G2Y        = 9617,\n"
"B2Y        = 1868,\n"
"BLOCK_SIZE = 256\n"
"};\n"
"__constant float c_RGB2GrayCoeffs_f[3]  = { 0.114f, 0.587f, 0.299f };\n"
"__constant int   c_RGB2GrayCoeffs_i[3]  = { B2Y, G2Y, R2Y };\n"
"__kernel void RGB2Gray(int cols, int rows, int src_step, int dst_step,\n"
"__global const DATA_TYPE* src, __global DATA_TYPE* dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0) * pixels_per_work_item;\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"int src_idx = mad24(y, src_step, src_offset + (x << 2));\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"#ifndef INTEL_DEVICE\n"
"#ifdef DEPTH_5\n"
"dst[dst_idx] = src[src_idx + bidx] * 0.114f + src[src_idx + 1] * 0.587f + src[src_idx + (bidx^2)] * 0.299f;\n"
"#else\n"
"dst[dst_idx] = (DATA_TYPE)CV_DESCALE((src[src_idx + bidx] * B2Y + src[src_idx + 1] * G2Y + src[src_idx + (bidx^2)] * R2Y), yuv_shift);\n"
"#endif\n"
"#else\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"#ifdef DEPTH_5\n"
"__constant float * coeffs = c_RGB2GrayCoeffs_f;\n"
"#else\n"
"__constant int * coeffs = c_RGB2GrayCoeffs_i;\n"
"#endif\n"
"#if (1 == pixels_per_work_item)\n"
"{\n"
"#ifdef DEPTH_5\n"
"*dst_ptr = src_ptr[bidx] * coeffs[0] + src_ptr[1] * coeffs[1] + src_ptr[(bidx^2)] *coeffs[2];\n"
"#else\n"
"*dst_ptr = (DATA_TYPE)CV_DESCALE((src_ptr[bidx] * coeffs[0] + src_ptr[1] * coeffs[1] + src_ptr[(bidx^2)] * coeffs[2]), yuv_shift);\n"
"#endif\n"
"}\n"
"#elif (2 == pixels_per_work_item)\n"
"{\n"
"const VECTOR8 r0 = vload8(0, src_ptr);\n"
"#ifdef DEPTH_5\n"
"const float2 c0 = r0.s04;\n"
"const float2 c1 = r0.s15;\n"
"const float2 c2 = r0.s26;\n"
"const float2 Y = c0 * coeffs[bidx] + c1 * coeffs[1] + c2 * coeffs[bidx^2];\n"
"#else\n"
"const int2 c0 = convert_int2(r0.s04);\n"
"const int2 c1 = convert_int2(r0.s15);\n"
"const int2 c2 = convert_int2(r0.s26);\n"
"const int2 yi = CV_DESCALE(c0 * coeffs[bidx] + c1 * coeffs[1] + c2 * coeffs[bidx^2], yuv_shift);\n"
"const VECTOR2 Y = SAT_CAST2(yi);\n"
"#endif\n"
"vstore2(Y, 0, dst_ptr);\n"
"}\n"
"#elif (4 == pixels_per_work_item)\n"
"{\n"
"#ifndef DEPTH_5\n"
"const VECTOR16 r0 = vload16(0, src_ptr);\n"
"const int4 c0 = convert_int4(r0.s048c);\n"
"const int4 c1 = convert_int4(r0.s159d);\n"
"const int4 c2 = convert_int4(r0.s26ae);\n"
"const int4 Y = CV_DESCALE(c0 * coeffs[bidx] + c1 * coeffs[1] + c2 * coeffs[bidx^2], yuv_shift);\n"
"vstore4(SAT_CAST4(Y), 0, dst_ptr);\n"
"#endif\n"
"}\n"
"#endif\n"
"#endif\n"
"}\n"
"}\n"
"__kernel void Gray2RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const DATA_TYPE* src, __global DATA_TYPE* dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + (x << 2));\n"
"DATA_TYPE val = src[src_idx];\n"
"dst[dst_idx] = val;\n"
"dst[dst_idx + 1] = val;\n"
"dst[dst_idx + 2] = val;\n"
"#if dcn == 4\n"
"dst[dst_idx + 3] = MAX_NUM;\n"
"#endif\n"
"}\n"
"}\n"
"__constant float c_RGB2YUVCoeffs_f[5]  = { 0.114f, 0.587f, 0.299f, 0.492f, 0.877f };\n"
"__constant int   c_RGB2YUVCoeffs_i[5]  = { B2Y, G2Y, R2Y, 8061, 14369 };\n"
"__kernel void RGB2YUV(int cols, int rows, int src_step, int dst_step,\n"
"__global const DATA_TYPE* src, __global DATA_TYPE* dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0) * pixels_per_work_item;\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"#ifdef DEPTH_5\n"
"__constant float * coeffs = c_RGB2YUVCoeffs_f;\n"
"#else\n"
"__constant int * coeffs = c_RGB2YUVCoeffs_i;\n"
"const int delta = HALF_MAX * (1 << yuv_shift);\n"
"#endif\n"
"#if (1 == pixels_per_work_item)\n"
"{\n"
"const DATA_TYPE rgb[] = {src_ptr[0], src_ptr[1], src_ptr[2]};\n"
"#ifdef DEPTH_5\n"
"float Y = rgb[0] * coeffs[bidx^2] + rgb[1] * coeffs[1] + rgb[2] * coeffs[bidx];\n"
"float U = (rgb[bidx^2] - Y) * coeffs[3] + HALF_MAX;\n"
"float V = (rgb[bidx] - Y) * coeffs[4] + HALF_MAX;\n"
"#else\n"
"int Y = CV_DESCALE(rgb[0] * coeffs[bidx^2] + rgb[1] * coeffs[1] + rgb[2] * coeffs[bidx], yuv_shift);\n"
"int U = CV_DESCALE((rgb[bidx^2] - Y) * coeffs[3] + delta, yuv_shift);\n"
"int V = CV_DESCALE((rgb[bidx] - Y) * coeffs[4] + delta, yuv_shift);\n"
"#endif\n"
"dst_ptr[0] = SAT_CAST( Y );\n"
"dst_ptr[1] = SAT_CAST( U );\n"
"dst_ptr[2] = SAT_CAST( V );\n"
"}\n"
"#elif (2 == pixels_per_work_item)\n"
"{\n"
"const VECTOR8 r0 = vload8(0, src_ptr);\n"
"#ifdef DEPTH_5\n"
"const float2 c0 = r0.s04;\n"
"const float2 c1 = r0.s15;\n"
"const float2 c2 = r0.s26;\n"
"const float2 Y = (bidx == 0) ? (c0 * coeffs[2] + c1 * coeffs[1] + c2 * coeffs[0]) : (c0 * coeffs[0] + c1 * coeffs[1] + c2 * coeffs[2]);\n"
"const float2 U = (bidx == 0) ? ((c2 - Y) * coeffs[3] + HALF_MAX) : ((c0 - Y) * coeffs[3] + HALF_MAX);\n"
"const float2 V = (bidx == 0) ? ((c0 - Y) * coeffs[4] + HALF_MAX) : ((c2 - Y) * coeffs[4] + HALF_MAX);\n"
"#else\n"
"const int2 c0 = convert_int2(r0.s04);\n"
"const int2 c1 = convert_int2(r0.s15);\n"
"const int2 c2 = convert_int2(r0.s26);\n"
"const int2 yi = (bidx == 0) ? CV_DESCALE(c0 * coeffs[2] + c1 * coeffs[1] + c2 * coeffs[0], yuv_shift) : CV_DESCALE(c0 * coeffs[0] + c1 * coeffs[1] + c2 * coeffs[2], yuv_shift);\n"
"const int2 ui = (bidx == 0) ? CV_DESCALE((c2 - yi) * coeffs[3] + delta, yuv_shift) : CV_DESCALE((c0 - yi) * coeffs[3] + delta, yuv_shift);\n"
"const int2 vi = (bidx == 0) ? CV_DESCALE((c0 - yi) * coeffs[4] + delta, yuv_shift) : CV_DESCALE((c2 - yi) * coeffs[4] + delta, yuv_shift);\n"
"const VECTOR2 Y = SAT_CAST2(yi);\n"
"const VECTOR2 U = SAT_CAST2(ui);\n"
"const VECTOR2 V = SAT_CAST2(vi);\n"
"#endif\n"
"vstore8((VECTOR8)(Y.s0, U.s0, V.s0, 0, Y.s1, U.s1, V.s1, 0), 0, dst_ptr);\n"
"}\n"
"#elif (4 == pixels_per_work_item)\n"
"{\n"
"#ifndef DEPTH_5\n"
"const VECTOR16 r0 = vload16(0, src_ptr);\n"
"const int4 c0 = convert_int4(r0.s048c);\n"
"const int4 c1 = convert_int4(r0.s159d);\n"
"const int4 c2 = convert_int4(r0.s26ae);\n"
"const int4 yi = (bidx == 0) ? CV_DESCALE(c0 * coeffs[2] + c1 * coeffs[1] + c2 * coeffs[0], yuv_shift) : CV_DESCALE(c0 * coeffs[0] + c1 * coeffs[1] + c2 * coeffs[2], yuv_shift);\n"
"const int4 ui = (bidx == 0) ? CV_DESCALE((c2 - yi) * coeffs[3] + delta, yuv_shift) : CV_DESCALE((c0 - yi) * coeffs[3] + delta, yuv_shift);\n"
"const int4 vi = (bidx == 0) ? CV_DESCALE((c0 - yi) * coeffs[4] + delta, yuv_shift) : CV_DESCALE((c2 - yi) * coeffs[4] + delta, yuv_shift);\n"
"const VECTOR4 Y = SAT_CAST4(yi);\n"
"const VECTOR4 U = SAT_CAST4(ui);\n"
"const VECTOR4 V = SAT_CAST4(vi);\n"
"vstore16((VECTOR16)(Y.s0, U.s0, V.s0, 0, Y.s1, U.s1, V.s1, 0, Y.s2, U.s2, V.s2, 0, Y.s3, U.s3, V.s3, 0), 0, dst_ptr);\n"
"#endif\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"__constant float c_YUV2RGBCoeffs_f[5] = { 2.032f, -0.395f, -0.581f, 1.140f };\n"
"__constant int   c_YUV2RGBCoeffs_i[5] = { 33292, -6472, -9519, 18678 };\n"
"__kernel void YUV2RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const DATA_TYPE* src, __global DATA_TYPE* dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0) * pixels_per_work_item;\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"#ifdef DEPTH_5\n"
"__constant float * coeffs = c_YUV2RGBCoeffs_f;\n"
"#else\n"
"__constant int * coeffs = c_YUV2RGBCoeffs_i;\n"
"#endif\n"
"#if (1 == pixels_per_work_item)\n"
"{\n"
"const DATA_TYPE yuv[] = {src_ptr[0], src_ptr[1], src_ptr[2]};\n"
"#ifdef DEPTH_5\n"
"float B = yuv[0] + (yuv[2] - HALF_MAX) * coeffs[3];\n"
"float G = yuv[0] + (yuv[2] - HALF_MAX) * coeffs[2] + (yuv[1] - HALF_MAX) * coeffs[1];\n"
"float R = yuv[0] + (yuv[1] - HALF_MAX) * coeffs[0];\n"
"#else\n"
"int B = yuv[0] + CV_DESCALE((yuv[2] - HALF_MAX) * coeffs[3], yuv_shift);\n"
"int G = yuv[0] + CV_DESCALE((yuv[2] - HALF_MAX) * coeffs[2] + (yuv[1] - HALF_MAX) * coeffs[1], yuv_shift);\n"
"int R = yuv[0] + CV_DESCALE((yuv[1] - HALF_MAX) * coeffs[0], yuv_shift);\n"
"#endif\n"
"dst_ptr[bidx]     = SAT_CAST( B );\n"
"dst_ptr[1]        = SAT_CAST( G );\n"
"dst_ptr[(bidx^2)] = SAT_CAST( R );\n"
"#if dcn == 4\n"
"dst_ptr[3]         = MAX_NUM;\n"
"#endif\n"
"}\n"
"#elif (2 == pixels_per_work_item)\n"
"{\n"
"const VECTOR8 r0 = vload8(0, src_ptr);\n"
"#ifdef DEPTH_5\n"
"const float2 Y = r0.s04;\n"
"const float2 U = r0.s15;\n"
"const float2 V = r0.s26;\n"
"const float2 c0 = (bidx == 0) ? (Y + (V - HALF_MAX) * coeffs[3]) : (Y + (U - HALF_MAX) * coeffs[0]);\n"
"const float2 c1 = Y + (V - HALF_MAX) * coeffs[2] + (U - HALF_MAX) * coeffs[1];\n"
"const float2 c2 = (bidx == 0) ? (Y + (U - HALF_MAX) * coeffs[0]) : (Y + (V - HALF_MAX) * coeffs[3]);\n"
"#else\n"
"const int2 Y = convert_int2(r0.s04);\n"
"const int2 U = convert_int2(r0.s15);\n"
"const int2 V = convert_int2(r0.s26);\n"
"const int2 c0i = (bidx == 0) ? (Y + CV_DESCALE((V - HALF_MAX) * coeffs[3], yuv_shift)) : (Y + CV_DESCALE((U - HALF_MAX) * coeffs[0], yuv_shift));\n"
"const int2 c1i = Y + CV_DESCALE((V - HALF_MAX) * coeffs[2] + (U - HALF_MAX) * coeffs[1], yuv_shift);\n"
"const int2 c2i = (bidx == 0) ? (Y + CV_DESCALE((U - HALF_MAX) * coeffs[0], yuv_shift)) : (Y + CV_DESCALE((V - HALF_MAX) * coeffs[3], yuv_shift));\n"
"const VECTOR2 c0 = SAT_CAST2(c0i);\n"
"const VECTOR2 c1 = SAT_CAST2(c1i);\n"
"const VECTOR2 c2 = SAT_CAST2(c2i);\n"
"#endif\n"
"#if dcn == 4\n"
"vstore8((VECTOR8)(c0.s0, c1.s0, c2.s0, MAX_NUM, c0.s1, c1.s1, c2.s1, MAX_NUM), 0, dst_ptr);\n"
"#else\n"
"vstore8((VECTOR8)(c0.s0, c1.s0, c2.s0, 0, c0.s1, c1.s1, c2.s1, 0), 0, dst_ptr);\n"
"#endif\n"
"}\n"
"#elif (4 == pixels_per_work_item)\n"
"{\n"
"#ifndef DEPTH_5\n"
"const VECTOR16 r0 = vload16(0, src_ptr);\n"
"const int4 Y = convert_int4(r0.s048c);\n"
"const int4 U = convert_int4(r0.s159d);\n"
"const int4 V = convert_int4(r0.s26ae);\n"
"const int4 c0i = (bidx == 0) ? (Y + CV_DESCALE((V - HALF_MAX) * coeffs[3], yuv_shift)) : (Y + CV_DESCALE((U - HALF_MAX) * coeffs[0], yuv_shift));\n"
"const int4 c1i = Y + CV_DESCALE((V - HALF_MAX) * coeffs[2] + (U - HALF_MAX) * coeffs[1], yuv_shift);\n"
"const int4 c2i = (bidx == 0) ? (Y + CV_DESCALE((U - HALF_MAX) * coeffs[0], yuv_shift)) : (Y + CV_DESCALE((V - HALF_MAX) * coeffs[3], yuv_shift));\n"
"const VECTOR4 c0 = SAT_CAST4(c0i);\n"
"const VECTOR4 c1 = SAT_CAST4(c1i);\n"
"const VECTOR4 c2 = SAT_CAST4(c2i);\n"
"#if dcn == 4\n"
"vstore16((VECTOR16)(c0.s0, c1.s0, c2.s0, MAX_NUM, c0.s1, c1.s1, c2.s1, MAX_NUM, c0.s2, c1.s2, c2.s2, MAX_NUM, c0.s3, c1.s3, c2.s3, MAX_NUM), 0, dst_ptr);\n"
"#else\n"
"vstore16((VECTOR16)(c0.s0, c1.s0, c2.s0, 0, c0.s1, c1.s1, c2.s1, 0, c0.s2, c1.s2, c2.s2, 0, c0.s3, c1.s3, c2.s3, 0), 0, dst_ptr);\n"
"#endif\n"
"#endif\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"__constant int ITUR_BT_601_CY = 1220542;\n"
"__constant int ITUR_BT_601_CUB = 2116026;\n"
"__constant int ITUR_BT_601_CUG = 409993;\n"
"__constant int ITUR_BT_601_CVG = 852492;\n"
"__constant int ITUR_BT_601_CVR = 1673527;\n"
"__constant int ITUR_BT_601_SHIFT = 20;\n"
"__kernel void YUV2RGBA_NV12(int cols, int rows, int src_step, int dst_step,\n"
"__global const uchar* src, __global uchar* dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_global_id(1);\n"
"if (y < rows / 2 && x < cols / 2 )\n"
"{\n"
"__global const uchar* ysrc = src + mad24(y << 1, src_step, (x << 1) + src_offset);\n"
"__global const uchar* usrc = src + mad24(rows + y, src_step, (x << 1) + src_offset);\n"
"__global uchar*       dst1 = dst + mad24(y << 1, dst_step, (x << 3) + dst_offset);\n"
"__global uchar*       dst2 = dst + mad24((y << 1) + 1, dst_step, (x << 3) + dst_offset);\n"
"int Y1 = ysrc[0];\n"
"int Y2 = ysrc[1];\n"
"int Y3 = ysrc[src_step];\n"
"int Y4 = ysrc[src_step + 1];\n"
"int U  = usrc[0] - 128;\n"
"int V  = usrc[1] - 128;\n"
"int ruv = (1 << (ITUR_BT_601_SHIFT - 1)) + ITUR_BT_601_CVR * V;\n"
"int guv = (1 << (ITUR_BT_601_SHIFT - 1)) - ITUR_BT_601_CVG * V - ITUR_BT_601_CUG * U;\n"
"int buv = (1 << (ITUR_BT_601_SHIFT - 1)) + ITUR_BT_601_CUB * U;\n"
"Y1 = max(0, Y1 - 16) * ITUR_BT_601_CY;\n"
"dst1[2 - bidx]     = convert_uchar_sat((Y1 + ruv) >> ITUR_BT_601_SHIFT);\n"
"dst1[1]        = convert_uchar_sat((Y1 + guv) >> ITUR_BT_601_SHIFT);\n"
"dst1[bidx] = convert_uchar_sat((Y1 + buv) >> ITUR_BT_601_SHIFT);\n"
"dst1[3]        = 255;\n"
"Y2 = max(0, Y2 - 16) * ITUR_BT_601_CY;\n"
"dst1[6 - bidx] = convert_uchar_sat((Y2 + ruv) >> ITUR_BT_601_SHIFT);\n"
"dst1[5]        = convert_uchar_sat((Y2 + guv) >> ITUR_BT_601_SHIFT);\n"
"dst1[4 + bidx] = convert_uchar_sat((Y2 + buv) >> ITUR_BT_601_SHIFT);\n"
"dst1[7]        = 255;\n"
"Y3 = max(0, Y3 - 16) * ITUR_BT_601_CY;\n"
"dst2[2 - bidx]     = convert_uchar_sat((Y3 + ruv) >> ITUR_BT_601_SHIFT);\n"
"dst2[1]        = convert_uchar_sat((Y3 + guv) >> ITUR_BT_601_SHIFT);\n"
"dst2[bidx] = convert_uchar_sat((Y3 + buv) >> ITUR_BT_601_SHIFT);\n"
"dst2[3]        = 255;\n"
"Y4 = max(0, Y4 - 16) * ITUR_BT_601_CY;\n"
"dst2[6 - bidx] = convert_uchar_sat((Y4 + ruv) >> ITUR_BT_601_SHIFT);\n"
"dst2[5]        = convert_uchar_sat((Y4 + guv) >> ITUR_BT_601_SHIFT);\n"
"dst2[4 + bidx] = convert_uchar_sat((Y4 + buv) >> ITUR_BT_601_SHIFT);\n"
"dst2[7]        = 255;\n"
"}\n"
"}\n"
"__constant float c_RGB2YCrCbCoeffs_f[5] = {0.299f, 0.587f, 0.114f, 0.713f, 0.564f};\n"
"__constant int   c_RGB2YCrCbCoeffs_i[5] = {R2Y, G2Y, B2Y, 11682, 9241};\n"
"__kernel void RGB2YCrCb(int cols, int rows, int src_step, int dst_step,\n"
"__global const DATA_TYPE* src, __global DATA_TYPE* dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0) * pixels_per_work_item;\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"#ifdef DEPTH_5\n"
"__constant float * coeffs = c_RGB2YCrCbCoeffs_f;\n"
"#else\n"
"__constant int * coeffs = c_RGB2YCrCbCoeffs_i;\n"
"const int delta = HALF_MAX * (1 << yuv_shift);\n"
"#endif\n"
"#if (1 == pixels_per_work_item)\n"
"{\n"
"const DATA_TYPE rgb[] = {src_ptr[0], src_ptr[1], src_ptr[2]};\n"
"#ifdef DEPTH_5\n"
"float Y  = rgb[0] * coeffs[bidx^2] + rgb[1] * coeffs[1] + rgb[2] * coeffs[bidx];\n"
"float Cr = (rgb[bidx^2] - Y) * coeffs[3] + HALF_MAX;\n"
"float Cb = (rgb[bidx] - Y) * coeffs[4] + HALF_MAX;\n"
"#else\n"
"int Y =  CV_DESCALE(rgb[0] * coeffs[bidx^2] + rgb[1] * coeffs[1] + rgb[2] * coeffs[bidx], yuv_shift);\n"
"int Cr = CV_DESCALE((rgb[bidx^2] - Y) * coeffs[3] + delta, yuv_shift);\n"
"int Cb = CV_DESCALE((rgb[bidx] - Y) * coeffs[4] + delta, yuv_shift);\n"
"#endif\n"
"dst_ptr[0] = SAT_CAST( Y );\n"
"dst_ptr[1] = SAT_CAST( Cr );\n"
"dst_ptr[2] = SAT_CAST( Cb );\n"
"}\n"
"#elif (2 == pixels_per_work_item)\n"
"{\n"
"const VECTOR8 r0 = vload8(0, src_ptr);\n"
"#ifdef DEPTH_5\n"
"const float2 c0 = r0.s04;\n"
"const float2 c1 = r0.s15;\n"
"const float2 c2 = r0.s26;\n"
"const float2 Y  = (bidx == 0) ? (c0 * coeffs[2] + c1 * coeffs[1] + c2 * coeffs[0]) : (c0 * coeffs[0] + c1 * coeffs[1] + c2 * coeffs[2]);\n"
"const float2 Cr = (bidx == 0) ? ((c2 - Y) * coeffs[3] + HALF_MAX) : ((c0 - Y) * coeffs[3] + HALF_MAX);\n"
"const float2 Cb = (bidx == 0) ? ((c0 - Y) * coeffs[4] + HALF_MAX) : ((c2 - Y) * coeffs[4] + HALF_MAX);\n"
"#else\n"
"const int2 c0 = convert_int2(r0.s04);\n"
"const int2 c1 = convert_int2(r0.s15);\n"
"const int2 c2 = convert_int2(r0.s26);\n"
"const int2 yi = (bidx == 0) ? CV_DESCALE(c0 * coeffs[2] + c1 * coeffs[1] + c2 * coeffs[0], yuv_shift) : CV_DESCALE(c0 * coeffs[0] + c1 * coeffs[1] + c2 * coeffs[2], yuv_shift);\n"
"const int2 ui = (bidx == 0) ? CV_DESCALE((c2 - yi) * coeffs[3] + delta, yuv_shift) : CV_DESCALE((c0 - yi) * coeffs[3] + delta, yuv_shift);\n"
"const int2 vi = (bidx == 0) ? CV_DESCALE((c0 - yi) * coeffs[4] + delta, yuv_shift) : CV_DESCALE((c2 - yi) * coeffs[4] + delta, yuv_shift);\n"
"const VECTOR2 Y  = SAT_CAST2(yi);\n"
"const VECTOR2 Cr = SAT_CAST2(ui);\n"
"const VECTOR2 Cb = SAT_CAST2(vi);\n"
"#endif\n"
"vstore8((VECTOR8)(Y.s0, Cr.s0, Cb.s0, 0, Y.s1, Cr.s1, Cb.s1, 0), 0, dst_ptr);\n"
"}\n"
"#elif (4 == pixels_per_work_item)\n"
"{\n"
"#ifndef DEPTH_5\n"
"const VECTOR16 r0 = vload16(0, src_ptr);\n"
"const int4 c0 = convert_int4(r0.s048c);\n"
"const int4 c1 = convert_int4(r0.s159d);\n"
"const int4 c2 = convert_int4(r0.s26ae);\n"
"const int4 yi = (bidx == 0) ? CV_DESCALE(c0 * coeffs[2] + c1 * coeffs[1] + c2 * coeffs[0], yuv_shift) : CV_DESCALE(c0 * coeffs[0] + c1 * coeffs[1] + c2 * coeffs[2], yuv_shift);\n"
"const int4 ui = (bidx == 0) ? CV_DESCALE((c2 - yi) * coeffs[3] + delta, yuv_shift) : CV_DESCALE((c0 - yi) * coeffs[3] + delta, yuv_shift);\n"
"const int4 vi = (bidx == 0) ? CV_DESCALE((c0 - yi) * coeffs[4] + delta, yuv_shift) : CV_DESCALE((c2 - yi) * coeffs[4] + delta, yuv_shift);\n"
"const VECTOR4 Y  = SAT_CAST4(yi);\n"
"const VECTOR4 Cr = SAT_CAST4(ui);\n"
"const VECTOR4 Cb = SAT_CAST4(vi);\n"
"vstore16((VECTOR16)(Y.s0, Cr.s0, Cb.s0, 0, Y.s1, Cr.s1, Cb.s1, 0, Y.s2, Cr.s2, Cb.s2, 0, Y.s3, Cr.s3, Cb.s3, 0), 0, dst_ptr);\n"
"#endif\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"__constant float c_YCrCb2RGBCoeffs_f[4] = { 1.403f, -0.714f, -0.344f, 1.773f };\n"
"__constant int   c_YCrCb2RGBCoeffs_i[4] = { 22987, -11698, -5636, 29049 };\n"
"__kernel void YCrCb2RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const DATA_TYPE* src, __global DATA_TYPE* dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0) * pixels_per_work_item;\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"#ifdef DEPTH_5\n"
"__constant float * coeffs = c_YCrCb2RGBCoeffs_f;\n"
"#else\n"
"__constant int * coeffs = c_YCrCb2RGBCoeffs_i;\n"
"#endif\n"
"#if (1 == pixels_per_work_item)\n"
"{\n"
"const DATA_TYPE ycrcb[] = {src_ptr[0], src_ptr[1], src_ptr[2]};\n"
"#ifdef DEPTH_5\n"
"float B = ycrcb[0] + (ycrcb[2] - HALF_MAX) * coeffs[3];\n"
"float G = ycrcb[0] + (ycrcb[2] - HALF_MAX) * coeffs[2] + (ycrcb[1] - HALF_MAX) * coeffs[1];\n"
"float R = ycrcb[0] + (ycrcb[1] - HALF_MAX) * coeffs[0];\n"
"#else\n"
"int B = ycrcb[0] + CV_DESCALE((ycrcb[2] - HALF_MAX) * coeffs[3], yuv_shift);\n"
"int G = ycrcb[0] + CV_DESCALE((ycrcb[2] - HALF_MAX) * coeffs[2] + (ycrcb[1] - HALF_MAX) * coeffs[1], yuv_shift);\n"
"int R = ycrcb[0] + CV_DESCALE((ycrcb[1] - HALF_MAX) * coeffs[0], yuv_shift);\n"
"#endif\n"
"dst_ptr[bidx]     = SAT_CAST( B );\n"
"dst_ptr[1]        = SAT_CAST( G );\n"
"dst_ptr[(bidx^2)] = SAT_CAST( R );\n"
"#if dcn == 4\n"
"dst_ptr[3]         = MAX_NUM;\n"
"#endif\n"
"}\n"
"#elif (2 == pixels_per_work_item)\n"
"{\n"
"const VECTOR8 r0 = vload8(0, src_ptr);\n"
"#ifdef DEPTH_5\n"
"const float2 Y  = r0.s04;\n"
"const float2 Cr = r0.s15;\n"
"const float2 Cb = r0.s26;\n"
"const float2 c0 = (bidx == 0) ? (Y + (Cb - HALF_MAX) * coeffs[3]) : (Y + (Cr - HALF_MAX) * coeffs[0]);\n"
"const float2 c1 = Y + (Cb - HALF_MAX) * coeffs[2] + (Cr - HALF_MAX) * coeffs[1];\n"
"const float2 c2 = (bidx == 0) ? (Y + (Cr - HALF_MAX) * coeffs[0]) : (Y + (Cb - HALF_MAX) * coeffs[3]);\n"
"#else\n"
"const int2 Y  = convert_int2(r0.s04);\n"
"const int2 Cr = convert_int2(r0.s15);\n"
"const int2 Cb = convert_int2(r0.s26);\n"
"const int2 c0i = (bidx == 0) ? (Y + CV_DESCALE((Cb - HALF_MAX) * coeffs[3], yuv_shift)) : (Y + CV_DESCALE((Cr - HALF_MAX) * coeffs[0], yuv_shift));\n"
"const int2 c1i = Y + CV_DESCALE((Cb - HALF_MAX) * coeffs[2] + (Cr - HALF_MAX) * coeffs[1], yuv_shift);\n"
"const int2 c2i = (bidx == 0) ? (Y + CV_DESCALE((Cr - HALF_MAX) * coeffs[0], yuv_shift)) : (Y + CV_DESCALE((Cb - HALF_MAX) * coeffs[3], yuv_shift));\n"
"const VECTOR2 c0 = SAT_CAST2(c0i);\n"
"const VECTOR2 c1 = SAT_CAST2(c1i);\n"
"const VECTOR2 c2 = SAT_CAST2(c2i);\n"
"#endif\n"
"#if dcn == 4\n"
"vstore8((VECTOR8)(c0.s0, c1.s0, c2.s0, MAX_NUM, c0.s1, c1.s1, c2.s1, MAX_NUM), 0, dst_ptr);\n"
"#else\n"
"vstore8((VECTOR8)(c0.s0, c1.s0, c2.s0, 0, c0.s1, c1.s1, c2.s1, 0), 0, dst_ptr);\n"
"#endif\n"
"}\n"
"#elif (4 == pixels_per_work_item)\n"
"{\n"
"#ifndef DEPTH_5\n"
"const VECTOR16 r0 = vload16(0, src_ptr);\n"
"const int4 Y  = convert_int4(r0.s048c);\n"
"const int4 Cr = convert_int4(r0.s159d);\n"
"const int4 Cb = convert_int4(r0.s26ae);\n"
"const int4 c0i = (bidx == 0) ? (Y + CV_DESCALE((Cb - HALF_MAX) * coeffs[3], yuv_shift)) : (Y + CV_DESCALE((Cr - HALF_MAX) * coeffs[0], yuv_shift));\n"
"const int4 c1i = Y + CV_DESCALE((Cb - HALF_MAX) * coeffs[2] + (Cr - HALF_MAX) * coeffs[1], yuv_shift);\n"
"const int4 c2i = (bidx == 0) ? (Y + CV_DESCALE((Cr - HALF_MAX) * coeffs[0], yuv_shift)) : (Y + CV_DESCALE((Cb - HALF_MAX) * coeffs[3], yuv_shift));\n"
"const VECTOR4 c0 = SAT_CAST4(c0i);\n"
"const VECTOR4 c1 = SAT_CAST4(c1i);\n"
"const VECTOR4 c2 = SAT_CAST4(c2i);\n"
"#if dcn == 4\n"
"vstore16((VECTOR16)(c0.s0, c1.s0, c2.s0, MAX_NUM, c0.s1, c1.s1, c2.s1, MAX_NUM, c0.s2, c1.s2, c2.s2, MAX_NUM, c0.s3, c1.s3, c2.s3, MAX_NUM), 0, dst_ptr);\n"
"#else\n"
"vstore16((VECTOR16)(c0.s0, c1.s0, c2.s0, 0, c0.s1, c1.s1, c2.s1, 0, c0.s2, c1.s2, c2.s2, 0, c0.s3, c1.s3, c2.s3, 0), 0, dst_ptr);\n"
"#endif\n"
"#endif\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"__kernel void RGB2XYZ(int cols, int rows, int src_step, int dst_step,\n"
"__global const DATA_TYPE* src, __global DATA_TYPE* dst,\n"
"int src_offset, int dst_offset, __constant COEFF_TYPE * coeffs)\n"
"{\n"
"int dx = get_global_id(0) * pixels_per_work_item;\n"
"int dy = get_global_id(1);\n"
"if (dy < rows && dx < cols)\n"
"{\n"
"dx <<= 2;\n"
"int src_idx = mad24(dy, src_step, src_offset + dx);\n"
"int dst_idx = mad24(dy, dst_step, dst_offset + dx);\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"#if (1 == pixels_per_work_item)\n"
"{\n"
"DATA_TYPE R = src_ptr[0], G = src_ptr[1], B = src_ptr[2];\n"
"#ifdef DEPTH_5\n"
"float X = R * coeffs[0] + G * coeffs[1] + B * coeffs[2];\n"
"float Y = R * coeffs[3] + G * coeffs[4] + B * coeffs[5];\n"
"float Z = R * coeffs[6] + G * coeffs[7] + B * coeffs[8];\n"
"#else\n"
"int X = CV_DESCALE(R * coeffs[0] + G * coeffs[1] + B * coeffs[2], xyz_shift);\n"
"int Y = CV_DESCALE(R * coeffs[3] + G * coeffs[4] + B * coeffs[5], xyz_shift);\n"
"int Z = CV_DESCALE(R * coeffs[6] + G * coeffs[7] + B * coeffs[8], xyz_shift);\n"
"#endif\n"
"dst_ptr[0] = SAT_CAST( X );\n"
"dst_ptr[1] = SAT_CAST( Y );\n"
"dst_ptr[2] = SAT_CAST( Z );\n"
"}\n"
"#elif (2 == pixels_per_work_item)\n"
"{\n"
"const VECTOR8 r0 = vload8(0, src_ptr);\n"
"#ifdef DEPTH_5\n"
"const float2 R = r0.s04;\n"
"const float2 G = r0.s15;\n"
"const float2 B = r0.s26;\n"
"const float2 X = R * coeffs[0] + G * coeffs[1] + B * coeffs[2];\n"
"const float2 Y = R * coeffs[3] + G * coeffs[4] + B * coeffs[5];\n"
"const float2 Z = R * coeffs[6] + G * coeffs[7] + B * coeffs[8];\n"
"#else\n"
"const int2 R = convert_int2(r0.s04);\n"
"const int2 G = convert_int2(r0.s15);\n"
"const int2 B = convert_int2(r0.s26);\n"
"const int2 xi = CV_DESCALE(R * coeffs[0] + G * coeffs[1] + B * coeffs[2], xyz_shift);\n"
"const int2 yi = CV_DESCALE(R * coeffs[3] + G * coeffs[4] + B * coeffs[5], xyz_shift);\n"
"const int2 zi = CV_DESCALE(R * coeffs[6] + G * coeffs[7] + B * coeffs[8], xyz_shift);\n"
"const VECTOR2 X = SAT_CAST2(xi);\n"
"const VECTOR2 Y = SAT_CAST2(yi);\n"
"const VECTOR2 Z = SAT_CAST2(zi);\n"
"#endif\n"
"vstore8((VECTOR8)(X.s0, Y.s0, Z.s0, 0, X.s1, Y.s1, Z.s1, 0), 0, dst_ptr);\n"
"}\n"
"#elif (4 == pixels_per_work_item)\n"
"{\n"
"#ifndef DEPTH_5\n"
"const VECTOR16 r0 = vload16(0, src_ptr);\n"
"const int4 R = convert_int4(r0.s048c);\n"
"const int4 G = convert_int4(r0.s159d);\n"
"const int4 B = convert_int4(r0.s26ae);\n"
"const int4 xi = CV_DESCALE(R * coeffs[0] + G * coeffs[1] + B * coeffs[2], xyz_shift);\n"
"const int4 yi = CV_DESCALE(R * coeffs[3] + G * coeffs[4] + B * coeffs[5], xyz_shift);\n"
"const int4 zi = CV_DESCALE(R * coeffs[6] + G * coeffs[7] + B * coeffs[8], xyz_shift);\n"
"const VECTOR4 X = SAT_CAST4(xi);\n"
"const VECTOR4 Y = SAT_CAST4(yi);\n"
"const VECTOR4 Z = SAT_CAST4(zi);\n"
"vstore16((VECTOR16)(X.s0, Y.s0, Z.s0, 0, X.s1, Y.s1, Z.s1, 0, X.s2, Y.s2, Z.s2, 0, X.s3, Y.s3, Z.s3, 0), 0, dst_ptr);\n"
"#endif\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"__kernel void XYZ2RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const DATA_TYPE* src, __global DATA_TYPE* dst,\n"
"int src_offset, int dst_offset, __constant COEFF_TYPE * coeffs)\n"
"{\n"
"int dx = get_global_id(0) * pixels_per_work_item;\n"
"int dy = get_global_id(1);\n"
"if (dy < rows && dx < cols)\n"
"{\n"
"dx <<= 2;\n"
"int src_idx = mad24(dy, src_step, src_offset + dx);\n"
"int dst_idx = mad24(dy, dst_step, dst_offset + dx);\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"#if (1 == pixels_per_work_item)\n"
"{\n"
"const DATA_TYPE X = src_ptr[0], Y = src_ptr[1], Z = src_ptr[2];\n"
"#ifdef DEPTH_5\n"
"float B = X * coeffs[0] + Y * coeffs[1] + Z * coeffs[2];\n"
"float G = X * coeffs[3] + Y * coeffs[4] + Z * coeffs[5];\n"
"float R = X * coeffs[6] + Y * coeffs[7] + Z * coeffs[8];\n"
"#else\n"
"int B = CV_DESCALE(X * coeffs[0] + Y * coeffs[1] + Z * coeffs[2], xyz_shift);\n"
"int G = CV_DESCALE(X * coeffs[3] + Y * coeffs[4] + Z * coeffs[5], xyz_shift);\n"
"int R = CV_DESCALE(X * coeffs[6] + Y * coeffs[7] + Z * coeffs[8], xyz_shift);\n"
"#endif\n"
"dst_ptr[0] = SAT_CAST( B );\n"
"dst_ptr[1] = SAT_CAST( G );\n"
"dst_ptr[2] = SAT_CAST( R );\n"
"#if dcn == 4\n"
"dst_ptr[3] = MAX_NUM;\n"
"#endif\n"
"}\n"
"#elif (2 == pixels_per_work_item)\n"
"{\n"
"const VECTOR8 r0 = vload8(0, src_ptr);\n"
"#ifdef DEPTH_5\n"
"const float2 X = r0.s04;\n"
"const float2 Y = r0.s15;\n"
"const float2 Z = r0.s26;\n"
"float2 B = X * coeffs[0] + Y * coeffs[1] + Z * coeffs[2];\n"
"float2 G = X * coeffs[3] + Y * coeffs[4] + Z * coeffs[5];\n"
"float2 R = X * coeffs[6] + Y * coeffs[7] + Z * coeffs[8];\n"
"#else\n"
"const int2 xi = convert_int2(r0.s04);\n"
"const int2 yi = convert_int2(r0.s15);\n"
"const int2 zi = convert_int2(r0.s26);\n"
"const int2 bi = CV_DESCALE(xi * coeffs[0] + yi * coeffs[1] + zi * coeffs[2], xyz_shift);\n"
"const int2 gi = CV_DESCALE(xi * coeffs[3] + yi * coeffs[4] + zi * coeffs[5], xyz_shift);\n"
"const int2 ri = CV_DESCALE(xi * coeffs[6] + yi * coeffs[7] + zi * coeffs[8], xyz_shift);\n"
"const VECTOR2 R = SAT_CAST2(ri);\n"
"const VECTOR2 G = SAT_CAST2(gi);\n"
"const VECTOR2 B = SAT_CAST2(bi);\n"
"#endif\n"
"#if dcn == 4\n"
"vstore8((VECTOR8)(B.s0, G.s0, R.s0, MAX_NUM, B.s1, G.s1, R.s1, MAX_NUM), 0, dst_ptr);\n"
"#else\n"
"vstore8((VECTOR8)(B.s0, G.s0, R.s0, 0, B.s1, G.s1, R.s1, 0), 0, dst_ptr);\n"
"#endif\n"
"}\n"
"#elif (4 == pixels_per_work_item)\n"
"{\n"
"#ifndef DEPTH_5\n"
"const VECTOR16 r0 = vload16(0, src_ptr);\n"
"const int4 xi = convert_int4(r0.s048c);\n"
"const int4 yi = convert_int4(r0.s159d);\n"
"const int4 zi = convert_int4(r0.s26ae);\n"
"const int4 bi = CV_DESCALE(xi * coeffs[0] + yi * coeffs[1] + zi * coeffs[2], xyz_shift);\n"
"const int4 gi = CV_DESCALE(xi * coeffs[3] + yi * coeffs[4] + zi * coeffs[5], xyz_shift);\n"
"const int4 ri = CV_DESCALE(xi * coeffs[6] + yi * coeffs[7] + zi * coeffs[8], xyz_shift);\n"
"const VECTOR4 R = SAT_CAST4(ri);\n"
"const VECTOR4 G = SAT_CAST4(gi);\n"
"const VECTOR4 B = SAT_CAST4(bi);\n"
"#if dcn == 4\n"
"vstore16((VECTOR16)(B.s0, G.s0, R.s0, MAX_NUM, B.s1, G.s1, R.s1, MAX_NUM, B.s2, G.s2, R.s2, MAX_NUM, B.s3, G.s3, R.s3, MAX_NUM), 0, dst_ptr);\n"
"#else\n"
"vstore16((VECTOR16)(B.s0, G.s0, R.s0, 0, B.s1, G.s1, R.s1, 0, B.s2, G.s2, R.s2, 0, B.s3, G.s3, R.s3, 0), 0, dst_ptr);\n"
"#endif\n"
"#endif\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"__kernel void RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const DATA_TYPE * src, __global DATA_TYPE * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"#ifndef INTEL_DEVICE\n"
"#ifdef REVERSE\n"
"dst[dst_idx] = src[src_idx + 2];\n"
"dst[dst_idx + 1] = src[src_idx + 1];\n"
"dst[dst_idx + 2] = src[src_idx];\n"
"#elif defined ORDER\n"
"dst[dst_idx] = src[src_idx];\n"
"dst[dst_idx + 1] = src[src_idx + 1];\n"
"dst[dst_idx + 2] = src[src_idx + 2];\n"
"#endif\n"
"#if dcn == 4\n"
"#if scn == 3\n"
"dst[dst_idx + 3] = MAX_NUM;\n"
"#else\n"
"dst[dst_idx + 3] = src[src_idx + 3];\n"
"#endif\n"
"#endif\n"
"#else\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"const VECTOR4 r0 = vload4(0, src_ptr);\n"
"#ifdef REVERSE\n"
"if (3 == dcn)\n"
"{\n"
"vstore4((VECTOR4)(r0.s210, 0), 0, dst_ptr);\n"
"}\n"
"else if (3 == scn)\n"
"{\n"
"vstore4((VECTOR4)(r0.s210, MAX_NUM), 0, dst_ptr);\n"
"}\n"
"else {\n"
"vstore4((VECTOR4)(r0.s2103), 0, dst_ptr);\n"
"}\n"
"#elif defined ORDER\n"
"if (3 == dcn)\n"
"{\n"
"vstore4((VECTOR4)(r0.s012, 0), 0, dst_ptr);\n"
"}\n"
"else if (3 == scn)\n"
"{\n"
"vstore4((VECTOR4)(r0.s012, MAX_NUM), 0, dst_ptr);\n"
"}\n"
"else {\n"
"vstore4(r0, 0, dst_ptr);\n"
"}\n"
"#endif\n"
"#endif\n"
"}\n"
"}\n"
"__kernel void RGB5x52RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const ushort * src, __global uchar * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + (x << 2));\n"
"ushort t = src[src_idx];\n"
"#if greenbits == 6\n"
"dst[dst_idx + bidx] = (uchar)(t << 3);\n"
"dst[dst_idx + 1] = (uchar)((t >> 3) & ~3);\n"
"dst[dst_idx + (bidx^2)] = (uchar)((t >> 8) & ~7);\n"
"#else\n"
"dst[dst_idx + bidx] = (uchar)(t << 3);\n"
"dst[dst_idx + 1] = (uchar)((t >> 2) & ~7);\n"
"dst[dst_idx + (bidx^2)] = (uchar)((t >> 7) & ~7);\n"
"#endif\n"
"#if dcn == 4\n"
"#if greenbits == 6\n"
"dst[dst_idx + 3] = 255;\n"
"#else\n"
"dst[dst_idx + 3] = t & 0x8000 ? 255 : 0;\n"
"#endif\n"
"#endif\n"
"}\n"
"}\n"
"__kernel void RGB2RGB5x5(int cols, int rows, int src_step, int dst_step,\n"
"__global const uchar * src, __global ushort * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"int src_idx = mad24(y, src_step, src_offset + (x << 2));\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"#if greenbits == 6\n"
"dst[dst_idx] = (ushort)((src[src_idx + bidx] >> 3)|((src[src_idx + 1]&~3) << 3)|((src[src_idx + (bidx^2)]&~7) << 8));\n"
"#elif scn == 3\n"
"dst[dst_idx] = (ushort)((src[src_idx + bidx] >> 3)|((src[src_idx + 1]&~7) << 2)|((src[src_idx + (bidx^2)]&~7) << 7));\n"
"#else\n"
"dst[dst_idx] = (ushort)((src[src_idx + bidx] >> 3)|((src[src_idx + 1]&~7) << 2)|\n"
"((src[src_idx + (bidx^2)]&~7) << 7)|(src[src_idx + 3] ? 0x8000 : 0));\n"
"#endif\n"
"}\n"
"}\n"
"__kernel void BGR5x52Gray(int cols, int rows, int src_step, int dst_step,\n"
"__global const ushort * src, __global uchar * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"int t = src[src_idx];\n"
"#if greenbits == 6\n"
"dst[dst_idx] = (uchar)CV_DESCALE(((t << 3) & 0xf8)*B2Y +\n"
"((t >> 3) & 0xfc)*G2Y +\n"
"((t >> 8) & 0xf8)*R2Y, yuv_shift);\n"
"#else\n"
"dst[dst_idx] = (uchar)CV_DESCALE(((t << 3) & 0xf8)*B2Y +\n"
"((t >> 2) & 0xf8)*G2Y +\n"
"((t >> 7) & 0xf8)*R2Y, yuv_shift);\n"
"#endif\n"
"}\n"
"}\n"
"__kernel void Gray2BGR5x5(int cols, int rows, int src_step, int dst_step,\n"
"__global const uchar * src, __global ushort * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"int t = src[src_idx];\n"
"#if greenbits == 6\n"
"dst[dst_idx] = (ushort)((t >> 3) | ((t & ~3) << 3) | ((t & ~7) << 8));\n"
"#else\n"
"t >>= 3;\n"
"dst[dst_idx] = (ushort)(t|(t << 5)|(t << 10));\n"
"#endif\n"
"}\n"
"}\n"
"__constant int sector_data[][3] = { {1, 3, 0}, { 1, 0, 2 }, { 3, 0, 1 }, { 0, 2, 1 }, { 0, 1, 3 }, { 2, 1, 0 } };\n"
"#ifdef DEPTH_0\n"
"__kernel void RGB2HSV(int cols, int rows, int src_step, int dst_step,\n"
"__global const uchar * src, __global uchar * dst,\n"
"int src_offset, int dst_offset,\n"
"__constant int * sdiv_table, __constant int * hdiv_table)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"int b = src[src_idx + bidx], g = src[src_idx + 1], r = src[src_idx + (bidx^2)];\n"
"int h, s, v = b;\n"
"int vmin = b, diff;\n"
"int vr, vg;\n"
"v = max( v, g );\n"
"v = max( v, r );\n"
"vmin = min( vmin, g );\n"
"vmin = min( vmin, r );\n"
"diff = v - vmin;\n"
"vr = v == r ? -1 : 0;\n"
"vg = v == g ? -1 : 0;\n"
"s = (diff * sdiv_table[v] + (1 << (hsv_shift-1))) >> hsv_shift;\n"
"h = (vr & (g - b)) +\n"
"(~vr & ((vg & (b - r + 2 * diff)) + ((~vg) & (r - g + 4 * diff))));\n"
"h = (h * hdiv_table[diff] + (1 << (hsv_shift-1))) >> hsv_shift;\n"
"h += h < 0 ? hrange : 0;\n"
"dst[dst_idx] = convert_uchar_sat_rte(h);\n"
"dst[dst_idx + 1] = (uchar)s;\n"
"dst[dst_idx + 2] = (uchar)v;\n"
"}\n"
"}\n"
"__kernel void HSV2RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const uchar * src, __global uchar * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"float h = src[src_idx], s = src[src_idx + 1]*(1/255.f), v = src[src_idx + 2]*(1/255.f);\n"
"float b, g, r;\n"
"if (s != 0)\n"
"{\n"
"float tab[4];\n"
"int sector;\n"
"h *= hscale;\n"
"if( h < 0 )\n"
"do h += 6; while( h < 0 );\n"
"else if( h >= 6 )\n"
"do h -= 6; while( h >= 6 );\n"
"sector = convert_int_sat_rtn(h);\n"
"h -= sector;\n"
"if( (unsigned)sector >= 6u )\n"
"{\n"
"sector = 0;\n"
"h = 0.f;\n"
"}\n"
"tab[0] = v;\n"
"tab[1] = v*(1.f - s);\n"
"tab[2] = v*(1.f - s*h);\n"
"tab[3] = v*(1.f - s*(1.f - h));\n"
"b = tab[sector_data[sector][0]];\n"
"g = tab[sector_data[sector][1]];\n"
"r = tab[sector_data[sector][2]];\n"
"}\n"
"else\n"
"b = g = r = v;\n"
"dst[dst_idx + bidx] = convert_uchar_sat_rte(b*255.f);\n"
"dst[dst_idx + 1] = convert_uchar_sat_rte(g*255.f);\n"
"dst[dst_idx + (bidx^2)] = convert_uchar_sat_rte(r*255.f);\n"
"#if dcn == 4\n"
"dst[dst_idx + 3] = MAX_NUM;\n"
"#endif\n"
"}\n"
"}\n"
"#elif defined DEPTH_5\n"
"__kernel void RGB2HSV(int cols, int rows, int src_step, int dst_step,\n"
"__global const float * src, __global float * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"float b = src[src_idx + bidx], g = src[src_idx + 1], r = src[src_idx + (bidx^2)];\n"
"float h, s, v;\n"
"float vmin, diff;\n"
"v = vmin = r;\n"
"if( v < g ) v = g;\n"
"if( v < b ) v = b;\n"
"if( vmin > g ) vmin = g;\n"
"if( vmin > b ) vmin = b;\n"
"diff = v - vmin;\n"
"s = diff/(float)(fabs(v) + FLT_EPSILON);\n"
"diff = (float)(60./(diff + FLT_EPSILON));\n"
"if( v == r )\n"
"h = (g - b)*diff;\n"
"else if( v == g )\n"
"h = (b - r)*diff + 120.f;\n"
"else\n"
"h = (r - g)*diff + 240.f;\n"
"if( h < 0 ) h += 360.f;\n"
"dst[dst_idx] = h*hscale;\n"
"dst[dst_idx + 1] = s;\n"
"dst[dst_idx + 2] = v;\n"
"}\n"
"}\n"
"__kernel void HSV2RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const float * src, __global float * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"float h = src[src_idx], s = src[src_idx + 1], v = src[src_idx + 2];\n"
"float b, g, r;\n"
"if (s != 0)\n"
"{\n"
"float tab[4];\n"
"int sector;\n"
"h *= hscale;\n"
"if(h < 0)\n"
"do h += 6; while (h < 0);\n"
"else if (h >= 6)\n"
"do h -= 6; while (h >= 6);\n"
"sector = convert_int_sat_rtn(h);\n"
"h -= sector;\n"
"if ((unsigned)sector >= 6u)\n"
"{\n"
"sector = 0;\n"
"h = 0.f;\n"
"}\n"
"tab[0] = v;\n"
"tab[1] = v*(1.f - s);\n"
"tab[2] = v*(1.f - s*h);\n"
"tab[3] = v*(1.f - s*(1.f - h));\n"
"b = tab[sector_data[sector][0]];\n"
"g = tab[sector_data[sector][1]];\n"
"r = tab[sector_data[sector][2]];\n"
"}\n"
"else\n"
"b = g = r = v;\n"
"dst[dst_idx + bidx] = b;\n"
"dst[dst_idx + 1] = g;\n"
"dst[dst_idx + (bidx^2)] = r;\n"
"#if dcn == 4\n"
"dst[dst_idx + 3] = MAX_NUM;\n"
"#endif\n"
"}\n"
"}\n"
"#endif\n"
"#ifdef DEPTH_0\n"
"__kernel void RGB2HLS(int cols, int rows, int src_step, int dst_step,\n"
"__global const uchar * src, __global uchar * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"float b = src[src_idx + bidx]*(1/255.f), g = src[src_idx + 1]*(1/255.f), r = src[src_idx + (bidx^2)]*(1/255.f);\n"
"float h = 0.f, s = 0.f, l;\n"
"float vmin, vmax, diff;\n"
"vmax = vmin = r;\n"
"if (vmax < g) vmax = g;\n"
"if (vmax < b) vmax = b;\n"
"if (vmin > g) vmin = g;\n"
"if (vmin > b) vmin = b;\n"
"diff = vmax - vmin;\n"
"l = (vmax + vmin)*0.5f;\n"
"if (diff > FLT_EPSILON)\n"
"{\n"
"s = l < 0.5f ? diff/(vmax + vmin) : diff/(2 - vmax - vmin);\n"
"diff = 60.f/diff;\n"
"if( vmax == r )\n"
"h = (g - b)*diff;\n"
"else if( vmax == g )\n"
"h = (b - r)*diff + 120.f;\n"
"else\n"
"h = (r - g)*diff + 240.f;\n"
"if( h < 0.f ) h += 360.f;\n"
"}\n"
"dst[dst_idx] = convert_uchar_sat_rte(h*hscale);\n"
"dst[dst_idx + 1] = convert_uchar_sat_rte(l*255.f);\n"
"dst[dst_idx + 2] = convert_uchar_sat_rte(s*255.f);\n"
"}\n"
"}\n"
"__kernel void HLS2RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const uchar * src, __global uchar * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"float h = src[src_idx], l = src[src_idx + 1]*(1.f/255.f), s = src[src_idx + 2]*(1.f/255.f);\n"
"float b, g, r;\n"
"if (s != 0)\n"
"{\n"
"float tab[4];\n"
"float p2 = l <= 0.5f ? l*(1 + s) : l + s - l*s;\n"
"float p1 = 2*l - p2;\n"
"h *= hscale;\n"
"if( h < 0 )\n"
"do h += 6; while( h < 0 );\n"
"else if( h >= 6 )\n"
"do h -= 6; while( h >= 6 );\n"
"int sector = convert_int_sat_rtn(h);\n"
"h -= sector;\n"
"tab[0] = p2;\n"
"tab[1] = p1;\n"
"tab[2] = p1 + (p2 - p1)*(1-h);\n"
"tab[3] = p1 + (p2 - p1)*h;\n"
"b = tab[sector_data[sector][0]];\n"
"g = tab[sector_data[sector][1]];\n"
"r = tab[sector_data[sector][2]];\n"
"}\n"
"else\n"
"b = g = r = l;\n"
"dst[dst_idx + bidx] = convert_uchar_sat_rte(b*255.f);\n"
"dst[dst_idx + 1] = convert_uchar_sat_rte(g*255.f);\n"
"dst[dst_idx + (bidx^2)] = convert_uchar_sat_rte(r*255.f);\n"
"#if dcn == 4\n"
"dst[dst_idx + 3] = MAX_NUM;\n"
"#endif\n"
"}\n"
"}\n"
"#elif defined DEPTH_5\n"
"__kernel void RGB2HLS(int cols, int rows, int src_step, int dst_step,\n"
"__global const float * src, __global float * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"float b = src[src_idx + bidx], g = src[src_idx + 1], r = src[src_idx + (bidx^2)];\n"
"float h = 0.f, s = 0.f, l;\n"
"float vmin, vmax, diff;\n"
"vmax = vmin = r;\n"
"if (vmax < g) vmax = g;\n"
"if (vmax < b) vmax = b;\n"
"if (vmin > g) vmin = g;\n"
"if (vmin > b) vmin = b;\n"
"diff = vmax - vmin;\n"
"l = (vmax + vmin)*0.5f;\n"
"if (diff > FLT_EPSILON)\n"
"{\n"
"s = l < 0.5f ? diff/(vmax + vmin) : diff/(2 - vmax - vmin);\n"
"diff = 60.f/diff;\n"
"if( vmax == r )\n"
"h = (g - b)*diff;\n"
"else if( vmax == g )\n"
"h = (b - r)*diff + 120.f;\n"
"else\n"
"h = (r - g)*diff + 240.f;\n"
"if( h < 0.f ) h += 360.f;\n"
"}\n"
"dst[dst_idx] = h*hscale;\n"
"dst[dst_idx + 1] = l;\n"
"dst[dst_idx + 2] = s;\n"
"}\n"
"}\n"
"__kernel void HLS2RGB(int cols, int rows, int src_step, int dst_step,\n"
"__global const float * src, __global float * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"float h = src[src_idx], l = src[src_idx + 1], s = src[src_idx + 2];\n"
"float b, g, r;\n"
"if (s != 0)\n"
"{\n"
"float tab[4];\n"
"int sector;\n"
"float p2 = l <= 0.5f ? l*(1 + s) : l + s - l*s;\n"
"float p1 = 2*l - p2;\n"
"h *= hscale;\n"
"if( h < 0 )\n"
"do h += 6; while( h < 0 );\n"
"else if( h >= 6 )\n"
"do h -= 6; while( h >= 6 );\n"
"sector = convert_int_sat_rtn(h);\n"
"h -= sector;\n"
"tab[0] = p2;\n"
"tab[1] = p1;\n"
"tab[2] = p1 + (p2 - p1)*(1-h);\n"
"tab[3] = p1 + (p2 - p1)*h;\n"
"b = tab[sector_data[sector][0]];\n"
"g = tab[sector_data[sector][1]];\n"
"r = tab[sector_data[sector][2]];\n"
"}\n"
"else\n"
"b = g = r = l;\n"
"dst[dst_idx + bidx] = b;\n"
"dst[dst_idx + 1] = g;\n"
"dst[dst_idx + (bidx^2)] = r;\n"
"#if dcn == 4\n"
"dst[dst_idx + 3] = MAX_NUM;\n"
"#endif\n"
"}\n"
"}\n"
"#endif\n"
"#ifdef DEPTH_0\n"
"__kernel void RGBA2mRGBA(int cols, int rows, int src_step, int dst_step,\n"
"__global const uchar * src, __global uchar * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0) * pixels_per_work_item;\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"#if (1 == pixels_per_work_item)\n"
"{\n"
"const uchar4 r0 = vload4(0, src_ptr);\n"
"dst_ptr[0] = (r0.s0 * r0.s3 + HALF_MAX) / MAX_NUM;\n"
"dst_ptr[1] = (r0.s1 * r0.s3 + HALF_MAX) / MAX_NUM;\n"
"dst_ptr[2] = (r0.s2 * r0.s3 + HALF_MAX) / MAX_NUM;\n"
"dst_ptr[3] = r0.s3;\n"
"}\n"
"#elif (2 == pixels_per_work_item)\n"
"{\n"
"const uchar8 r0 = vload8(0, src_ptr);\n"
"const int2 v0 = convert_int2(r0.s04);\n"
"const int2 v1 = convert_int2(r0.s15);\n"
"const int2 v2 = convert_int2(r0.s26);\n"
"const int2 v3 = convert_int2(r0.s37);\n"
"const int2 ri = (v0 * v3 + HALF_MAX) / MAX_NUM;\n"
"const int2 gi = (v1 * v3 + HALF_MAX) / MAX_NUM;\n"
"const int2 bi = (v2 * v3 + HALF_MAX) / MAX_NUM;\n"
"const uchar2 r = convert_uchar2(ri);\n"
"const uchar2 g = convert_uchar2(gi);\n"
"const uchar2 b = convert_uchar2(bi);\n"
"vstore8((uchar8)(r.s0, g.s0, b.s0, v3.s0, r.s1, g.s1, b.s1, v3.s1), 0, dst_ptr);\n"
"}\n"
"#elif (4 == pixels_per_work_item)\n"
"{\n"
"const uchar16 r0 = vload16(0, src_ptr);\n"
"const int4 v0 = convert_int4(r0.s048c);\n"
"const int4 v1 = convert_int4(r0.s159d);\n"
"const int4 v2 = convert_int4(r0.s26ae);\n"
"const int4 v3 = convert_int4(r0.s37bf);\n"
"const int4 ri = (v0 * v3 + HALF_MAX) / MAX_NUM;\n"
"const int4 gi = (v1 * v3 + HALF_MAX) / MAX_NUM;\n"
"const int4 bi = (v2 * v3 + HALF_MAX) / MAX_NUM;\n"
"const uchar4 r = convert_uchar4(ri);\n"
"const uchar4 g = convert_uchar4(gi);\n"
"const uchar4 b = convert_uchar4(bi);\n"
"vstore16((uchar16)(r.s0, g.s0, b.s0, v3.s0, r.s1, g.s1, b.s1, v3.s1, r.s2, g.s2, b.s2, v3.s2, r.s3, g.s3, b.s3, v3.s3), 0, dst_ptr);\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"__kernel void mRGBA2RGBA(int cols, int rows, int src_step, int dst_step,\n"
"__global const uchar * src, __global uchar * dst,\n"
"int src_offset, int dst_offset)\n"
"{\n"
"int x = get_global_id(0) * pixels_per_work_item;\n"
"int y = get_global_id(1);\n"
"if (y < rows && x < cols)\n"
"{\n"
"x <<= 2;\n"
"int src_idx = mad24(y, src_step, src_offset + x);\n"
"int dst_idx = mad24(y, dst_step, dst_offset + x);\n"
"global DATA_TYPE *src_ptr = (global DATA_TYPE *)(src + src_idx);\n"
"global DATA_TYPE *dst_ptr = (global DATA_TYPE *)(dst + dst_idx);\n"
"#if (1 == pixels_per_work_item)\n"
"{\n"
"const uchar4 r0 = vload4(0, src_ptr);\n"
"const uchar v3_half = r0.s3 / 2;\n"
"const uchar r = (r0.s3 == 0) ? 0 : (r0.s0 * MAX_NUM + v3_half) / r0.s3;\n"
"const uchar g = (r0.s3 == 0) ? 0 : (r0.s1 * MAX_NUM + v3_half) / r0.s3;\n"
"const uchar b = (r0.s3 == 0) ? 0 : (r0.s2 * MAX_NUM + v3_half) / r0.s3;\n"
"vstore4((uchar4)(r, g, b, r0.s3), 0, dst_ptr);\n"
"}\n"
"#elif (2 == pixels_per_work_item)\n"
"{\n"
"const uchar8 r0 = vload8(0, src_ptr);\n"
"const int2 v0 = convert_int2(r0.s04);\n"
"const int2 v1 = convert_int2(r0.s15);\n"
"const int2 v2 = convert_int2(r0.s26);\n"
"const int2 v3 = convert_int2(r0.s37);\n"
"const int2 v3_half = v3 / 2;\n"
"const int2 ri = (v3 == 0) ? 0 : (v0 * MAX_NUM + v3_half) / v3;\n"
"const int2 gi = (v3 == 0) ? 0 : (v1 * MAX_NUM + v3_half) / v3;\n"
"const int2 bi = (v3 == 0) ? 0 : (v2 * MAX_NUM + v3_half) / v3;\n"
"const uchar2 r = convert_uchar2(ri);\n"
"const uchar2 g = convert_uchar2(gi);\n"
"const uchar2 b = convert_uchar2(bi);\n"
"vstore8((uchar8)(r.s0, g.s0, b.s0, v3.s0, r.s1, g.s1, b.s1, v3.s1), 0, dst_ptr);\n"
"}\n"
"#elif (4 == pixels_per_work_item)\n"
"{\n"
"const uchar16 r0 = vload16(0, src_ptr);\n"
"const int4 v0 = convert_int4(r0.s048c);\n"
"const int4 v1 = convert_int4(r0.s159d);\n"
"const int4 v2 = convert_int4(r0.s26ae);\n"
"const int4 v3 = convert_int4(r0.s37bf);\n"
"const int4 v3_half = v3 / 2;\n"
"const int4 ri = (v3 == 0) ? 0 : (v0 * MAX_NUM + v3_half) / v3;\n"
"const int4 gi = (v3 == 0) ? 0 : (v1 * MAX_NUM + v3_half) / v3;\n"
"const int4 bi = (v3 == 0) ? 0 : (v2 * MAX_NUM + v3_half) / v3;\n"
"const uchar4 r = convert_uchar4(ri);\n"
"const uchar4 g = convert_uchar4(gi);\n"
"const uchar4 b = convert_uchar4(bi);\n"
"vstore16((uchar16)(r.s0, g.s0, b.s0, v3.s0, r.s1, g.s1, b.s1, v3.s1, r.s2, g.s2, b.s2, v3.s2, r.s3, g.s3, b.s3, v3.s3), 0, dst_ptr);\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"#endif\n"
, "d8989aadab81f92a35b32db9740d9b62"};
const struct ProgramEntry filter_sep_col={"filter_sep_col",
"#define READ_TIMES_COL ((2*(RADIUSY+LSIZE1)-1)/LSIZE1)\n"
"#define RADIUS 1\n"
"#if CN ==1\n"
"#define ALIGN (((RADIUS)+3)>>2<<2)\n"
"#elif CN==2\n"
"#define ALIGN (((RADIUS)+1)>>1<<1)\n"
"#elif CN==3\n"
"#define ALIGN (((RADIUS)+3)>>2<<2)\n"
"#elif CN==4\n"
"#define ALIGN (RADIUS)\n"
"#define READ_TIMES_ROW ((2*(RADIUS+LSIZE0)-1)/LSIZE0)\n"
"#endif\n"
"__kernel __attribute__((reqd_work_group_size(LSIZE0,LSIZE1,1))) void col_filter\n"
"(__global const GENTYPE_SRC * restrict src,\n"
"__global GENTYPE_DST * dst,\n"
"const int dst_cols,\n"
"const int dst_rows,\n"
"const int src_whole_cols,\n"
"const int src_whole_rows,\n"
"const int src_step_in_pixel,\n"
"const int dst_step_in_pixel,\n"
"const int dst_offset_in_pixel,\n"
"__constant float * mat_kernel __attribute__((max_constant_size(4*(2*RADIUSY+1)))))\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"int l_x = get_local_id(0);\n"
"int l_y = get_local_id(1);\n"
"int start_addr = mad24(y, src_step_in_pixel, x);\n"
"int end_addr = mad24(src_whole_rows - 1, src_step_in_pixel, src_whole_cols);\n"
"int i;\n"
"GENTYPE_SRC sum, temp[READ_TIMES_COL];\n"
"__local GENTYPE_SRC LDS_DAT[LSIZE1 * READ_TIMES_COL][LSIZE0 + 1];\n"
"for(i = 0;i<READ_TIMES_COL;i++)\n"
"{\n"
"int current_addr = start_addr+i*LSIZE1*src_step_in_pixel;\n"
"current_addr = current_addr < end_addr ? current_addr : 0;\n"
"temp[i] = src[current_addr];\n"
"}\n"
"for(i = 0;i<READ_TIMES_COL;i++)\n"
"{\n"
"LDS_DAT[l_y+i*LSIZE1][l_x] = temp[i];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum = LDS_DAT[l_y+RADIUSY][l_x]*mat_kernel[RADIUSY];\n"
"for(i=1;i<=RADIUSY;i++)\n"
"{\n"
"temp[0]=LDS_DAT[l_y+RADIUSY-i][l_x];\n"
"temp[1]=LDS_DAT[l_y+RADIUSY+i][l_x];\n"
"sum += temp[0] * mat_kernel[RADIUSY-i]+temp[1] * mat_kernel[RADIUSY+i];\n"
"}\n"
"if((x<dst_cols) & (y<dst_rows))\n"
"{\n"
"start_addr = mad24(y,dst_step_in_pixel,x+dst_offset_in_pixel);\n"
"dst[start_addr] = convert_to_DST(sum);\n"
"}\n"
"}\n"
, "06a58fab4710a0c1f63d1a16efbeddf8"};
const struct ProgramEntry filter_sep_row={"filter_sep_row",
"#define READ_TIMES_ROW ((2*(RADIUSX+LSIZE0)-1)/LSIZE0)\n"
"#define READ_TIMES_COL ((2*(RADIUSY+LSIZE1)-1)/LSIZE1)\n"
"#define RADIUS 1\n"
"#if CN ==1\n"
"#define ALIGN (((RADIUS)+3)>>2<<2)\n"
"#elif CN==2\n"
"#define ALIGN (((RADIUS)+1)>>1<<1)\n"
"#elif CN==3\n"
"#define ALIGN (((RADIUS)+3)>>2<<2)\n"
"#elif CN==4\n"
"#define ALIGN (RADIUS)\n"
"#endif\n"
"#ifdef BORDER_CONSTANT\n"
"#define ELEM(i,l_edge,r_edge,elem1,elem2) (i)<(l_edge) | (i) >= (r_edge) ? (elem1) : (elem2)\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"x = max(min(x, maxV - 1), 0); \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"if (x < 0) \\\n"
"x -= ((x - maxV + 1) / maxV) * maxV; \\\n"
"if (x >= maxV) \\\n"
"x %= maxV; \\\n"
"}\n"
"#elif defined(BORDER_REFLECT) || defined(BORDER_REFLECT_101)\n"
"#define EXTRAPOLATE_(x, maxV, delta) \\\n"
"{ \\\n"
"if (maxV == 1) \\\n"
"x = 0; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if ( x < 0 ) \\\n"
"x = -x - 1 + delta; \\\n"
"else \\\n"
"x = maxV - 1 - (x - maxV) - delta; \\\n"
"} \\\n"
"while (x >= maxV || x < 0); \\\n"
"}\n"
"#ifdef BORDER_REFLECT\n"
"#define EXTRAPOLATE(x, maxV) EXTRAPOLATE_(x, maxV, 0)\n"
"#else\n"
"#define EXTRAPOLATE(x, maxV) EXTRAPOLATE_(x, maxV, 1)\n"
"#endif\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"__kernel __attribute__((reqd_work_group_size(LSIZE0,LSIZE1,1))) void row_filter_C1_D0\n"
"(__global uchar * restrict src,\n"
"__global float * dst,\n"
"int dst_cols, int dst_rows,\n"
"int src_whole_cols, int src_whole_rows,\n"
"int src_step_in_pixel,\n"
"int src_offset_x, int src_offset_y,\n"
"int dst_step_in_pixel, int radiusy,\n"
"__constant float * mat_kernel __attribute__((max_constant_size(4*(2*RADIUSX+1)))))\n"
"{\n"
"int x = get_global_id(0)<<2;\n"
"int y = get_global_id(1);\n"
"int l_x = get_local_id(0);\n"
"int l_y = get_local_id(1);\n"
"int start_x = x+src_offset_x - RADIUSX & 0xfffffffc;\n"
"int offset = src_offset_x - RADIUSX & 3;\n"
"int start_y = y + src_offset_y - radiusy;\n"
"int start_addr = mad24(start_y, src_step_in_pixel, start_x);\n"
"int i;\n"
"float4 sum;\n"
"uchar4 temp[READ_TIMES_ROW];\n"
"__local uchar4 LDS_DAT[LSIZE1][READ_TIMES_ROW*LSIZE0+1];\n"
"#ifdef BORDER_CONSTANT\n"
"int end_addr = mad24(src_whole_rows - 1, src_step_in_pixel, src_whole_cols);\n"
"for (i = 0; i < READ_TIMES_ROW; i++)\n"
"{\n"
"int current_addr = start_addr+i*LSIZE0*4;\n"
"current_addr = ((current_addr < end_addr) && (current_addr > 0)) ? current_addr : 0;\n"
"temp[i] = *(__global uchar4*)&src[current_addr];\n"
"}\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"temp[i].x = ELEM(start_x+i*LSIZE0*4,0,src_whole_cols,0,temp[i].x);\n"
"temp[i].y = ELEM(start_x+i*LSIZE0*4+1,0,src_whole_cols,0,temp[i].y);\n"
"temp[i].z = ELEM(start_x+i*LSIZE0*4+2,0,src_whole_cols,0,temp[i].z);\n"
"temp[i].w = ELEM(start_x+i*LSIZE0*4+3,0,src_whole_cols,0,temp[i].w);\n"
"temp[i]   = ELEM(start_y,0,src_whole_rows,(uchar4)0,temp[i]);\n"
"}\n"
"#else\n"
"int not_all_in_range = (start_x<0) | (start_x + READ_TIMES_ROW*LSIZE0*4+4>src_whole_cols)| (start_y<0) | (start_y >= src_whole_rows);\n"
"int4 index[READ_TIMES_ROW];\n"
"int4 addr;\n"
"int s_y;\n"
"if (not_all_in_range)\n"
"{\n"
"for (i = 0; i < READ_TIMES_ROW; i++)\n"
"{\n"
"index[i] = (int4)(start_x+i*LSIZE0*4) + (int4)(0, 1, 2, 3);\n"
"EXTRAPOLATE(index[i].x, src_whole_cols);\n"
"EXTRAPOLATE(index[i].y, src_whole_cols);\n"
"EXTRAPOLATE(index[i].z, src_whole_cols);\n"
"EXTRAPOLATE(index[i].w, src_whole_cols);\n"
"}\n"
"s_y = start_y;\n"
"EXTRAPOLATE(s_y, src_whole_rows);\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"addr = mad24((int4)s_y,(int4)src_step_in_pixel,index[i]);\n"
"temp[i].x = src[addr.x];\n"
"temp[i].y = src[addr.y];\n"
"temp[i].z = src[addr.z];\n"
"temp[i].w = src[addr.w];\n"
"}\n"
"}\n"
"else\n"
"{\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"temp[i] = *(__global uchar4*)&src[start_addr+i*LSIZE0*4];\n"
"}\n"
"#endif\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"LDS_DAT[l_y][l_x+i*LSIZE0]=temp[i];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum =convert_float4(vload4(0,(__local uchar*)&LDS_DAT[l_y][l_x]+RADIUSX+offset))*mat_kernel[RADIUSX];\n"
"for (i=1; i<=RADIUSX; i++)\n"
"{\n"
"temp[0] = vload4(0, (__local uchar*)&LDS_DAT[l_y][l_x] + RADIUSX + offset - i);\n"
"temp[1] = vload4(0, (__local uchar*)&LDS_DAT[l_y][l_x] + RADIUSX + offset + i);\n"
"sum += convert_float4(temp[0]) * mat_kernel[RADIUSX-i] + convert_float4(temp[1]) * mat_kernel[RADIUSX+i];\n"
"}\n"
"start_addr = mad24(y,dst_step_in_pixel,x);\n"
"if ((x+3<dst_cols) & (y<dst_rows))\n"
"*(__global float4*)&dst[start_addr] = sum;\n"
"else if ((x+2<dst_cols) && (y<dst_rows))\n"
"{\n"
"dst[start_addr] = sum.x;\n"
"dst[start_addr+1] = sum.y;\n"
"dst[start_addr+2] = sum.z;\n"
"}\n"
"else if ((x+1<dst_cols) && (y<dst_rows))\n"
"{\n"
"dst[start_addr] = sum.x;\n"
"dst[start_addr+1] = sum.y;\n"
"}\n"
"else if (x<dst_cols && y<dst_rows)\n"
"dst[start_addr] = sum.x;\n"
"}\n"
"__kernel __attribute__((reqd_work_group_size(LSIZE0,LSIZE1,1))) void row_filter_C4_D0\n"
"(__global uchar4 * restrict src,\n"
"__global float4 * dst,\n"
"int dst_cols, int dst_rows,\n"
"int src_whole_cols, int src_whole_rows,\n"
"int src_step_in_pixel,\n"
"int src_offset_x, int src_offset_y,\n"
"int dst_step_in_pixel, int radiusy,\n"
"__constant float * mat_kernel __attribute__((max_constant_size(4*(2*RADIUSX+1)))))\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"int l_x = get_local_id(0);\n"
"int l_y = get_local_id(1);\n"
"int start_x = x+src_offset_x-RADIUSX;\n"
"int start_y = y+src_offset_y-radiusy;\n"
"int start_addr = mad24(start_y,src_step_in_pixel,start_x);\n"
"int i;\n"
"float4 sum;\n"
"uchar4 temp[READ_TIMES_ROW];\n"
"__local uchar4 LDS_DAT[LSIZE1][READ_TIMES_ROW*LSIZE0+1];\n"
"#ifdef BORDER_CONSTANT\n"
"int end_addr = mad24(src_whole_rows - 1,src_step_in_pixel,src_whole_cols);\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"int current_addr = start_addr+i*LSIZE0;\n"
"current_addr = ((current_addr < end_addr) && (current_addr > 0)) ? current_addr : 0;\n"
"temp[i] = src[current_addr];\n"
"}\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"temp[i]= ELEM(start_x+i*LSIZE0,0,src_whole_cols,(uchar4)0,temp[i]);\n"
"temp[i]= ELEM(start_y,0,src_whole_rows,(uchar4)0,temp[i]);\n"
"}\n"
"#else\n"
"int index[READ_TIMES_ROW];\n"
"int s_x,s_y;\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"s_x = start_x+i*LSIZE0;\n"
"EXTRAPOLATE(s_x, src_whole_cols);\n"
"s_y = start_y;\n"
"EXTRAPOLATE(s_y, src_whole_rows);\n"
"index[i]=mad24(s_y,src_step_in_pixel,s_x);\n"
"}\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"temp[i] = src[index[i]];\n"
"#endif\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"LDS_DAT[l_y][l_x+i*LSIZE0]=temp[i];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum =convert_float4(LDS_DAT[l_y][l_x+RADIUSX])*mat_kernel[RADIUSX];\n"
"for (i=1; i<=RADIUSX; i++)\n"
"{\n"
"temp[0]=LDS_DAT[l_y][l_x+RADIUSX-i];\n"
"temp[1]=LDS_DAT[l_y][l_x+RADIUSX+i];\n"
"sum += convert_float4(temp[0])*mat_kernel[RADIUSX-i]+convert_float4(temp[1])*mat_kernel[RADIUSX+i];\n"
"}\n"
"if (x<dst_cols && y<dst_rows)\n"
"{\n"
"start_addr = mad24(y,dst_step_in_pixel,x);\n"
"dst[start_addr] = sum;\n"
"}\n"
"}\n"
"__kernel __attribute__((reqd_work_group_size(LSIZE0,LSIZE1,1))) void row_filter_C1_D5\n"
"(__global float * restrict src,\n"
"__global float * dst,\n"
"int dst_cols, int dst_rows,\n"
"int src_whole_cols, int src_whole_rows,\n"
"int src_step_in_pixel,\n"
"int src_offset_x, int src_offset_y,\n"
"int dst_step_in_pixel, int radiusy,\n"
"__constant float * mat_kernel __attribute__((max_constant_size(4*(2*RADIUSX+1)))))\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"int l_x = get_local_id(0);\n"
"int l_y = get_local_id(1);\n"
"int start_x = x+src_offset_x-RADIUSX;\n"
"int start_y = y+src_offset_y-radiusy;\n"
"int start_addr = mad24(start_y,src_step_in_pixel,start_x);\n"
"int i;\n"
"float sum;\n"
"float temp[READ_TIMES_ROW];\n"
"__local float LDS_DAT[LSIZE1][READ_TIMES_ROW*LSIZE0+1];\n"
"#ifdef BORDER_CONSTANT\n"
"int end_addr = mad24(src_whole_rows - 1,src_step_in_pixel,src_whole_cols);\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"int current_addr = start_addr+i*LSIZE0;\n"
"current_addr = ((current_addr < end_addr) && (current_addr > 0)) ? current_addr : 0;\n"
"temp[i] = src[current_addr];\n"
"}\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"temp[i]= ELEM(start_x+i*LSIZE0,0,src_whole_cols,(float)0,temp[i]);\n"
"temp[i]= ELEM(start_y,0,src_whole_rows,(float)0,temp[i]);\n"
"}\n"
"#else\n"
"int index[READ_TIMES_ROW];\n"
"int s_x,s_y;\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"s_x = start_x + i*LSIZE0, s_y = start_y;\n"
"EXTRAPOLATE(s_x, src_whole_cols);\n"
"EXTRAPOLATE(s_y, src_whole_rows);\n"
"index[i]=mad24(s_y, src_step_in_pixel, s_x);\n"
"}\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"temp[i] = src[index[i]];\n"
"#endif\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"LDS_DAT[l_y][l_x+i*LSIZE0]=temp[i];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum =LDS_DAT[l_y][l_x+RADIUSX]*mat_kernel[RADIUSX];\n"
"for (i=1; i<=RADIUSX; i++)\n"
"{\n"
"temp[0]=LDS_DAT[l_y][l_x+RADIUSX-i];\n"
"temp[1]=LDS_DAT[l_y][l_x+RADIUSX+i];\n"
"sum += temp[0]*mat_kernel[RADIUSX-i]+temp[1]*mat_kernel[RADIUSX+i];\n"
"}\n"
"if (x<dst_cols && y<dst_rows)\n"
"{\n"
"start_addr = mad24(y,dst_step_in_pixel,x);\n"
"dst[start_addr] = sum;\n"
"}\n"
"}\n"
"__kernel __attribute__((reqd_work_group_size(LSIZE0,LSIZE1,1))) void row_filter_C4_D5\n"
"(__global float4 * restrict src,\n"
"__global float4 * dst,\n"
"int dst_cols, int dst_rows,\n"
"int src_whole_cols, int src_whole_rows,\n"
"int src_step_in_pixel,\n"
"int src_offset_x, int src_offset_y,\n"
"int dst_step_in_pixel, int radiusy,\n"
"__constant float * mat_kernel __attribute__((max_constant_size(4*(2*RADIUSX+1)))))\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"int l_x = get_local_id(0);\n"
"int l_y = get_local_id(1);\n"
"int start_x = x+src_offset_x-RADIUSX;\n"
"int start_y = y+src_offset_y-radiusy;\n"
"int start_addr = mad24(start_y,src_step_in_pixel,start_x);\n"
"int i;\n"
"float4 sum;\n"
"float4 temp[READ_TIMES_ROW];\n"
"__local float4 LDS_DAT[LSIZE1][READ_TIMES_ROW*LSIZE0+1];\n"
"#ifdef BORDER_CONSTANT\n"
"int end_addr = mad24(src_whole_rows - 1,src_step_in_pixel,src_whole_cols);\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"int current_addr = start_addr+i*LSIZE0;\n"
"current_addr = ((current_addr < end_addr) && (current_addr > 0)) ? current_addr : 0;\n"
"temp[i] = src[current_addr];\n"
"}\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"temp[i]= ELEM(start_x+i*LSIZE0,0,src_whole_cols,(float4)0,temp[i]);\n"
"temp[i]= ELEM(start_y,0,src_whole_rows,(float4)0,temp[i]);\n"
"}\n"
"#else\n"
"int index[READ_TIMES_ROW];\n"
"int s_x,s_y;\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"{\n"
"s_x = start_x + i*LSIZE0, s_y = start_y;\n"
"EXTRAPOLATE(s_x, src_whole_cols);\n"
"EXTRAPOLATE(s_y, src_whole_rows);\n"
"index[i]=mad24(s_y,src_step_in_pixel,s_x);\n"
"}\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"temp[i] = src[index[i]];\n"
"#endif\n"
"for (i = 0; i<READ_TIMES_ROW; i++)\n"
"LDS_DAT[l_y][l_x+i*LSIZE0]=temp[i];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum =LDS_DAT[l_y][l_x+RADIUSX]*mat_kernel[RADIUSX];\n"
"for (i=1; i<=RADIUSX; i++)\n"
"{\n"
"temp[0]=LDS_DAT[l_y][l_x+RADIUSX-i];\n"
"temp[1]=LDS_DAT[l_y][l_x+RADIUSX+i];\n"
"sum += temp[0]*mat_kernel[RADIUSX-i]+temp[1]*mat_kernel[RADIUSX+i];\n"
"}\n"
"if (x<dst_cols && y<dst_rows)\n"
"{\n"
"start_addr = mad24(y,dst_step_in_pixel,x);\n"
"dst[start_addr] = sum;\n"
"}\n"
"}\n"
, "f8d165185422bdb2670abb440bc50225"};
const struct ProgramEntry filtering_adaptive_bilateral={"filtering_adaptive_bilateral",
"#ifdef BORDER_CONSTANT\n"
"#define ELEM(i,l_edge,r_edge,elem1,elem2) (i)<(l_edge) | (i) >= (r_edge) ? (elem1) : (elem2)\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"x = max(min(x, maxV - 1), 0); \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"if (x < 0) \\\n"
"x -= ((x - maxV + 1) / maxV) * maxV; \\\n"
"if (x >= maxV) \\\n"
"x %= maxV; \\\n"
"}\n"
"#elif defined(BORDER_REFLECT) || defined(BORDER_REFLECT_101)\n"
"#define EXTRAPOLATE_(x, maxV, delta) \\\n"
"{ \\\n"
"if (maxV == 1) \\\n"
"x = 0; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if ( x < 0 ) \\\n"
"x = -x - 1 + delta; \\\n"
"else \\\n"
"x = maxV - 1 - (x - maxV) - delta; \\\n"
"} \\\n"
"while (x >= maxV || x < 0); \\\n"
"}\n"
"#ifdef BORDER_REFLECT\n"
"#define EXTRAPOLATE(x, maxV) EXTRAPOLATE_(x, maxV, 0)\n"
"#else\n"
"#define EXTRAPOLATE(x, maxV) EXTRAPOLATE_(x, maxV, 1)\n"
"#endif\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"__kernel void\n"
"adaptiveBilateralFilter_C4_D0(\n"
"__global const uchar4 * restrict src,\n"
"__global uchar4 *dst,\n"
"float alpha,\n"
"int src_offset,\n"
"int src_whole_rows,\n"
"int src_whole_cols,\n"
"int src_step,\n"
"int dst_offset,\n"
"int dst_rows,\n"
"int dst_cols,\n"
"int dst_step,\n"
"__global const float* lut,\n"
"int lut_step)\n"
"{\n"
"int col = get_local_id(0);\n"
"const int gX = get_group_id(0);\n"
"const int gY = get_group_id(1);\n"
"int src_x_off = (src_offset % src_step) >> 2;\n"
"int src_y_off = src_offset / src_step;\n"
"int dst_x_off = (dst_offset % dst_step) >> 2;\n"
"int dst_y_off = dst_offset / dst_step;\n"
"int startX = gX * (THREADS-ksX+1) - anX + src_x_off;\n"
"int startY = (gY * (1+EXTRA)) - anY + src_y_off;\n"
"int dst_startX = gX * (THREADS-ksX+1) + dst_x_off;\n"
"int dst_startY = (gY * (1+EXTRA)) + dst_y_off;\n"
"int posX = dst_startX - dst_x_off + col;\n"
"int posY = (gY * (1+EXTRA))  ;\n"
"__local uchar4 data[ksY+EXTRA][THREADS];\n"
"float4 tmp_sum[1+EXTRA];\n"
"for(int tmpint = 0; tmpint < 1+EXTRA; tmpint++)\n"
"tmp_sum[tmpint] = (float4)(0,0,0,0);\n"
"#ifdef BORDER_CONSTANT\n"
"bool con;\n"
"uchar4 ss;\n"
"for(int j = 0;  j < ksY+EXTRA; j++)\n"
"{\n"
"con = (startX+col >= 0 && startX+col < src_whole_cols && startY+j >= 0 && startY+j < src_whole_rows);\n"
"int cur_col = clamp(startX + col, 0, src_whole_cols);\n"
"if (con)\n"
"ss = src[(startY+j)*(src_step>>2) + cur_col];\n"
"data[j][col] = con ? ss : (uchar4)0;\n"
"}\n"
"#else\n"
"for(int j= 0; j < ksY+EXTRA; j++)\n"
"{\n"
"int selected_row = startY+j, selected_col = startX+col;\n"
"EXTRAPOLATE(selected_row, src_whole_rows)\n"
"EXTRAPOLATE(selected_col, src_whole_cols)\n"
"data[j][col] = src[selected_row * (src_step>>2) + selected_col];\n"
"}\n"
"#endif\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"float4 var[1+EXTRA];\n"
"#if VAR_PER_CHANNEL\n"
"float4 weight;\n"
"float4 totalWeight = (float4)(0,0,0,0);\n"
"#else\n"
"float weight;\n"
"float totalWeight = 0;\n"
"#endif\n"
"int4 currValCenter;\n"
"int4 currWRTCenter;\n"
"int4 sumVal = 0;\n"
"int4 sumValSqr = 0;\n"
"if(col < (THREADS-(ksX-1)))\n"
"{\n"
"int4 currVal;\n"
"int howManyAll = (2*anX+1)*(ksY);\n"
"int startLMj;\n"
"int endLMj ;\n"
"for(int extraCnt = 0; extraCnt <=EXTRA; extraCnt++)\n"
"{\n"
"#if CALCVAR\n"
"startLMj = extraCnt;\n"
"endLMj =  ksY+extraCnt-1;\n"
"sumVal = (int4)0;\n"
"sumValSqr= (int4)0;\n"
"for(int j = startLMj; j < endLMj; j++)\n"
"for(int i=-anX; i<=anX; i++)\n"
"{\n"
"currVal = convert_int4(data[j][col+anX+i]);\n"
"sumVal += currVal;\n"
"sumValSqr += mul24(currVal, currVal);\n"
"}\n"
"var[extraCnt] = clamp( convert_float4( ( (sumValSqr * howManyAll)- mul24(sumVal , sumVal) ) ) /  ( (float)(howManyAll*howManyAll) ), (float4)(0.1f, 0.1f, 0.1f, 0.1f), (float4)(MAX_VAR_VAL, MAX_VAR_VAL, MAX_VAR_VAL, MAX_VAR_VAL)) ;\n"
"#else\n"
"var[extraCnt] = (float4)(MAX_VAR_VAL, MAX_VAR_VAL, MAX_VAR_VAL, MAX_VAR_VAL);\n"
"#endif\n"
"}\n"
"for(int extraCnt = 0; extraCnt <= EXTRA; extraCnt++)\n"
"{\n"
"startLMj = extraCnt;\n"
"endLMj =  extraCnt + ksY;\n"
"currValCenter = convert_int4( data[ (startLMj + endLMj)/2][col+anX] );\n"
"for(int j = startLMj, lut_j = 0; j < endLMj; j++, lut_j++)\n"
"{\n"
"for(int i=-anX; i<=anX; i++)\n"
"{\n"
"#if FIXED_WEIGHT\n"
"#if VAR_PER_CHANNEL\n"
"weight.x = 1.0f;\n"
"weight.y = 1.0f;\n"
"weight.z = 1.0f;\n"
"weight.w = 1.0f;\n"
"#else\n"
"weight = 1.0f;\n"
"#endif\n"
"#else\n"
"currVal = convert_int4(data[j][col+anX+i]);\n"
"currWRTCenter = currVal-currValCenter;\n"
"#if ABF_GAUSSIAN\n"
"#if VAR_PER_CHANNEL\n"
"weight = exp( (float4)(-0.5f, -0.5f, -0.5f, -0.5f) * convert_float4(currWRTCenter * currWRTCenter) / var[extraCnt] )*\n"
"(float4)(lut[lut_j*lut_step+anX+i]);\n"
"#else\n"
"weight = exp( -0.5f * (mul24(currWRTCenter.x, currWRTCenter.x) + mul24(currWRTCenter.y, currWRTCenter.y) +\n"
"mul24(currWRTCenter.z, currWRTCenter.z) ) / (var[extraCnt].x+var[extraCnt].y+var[extraCnt].z) ) * lut[lut_j*lut_step+anX+i];\n"
"#endif\n"
"#else\n"
"#if VAR_PER_CHANNEL\n"
"weight = var[extraCnt] / (var[extraCnt] + convert_float4(currWRTCenter * currWRTCenter)) *\n"
"(float4)(lut[lut_j*lut_step+anX+i]);\n"
"#else\n"
"weight = ((float)lut[lut_j*lut_step+anX+i]) /(1.0f+( mul24(currWRTCenter.x, currWRTCenter.x) + mul24(currWRTCenter.y, currWRTCenter.y) +\n"
"mul24(currWRTCenter.z, currWRTCenter.z))/(var[extraCnt].x+var[extraCnt].y+var[extraCnt].z));\n"
"#endif\n"
"#endif\n"
"#endif\n"
"tmp_sum[extraCnt] += convert_float4(data[j][col+anX+i]) * weight;\n"
"totalWeight += weight;\n"
"}\n"
"}\n"
"if(posX >= 0 && posX < dst_cols && (posY+extraCnt) >= 0 && (posY+extraCnt) < dst_rows)\n"
"dst[(dst_startY+extraCnt) * (dst_step>>2)+ dst_startX + col] = convert_uchar4_rtz( (tmp_sum[extraCnt] / (float4)totalWeight) + (float4)0.5f);\n"
"#if VAR_PER_CHANNEL\n"
"totalWeight = (float4)(0,0,0,0);\n"
"#else\n"
"totalWeight = 0.0f;\n"
"#endif\n"
"}\n"
"}\n"
"}\n"
"__kernel void\n"
"adaptiveBilateralFilter_C1_D0(\n"
"__global const uchar * restrict src,\n"
"__global uchar *dst,\n"
"float alpha,\n"
"int src_offset,\n"
"int src_whole_rows,\n"
"int src_whole_cols,\n"
"int src_step,\n"
"int dst_offset,\n"
"int dst_rows,\n"
"int dst_cols,\n"
"int dst_step,\n"
"__global const float * lut,\n"
"int lut_step)\n"
"{\n"
"int col = get_local_id(0);\n"
"const int gX = get_group_id(0);\n"
"const int gY = get_group_id(1);\n"
"int src_x_off = (src_offset % src_step);\n"
"int src_y_off = src_offset / src_step;\n"
"int dst_x_off = (dst_offset % dst_step);\n"
"int dst_y_off = dst_offset / dst_step;\n"
"int startX = gX * (THREADS-ksX+1) - anX + src_x_off;\n"
"int startY = (gY * (1+EXTRA)) - anY + src_y_off;\n"
"int dst_startX = gX * (THREADS-ksX+1) + dst_x_off;\n"
"int dst_startY = (gY * (1+EXTRA)) + dst_y_off;\n"
"int posX = dst_startX - dst_x_off + col;\n"
"int posY = (gY * (1+EXTRA))  ;\n"
"__local uchar data[ksY+EXTRA][THREADS];\n"
"float tmp_sum[1+EXTRA];\n"
"for(int tmpint = 0; tmpint < 1+EXTRA; tmpint++)\n"
"{\n"
"tmp_sum[tmpint] = (float)(0);\n"
"}\n"
"#ifdef BORDER_CONSTANT\n"
"bool con;\n"
"uchar ss;\n"
"for(int j = 0;  j < ksY+EXTRA; j++)\n"
"{\n"
"con = (startX+col >= 0 && startX+col < src_whole_cols && startY+j >= 0 && startY+j < src_whole_rows);\n"
"int cur_col = clamp(startX + col, 0, src_whole_cols);\n"
"if(con)\n"
"{\n"
"ss = src[(startY+j)*(src_step) + cur_col];\n"
"}\n"
"data[j][col] = con ? ss : 0;\n"
"}\n"
"#else\n"
"for(int j= 0; j < ksY+EXTRA; j++)\n"
"{\n"
"int selected_row = startY+j, selected_col = startX+col;\n"
"EXTRAPOLATE(selected_row, src_whole_rows)\n"
"EXTRAPOLATE(selected_col, src_whole_cols)\n"
"data[j][col] = src[selected_row * (src_step) + selected_col];\n"
"}\n"
"#endif\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"float var[1+EXTRA];\n"
"float weight;\n"
"float totalWeight = 0;\n"
"int currValCenter;\n"
"int currWRTCenter;\n"
"int sumVal = 0;\n"
"int sumValSqr = 0;\n"
"if(col < (THREADS-(ksX-1)))\n"
"{\n"
"int currVal;\n"
"int howManyAll = (2*anX+1)*(ksY);\n"
"int startLMj;\n"
"int endLMj;\n"
"for(int extraCnt=0; extraCnt<=EXTRA; extraCnt++)\n"
"{\n"
"#if CALCVAR\n"
"startLMj = extraCnt;\n"
"endLMj =  ksY+extraCnt-1;\n"
"sumVal = 0;\n"
"sumValSqr =0;\n"
"for(int j = startLMj; j < endLMj; j++)\n"
"{\n"
"for(int i=-anX; i<=anX; i++)\n"
"{\n"
"currVal  = (uint)(data[j][col+anX+i])  ;\n"
"sumVal += currVal;\n"
"sumValSqr += mul24(currVal, currVal);\n"
"}\n"
"}\n"
"var[extraCnt] =  clamp((float)( ( (sumValSqr * howManyAll)- mul24(sumVal , sumVal) ) ) /  ( (float)(howManyAll*howManyAll) ) , 0.1f, (float)(MAX_VAR_VAL) );\n"
"#else\n"
"var[extraCnt] = (float)(MAX_VAR_VAL);\n"
"#endif\n"
"}\n"
"for(int extraCnt = 0; extraCnt <= EXTRA; extraCnt++)\n"
"{\n"
"startLMj = extraCnt;\n"
"endLMj =  extraCnt + ksY;\n"
"currValCenter = (int)( data[ (startLMj + endLMj)/2][col+anX] );\n"
"for(int j = startLMj, lut_j = 0; j < endLMj; j++, lut_j++)\n"
"{\n"
"for(int i=-anX; i<=anX; i++)\n"
"{\n"
"#if FIXED_WEIGHT\n"
"weight = 1.0f;\n"
"#else\n"
"currVal  = (int)(data[j][col+anX+i])  ;\n"
"currWRTCenter = currVal-currValCenter;\n"
"#if ABF_GAUSSIAN\n"
"weight = exp( -0.5f * (float)mul24(currWRTCenter,currWRTCenter)/var[extraCnt]) * lut[lut_j*lut_step+anX+i] ;\n"
"#else\n"
"weight = var[extraCnt] / (var[extraCnt] + (float)mul24(currWRTCenter,currWRTCenter)) * lut[lut_j*lut_step+anX+i] ;\n"
"#endif\n"
"#endif\n"
"tmp_sum[extraCnt] += (float)(data[j][col+anX+i] * weight);\n"
"totalWeight += weight;\n"
"}\n"
"}\n"
"if(posX >= 0 && posX < dst_cols && (posY+extraCnt) >= 0 && (posY+extraCnt) < dst_rows)\n"
"{\n"
"dst[(dst_startY+extraCnt) * (dst_step)+ dst_startX + col] = convert_uchar_rtz(tmp_sum[extraCnt]/totalWeight+0.5f);\n"
"}\n"
"totalWeight = 0;\n"
"}\n"
"}\n"
"}\n"
, "9bf8fa5a50a63ee945172dc0f70760f2"};
const struct ProgramEntry filtering_boxFilter={"filtering_boxFilter",
"#ifdef BORDER_REPLICATE\n"
"#define ADDR_L(i, l_edge, r_edge)  ((i) <  (l_edge) ? (l_edge)   : (i))\n"
"#define ADDR_R(i, r_edge, addr)    ((i) >= (r_edge) ? (r_edge)-1 : (addr))\n"
"#define ADDR_H(i, t_edge, b_edge)  ((i) <  (t_edge) ? (t_edge)   :(i))\n"
"#define ADDR_B(i, b_edge, addr)    ((i) >= (b_edge) ? (b_edge)-1 :(addr))\n"
"#endif\n"
"#ifdef BORDER_REFLECT\n"
"#define ADDR_L(i, l_edge, r_edge)  ((i) <  (l_edge) ? -(i)-1               : (i))\n"
"#define ADDR_R(i, r_edge, addr)    ((i) >= (r_edge) ? -(i)-1+((r_edge)<<1) : (addr))\n"
"#define ADDR_H(i, t_edge, b_edge)  ((i) <  (t_edge) ? -(i)-1 : (i))\n"
"#define ADDR_B(i, b_edge, addr)    ((i) >= (b_edge) ? -(i)-1+((b_edge)<<1) : (addr))\n"
"#endif\n"
"#ifdef BORDER_REFLECT_101\n"
"#define ADDR_L(i, l_edge, r_edge)  ((i) <  (l_edge) ? -(i)                 : (i))\n"
"#define ADDR_R(i, r_edge, addr)    ((i) >= (r_edge) ? -(i)-2+((r_edge)<<1) : (addr))\n"
"#define ADDR_H(i, t_edge, b_edge)  ((i) <  (t_edge) ? -(i)                 : (i))\n"
"#define ADDR_B(i, b_edge, addr)    ((i) >= (b_edge) ? -(i)-2+((b_edge)<<1) : (addr))\n"
"#endif\n"
"#ifdef BORDER_WRAP\n"
"#define ADDR_L(i, l_edge, r_edge)  ((i) <  (l_edge) ? (i)+(r_edge) : (i))\n"
"#define ADDR_R(i, r_edge, addr)    ((i) >= (r_edge) ? (i)-(r_edge) : (addr))\n"
"#define ADDR_H(i, t_edge, b_edge)  ((i) <  (t_edge) ? (i)+(b_edge) : (i))\n"
"#define ADDR_B(i, b_edge, addr)    ((i) >= (b_edge) ? (i)-(b_edge) : (addr))\n"
"#endif\n"
"#ifdef EXTRA_EXTRAPOLATION\n"
"#ifdef BORDER_CONSTANT\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) \\\n"
"{ \\\n"
"x = max(min(x, maxX - 1), minX); \\\n"
"y = max(min(y, maxY - 1), minY); \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) \\\n"
"{ \\\n"
"if (x < minX) \\\n"
"x -= ((x - maxX + 1) / maxX) * maxX; \\\n"
"if (x >= maxX) \\\n"
"x %= maxX; \\\n"
"if (y < minY) \\\n"
"y -= ((y - maxY + 1) / maxY) * maxY; \\\n"
"if (y >= maxY) \\\n"
"y %= maxY; \\\n"
"}\n"
"#elif defined(BORDER_REFLECT) || defined(BORDER_REFLECT_101)\n"
"#define EXTRAPOLATE_(x, y, minX, minY, maxX, maxY, delta) \\\n"
"{ \\\n"
"if (maxX - minX == 1) \\\n"
"x = minX; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if (x < minX) \\\n"
"x = -(x - minX) - 1 + delta; \\\n"
"else \\\n"
"x = maxX - 1 - (x - maxX) - delta; \\\n"
"} \\\n"
"while (x >= maxX || x < minX); \\\n"
"\\\n"
"if (maxY - minY == 1) \\\n"
"y = minY; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if (y < minY) \\\n"
"y = -(y - minY) - 1 + delta; \\\n"
"else \\\n"
"y = maxY - 1 - (y - maxY) - delta; \\\n"
"} \\\n"
"while (y >= maxY || y < minY); \\\n"
"}\n"
"#ifdef BORDER_REFLECT\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) EXTRAPOLATE_(x, y, minX, minY, maxX, maxY, 0)\n"
"#elif defined(BORDER_REFLECT_101)\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) EXTRAPOLATE_(x, y, minX, minY, maxX, maxY, 1)\n"
"#endif\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"#else\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) \\\n"
"{ \\\n"
"int _row = y - minY, _col = x - minX; \\\n"
"_row = ADDR_H(_row, 0, maxY - minY); \\\n"
"_row = ADDR_B(_row, maxY - minY, _row); \\\n"
"y = _row + minY; \\\n"
"\\\n"
"_col = ADDR_L(_col, 0, maxX - minX); \\\n"
"_col = ADDR_R(_col, maxX - minX, _col); \\\n"
"x = _col + minX; \\\n"
"}\n"
"#endif\n"
"#if USE_DOUBLE\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define FPTYPE double\n"
"#define CONVERT_TO_FPTYPE CAT(convert_double, VEC_SIZE)\n"
"#else\n"
"#define FPTYPE float\n"
"#define CONVERT_TO_FPTYPE CAT(convert_float, VEC_SIZE)\n"
"#endif\n"
"#if DATA_DEPTH == 0\n"
"#define BASE_TYPE uchar\n"
"#elif DATA_DEPTH == 1\n"
"#define BASE_TYPE char\n"
"#elif DATA_DEPTH == 2\n"
"#define BASE_TYPE ushort\n"
"#elif DATA_DEPTH == 3\n"
"#define BASE_TYPE short\n"
"#elif DATA_DEPTH == 4\n"
"#define BASE_TYPE int\n"
"#elif DATA_DEPTH == 5\n"
"#define BASE_TYPE float\n"
"#elif DATA_DEPTH == 6\n"
"#define BASE_TYPE double\n"
"#else\n"
"#error data_depth\n"
"#endif\n"
"#define __CAT(x, y) x##y\n"
"#define CAT(x, y) __CAT(x, y)\n"
"#define uchar1 uchar\n"
"#define char1 char\n"
"#define ushort1 ushort\n"
"#define short1 short\n"
"#define int1 int\n"
"#define float1 float\n"
"#define double1 double\n"
"#define convert_uchar1_sat_rte convert_uchar_sat_rte\n"
"#define convert_char1_sat_rte convert_char_sat_rte\n"
"#define convert_ushort1_sat_rte convert_ushort_sat_rte\n"
"#define convert_short1_sat_rte convert_short_sat_rte\n"
"#define convert_int1_sat_rte convert_int_sat_rte\n"
"#define convert_float1\n"
"#define convert_double1\n"
"#if DATA_DEPTH == 5 || DATA_DEPTH == 6\n"
"#define CONVERT_TO_TYPE CAT(CAT(convert_, BASE_TYPE), VEC_SIZE)\n"
"#else\n"
"#define CONVERT_TO_TYPE CAT(CAT(CAT(convert_, BASE_TYPE), VEC_SIZE), _sat_rte)\n"
"#endif\n"
"#define VEC_SIZE DATA_CHAN\n"
"#define VEC_TYPE CAT(BASE_TYPE, VEC_SIZE)\n"
"#define TYPE VEC_TYPE\n"
"#define SCALAR_TYPE CAT(FPTYPE, VEC_SIZE)\n"
"#define INTERMEDIATE_TYPE CAT(FPTYPE, VEC_SIZE)\n"
"struct RectCoords\n"
"{\n"
"int x1, y1, x2, y2;\n"
"};\n"
"#ifdef DEBUG\n"
"#define DEBUG_ONLY(x) x\n"
"#define ASSERT(condition) do { if (!(condition)) { printf(\"BUG in boxFilter kernel (global=%d,%d): \" #condition \"\\n\", get_global_id(0), get_global_id(1)); } } while (0)\n"
"#else\n"
"#define DEBUG_ONLY(x)\n"
"#define ASSERT(condition)\n"
"#endif\n"
"INTERMEDIATE_TYPE readSrcPixel(int2 pos, __global TYPE *src, const unsigned int srcStepBytes, const struct RectCoords srcCoords\n"
"#ifdef BORDER_CONSTANT\n"
", SCALAR_TYPE borderValue\n"
"#endif\n"
")\n"
"{\n"
"#ifdef BORDER_ISOLATED\n"
"if(pos.x >= srcCoords.x1 && pos.y >= srcCoords.y1 && pos.x < srcCoords.x2 && pos.y < srcCoords.y2)\n"
"#else\n"
"if(pos.x >= 0 && pos.y >= 0 && pos.x < srcCoords.x2 && pos.y < srcCoords.y2)\n"
"#endif\n"
"{\n"
"__global TYPE* ptr = (__global TYPE*)((__global char*)src + pos.x * sizeof(TYPE) + pos.y * srcStepBytes);\n"
"return CONVERT_TO_FPTYPE(*ptr);\n"
"}\n"
"else\n"
"{\n"
"#ifdef BORDER_CONSTANT\n"
"return borderValue;\n"
"#else\n"
"int selected_col = pos.x;\n"
"int selected_row = pos.y;\n"
"EXTRAPOLATE(selected_col, selected_row,\n"
"#ifdef BORDER_ISOLATED\n"
"srcCoords.x1, srcCoords.y1,\n"
"#else\n"
"0, 0,\n"
"#endif\n"
"srcCoords.x2, srcCoords.y2\n"
");\n"
"pos = (int2)(selected_col, selected_row);\n"
"if(pos.x >= 0 && pos.y >= 0 && pos.x < srcCoords.x2 && pos.y < srcCoords.y2)\n"
"{\n"
"__global TYPE* ptr = (__global TYPE*)((__global char*)src + pos.x * sizeof(TYPE) + pos.y * srcStepBytes);\n"
"return CONVERT_TO_FPTYPE(*ptr);\n"
"}\n"
"else\n"
"{\n"
"DEBUG_ONLY(printf(\"BUG in boxFilter kernel\\n\"));\n"
"return (FPTYPE)(0.0f);\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"__kernel\n"
"__attribute__((reqd_work_group_size(LOCAL_SIZE, 1, 1)))\n"
"void boxFilter(__global TYPE *src, const unsigned int srcStepBytes, const int4 srcRC,\n"
"__global TYPE *dst, const unsigned int dstStepBytes, const int4 dstRC,\n"
"#ifdef BORDER_CONSTANT\n"
"SCALAR_TYPE borderValue,\n"
"#endif\n"
"FPTYPE alpha\n"
")\n"
"{\n"
"const struct RectCoords srcCoords = {srcRC.s0, srcRC.s1, srcRC.s2, srcRC.s3};\n"
"const struct RectCoords dstCoords = {dstRC.s0, dstRC.s1, dstRC.s2, dstRC.s3};\n"
"const int x = get_local_id(0) + (LOCAL_SIZE - (KERNEL_SIZE_X - 1)) * get_group_id(0) - ANCHOR_X;\n"
"const int y = get_global_id(1) * BLOCK_SIZE_Y;\n"
"const int local_id = get_local_id(0);\n"
"INTERMEDIATE_TYPE data[KERNEL_SIZE_Y];\n"
"__local INTERMEDIATE_TYPE sumOfCols[LOCAL_SIZE];\n"
"int2 srcPos = (int2)(srcCoords.x1 + x, srcCoords.y1 + y - ANCHOR_Y);\n"
"for(int sy = 0; sy < KERNEL_SIZE_Y; sy++, srcPos.y++)\n"
"{\n"
"data[sy] = readSrcPixel(srcPos, src, srcStepBytes, srcCoords\n"
"#ifdef BORDER_CONSTANT\n"
", borderValue\n"
"#endif\n"
");\n"
"}\n"
"INTERMEDIATE_TYPE tmp_sum = 0;\n"
"for(int sy = 0; sy < KERNEL_SIZE_Y; sy++)\n"
"{\n"
"tmp_sum += (data[sy]);\n"
"}\n"
"sumOfCols[local_id] = tmp_sum;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int2 pos = (int2)(dstCoords.x1 + x, dstCoords.y1 + y);\n"
"__global TYPE* dstPtr = (__global TYPE*)((__global char*)dst + pos.x * sizeof(TYPE) + pos.y * dstStepBytes);\n"
"int sy_index = 0;\n"
"int stepsY = min(dstCoords.y2 - pos.y, BLOCK_SIZE_Y);\n"
"ASSERT(stepsY > 0);\n"
"for (; ;)\n"
"{\n"
"ASSERT(pos.y < dstCoords.y2);\n"
"if(local_id >= ANCHOR_X && local_id < LOCAL_SIZE - (KERNEL_SIZE_X - 1 - ANCHOR_X) &&\n"
"pos.x >= dstCoords.x1 && pos.x < dstCoords.x2)\n"
"{\n"
"ASSERT(pos.y >= dstCoords.y1 && pos.y < dstCoords.y2);\n"
"INTERMEDIATE_TYPE total_sum = 0;\n"
"#pragma unroll\n"
"for (int sx = 0; sx < KERNEL_SIZE_X; sx++)\n"
"{\n"
"total_sum += sumOfCols[local_id + sx - ANCHOR_X];\n"
"}\n"
"*dstPtr = CONVERT_TO_TYPE(((INTERMEDIATE_TYPE)alpha) * total_sum);\n"
"}\n"
"#if BLOCK_SIZE_Y == 1\n"
"break;\n"
"#else\n"
"if (--stepsY == 0)\n"
"break;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"tmp_sum = sumOfCols[local_id];\n"
"tmp_sum -= data[sy_index];\n"
"data[sy_index] = readSrcPixel(srcPos, src, srcStepBytes, srcCoords\n"
"#ifdef BORDER_CONSTANT\n"
", borderValue\n"
"#endif\n"
");\n"
"srcPos.y++;\n"
"tmp_sum += data[sy_index];\n"
"sumOfCols[local_id] = tmp_sum;\n"
"sy_index = (sy_index + 1 < KERNEL_SIZE_Y) ? sy_index + 1 : 0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"DEBUG_ONLY(pos.y++);\n"
"dstPtr = (__global TYPE*)((__global char*)dstPtr + dstStepBytes);\n"
"#endif\n"
"}\n"
"}\n"
, "4886fb0eca8474fbd9c13bc03089baf2"};
const struct ProgramEntry filtering_filter2D={"filtering_filter2D",
"#ifdef BORDER_REPLICATE\n"
"#define ADDR_L(i, l_edge, r_edge)  ((i) <  (l_edge) ? (l_edge)   : (i))\n"
"#define ADDR_R(i, r_edge, addr)    ((i) >= (r_edge) ? (r_edge)-1 : (addr))\n"
"#define ADDR_H(i, t_edge, b_edge)  ((i) <  (t_edge) ? (t_edge)   :(i))\n"
"#define ADDR_B(i, b_edge, addr)    ((i) >= (b_edge) ? (b_edge)-1 :(addr))\n"
"#endif\n"
"#ifdef BORDER_REFLECT\n"
"#define ADDR_L(i, l_edge, r_edge)  ((i) <  (l_edge) ? -(i)-1               : (i))\n"
"#define ADDR_R(i, r_edge, addr)    ((i) >= (r_edge) ? -(i)-1+((r_edge)<<1) : (addr))\n"
"#define ADDR_H(i, t_edge, b_edge)  ((i) <  (t_edge) ? -(i)-1 : (i))\n"
"#define ADDR_B(i, b_edge, addr)    ((i) >= (b_edge) ? -(i)-1+((b_edge)<<1) : (addr))\n"
"#endif\n"
"#ifdef BORDER_REFLECT_101\n"
"#define ADDR_L(i, l_edge, r_edge)  ((i) <  (l_edge) ? -(i)                 : (i))\n"
"#define ADDR_R(i, r_edge, addr)    ((i) >= (r_edge) ? -(i)-2+((r_edge)<<1) : (addr))\n"
"#define ADDR_H(i, t_edge, b_edge)  ((i) <  (t_edge) ? -(i)                 : (i))\n"
"#define ADDR_B(i, b_edge, addr)    ((i) >= (b_edge) ? -(i)-2+((b_edge)<<1) : (addr))\n"
"#endif\n"
"#ifdef BORDER_WRAP\n"
"#define ADDR_L(i, l_edge, r_edge)  ((i) <  (l_edge) ? (i)+(r_edge) : (i))\n"
"#define ADDR_R(i, r_edge, addr)    ((i) >= (r_edge) ? (i)-(r_edge) : (addr))\n"
"#define ADDR_H(i, t_edge, b_edge)  ((i) <  (t_edge) ? (i)+(b_edge) : (i))\n"
"#define ADDR_B(i, b_edge, addr)    ((i) >= (b_edge) ? (i)-(b_edge) : (addr))\n"
"#endif\n"
"#ifdef EXTRA_EXTRAPOLATION\n"
"#ifdef BORDER_CONSTANT\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) \\\n"
"{ \\\n"
"x = max(min(x, maxX - 1), minX); \\\n"
"y = max(min(y, maxY - 1), minY); \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) \\\n"
"{ \\\n"
"if (x < minX) \\\n"
"x -= ((x - maxX + 1) / maxX) * maxX; \\\n"
"if (x >= maxX) \\\n"
"x %= maxX; \\\n"
"if (y < minY) \\\n"
"y -= ((y - maxY + 1) / maxY) * maxY; \\\n"
"if (y >= maxY) \\\n"
"y %= maxY; \\\n"
"}\n"
"#elif defined(BORDER_REFLECT) || defined(BORDER_REFLECT_101)\n"
"#define EXTRAPOLATE_(x, y, minX, minY, maxX, maxY, delta) \\\n"
"{ \\\n"
"if (maxX - minX == 1) \\\n"
"x = minX; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if (x < minX) \\\n"
"x = -(x - minX) - 1 + delta; \\\n"
"else \\\n"
"x = maxX - 1 - (x - maxX) - delta; \\\n"
"} \\\n"
"while (x >= maxX || x < minX); \\\n"
"\\\n"
"if (maxY - minY == 1) \\\n"
"y = minY; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if (y < minY) \\\n"
"y = -(y - minY) - 1 + delta; \\\n"
"else \\\n"
"y = maxY - 1 - (y - maxY) - delta; \\\n"
"} \\\n"
"while (y >= maxY || y < minY); \\\n"
"}\n"
"#ifdef BORDER_REFLECT\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) EXTRAPOLATE_(x, y, minX, minY, maxX, maxY, 0)\n"
"#elif defined(BORDER_REFLECT_101)\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) EXTRAPOLATE_(x, y, minX, minY, maxX, maxY, 1)\n"
"#endif\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"#else\n"
"#define EXTRAPOLATE(x, y, minX, minY, maxX, maxY) \\\n"
"{ \\\n"
"int _row = y - minY, _col = x - minX; \\\n"
"_row = ADDR_H(_row, 0, maxY - minY); \\\n"
"_row = ADDR_B(_row, maxY - minY, _row); \\\n"
"y = _row + minY; \\\n"
"\\\n"
"_col = ADDR_L(_col, 0, maxX - minX); \\\n"
"_col = ADDR_R(_col, maxX - minX, _col); \\\n"
"x = _col + minX; \\\n"
"}\n"
"#endif\n"
"#if USE_DOUBLE\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define FPTYPE double\n"
"#define CONVERT_TO_FPTYPE CAT(convert_double, VEC_SIZE)\n"
"#else\n"
"#define FPTYPE float\n"
"#define CONVERT_TO_FPTYPE CAT(convert_float, VEC_SIZE)\n"
"#endif\n"
"#if DATA_DEPTH == 0\n"
"#define BASE_TYPE uchar\n"
"#elif DATA_DEPTH == 1\n"
"#define BASE_TYPE char\n"
"#elif DATA_DEPTH == 2\n"
"#define BASE_TYPE ushort\n"
"#elif DATA_DEPTH == 3\n"
"#define BASE_TYPE short\n"
"#elif DATA_DEPTH == 4\n"
"#define BASE_TYPE int\n"
"#elif DATA_DEPTH == 5\n"
"#define BASE_TYPE float\n"
"#elif DATA_DEPTH == 6\n"
"#define BASE_TYPE double\n"
"#else\n"
"#error data_depth\n"
"#endif\n"
"#define __CAT(x, y) x##y\n"
"#define CAT(x, y) __CAT(x, y)\n"
"#define uchar1 uchar\n"
"#define char1 char\n"
"#define ushort1 ushort\n"
"#define short1 short\n"
"#define int1 int\n"
"#define float1 float\n"
"#define double1 double\n"
"#define convert_uchar1_sat_rte convert_uchar_sat_rte\n"
"#define convert_char1_sat_rte convert_char_sat_rte\n"
"#define convert_ushort1_sat_rte convert_ushort_sat_rte\n"
"#define convert_short1_sat_rte convert_short_sat_rte\n"
"#define convert_int1_sat_rte convert_int_sat_rte\n"
"#define convert_float1\n"
"#define convert_double1\n"
"#if DATA_DEPTH == 5 || DATA_DEPTH == 6\n"
"#define CONVERT_TO_TYPE CAT(CAT(convert_, BASE_TYPE), VEC_SIZE)\n"
"#else\n"
"#define CONVERT_TO_TYPE CAT(CAT(CAT(convert_, BASE_TYPE), VEC_SIZE), _sat_rte)\n"
"#endif\n"
"#define VEC_SIZE DATA_CHAN\n"
"#define VEC_TYPE CAT(BASE_TYPE, VEC_SIZE)\n"
"#define TYPE VEC_TYPE\n"
"#define SCALAR_TYPE CAT(FPTYPE, VEC_SIZE)\n"
"#define INTERMEDIATE_TYPE CAT(FPTYPE, VEC_SIZE)\n"
"struct RectCoords\n"
"{\n"
"int x1, y1, x2, y2;\n"
"};\n"
"#ifdef DEBUG\n"
"#define DEBUG_ONLY(x) x\n"
"#define ASSERT(condition) do { if (!(condition)) { printf(\"BUG in boxFilter kernel (global=%d,%d): \" #condition \"\\n\", get_global_id(0), get_global_id(1)); } } while (0)\n"
"#else\n"
"#define DEBUG_ONLY(x) (void)0\n"
"#define ASSERT(condition) (void)0\n"
"#endif\n"
"INTERMEDIATE_TYPE readSrcPixel(int2 pos, __global TYPE *src, const unsigned int srcStepBytes, const struct RectCoords srcCoords\n"
"#ifdef BORDER_CONSTANT\n"
", SCALAR_TYPE borderValue\n"
"#endif\n"
")\n"
"{\n"
"#ifdef BORDER_ISOLATED\n"
"if(pos.x >= srcCoords.x1 && pos.y >= srcCoords.y1 && pos.x < srcCoords.x2 && pos.y < srcCoords.y2)\n"
"#else\n"
"if(pos.x >= 0 && pos.y >= 0 && pos.x < srcCoords.x2 && pos.y < srcCoords.y2)\n"
"#endif\n"
"{\n"
"__global TYPE* ptr = (__global TYPE*)((__global char*)src + pos.x * sizeof(TYPE) + pos.y * srcStepBytes);\n"
"return CONVERT_TO_FPTYPE(*ptr);\n"
"}\n"
"else\n"
"{\n"
"#ifdef BORDER_CONSTANT\n"
"return borderValue;\n"
"#else\n"
"int selected_col = pos.x;\n"
"int selected_row = pos.y;\n"
"EXTRAPOLATE(selected_col, selected_row,\n"
"#ifdef BORDER_ISOLATED\n"
"srcCoords.x1, srcCoords.y1,\n"
"#else\n"
"0, 0,\n"
"#endif\n"
"srcCoords.x2, srcCoords.y2\n"
");\n"
"pos = (int2)(selected_col, selected_row);\n"
"if(pos.x >= 0 && pos.y >= 0 && pos.x < srcCoords.x2 && pos.y < srcCoords.y2)\n"
"{\n"
"__global TYPE* ptr = (__global TYPE*)((__global char*)src + pos.x * sizeof(TYPE) + pos.y * srcStepBytes);\n"
"return CONVERT_TO_FPTYPE(*ptr);\n"
"}\n"
"else\n"
"{\n"
"DEBUG_ONLY(printf(\"BUG in boxFilter kernel\\n\"));\n"
"return (FPTYPE)(0.0f);\n"
"}\n"
"#endif\n"
"}\n"
"}\n"
"__kernel\n"
"__attribute__((reqd_work_group_size(LOCAL_SIZE, 1, 1)))\n"
"void filter2D(__global TYPE *src, const unsigned int srcStepBytes, const int4 srcRC,\n"
"__global TYPE *dst, const unsigned int dstStepBytes, const int4 dstRC,\n"
"#ifdef BORDER_CONSTANT\n"
"SCALAR_TYPE borderValue,\n"
"#endif\n"
"__constant FPTYPE* kernelData\n"
")\n"
"{\n"
"const struct RectCoords srcCoords = {srcRC.s0, srcRC.s1, srcRC.s2, srcRC.s3};\n"
"struct RectCoords dstCoords = {dstRC.s0, dstRC.s1, dstRC.s2, dstRC.s3};\n"
"const int local_id = get_local_id(0);\n"
"const int x = local_id + (LOCAL_SIZE - (KERNEL_SIZE_X - 1)) * get_group_id(0) - ANCHOR_X;\n"
"const int y = get_global_id(1) * BLOCK_SIZE_Y;\n"
"INTERMEDIATE_TYPE data[KERNEL_SIZE_Y];\n"
"__local INTERMEDIATE_TYPE sumOfCols[LOCAL_SIZE];\n"
"int2 srcPos = (int2)(srcCoords.x1 + x, srcCoords.y1 + y - ANCHOR_Y);\n"
"int2 pos = (int2)(dstCoords.x1 + x, dstCoords.y1 + y);\n"
"__global TYPE* dstPtr = (__global TYPE*)((__global char*)dst + pos.x * sizeof(TYPE) + pos.y * dstStepBytes);\n"
"bool writeResult = (local_id >= ANCHOR_X && local_id < LOCAL_SIZE - (KERNEL_SIZE_X - 1 - ANCHOR_X) &&\n"
"pos.x >= dstCoords.x1 && pos.x < dstCoords.x2);\n"
"#if BLOCK_SIZE_Y > 1\n"
"bool readAllpixels = true;\n"
"int sy_index = 0;\n"
"dstCoords.y2 = min(dstCoords.y2, pos.y + BLOCK_SIZE_Y);\n"
"for (;\n"
"pos.y < dstCoords.y2;\n"
"pos.y++,\n"
"dstPtr = (__global TYPE*)((__global char*)dstPtr + dstStepBytes))\n"
"#endif\n"
"{\n"
"ASSERT(pos.y < dstCoords.y2);\n"
"for (\n"
"#if BLOCK_SIZE_Y > 1\n"
"int sy = readAllpixels ? 0 : -1; sy < (readAllpixels ? KERNEL_SIZE_Y : 0);\n"
"#else\n"
"int sy = 0, sy_index = 0; sy < KERNEL_SIZE_Y;\n"
"#endif\n"
"sy++, srcPos.y++)\n"
"{\n"
"data[sy + sy_index] = readSrcPixel(srcPos, src, srcStepBytes, srcCoords\n"
"#ifdef BORDER_CONSTANT\n"
", borderValue\n"
"#endif\n"
");\n"
"}\n"
"INTERMEDIATE_TYPE total_sum = 0;\n"
"for (int sx = 0; sx < KERNEL_SIZE_X; sx++)\n"
"{\n"
"{\n"
"__constant FPTYPE* k = &kernelData[KERNEL_SIZE_Y2_ALIGNED * sx\n"
"#if BLOCK_SIZE_Y > 1\n"
"+ KERNEL_SIZE_Y - sy_index\n"
"#endif\n"
"];\n"
"INTERMEDIATE_TYPE tmp_sum = 0;\n"
"for (int sy = 0; sy < KERNEL_SIZE_Y; sy++)\n"
"{\n"
"tmp_sum += data[sy] * k[sy];\n"
"}\n"
"sumOfCols[local_id] = tmp_sum;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"int id = local_id + sx - ANCHOR_X;\n"
"if (id >= 0 && id < LOCAL_SIZE)\n"
"total_sum += sumOfCols[id];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"if (writeResult)\n"
"{\n"
"ASSERT(pos.y >= dstCoords.y1 && pos.y < dstCoords.y2);\n"
"*dstPtr = CONVERT_TO_TYPE(total_sum);\n"
"}\n"
"#if BLOCK_SIZE_Y > 1\n"
"readAllpixels = false;\n"
"#if BLOCK_SIZE_Y > KERNEL_SIZE_Y\n"
"sy_index = (sy_index + 1 <= KERNEL_SIZE_Y) ? sy_index + 1 : 1;\n"
"#else\n"
"sy_index++;\n"
"#endif\n"
"#endif\n"
"}\n"
"}\n"
, "ca32031fbf7bad598b8468e60df95be6"};
const struct ProgramEntry filtering_morph={"filtering_morph",
"#ifdef ERODE\n"
"#define MORPH_OP(A,B) min((A),(B))\n"
"#endif\n"
"#ifdef DILATE\n"
"#define MORPH_OP(A,B) max((A),(B))\n"
"#endif\n"
"#define ELEM(i,l_edge,r_edge,elem1,elem2) (i)<(l_edge) | (i) >= (r_edge) ? (elem1) : (elem2)\n"
"#ifndef GENTYPE\n"
"__kernel void morph_C1_D0(__global const uchar * restrict src,\n"
"__global uchar *dst,\n"
"int src_offset_x, int src_offset_y,\n"
"int cols, int rows,\n"
"int src_step_in_pixel, int dst_step_in_pixel,\n"
"__constant uchar * mat_kernel,\n"
"int src_whole_cols, int src_whole_rows,\n"
"int dst_offset_in_pixel)\n"
"{\n"
"int l_x = get_local_id(0);\n"
"int l_y = get_local_id(1);\n"
"int x = get_group_id(0)*4*LSIZE0;\n"
"int y = get_group_id(1)*LSIZE1;\n"
"int start_x = x+src_offset_x-RADIUSX & 0xfffffffc;\n"
"int end_x = x + src_offset_x+LSIZE0*4+RADIUSX & 0xfffffffc;\n"
"int width = (end_x -start_x+4)>>2;\n"
"int offset = src_offset_x-RADIUSX & 3;\n"
"int start_y = y+src_offset_y-RADIUSY;\n"
"int point1 = mad24(l_y,LSIZE0,l_x);\n"
"int point2 = point1 + LSIZE0*LSIZE1;\n"
"int tl_x = (point1 % width)<<2;\n"
"int tl_y = point1 / width;\n"
"int tl_x2 = (point2 % width)<<2;\n"
"int tl_y2 = point2 / width;\n"
"int cur_x = start_x + tl_x;\n"
"int cur_y = start_y + tl_y;\n"
"int cur_x2 = start_x + tl_x2;\n"
"int cur_y2 = start_y + tl_y2;\n"
"int start_addr = mad24(cur_y,src_step_in_pixel,cur_x);\n"
"int start_addr2 = mad24(cur_y2,src_step_in_pixel,cur_x2);\n"
"uchar4 temp0,temp1;\n"
"__local uchar4 LDS_DAT[2*LSIZE1*LSIZE0];\n"
"int end_addr = mad24(src_whole_rows - 1,src_step_in_pixel,src_whole_cols);\n"
"start_addr = ((start_addr < end_addr) && (start_addr > 0)) ? start_addr : 0;\n"
"start_addr2 = ((start_addr2 < end_addr) && (start_addr2 > 0)) ? start_addr2 : 0;\n"
"temp0 = *(__global uchar4*)&src[start_addr];\n"
"temp1 = *(__global uchar4*)&src[start_addr2];\n"
"temp0.x= ELEM(cur_x,0,src_whole_cols,VAL,temp0.x);\n"
"temp0.y= ELEM(cur_x+1,0,src_whole_cols,VAL,temp0.y);\n"
"temp0.z= ELEM(cur_x+2,0,src_whole_cols,VAL,temp0.z);\n"
"temp0.w= ELEM(cur_x+3,0,src_whole_cols,VAL,temp0.w);\n"
"temp0= ELEM(cur_y,0,src_whole_rows,(uchar4)VAL,temp0);\n"
"temp1.x= ELEM(cur_x2,0,src_whole_cols,VAL,temp1.x);\n"
"temp1.y= ELEM(cur_x2+1,0,src_whole_cols,VAL,temp1.y);\n"
"temp1.z= ELEM(cur_x2+2,0,src_whole_cols,VAL,temp1.z);\n"
"temp1.w= ELEM(cur_x2+3,0,src_whole_cols,VAL,temp1.w);\n"
"temp1= ELEM(cur_y2,0,src_whole_rows,(uchar4)VAL,temp1);\n"
"LDS_DAT[point1] = temp0;\n"
"LDS_DAT[point2] = temp1;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"uchar4 res = (uchar4)VAL;\n"
"for(int i=0; i<2*RADIUSY+1; i++)\n"
"for(int j=0; j<2*RADIUSX+1; j++)\n"
"{\n"
"res =\n"
"#ifndef RECTKERNEL\n"
"mat_kernel[i*(2*RADIUSX+1)+j] ?\n"
"#endif\n"
"MORPH_OP(res,vload4(0,(__local uchar*)&LDS_DAT[mad24((l_y+i),width,l_x)]+offset+j))\n"
"#ifndef RECTKERNEL\n"
":res\n"
"#endif\n"
";\n"
"}\n"
"int gidx = get_global_id(0)<<2;\n"
"int gidy = get_global_id(1);\n"
"int out_addr = mad24(gidy,dst_step_in_pixel,gidx+dst_offset_in_pixel);\n"
"if(gidx+3<cols && gidy<rows && ((dst_offset_in_pixel&3)==0))\n"
"{\n"
"*(__global uchar4*)&dst[out_addr] = res;\n"
"}\n"
"else\n"
"{\n"
"if(gidx+3<cols && gidy<rows)\n"
"{\n"
"dst[out_addr] = res.x;\n"
"dst[out_addr+1] = res.y;\n"
"dst[out_addr+2] = res.z;\n"
"dst[out_addr+3] = res.w;\n"
"}\n"
"else if(gidx+2<cols && gidy<rows)\n"
"{\n"
"dst[out_addr] = res.x;\n"
"dst[out_addr+1] = res.y;\n"
"dst[out_addr+2] = res.z;\n"
"}\n"
"else if(gidx+1<cols && gidy<rows)\n"
"{\n"
"dst[out_addr] = res.x;\n"
"dst[out_addr+1] = res.y;\n"
"}\n"
"else if(gidx<cols && gidy<rows)\n"
"{\n"
"dst[out_addr] = res.x;\n"
"}\n"
"}\n"
"}\n"
"#else\n"
"__kernel void morph(__global const GENTYPE * restrict src,\n"
"__global GENTYPE *dst,\n"
"int src_offset_x, int src_offset_y,\n"
"int cols, int rows,\n"
"int src_step_in_pixel, int dst_step_in_pixel,\n"
"__constant uchar * mat_kernel,\n"
"int src_whole_cols, int src_whole_rows,\n"
"int dst_offset_in_pixel)\n"
"{\n"
"int l_x = get_local_id(0);\n"
"int l_y = get_local_id(1);\n"
"int x = get_group_id(0)*LSIZE0;\n"
"int y = get_group_id(1)*LSIZE1;\n"
"int start_x = x+src_offset_x-RADIUSX;\n"
"int end_x = x + src_offset_x+LSIZE0+RADIUSX;\n"
"int width = end_x -(x+src_offset_x-RADIUSX)+1;\n"
"int start_y = y+src_offset_y-RADIUSY;\n"
"int point1 = mad24(l_y,LSIZE0,l_x);\n"
"int point2 = point1 + LSIZE0*LSIZE1;\n"
"int tl_x = point1 % width;\n"
"int tl_y = point1 / width;\n"
"int tl_x2 = point2 % width;\n"
"int tl_y2 = point2 / width;\n"
"int cur_x = start_x + tl_x;\n"
"int cur_y = start_y + tl_y;\n"
"int cur_x2 = start_x + tl_x2;\n"
"int cur_y2 = start_y + tl_y2;\n"
"int start_addr = mad24(cur_y,src_step_in_pixel,cur_x);\n"
"int start_addr2 = mad24(cur_y2,src_step_in_pixel,cur_x2);\n"
"GENTYPE temp0,temp1;\n"
"__local GENTYPE LDS_DAT[2*LSIZE1*LSIZE0];\n"
"int end_addr = mad24(src_whole_rows - 1,src_step_in_pixel,src_whole_cols);\n"
"start_addr = ((start_addr < end_addr) && (start_addr > 0)) ? start_addr : 0;\n"
"start_addr2 = ((start_addr2 < end_addr) && (start_addr2 > 0)) ? start_addr2 : 0;\n"
"temp0 = src[start_addr];\n"
"temp1 = src[start_addr2];\n"
"temp0= ELEM(cur_x,0,src_whole_cols,(GENTYPE)VAL,temp0);\n"
"temp0= ELEM(cur_y,0,src_whole_rows,(GENTYPE)VAL,temp0);\n"
"temp1= ELEM(cur_x2,0,src_whole_cols,(GENTYPE)VAL,temp1);\n"
"temp1= ELEM(cur_y2,0,src_whole_rows,(GENTYPE)VAL,temp1);\n"
"LDS_DAT[point1] = temp0;\n"
"LDS_DAT[point2] = temp1;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"GENTYPE res = (GENTYPE)VAL;\n"
"for(int i=0; i<2*RADIUSY+1; i++)\n"
"for(int j=0; j<2*RADIUSX+1; j++)\n"
"{\n"
"res =\n"
"#ifndef RECTKERNEL\n"
"mat_kernel[i*(2*RADIUSX+1)+j] ?\n"
"#endif\n"
"MORPH_OP(res,LDS_DAT[mad24(l_y+i,width,l_x+j)])\n"
"#ifndef RECTKERNEL\n"
":res\n"
"#endif\n"
";\n"
"}\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int out_addr = mad24(gidy,dst_step_in_pixel,gidx+dst_offset_in_pixel);\n"
"if(gidx<cols && gidy<rows)\n"
"{\n"
"dst[out_addr] = res;\n"
"}\n"
"}\n"
"#endif\n"
, "01cdf6da352386c7aab3e65cfb1f7e39"};
const struct ProgramEntry filtering_sep_filter_singlepass={"filtering_sep_filter_singlepass",
"#ifdef BORDER_CONSTANT\n"
"#define EXTRAPOLATE(x, maxV)\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"(x) = max(min((x), (maxV) - 1), 0); \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"(x) = ( (x) + (maxV) ) % (maxV); \\\n"
"}\n"
"#elif defined BORDER_REFLECT\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"(x) = min(((maxV)-1)*2-(x)+1, max((x),-(x)-1) ); \\\n"
"}\n"
"#elif defined BORDER_REFLECT_101\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"(x) = min(((maxV)-1)*2-(x), max((x),-(x)) ); \\\n"
"}\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"#define SRC(_x,_y) CONVERT_SRCTYPE(((global SRCTYPE*)(Src+(_y)*SrcPitch))[_x])\n"
"#ifdef BORDER_CONSTANT\n"
"#define ELEM(_x,_y,r_edge,t_edge,const_v) (_x)<0 | (_x) >= (r_edge) | (_y)<0 | (_y) >= (t_edge) ? (const_v) : SRC((_x),(_y))\n"
"#else\n"
"#define ELEM(_x,_y,r_edge,t_edge,const_v) SRC((_x),(_y))\n"
"#endif\n"
"#define DST(_x,_y) (((global DSTTYPE*)(Dst+DstOffset+(_y)*DstPitch))[_x])\n"
"#define DIG(a) a,\n"
"__constant uint mat_kernelX[] = {KERNEL_MATRIX_X};\n"
"__constant uint mat_kernelY[] = {KERNEL_MATRIX_Y};\n"
"__kernel __attribute__((reqd_work_group_size(BLK_X,BLK_Y,1))) void sep_filter_singlepass\n"
"(\n"
"__global uchar* Src,\n"
"const uint      SrcPitch,\n"
"const int       srcOffsetX,\n"
"const int       srcOffsetY,\n"
"__global uchar* Dst,\n"
"const int       DstOffset,\n"
"const uint      DstPitch,\n"
"int             width,\n"
"int             height,\n"
"int             dstWidth,\n"
"int             dstHeight\n"
")\n"
"{\n"
"__local WORKTYPE lsmem[BLK_Y+2*RADIUSY][BLK_X+2*RADIUSX];\n"
"__local WORKTYPE lsmemDy[BLK_Y][BLK_X+2*RADIUSX];\n"
"int lix = get_local_id(0);\n"
"int liy = get_local_id(1);\n"
"int x = (int)get_global_id(0);\n"
"int y = (int)get_global_id(1);\n"
"int srcX = x + srcOffsetX - RADIUSX;\n"
"int srcY = y + srcOffsetY - RADIUSY;\n"
"int xb = srcX;\n"
"int yb = srcY;\n"
"int clocY = liy;\n"
"int cSrcY = srcY;\n"
"do\n"
"{\n"
"int yb = cSrcY;\n"
"EXTRAPOLATE(yb, (height));\n"
"int clocX = lix;\n"
"int cSrcX = srcX;\n"
"do\n"
"{\n"
"int xb = cSrcX;\n"
"EXTRAPOLATE(xb,(width));\n"
"lsmem[clocY][clocX] = ELEM(xb, yb, (width), (height), 0 );\n"
"clocX += BLK_X;\n"
"cSrcX += BLK_X;\n"
"}\n"
"while(clocX < BLK_X+(RADIUSX*2));\n"
"clocY += BLK_Y;\n"
"cSrcY += BLK_Y;\n"
"}\n"
"while(clocY < BLK_Y+(RADIUSY*2));\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int i;\n"
"WORKTYPE sum = 0.0f;\n"
"int clocX = lix;\n"
"do\n"
"{\n"
"sum = 0.0f;\n"
"for(i=0; i<=2*RADIUSY; i++)\n"
"sum = mad(lsmem[liy+i][clocX], as_float(mat_kernelY[i]), sum);\n"
"lsmemDy[liy][clocX] = sum;\n"
"clocX += BLK_X;\n"
"}\n"
"while(clocX < BLK_X+(RADIUSX*2));\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if( x >= dstWidth || y >=dstHeight )  return;\n"
"sum = 0.0f;\n"
"for(i=0; i<=2*RADIUSX; i++)\n"
"sum = mad(lsmemDy[liy][lix+i], as_float(mat_kernelX[i]), sum);\n"
"DST(x,y) = CONVERT_DSTTYPE(sum);\n"
"}\n"
, "f48a37bd2a76b2d14666ef7fc1f6d88e"};
const struct ProgramEntry haarobjectdetect={"haarobjectdetect",
"#define CV_HAAR_FEATURE_MAX           3\n"
"#define calc_sum(rect,offset)        (sum[(rect).p0+offset] - sum[(rect).p1+offset] - sum[(rect).p2+offset] + sum[(rect).p3+offset])\n"
"#define calc_sum1(rect,offset,i)     (sum[(rect).p0[i]+offset] - sum[(rect).p1[i]+offset] - sum[(rect).p2[i]+offset] + sum[(rect).p3[i]+offset])\n"
"typedef int   sumtype;\n"
"typedef float sqsumtype;\n"
"#ifndef STUMP_BASED\n"
"#define STUMP_BASED 1\n"
"#endif\n"
"typedef struct __attribute__((aligned (128) )) GpuHidHaarTreeNode\n"
"{\n"
"int p[CV_HAAR_FEATURE_MAX][4] __attribute__((aligned (64)));\n"
"float weight[CV_HAAR_FEATURE_MAX];\n"
"float threshold;\n"
"float alpha[3] __attribute__((aligned (16)));\n"
"int left __attribute__((aligned (4)));\n"
"int right __attribute__((aligned (4)));\n"
"}\n"
"GpuHidHaarTreeNode;\n"
"typedef struct __attribute__((aligned (32))) GpuHidHaarClassifier\n"
"{\n"
"int count __attribute__((aligned (4)));\n"
"GpuHidHaarTreeNode* node __attribute__((aligned (8)));\n"
"float* alpha __attribute__((aligned (8)));\n"
"}\n"
"GpuHidHaarClassifier;\n"
"typedef struct __attribute__((aligned (64))) GpuHidHaarStageClassifier\n"
"{\n"
"int  count __attribute__((aligned (4)));\n"
"float threshold __attribute__((aligned (4)));\n"
"int two_rects __attribute__((aligned (4)));\n"
"int reserved0 __attribute__((aligned (8)));\n"
"int reserved1 __attribute__((aligned (8)));\n"
"int reserved2 __attribute__((aligned (8)));\n"
"int reserved3 __attribute__((aligned (8)));\n"
"}\n"
"GpuHidHaarStageClassifier;\n"
"typedef struct __attribute__((aligned (64))) GpuHidHaarClassifierCascade\n"
"{\n"
"int  count __attribute__((aligned (4)));\n"
"int  is_stump_based __attribute__((aligned (4)));\n"
"int  has_tilted_features __attribute__((aligned (4)));\n"
"int  is_tree __attribute__((aligned (4)));\n"
"int pq0 __attribute__((aligned (4)));\n"
"int pq1 __attribute__((aligned (4)));\n"
"int pq2 __attribute__((aligned (4)));\n"
"int pq3 __attribute__((aligned (4)));\n"
"int p0 __attribute__((aligned (4)));\n"
"int p1 __attribute__((aligned (4)));\n"
"int p2 __attribute__((aligned (4)));\n"
"int p3 __attribute__((aligned (4)));\n"
"float inv_window_area __attribute__((aligned (4)));\n"
"} GpuHidHaarClassifierCascade;\n"
"#ifdef PACKED_CLASSIFIER\n"
"__kernel void gpuRunHaarClassifierCascadePacked(\n"
"global const GpuHidHaarStageClassifier * stagecascadeptr,\n"
"global const int4 * info,\n"
"global const GpuHidHaarTreeNode * nodeptr,\n"
"global const int * restrict sum,\n"
"global const float * restrict sqsum,\n"
"volatile global int4 * candidate,\n"
"const int pixelstep,\n"
"const int loopcount,\n"
"const int start_stage,\n"
"const int split_stage,\n"
"const int end_stage,\n"
"const int startnode,\n"
"const int splitnode,\n"
"const int4 p,\n"
"const int4 pq,\n"
"const float correction,\n"
"global const int* pNodesPK,\n"
"global const int4* pWGInfo\n"
")\n"
"{\n"
"int     gid = (int)get_group_id(0);\n"
"int     lid_x = (int)get_local_id(0);\n"
"int     lid_y = (int)get_local_id(1);\n"
"int     lid = lid_y*LSx+lid_x;\n"
"int4    WGInfo = pWGInfo[WGSTART+gid];\n"
"int     GroupX = (WGInfo.y >> 16)&0xFFFF;\n"
"int     GroupY = (WGInfo.y >> 0 )& 0xFFFF;\n"
"int     Width  = (WGInfo.x >> 16)&0xFFFF;\n"
"int     Height = (WGInfo.x >> 0 )& 0xFFFF;\n"
"int     ImgOffset = WGInfo.z;\n"
"float   ScaleFactor = as_float(WGInfo.w);\n"
"#define DATA_SIZE_X (PIXEL_STEP*LSx+WND_SIZE_X)\n"
"#define DATA_SIZE_Y (PIXEL_STEP*LSy+WND_SIZE_Y)\n"
"#define DATA_SIZE (DATA_SIZE_X*DATA_SIZE_Y)\n"
"local int SumL[DATA_SIZE];\n"
"for(int i = 0; i<DATA_SIZE; i+=(LSx*LSy))\n"
"{\n"
"int     index = i+lid;\n"
"if(index<DATA_SIZE)\n"
"{\n"
"int     x = min(GroupX + (index % (DATA_SIZE_X)),Width-1+WND_SIZE_X);\n"
"int     y = min(GroupY + (index / (DATA_SIZE_X)),Height-1+WND_SIZE_Y);\n"
"SumL[index] = sum[ImgOffset+y*pixelstep+x];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"float   variance_norm_factor;\n"
"int     nodecounter= startnode;\n"
"int4    info1 = p;\n"
"int4    info2 = pq;\n"
"int     xl = lid_x*PIXEL_STEP;\n"
"int     yl = lid_y*PIXEL_STEP;\n"
"{\n"
"int     OffsetLocal =          yl * DATA_SIZE_X +         xl;\n"
"int     OffsetGlobal = (GroupY+yl)* pixelstep   + (GroupX+xl);\n"
"OffsetGlobal += ImgOffset;\n"
"float   mean =\n"
"SumL[info1.y*DATA_SIZE_X+info1.x+OffsetLocal] -\n"
"SumL[info1.y*DATA_SIZE_X+info1.z+OffsetLocal] -\n"
"SumL[info1.w*DATA_SIZE_X+info1.x+OffsetLocal] +\n"
"SumL[info1.w*DATA_SIZE_X+info1.z+OffsetLocal];\n"
"float sq =\n"
"sqsum[info2.y*pixelstep+info2.x+OffsetGlobal] -\n"
"sqsum[info2.y*pixelstep+info2.z+OffsetGlobal] -\n"
"sqsum[info2.w*pixelstep+info2.x+OffsetGlobal] +\n"
"sqsum[info2.w*pixelstep+info2.z+OffsetGlobal];\n"
"mean *= correction;\n"
"sq *= correction;\n"
"variance_norm_factor = sq - mean * mean;\n"
"variance_norm_factor = (variance_norm_factor >=0.f) ? sqrt(variance_norm_factor) : 1.f;\n"
"}\n"
"int result = (1.0f>0.0f);\n"
"for(int stageloop = start_stage; (stageloop < end_stage) && result; stageloop++ )\n"
"{\n"
"float   stage_sum = 0.0f;\n"
"int2    stageinfo = *(global int2*)(stagecascadeptr+stageloop);\n"
"float   stagethreshold = as_float(stageinfo.y);\n"
"int     lcl_off = (lid_y*DATA_SIZE_X)+(lid_x);\n"
"for(int nodeloop = 0; nodeloop < stageinfo.x; nodecounter++,nodeloop++ )\n"
"{\n"
"#define M0(_t) ((_t)&0xFFFF)\n"
"#define M1(_t) (((_t)>>16)&0xFFFF)\n"
"global const int4* pN = (__global int4*)(pNodesPK+nodecounter*NODE_SIZE);\n"
"int4    n0 = pN[0];\n"
"int4    n1 = pN[1];\n"
"int4    n2 = pN[2];\n"
"float   nodethreshold  = as_float(n2.y) * variance_norm_factor;\n"
"float classsum =\n"
"(SumL[M0(n0.x)+lcl_off] - SumL[M1(n0.x)+lcl_off] - SumL[M0(n0.y)+lcl_off] + SumL[M1(n0.y)+lcl_off]) * as_float(n1.z) +\n"
"(SumL[M0(n0.z)+lcl_off] - SumL[M1(n0.z)+lcl_off] - SumL[M0(n0.w)+lcl_off] + SumL[M1(n0.w)+lcl_off]) * as_float(n1.w) +\n"
"(SumL[M0(n1.x)+lcl_off] - SumL[M1(n1.x)+lcl_off] - SumL[M0(n1.y)+lcl_off] + SumL[M1(n1.y)+lcl_off]) * as_float(n2.x);\n"
"stage_sum += (classsum >= nodethreshold) ? as_float(n2.w) : as_float(n2.z);\n"
"}\n"
"result = (stage_sum >= stagethreshold);\n"
"}\n"
"if(result)\n"
"{\n"
"int index = 1+atomic_inc((volatile global int*)candidate);\n"
"if(index<OUTPUTSZ)\n"
"{\n"
"int     x = GroupX+xl;\n"
"int     y = GroupY+yl;\n"
"int4 candidate_result;\n"
"candidate_result.x = convert_int_rtn(x*ScaleFactor);\n"
"candidate_result.y = convert_int_rtn(y*ScaleFactor);\n"
"candidate_result.z = convert_int_rtn(ScaleFactor*WND_SIZE_X);\n"
"candidate_result.w = convert_int_rtn(ScaleFactor*WND_SIZE_Y);\n"
"candidate[index] = candidate_result;\n"
"}\n"
"}\n"
"}\n"
"#else\n"
"__kernel void __attribute__((reqd_work_group_size(8,8,1)))gpuRunHaarClassifierCascade(\n"
"global GpuHidHaarStageClassifier * stagecascadeptr,\n"
"global int4 * info,\n"
"global GpuHidHaarTreeNode * nodeptr,\n"
"global const int * restrict sum1,\n"
"global const float * restrict sqsum1,\n"
"global int4 * candidate,\n"
"const int pixelstep,\n"
"const int loopcount,\n"
"const int start_stage,\n"
"const int split_stage,\n"
"const int end_stage,\n"
"const int startnode,\n"
"const int splitnode,\n"
"const int4 p,\n"
"const int4 pq,\n"
"const float correction)\n"
"{\n"
"int grpszx = get_local_size(0);\n"
"int grpszy = get_local_size(1);\n"
"int grpnumx = get_num_groups(0);\n"
"int grpidx = get_group_id(0);\n"
"int lclidx = get_local_id(0);\n"
"int lclidy = get_local_id(1);\n"
"int lcl_sz = mul24(grpszx,grpszy);\n"
"int lcl_id = mad24(lclidy,grpszx,lclidx);\n"
"__local int lclshare[1024];\n"
"__local int* lcldata = lclshare;\n"
"__local int* glboutindex = lcldata + 28*28;\n"
"__local int* lclcount = glboutindex + 1;\n"
"__local int* lcloutindex = lclcount + 1;\n"
"__local float* partialsum = (__local float*)(lcloutindex + (lcl_sz<<1));\n"
"glboutindex[0]=0;\n"
"int outputoff = mul24(grpidx,256);\n"
"#define WINDOWSIZE 20+1\n"
"int readwidth = ((grpszx-1 + WINDOWSIZE+3)>>2)<<2;\n"
"int readheight = grpszy-1+WINDOWSIZE;\n"
"int read_horiz_cnt = readwidth >> 2;\n"
"int total_read = mul24(read_horiz_cnt,readheight);\n"
"int read_loop = (total_read + lcl_sz - 1) >> 6;\n"
"candidate[outputoff+(lcl_id<<2)] = (int4)0;\n"
"candidate[outputoff+(lcl_id<<2)+1] = (int4)0;\n"
"candidate[outputoff+(lcl_id<<2)+2] = (int4)0;\n"
"candidate[outputoff+(lcl_id<<2)+3] = (int4)0;\n"
"for(int scalei = 0; scalei <loopcount; scalei++)\n"
"{\n"
"int4 scaleinfo1= info[scalei];\n"
"int height = scaleinfo1.x & 0xffff;\n"
"int grpnumperline =(scaleinfo1.y & 0xffff0000) >> 16;\n"
"int totalgrp = scaleinfo1.y & 0xffff;\n"
"int imgoff = scaleinfo1.z;\n"
"float factor = as_float(scaleinfo1.w);\n"
"__global const int * sum = sum1 + imgoff;\n"
"__global const float * sqsum = sqsum1 + imgoff;\n"
"for(int grploop=grpidx; grploop<totalgrp; grploop+=grpnumx)\n"
"{\n"
"int grpidy = grploop / grpnumperline;\n"
"int grpidx = grploop - mul24(grpidy, grpnumperline);\n"
"int x = mad24(grpidx,grpszx,lclidx);\n"
"int y = mad24(grpidy,grpszy,lclidy);\n"
"int grpoffx = x-lclidx;\n"
"int grpoffy = y-lclidy;\n"
"for(int i=0; i<read_loop; i++)\n"
"{\n"
"int pos_id = mad24(i,lcl_sz,lcl_id);\n"
"pos_id = pos_id < total_read ? pos_id : 0;\n"
"int lcl_y = pos_id / read_horiz_cnt;\n"
"int lcl_x = pos_id - mul24(lcl_y, read_horiz_cnt);\n"
"int glb_x = grpoffx + (lcl_x<<2);\n"
"int glb_y = grpoffy + lcl_y;\n"
"int glb_off = mad24(min(glb_y, height + WINDOWSIZE - 1),pixelstep,glb_x);\n"
"int4 data = *(__global int4*)&sum[glb_off];\n"
"int lcl_off = mad24(lcl_y, readwidth, lcl_x<<2);\n"
"vstore4(data, 0, &lcldata[lcl_off]);\n"
"}\n"
"lcloutindex[lcl_id] = 0;\n"
"lclcount[0] = 0;\n"
"int result = 1;\n"
"int nodecounter= startnode;\n"
"float mean, variance_norm_factor;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int lcl_off = mad24(lclidy,readwidth,lclidx);\n"
"int4 cascadeinfo1, cascadeinfo2;\n"
"cascadeinfo1 = p;\n"
"cascadeinfo2 = pq;\n"
"cascadeinfo1.x +=lcl_off;\n"
"cascadeinfo1.z +=lcl_off;\n"
"mean = (lcldata[mad24(cascadeinfo1.y,readwidth,cascadeinfo1.x)] - lcldata[mad24(cascadeinfo1.y,readwidth,cascadeinfo1.z)] -\n"
"lcldata[mad24(cascadeinfo1.w,readwidth,cascadeinfo1.x)] + lcldata[mad24(cascadeinfo1.w,readwidth,cascadeinfo1.z)])\n"
"*correction;\n"
"int p_offset = mad24(y, pixelstep, x);\n"
"cascadeinfo2.x +=p_offset;\n"
"cascadeinfo2.z +=p_offset;\n"
"variance_norm_factor =sqsum[mad24(cascadeinfo2.y, pixelstep, cascadeinfo2.x)] - sqsum[mad24(cascadeinfo2.y, pixelstep, cascadeinfo2.z)] -\n"
"sqsum[mad24(cascadeinfo2.w, pixelstep, cascadeinfo2.x)] + sqsum[mad24(cascadeinfo2.w, pixelstep, cascadeinfo2.z)];\n"
"variance_norm_factor = variance_norm_factor * correction - mean * mean;\n"
"variance_norm_factor = variance_norm_factor >=0.f ? sqrt(variance_norm_factor) : 1.f;\n"
"for(int stageloop = start_stage; (stageloop < split_stage)  && result; stageloop++ )\n"
"{\n"
"float stage_sum = 0.f;\n"
"int2 stageinfo = *(global int2*)(stagecascadeptr+stageloop);\n"
"float stagethreshold = as_float(stageinfo.y);\n"
"for(int nodeloop = 0; nodeloop < stageinfo.x; )\n"
"{\n"
"__global GpuHidHaarTreeNode* currentnodeptr = (nodeptr + nodecounter);\n"
"int4 info1 = *(__global int4*)(&(currentnodeptr->p[0][0]));\n"
"int4 info2 = *(__global int4*)(&(currentnodeptr->p[1][0]));\n"
"int4 info3 = *(__global int4*)(&(currentnodeptr->p[2][0]));\n"
"float4 w = *(__global float4*)(&(currentnodeptr->weight[0]));\n"
"float3 alpha3 = *(__global float3*)(&(currentnodeptr->alpha[0]));\n"
"float nodethreshold  = w.w * variance_norm_factor;\n"
"info1.x +=lcl_off;\n"
"info1.z +=lcl_off;\n"
"info2.x +=lcl_off;\n"
"info2.z +=lcl_off;\n"
"float classsum = (lcldata[mad24(info1.y,readwidth,info1.x)] - lcldata[mad24(info1.y,readwidth,info1.z)] -\n"
"lcldata[mad24(info1.w,readwidth,info1.x)] + lcldata[mad24(info1.w,readwidth,info1.z)]) * w.x;\n"
"classsum += (lcldata[mad24(info2.y,readwidth,info2.x)] - lcldata[mad24(info2.y,readwidth,info2.z)] -\n"
"lcldata[mad24(info2.w,readwidth,info2.x)] + lcldata[mad24(info2.w,readwidth,info2.z)]) * w.y;\n"
"info3.x +=lcl_off;\n"
"info3.z +=lcl_off;\n"
"classsum += (lcldata[mad24(info3.y,readwidth,info3.x)] - lcldata[mad24(info3.y,readwidth,info3.z)] -\n"
"lcldata[mad24(info3.w,readwidth,info3.x)] + lcldata[mad24(info3.w,readwidth,info3.z)]) * w.z;\n"
"bool passThres = classsum >= nodethreshold;\n"
"#if STUMP_BASED\n"
"stage_sum += passThres ? alpha3.y : alpha3.x;\n"
"nodecounter++;\n"
"nodeloop++;\n"
"#else\n"
"bool isRootNode = (nodecounter & 1) == 0;\n"
"if(isRootNode)\n"
"{\n"
"if( (passThres && currentnodeptr->right) ||\n"
"(!passThres && currentnodeptr->left))\n"
"{\n"
"nodecounter ++;\n"
"}\n"
"else\n"
"{\n"
"stage_sum += alpha3.x;\n"
"nodecounter += 2;\n"
"nodeloop ++;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"stage_sum += passThres ? alpha3.z : alpha3.y;\n"
"nodecounter ++;\n"
"nodeloop ++;\n"
"}\n"
"#endif\n"
"}\n"
"result = (stage_sum >= stagethreshold);\n"
"}\n"
"if(factor < 2)\n"
"{\n"
"if(result && lclidx %2 ==0 && lclidy %2 ==0 )\n"
"{\n"
"int queueindex = atomic_inc(lclcount);\n"
"lcloutindex[queueindex<<1] = (lclidy << 16) | lclidx;\n"
"lcloutindex[(queueindex<<1)+1] = as_int((float)variance_norm_factor);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if(result)\n"
"{\n"
"int queueindex = atomic_inc(lclcount);\n"
"lcloutindex[queueindex<<1] = (lclidy << 16) | lclidx;\n"
"lcloutindex[(queueindex<<1)+1] = as_int((float)variance_norm_factor);\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int queuecount  = lclcount[0];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"nodecounter = splitnode;\n"
"for(int stageloop = split_stage; stageloop< end_stage && queuecount>0; stageloop++)\n"
"{\n"
"lclcount[0]=0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int2 stageinfo = *(global int2*)(stagecascadeptr+stageloop);\n"
"float stagethreshold = as_float(stageinfo.y);\n"
"int perfscale = queuecount > 4 ? 3 : 2;\n"
"int queuecount_loop = (queuecount + (1<<perfscale)-1) >> perfscale;\n"
"int lcl_compute_win = lcl_sz >> perfscale;\n"
"int lcl_compute_win_id = (lcl_id >>(6-perfscale));\n"
"int lcl_loops = (stageinfo.x + lcl_compute_win -1) >> (6-perfscale);\n"
"int lcl_compute_id = lcl_id - (lcl_compute_win_id << (6-perfscale));\n"
"for(int queueloop=0; queueloop<queuecount_loop; queueloop++)\n"
"{\n"
"float stage_sum = 0.f;\n"
"int temp_coord = lcloutindex[lcl_compute_win_id<<1];\n"
"float variance_norm_factor = as_float(lcloutindex[(lcl_compute_win_id<<1)+1]);\n"
"int queue_pixel = mad24(((temp_coord  & (int)0xffff0000)>>16),readwidth,temp_coord & 0xffff);\n"
"if(lcl_compute_win_id < queuecount)\n"
"{\n"
"int tempnodecounter = lcl_compute_id;\n"
"float part_sum = 0.f;\n"
"const int stump_factor = STUMP_BASED ? 1 : 2;\n"
"int root_offset = 0;\n"
"for(int lcl_loop=0; lcl_loop<lcl_loops && tempnodecounter<stageinfo.x;)\n"
"{\n"
"__global GpuHidHaarTreeNode* currentnodeptr =\n"
"nodeptr + (nodecounter + tempnodecounter) * stump_factor + root_offset;\n"
"int4 info1 = *(__global int4*)(&(currentnodeptr->p[0][0]));\n"
"int4 info2 = *(__global int4*)(&(currentnodeptr->p[1][0]));\n"
"int4 info3 = *(__global int4*)(&(currentnodeptr->p[2][0]));\n"
"float4 w = *(__global float4*)(&(currentnodeptr->weight[0]));\n"
"float3 alpha3 = *(__global float3*)(&(currentnodeptr->alpha[0]));\n"
"float nodethreshold  = w.w * variance_norm_factor;\n"
"info1.x +=queue_pixel;\n"
"info1.z +=queue_pixel;\n"
"info2.x +=queue_pixel;\n"
"info2.z +=queue_pixel;\n"
"float classsum = (lcldata[mad24(info1.y,readwidth,info1.x)] - lcldata[mad24(info1.y,readwidth,info1.z)] -\n"
"lcldata[mad24(info1.w,readwidth,info1.x)] + lcldata[mad24(info1.w,readwidth,info1.z)]) * w.x;\n"
"classsum += (lcldata[mad24(info2.y,readwidth,info2.x)] - lcldata[mad24(info2.y,readwidth,info2.z)] -\n"
"lcldata[mad24(info2.w,readwidth,info2.x)] + lcldata[mad24(info2.w,readwidth,info2.z)]) * w.y;\n"
"info3.x +=queue_pixel;\n"
"info3.z +=queue_pixel;\n"
"classsum += (lcldata[mad24(info3.y,readwidth,info3.x)] - lcldata[mad24(info3.y,readwidth,info3.z)] -\n"
"lcldata[mad24(info3.w,readwidth,info3.x)] + lcldata[mad24(info3.w,readwidth,info3.z)]) * w.z;\n"
"bool passThres = classsum >= nodethreshold;\n"
"#if STUMP_BASED\n"
"part_sum += passThres ? alpha3.y : alpha3.x;\n"
"tempnodecounter += lcl_compute_win;\n"
"lcl_loop++;\n"
"#else\n"
"if(root_offset == 0)\n"
"{\n"
"if( (passThres && currentnodeptr->right) ||\n"
"(!passThres && currentnodeptr->left))\n"
"{\n"
"root_offset = 1;\n"
"}\n"
"else\n"
"{\n"
"part_sum += alpha3.x;\n"
"tempnodecounter += lcl_compute_win;\n"
"lcl_loop++;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"part_sum += passThres ? alpha3.z : alpha3.y;\n"
"tempnodecounter += lcl_compute_win;\n"
"lcl_loop++;\n"
"root_offset = 0;\n"
"}\n"
"#endif\n"
"}\n"
"partialsum[lcl_id]=part_sum;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lcl_compute_win_id < queuecount)\n"
"{\n"
"for(int i=0; i<lcl_compute_win && (lcl_compute_id==0); i++)\n"
"{\n"
"stage_sum += partialsum[lcl_id+i];\n"
"}\n"
"if(stage_sum >= stagethreshold && (lcl_compute_id==0))\n"
"{\n"
"int queueindex = atomic_inc(lclcount);\n"
"lcloutindex[queueindex<<1] = temp_coord;\n"
"lcloutindex[(queueindex<<1)+1] = as_int(variance_norm_factor);\n"
"}\n"
"lcl_compute_win_id +=(1<<perfscale);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"queuecount = lclcount[0];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"nodecounter += stageinfo.x;\n"
"}\n"
"if(lcl_id<queuecount)\n"
"{\n"
"int temp = lcloutindex[lcl_id<<1];\n"
"int x = mad24(grpidx,grpszx,temp & 0xffff);\n"
"int y = mad24(grpidy,grpszy,((temp & (int)0xffff0000) >> 16));\n"
"temp = glboutindex[0];\n"
"int4 candidate_result;\n"
"candidate_result.zw = (int2)convert_int_rte(factor*20.f);\n"
"candidate_result.x = convert_int_rte(x*factor);\n"
"candidate_result.y = convert_int_rte(y*factor);\n"
"atomic_inc(glboutindex);\n"
"int i = outputoff+temp+lcl_id;\n"
"if(candidate[i].z == 0)\n"
"{\n"
"candidate[i] = candidate_result;\n"
"}\n"
"else\n"
"{\n"
"for(i=i+1;;i++)\n"
"{\n"
"if(candidate[i].z == 0)\n"
"{\n"
"candidate[i] = candidate_result;\n"
"break;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"}\n"
"#endif\n"
, "590337901df52f2d5c88385fa212f8b5"};
const struct ProgramEntry haarobjectdetect_scaled2={"haarobjectdetect_scaled2",
"#define CV_HAAR_FEATURE_MAX           3\n"
"typedef int   sumtype;\n"
"typedef float sqsumtype;\n"
"typedef struct __attribute__((aligned(128))) GpuHidHaarTreeNode\n"
"{\n"
"int p[CV_HAAR_FEATURE_MAX][4] __attribute__((aligned(64)));\n"
"float weight[CV_HAAR_FEATURE_MAX] ;\n"
"float threshold ;\n"
"float alpha[3] __attribute__((aligned(16)));\n"
"int left __attribute__((aligned(4)));\n"
"int right __attribute__((aligned(4)));\n"
"}\n"
"GpuHidHaarTreeNode;\n"
"typedef struct __attribute__((aligned(32))) GpuHidHaarClassifier\n"
"{\n"
"int count __attribute__((aligned(4)));\n"
"GpuHidHaarTreeNode *node __attribute__((aligned(8)));\n"
"float *alpha __attribute__((aligned(8)));\n"
"}\n"
"GpuHidHaarClassifier;\n"
"typedef struct __attribute__((aligned(64))) GpuHidHaarStageClassifier\n"
"{\n"
"int  count __attribute__((aligned(4)));\n"
"float threshold __attribute__((aligned(4)));\n"
"int two_rects __attribute__((aligned(4)));\n"
"int reserved0 __attribute__((aligned(8)));\n"
"int reserved1 __attribute__((aligned(8)));\n"
"int reserved2 __attribute__((aligned(8)));\n"
"int reserved3 __attribute__((aligned(8)));\n"
"}\n"
"GpuHidHaarStageClassifier;\n"
"typedef struct __attribute__((aligned(64))) GpuHidHaarClassifierCascade\n"
"{\n"
"int  count __attribute__((aligned(4)));\n"
"int  is_stump_based __attribute__((aligned(4)));\n"
"int  has_tilted_features __attribute__((aligned(4)));\n"
"int  is_tree __attribute__((aligned(4)));\n"
"int pq0 __attribute__((aligned(4)));\n"
"int pq1 __attribute__((aligned(4)));\n"
"int pq2 __attribute__((aligned(4)));\n"
"int pq3 __attribute__((aligned(4)));\n"
"int p0 __attribute__((aligned(4)));\n"
"int p1 __attribute__((aligned(4)));\n"
"int p2 __attribute__((aligned(4)));\n"
"int p3 __attribute__((aligned(4)));\n"
"float inv_window_area __attribute__((aligned(4)));\n"
"} GpuHidHaarClassifierCascade;\n"
"__kernel void gpuRunHaarClassifierCascade_scaled2(\n"
"global GpuHidHaarStageClassifier *stagecascadeptr,\n"
"global int4 *info,\n"
"global GpuHidHaarTreeNode *nodeptr,\n"
"global const int *restrict sum,\n"
"global const float   *restrict sqsum,\n"
"global int4 *candidate,\n"
"const int rows,\n"
"const int cols,\n"
"const int step,\n"
"const int loopcount,\n"
"const int start_stage,\n"
"const int split_stage,\n"
"const int end_stage,\n"
"const int startnode,\n"
"global int4 *p,\n"
"global float *correction,\n"
"const int nodecount)\n"
"{\n"
"int grpszx = get_local_size(0);\n"
"int grpszy = get_local_size(1);\n"
"int grpnumx = get_num_groups(0);\n"
"int grpidx = get_group_id(0);\n"
"int lclidx = get_local_id(0);\n"
"int lclidy = get_local_id(1);\n"
"int lcl_id = mad24(lclidy, grpszx, lclidx);\n"
"__local int glboutindex[1];\n"
"__local int lclcount[1];\n"
"__local int lcloutindex[64];\n"
"glboutindex[0] = 0;\n"
"int outputoff = mul24(grpidx, 256);\n"
"candidate[outputoff + (lcl_id << 2)] = (int4)0;\n"
"candidate[outputoff + (lcl_id << 2) + 1] = (int4)0;\n"
"candidate[outputoff + (lcl_id << 2) + 2] = (int4)0;\n"
"candidate[outputoff + (lcl_id << 2) + 3] = (int4)0;\n"
"int max_idx = rows * cols - 1;\n"
"for (int scalei = 0; scalei < loopcount; scalei++)\n"
"{\n"
"int4 scaleinfo1;\n"
"scaleinfo1 = info[scalei];\n"
"int grpnumperline = (scaleinfo1.y & 0xffff0000) >> 16;\n"
"int totalgrp = scaleinfo1.y & 0xffff;\n"
"float factor = as_float(scaleinfo1.w);\n"
"float correction_t = correction[scalei];\n"
"float ystep = max(2.0f, factor);\n"
"for (int grploop = get_group_id(0); grploop < totalgrp; grploop += grpnumx)\n"
"{\n"
"int4 cascadeinfo = p[scalei];\n"
"int grpidy = grploop / grpnumperline;\n"
"int grpidx = grploop - mul24(grpidy, grpnumperline);\n"
"int ix = mad24(grpidx, grpszx, lclidx);\n"
"int iy = mad24(grpidy, grpszy, lclidy);\n"
"int x = round(ix * ystep);\n"
"int y = round(iy * ystep);\n"
"lcloutindex[lcl_id] = 0;\n"
"lclcount[0] = 0;\n"
"int nodecounter;\n"
"float mean, variance_norm_factor;\n"
"{\n"
"const int p_offset = mad24(y, step, x);\n"
"cascadeinfo.x += p_offset;\n"
"cascadeinfo.z += p_offset;\n"
"mean = (sum[clamp(mad24(cascadeinfo.y, step, cascadeinfo.x), 0, max_idx)]\n"
"- sum[clamp(mad24(cascadeinfo.y, step, cascadeinfo.z), 0, max_idx)] -\n"
"sum[clamp(mad24(cascadeinfo.w, step, cascadeinfo.x), 0, max_idx)]\n"
"+ sum[clamp(mad24(cascadeinfo.w, step, cascadeinfo.z), 0, max_idx)])\n"
"* correction_t;\n"
"variance_norm_factor = sqsum[clamp(mad24(cascadeinfo.y, step, cascadeinfo.x), 0, max_idx)]\n"
"- sqsum[clamp(mad24(cascadeinfo.y, step, cascadeinfo.z), 0, max_idx)] -\n"
"sqsum[clamp(mad24(cascadeinfo.w, step, cascadeinfo.x), 0, max_idx)]\n"
"+ sqsum[clamp(mad24(cascadeinfo.w, step, cascadeinfo.z), 0, max_idx)];\n"
"variance_norm_factor = variance_norm_factor * correction_t - mean * mean;\n"
"variance_norm_factor = variance_norm_factor >= 0.f ? sqrt(variance_norm_factor) : 1.f;\n"
"bool result = true;\n"
"nodecounter = startnode + nodecount * scalei;\n"
"for (int stageloop = start_stage; (stageloop < end_stage) && result; stageloop++)\n"
"{\n"
"float stage_sum = 0.f;\n"
"int   stagecount = stagecascadeptr[stageloop].count;\n"
"for (int nodeloop = 0; nodeloop < stagecount;)\n"
"{\n"
"__global GpuHidHaarTreeNode *currentnodeptr = (nodeptr + nodecounter);\n"
"int4 info1 = *(__global int4 *)(&(currentnodeptr->p[0][0]));\n"
"int4 info2 = *(__global int4 *)(&(currentnodeptr->p[1][0]));\n"
"int4 info3 = *(__global int4 *)(&(currentnodeptr->p[2][0]));\n"
"float4 w = *(__global float4 *)(&(currentnodeptr->weight[0]));\n"
"float3 alpha3 = *(__global float3 *)(&(currentnodeptr->alpha[0]));\n"
"float nodethreshold  = w.w * variance_norm_factor;\n"
"info1.x += p_offset;\n"
"info1.z += p_offset;\n"
"info2.x += p_offset;\n"
"info2.z += p_offset;\n"
"info3.x += p_offset;\n"
"info3.z += p_offset;\n"
"float classsum = (sum[clamp(mad24(info1.y, step, info1.x), 0, max_idx)]\n"
"- sum[clamp(mad24(info1.y, step, info1.z), 0, max_idx)] -\n"
"sum[clamp(mad24(info1.w, step, info1.x), 0, max_idx)]\n"
"+ sum[clamp(mad24(info1.w, step, info1.z), 0, max_idx)]) * w.x;\n"
"classsum += (sum[clamp(mad24(info2.y, step, info2.x), 0, max_idx)]\n"
"- sum[clamp(mad24(info2.y, step, info2.z), 0, max_idx)] -\n"
"sum[clamp(mad24(info2.w, step, info2.x), 0, max_idx)]\n"
"+ sum[clamp(mad24(info2.w, step, info2.z), 0, max_idx)]) * w.y;\n"
"classsum += (sum[clamp(mad24(info3.y, step, info3.x), 0, max_idx)]\n"
"- sum[clamp(mad24(info3.y, step, info3.z), 0, max_idx)] -\n"
"sum[clamp(mad24(info3.w, step, info3.x), 0, max_idx)]\n"
"+ sum[clamp(mad24(info3.w, step, info3.z), 0, max_idx)]) * w.z;\n"
"bool passThres = classsum >= nodethreshold;\n"
"#if STUMP_BASED\n"
"stage_sum += passThres ? alpha3.y : alpha3.x;\n"
"nodecounter++;\n"
"nodeloop++;\n"
"#else\n"
"bool isRootNode = (nodecounter & 1) == 0;\n"
"if(isRootNode)\n"
"{\n"
"if( (passThres && currentnodeptr->right) ||\n"
"(!passThres && currentnodeptr->left))\n"
"{\n"
"nodecounter ++;\n"
"}\n"
"else\n"
"{\n"
"stage_sum += alpha3.x;\n"
"nodecounter += 2;\n"
"nodeloop ++;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"stage_sum += (passThres ? alpha3.z : alpha3.y);\n"
"nodecounter ++;\n"
"nodeloop ++;\n"
"}\n"
"#endif\n"
"}\n"
"result = (int)(stage_sum >= stagecascadeptr[stageloop].threshold);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (result)\n"
"{\n"
"int queueindex = atomic_inc(lclcount);\n"
"lcloutindex[queueindex] = (y << 16) | x;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int queuecount = lclcount[0];\n"
"if (lcl_id < queuecount)\n"
"{\n"
"int temp = lcloutindex[lcl_id];\n"
"int x = temp & 0xffff;\n"
"int y = (temp & (int)0xffff0000) >> 16;\n"
"temp = atomic_inc(glboutindex);\n"
"int4 candidate_result;\n"
"candidate_result.zw = (int2)convert_int_rte(factor * 20.f);\n"
"candidate_result.x = x;\n"
"candidate_result.y = y;\n"
"int i = outputoff+temp+lcl_id;\n"
"if(candidate[i].z == 0)\n"
"{\n"
"candidate[i] = candidate_result;\n"
"}\n"
"else\n"
"{\n"
"for(i=i+1;;i++)\n"
"{\n"
"if(candidate[i].z == 0)\n"
"{\n"
"candidate[i] = candidate_result;\n"
"break;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"__kernel void gpuscaleclassifier(global GpuHidHaarTreeNode *orinode, global GpuHidHaarTreeNode *newnode, float scale, float weight_scale, int nodenum)\n"
"{\n"
"int counter = get_global_id(0);\n"
"int tr_x[3], tr_y[3], tr_h[3], tr_w[3], i = 0;\n"
"GpuHidHaarTreeNode t1 = *(orinode + counter);\n"
"#pragma unroll\n"
"for (i = 0; i < 3; i++)\n"
"{\n"
"tr_x[i] = (int)(t1.p[i][0] * scale + 0.5f);\n"
"tr_y[i] = (int)(t1.p[i][1] * scale + 0.5f);\n"
"tr_w[i] = (int)(t1.p[i][2] * scale + 0.5f);\n"
"tr_h[i] = (int)(t1.p[i][3] * scale + 0.5f);\n"
"}\n"
"t1.weight[0] = -(t1.weight[1] * tr_h[1] * tr_w[1] + t1.weight[2] * tr_h[2] * tr_w[2]) / (tr_h[0] * tr_w[0]);\n"
"counter += nodenum;\n"
"#pragma unroll\n"
"for (i = 0; i < 3; i++)\n"
"{\n"
"newnode[counter].p[i][0] = tr_x[i];\n"
"newnode[counter].p[i][1] = tr_y[i];\n"
"newnode[counter].p[i][2] = tr_x[i] + tr_w[i];\n"
"newnode[counter].p[i][3] = tr_y[i] + tr_h[i];\n"
"newnode[counter].weight[i] = t1.weight[i] * weight_scale;\n"
"}\n"
"newnode[counter].left = t1.left;\n"
"newnode[counter].right = t1.right;\n"
"newnode[counter].threshold = t1.threshold;\n"
"newnode[counter].alpha[0] = t1.alpha[0];\n"
"newnode[counter].alpha[1] = t1.alpha[1];\n"
"newnode[counter].alpha[2] = t1.alpha[2];\n"
"}\n"
, "37a0dce47f004dc26ec48a141c200e2d"};
const struct ProgramEntry imgproc_bilateral={"imgproc_bilateral",
"__kernel void bilateral_C1_D0(__global uchar *dst,\n"
"__global const uchar *src,\n"
"const int dst_rows,\n"
"const int dst_cols,\n"
"const int maxk,\n"
"const int radius,\n"
"const int dst_step,\n"
"const int dst_offset,\n"
"const int src_step,\n"
"const int src_rows,\n"
"const int src_cols,\n"
"__constant float *color_weight,\n"
"__constant float *space_weight,\n"
"__constant int *space_ofs)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < dst_rows && x < dst_cols)\n"
"{\n"
"int src_index = mad24(y + radius, src_step, x + radius);\n"
"int dst_index = mad24(y, dst_step, x + dst_offset);\n"
"float sum = 0.f, wsum = 0.f;\n"
"int val0 = (int)src[src_index];\n"
"for(int k = 0; k < maxk; k++ )\n"
"{\n"
"int val = (int)src[src_index + space_ofs[k]];\n"
"float w = space_weight[k] * color_weight[abs(val - val0)];\n"
"sum += (float)(val) * w;\n"
"wsum += w;\n"
"}\n"
"dst[dst_index] = convert_uchar_rtz(sum / wsum + 0.5f);\n"
"}\n"
"}\n"
"__kernel void bilateral2_C1_D0(__global uchar *dst,\n"
"__global const uchar *src,\n"
"const int dst_rows,\n"
"const int dst_cols,\n"
"const int maxk,\n"
"const int radius,\n"
"const int dst_step,\n"
"const int dst_offset,\n"
"const int src_step,\n"
"const int src_rows,\n"
"const int src_cols,\n"
"__constant float *color_weight,\n"
"__constant float *space_weight,\n"
"__constant int *space_ofs)\n"
"{\n"
"int x = get_global_id(0) << 2;\n"
"int y = get_global_id(1);\n"
"if (y < dst_rows && x < dst_cols)\n"
"{\n"
"int src_index = mad24(y + radius, src_step, x + radius);\n"
"int dst_index = mad24(y, dst_step, x + dst_offset);\n"
"float4 sum = (float4)(0.f), wsum = (float4)(0.f);\n"
"int4 val0 = convert_int4(vload4(0,src + src_index));\n"
"for(int k = 0; k < maxk; k++ )\n"
"{\n"
"int4 val = convert_int4(vload4(0,src+src_index + space_ofs[k]));\n"
"float4 w = (float4)(space_weight[k]) * (float4)(color_weight[abs(val.x - val0.x)], color_weight[abs(val.y - val0.y)],\n"
"color_weight[abs(val.z - val0.z)], color_weight[abs(val.w - val0.w)]);\n"
"sum += convert_float4(val) * w;\n"
"wsum += w;\n"
"}\n"
"*(__global uchar4*)(dst+dst_index) = convert_uchar4_rtz(sum/wsum+0.5f);\n"
"}\n"
"}\n"
"__kernel void bilateral_C4_D0(__global uchar4 *dst,\n"
"__global const uchar4 *src,\n"
"const int dst_rows,\n"
"const int dst_cols,\n"
"const int maxk,\n"
"const int radius,\n"
"const int dst_step,\n"
"const int dst_offset,\n"
"const int src_step,\n"
"const int src_rows,\n"
"const int src_cols,\n"
"__constant float *color_weight,\n"
"__constant float *space_weight,\n"
"__constant int *space_ofs)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < dst_rows && x < dst_cols)\n"
"{\n"
"int src_index = mad24(y + radius, src_step, x + radius);\n"
"int dst_index = mad24(y, dst_step, x + dst_offset);\n"
"float4 sum = (float4)0.f;\n"
"float wsum = 0.f;\n"
"int4 val0 = convert_int4(src[src_index]);\n"
"for(int k = 0; k < maxk; k++ )\n"
"{\n"
"int4 val = convert_int4(src[src_index + space_ofs[k]]);\n"
"float w = space_weight[k] * color_weight[abs(val.x - val0.x) + abs(val.y - val0.y) + abs(val.z - val0.z)];\n"
"sum += convert_float4(val) * (float4)w;\n"
"wsum += w;\n"
"}\n"
"wsum = 1.f / wsum;\n"
"dst[dst_index] = convert_uchar4_rtz(sum * (float4)wsum + (float4)0.5f);\n"
"}\n"
"}\n"
, "9b8b7d38ce4703393eef8505f1b2c7d3"};
const struct ProgramEntry imgproc_calcHarris={"imgproc_calcHarris",
"#if defined (DOUBLE_SUPPORT) && defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#define FPTYPE double\n"
"#else\n"
"#define FPTYPE float\n"
"#endif\n"
"#ifdef BORDER_CONSTANT\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"x = max(min(x, maxV - 1), 0); \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"if (x < 0) \\\n"
"x -= ((x - maxV + 1) / maxV) * maxV; \\\n"
"if (x >= maxV) \\\n"
"x %= maxV; \\\n"
"}\n"
"#elif defined(BORDER_REFLECT) || defined(BORDER_REFLECT101)\n"
"#define EXTRAPOLATE_(x, maxV, delta) \\\n"
"{ \\\n"
"if (maxV == 1) \\\n"
"x = 0; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if ( x < 0 ) \\\n"
"x = -x - 1 + delta; \\\n"
"else \\\n"
"x = maxV - 1 - (x - maxV) - delta; \\\n"
"} \\\n"
"while (x >= maxV || x < 0); \\\n"
"}\n"
"#ifdef BORDER_REFLECT\n"
"#define EXTRAPOLATE(x, maxV) EXTRAPOLATE_(x, maxV, 0)\n"
"#else\n"
"#define EXTRAPOLATE(x, maxV) EXTRAPOLATE_(x, maxV, 1)\n"
"#endif\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"#define THREADS 256\n"
"__kernel void calcHarris(__global const float *Dx, __global const float *Dy, __global float *dst,\n"
"int dx_offset, int dx_whole_rows, int dx_whole_cols, int dx_step,\n"
"int dy_offset, int dy_whole_rows, int dy_whole_cols, int dy_step,\n"
"int dst_offset, int dst_rows, int dst_cols, int dst_step, float k)\n"
"{\n"
"int col = get_local_id(0);\n"
"int gX = get_group_id(0);\n"
"int gY = get_group_id(1);\n"
"int gly = get_global_id(1);\n"
"int dx_x_off = (dx_offset % dx_step) >> 2;\n"
"int dx_y_off = dx_offset / dx_step;\n"
"int dy_x_off = (dy_offset % dy_step) >> 2;\n"
"int dy_y_off = dy_offset / dy_step;\n"
"int dst_x_off = (dst_offset % dst_step) >> 2;\n"
"int dst_y_off = dst_offset / dst_step;\n"
"int dx_startX = gX * (THREADS-ksX+1) - anX + dx_x_off;\n"
"int dx_startY = (gY << 1) - anY + dx_y_off;\n"
"int dy_startX = gX * (THREADS-ksX+1) - anX + dy_x_off;\n"
"int dy_startY = (gY << 1) - anY + dy_y_off;\n"
"int dst_startX = gX * (THREADS-ksX+1) + dst_x_off;\n"
"int dst_startY = (gY << 1) + dst_y_off;\n"
"float dx_data[ksY+1],dy_data[ksY+1], data[3][ksY+1];\n"
"__local FPTYPE temp[6][THREADS];\n"
"#ifdef BORDER_CONSTANT\n"
"for (int i=0; i < ksY+1; i++)\n"
"{\n"
"bool dx_con = dx_startX+col >= 0 && dx_startX+col < dx_whole_cols && dx_startY+i >= 0 && dx_startY+i < dx_whole_rows;\n"
"int indexDx = (dx_startY+i)*(dx_step>>2)+(dx_startX+col);\n"
"float dx_s = dx_con ? Dx[indexDx] : 0.0f;\n"
"dx_data[i] = dx_s;\n"
"bool dy_con = dy_startX+col >= 0 && dy_startX+col < dy_whole_cols && dy_startY+i >= 0 && dy_startY+i < dy_whole_rows;\n"
"int indexDy = (dy_startY+i)*(dy_step>>2)+(dy_startX+col);\n"
"float dy_s = dy_con ? Dy[indexDy] : 0.0f;\n"
"dy_data[i] = dy_s;\n"
"data[0][i] = dx_data[i] * dx_data[i];\n"
"data[1][i] = dx_data[i] * dy_data[i];\n"
"data[2][i] = dy_data[i] * dy_data[i];\n"
"}\n"
"#else\n"
"int clamped_col = min(2*dst_cols, col);\n"
"for (int i=0; i < ksY+1; i++)\n"
"{\n"
"int dx_selected_row = dx_startY+i, dx_selected_col = dx_startX+clamped_col;\n"
"EXTRAPOLATE(dx_selected_row, dx_whole_rows)\n"
"EXTRAPOLATE(dx_selected_col, dx_whole_cols)\n"
"dx_data[i] = Dx[dx_selected_row * (dx_step>>2) + dx_selected_col];\n"
"int dy_selected_row = dy_startY+i, dy_selected_col = dy_startX+clamped_col;\n"
"EXTRAPOLATE(dy_selected_row, dy_whole_rows)\n"
"EXTRAPOLATE(dy_selected_col, dy_whole_cols)\n"
"dy_data[i] = Dy[dy_selected_row * (dy_step>>2) + dy_selected_col];\n"
"data[0][i] = dx_data[i] * dx_data[i];\n"
"data[1][i] = dx_data[i] * dy_data[i];\n"
"data[2][i] = dy_data[i] * dy_data[i];\n"
"}\n"
"#endif\n"
"FPTYPE sum0 = 0.0f, sum1 = 0.0f, sum2 = 0.0f;\n"
"for (int i=1; i < ksY; i++)\n"
"{\n"
"sum0 += data[0][i];\n"
"sum1 += data[1][i];\n"
"sum2 += data[2][i];\n"
"}\n"
"FPTYPE sum01 = sum0 + data[0][0];\n"
"FPTYPE sum02 = sum0 + data[0][ksY];\n"
"temp[0][col] = sum01;\n"
"temp[1][col] = sum02;\n"
"FPTYPE sum11 = sum1 + data[1][0];\n"
"FPTYPE sum12 = sum1 + data[1][ksY];\n"
"temp[2][col] = sum11;\n"
"temp[3][col] = sum12;\n"
"FPTYPE sum21 = sum2 + data[2][0];\n"
"FPTYPE sum22 = sum2 + data[2][ksY];\n"
"temp[4][col] = sum21;\n"
"temp[5][col] = sum22;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (col < (THREADS- (ksX - 1)))\n"
"{\n"
"col += anX;\n"
"int posX = dst_startX - dst_x_off + col - anX;\n"
"int posY = (gly << 1);\n"
"int till = (ksX + 1)%2;\n"
"float tmp_sum[6] = { 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f };\n"
"for (int k=0; k<6; k++)\n"
"{\n"
"FPTYPE temp_sum = 0;\n"
"for (int i=-anX; i<=anX - till; i++)\n"
"{\n"
"temp_sum += temp[k][col+i];\n"
"}\n"
"tmp_sum[k] = temp_sum;\n"
"}\n"
"if (posX < dst_cols && (posY) < dst_rows)\n"
"{\n"
"dst[(dst_startY+0) * (dst_step>>2)+ dst_startX + col - anX] =\n"
"tmp_sum[0] * tmp_sum[4] - tmp_sum[2] * tmp_sum[2] - k * (tmp_sum[0] + tmp_sum[4]) * (tmp_sum[0] + tmp_sum[4]);\n"
"}\n"
"if (posX < dst_cols && (posY + 1) < dst_rows)\n"
"{\n"
"dst[(dst_startY+1) * (dst_step>>2)+ dst_startX + col - anX] =\n"
"tmp_sum[1] * tmp_sum[5] - tmp_sum[3] * tmp_sum[3] - k * (tmp_sum[1] + tmp_sum[5]) * (tmp_sum[1] + tmp_sum[5]);\n"
"}\n"
"}\n"
"}\n"
, "f2c0f92edc8f64eb31dc2f2034bc799f"};
const struct ProgramEntry imgproc_calcMinEigenVal={"imgproc_calcMinEigenVal",
"#ifdef BORDER_CONSTANT\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"x = max(min(x, maxV - 1), 0); \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"if (x < 0) \\\n"
"x -= ((x - maxV + 1) / maxV) * maxV; \\\n"
"if (x >= maxV) \\\n"
"x %= maxV; \\\n"
"}\n"
"#elif defined(BORDER_REFLECT) || defined(BORDER_REFLECT101)\n"
"#define EXTRAPOLATE_(x, maxV, delta) \\\n"
"{ \\\n"
"if (maxV == 1) \\\n"
"x = 0; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if ( x < 0 ) \\\n"
"x = -x - 1 + delta; \\\n"
"else \\\n"
"x = maxV - 1 - (x - maxV) - delta; \\\n"
"} \\\n"
"while (x >= maxV || x < 0); \\\n"
"}\n"
"#ifdef BORDER_REFLECT\n"
"#define EXTRAPOLATE(x, maxV) EXTRAPOLATE_(x, maxV, 0)\n"
"#else\n"
"#define EXTRAPOLATE(x, maxV) EXTRAPOLATE_(x, maxV, 1)\n"
"#endif\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"#define THREADS 256\n"
"__kernel void calcMinEigenVal(__global const float *Dx,__global const float *Dy, __global float *dst,\n"
"int dx_offset, int dx_whole_rows, int dx_whole_cols, int dx_step,\n"
"int dy_offset, int dy_whole_rows, int dy_whole_cols, int dy_step,\n"
"int dst_offset, int dst_rows, int dst_cols, int dst_step, float k)\n"
"{\n"
"int col = get_local_id(0);\n"
"int gX = get_group_id(0);\n"
"int gY = get_group_id(1);\n"
"int gly = get_global_id(1);\n"
"int dx_x_off = (dx_offset % dx_step) >> 2;\n"
"int dx_y_off = dx_offset / dx_step;\n"
"int dy_x_off = (dy_offset % dy_step) >> 2;\n"
"int dy_y_off = dy_offset / dy_step;\n"
"int dst_x_off = (dst_offset % dst_step) >> 2;\n"
"int dst_y_off = dst_offset / dst_step;\n"
"int dx_startX = gX * (THREADS-ksX+1) - anX + dx_x_off;\n"
"int dx_startY = (gY << 1) - anY + dx_y_off;\n"
"int dy_startX = gX * (THREADS-ksX+1) - anX + dy_x_off;\n"
"int dy_startY = (gY << 1) - anY + dy_y_off;\n"
"int dst_startX = gX * (THREADS-ksX+1) + dst_x_off;\n"
"int dst_startY = (gY << 1) + dst_y_off;\n"
"float dx_data[ksY+1], dy_data[ksY+1], data[3][ksY+1];\n"
"__local float temp[6][THREADS];\n"
"#ifdef BORDER_CONSTANT\n"
"for (int i=0; i < ksY+1; i++)\n"
"{\n"
"bool dx_con = dx_startX+col >= 0 && dx_startX+col < dx_whole_cols && dx_startY+i >= 0 && dx_startY+i < dx_whole_rows;\n"
"int indexDx = (dx_startY+i)*(dx_step>>2)+(dx_startX+col);\n"
"float dx_s = dx_con ? Dx[indexDx] : 0.0f;\n"
"dx_data[i] = dx_s;\n"
"bool dy_con = dy_startX+col >= 0 && dy_startX+col < dy_whole_cols && dy_startY+i >= 0 && dy_startY+i < dy_whole_rows;\n"
"int indexDy = (dy_startY+i)*(dy_step>>2)+(dy_startX+col);\n"
"float dy_s = dy_con ? Dy[indexDy] : 0.0f;\n"
"dy_data[i] = dy_s;\n"
"data[0][i] = dx_data[i] * dx_data[i];\n"
"data[1][i] = dx_data[i] * dy_data[i];\n"
"data[2][i] = dy_data[i] * dy_data[i];\n"
"}\n"
"#else\n"
"int clamped_col = min(dst_cols, col);\n"
"for (int i=0; i < ksY+1; i++)\n"
"{\n"
"int dx_selected_row = dx_startY+i, dx_selected_col = dx_startX+clamped_col;\n"
"EXTRAPOLATE(dx_selected_row, dx_whole_rows)\n"
"EXTRAPOLATE(dx_selected_col, dx_whole_cols)\n"
"dx_data[i] = Dx[dx_selected_row * (dx_step>>2) + dx_selected_col];\n"
"int dy_selected_row = dy_startY+i, dy_selected_col = dy_startX+clamped_col;\n"
"EXTRAPOLATE(dy_selected_row, dy_whole_rows)\n"
"EXTRAPOLATE(dy_selected_col, dy_whole_cols)\n"
"dy_data[i] = Dy[dy_selected_row * (dy_step>>2) + dy_selected_col];\n"
"data[0][i] = dx_data[i] * dx_data[i];\n"
"data[1][i] = dx_data[i] * dy_data[i];\n"
"data[2][i] = dy_data[i] * dy_data[i];\n"
"}\n"
"#endif\n"
"float sum0 = 0.0f, sum1 = 0.0f, sum2 = 0.0f;\n"
"for (int i=1; i < ksY; i++)\n"
"{\n"
"sum0 += (data[0][i]);\n"
"sum1 += (data[1][i]);\n"
"sum2 += (data[2][i]);\n"
"}\n"
"float sum01 = sum0 + (data[0][0]);\n"
"float sum02 = sum0 + (data[0][ksY]);\n"
"temp[0][col] = sum01;\n"
"temp[1][col] = sum02;\n"
"float sum11 = sum1 + (data[1][0]);\n"
"float sum12 = sum1 + (data[1][ksY]);\n"
"temp[2][col] = sum11;\n"
"temp[3][col] = sum12;\n"
"float sum21 = sum2 + (data[2][0]);\n"
"float sum22 = sum2 + (data[2][ksY]);\n"
"temp[4][col] = sum21;\n"
"temp[5][col] = sum22;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(col < (THREADS-(ksX-1)))\n"
"{\n"
"col += anX;\n"
"int posX = dst_startX - dst_x_off + col - anX;\n"
"int posY = (gly << 1);\n"
"int till = (ksX + 1)%2;\n"
"float tmp_sum[6] = { 0.0f, 0.0f , 0.0f, 0.0f, 0.0f, 0.0f };\n"
"for (int k=0; k<6; k++)\n"
"for (int i=-anX; i<=anX - till; i++)\n"
"tmp_sum[k] += temp[k][col+i];\n"
"if(posX < dst_cols && (posY) < dst_rows)\n"
"{\n"
"float a = tmp_sum[0] * 0.5f;\n"
"float b = tmp_sum[2];\n"
"float c = tmp_sum[4] * 0.5f;\n"
"dst[(dst_startY+0) * (dst_step>>2)+ dst_startX + col - anX] = (float)((a+c) - sqrt((a-c)*(a-c) + b*b));\n"
"}\n"
"if (posX < dst_cols && (posY + 1) < dst_rows)\n"
"{\n"
"float a = tmp_sum[1] * 0.5f;\n"
"float b = tmp_sum[3];\n"
"float c = tmp_sum[5] * 0.5f;\n"
"dst[(dst_startY+1) * (dst_step>>2)+ dst_startX + col - anX] = (float)((a+c) - sqrt((a-c)*(a-c) + b*b));\n"
"}\n"
"}\n"
"}\n"
, "af755a2a32c7b43016576fecac43fa29"};
const struct ProgramEntry imgproc_canny={"imgproc_canny",
"#ifdef L2GRAD\n"
"float calc(int x, int y)\n"
"{\n"
"return sqrt((float)(x * x + y * y));\n"
"}\n"
"#else\n"
"float calc(int x, int y)\n"
"{\n"
"return (float)abs(x) + abs(y);\n"
"}\n"
"#endif\n"
"__kernel\n"
"void\n"
"__attribute__((reqd_work_group_size(16,16,1)))\n"
"calcSobelRowPass\n"
"(\n"
"__global const uchar * src,\n"
"__global int * dx_buf,\n"
"__global int * dy_buf,\n"
"int rows,\n"
"int cols,\n"
"int src_step,\n"
"int src_offset,\n"
"int dx_buf_step,\n"
"int dx_buf_offset,\n"
"int dy_buf_step,\n"
"int dy_buf_offset\n"
")\n"
"{\n"
"dx_buf_step   /= sizeof(*dx_buf);\n"
"dx_buf_offset /= sizeof(*dx_buf);\n"
"dy_buf_step   /= sizeof(*dy_buf);\n"
"dy_buf_offset /= sizeof(*dy_buf);\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int lidx = get_local_id(0);\n"
"int lidy = get_local_id(1);\n"
"__local int smem[16][18];\n"
"smem[lidy][lidx + 1] =\n"
"src[gidx + min(gidy, rows - 1) * src_step + src_offset];\n"
"if(lidx == 0)\n"
"{\n"
"smem[lidy][0]  =\n"
"src[max(gidx - 1,  0)        + min(gidy, rows - 1) * src_step + src_offset];\n"
"smem[lidy][17] =\n"
"src[min(gidx + 16, cols - 1) + min(gidy, rows - 1) * src_step + src_offset];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(gidy < rows && gidx < cols)\n"
"{\n"
"dx_buf[gidx + gidy * dx_buf_step + dx_buf_offset] =\n"
"-smem[lidy][lidx] + smem[lidy][lidx + 2];\n"
"dy_buf[gidx + gidy * dy_buf_step + dy_buf_offset] =\n"
"smem[lidy][lidx] + 2 * smem[lidy][lidx + 1] + smem[lidy][lidx + 2];\n"
"}\n"
"}\n"
"__kernel\n"
"void\n"
"__attribute__((reqd_work_group_size(16,16,1)))\n"
"calcMagnitude_buf\n"
"(\n"
"__global const int * dx_buf,\n"
"__global const int * dy_buf,\n"
"__global int * dx,\n"
"__global int * dy,\n"
"__global float * mag,\n"
"int rows,\n"
"int cols,\n"
"int dx_buf_step,\n"
"int dx_buf_offset,\n"
"int dy_buf_step,\n"
"int dy_buf_offset,\n"
"int dx_step,\n"
"int dx_offset,\n"
"int dy_step,\n"
"int dy_offset,\n"
"int mag_step,\n"
"int mag_offset\n"
")\n"
"{\n"
"dx_buf_step    /= sizeof(*dx_buf);\n"
"dx_buf_offset  /= sizeof(*dx_buf);\n"
"dy_buf_step    /= sizeof(*dy_buf);\n"
"dy_buf_offset  /= sizeof(*dy_buf);\n"
"dx_step    /= sizeof(*dx);\n"
"dx_offset  /= sizeof(*dx);\n"
"dy_step    /= sizeof(*dy);\n"
"dy_offset  /= sizeof(*dy);\n"
"mag_step   /= sizeof(*mag);\n"
"mag_offset /= sizeof(*mag);\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int lidx = get_local_id(0);\n"
"int lidy = get_local_id(1);\n"
"__local int sdx[18][16];\n"
"__local int sdy[18][16];\n"
"sdx[lidy + 1][lidx] =\n"
"dx_buf[gidx + min(gidy, rows - 1) * dx_buf_step + dx_buf_offset];\n"
"sdy[lidy + 1][lidx] =\n"
"dy_buf[gidx + min(gidy, rows - 1) * dy_buf_step + dy_buf_offset];\n"
"if(lidy == 0)\n"
"{\n"
"sdx[0][lidx]  =\n"
"dx_buf[gidx + min(max(gidy-1,0),rows-1) * dx_buf_step + dx_buf_offset];\n"
"sdx[17][lidx] =\n"
"dx_buf[gidx + min(gidy + 16, rows - 1)  * dx_buf_step + dx_buf_offset];\n"
"sdy[0][lidx]  =\n"
"dy_buf[gidx + min(max(gidy-1,0),rows-1) * dy_buf_step + dy_buf_offset];\n"
"sdy[17][lidx] =\n"
"dy_buf[gidx + min(gidy + 16, rows - 1)  * dy_buf_step + dy_buf_offset];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(gidx < cols && gidy < rows)\n"
"{\n"
"int x =  sdx[lidy][lidx] + 2 * sdx[lidy + 1][lidx] + sdx[lidy + 2][lidx];\n"
"int y = -sdy[lidy][lidx] + sdy[lidy + 2][lidx];\n"
"dx[gidx + gidy * dx_step + dx_offset] = x;\n"
"dy[gidx + gidy * dy_step + dy_offset] = y;\n"
"mag[(gidx + 1) + (gidy + 1) * mag_step + mag_offset] = calc(x, y);\n"
"}\n"
"}\n"
"__kernel\n"
"void calcMagnitude\n"
"(\n"
"__global const int * dx,\n"
"__global const int * dy,\n"
"__global float * mag,\n"
"int rows,\n"
"int cols,\n"
"int dx_step,\n"
"int dx_offset,\n"
"int dy_step,\n"
"int dy_offset,\n"
"int mag_step,\n"
"int mag_offset\n"
")\n"
"{\n"
"dx_step    /= sizeof(*dx);\n"
"dx_offset  /= sizeof(*dx);\n"
"dy_step    /= sizeof(*dy);\n"
"dy_offset  /= sizeof(*dy);\n"
"mag_step   /= sizeof(*mag);\n"
"mag_offset /= sizeof(*mag);\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"if(gidy < rows && gidx < cols)\n"
"{\n"
"mag[(gidx + 1) + (gidy + 1) * mag_step + mag_offset] =\n"
"calc(\n"
"dx[gidx + gidy * dx_step + dx_offset],\n"
"dy[gidx + gidy * dy_step + dy_offset]\n"
");\n"
"}\n"
"}\n"
"#define CANNY_SHIFT 15\n"
"#ifdef DOUBLE_SUPPORT\n"
"#define TG22        (int)(0.4142135623730950488016887242097*(1<<CANNY_SHIFT) + 0.5)\n"
"#else\n"
"#define TG22        (int)(0.4142135623730950488016887242097f*(1<<CANNY_SHIFT) + 0.5f)\n"
"#endif\n"
"__kernel\n"
"void\n"
"__attribute__((reqd_work_group_size(16,16,1)))\n"
"calcMap\n"
"(\n"
"__global const int * dx,\n"
"__global const int * dy,\n"
"__global const float * mag,\n"
"__global int * map,\n"
"int rows,\n"
"int cols,\n"
"float low_thresh,\n"
"float high_thresh,\n"
"int dx_step,\n"
"int dx_offset,\n"
"int dy_step,\n"
"int dy_offset,\n"
"int mag_step,\n"
"int mag_offset,\n"
"int map_step,\n"
"int map_offset\n"
")\n"
"{\n"
"dx_step    /= sizeof(*dx);\n"
"dx_offset  /= sizeof(*dx);\n"
"dy_step    /= sizeof(*dy);\n"
"dy_offset  /= sizeof(*dy);\n"
"mag_step   /= sizeof(*mag);\n"
"mag_offset /= sizeof(*mag);\n"
"map_step   /= sizeof(*map);\n"
"map_offset /= sizeof(*map);\n"
"mag += mag_offset;\n"
"map += map_offset;\n"
"__local float smem[18][18];\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int lidx = get_local_id(0);\n"
"int lidy = get_local_id(1);\n"
"int grp_idx = get_global_id(0) & 0xFFFFF0;\n"
"int grp_idy = get_global_id(1) & 0xFFFFF0;\n"
"int tid = lidx + lidy * 16;\n"
"int lx = tid % 18;\n"
"int ly = tid / 18;\n"
"if(ly < 14)\n"
"{\n"
"smem[ly][lx] =\n"
"mag[grp_idx + lx + min(grp_idy + ly, rows - 1) * mag_step];\n"
"}\n"
"if(ly < 4 && grp_idy + ly + 14 <= rows && grp_idx + lx <= cols)\n"
"{\n"
"smem[ly + 14][lx] =\n"
"mag[grp_idx + lx + min(grp_idy + ly + 14, rows -1) * mag_step];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(gidy < rows && gidx < cols)\n"
"{\n"
"int x = dx[gidx + gidy * dx_step];\n"
"int y = dy[gidx + gidy * dy_step];\n"
"const int s = (x ^ y) < 0 ? -1 : 1;\n"
"const float m = smem[lidy + 1][lidx + 1];\n"
"x = abs(x);\n"
"y = abs(y);\n"
"int edge_type = 0;\n"
"if(m > low_thresh)\n"
"{\n"
"const int tg22x = x * TG22;\n"
"const int tg67x = tg22x + (x << (1 + CANNY_SHIFT));\n"
"y <<= CANNY_SHIFT;\n"
"if(y < tg22x)\n"
"{\n"
"if(m > smem[lidy + 1][lidx] && m >= smem[lidy + 1][lidx + 2])\n"
"{\n"
"edge_type = 1 + (int)(m > high_thresh);\n"
"}\n"
"}\n"
"else if (y > tg67x)\n"
"{\n"
"if(m > smem[lidy][lidx + 1]&& m >= smem[lidy + 2][lidx + 1])\n"
"{\n"
"edge_type = 1 + (int)(m > high_thresh);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if(m > smem[lidy][lidx + 1 - s]&& m > smem[lidy + 2][lidx + 1 + s])\n"
"{\n"
"edge_type = 1 + (int)(m > high_thresh);\n"
"}\n"
"}\n"
"}\n"
"map[gidx + 1 + (gidy + 1) * map_step] = edge_type;\n"
"}\n"
"}\n"
"#undef CANNY_SHIFT\n"
"#undef TG22\n"
"struct PtrStepSz {\n"
"__global int *ptr;\n"
"int step;\n"
"int rows, cols;\n"
"};\n"
"int get(struct PtrStepSz data, int y, int x) { return *((__global int *)((__global char*)data.ptr + data.step * (y + 1) + sizeof(int) * (x + 1))); }\n"
"void set(struct PtrStepSz data, int y, int x, int value) { *((__global int *)((__global char*)data.ptr + data.step * (y + 1) + sizeof(int) * (x + 1))) = value; }\n"
"__kernel\n"
"void\n"
"__attribute__((reqd_work_group_size(16,16,1)))\n"
"edgesHysteresisLocal\n"
"(\n"
"__global int * map_ptr,\n"
"__global ushort2 * st,\n"
"__global unsigned int * counter,\n"
"int rows,\n"
"int cols,\n"
"int map_step,\n"
"int map_offset\n"
")\n"
"{\n"
"#if 0\n"
"map_step   /= sizeof(*map);\n"
"map_offset /= sizeof(*map);\n"
"const __global int* map = map_ptr + map_offset;\n"
"__local int smem[18][18];\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int lidx = get_local_id(0);\n"
"int lidy = get_local_id(1);\n"
"int grp_idx = get_global_id(0) & 0xFFFFF0;\n"
"int grp_idy = get_global_id(1) & 0xFFFFF0;\n"
"int tid = lidx + lidy * 16;\n"
"int lx = tid % 18;\n"
"int ly = tid / 18;\n"
"if(ly < 14)\n"
"{\n"
"smem[ly][lx] =\n"
"map[grp_idx + lx + min(grp_idy + ly, rows - 1) * map_step];\n"
"}\n"
"if(ly < 4 && grp_idy + ly + 14 <= rows && grp_idx + lx <= cols)\n"
"{\n"
"smem[ly + 14][lx] =\n"
"map[grp_idx + lx + min(grp_idy + ly + 14, rows - 1) * map_step];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(gidy < rows && gidx < cols)\n"
"{\n"
"int n;\n"
"#pragma unroll\n"
"for (int k = 0; k < 16; ++k)\n"
"{\n"
"n = 0;\n"
"if (smem[lidy + 1][lidx + 1] == 1)\n"
"{\n"
"n += smem[lidy    ][lidx    ] == 2;\n"
"n += smem[lidy    ][lidx + 1] == 2;\n"
"n += smem[lidy    ][lidx + 2] == 2;\n"
"n += smem[lidy + 1][lidx    ] == 2;\n"
"n += smem[lidy + 1][lidx + 2] == 2;\n"
"n += smem[lidy + 2][lidx    ] == 2;\n"
"n += smem[lidy + 2][lidx + 1] == 2;\n"
"n += smem[lidy + 2][lidx + 2] == 2;\n"
"}\n"
"if (n > 0)\n"
"smem[lidy + 1][lidx + 1] = 2;\n"
"}\n"
"const int e = smem[lidy + 1][lidx + 1];\n"
"map[gidx + 1 + (gidy + 1) * map_step] = e;\n"
"n = 0;\n"
"if(e == 2)\n"
"{\n"
"n += smem[lidy    ][lidx    ] == 1;\n"
"n += smem[lidy    ][lidx + 1] == 1;\n"
"n += smem[lidy    ][lidx + 2] == 1;\n"
"n += smem[lidy + 1][lidx    ] == 1;\n"
"n += smem[lidy + 1][lidx + 2] == 1;\n"
"n += smem[lidy + 2][lidx    ] == 1;\n"
"n += smem[lidy + 2][lidx + 1] == 1;\n"
"n += smem[lidy + 2][lidx + 2] == 1;\n"
"}\n"
"if(n > 0)\n"
"{\n"
"unsigned int ind = atomic_inc(counter);\n"
"st[ind] = (ushort2)(gidx + 1, gidy + 1);\n"
"}\n"
"}\n"
"#else\n"
"struct PtrStepSz map = {((__global int *)((__global char*)map_ptr + map_offset)), map_step, rows + 1, cols + 1};\n"
"__local int smem[18][18];\n"
"int2 blockIdx = (int2)(get_group_id(0), get_group_id(1));\n"
"int2 blockDim = (int2)(get_local_size(0), get_local_size(1));\n"
"int2 threadIdx = (int2)(get_local_id(0), get_local_id(1));\n"
"const int x = blockIdx.x * blockDim.x + threadIdx.x;\n"
"const int y = blockIdx.y * blockDim.y + threadIdx.y;\n"
"smem[threadIdx.y + 1][threadIdx.x + 1] = x < map.cols && y < map.rows ? get(map, y, x) : 0;\n"
"if (threadIdx.y == 0)\n"
"smem[0][threadIdx.x + 1] = x < map.cols ? get(map, y - 1, x) : 0;\n"
"if (threadIdx.y == blockDim.y - 1)\n"
"smem[blockDim.y + 1][threadIdx.x + 1] = y + 1 < map.rows ? get(map, y + 1, x) : 0;\n"
"if (threadIdx.x == 0)\n"
"smem[threadIdx.y + 1][0] = y < map.rows ? get(map, y, x - 1) : 0;\n"
"if (threadIdx.x == blockDim.x - 1)\n"
"smem[threadIdx.y + 1][blockDim.x + 1] = x + 1 < map.cols && y < map.rows ? get(map, y, x + 1) : 0;\n"
"if (threadIdx.x == 0 && threadIdx.y == 0)\n"
"smem[0][0] = y > 0 && x > 0 ? get(map, y - 1, x - 1) : 0;\n"
"if (threadIdx.x == blockDim.x - 1 && threadIdx.y == 0)\n"
"smem[0][blockDim.x + 1] = y > 0 && x + 1 < map.cols ? get(map, y - 1, x + 1) : 0;\n"
"if (threadIdx.x == 0 && threadIdx.y == blockDim.y - 1)\n"
"smem[blockDim.y + 1][0] = y + 1 < map.rows && x > 0 ? get(map, y + 1, x - 1) : 0;\n"
"if (threadIdx.x == blockDim.x - 1 && threadIdx.y == blockDim.y - 1)\n"
"smem[blockDim.y + 1][blockDim.x + 1] = y + 1 < map.rows && x + 1 < map.cols ? get(map, y + 1, x + 1) : 0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (x >= cols || y >= rows)\n"
"return;\n"
"int n;\n"
"#pragma unroll\n"
"for (int k = 0; k < 16; ++k)\n"
"{\n"
"n = 0;\n"
"if (smem[threadIdx.y + 1][threadIdx.x + 1] == 1)\n"
"{\n"
"n += smem[threadIdx.y    ][threadIdx.x    ] == 2;\n"
"n += smem[threadIdx.y    ][threadIdx.x + 1] == 2;\n"
"n += smem[threadIdx.y    ][threadIdx.x + 2] == 2;\n"
"n += smem[threadIdx.y + 1][threadIdx.x    ] == 2;\n"
"n += smem[threadIdx.y + 1][threadIdx.x + 2] == 2;\n"
"n += smem[threadIdx.y + 2][threadIdx.x    ] == 2;\n"
"n += smem[threadIdx.y + 2][threadIdx.x + 1] == 2;\n"
"n += smem[threadIdx.y + 2][threadIdx.x + 2] == 2;\n"
"}\n"
"if (n > 0)\n"
"smem[threadIdx.y + 1][threadIdx.x + 1] = 2;\n"
"}\n"
"const int e = smem[threadIdx.y + 1][threadIdx.x + 1];\n"
"set(map, y, x, e);\n"
"n = 0;\n"
"if (e == 2)\n"
"{\n"
"n += smem[threadIdx.y    ][threadIdx.x    ] == 1;\n"
"n += smem[threadIdx.y    ][threadIdx.x + 1] == 1;\n"
"n += smem[threadIdx.y    ][threadIdx.x + 2] == 1;\n"
"n += smem[threadIdx.y + 1][threadIdx.x    ] == 1;\n"
"n += smem[threadIdx.y + 1][threadIdx.x + 2] == 1;\n"
"n += smem[threadIdx.y + 2][threadIdx.x    ] == 1;\n"
"n += smem[threadIdx.y + 2][threadIdx.x + 1] == 1;\n"
"n += smem[threadIdx.y + 2][threadIdx.x + 2] == 1;\n"
"}\n"
"if (n > 0)\n"
"{\n"
"const int ind = atomic_inc(counter);\n"
"st[ind] = (ushort2)(x + 1, y + 1);\n"
"}\n"
"#endif\n"
"}\n"
"__constant int c_dx[8] = {-1,  0,  1, -1, 1, -1, 0, 1};\n"
"__constant int c_dy[8] = {-1, -1, -1,  0, 0,  1, 1, 1};\n"
"#define stack_size 512\n"
"__kernel\n"
"void\n"
"__attribute__((reqd_work_group_size(128,1,1)))\n"
"edgesHysteresisGlobal\n"
"(\n"
"__global int * map,\n"
"__global ushort2 * st1,\n"
"__global ushort2 * st2,\n"
"__global int * counter,\n"
"int rows,\n"
"int cols,\n"
"int count,\n"
"int map_step,\n"
"int map_offset\n"
")\n"
"{\n"
"map_step   /= sizeof(*map);\n"
"map_offset /= sizeof(*map);\n"
"map += map_offset;\n"
"int lidx = get_local_id(0);\n"
"int grp_idx = get_group_id(0);\n"
"int grp_idy = get_group_id(1);\n"
"__local unsigned int s_counter;\n"
"__local unsigned int s_ind;\n"
"__local ushort2 s_st[stack_size];\n"
"if(lidx == 0)\n"
"{\n"
"s_counter = 0;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int ind = mad24(grp_idy, (int)get_local_size(0), grp_idx);\n"
"if(ind < count)\n"
"{\n"
"ushort2 pos = st1[ind];\n"
"if (lidx < 8)\n"
"{\n"
"pos.x += c_dx[lidx];\n"
"pos.y += c_dy[lidx];\n"
"if (pos.x > 0 && pos.x <= cols && pos.y > 0 && pos.y <= rows && map[pos.x + pos.y * map_step] == 1)\n"
"{\n"
"map[pos.x + pos.y * map_step] = 2;\n"
"ind = atomic_inc(&s_counter);\n"
"s_st[ind] = pos;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"while (s_counter > 0 && s_counter <= stack_size - get_local_size(0))\n"
"{\n"
"const int subTaskIdx = lidx >> 3;\n"
"const int portion = min(s_counter, (uint)(get_local_size(0)>> 3));\n"
"if (subTaskIdx < portion)\n"
"pos = s_st[s_counter - 1 - subTaskIdx];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lidx == 0)\n"
"s_counter -= portion;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (subTaskIdx < portion)\n"
"{\n"
"pos.x += c_dx[lidx & 7];\n"
"pos.y += c_dy[lidx & 7];\n"
"if (pos.x > 0 && pos.x <= cols && pos.y > 0 && pos.y <= rows && map[pos.x + pos.y * map_step] == 1)\n"
"{\n"
"map[pos.x + pos.y * map_step] = 2;\n"
"ind = atomic_inc(&s_counter);\n"
"s_st[ind] = pos;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"if (s_counter > 0)\n"
"{\n"
"if (lidx == 0)\n"
"{\n"
"ind = atomic_add(counter, s_counter);\n"
"s_ind = ind - s_counter;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"ind = s_ind;\n"
"for (int i = lidx; i < (int)s_counter; i += get_local_size(0))\n"
"{\n"
"st2[ind + i] = s_st[i];\n"
"}\n"
"}\n"
"}\n"
"}\n"
"#undef stack_size\n"
"__kernel\n"
"void getEdges\n"
"(\n"
"__global const int * map,\n"
"__global uchar * dst,\n"
"int rows,\n"
"int cols,\n"
"int map_step,\n"
"int map_offset,\n"
"int dst_step,\n"
"int dst_offset\n"
")\n"
"{\n"
"map_step   /= sizeof(*map);\n"
"map_offset /= sizeof(*map);\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"if(gidy < rows && gidx < cols)\n"
"{\n"
"dst[gidx + gidy * dst_step] = (uchar)(-(map[gidx + 1 + (gidy + 1) * map_step + map_offset] >> 1));\n"
"}\n"
"}\n"
, "917a8bcd294871fe5c17dc71f6d660e8"};
const struct ProgramEntry imgproc_clahe={"imgproc_clahe",
"#ifndef WAVE_SIZE\n"
"#define WAVE_SIZE 1\n"
"#endif\n"
"int calc_lut(__local int* smem, int val, int tid)\n"
"{\n"
"smem[tid] = val;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid == 0)\n"
"for (int i = 1; i < 256; ++i)\n"
"smem[i] += smem[i - 1];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"return smem[tid];\n"
"}\n"
"#ifdef CPU\n"
"void reduce(volatile __local int* smem, int val, int tid)\n"
"{\n"
"smem[tid] = val;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 128)\n"
"smem[tid] = val += smem[tid + 128];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 64)\n"
"smem[tid] = val += smem[tid + 64];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 32)\n"
"smem[tid] += smem[tid + 32];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 16)\n"
"smem[tid] += smem[tid + 16];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 8)\n"
"smem[tid] += smem[tid + 8];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 4)\n"
"smem[tid] += smem[tid + 4];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 2)\n"
"smem[tid] += smem[tid + 2];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 1)\n"
"smem[256] = smem[tid] + smem[tid + 1];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"#else\n"
"void reduce(__local volatile int* smem, int val, int tid)\n"
"{\n"
"smem[tid] = val;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 128)\n"
"smem[tid] = val += smem[tid + 128];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 64)\n"
"smem[tid] = val += smem[tid + 64];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 32)\n"
"{\n"
"smem[tid] += smem[tid + 32];\n"
"#if WAVE_SIZE < 32\n"
"} barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 16)\n"
"{\n"
"#endif\n"
"smem[tid] += smem[tid + 16];\n"
"#if WAVE_SIZE < 16\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 8)\n"
"{\n"
"#endif\n"
"smem[tid] += smem[tid + 8];\n"
"smem[tid] += smem[tid + 4];\n"
"smem[tid] += smem[tid + 2];\n"
"smem[tid] += smem[tid + 1];\n"
"}\n"
"}\n"
"#endif\n"
"__kernel void calcLut(__global __const uchar * src, __global uchar * lut,\n"
"const int srcStep, const int dstStep,\n"
"const int2 tileSize, const int tilesX,\n"
"const int clipLimit, const float lutScale,\n"
"const int src_offset, const int dst_offset)\n"
"{\n"
"__local int smem[512];\n"
"int tx = get_group_id(0);\n"
"int ty = get_group_id(1);\n"
"int tid = get_local_id(1) * get_local_size(0)\n"
"+ get_local_id(0);\n"
"smem[tid] = 0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for (int i = get_local_id(1); i < tileSize.y; i += get_local_size(1))\n"
"{\n"
"__global const uchar* srcPtr = src + mad24(ty * tileSize.y + i, srcStep, tx * tileSize.x + src_offset);\n"
"for (int j = get_local_id(0); j < tileSize.x; j += get_local_size(0))\n"
"{\n"
"const int data = srcPtr[j];\n"
"atomic_inc(&smem[data]);\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int tHistVal = smem[tid];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (clipLimit > 0)\n"
"{\n"
"int clipped = 0;\n"
"if (tHistVal > clipLimit)\n"
"{\n"
"clipped = tHistVal - clipLimit;\n"
"tHistVal = clipLimit;\n"
"}\n"
"reduce(smem, clipped, tid);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"#ifdef CPU\n"
"clipped = smem[256];\n"
"#else\n"
"clipped = smem[0];\n"
"#endif\n"
"__local int totalClipped;\n"
"if (tid == 0)\n"
"totalClipped = clipped;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int redistBatch = totalClipped / 256;\n"
"tHistVal += redistBatch;\n"
"int residual = totalClipped - redistBatch * 256;\n"
"if (tid < residual)\n"
"++tHistVal;\n"
"}\n"
"const int lutVal = calc_lut(smem, tHistVal, tid);\n"
"uint ires = (uint)convert_int_rte(lutScale * lutVal);\n"
"lut[(ty * tilesX + tx) * dstStep + tid + dst_offset] =\n"
"convert_uchar(clamp(ires, (uint)0, (uint)255));\n"
"}\n"
"__kernel void transform(__global __const uchar * src,\n"
"__global uchar * dst,\n"
"__global uchar * lut,\n"
"const int srcStep, const int dstStep, const int lutStep,\n"
"const int cols, const int rows,\n"
"const int2 tileSize,\n"
"const int tilesX, const int tilesY,\n"
"const int src_offset, const int dst_offset, int lut_offset)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_global_id(1);\n"
"if (x >= cols || y >= rows)\n"
"return;\n"
"const float tyf = (convert_float(y) / tileSize.y) - 0.5f;\n"
"int ty1 = convert_int_rtn(tyf);\n"
"int ty2 = ty1 + 1;\n"
"const float ya = tyf - ty1;\n"
"ty1 = max(ty1, 0);\n"
"ty2 = min(ty2, tilesY - 1);\n"
"const float txf = (convert_float(x) / tileSize.x) - 0.5f;\n"
"int tx1 = convert_int_rtn(txf);\n"
"int tx2 = tx1 + 1;\n"
"const float xa = txf - tx1;\n"
"tx1 = max(tx1, 0);\n"
"tx2 = min(tx2, tilesX - 1);\n"
"const int srcVal = src[mad24(y, srcStep, x + src_offset)];\n"
"float res = 0;\n"
"res += lut[mad24(ty1 * tilesX + tx1, lutStep, srcVal + lut_offset)] * ((1.0f - xa) * (1.0f - ya));\n"
"res += lut[mad24(ty1 * tilesX + tx2, lutStep, srcVal + lut_offset)] * ((xa) * (1.0f - ya));\n"
"res += lut[mad24(ty2 * tilesX + tx1, lutStep, srcVal + lut_offset)] * ((1.0f - xa) * (ya));\n"
"res += lut[mad24(ty2 * tilesX + tx2, lutStep, srcVal + lut_offset)] * ((xa) * (ya));\n"
"uint ires = (uint)convert_int_rte(res);\n"
"dst[mad24(y, dstStep, x + dst_offset)] = convert_uchar(clamp(ires, (uint)0, (uint)255));\n"
"}\n"
, "8b121e325b7df292f7ca7b394daddbbe"};
const struct ProgramEntry imgproc_columnsum={"imgproc_columnsum",
"__kernel void columnSum_C1_D5(__global float * src, __global float * dst,\n"
"int cols, int rows, int src_step, int dst_step, int src_offset, int dst_offset)\n"
"{\n"
"const int x = get_global_id(0);\n"
"if (x < cols)\n"
"{\n"
"int srcIdx = x + src_offset;\n"
"int dstIdx = x + dst_offset;\n"
"float sum = 0;\n"
"for (int y = 0; y < rows; ++y)\n"
"{\n"
"sum += src[srcIdx];\n"
"dst[dstIdx] = sum;\n"
"srcIdx += src_step;\n"
"dstIdx += dst_step;\n"
"}\n"
"}\n"
"}\n"
, "b6c673aadf09dcda2c42262f9d0d8f40"};
const struct ProgramEntry imgproc_convolve={"imgproc_convolve",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void convolve_D5(__global float *src, __global float *temp1, __global float *dst,\n"
"int rows, int cols, int src_step, int dst_step,int k_step, int kWidth, int kHeight,\n"
"int src_offset, int dst_offset, int koffset)\n"
"{\n"
"__local float smem[16 + 2 * 8][16 + 2 * 8];\n"
"int x = get_local_id(0);\n"
"int y = get_local_id(1);\n"
"int gx = get_global_id(0);\n"
"int gy = get_global_id(1);\n"
"smem[y][x] = src[min(max(gy - 8, 0), rows - 1) * src_step + min(max(gx - 8, 0), cols - 1) + src_offset];\n"
"smem[y][x + 16] = src[min(max(gy - 8, 0), rows - 1) * src_step + min(gx + 8, cols - 1) + src_offset];\n"
"smem[y + 16][x] = src[min(gy + 8, rows - 1) * src_step + min(max(gx - 8, 0), cols - 1) + src_offset];\n"
"smem[y + 16][x + 16] = src[min(gy + 8, rows - 1) * src_step + min(gx + 8, cols - 1) + src_offset];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (gx < cols && gy < rows)\n"
"{\n"
"float res = 0;\n"
"for (int i = 0; i < kHeight; ++i)\n"
"for (int j = 0; j < kWidth; ++j)\n"
"res += smem[y + 8 - kHeight / 2 + i][x + 8 - kWidth / 2 + j] * temp1[i * k_step + j + koffset];\n"
"dst[gy * dst_step + gx + dst_offset] = res;\n"
"}\n"
"}\n"
, "f7190f8357538986dbf934323c735bd8"};
const struct ProgramEntry imgproc_copymakeboder={"imgproc_copymakeboder",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#ifdef BORDER_CONSTANT\n"
"#define EXTRAPOLATE(x, y, v) v = scalar;\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(x, y, v) \\\n"
"{ \\\n"
"x = max(min(x, src_cols - 1), 0); \\\n"
"y = max(min(y, src_rows - 1), 0); \\\n"
"v = src[mad24(y, src_step, x + src_offset)]; \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(x, y, v) \\\n"
"{ \\\n"
"if (x < 0) \\\n"
"x -= ((x - src_cols + 1) / src_cols) * src_cols; \\\n"
"if (x >= src_cols) \\\n"
"x %= src_cols; \\\n"
"\\\n"
"if (y < 0) \\\n"
"y -= ((y - src_rows + 1) / src_rows) * src_rows; \\\n"
"if( y >= src_rows ) \\\n"
"y %= src_rows; \\\n"
"v = src[mad24(y, src_step, x + src_offset)]; \\\n"
"}\n"
"#elif defined(BORDER_REFLECT) || defined(BORDER_REFLECT_101)\n"
"#ifdef BORDER_REFLECT\n"
"#define DELTA int delta = 0\n"
"#else\n"
"#define DELTA int delta = 1\n"
"#endif\n"
"#define EXTRAPOLATE(x, y, v) \\\n"
"{ \\\n"
"DELTA; \\\n"
"if (src_cols == 1) \\\n"
"x = 0; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if( x < 0 ) \\\n"
"x = -x - 1 + delta; \\\n"
"else \\\n"
"x = src_cols - 1 - (x - src_cols) - delta; \\\n"
"} \\\n"
"while (x >= src_cols || x < 0); \\\n"
"\\\n"
"if (src_rows == 1) \\\n"
"y = 0; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if( y < 0 ) \\\n"
"y = -y - 1 + delta; \\\n"
"else \\\n"
"y = src_rows - 1 - (y - src_rows) - delta; \\\n"
"} \\\n"
"while (y >= src_rows || y < 0); \\\n"
"v = src[mad24(y, src_step, x + src_offset)]; \\\n"
"}\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"#define NEED_EXTRAPOLATION(gx, gy) (gx >= src_cols || gy >= src_rows || gx < 0 || gy < 0)\n"
"__kernel void copymakeborder\n"
"(__global const GENTYPE *src,\n"
"__global GENTYPE *dst,\n"
"int dst_cols, int dst_rows,\n"
"int src_cols, int src_rows,\n"
"int src_step, int src_offset,\n"
"int dst_step, int dst_offset,\n"
"int top, int left, GENTYPE scalar)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"int src_x = x - left;\n"
"int src_y = y - top;\n"
"int dst_index = mad24(y, dst_step, x + dst_offset);\n"
"if (NEED_EXTRAPOLATION(src_x, src_y))\n"
"EXTRAPOLATE(src_x, src_y, dst[dst_index])\n"
"else\n"
"{\n"
"int src_index = mad24(src_y, src_step, src_x + src_offset);\n"
"dst[dst_index] = src[src_index];\n"
"}\n"
"}\n"
"}\n"
, "d7165bbf10e602973a40db33d5cfc4ad"};
const struct ProgramEntry imgproc_gftt={"imgproc_gftt",
"#ifndef WITH_MASK\n"
"#define WITH_MASK 0\n"
"#endif\n"
"#define GET_SRC_32F(_x, _y) ((__global const float*)(eig + (_y)*eig_pitch))[_x]\n"
"__kernel\n"
"void findCorners\n"
"(\n"
"__global const char*    eig,\n"
"const int               eig_pitch,\n"
"__global const char*    mask,\n"
"__global float2*        corners,\n"
"const int               mask_strip,\n"
"__global const float*   pMinMax,\n"
"const float             qualityLevel,\n"
"const int               rows,\n"
"const int               cols,\n"
"const int               max_count,\n"
"__global int*           g_counter\n"
")\n"
"{\n"
"float threshold = qualityLevel*pMinMax[1];\n"
"const int j = get_global_id(0);\n"
"const int i = get_global_id(1);\n"
"if (i > 0 && i < rows - 1 && j > 0 && j < cols - 1\n"
"#if WITH_MASK\n"
"&& mask[i * mask_strip + j] != 0\n"
"#endif\n"
")\n"
"{\n"
"const float val = GET_SRC_32F(j, i);\n"
"if (val > threshold)\n"
"{\n"
"float maxVal = val;\n"
"maxVal = fmax(GET_SRC_32F(j - 1, i - 1), maxVal);\n"
"maxVal = fmax(GET_SRC_32F(j    , i - 1), maxVal);\n"
"maxVal = fmax(GET_SRC_32F(j + 1, i - 1), maxVal);\n"
"maxVal = fmax(GET_SRC_32F(j - 1, i), maxVal);\n"
"maxVal = fmax(GET_SRC_32F(j + 1, i), maxVal);\n"
"maxVal = fmax(GET_SRC_32F(j - 1, i + 1), maxVal);\n"
"maxVal = fmax(GET_SRC_32F(j    , i + 1), maxVal);\n"
"maxVal = fmax(GET_SRC_32F(j + 1, i + 1), maxVal);\n"
"if (val == maxVal)\n"
"{\n"
"const int ind = atomic_inc(g_counter);\n"
"if (ind < max_count)\n"
"{\n"
"corners[ind].x = val;\n"
"corners[ind].y = as_float(j|(i<<16));\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"#undef GET_SRC_32F\n"
"__kernel\n"
"void sortCorners_bitonicSort\n"
"(\n"
"__global float2 * corners,\n"
"const int count,\n"
"const int stage,\n"
"const int passOfStage\n"
")\n"
"{\n"
"const int threadId = get_global_id(0);\n"
"if(threadId >= count / 2)\n"
"{\n"
"return;\n"
"}\n"
"const int sortOrder = (((threadId/(1 << stage)) % 2)) == 1 ? 1 : 0;\n"
"const int pairDistance = 1 << (stage - passOfStage);\n"
"const int blockWidth   = 2 * pairDistance;\n"
"const int leftId = min( (threadId % pairDistance)\n"
"+ (threadId / pairDistance) * blockWidth, count );\n"
"const int rightId = min( leftId + pairDistance, count );\n"
"const float2 leftPt  = corners[leftId];\n"
"const float2 rightPt = corners[rightId];\n"
"const float leftVal  = leftPt.x;\n"
"const float rightVal = rightPt.x;\n"
"const bool compareResult = leftVal > rightVal;\n"
"float2 greater = compareResult ? leftPt:rightPt;\n"
"float2 lesser  = compareResult ? rightPt:leftPt;\n"
"corners[leftId]  = sortOrder ? lesser : greater;\n"
"corners[rightId] = sortOrder ? greater : lesser;\n"
"}\n"
"__kernel void arithm_op_minMax_final(__global float * data, int groupnum,__global int * g_counter)\n"
"{\n"
"g_counter[0] = 0;\n"
"float minVal = data[0];\n"
"float maxVal = data[groupnum];\n"
"for(int i=1;i<groupnum;++i)\n"
"{\n"
"minVal = min(minVal,data[i]);\n"
"maxVal = max(maxVal,data[i+groupnum]);\n"
"}\n"
"data[0] = minVal;\n"
"data[1] = maxVal;\n"
"}\n"
, "465db4ad20d408ebbb09576d85e4c452"};
const struct ProgramEntry imgproc_histogram={"imgproc_histogram",
"#define PARTIAL_HISTOGRAM256_COUNT     (256)\n"
"#define HISTOGRAM256_BIN_COUNT         (256)\n"
"#define HISTOGRAM256_WORK_GROUP_SIZE     (256)\n"
"#define HISTOGRAM256_LOCAL_MEM_SIZE      (HISTOGRAM256_BIN_COUNT)\n"
"#define NBANKS (16)\n"
"#define NBANKS_BIT (4)\n"
"__kernel __attribute__((reqd_work_group_size(HISTOGRAM256_BIN_COUNT,1,1)))void calc_sub_hist_D0(\n"
"__global const uint4* src,\n"
"int src_step, int src_offset,\n"
"__global int* globalHist,\n"
"int dataCount,  int cols,\n"
"int inc_x, int inc_y,\n"
"int hist_step)\n"
"{\n"
"__local int subhist[(HISTOGRAM256_BIN_COUNT << NBANKS_BIT)];\n"
"int gid = get_global_id(0);\n"
"int lid = get_local_id(0);\n"
"int gx  = get_group_id(0);\n"
"int gsize = get_global_size(0);\n"
"int lsize  = get_local_size(0);\n"
"const int shift = 8;\n"
"const int mask = HISTOGRAM256_BIN_COUNT-1;\n"
"int offset = (lid & (NBANKS-1));\n"
"uint4 data, temp1, temp2, temp3, temp4;\n"
"src += src_offset;\n"
"for(int i=0, idx=lid; i<(NBANKS >> 2); i++, idx += lsize)\n"
"{\n"
"subhist[idx] = 0;\n"
"subhist[idx+=lsize] = 0;\n"
"subhist[idx+=lsize] = 0;\n"
"subhist[idx+=lsize] = 0;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int y = gid/cols;\n"
"int x = gid - mul24(y, cols);\n"
"for(int idx=gid; idx<dataCount; idx+=gsize)\n"
"{\n"
"data = src[mad24(y, src_step, x)];\n"
"temp1 = ((data & mask) << NBANKS_BIT) + offset;\n"
"data >>= shift;\n"
"temp2 = ((data & mask) << NBANKS_BIT) + offset;\n"
"data >>= shift;\n"
"temp3 = ((data & mask) << NBANKS_BIT) + offset;\n"
"data >>= shift;\n"
"temp4 = ((data & mask) << NBANKS_BIT) + offset;\n"
"atomic_inc(subhist + temp1.x);\n"
"atomic_inc(subhist + temp1.y);\n"
"atomic_inc(subhist + temp1.z);\n"
"atomic_inc(subhist + temp1.w);\n"
"atomic_inc(subhist + temp2.x);\n"
"atomic_inc(subhist + temp2.y);\n"
"atomic_inc(subhist + temp2.z);\n"
"atomic_inc(subhist + temp2.w);\n"
"atomic_inc(subhist + temp3.x);\n"
"atomic_inc(subhist + temp3.y);\n"
"atomic_inc(subhist + temp3.z);\n"
"atomic_inc(subhist + temp3.w);\n"
"atomic_inc(subhist + temp4.x);\n"
"atomic_inc(subhist + temp4.y);\n"
"atomic_inc(subhist + temp4.z);\n"
"atomic_inc(subhist + temp4.w);\n"
"x += inc_x;\n"
"int off = ((x>=cols) ? -1 : 0);\n"
"x = mad24(off, cols, x);\n"
"y += inc_y - off;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int bin1=0, bin2=0, bin3=0, bin4=0;\n"
"for(int i=0; i<NBANKS; i+=4)\n"
"{\n"
"bin1 += subhist[(lid << NBANKS_BIT) + i];\n"
"bin2 += subhist[(lid << NBANKS_BIT) + i+1];\n"
"bin3 += subhist[(lid << NBANKS_BIT) + i+2];\n"
"bin4 += subhist[(lid << NBANKS_BIT) + i+3];\n"
"}\n"
"globalHist[mad24(gx, hist_step, lid)] = bin1+bin2+bin3+bin4;\n"
"}\n"
"__kernel void __attribute__((reqd_work_group_size(1,HISTOGRAM256_BIN_COUNT,1)))\n"
"calc_sub_hist_border_D0(__global const uchar* src, int src_step, int src_offset,\n"
"__global int* globalHist, int left_col, int cols,\n"
"int rows, int hist_step)\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int lidy = get_local_id(1);\n"
"int gx = get_group_id(0);\n"
"int gy = get_group_id(1);\n"
"int gn = get_num_groups(0);\n"
"int rowIndex = mad24(gy, gn, gx);\n"
"__local int subhist[HISTOGRAM256_LOCAL_MEM_SIZE];\n"
"subhist[lidy] = 0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"gidx = ((gidx>=left_col) ? (gidx+cols) : gidx);\n"
"if(gidy<rows)\n"
"{\n"
"int src_index = src_offset + mad24(gidy, src_step, gidx);\n"
"int p = (int)src[src_index];\n"
"atomic_inc(subhist + p);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"globalHist[mad24(rowIndex, hist_step, lidy)] += subhist[lidy];\n"
"}\n"
"__kernel __attribute__((reqd_work_group_size(256,1,1)))void merge_hist(__global int* buf,\n"
"__global int* hist,\n"
"int src_step)\n"
"{\n"
"int lx = get_local_id(0);\n"
"int gx = get_group_id(0);\n"
"int sum = 0;\n"
"for(int i = lx; i < PARTIAL_HISTOGRAM256_COUNT; i += HISTOGRAM256_WORK_GROUP_SIZE)\n"
"sum += buf[ mad24(i, src_step, gx)];\n"
"__local int data[HISTOGRAM256_WORK_GROUP_SIZE];\n"
"data[lx] = sum;\n"
"for(int stride = HISTOGRAM256_WORK_GROUP_SIZE /2; stride > 0; stride >>= 1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lx < stride)\n"
"data[lx] += data[lx + stride];\n"
"}\n"
"if(lx == 0)\n"
"hist[gx] = data[0];\n"
"}\n"
"__kernel __attribute__((reqd_work_group_size(256,1,1)))\n"
"void calLUT(__global uchar * dst, __constant int * hist, int total)\n"
"{\n"
"int lid = get_local_id(0);\n"
"__local int sumhist[HISTOGRAM256_BIN_COUNT];\n"
"__local float scale;\n"
"sumhist[lid] = hist[lid];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (lid == 0)\n"
"{\n"
"int sum = 0, i = 0;\n"
"while (!sumhist[i])\n"
"++i;\n"
"if (total == sumhist[i])\n"
"{\n"
"scale = 1;\n"
"for (int j = 0; j < HISTOGRAM256_BIN_COUNT; ++j)\n"
"sumhist[i] = i;\n"
"}\n"
"else\n"
"{\n"
"scale = 255.f/(total - sumhist[i]);\n"
"for (sumhist[i++] = 0; i < HISTOGRAM256_BIN_COUNT; i++)\n"
"{\n"
"sum += sumhist[i];\n"
"sumhist[i] = sum;\n"
"}\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"dst[lid]= convert_uchar_sat_rte(convert_float(sumhist[lid])*scale);\n"
"}\n"
, "c7700f9857976933b98297cf20dfc711"};
const struct ProgramEntry imgproc_integral={"imgproc_integral",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#define LSIZE 256\n"
"#define LSIZE_1 255\n"
"#define LSIZE_2 254\n"
"#define HF_LSIZE 128\n"
"#define LOG_LSIZE 8\n"
"#define LOG_NUM_BANKS 5\n"
"#define NUM_BANKS 32\n"
"#define GET_CONFLICT_OFFSET(lid) ((lid) >> LOG_NUM_BANKS)\n"
"kernel void integral_cols_D4(__global uchar4 *src,__global int *sum ,__global float *sqsum,\n"
"int src_offset,int pre_invalid,int rows,int cols,int src_step,int dst_step)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"int4 src_t[2], sum_t[2];\n"
"float4 sqsum_t[2];\n"
"__local int4 lm_sum[2][LSIZE + LOG_LSIZE];\n"
"__local float4 lm_sqsum[2][LSIZE + LOG_LSIZE];\n"
"__local int* sum_p;\n"
"__local float* sqsum_p;\n"
"src_step = src_step >> 2;\n"
"gid = gid << 1;\n"
"for(int i = 0; i < rows; i =i + LSIZE_1)\n"
"{\n"
"src_t[0] = (i + lid < rows ? convert_int4(src[src_offset + (lid+i) * src_step + min(gid, cols - 1)]) : 0);\n"
"src_t[1] = (i + lid < rows ? convert_int4(src[src_offset + (lid+i) * src_step + min(gid + 1, cols - 1)]) : 0);\n"
"sum_t[0] = (i == 0 ? 0 : lm_sum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sqsum_t[0] = (i == 0 ? (float4)0 : lm_sqsum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sum_t[1] =  (i == 0 ? 0 : lm_sum[1][LSIZE_2 + LOG_LSIZE]);\n"
"sqsum_t[1] =  (i == 0 ? (float4)0 : lm_sqsum[1][LSIZE_2 + LOG_LSIZE]);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int bf_loc = lid + GET_CONFLICT_OFFSET(lid);\n"
"lm_sum[0][bf_loc] = src_t[0];\n"
"lm_sqsum[0][bf_loc] = convert_float4(src_t[0] * src_t[0]);\n"
"lm_sum[1][bf_loc] = src_t[1];\n"
"lm_sqsum[1][bf_loc] = convert_float4(src_t[1] * src_t[1]);\n"
"int offset = 1;\n"
"for(int d = LSIZE >> 1 ;  d > 0; d>>=1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi]  +=  lm_sum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][bi]  +=  lm_sqsum[lid >> 7][ai];\n"
"}\n"
"offset <<= 1;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid < 2)\n"
"{\n"
"lm_sum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"lm_sqsum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"}\n"
"for(int d = 1;  d < LSIZE; d <<= 1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"offset >>= 1;\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi] += lm_sum[lid >> 7][ai];\n"
"lm_sum[lid >> 7][ai] = lm_sum[lid >> 7][bi] - lm_sum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][bi] += lm_sqsum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][ai] = lm_sqsum[lid >> 7][bi] - lm_sqsum[lid >> 7][ai];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int loc_s0 = gid * dst_step + i + lid - 1 - pre_invalid * dst_step / 4, loc_s1 = loc_s0 + dst_step ;\n"
"if(lid > 0 && (i+lid) <= rows)\n"
"{\n"
"lm_sum[0][bf_loc] += sum_t[0];\n"
"lm_sum[1][bf_loc] += sum_t[1];\n"
"lm_sqsum[0][bf_loc] += sqsum_t[0];\n"
"lm_sqsum[1][bf_loc] += sqsum_t[1];\n"
"sum_p = (__local int*)(&(lm_sum[0][bf_loc]));\n"
"sqsum_p = (__local float*)(&(lm_sqsum[0][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 4 + k >= cols + pre_invalid || gid * 4 + k < pre_invalid) continue;\n"
"sum[loc_s0 + k * dst_step / 4] = sum_p[k];\n"
"sqsum[loc_s0 + k * dst_step / 4] = sqsum_p[k];\n"
"}\n"
"sum_p = (__local int*)(&(lm_sum[1][bf_loc]));\n"
"sqsum_p = (__local float*)(&(lm_sqsum[1][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 4 + k + 4 >= cols + pre_invalid) break;\n"
"sum[loc_s1 + k * dst_step / 4] = sum_p[k];\n"
"sqsum[loc_s1 + k * dst_step / 4] = sqsum_p[k];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"kernel void integral_rows_D4(__global int4 *srcsum,__global float4 * srcsqsum,__global int *sum ,\n"
"__global float *sqsum,int rows,int cols,int src_step,int sum_step,\n"
"int sqsum_step,int sum_offset,int sqsum_offset)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"int4 src_t[2], sum_t[2];\n"
"float4 sqsrc_t[2],sqsum_t[2];\n"
"__local int4 lm_sum[2][LSIZE + LOG_LSIZE];\n"
"__local float4 lm_sqsum[2][LSIZE + LOG_LSIZE];\n"
"__local int *sum_p;\n"
"__local float *sqsum_p;\n"
"src_step = src_step >> 4;\n"
"for(int i = 0; i < rows; i =i + LSIZE_1)\n"
"{\n"
"src_t[0] = i + lid < rows ? srcsum[(lid+i) * src_step + gid * 2] : (int4)0;\n"
"sqsrc_t[0] = i + lid < rows ? srcsqsum[(lid+i) * src_step + gid * 2] : (float4)0;\n"
"src_t[1] = i + lid < rows ? srcsum[(lid+i) * src_step + gid * 2 + 1] : (int4)0;\n"
"sqsrc_t[1] = i + lid < rows ? srcsqsum[(lid+i) * src_step + gid * 2 + 1] : (float4)0;\n"
"sum_t[0] =  (i == 0 ? 0 : lm_sum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sqsum_t[0] =  (i == 0 ? (float4)0 : lm_sqsum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sum_t[1] =  (i == 0 ? 0 : lm_sum[1][LSIZE_2 + LOG_LSIZE]);\n"
"sqsum_t[1] =  (i == 0 ? (float4)0 : lm_sqsum[1][LSIZE_2 + LOG_LSIZE]);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int bf_loc = lid + GET_CONFLICT_OFFSET(lid);\n"
"lm_sum[0][bf_loc] = src_t[0];\n"
"lm_sqsum[0][bf_loc] = sqsrc_t[0];\n"
"lm_sum[1][bf_loc] = src_t[1];\n"
"lm_sqsum[1][bf_loc] = sqsrc_t[1];\n"
"int offset = 1;\n"
"for(int d = LSIZE >> 1 ;  d > 0; d>>=1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi]  +=  lm_sum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][bi]  +=  lm_sqsum[lid >> 7][ai];\n"
"}\n"
"offset <<= 1;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid < 2)\n"
"{\n"
"lm_sum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"lm_sqsum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"}\n"
"for(int d = 1;  d < LSIZE; d <<= 1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"offset >>= 1;\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi] += lm_sum[lid >> 7][ai];\n"
"lm_sum[lid >> 7][ai] = lm_sum[lid >> 7][bi] - lm_sum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][bi] += lm_sqsum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][ai] = lm_sqsum[lid >> 7][bi] - lm_sqsum[lid >> 7][ai];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(gid == 0 && (i + lid) <= rows)\n"
"{\n"
"sum[sum_offset + i + lid] = 0;\n"
"sqsum[sqsum_offset + i + lid] = 0;\n"
"}\n"
"if(i + lid == 0)\n"
"{\n"
"int loc0 = gid * 2 * sum_step;\n"
"int loc1 = gid * 2 * sqsum_step;\n"
"for(int k = 1; k <= 8; k++)\n"
"{\n"
"if(gid * 8 + k > cols) break;\n"
"sum[sum_offset + loc0 + k * sum_step / 4] = 0;\n"
"sqsum[sqsum_offset + loc1 + k * sqsum_step / 4] = 0;\n"
"}\n"
"}\n"
"int loc_s0 = sum_offset + gid * 2 * sum_step + sum_step / 4 + i + lid, loc_s1 = loc_s0 + sum_step ;\n"
"int loc_sq0 = sqsum_offset + gid * 2 * sqsum_step + sqsum_step / 4 + i + lid, loc_sq1 = loc_sq0 + sqsum_step ;\n"
"if(lid > 0 && (i+lid) <= rows)\n"
"{\n"
"lm_sum[0][bf_loc] += sum_t[0];\n"
"lm_sum[1][bf_loc] += sum_t[1];\n"
"lm_sqsum[0][bf_loc] += sqsum_t[0];\n"
"lm_sqsum[1][bf_loc] += sqsum_t[1];\n"
"sum_p = (__local int*)(&(lm_sum[0][bf_loc]));\n"
"sqsum_p = (__local float*)(&(lm_sqsum[0][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 8 + k >= cols) break;\n"
"sum[loc_s0 + k * sum_step / 4] = sum_p[k];\n"
"sqsum[loc_sq0 + k * sqsum_step / 4] = sqsum_p[k];\n"
"}\n"
"sum_p = (__local int*)(&(lm_sum[1][bf_loc]));\n"
"sqsum_p = (__local float*)(&(lm_sqsum[1][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 8 + 4 + k >= cols) break;\n"
"sum[loc_s1 + k * sum_step / 4] = sum_p[k];\n"
"sqsum[loc_sq1 + k * sqsum_step / 4] = sqsum_p[k];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"kernel void integral_cols_D5(__global uchar4 *src,__global float *sum ,__global float *sqsum,\n"
"int src_offset,int pre_invalid,int rows,int cols,int src_step,int dst_step)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"float4 src_t[2], sum_t[2];\n"
"float4 sqsum_t[2];\n"
"__local float4 lm_sum[2][LSIZE + LOG_LSIZE];\n"
"__local float4 lm_sqsum[2][LSIZE + LOG_LSIZE];\n"
"__local float* sum_p;\n"
"__local float* sqsum_p;\n"
"src_step = src_step >> 2;\n"
"gid = gid << 1;\n"
"for(int i = 0; i < rows; i =i + LSIZE_1)\n"
"{\n"
"src_t[0] = (i + lid < rows ? convert_float4(src[src_offset + (lid+i) * src_step + min(gid, cols - 1)]) : (float4)0);\n"
"src_t[1] = (i + lid < rows ? convert_float4(src[src_offset + (lid+i) * src_step + min(gid + 1, cols - 1)]) : (float4)0);\n"
"sum_t[0] = (i == 0 ? (float4)0 : lm_sum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sqsum_t[0] = (i == 0 ? (float4)0 : lm_sqsum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sum_t[1] =  (i == 0 ? (float4)0 : lm_sum[1][LSIZE_2 + LOG_LSIZE]);\n"
"sqsum_t[1] =  (i == 0 ? (float4)0 : lm_sqsum[1][LSIZE_2 + LOG_LSIZE]);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int bf_loc = lid + GET_CONFLICT_OFFSET(lid);\n"
"lm_sum[0][bf_loc] = src_t[0];\n"
"lm_sqsum[0][bf_loc] = convert_float4(src_t[0] * src_t[0]);\n"
"lm_sum[1][bf_loc] = src_t[1];\n"
"lm_sqsum[1][bf_loc] = convert_float4(src_t[1] * src_t[1]);\n"
"int offset = 1;\n"
"for(int d = LSIZE >> 1 ;  d > 0; d>>=1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi]  +=  lm_sum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][bi]  +=  lm_sqsum[lid >> 7][ai];\n"
"}\n"
"offset <<= 1;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid < 2)\n"
"{\n"
"lm_sum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"lm_sqsum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"}\n"
"for(int d = 1;  d < LSIZE; d <<= 1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"offset >>= 1;\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi] += lm_sum[lid >> 7][ai];\n"
"lm_sum[lid >> 7][ai] = lm_sum[lid >> 7][bi] - lm_sum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][bi] += lm_sqsum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][ai] = lm_sqsum[lid >> 7][bi] - lm_sqsum[lid >> 7][ai];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int loc_s0 = gid * dst_step + i + lid - 1 - pre_invalid * dst_step / 4, loc_s1 = loc_s0 + dst_step ;\n"
"if(lid > 0 && (i+lid) <= rows)\n"
"{\n"
"lm_sum[0][bf_loc] += sum_t[0];\n"
"lm_sum[1][bf_loc] += sum_t[1];\n"
"lm_sqsum[0][bf_loc] += sqsum_t[0];\n"
"lm_sqsum[1][bf_loc] += sqsum_t[1];\n"
"sum_p = (__local float*)(&(lm_sum[0][bf_loc]));\n"
"sqsum_p = (__local float*)(&(lm_sqsum[0][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 4 + k >= cols + pre_invalid || gid * 4 + k < pre_invalid) continue;\n"
"sum[loc_s0 + k * dst_step / 4] = sum_p[k];\n"
"sqsum[loc_s0 + k * dst_step / 4] = sqsum_p[k];\n"
"}\n"
"sum_p = (__local float*)(&(lm_sum[1][bf_loc]));\n"
"sqsum_p = (__local float*)(&(lm_sqsum[1][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 4 + k + 4 >= cols + pre_invalid) break;\n"
"sum[loc_s1 + k * dst_step / 4] = sum_p[k];\n"
"sqsum[loc_s1 + k * dst_step / 4] = sqsum_p[k];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"kernel void integral_rows_D5(__global float4 *srcsum,__global float4 * srcsqsum,__global float *sum ,\n"
"__global float *sqsum,int rows,int cols,int src_step,int sum_step,\n"
"int sqsum_step,int sum_offset,int sqsum_offset)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"float4 src_t[2], sum_t[2];\n"
"float4 sqsrc_t[2],sqsum_t[2];\n"
"__local float4 lm_sum[2][LSIZE + LOG_LSIZE];\n"
"__local float4 lm_sqsum[2][LSIZE + LOG_LSIZE];\n"
"__local float *sum_p;\n"
"__local float *sqsum_p;\n"
"src_step = src_step >> 4;\n"
"for(int i = 0; i < rows; i =i + LSIZE_1)\n"
"{\n"
"src_t[0] = i + lid < rows ? srcsum[(lid+i) * src_step + gid * 2] : (float4)0;\n"
"sqsrc_t[0] = i + lid < rows ? srcsqsum[(lid+i) * src_step + gid * 2] : (float4)0;\n"
"src_t[1] = i + lid < rows ? srcsum[(lid+i) * src_step + gid * 2 + 1] : (float4)0;\n"
"sqsrc_t[1] = i + lid < rows ? srcsqsum[(lid+i) * src_step + gid * 2 + 1] : (float4)0;\n"
"sum_t[0] =  (i == 0 ? (float4)0 : lm_sum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sqsum_t[0] =  (i == 0 ? (float4)0 : lm_sqsum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sum_t[1] =  (i == 0 ? (float4)0 : lm_sum[1][LSIZE_2 + LOG_LSIZE]);\n"
"sqsum_t[1] =  (i == 0 ? (float4)0 : lm_sqsum[1][LSIZE_2 + LOG_LSIZE]);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int bf_loc = lid + GET_CONFLICT_OFFSET(lid);\n"
"lm_sum[0][bf_loc] = src_t[0];\n"
"lm_sqsum[0][bf_loc] = sqsrc_t[0];\n"
"lm_sum[1][bf_loc] = src_t[1];\n"
"lm_sqsum[1][bf_loc] = sqsrc_t[1];\n"
"int offset = 1;\n"
"for(int d = LSIZE >> 1 ;  d > 0; d>>=1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi]  +=  lm_sum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][bi]  +=  lm_sqsum[lid >> 7][ai];\n"
"}\n"
"offset <<= 1;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid < 2)\n"
"{\n"
"lm_sum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"lm_sqsum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"}\n"
"for(int d = 1;  d < LSIZE; d <<= 1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"offset >>= 1;\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi] += lm_sum[lid >> 7][ai];\n"
"lm_sum[lid >> 7][ai] = lm_sum[lid >> 7][bi] - lm_sum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][bi] += lm_sqsum[lid >> 7][ai];\n"
"lm_sqsum[lid >> 7][ai] = lm_sqsum[lid >> 7][bi] - lm_sqsum[lid >> 7][ai];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(gid == 0 && (i + lid) <= rows)\n"
"{\n"
"sum[sum_offset + i + lid] = 0;\n"
"sqsum[sqsum_offset + i + lid] = 0;\n"
"}\n"
"if(i + lid == 0)\n"
"{\n"
"int loc0 = gid * 2 * sum_step;\n"
"int loc1 = gid * 2 * sqsum_step;\n"
"for(int k = 1; k <= 8; k++)\n"
"{\n"
"if(gid * 8 + k > cols) break;\n"
"sum[sum_offset + loc0 + k * sum_step / 4] = 0;\n"
"sqsum[sqsum_offset + loc1 + k * sqsum_step / 4] = 0;\n"
"}\n"
"}\n"
"int loc_s0 = sum_offset + gid * 2 * sum_step + sum_step / 4 + i + lid, loc_s1 = loc_s0 + sum_step ;\n"
"int loc_sq0 = sqsum_offset + gid * 2 * sqsum_step + sqsum_step / 4 + i + lid, loc_sq1 = loc_sq0 + sqsum_step ;\n"
"if(lid > 0 && (i+lid) <= rows)\n"
"{\n"
"lm_sum[0][bf_loc] += sum_t[0];\n"
"lm_sum[1][bf_loc] += sum_t[1];\n"
"lm_sqsum[0][bf_loc] += sqsum_t[0];\n"
"lm_sqsum[1][bf_loc] += sqsum_t[1];\n"
"sum_p = (__local float*)(&(lm_sum[0][bf_loc]));\n"
"sqsum_p = (__local float*)(&(lm_sqsum[0][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 8 + k >= cols) break;\n"
"sum[loc_s0 + k * sum_step / 4] = sum_p[k];\n"
"sqsum[loc_sq0 + k * sqsum_step / 4] = sqsum_p[k];\n"
"}\n"
"sum_p = (__local float*)(&(lm_sum[1][bf_loc]));\n"
"sqsum_p = (__local float*)(&(lm_sqsum[1][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 8 + 4 + k >= cols) break;\n"
"sum[loc_s1 + k * sum_step / 4] = sum_p[k];\n"
"sqsum[loc_sq1 + k * sqsum_step / 4] = sqsum_p[k];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
, "5e6a87796fabb22a98ead9c7596269eb"};
const struct ProgramEntry imgproc_integral_sum={"imgproc_integral_sum",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#define LSIZE 256\n"
"#define LSIZE_1 255\n"
"#define LSIZE_2 254\n"
"#define HF_LSIZE 128\n"
"#define LOG_LSIZE 8\n"
"#define LOG_NUM_BANKS 5\n"
"#define NUM_BANKS 32\n"
"#define GET_CONFLICT_OFFSET(lid) ((lid) >> LOG_NUM_BANKS)\n"
"kernel void integral_sum_cols_D4(__global uchar4 *src,__global int *sum ,\n"
"int src_offset,int pre_invalid,int rows,int cols,int src_step,int dst_step)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"int4 src_t[2], sum_t[2];\n"
"__local int4 lm_sum[2][LSIZE + LOG_LSIZE];\n"
"__local int* sum_p;\n"
"src_step = src_step >> 2;\n"
"gid = gid << 1;\n"
"for(int i = 0; i < rows; i =i + LSIZE_1)\n"
"{\n"
"src_t[0] = (i + lid < rows ? convert_int4(src[src_offset + (lid+i) * src_step + gid]) : 0);\n"
"src_t[1] = (i + lid < rows ? convert_int4(src[src_offset + (lid+i) * src_step + gid + 1]) : 0);\n"
"sum_t[0] =  (i == 0 ? 0 : lm_sum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sum_t[1] =  (i == 0 ? 0 : lm_sum[1][LSIZE_2 + LOG_LSIZE]);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int bf_loc = lid + GET_CONFLICT_OFFSET(lid);\n"
"lm_sum[0][bf_loc] = src_t[0];\n"
"lm_sum[1][bf_loc] = src_t[1];\n"
"int offset = 1;\n"
"for(int d = LSIZE >> 1 ;  d > 0; d>>=1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi]  +=  lm_sum[lid >> 7][ai];\n"
"}\n"
"offset <<= 1;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid < 2)\n"
"{\n"
"lm_sum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"}\n"
"for(int d = 1;  d < LSIZE; d <<= 1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"offset >>= 1;\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi] += lm_sum[lid >> 7][ai];\n"
"lm_sum[lid >> 7][ai] = lm_sum[lid >> 7][bi] - lm_sum[lid >> 7][ai];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid > 0 && (i+lid) <= rows)\n"
"{\n"
"int loc_s0 = gid * dst_step + i + lid - 1 - pre_invalid * dst_step / 4, loc_s1 = loc_s0 + dst_step ;\n"
"lm_sum[0][bf_loc] += sum_t[0];\n"
"lm_sum[1][bf_loc] += sum_t[1];\n"
"sum_p = (__local int*)(&(lm_sum[0][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 4 + k >= cols + pre_invalid || gid * 4 + k < pre_invalid) continue;\n"
"sum[loc_s0 + k * dst_step / 4] = sum_p[k];\n"
"}\n"
"sum_p = (__local int*)(&(lm_sum[1][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 4 + k + 4 >= cols + pre_invalid) break;\n"
"sum[loc_s1 + k * dst_step / 4] = sum_p[k];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"kernel void integral_sum_rows_D4(__global int4 *srcsum,__global int *sum ,\n"
"int rows,int cols,int src_step,int sum_step,\n"
"int sum_offset)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"int4 src_t[2], sum_t[2];\n"
"__local int4 lm_sum[2][LSIZE + LOG_LSIZE];\n"
"__local int *sum_p;\n"
"src_step = src_step >> 4;\n"
"for(int i = 0; i < rows; i =i + LSIZE_1)\n"
"{\n"
"src_t[0] = i + lid < rows ? srcsum[(lid+i) * src_step + gid * 2] : 0;\n"
"src_t[1] = i + lid < rows ? srcsum[(lid+i) * src_step + gid * 2 + 1] : 0;\n"
"sum_t[0] =  (i == 0 ? 0 : lm_sum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sum_t[1] =  (i == 0 ? 0 : lm_sum[1][LSIZE_2 + LOG_LSIZE]);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int bf_loc = lid + GET_CONFLICT_OFFSET(lid);\n"
"lm_sum[0][bf_loc] = src_t[0];\n"
"lm_sum[1][bf_loc] = src_t[1];\n"
"int offset = 1;\n"
"for(int d = LSIZE >> 1 ;  d > 0; d>>=1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi]  +=  lm_sum[lid >> 7][ai];\n"
"}\n"
"offset <<= 1;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid < 2)\n"
"{\n"
"lm_sum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"}\n"
"for(int d = 1;  d < LSIZE; d <<= 1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"offset >>= 1;\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi] += lm_sum[lid >> 7][ai];\n"
"lm_sum[lid >> 7][ai] = lm_sum[lid >> 7][bi] - lm_sum[lid >> 7][ai];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(gid == 0 && (i + lid) <= rows)\n"
"{\n"
"sum[sum_offset + i + lid] = 0;\n"
"}\n"
"if(i + lid == 0)\n"
"{\n"
"int loc0 = gid * 2 * sum_step;\n"
"for(int k = 1; k <= 8; k++)\n"
"{\n"
"if(gid * 8 + k > cols) break;\n"
"sum[sum_offset + loc0 + k * sum_step / 4] = 0;\n"
"}\n"
"}\n"
"if(lid > 0 && (i+lid) <= rows)\n"
"{\n"
"int loc_s0 = sum_offset + gid * 2 * sum_step + sum_step / 4 + i + lid, loc_s1 = loc_s0 + sum_step ;\n"
"lm_sum[0][bf_loc] += sum_t[0];\n"
"lm_sum[1][bf_loc] += sum_t[1];\n"
"sum_p = (__local int*)(&(lm_sum[0][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 8 + k >= cols) break;\n"
"sum[loc_s0 + k * sum_step / 4] = sum_p[k];\n"
"}\n"
"sum_p = (__local int*)(&(lm_sum[1][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 8 + 4 + k >= cols) break;\n"
"sum[loc_s1 + k * sum_step / 4] = sum_p[k];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"kernel void integral_sum_cols_D5(__global uchar4 *src,__global float *sum ,\n"
"int src_offset,int pre_invalid,int rows,int cols,int src_step,int dst_step)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"float4 src_t[2], sum_t[2];\n"
"__local float4 lm_sum[2][LSIZE + LOG_LSIZE];\n"
"__local float* sum_p;\n"
"src_step = src_step >> 2;\n"
"gid = gid << 1;\n"
"for(int i = 0; i < rows; i =i + LSIZE_1)\n"
"{\n"
"src_t[0] = (i + lid < rows ? convert_float4(src[src_offset + (lid+i) * src_step + gid]) : (float4)0);\n"
"src_t[1] = (i + lid < rows ? convert_float4(src[src_offset + (lid+i) * src_step + gid + 1]) : (float4)0);\n"
"sum_t[0] =  (i == 0 ? (float4)0 : lm_sum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sum_t[1] =  (i == 0 ? (float4)0 : lm_sum[1][LSIZE_2 + LOG_LSIZE]);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int bf_loc = lid + GET_CONFLICT_OFFSET(lid);\n"
"lm_sum[0][bf_loc] = src_t[0];\n"
"lm_sum[1][bf_loc] = src_t[1];\n"
"int offset = 1;\n"
"for(int d = LSIZE >> 1 ;  d > 0; d>>=1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi]  +=  lm_sum[lid >> 7][ai];\n"
"}\n"
"offset <<= 1;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid < 2)\n"
"{\n"
"lm_sum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"}\n"
"for(int d = 1;  d < LSIZE; d <<= 1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"offset >>= 1;\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi] += lm_sum[lid >> 7][ai];\n"
"lm_sum[lid >> 7][ai] = lm_sum[lid >> 7][bi] - lm_sum[lid >> 7][ai];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid > 0 && (i+lid) <= rows)\n"
"{\n"
"int loc_s0 = gid * dst_step + i + lid - 1 - pre_invalid * dst_step / 4, loc_s1 = loc_s0 + dst_step ;\n"
"lm_sum[0][bf_loc] += sum_t[0];\n"
"lm_sum[1][bf_loc] += sum_t[1];\n"
"sum_p = (__local float*)(&(lm_sum[0][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 4 + k >= cols + pre_invalid || gid * 4 + k < pre_invalid) continue;\n"
"sum[loc_s0 + k * dst_step / 4] = sum_p[k];\n"
"}\n"
"sum_p = (__local float*)(&(lm_sum[1][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 4 + k + 4 >= cols + pre_invalid) break;\n"
"sum[loc_s1 + k * dst_step / 4] = sum_p[k];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"kernel void integral_sum_rows_D5(__global float4 *srcsum,__global float *sum ,\n"
"int rows,int cols,int src_step,int sum_step,\n"
"int sum_offset)\n"
"{\n"
"int lid = get_local_id(0);\n"
"int gid = get_group_id(0);\n"
"float4 src_t[2], sum_t[2];\n"
"__local float4 lm_sum[2][LSIZE + LOG_LSIZE];\n"
"__local float *sum_p;\n"
"src_step = src_step >> 4;\n"
"for(int i = 0; i < rows; i =i + LSIZE_1)\n"
"{\n"
"src_t[0] = i + lid < rows ? srcsum[(lid+i) * src_step + gid * 2] : (float4)0;\n"
"src_t[1] = i + lid < rows ? srcsum[(lid+i) * src_step + gid * 2 + 1] : (float4)0;\n"
"sum_t[0] =  (i == 0 ? (float4)0 : lm_sum[0][LSIZE_2 + LOG_LSIZE]);\n"
"sum_t[1] =  (i == 0 ? (float4)0 : lm_sum[1][LSIZE_2 + LOG_LSIZE]);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int bf_loc = lid + GET_CONFLICT_OFFSET(lid);\n"
"lm_sum[0][bf_loc] = src_t[0];\n"
"lm_sum[1][bf_loc] = src_t[1];\n"
"int offset = 1;\n"
"for(int d = LSIZE >> 1 ;  d > 0; d>>=1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi]  +=  lm_sum[lid >> 7][ai];\n"
"}\n"
"offset <<= 1;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(lid < 2)\n"
"{\n"
"lm_sum[lid][LSIZE_2 + LOG_LSIZE] = 0;\n"
"}\n"
"for(int d = 1;  d < LSIZE; d <<= 1)\n"
"{\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"offset >>= 1;\n"
"int ai = offset * (((lid & 127)<<1) +1) - 1,bi = ai + offset;\n"
"ai += GET_CONFLICT_OFFSET(ai);\n"
"bi += GET_CONFLICT_OFFSET(bi);\n"
"if((lid & 127) < d)\n"
"{\n"
"lm_sum[lid >> 7][bi] += lm_sum[lid >> 7][ai];\n"
"lm_sum[lid >> 7][ai] = lm_sum[lid >> 7][bi] - lm_sum[lid >> 7][ai];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(gid == 0 && (i + lid) <= rows)\n"
"{\n"
"sum[sum_offset + i + lid] = 0;\n"
"}\n"
"if(i + lid == 0)\n"
"{\n"
"int loc0 = gid * 2 * sum_step;\n"
"for(int k = 1; k <= 8; k++)\n"
"{\n"
"if(gid * 8 + k > cols) break;\n"
"sum[sum_offset + loc0 + k * sum_step / 4] = 0;\n"
"}\n"
"}\n"
"if(lid > 0 && (i+lid) <= rows)\n"
"{\n"
"int loc_s0 = sum_offset + gid * 2 * sum_step + sum_step / 4 + i + lid, loc_s1 = loc_s0 + sum_step ;\n"
"lm_sum[0][bf_loc] += sum_t[0];\n"
"lm_sum[1][bf_loc] += sum_t[1];\n"
"sum_p = (__local float*)(&(lm_sum[0][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 8 + k >= cols) break;\n"
"sum[loc_s0 + k * sum_step / 4] = sum_p[k];\n"
"}\n"
"sum_p = (__local float*)(&(lm_sum[1][bf_loc]));\n"
"for(int k = 0; k < 4; k++)\n"
"{\n"
"if(gid * 8 + 4 + k >= cols) break;\n"
"sum[loc_s1 + k * sum_step / 4] = sum_p[k];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
, "e59da438d1e7b62e64504698acb985b2"};
const struct ProgramEntry imgproc_median={"imgproc_median",
"#define op(a,b) {mid=a; a=min(a,b); b=max(mid,b);}\n"
"__kernel void medianFilter3_C4_D0(__global uchar4 * src, __global uchar4 * dst,  int srcOffset, int dstOffset, int cols,\n"
"int rows, int srcStep, int dstStep)\n"
"{\n"
"__local uchar4 data[18][18];\n"
"__global uchar4* source=src + srcOffset;\n"
"int dx = get_global_id(0) - get_local_id(0) -1;\n"
"int dy = get_global_id(1) - get_local_id(1) -1;\n"
"const int id = min((int)(get_local_id(0)*16+get_local_id(1)), 9*18-1);\n"
"int dr=id/18;\n"
"int dc=id%18;\n"
"int r=clamp(dy+dr, 0, rows-1);\n"
"int c=clamp(dx+dc, 0, cols-1);\n"
"data[dr][dc] = source[r*srcStep + c];\n"
"r=clamp(dy+dr+9, 0, rows-1);\n"
"data[dr+9][dc] = source[r*srcStep + c];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int x =get_local_id(0);\n"
"int y =get_local_id(1);\n"
"uchar4 p0=data[y][x], p1=data[y][x+1], p2=data[y][x+2];\n"
"uchar4 p3=data[y+1][x], p4=data[y+1][x+1], p5=data[y+1][x+2];\n"
"uchar4 p6=data[y+2][x], p7=data[y+2][x+1], p8=data[y+2][x+2];\n"
"uchar4 mid;\n"
"op(p1, p2); op(p4, p5); op(p7, p8); op(p0, p1);\n"
"op(p3, p4); op(p6, p7); op(p1, p2); op(p4, p5);\n"
"op(p7, p8); op(p0, p3); op(p5, p8); op(p4, p7);\n"
"op(p3, p6); op(p1, p4); op(p2, p5); op(p4, p7);\n"
"op(p4, p2); op(p6, p4); op(p4, p2);\n"
"if((int)get_global_id(1)<rows && (int)get_global_id(0)<cols)\n"
"dst[dstOffset + get_global_id(1)*dstStep + get_global_id(0)]=p4;\n"
"}\n"
"#undef op\n"
"#define op(a,b) {mid=a; a=min(a,b); b=max(mid,b);}\n"
"__kernel void medianFilter3_C1_D0(__global uchar * src, __global uchar * dst,  int srcOffset, int dstOffset, int cols,\n"
"int rows, int srcStep, int dstStep)\n"
"{\n"
"__local uchar data[18][18];\n"
"__global uchar* source=src + srcOffset;\n"
"int dx = get_global_id(0) - get_local_id(0) -1;\n"
"int dy = get_global_id(1) - get_local_id(1) -1;\n"
"const int id = min((int)(get_local_id(0)*16+get_local_id(1)), 9*18-1);\n"
"int dr=id/18;\n"
"int dc=id%18;\n"
"int r=clamp(dy+dr, 0, rows-1);\n"
"int c=clamp(dx+dc, 0, cols-1);\n"
"data[dr][dc] = source[r*srcStep + c];\n"
"r=clamp(dy+dr+9, 0, rows-1);\n"
"data[dr+9][dc] = source[r*srcStep + c];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int x =get_local_id(0);\n"
"int y =get_local_id(1);\n"
"uchar p0=data[y][x], p1=data[y][x+1], p2=data[y][x+2];\n"
"uchar p3=data[y+1][x], p4=data[y+1][x+1], p5=data[y+1][x+2];\n"
"uchar p6=data[y+2][x], p7=data[y+2][x+1], p8=data[y+2][x+2];\n"
"uchar mid;\n"
"op(p1, p2); op(p4, p5); op(p7, p8); op(p0, p1);\n"
"op(p3, p4); op(p6, p7); op(p1, p2); op(p4, p5);\n"
"op(p7, p8); op(p0, p3); op(p5, p8); op(p4, p7);\n"
"op(p3, p6); op(p1, p4); op(p2, p5); op(p4, p7);\n"
"op(p4, p2); op(p6, p4); op(p4, p2);\n"
"if((int)get_global_id(1)<rows && (int)get_global_id(0)<cols)\n"
"dst[dstOffset + get_global_id(1)*dstStep + get_global_id(0)]=p4;\n"
"}\n"
"#undef op\n"
"#define op(a,b) {mid=a; a=min(a,b); b=max(mid,b);}\n"
"__kernel void medianFilter3_C1_D5(__global float * src, __global float * dst,  int srcOffset, int dstOffset, int cols,\n"
"int rows, int srcStep, int dstStep)\n"
"{\n"
"__local float data[18][18];\n"
"__global float* source=src + srcOffset;\n"
"int dx = get_global_id(0) - get_local_id(0) -1;\n"
"int dy = get_global_id(1) - get_local_id(1) -1;\n"
"const int id = min((int)(get_local_id(0)*16+get_local_id(1)), 9*18-1);\n"
"int dr=id/18;\n"
"int dc=id%18;\n"
"int r=clamp(dy+dr, 0, rows-1);\n"
"int c=clamp(dx+dc, 0, cols-1);\n"
"data[dr][dc] = source[r*srcStep + c];\n"
"r=clamp(dy+dr+9, 0, rows-1);\n"
"data[dr+9][dc] = source[r*srcStep + c];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int x =get_local_id(0);\n"
"int y =get_local_id(1);\n"
"float p0=data[y][x], p1=data[y][x+1], p2=data[y][x+2];\n"
"float p3=data[y+1][x], p4=data[y+1][x+1], p5=data[y+1][x+2];\n"
"float p6=data[y+2][x], p7=data[y+2][x+1], p8=data[y+2][x+2];\n"
"float mid;\n"
"op(p1, p2); op(p4, p5); op(p7, p8); op(p0, p1);\n"
"op(p3, p4); op(p6, p7); op(p1, p2); op(p4, p5);\n"
"op(p7, p8); op(p0, p3); op(p5, p8); op(p4, p7);\n"
"op(p3, p6); op(p1, p4); op(p2, p5); op(p4, p7);\n"
"op(p4, p2); op(p6, p4); op(p4, p2);\n"
"if((int)get_global_id(1)<rows && (int)get_global_id(0)<cols)\n"
"dst[dstOffset + get_global_id(1)*dstStep + get_global_id(0)]=p4;\n"
"}\n"
"#undef op\n"
"#define op(a,b) {mid=a; a=min(a,b); b=max(mid,b);}\n"
"__kernel void medianFilter3_C4_D5(__global float4 * src, __global float4 * dst,  int srcOffset, int dstOffset, int cols,\n"
"int rows, int srcStep, int dstStep)\n"
"{\n"
"__local float4 data[18][18];\n"
"__global float4* source=src + srcOffset;\n"
"int dx = get_global_id(0) - get_local_id(0) -1;\n"
"int dy = get_global_id(1) - get_local_id(1) -1;\n"
"const int id = min((int)(get_local_id(0)*16+get_local_id(1)), 9*18-1);\n"
"int dr=id/18;\n"
"int dc=id%18;\n"
"int r=clamp(dy+dr, 0, rows-1);\n"
"int c=clamp(dx+dc, 0, cols-1);\n"
"data[dr][dc] = source[r*srcStep + c];\n"
"r=clamp(dy+dr+9, 0, rows-1);\n"
"data[dr+9][dc] = source[r*srcStep + c];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int x =get_local_id(0);\n"
"int y =get_local_id(1);\n"
"float4 p0=data[y][x], p1=data[y][x+1], p2=data[y][x+2];\n"
"float4 p3=data[y+1][x], p4=data[y+1][x+1], p5=data[y+1][x+2];\n"
"float4 p6=data[y+2][x], p7=data[y+2][x+1], p8=data[y+2][x+2];\n"
"float4 mid;\n"
"op(p1, p2); op(p4, p5); op(p7, p8); op(p0, p1);\n"
"op(p3, p4); op(p6, p7); op(p1, p2); op(p4, p5);\n"
"op(p7, p8); op(p0, p3); op(p5, p8); op(p4, p7);\n"
"op(p3, p6); op(p1, p4); op(p2, p5); op(p4, p7);\n"
"op(p4, p2); op(p6, p4); op(p4, p2);\n"
"if((int)get_global_id(1)<rows && (int)get_global_id(0)<cols)\n"
"dst[dstOffset + get_global_id(1)*dstStep + get_global_id(0)]=p4;\n"
"}\n"
"#undef op\n"
"#define op(a,b) {mid=a; a=min(a,b); b=max(mid,b);}\n"
"__kernel void medianFilter5_C4_D0(__global uchar4 * src, __global uchar4 * dst,  int srcOffset, int dstOffset, int cols,\n"
"int rows, int srcStep, int dstStep)\n"
"{\n"
"__local uchar4 data[20][20];\n"
"__global uchar4* source=src + srcOffset;\n"
"int dx = get_global_id(0) - get_local_id(0) -2;\n"
"int dy = get_global_id(1) - get_local_id(1) -2;\n"
"const int id = min((int)(get_local_id(0)*16+get_local_id(1)), 10*20-1);\n"
"int dr=id/20;\n"
"int dc=id%20;\n"
"int r=clamp(dy+dr, 0, rows-1);\n"
"int c=clamp(dx+dc, 0, cols-1);\n"
"data[dr][dc] = source[r*srcStep + c];\n"
"r=clamp(dy+dr+10, 0, rows-1);\n"
"data[dr+10][dc] = source[r*srcStep + c];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int x =get_local_id(0);\n"
"int y =get_local_id(1);\n"
"uchar4 p0=data[y][x], p1=data[y][x+1], p2=data[y][x+2], p3=data[y][x+3], p4=data[y][x+4];\n"
"uchar4 p5=data[y+1][x], p6=data[y+1][x+1], p7=data[y+1][x+2], p8=data[y+1][x+3], p9=data[y+1][x+4];\n"
"uchar4 p10=data[y+2][x], p11=data[y+2][x+1], p12=data[y+2][x+2], p13=data[y+2][x+3], p14=data[y+2][x+4];\n"
"uchar4 p15=data[y+3][x], p16=data[y+3][x+1], p17=data[y+3][x+2], p18=data[y+3][x+3], p19=data[y+3][x+4];\n"
"uchar4 p20=data[y+4][x], p21=data[y+4][x+1], p22=data[y+4][x+2], p23=data[y+4][x+3], p24=data[y+4][x+4];\n"
"uchar4 mid;\n"
"op(p1, p2); op(p0, p1); op(p1, p2); op(p4, p5); op(p3, p4);\n"
"op(p4, p5); op(p0, p3); op(p2, p5); op(p2, p3); op(p1, p4);\n"
"op(p1, p2); op(p3, p4); op(p7, p8); op(p6, p7); op(p7, p8);\n"
"op(p10, p11); op(p9, p10); op(p10, p11); op(p6, p9); op(p8, p11);\n"
"op(p8, p9); op(p7, p10); op(p7, p8); op(p9, p10); op(p0, p6);\n"
"op(p4, p10); op(p4, p6); op(p2, p8); op(p2, p4); op(p6, p8);\n"
"op(p1, p7); op(p5, p11); op(p5, p7); op(p3, p9); op(p3, p5);\n"
"op(p7, p9); op(p1, p2); op(p3, p4); op(p5, p6); op(p7, p8);\n"
"op(p9, p10); op(p13, p14); op(p12, p13); op(p13, p14); op(p16, p17);\n"
"op(p15, p16); op(p16, p17); op(p12, p15); op(p14, p17); op(p14, p15);\n"
"op(p13, p16); op(p13, p14); op(p15, p16); op(p19, p20); op(p18, p19);\n"
"op(p19, p20); op(p21, p22); op(p23, p24); op(p21, p23); op(p22, p24);\n"
"op(p22, p23); op(p18, p21); op(p20, p23); op(p20, p21); op(p19, p22);\n"
"op(p22, p24); op(p19, p20); op(p21, p22); op(p23, p24); op(p12, p18);\n"
"op(p16, p22); op(p16, p18); op(p14, p20); op(p20, p24); op(p14, p16);\n"
"op(p18, p20); op(p22, p24); op(p13, p19); op(p17, p23); op(p17, p19);\n"
"op(p15, p21); op(p15, p17); op(p19, p21); op(p13, p14); op(p15, p16);\n"
"op(p17, p18); op(p19, p20); op(p21, p22); op(p23, p24); op(p0, p12);\n"
"op(p8, p20); op(p8, p12); op(p4, p16); op(p16, p24); op(p12, p16);\n"
"op(p2, p14); op(p10, p22); op(p10, p14); op(p6, p18); op(p6, p10);\n"
"op(p10, p12); op(p1, p13); op(p9, p21); op(p9, p13); op(p5, p17);\n"
"op(p13, p17); op(p3, p15); op(p11, p23); op(p11, p15); op(p7, p19);\n"
"op(p7, p11); op(p11, p13); op(p11, p12);\n"
"if((int)get_global_id(1)<rows && (int)get_global_id(0)<cols)\n"
"dst[dstOffset + get_global_id(1)*dstStep + get_global_id(0)]=p12;\n"
"}\n"
"#undef op\n"
"#define op(a,b) {mid=a; a=min(a,b); b=max(mid,b);}\n"
"__kernel void medianFilter5_C1_D0(__global uchar * src, __global uchar * dst,  int srcOffset, int dstOffset, int cols,\n"
"int rows, int srcStep, int dstStep)\n"
"{\n"
"__local uchar data[20][20];\n"
"__global uchar* source=src + srcOffset;\n"
"int dx = get_global_id(0) - get_local_id(0) -2;\n"
"int dy = get_global_id(1) - get_local_id(1) -2;\n"
"const int id = min((int)(get_local_id(0)*16+get_local_id(1)), 10*20-1);\n"
"int dr=id/20;\n"
"int dc=id%20;\n"
"int r=clamp(dy+dr, 0, rows-1);\n"
"int c=clamp(dx+dc, 0, cols-1);\n"
"data[dr][dc] = source[r*srcStep + c];\n"
"r=clamp(dy+dr+10, 0, rows-1);\n"
"data[dr+10][dc] = source[r*srcStep + c];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int x =get_local_id(0);\n"
"int y =get_local_id(1);\n"
"uchar p0=data[y][x], p1=data[y][x+1], p2=data[y][x+2], p3=data[y][x+3], p4=data[y][x+4];\n"
"uchar p5=data[y+1][x], p6=data[y+1][x+1], p7=data[y+1][x+2], p8=data[y+1][x+3], p9=data[y+1][x+4];\n"
"uchar p10=data[y+2][x], p11=data[y+2][x+1], p12=data[y+2][x+2], p13=data[y+2][x+3], p14=data[y+2][x+4];\n"
"uchar p15=data[y+3][x], p16=data[y+3][x+1], p17=data[y+3][x+2], p18=data[y+3][x+3], p19=data[y+3][x+4];\n"
"uchar p20=data[y+4][x], p21=data[y+4][x+1], p22=data[y+4][x+2], p23=data[y+4][x+3], p24=data[y+4][x+4];\n"
"uchar mid;\n"
"op(p1, p2); op(p0, p1); op(p1, p2); op(p4, p5); op(p3, p4);\n"
"op(p4, p5); op(p0, p3); op(p2, p5); op(p2, p3); op(p1, p4);\n"
"op(p1, p2); op(p3, p4); op(p7, p8); op(p6, p7); op(p7, p8);\n"
"op(p10, p11); op(p9, p10); op(p10, p11); op(p6, p9); op(p8, p11);\n"
"op(p8, p9); op(p7, p10); op(p7, p8); op(p9, p10); op(p0, p6);\n"
"op(p4, p10); op(p4, p6); op(p2, p8); op(p2, p4); op(p6, p8);\n"
"op(p1, p7); op(p5, p11); op(p5, p7); op(p3, p9); op(p3, p5);\n"
"op(p7, p9); op(p1, p2); op(p3, p4); op(p5, p6); op(p7, p8);\n"
"op(p9, p10); op(p13, p14); op(p12, p13); op(p13, p14); op(p16, p17);\n"
"op(p15, p16); op(p16, p17); op(p12, p15); op(p14, p17); op(p14, p15);\n"
"op(p13, p16); op(p13, p14); op(p15, p16); op(p19, p20); op(p18, p19);\n"
"op(p19, p20); op(p21, p22); op(p23, p24); op(p21, p23); op(p22, p24);\n"
"op(p22, p23); op(p18, p21); op(p20, p23); op(p20, p21); op(p19, p22);\n"
"op(p22, p24); op(p19, p20); op(p21, p22); op(p23, p24); op(p12, p18);\n"
"op(p16, p22); op(p16, p18); op(p14, p20); op(p20, p24); op(p14, p16);\n"
"op(p18, p20); op(p22, p24); op(p13, p19); op(p17, p23); op(p17, p19);\n"
"op(p15, p21); op(p15, p17); op(p19, p21); op(p13, p14); op(p15, p16);\n"
"op(p17, p18); op(p19, p20); op(p21, p22); op(p23, p24); op(p0, p12);\n"
"op(p8, p20); op(p8, p12); op(p4, p16); op(p16, p24); op(p12, p16);\n"
"op(p2, p14); op(p10, p22); op(p10, p14); op(p6, p18); op(p6, p10);\n"
"op(p10, p12); op(p1, p13); op(p9, p21); op(p9, p13); op(p5, p17);\n"
"op(p13, p17); op(p3, p15); op(p11, p23); op(p11, p15); op(p7, p19);\n"
"op(p7, p11); op(p11, p13); op(p11, p12);\n"
"if((int)get_global_id(1)<rows && (int)get_global_id(0)<cols)\n"
"dst[dstOffset + get_global_id(1)*dstStep + get_global_id(0)]=p12;\n"
"}\n"
"#undef op\n"
"#define op(a,b) {mid=a; a=min(a,b); b=max(mid,b);}\n"
"__kernel void medianFilter5_C4_D5(__global float4 * src, __global float4 * dst,  int srcOffset, int dstOffset, int cols,\n"
"int rows, int srcStep, int dstStep)\n"
"{\n"
"__local float4 data[20][20];\n"
"__global float4* source=src + srcOffset;\n"
"int dx = get_global_id(0) - get_local_id(0) -2;\n"
"int dy = get_global_id(1) - get_local_id(1) -2;\n"
"const int id = min((int)(get_local_id(0)*16+get_local_id(1)), 10*20-1);\n"
"int dr=id/20;\n"
"int dc=id%20;\n"
"int r=clamp(dy+dr, 0, rows-1);\n"
"int c=clamp(dx+dc, 0, cols-1);\n"
"data[dr][dc] = source[r*srcStep + c];\n"
"r=clamp(dy+dr+10, 0, rows-1);\n"
"data[dr+10][dc] = source[r*srcStep + c];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int x =get_local_id(0);\n"
"int y =get_local_id(1);\n"
"float4 p0=data[y][x], p1=data[y][x+1], p2=data[y][x+2], p3=data[y][x+3], p4=data[y][x+4];\n"
"float4 p5=data[y+1][x], p6=data[y+1][x+1], p7=data[y+1][x+2], p8=data[y+1][x+3], p9=data[y+1][x+4];\n"
"float4 p10=data[y+2][x], p11=data[y+2][x+1], p12=data[y+2][x+2], p13=data[y+2][x+3], p14=data[y+2][x+4];\n"
"float4 p15=data[y+3][x], p16=data[y+3][x+1], p17=data[y+3][x+2], p18=data[y+3][x+3], p19=data[y+3][x+4];\n"
"float4 p20=data[y+4][x], p21=data[y+4][x+1], p22=data[y+4][x+2], p23=data[y+4][x+3], p24=data[y+4][x+4];\n"
"float4 mid;\n"
"op(p1, p2); op(p0, p1); op(p1, p2); op(p4, p5); op(p3, p4);\n"
"op(p4, p5); op(p0, p3); op(p2, p5); op(p2, p3); op(p1, p4);\n"
"op(p1, p2); op(p3, p4); op(p7, p8); op(p6, p7); op(p7, p8);\n"
"op(p10, p11); op(p9, p10); op(p10, p11); op(p6, p9); op(p8, p11);\n"
"op(p8, p9); op(p7, p10); op(p7, p8); op(p9, p10); op(p0, p6);\n"
"op(p4, p10); op(p4, p6); op(p2, p8); op(p2, p4); op(p6, p8);\n"
"op(p1, p7); op(p5, p11); op(p5, p7); op(p3, p9); op(p3, p5);\n"
"op(p7, p9); op(p1, p2); op(p3, p4); op(p5, p6); op(p7, p8);\n"
"op(p9, p10); op(p13, p14); op(p12, p13); op(p13, p14); op(p16, p17);\n"
"op(p15, p16); op(p16, p17); op(p12, p15); op(p14, p17); op(p14, p15);\n"
"op(p13, p16); op(p13, p14); op(p15, p16); op(p19, p20); op(p18, p19);\n"
"op(p19, p20); op(p21, p22); op(p23, p24); op(p21, p23); op(p22, p24);\n"
"op(p22, p23); op(p18, p21); op(p20, p23); op(p20, p21); op(p19, p22);\n"
"op(p22, p24); op(p19, p20); op(p21, p22); op(p23, p24); op(p12, p18);\n"
"op(p16, p22); op(p16, p18); op(p14, p20); op(p20, p24); op(p14, p16);\n"
"op(p18, p20); op(p22, p24); op(p13, p19); op(p17, p23); op(p17, p19);\n"
"op(p15, p21); op(p15, p17); op(p19, p21); op(p13, p14); op(p15, p16);\n"
"op(p17, p18); op(p19, p20); op(p21, p22); op(p23, p24); op(p0, p12);\n"
"op(p8, p20); op(p8, p12); op(p4, p16); op(p16, p24); op(p12, p16);\n"
"op(p2, p14); op(p10, p22); op(p10, p14); op(p6, p18); op(p6, p10);\n"
"op(p10, p12); op(p1, p13); op(p9, p21); op(p9, p13); op(p5, p17);\n"
"op(p13, p17); op(p3, p15); op(p11, p23); op(p11, p15); op(p7, p19);\n"
"op(p7, p11); op(p11, p13); op(p11, p12);\n"
"if((int)get_global_id(1)<rows && (int)get_global_id(0)<cols)\n"
"dst[dstOffset + get_global_id(1)*dstStep + get_global_id(0)]=p12;\n"
"}\n"
"#undef op\n"
"#define op(a,b) {mid=a; a=min(a,b); b=max(mid,b);}\n"
"__kernel void medianFilter5_C1_D5(__global float * src, __global float * dst,  int srcOffset, int dstOffset, int cols,\n"
"int rows, int srcStep, int dstStep)\n"
"{\n"
"__local float data[20][20];\n"
"__global float* source=src + srcOffset;\n"
"int dx = get_global_id(0) - get_local_id(0) -2;\n"
"int dy = get_global_id(1) - get_local_id(1) -2;\n"
"const int id = min((int)(get_local_id(0)*16+get_local_id(1)), 10*20-1);\n"
"int dr=id/20;\n"
"int dc=id%20;\n"
"int r=clamp(dy+dr, 0, rows-1);\n"
"int c=clamp(dx+dc, 0, cols-1);\n"
"data[dr][dc] = source[r*srcStep + c];\n"
"r=clamp(dy+dr+10, 0, rows-1);\n"
"data[dr+10][dc] = source[r*srcStep + c];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"int x =get_local_id(0);\n"
"int y =get_local_id(1);\n"
"float p0=data[y][x], p1=data[y][x+1], p2=data[y][x+2], p3=data[y][x+3], p4=data[y][x+4];\n"
"float p5=data[y+1][x], p6=data[y+1][x+1], p7=data[y+1][x+2], p8=data[y+1][x+3], p9=data[y+1][x+4];\n"
"float p10=data[y+2][x], p11=data[y+2][x+1], p12=data[y+2][x+2], p13=data[y+2][x+3], p14=data[y+2][x+4];\n"
"float p15=data[y+3][x], p16=data[y+3][x+1], p17=data[y+3][x+2], p18=data[y+3][x+3], p19=data[y+3][x+4];\n"
"float p20=data[y+4][x], p21=data[y+4][x+1], p22=data[y+4][x+2], p23=data[y+4][x+3], p24=data[y+4][x+4];\n"
"float mid;\n"
"op(p1, p2); op(p0, p1); op(p1, p2); op(p4, p5); op(p3, p4);\n"
"op(p4, p5); op(p0, p3); op(p2, p5); op(p2, p3); op(p1, p4);\n"
"op(p1, p2); op(p3, p4); op(p7, p8); op(p6, p7); op(p7, p8);\n"
"op(p10, p11); op(p9, p10); op(p10, p11); op(p6, p9); op(p8, p11);\n"
"op(p8, p9); op(p7, p10); op(p7, p8); op(p9, p10); op(p0, p6);\n"
"op(p4, p10); op(p4, p6); op(p2, p8); op(p2, p4); op(p6, p8);\n"
"op(p1, p7); op(p5, p11); op(p5, p7); op(p3, p9); op(p3, p5);\n"
"op(p7, p9); op(p1, p2); op(p3, p4); op(p5, p6); op(p7, p8);\n"
"op(p9, p10); op(p13, p14); op(p12, p13); op(p13, p14); op(p16, p17);\n"
"op(p15, p16); op(p16, p17); op(p12, p15); op(p14, p17); op(p14, p15);\n"
"op(p13, p16); op(p13, p14); op(p15, p16); op(p19, p20); op(p18, p19);\n"
"op(p19, p20); op(p21, p22); op(p23, p24); op(p21, p23); op(p22, p24);\n"
"op(p22, p23); op(p18, p21); op(p20, p23); op(p20, p21); op(p19, p22);\n"
"op(p22, p24); op(p19, p20); op(p21, p22); op(p23, p24); op(p12, p18);\n"
"op(p16, p22); op(p16, p18); op(p14, p20); op(p20, p24); op(p14, p16);\n"
"op(p18, p20); op(p22, p24); op(p13, p19); op(p17, p23); op(p17, p19);\n"
"op(p15, p21); op(p15, p17); op(p19, p21); op(p13, p14); op(p15, p16);\n"
"op(p17, p18); op(p19, p20); op(p21, p22); op(p23, p24); op(p0, p12);\n"
"op(p8, p20); op(p8, p12); op(p4, p16); op(p16, p24); op(p12, p16);\n"
"op(p2, p14); op(p10, p22); op(p10, p14); op(p6, p18); op(p6, p10);\n"
"op(p10, p12); op(p1, p13); op(p9, p21); op(p9, p13); op(p5, p17);\n"
"op(p13, p17); op(p3, p15); op(p11, p23); op(p11, p15); op(p7, p19);\n"
"op(p7, p11); op(p11, p13); op(p11, p12);\n"
"if((int)get_global_id(1)<rows && (int)get_global_id(0)<cols)\n"
"dst[dstOffset + get_global_id(1)*dstStep + get_global_id(0)]=p12;\n"
"}\n"
"#undef op\n"
, "6a58f04e0619c3c5c81f91b56c469553"};
const struct ProgramEntry imgproc_remap={"imgproc_remap",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"enum\n"
"{\n"
"INTER_BITS = 5,\n"
"INTER_TAB_SIZE = 1 << INTER_BITS,\n"
"INTER_TAB_SIZE2 = INTER_TAB_SIZE * INTER_TAB_SIZE\n"
"};\n"
"#ifdef INTER_NEAREST\n"
"#define convertToWT\n"
"#endif\n"
"#ifdef BORDER_CONSTANT\n"
"#define EXTRAPOLATE(v2, v) v = scalar;\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(v2, v) \\\n"
"{ \\\n"
"v2 = max(min(v2, (int2)(src_cols - 1, src_rows - 1)), (int2)(0)); \\\n"
"v = convertToWT(src[mad24(v2.y, src_step, v2.x + src_offset)]); \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(v2, v) \\\n"
"{ \\\n"
"if (v2.x < 0) \\\n"
"v2.x -= ((v2.x - src_cols + 1) / src_cols) * src_cols; \\\n"
"if (v2.x >= src_cols) \\\n"
"v2.x %= src_cols; \\\n"
"\\\n"
"if (v2.y < 0) \\\n"
"v2.y -= ((v2.y - src_rows + 1) / src_rows) * src_rows; \\\n"
"if( v2.y >= src_rows ) \\\n"
"v2.y %= src_rows; \\\n"
"v = convertToWT(src[mad24(v2.y, src_step, v2.x + src_offset)]); \\\n"
"}\n"
"#elif defined(BORDER_REFLECT) || defined(BORDER_REFLECT_101)\n"
"#ifdef BORDER_REFLECT\n"
"#define DELTA int delta = 0\n"
"#else\n"
"#define DELTA int delta = 1\n"
"#endif\n"
"#define EXTRAPOLATE(v2, v) \\\n"
"{ \\\n"
"DELTA; \\\n"
"if (src_cols == 1) \\\n"
"v2.x = 0; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if( v2.x < 0 ) \\\n"
"v2.x = -v2.x - 1 + delta; \\\n"
"else \\\n"
"v2.x = src_cols - 1 - (v2.x - src_cols) - delta; \\\n"
"} \\\n"
"while (v2.x >= src_cols || v2.x < 0); \\\n"
"\\\n"
"if (src_rows == 1) \\\n"
"v2.y = 0; \\\n"
"else \\\n"
"do \\\n"
"{ \\\n"
"if( v2.y < 0 ) \\\n"
"v2.y = -v2.y - 1 + delta; \\\n"
"else \\\n"
"v2.y = src_rows - 1 - (v2.y - src_rows) - delta; \\\n"
"} \\\n"
"while (v2.y >= src_rows || v2.y < 0); \\\n"
"v = convertToWT(src[mad24(v2.y, src_step, v2.x + src_offset)]); \\\n"
"}\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"#define NEED_EXTRAPOLATION(gx, gy) (gx >= src_cols || gy >= src_rows || gx < 0 || gy < 0)\n"
"#ifdef INTER_NEAREST\n"
"__kernel void remap_2_32FC1(__global const T * restrict src, __global T * dst,\n"
"__global float * map1, __global float * map2,\n"
"int src_offset, int dst_offset, int map1_offset, int map2_offset,\n"
"int src_step, int dst_step, int map1_step, int map2_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, T scalar)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"int dstIdx = mad24(y, dst_step, x + dst_offset);\n"
"int map1Idx = mad24(y, map1_step, x + map1_offset);\n"
"int map2Idx = mad24(y, map2_step, x + map2_offset);\n"
"int gx = convert_int_sat_rte(map1[map1Idx]);\n"
"int gy = convert_int_sat_rte(map2[map2Idx]);\n"
"if (NEED_EXTRAPOLATION(gx, gy))\n"
"{\n"
"#ifndef BORDER_CONSTANT\n"
"int2 gxy = (int2)(gx, gy);\n"
"#endif\n"
"EXTRAPOLATE(gxy, dst[dstIdx]);\n"
"}\n"
"else\n"
"{\n"
"int srcIdx = mad24(gy, src_step, gx + src_offset);\n"
"dst[dstIdx] = src[srcIdx];\n"
"}\n"
"}\n"
"}\n"
"__kernel void remap_32FC2(__global const T * restrict src, __global T * dst, __global float2 * map1,\n"
"int src_offset, int dst_offset, int map1_offset,\n"
"int src_step, int dst_step, int map1_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, T scalar)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"int dstIdx = mad24(y, dst_step, x + dst_offset);\n"
"int map1Idx = mad24(y, map1_step, x + map1_offset);\n"
"int2 gxy = convert_int2_sat_rte(map1[map1Idx]);\n"
"int gx = gxy.x, gy = gxy.y;\n"
"if (NEED_EXTRAPOLATION(gx, gy))\n"
"EXTRAPOLATE(gxy, dst[dstIdx])\n"
"else\n"
"{\n"
"int srcIdx = mad24(gy, src_step, gx + src_offset);\n"
"dst[dstIdx] = src[srcIdx];\n"
"}\n"
"}\n"
"}\n"
"__kernel void remap_16SC2(__global const T * restrict src, __global T * dst, __global short2 * map1,\n"
"int src_offset, int dst_offset, int map1_offset,\n"
"int src_step, int dst_step, int map1_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, T scalar)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"int dstIdx = mad24(y, dst_step, x + dst_offset);\n"
"int map1Idx = mad24(y, map1_step, x + map1_offset);\n"
"int2 gxy = convert_int2(map1[map1Idx]);\n"
"int gx = gxy.x, gy = gxy.y;\n"
"if (NEED_EXTRAPOLATION(gx, gy))\n"
"EXTRAPOLATE(gxy, dst[dstIdx])\n"
"else\n"
"{\n"
"int srcIdx = mad24(gy, src_step, gx + src_offset);\n"
"dst[dstIdx] = src[srcIdx];\n"
"}\n"
"}\n"
"}\n"
"__kernel void remap_16SC2_16UC1(__global const T * restrict src, __global T * dst, __global short2 * map1, __global ushort * map2,\n"
"int src_offset, int dst_offset, int map1_offset, int map2_offset,\n"
"int src_step, int dst_step, int map1_step, int map2_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, T scalar)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"int dstIdx = mad24(y, dst_step, x + dst_offset);\n"
"int map1Idx = mad24(y, map1_step, x + map1_offset);\n"
"int map2Idx = mad24(y, map2_step, x + map2_offset);\n"
"int map2Value = convert_int(map2[map2Idx]) & (INTER_TAB_SIZE2 - 1);\n"
"int dx = (map2Value & (INTER_TAB_SIZE - 1)) < (INTER_TAB_SIZE >> 1) ? 1 : 0;\n"
"int dy = (map2Value >> INTER_BITS) < (INTER_TAB_SIZE >> 1) ? 1 : 0;\n"
"int2 gxy = convert_int2(map1[map1Idx]) + (int2)(dx, dy);\n"
"int gx = gxy.x, gy = gxy.y;\n"
"if (NEED_EXTRAPOLATION(gx, gy))\n"
"EXTRAPOLATE(gxy, dst[dstIdx])\n"
"else\n"
"{\n"
"int srcIdx = mad24(gy, src_step, gx + src_offset);\n"
"dst[dstIdx] = src[srcIdx];\n"
"}\n"
"}\n"
"}\n"
"#elif INTER_LINEAR\n"
"__kernel void remap_16SC2_16UC1(__global T const * restrict src, __global T * dst,\n"
"__global short2 * restrict map1, __global ushort * restrict map2,\n"
"int src_offset, int dst_offset, int map1_offset, int map2_offset,\n"
"int src_step, int dst_step, int map1_step, int map2_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, T nVal)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"int dstIdx = mad24(y, dst_step, x + dst_offset);\n"
"int map1Idx = mad24(y, map1_step, x + map1_offset);\n"
"int map2Idx = mad24(y, map2_step, x + map2_offset);\n"
"int2 map_dataA = convert_int2(map1[map1Idx]);\n"
"int2 map_dataB = (int2)(map_dataA.x + 1, map_dataA.y);\n"
"int2 map_dataC = (int2)(map_dataA.x, map_dataA.y + 1);\n"
"int2 map_dataD = (int2)(map_dataA.x + 1, map_dataA.y + 1);\n"
"ushort map2Value = (ushort)(map2[map2Idx] & (INTER_TAB_SIZE2 - 1));\n"
"WT2 u = (WT2)(map2Value & (INTER_TAB_SIZE - 1), map2Value >> INTER_BITS) / (WT2)(INTER_TAB_SIZE);\n"
"WT scalar = convertToWT(nVal);\n"
"WT a = scalar, b = scalar, c = scalar, d = scalar;\n"
"if (!NEED_EXTRAPOLATION(map_dataA.x, map_dataA.y))\n"
"a = convertToWT(src[mad24(map_dataA.y, src_step, map_dataA.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataA, a);\n"
"if (!NEED_EXTRAPOLATION(map_dataB.x, map_dataB.y))\n"
"b = convertToWT(src[mad24(map_dataB.y, src_step, map_dataB.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataB, b);\n"
"if (!NEED_EXTRAPOLATION(map_dataC.x, map_dataC.y))\n"
"c = convertToWT(src[mad24(map_dataC.y, src_step, map_dataC.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataC, c);\n"
"if (!NEED_EXTRAPOLATION(map_dataD.x, map_dataD.y))\n"
"d = convertToWT(src[mad24(map_dataD.y, src_step, map_dataD.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataD, d);\n"
"WT dst_data = a * (1 - u.x) * (1 - u.y) +\n"
"b * (u.x)     * (1 - u.y) +\n"
"c * (1 - u.x) * (u.y) +\n"
"d * (u.x)     * (u.y);\n"
"dst[dstIdx] = convertToT(dst_data);\n"
"}\n"
"}\n"
"__kernel void remap_2_32FC1(__global T const * restrict  src, __global T * dst,\n"
"__global float * map1, __global float * map2,\n"
"int src_offset, int dst_offset, int map1_offset, int map2_offset,\n"
"int src_step, int dst_step, int map1_step, int map2_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, T nVal)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"int dstIdx = mad24(y, dst_step, x + dst_offset);\n"
"int map1Idx = mad24(y, map1_step, x + map1_offset);\n"
"int map2Idx = mad24(y, map2_step, x + map2_offset);\n"
"float2 map_data = (float2)(map1[map1Idx], map2[map2Idx]);\n"
"int2 map_dataA = convert_int2_sat_rtn(map_data);\n"
"int2 map_dataB = (int2)(map_dataA.x + 1, map_dataA.y);\n"
"int2 map_dataC = (int2)(map_dataA.x, map_dataA.y + 1);\n"
"int2 map_dataD = (int2)(map_dataA.x + 1, map_dataA.y + 1);\n"
"float2 _u = map_data - convert_float2(map_dataA);\n"
"WT2 u = convertToWT2(convert_int2_rte(convertToWT2(_u) * (WT2)INTER_TAB_SIZE)) / (WT2)INTER_TAB_SIZE;\n"
"WT scalar = convertToWT(nVal);\n"
"WT a = scalar, b = scalar, c = scalar, d = scalar;\n"
"if (!NEED_EXTRAPOLATION(map_dataA.x, map_dataA.y))\n"
"a = convertToWT(src[mad24(map_dataA.y, src_step, map_dataA.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataA, a);\n"
"if (!NEED_EXTRAPOLATION(map_dataB.x, map_dataB.y))\n"
"b = convertToWT(src[mad24(map_dataB.y, src_step, map_dataB.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataB, b);\n"
"if (!NEED_EXTRAPOLATION(map_dataC.x, map_dataC.y))\n"
"c = convertToWT(src[mad24(map_dataC.y, src_step, map_dataC.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataC, c);\n"
"if (!NEED_EXTRAPOLATION(map_dataD.x, map_dataD.y))\n"
"d = convertToWT(src[mad24(map_dataD.y, src_step, map_dataD.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataD, d);\n"
"WT dst_data = a * (1 - u.x) * (1 - u.y) +\n"
"b * (u.x)     * (1 - u.y) +\n"
"c * (1 - u.x) * (u.y) +\n"
"d * (u.x)     * (u.y);\n"
"dst[dstIdx] = convertToT(dst_data);\n"
"}\n"
"}\n"
"__kernel void remap_32FC2(__global T const * restrict  src, __global T * dst,\n"
"__global float2 * map1,\n"
"int src_offset, int dst_offset, int map1_offset,\n"
"int src_step, int dst_step, int map1_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, T nVal)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"int dstIdx = mad24(y, dst_step, x + dst_offset);\n"
"int map1Idx = mad24(y, map1_step, x + map1_offset);\n"
"float2 map_data = map1[map1Idx];\n"
"int2 map_dataA = convert_int2_sat_rtn(map_data);\n"
"int2 map_dataB = (int2)(map_dataA.x + 1, map_dataA.y);\n"
"int2 map_dataC = (int2)(map_dataA.x, map_dataA.y + 1);\n"
"int2 map_dataD = (int2)(map_dataA.x + 1, map_dataA.y + 1);\n"
"float2 _u = map_data - convert_float2(map_dataA);\n"
"WT2 u = convertToWT2(convert_int2_rte(convertToWT2(_u) * (WT2)INTER_TAB_SIZE)) / (WT2)INTER_TAB_SIZE;\n"
"WT scalar = convertToWT(nVal);\n"
"WT a = scalar, b = scalar, c = scalar, d = scalar;\n"
"if (!NEED_EXTRAPOLATION(map_dataA.x, map_dataA.y))\n"
"a = convertToWT(src[mad24(map_dataA.y, src_step, map_dataA.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataA, a);\n"
"if (!NEED_EXTRAPOLATION(map_dataB.x, map_dataB.y))\n"
"b = convertToWT(src[mad24(map_dataB.y, src_step, map_dataB.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataB, b);\n"
"if (!NEED_EXTRAPOLATION(map_dataC.x, map_dataC.y))\n"
"c = convertToWT(src[mad24(map_dataC.y, src_step, map_dataC.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataC, c);\n"
"if (!NEED_EXTRAPOLATION(map_dataD.x, map_dataD.y))\n"
"d = convertToWT(src[mad24(map_dataD.y, src_step, map_dataD.x + src_offset)]);\n"
"else\n"
"EXTRAPOLATE(map_dataD, d);\n"
"WT dst_data = a * (1 - u.x) * (1 - u.y) +\n"
"b * (u.x)     * (1 - u.y) +\n"
"c * (1 - u.x) * (u.y) +\n"
"d * (u.x)     * (u.y);\n"
"dst[dstIdx] = convertToT(dst_data);\n"
"}\n"
"}\n"
"#endif\n"
, "97286bf2357a81af2a1da7e008a02729"};
const struct ProgramEntry imgproc_resize={"imgproc_resize",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#define INTER_RESIZE_COEF_BITS 11\n"
"#define INTER_RESIZE_COEF_SCALE (1 << INTER_RESIZE_COEF_BITS)\n"
"#define CAST_BITS (INTER_RESIZE_COEF_BITS << 1)\n"
"#define CAST_SCALE (1.0f/(1<<CAST_BITS))\n"
"#define INC(x,l) ((x+1) >= (l) ? (x):((x)+1))\n"
"#ifdef LN\n"
"__kernel void resizeLN_C1_D0(__global uchar * dst, __global uchar const * restrict src,\n"
"int dst_offset, int src_offset,int dst_step, int src_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, float ifx, float ify )\n"
"{\n"
"int gx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"float4  sx, u, xf;\n"
"int4 x, DX;\n"
"gx = (gx<<2) - (dst_offset&3);\n"
"DX = (int4)(gx, gx+1, gx+2, gx+3);\n"
"sx = (convert_float4(DX) + 0.5f) * ifx - 0.5f;\n"
"xf = floor(sx);\n"
"x = convert_int4(xf);\n"
"u = sx - xf;\n"
"float sy = ((dy+0.5f) * ify - 0.5f);\n"
"int y = floor(sy);\n"
"float v = sy - y;\n"
"u = x < (int4)0 ? (float4)0 : u;\n"
"u = (x >= (int4)src_cols) ? (float4)0 : u;\n"
"x = x < (int4)0 ? (int4)0 : x;\n"
"x = (x >= (int4)src_cols) ? (int4)(src_cols-1) : x;\n"
"y<0 ? y=0,v=0 : y;\n"
"y>=src_rows ? y=src_rows-1,v=0 : y;\n"
"int4 U, U1;\n"
"int V, V1;\n"
"float4 utmp1, utmp2;\n"
"float vtmp;\n"
"float4 scale_vec = INTER_RESIZE_COEF_SCALE;\n"
"utmp1 = u * scale_vec;\n"
"utmp2 = scale_vec - utmp1;\n"
"U = convert_int4(rint(utmp1));\n"
"U1 = convert_int4(rint(utmp2));\n"
"vtmp = v * INTER_RESIZE_COEF_SCALE;\n"
"V = rint(vtmp);\n"
"V1= rint(INTER_RESIZE_COEF_SCALE - vtmp);\n"
"int y_ = INC(y,src_rows);\n"
"int4 x_;\n"
"x_ =  ((x+1 >= src_cols) != 0) ? x : x+1;\n"
"int4 val1, val2, val;\n"
"int4 sdata1, sdata2, sdata3, sdata4;\n"
"int4 pos1 = mad24((int4)y, (int4)src_step, x+(int4)src_offset);\n"
"int4 pos2 = mad24((int4)y, (int4)src_step, x_+(int4)src_offset);\n"
"int4 pos3 = mad24((int4)y_, (int4)src_step, x+(int4)src_offset);\n"
"int4 pos4 = mad24((int4)y_, (int4)src_step, x_+(int4)src_offset);\n"
"sdata1.s0 = src[pos1.s0];\n"
"sdata1.s1 = src[pos1.s1];\n"
"sdata1.s2 = src[pos1.s2];\n"
"sdata1.s3 = src[pos1.s3];\n"
"sdata2.s0 = src[pos2.s0];\n"
"sdata2.s1 = src[pos2.s1];\n"
"sdata2.s2 = src[pos2.s2];\n"
"sdata2.s3 = src[pos2.s3];\n"
"sdata3.s0 = src[pos3.s0];\n"
"sdata3.s1 = src[pos3.s1];\n"
"sdata3.s2 = src[pos3.s2];\n"
"sdata3.s3 = src[pos3.s3];\n"
"sdata4.s0 = src[pos4.s0];\n"
"sdata4.s1 = src[pos4.s1];\n"
"sdata4.s2 = src[pos4.s2];\n"
"sdata4.s3 = src[pos4.s3];\n"
"val1 = mul24(U1 , sdata1) + mul24(U , sdata2);\n"
"val2 = mul24(U1 , sdata3) + mul24(U , sdata4);\n"
"val = mul24((int4)V1 , val1) + mul24((int4)V , val2);\n"
"val = ((val + (1<<(CAST_BITS-1))) >> CAST_BITS);\n"
"pos4 = mad24(dy, dst_step, gx+dst_offset);\n"
"pos4.y++;\n"
"pos4.z+=2;\n"
"pos4.w+=3;\n"
"uchar4 uval = convert_uchar4_sat(val);\n"
"int con = (gx >= 0 && gx+3 < dst_cols && dy >= 0 && dy < dst_rows && (dst_offset&3)==0);\n"
"if(con)\n"
"{\n"
"*(__global uchar4*)(dst + pos4.x)=uval;\n"
"}\n"
"else\n"
"{\n"
"if(gx >= 0 && gx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"dst[pos4.x]=uval.x;\n"
"}\n"
"if(gx+1 >= 0 && gx+1 < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"dst[pos4.y]=uval.y;\n"
"}\n"
"if(gx+2 >= 0 && gx+2 < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"dst[pos4.z]=uval.z;\n"
"}\n"
"if(gx+3 >= 0 && gx+3 < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"dst[pos4.w]=uval.w;\n"
"}\n"
"}\n"
"}\n"
"__kernel void resizeLN_C4_D0(__global uchar4 * dst, __global uchar4 * src,\n"
"int dst_offset, int src_offset,int dst_step, int src_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, float ifx, float ify )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"float sx = ((dx+0.5f) * ifx - 0.5f), sy = ((dy+0.5f) * ify - 0.5f);\n"
"int x = floor(sx), y = floor(sy);\n"
"float u = sx - x, v = sy - y;\n"
"if ( x<0 ) x=0,u=0;\n"
"if ( x>=src_cols ) x=src_cols-1,u=0;\n"
"if ( y<0 ) y=0,v=0;\n"
"if (y>=src_rows ) y=src_rows-1,v=0;\n"
"u = u * INTER_RESIZE_COEF_SCALE;\n"
"v = v * INTER_RESIZE_COEF_SCALE;\n"
"int U = rint(u);\n"
"int V = rint(v);\n"
"int U1= rint(INTER_RESIZE_COEF_SCALE - u);\n"
"int V1= rint(INTER_RESIZE_COEF_SCALE - v);\n"
"int y_ = INC(y,src_rows);\n"
"int x_ = INC(x,src_cols);\n"
"int4 srcpos;\n"
"srcpos.x = mad24(y, src_step, x+src_offset);\n"
"srcpos.y = mad24(y, src_step, x_+src_offset);\n"
"srcpos.z = mad24(y_, src_step, x+src_offset);\n"
"srcpos.w = mad24(y_, src_step, x_+src_offset);\n"
"int4 data0 = convert_int4(src[srcpos.x]);\n"
"int4 data1 = convert_int4(src[srcpos.y]);\n"
"int4 data2 = convert_int4(src[srcpos.z]);\n"
"int4 data3 = convert_int4(src[srcpos.w]);\n"
"int4 val = mul24((int4)mul24(U1, V1) ,  data0) + mul24((int4)mul24(U, V1) ,  data1)\n"
"+mul24((int4)mul24(U1, V) ,  data2)+mul24((int4)mul24(U, V) ,  data3);\n"
"int dstpos = mad24(dy, dst_step, dx+dst_offset);\n"
"uchar4 uval =   convert_uchar4((val + (1<<(CAST_BITS-1)))>>CAST_BITS);\n"
"if(dx>=0 && dx<dst_cols && dy>=0 && dy<dst_rows)\n"
"dst[dstpos] = uval;\n"
"}\n"
"__kernel void resizeLN_C1_D5(__global float * dst, __global float * src,\n"
"int dst_offset, int src_offset,int dst_step, int src_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, float ifx, float ify )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"float sx = ((dx+0.5f) * ifx - 0.5f), sy = ((dy+0.5f) * ify - 0.5f);\n"
"int x = floor(sx), y = floor(sy);\n"
"float u = sx - x, v = sy - y;\n"
"if ( x<0 ) x=0,u=0;\n"
"if ( x>=src_cols ) x=src_cols-1,u=0;\n"
"if ( y<0 ) y=0,v=0;\n"
"if (y>=src_rows ) y=src_rows-1,v=0;\n"
"int y_ = INC(y,src_rows);\n"
"int x_ = INC(x,src_cols);\n"
"float u1 = 1.f-u;\n"
"float v1 = 1.f-v;\n"
"int4 srcpos;\n"
"srcpos.x = mad24(y, src_step, x+src_offset);\n"
"srcpos.y = mad24(y, src_step, x_+src_offset);\n"
"srcpos.z = mad24(y_, src_step, x+src_offset);\n"
"srcpos.w = mad24(y_, src_step, x_+src_offset);\n"
"float data0 = src[srcpos.x];\n"
"float data1 = src[srcpos.y];\n"
"float data2 = src[srcpos.z];\n"
"float data3 = src[srcpos.w];\n"
"float val1 = u1 *  data0 +\n"
"u  *  data1 ;\n"
"float val2 = u1 *  data2 +\n"
"u *  data3;\n"
"float val = v1 * val1 + v * val2;\n"
"int dstpos = mad24(dy, dst_step, dx+dst_offset);\n"
"if(dx>=0 && dx<dst_cols && dy>=0 && dy<dst_rows)\n"
"dst[dstpos] = val;\n"
"}\n"
"__kernel void resizeLN_C4_D5(__global float4 * dst, __global float4 * src,\n"
"int dst_offset, int src_offset,int dst_step, int src_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, float ifx, float ify )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"float sx = ((dx+0.5f) * ifx - 0.5f), sy = ((dy+0.5f) * ify - 0.5f);\n"
"int x = floor(sx), y = floor(sy);\n"
"float u = sx - x, v = sy - y;\n"
"if ( x<0 ) x=0,u=0;\n"
"if ( x>=src_cols ) x=src_cols-1,u=0;\n"
"if ( y<0 ) y=0,v=0;\n"
"if (y>=src_rows ) y=src_rows-1,v=0;\n"
"int y_ = INC(y,src_rows);\n"
"int x_ = INC(x,src_cols);\n"
"float u1 = 1.f-u;\n"
"float v1 = 1.f-v;\n"
"int4 srcpos;\n"
"srcpos.x = mad24(y, src_step, x+src_offset);\n"
"srcpos.y = mad24(y, src_step, x_+src_offset);\n"
"srcpos.z = mad24(y_, src_step, x+src_offset);\n"
"srcpos.w = mad24(y_, src_step, x_+src_offset);\n"
"float4 s_data1, s_data2, s_data3, s_data4;\n"
"s_data1 = src[srcpos.x];\n"
"s_data2 = src[srcpos.y];\n"
"s_data3 = src[srcpos.z];\n"
"s_data4 = src[srcpos.w];\n"
"float4 val = u1 * v1 * s_data1 + u * v1 * s_data2\n"
"+u1 * v *s_data3 + u * v *s_data4;\n"
"int dstpos = mad24(dy, dst_step, dx+dst_offset);\n"
"if(dx>=0 && dx<dst_cols && dy>=0 && dy<dst_rows)\n"
"dst[dstpos] = val;\n"
"}\n"
"#elif defined NN\n"
"__kernel void resizeNN(__global T * dst, __global T * src,\n"
"int dst_offset, int src_offset, int dst_step, int src_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, float ifx, float ify)\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if (dx < dst_cols && dy < dst_rows)\n"
"{\n"
"float s1 = dx * ifx, s2 = dy * ify;\n"
"int sx = min(convert_int_sat_rtn(s1), src_cols - 1);\n"
"int sy = min(convert_int_sat_rtn(s2), src_rows - 1);\n"
"int dst_index = mad24(dy, dst_step, dx + dst_offset);\n"
"int src_index = mad24(sy, src_step, sx + src_offset);\n"
"dst[dst_index] = src[src_index];\n"
"}\n"
"}\n"
"#elif defined AREA\n"
"#ifdef AREA_FAST\n"
"__kernel void resizeAREA_FAST(__global T * dst, __global T * src,\n"
"int dst_offset, int src_offset, int dst_step, int src_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, WT ifx, WT ify,\n"
"__global const int * dmap_tab, __global const int * smap_tab)\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if (dx < dst_cols && dy < dst_rows)\n"
"{\n"
"int dst_index = mad24(dy, dst_step, dst_offset + dx);\n"
"__global const int * xmap_tab = dmap_tab;\n"
"__global const int * ymap_tab = dmap_tab + dst_cols;\n"
"__global const int * sxmap_tab = smap_tab;\n"
"__global const int * symap_tab = smap_tab + XSCALE * dst_cols;\n"
"int sx = xmap_tab[dx], sy = ymap_tab[dy];\n"
"WTV sum = (WTV)(0);\n"
"#pragma unroll\n"
"for (int y = 0; y < YSCALE; ++y)\n"
"{\n"
"int src_index = mad24(symap_tab[y + sy], src_step, src_offset);\n"
"#pragma unroll\n"
"for (int x = 0; x < XSCALE; ++x)\n"
"sum += convertToWTV(src[src_index + sxmap_tab[sx + x]]);\n"
"}\n"
"dst[dst_index] = convertToT(convertToWT2V(sum) * (WT2V)(SCALE));\n"
"}\n"
"}\n"
"#else\n"
"__kernel void resizeAREA(__global T * dst, __global T * src,\n"
"int dst_offset, int src_offset, int dst_step, int src_step,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, WT ifx, WT ify,\n"
"__global const int * ofs_tab, __global const int * map_tab,\n"
"__global const float * alpha_tab)\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if (dx < dst_cols && dy < dst_rows)\n"
"{\n"
"int dst_index = mad24(dy, dst_step, dst_offset + dx);\n"
"__global const int * xmap_tab = map_tab;\n"
"__global const int * ymap_tab = (__global const int *)(map_tab + (src_cols << 1));\n"
"__global const float * xalpha_tab = alpha_tab;\n"
"__global const float * yalpha_tab = (__global const float *)(alpha_tab + (src_cols << 1));\n"
"__global const int * xofs_tab = ofs_tab;\n"
"__global const int * yofs_tab = (__global const int *)(ofs_tab + dst_cols + 1);\n"
"int xk0 = xofs_tab[dx], xk1 = xofs_tab[dx + 1];\n"
"int yk0 = yofs_tab[dy], yk1 = yofs_tab[dy + 1];\n"
"int sy0 = ymap_tab[yk0], sy1 = ymap_tab[yk1 - 1];\n"
"int sx0 = xmap_tab[xk0], sx1 = xmap_tab[xk1 - 1];\n"
"WTV sum = (WTV)(0), buf;\n"
"int src_index = mad24(sy0, src_step, src_offset);\n"
"for (int sy = sy0, yk = yk0; sy <= sy1; ++sy, src_index += src_step, ++yk)\n"
"{\n"
"WTV beta = (WTV)(yalpha_tab[yk]);\n"
"buf = (WTV)(0);\n"
"for (int sx = sx0, xk = xk0; sx <= sx1; ++sx, ++xk)\n"
"{\n"
"WTV alpha = (WTV)(xalpha_tab[xk]);\n"
"buf += convertToWTV(src[src_index + sx]) * alpha;\n"
"}\n"
"sum += buf * beta;\n"
"}\n"
"dst[dst_index] = convertToT(sum);\n"
"}\n"
"}\n"
"#endif\n"
"#endif\n"
, "dce4e0232bb7fd3e374f363a5311e3cc"};
const struct ProgramEntry imgproc_sobel3={"imgproc_sobel3",
"#ifdef BORDER_CONSTANT\n"
"#define EXTRAPOLATE(x, maxV)\n"
"#elif defined BORDER_REPLICATE\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"(x) = max(min((x), (maxV) - 1), 0); \\\n"
"}\n"
"#elif defined BORDER_WRAP\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"(x) = ( (x) + (maxV) ) % (maxV); \\\n"
"}\n"
"#elif defined BORDER_REFLECT\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"(x) = min( mad24((maxV)-1,2,-(x))+1 , max((x),-(x)-1) ); \\\n"
"}\n"
"#elif defined BORDER_REFLECT_101\n"
"#define EXTRAPOLATE(x, maxV) \\\n"
"{ \\\n"
"(x) = min( mad24((maxV)-1,2,-(x)), max((x),-(x)) ); \\\n"
"}\n"
"#else\n"
"#error No extrapolation method\n"
"#endif\n"
"#define SRC(_x,_y) convert_float(((global SRCTYPE*)(Src+(_y)*SrcPitch))[_x])\n"
"#ifdef BORDER_CONSTANT\n"
"#define ELEM(_x,_y,r_edge,t_edge,const_v) (_x)<0 | (_x) >= (r_edge) | (_y)<0 | (_y) >= (t_edge) ? (const_v) : SRC((_x),(_y))\n"
"#else\n"
"#define ELEM(_x,_y,r_edge,t_edge,const_v) SRC((_x),(_y))\n"
"#endif\n"
"#define DSTX(_x,_y) (((global float*)(DstX+DstXOffset+(_y)*DstXPitch))[_x])\n"
"#define DSTY(_x,_y) (((global float*)(DstY+DstYOffset+(_y)*DstYPitch))[_x])\n"
"#define INIT_AND_READ_LOCAL_SOURCE(width, height, fill_const, kernel_border) \\\n"
"int srcX = x + srcOffsetX - (kernel_border); \\\n"
"int srcY = y + srcOffsetY - (kernel_border); \\\n"
"int xb = srcX; \\\n"
"int yb = srcY; \\\n"
"\\\n"
"EXTRAPOLATE(xb, (width)); \\\n"
"EXTRAPOLATE(yb, (height)); \\\n"
"lsmem[liy][lix] = ELEM(xb, yb, (width), (height), (fill_const) ); \\\n"
"\\\n"
"if(lix < ((kernel_border)*2)) \\\n"
"{ \\\n"
"int xb = srcX+BLK_X; \\\n"
"EXTRAPOLATE(xb,(width)); \\\n"
"lsmem[liy][lix+BLK_X] = ELEM(xb, yb, (width), (height), (fill_const) ); \\\n"
"} \\\n"
"if(liy< ((kernel_border)*2)) \\\n"
"{ \\\n"
"int yb = srcY+BLK_Y; \\\n"
"EXTRAPOLATE(yb, (height)); \\\n"
"lsmem[liy+BLK_Y][lix] = ELEM(xb, yb, (width), (height), (fill_const) ); \\\n"
"} \\\n"
"if(lix<((kernel_border)*2) && liy<((kernel_border)*2)) \\\n"
"{ \\\n"
"int xb = srcX+BLK_X; \\\n"
"int yb = srcY+BLK_Y; \\\n"
"EXTRAPOLATE(xb,(width)); \\\n"
"EXTRAPOLATE(yb,(height)); \\\n"
"lsmem[liy+BLK_Y][lix+BLK_X] = ELEM(xb, yb, (width), (height), (fill_const) ); \\\n"
"}\n"
"__kernel void sobel3(\n"
"__global uchar* Src,\n"
"const uint      SrcPitch,\n"
"const int       srcOffsetX,\n"
"const int       srcOffsetY,\n"
"__global uchar* DstX,\n"
"const int       DstXOffset,\n"
"const uint      DstXPitch,\n"
"__global uchar* DstY,\n"
"const int       DstYOffset,\n"
"const uint      DstYPitch,\n"
"int             width,\n"
"int             height,\n"
"int             dstWidth,\n"
"int             dstHeight,\n"
"float           scale\n"
")\n"
"{\n"
"__local float lsmem[BLK_Y+2][BLK_X+2];\n"
"int lix = get_local_id(0);\n"
"int liy = get_local_id(1);\n"
"int x = (int)get_global_id(0);\n"
"int y = (int)get_global_id(1);\n"
"INIT_AND_READ_LOCAL_SOURCE(width, height, 0, 1)\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if( x >= dstWidth || y >=dstHeight )  return;\n"
"float u1 = lsmem[liy][lix];\n"
"float u2 = lsmem[liy][lix+1];\n"
"float u3 = lsmem[liy][lix+2];\n"
"float m1 = lsmem[liy+1][lix];\n"
"float m3 = lsmem[liy+1][lix+2];\n"
"float b1 = lsmem[liy+2][lix];\n"
"float b2 = lsmem[liy+2][lix+1];\n"
"float b3 = lsmem[liy+2][lix+2];\n"
"#ifdef SCHARR\n"
"DSTX(x,y) = mad(10.0f, m3 - m1, 3.0f * (u3 - u1 + b3 - b1)) * scale;\n"
"DSTY(x,y) = mad(10.0f, b2 - u2, 3.0f * (b1 - u1 + b3 - u3)) * scale;\n"
"#else\n"
"DSTX(x,y) = mad(2.0f, m3 - m1, u3 - u1 + b3 - b1) * scale;\n"
"DSTY(x,y) = mad(2.0f, b2 - u2, b1 - u1 + b3 - u3) * scale;\n"
"#endif\n"
"}\n"
"__kernel void sobel5(\n"
"__global uchar* Src,\n"
"const uint      SrcPitch,\n"
"const int       srcOffsetX,\n"
"const int       srcOffsetY,\n"
"__global uchar* DstX,\n"
"const int       DstXOffset,\n"
"const uint      DstXPitch,\n"
"__global uchar* DstY,\n"
"const int       DstYOffset,\n"
"const uint      DstYPitch,\n"
"int             width,\n"
"int             height,\n"
"int             dstWidth,\n"
"int             dstHeight,\n"
"float           scale\n"
")\n"
"{\n"
"__local float lsmem[BLK_Y+4][BLK_X+4];\n"
"int lix = get_local_id(0);\n"
"int liy = get_local_id(1);\n"
"int x = (int)get_global_id(0);\n"
"int y = (int)get_global_id(1);\n"
"INIT_AND_READ_LOCAL_SOURCE(width, height, 0, 2)\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if( x >= dstWidth || y >=dstHeight )  return;\n"
"float t1 = lsmem[liy][lix];\n"
"float t2 = lsmem[liy][lix+1];\n"
"float t3 = lsmem[liy][lix+2];\n"
"float t4 = lsmem[liy][lix+3];\n"
"float t5 = lsmem[liy][lix+4];\n"
"float u1 = lsmem[liy+1][lix];\n"
"float u2 = lsmem[liy+1][lix+1];\n"
"float u3 = lsmem[liy+1][lix+2];\n"
"float u4 = lsmem[liy+1][lix+3];\n"
"float u5 = lsmem[liy+1][lix+4];\n"
"float m1 = lsmem[liy+2][lix];\n"
"float m2 = lsmem[liy+2][lix+1];\n"
"float m4 = lsmem[liy+2][lix+3];\n"
"float m5 = lsmem[liy+2][lix+4];\n"
"float l1 = lsmem[liy+3][lix];\n"
"float l2 = lsmem[liy+3][lix+1];\n"
"float l3 = lsmem[liy+3][lix+2];\n"
"float l4 = lsmem[liy+3][lix+3];\n"
"float l5 = lsmem[liy+3][lix+4];\n"
"float b1 = lsmem[liy+4][lix];\n"
"float b2 = lsmem[liy+4][lix+1];\n"
"float b3 = lsmem[liy+4][lix+2];\n"
"float b4 = lsmem[liy+4][lix+3];\n"
"float b5 = lsmem[liy+4][lix+4];\n"
"DSTX(x,y) = scale *\n"
"mad(12.0f, m4 - m2,\n"
"mad(6.0f, m5 - m1,\n"
"mad(8.0f, u4 - u2 + l4 - l2,\n"
"mad(4.0f, u5 - u1 + l5 - l1,\n"
"mad(2.0f, t4 - t2 + b4 - b2, t5 - t1 + b5 - b1 )\n"
")\n"
")\n"
")\n"
");\n"
"DSTY(x,y) = scale *\n"
"mad(12.0f, l3 - u3,\n"
"mad(6.0f, b3 - t3,\n"
"mad(8.0f, l2 - u2 + l4 - u4,\n"
"mad(4.0f, b2 - t2 + b4 - t4,\n"
"mad(2.0f, l1 - u1 + l5 - u5, b1 - t1 + b5 - t5 )\n"
")\n"
")\n"
")\n"
");\n"
"}\n"
"__kernel void sobel7(\n"
"__global uchar* Src,\n"
"const uint      SrcPitch,\n"
"const int       srcOffsetX,\n"
"const int       srcOffsetY,\n"
"__global uchar* DstX,\n"
"const int       DstXOffset,\n"
"const uint      DstXPitch,\n"
"__global uchar* DstY,\n"
"const int       DstYOffset,\n"
"const uint      DstYPitch,\n"
"int             width,\n"
"int             height,\n"
"int             dstWidth,\n"
"int             dstHeight,\n"
"float           scale\n"
")\n"
"{\n"
"__local float lsmem[BLK_Y+6][BLK_X+6];\n"
"int lix = get_local_id(0);\n"
"int liy = get_local_id(1);\n"
"int x = (int)get_global_id(0);\n"
"int y = (int)get_global_id(1);\n"
"INIT_AND_READ_LOCAL_SOURCE(width, height, 0, 3)\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if( x >= dstWidth || y >=dstHeight )  return;\n"
"float tt1 = lsmem[liy][lix];\n"
"float tt2 = lsmem[liy][lix+1];\n"
"float tt3 = lsmem[liy][lix+2];\n"
"float tt4 = lsmem[liy][lix+3];\n"
"float tt5 = lsmem[liy][lix+4];\n"
"float tt6 = lsmem[liy][lix+5];\n"
"float tt7 = lsmem[liy][lix+6];\n"
"float t1 = lsmem[liy+1][lix];\n"
"float t2 = lsmem[liy+1][lix+1];\n"
"float t3 = lsmem[liy+1][lix+2];\n"
"float t4 = lsmem[liy+1][lix+3];\n"
"float t5 = lsmem[liy+1][lix+4];\n"
"float t6 = lsmem[liy+1][lix+5];\n"
"float t7 = lsmem[liy+1][lix+6];\n"
"float u1 = lsmem[liy+2][lix];\n"
"float u2 = lsmem[liy+2][lix+1];\n"
"float u3 = lsmem[liy+2][lix+2];\n"
"float u4 = lsmem[liy+2][lix+3];\n"
"float u5 = lsmem[liy+2][lix+4];\n"
"float u6 = lsmem[liy+2][lix+5];\n"
"float u7 = lsmem[liy+2][lix+6];\n"
"float m1 = lsmem[liy+3][lix];\n"
"float m2 = lsmem[liy+3][lix+1];\n"
"float m3 = lsmem[liy+3][lix+2];\n"
"float m5 = lsmem[liy+3][lix+4];\n"
"float m6 = lsmem[liy+3][lix+5];\n"
"float m7 = lsmem[liy+3][lix+6];\n"
"float l1 = lsmem[liy+4][lix];\n"
"float l2 = lsmem[liy+4][lix+1];\n"
"float l3 = lsmem[liy+4][lix+2];\n"
"float l4 = lsmem[liy+4][lix+3];\n"
"float l5 = lsmem[liy+4][lix+4];\n"
"float l6 = lsmem[liy+4][lix+5];\n"
"float l7 = lsmem[liy+4][lix+6];\n"
"float b1 = lsmem[liy+5][lix];\n"
"float b2 = lsmem[liy+5][lix+1];\n"
"float b3 = lsmem[liy+5][lix+2];\n"
"float b4 = lsmem[liy+5][lix+3];\n"
"float b5 = lsmem[liy+5][lix+4];\n"
"float b6 = lsmem[liy+5][lix+5];\n"
"float b7 = lsmem[liy+5][lix+6];\n"
"float bb1 = lsmem[liy+6][lix];\n"
"float bb2 = lsmem[liy+6][lix+1];\n"
"float bb3 = lsmem[liy+6][lix+2];\n"
"float bb4 = lsmem[liy+6][lix+3];\n"
"float bb5 = lsmem[liy+6][lix+4];\n"
"float bb6 = lsmem[liy+6][lix+5];\n"
"float bb7 = lsmem[liy+6][lix+6];\n"
"DSTX(x,y) = scale *\n"
"mad(100.0f, m5 - m3,\n"
"mad(80.0f, m6 - m2,\n"
"mad(20.0f, m7 - m1,\n"
"mad(75.0f, u5 - u3 + l5 - l3,\n"
"mad(60.0f, u6 - u2 + l6 - l2,\n"
"mad(15.0f, u7 - u1 + l7 - l1,\n"
"mad(30.0f, t5 - t3 + b5 - b3,\n"
"mad(24.0f, t6 - t2 + b6 - b2,\n"
"mad(6.0f, t7 - t1 + b7 - b1,\n"
"mad(5.0f, tt5 - tt3 + bb5 - bb3,\n"
"mad(4.0f, tt6 - tt2 + bb6 - bb2, tt7 - tt1 + bb7 - bb1 )\n"
")\n"
")\n"
")\n"
")\n"
")\n"
")\n"
")\n"
")\n"
")\n"
");\n"
"DSTY(x,y) = scale *\n"
"mad(100.0f, l4 - u4,\n"
"mad(80.0f, b4 - t4,\n"
"mad(20.0f, bb4 - tt4,\n"
"mad(75.0f, l5 - u5 + l3 - u3,\n"
"mad(60.0f, b5 - t5 + b3 - t3,\n"
"mad(15.0f, bb5 - tt5 + bb3 - tt3,\n"
"mad(30.0f, l6 - u6 + l2 - u2,\n"
"mad(24.0f, b6 - t6 + b2 - t2,\n"
"mad(6.0f, bb6 - tt6 + bb2 - tt2,\n"
"mad(5.0f, l7 - u7 + l1 - u1,\n"
"mad(4.0f, b7 - t7 + b1 - t1, bb7 - tt7 + bb1 - tt1 )\n"
")\n"
")\n"
")\n"
")\n"
")\n"
")\n"
")\n"
")\n"
")\n"
");\n"
"}\n"
, "d91d5e7d7c63952c08769030655a5c90"};
const struct ProgramEntry imgproc_threshold={"imgproc_threshold",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#ifdef VECTORIZED\n"
"__kernel void threshold(__global const T * restrict src, int src_offset, int src_step,\n"
"__global T * dst, int dst_offset, int dst_step,\n"
"T thresh, T max_val, int max_index, int rows, int cols)\n"
"{\n"
"int gx = get_global_id(0);\n"
"int gy = get_global_id(1);\n"
"if (gx < cols && gy < rows)\n"
"{\n"
"gx *= VECSIZE;\n"
"int src_index = mad24(gy, src_step, src_offset + gx);\n"
"int dst_index = mad24(gy, dst_step, dst_offset + gx);\n"
"#ifdef SRC_ALIGNED\n"
"VT sdata = *((__global VT *)(src + src_index));\n"
"#else\n"
"VT sdata = VLOADN(0, src + src_index);\n"
"#endif\n"
"VT vthresh = (VT)(thresh);\n"
"#ifdef THRESH_BINARY\n"
"VT vecValue = sdata > vthresh ? (VT)max_val : (VT)(0);\n"
"#elif defined THRESH_BINARY_INV\n"
"VT vecValue = sdata > vthresh ? (VT)(0) : (VT)max_val;\n"
"#elif defined THRESH_TRUNC\n"
"VT vecValue = sdata > vthresh ? (VT)thresh : sdata;\n"
"#elif defined THRESH_TOZERO\n"
"VT vecValue = sdata > vthresh ? sdata : (VT)(0);\n"
"#elif defined THRESH_TOZERO_INV\n"
"VT vecValue = sdata > vthresh ? (VT)(0) : sdata;\n"
"#endif\n"
"if (gx + VECSIZE <= max_index)\n"
"#ifdef DST_ALIGNED\n"
"*(__global VT*)(dst + dst_index) = vecValue;\n"
"#else\n"
"VSTOREN(vecValue, 0, dst + dst_index);\n"
"#endif\n"
"else\n"
"{\n"
"__attribute__(( aligned(sizeof(VT)) )) T array[VECSIZE];\n"
"*((VT*)array) = vecValue;\n"
"#pragma unroll\n"
"for (int i = 0; i < VECSIZE; ++i)\n"
"if (gx + i < max_index)\n"
"dst[dst_index + i] = array[i];\n"
"}\n"
"}\n"
"}\n"
"#else\n"
"__kernel void threshold(__global const T * restrict src, int src_offset, int src_step,\n"
"__global T * dst, int dst_offset, int dst_step,\n"
"T thresh, T max_val, int rows, int cols)\n"
"{\n"
"int gx = get_global_id(0);\n"
"int gy = get_global_id(1);\n"
"if (gx < cols && gy < rows)\n"
"{\n"
"int src_index = mad24(gy, src_step, src_offset + gx);\n"
"int dst_index = mad24(gy, dst_step, dst_offset + gx);\n"
"T sdata = src[src_index];\n"
"#ifdef THRESH_BINARY\n"
"dst[dst_index] = sdata > thresh ? max_val : (T)(0);\n"
"#elif defined THRESH_BINARY_INV\n"
"dst[dst_index] = sdata > thresh ? (T)(0) : max_val;\n"
"#elif defined THRESH_TRUNC\n"
"dst[dst_index] = sdata > thresh ? thresh : sdata;\n"
"#elif defined THRESH_TOZERO\n"
"dst[dst_index] = sdata > thresh ? sdata : (T)(0);\n"
"#elif defined THRESH_TOZERO_INV\n"
"dst[dst_index] = sdata > thresh ? (T)(0) : sdata;\n"
"#endif\n"
"}\n"
"}\n"
"#endif\n"
, "3d9631e061a5b037ea5cfb86b156d984"};
const struct ProgramEntry imgproc_warpAffine={"imgproc_warpAffine",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"typedef double F;\n"
"typedef double4 F4;\n"
"#define convert_F4 convert_double4\n"
"#else\n"
"typedef float F;\n"
"typedef float4 F4;\n"
"#define convert_F4 convert_float4\n"
"#endif\n"
"#define INTER_BITS 5\n"
"#define INTER_TAB_SIZE (1 << INTER_BITS)\n"
"#define INTER_SCALE 1.f/INTER_TAB_SIZE\n"
"#define AB_BITS max(10, (int)INTER_BITS)\n"
"#define AB_SCALE (1 << AB_BITS)\n"
"#define INTER_REMAP_COEF_BITS 15\n"
"#define INTER_REMAP_COEF_SCALE (1 << INTER_REMAP_COEF_BITS)\n"
"void interpolateCubic( float x, float* coeffs )\n"
"{\n"
"const float A = -0.75f;\n"
"coeffs[0] = ((A*(x + 1.f) - 5.0f*A)*(x + 1.f) + 8.0f*A)*(x + 1.f) - 4.0f*A;\n"
"coeffs[1] = ((A + 2.f)*x - (A + 3.f))*x*x + 1.f;\n"
"coeffs[2] = ((A + 2.f)*(1.f - x) - (A + 3.f))*(1.f - x)*(1.f - x) + 1.f;\n"
"coeffs[3] = 1.f - coeffs[0] - coeffs[1] - coeffs[2];\n"
"}\n"
"__kernel void warpAffineNN_C1_D0(__global uchar const * restrict src, __global uchar * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"dx = (dx<<2) - (dst_offset&3);\n"
"int round_delta = (AB_SCALE>>1);\n"
"int4 X, Y;\n"
"int4 sx, sy;\n"
"int4 DX = (int4)(dx, dx+1, dx+2, dx+3);\n"
"DX = (DX << AB_BITS);\n"
"F4 M0DX, M3DX;\n"
"M0DX = M[0] * convert_F4(DX);\n"
"M3DX = M[3] * convert_F4(DX);\n"
"X = convert_int4(rint(M0DX));\n"
"Y = convert_int4(rint(M3DX));\n"
"int tmp1, tmp2;\n"
"tmp1 = rint((M[1]*dy + M[2]) * AB_SCALE);\n"
"tmp2 = rint((M[4]*dy + M[5]) * AB_SCALE);\n"
"X += tmp1 + round_delta;\n"
"Y += tmp2 + round_delta;\n"
"sx = convert_int4(convert_short4(X >> AB_BITS));\n"
"sy = convert_int4(convert_short4(Y >> AB_BITS));\n"
"__global uchar4 * d = (__global uchar4 *)(dst+dst_offset+dy*dstStep+dx);\n"
"uchar4 dval = *d;\n"
"DX = (int4)(dx, dx+1, dx+2, dx+3);\n"
"int4 dcon = DX >= 0 && DX < dst_cols && dy >= 0 && dy < dst_rows;\n"
"int4 scon = sx >= 0 && sx < src_cols && sy >= 0 && sy < src_rows;\n"
"int4 spos = src_offset + sy * srcStep + sx;\n"
"uchar4 sval;\n"
"sval.s0 = scon.s0 ? src[spos.s0] : 0;\n"
"sval.s1 = scon.s1 ? src[spos.s1] : 0;\n"
"sval.s2 = scon.s2 ? src[spos.s2] : 0;\n"
"sval.s3 = scon.s3 ? src[spos.s3] : 0;\n"
"dval = convert_uchar4(dcon) != (uchar4)(0,0,0,0) ? sval : dval;\n"
"*d = dval;\n"
"}\n"
"}\n"
"__kernel void warpAffineLinear_C1_D0(__global const uchar * restrict src, __global uchar * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"dx = (dx<<2) - (dst_offset&3);\n"
"int round_delta = ((AB_SCALE >> INTER_BITS) >> 1);\n"
"int4 X, Y;\n"
"short4  ax, ay;\n"
"int4 sx, sy;\n"
"int4 DX = (int4)(dx, dx+1, dx+2, dx+3);\n"
"DX = (DX << AB_BITS);\n"
"F4 M0DX, M3DX;\n"
"M0DX = M[0] * convert_F4(DX);\n"
"M3DX = M[3] * convert_F4(DX);\n"
"X = convert_int4(rint(M0DX));\n"
"Y = convert_int4(rint(M3DX));\n"
"int tmp1, tmp2;\n"
"tmp1 = rint((M[1]*dy + M[2]) * AB_SCALE);\n"
"tmp2 = rint((M[4]*dy + M[5]) * AB_SCALE);\n"
"X += tmp1 + round_delta;\n"
"Y += tmp2 + round_delta;\n"
"X = X >> (AB_BITS - INTER_BITS);\n"
"Y = Y >> (AB_BITS - INTER_BITS);\n"
"sx = convert_int4(convert_short4(X >> INTER_BITS));\n"
"sy = convert_int4(convert_short4(Y >> INTER_BITS));\n"
"ax = convert_short4(X & (INTER_TAB_SIZE-1));\n"
"ay = convert_short4(Y & (INTER_TAB_SIZE-1));\n"
"uchar4 v0, v1, v2,v3;\n"
"int4 scon0, scon1, scon2, scon3;\n"
"int4 spos0, spos1, spos2, spos3;\n"
"scon0 = (sx >= 0 && sx < src_cols && sy >= 0 && sy < src_rows);\n"
"scon1 = (sx+1 >= 0 && sx+1 < src_cols && sy >= 0 && sy < src_rows);\n"
"scon2 = (sx >= 0 && sx < src_cols && sy+1 >= 0 && sy+1 < src_rows);\n"
"scon3 = (sx+1 >= 0 && sx+1 < src_cols && sy+1 >= 0 && sy+1 < src_rows);\n"
"spos0 = src_offset + sy * srcStep + sx;\n"
"spos1 = src_offset + sy * srcStep + sx + 1;\n"
"spos2 = src_offset + (sy+1) * srcStep + sx;\n"
"spos3 = src_offset + (sy+1) * srcStep + sx + 1;\n"
"v0.s0 = scon0.s0 ? src[spos0.s0] : 0;\n"
"v1.s0 = scon1.s0 ? src[spos1.s0] : 0;\n"
"v2.s0 = scon2.s0 ? src[spos2.s0] : 0;\n"
"v3.s0 = scon3.s0 ? src[spos3.s0] : 0;\n"
"v0.s1 = scon0.s1 ? src[spos0.s1] : 0;\n"
"v1.s1 = scon1.s1 ? src[spos1.s1] : 0;\n"
"v2.s1 = scon2.s1 ? src[spos2.s1] : 0;\n"
"v3.s1 = scon3.s1 ? src[spos3.s1] : 0;\n"
"v0.s2 = scon0.s2 ? src[spos0.s2] : 0;\n"
"v1.s2 = scon1.s2 ? src[spos1.s2] : 0;\n"
"v2.s2 = scon2.s2 ? src[spos2.s2] : 0;\n"
"v3.s2 = scon3.s2 ? src[spos3.s2] : 0;\n"
"v0.s3 = scon0.s3 ? src[spos0.s3] : 0;\n"
"v1.s3 = scon1.s3 ? src[spos1.s3] : 0;\n"
"v2.s3 = scon2.s3 ? src[spos2.s3] : 0;\n"
"v3.s3 = scon3.s3 ? src[spos3.s3] : 0;\n"
"short4 itab0, itab1, itab2, itab3;\n"
"float4 taby, tabx;\n"
"taby = INTER_SCALE * convert_float4(ay);\n"
"tabx = INTER_SCALE * convert_float4(ax);\n"
"itab0 = convert_short4_sat(( (1.0f-taby)*(1.0f-tabx) * (float4)INTER_REMAP_COEF_SCALE ));\n"
"itab1 = convert_short4_sat(( (1.0f-taby)*tabx * (float4)INTER_REMAP_COEF_SCALE ));\n"
"itab2 = convert_short4_sat(( taby*(1.0f-tabx) * (float4)INTER_REMAP_COEF_SCALE ));\n"
"itab3 = convert_short4_sat(( taby*tabx * (float4)INTER_REMAP_COEF_SCALE ));\n"
"int4 val;\n"
"uchar4 tval;\n"
"val = convert_int4(v0) * convert_int4(itab0) + convert_int4(v1) * convert_int4(itab1)\n"
"+ convert_int4(v2) * convert_int4(itab2) + convert_int4(v3) * convert_int4(itab3);\n"
"tval = convert_uchar4_sat ( (val + (1 << (INTER_REMAP_COEF_BITS-1))) >> INTER_REMAP_COEF_BITS ) ;\n"
"__global uchar4 * d =(__global uchar4 *)(dst+dst_offset+dy*dstStep+dx);\n"
"uchar4 dval = *d;\n"
"DX = (int4)(dx, dx+1, dx+2, dx+3);\n"
"int4 dcon = DX >= 0 && DX < dst_cols && dy >= 0 && dy < dst_rows;\n"
"dval = convert_uchar4(dcon != 0) ? tval : dval;\n"
"*d = dval;\n"
"}\n"
"}\n"
"__kernel void warpAffineCubic_C1_D0(__global uchar * src, __global uchar * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = ((AB_SCALE>>INTER_BITS)>>1);\n"
"int X0 = rint(M[0] * dx * AB_SCALE);\n"
"int Y0 = rint(M[3] * dx * AB_SCALE);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"int X = X0 >> (AB_BITS - INTER_BITS);\n"
"int Y = Y0 >> (AB_BITS - INTER_BITS);\n"
"short sx = (short)(X >> INTER_BITS) - 1;\n"
"short sy = (short)(Y >> INTER_BITS) - 1;\n"
"short ay = (short)(Y & (INTER_TAB_SIZE-1));\n"
"short ax = (short)(X & (INTER_TAB_SIZE-1));\n"
"uchar v[16];\n"
"int i, j;\n"
"#pragma unroll 4\n"
"for(i=0; i<4;  i++)\n"
"for(j=0; j<4;  j++)\n"
"{\n"
"v[i*4+j] = (sx+j >= 0 && sx+j < src_cols && sy+i >= 0 && sy+i < src_rows) ? src[src_offset+(sy+i) * srcStep + (sx+j)] : 0;\n"
"}\n"
"short itab[16];\n"
"float tab1y[4], tab1x[4];\n"
"float axx, ayy;\n"
"ayy = 1.f/INTER_TAB_SIZE * ay;\n"
"axx = 1.f/INTER_TAB_SIZE * ax;\n"
"interpolateCubic(ayy, tab1y);\n"
"interpolateCubic(axx, tab1x);\n"
"int isum = 0;\n"
"#pragma unroll 16\n"
"for( i=0; i<16; i++ )\n"
"{\n"
"F v = tab1y[(i>>2)] * tab1x[(i&3)];\n"
"isum += itab[i] = convert_short_sat( rint( v * INTER_REMAP_COEF_SCALE ) );\n"
"}\n"
"if( isum != INTER_REMAP_COEF_SCALE )\n"
"{\n"
"int k1, k2;\n"
"int diff = isum - INTER_REMAP_COEF_SCALE;\n"
"int Mk1=2, Mk2=2, mk1=2, mk2=2;\n"
"for( k1 = 2; k1 < 4; k1++ )\n"
"for( k2 = 2; k2 < 4; k2++ )\n"
"{\n"
"if( itab[(k1<<2)+k2] < itab[(mk1<<2)+mk2] )\n"
"mk1 = k1, mk2 = k2;\n"
"else if( itab[(k1<<2)+k2] > itab[(Mk1<<2)+Mk2] )\n"
"Mk1 = k1, Mk2 = k2;\n"
"}\n"
"diff<0 ? (itab[(Mk1<<2)+Mk2]=(short)(itab[(Mk1<<2)+Mk2]-diff)) : (itab[(mk1<<2)+mk2]=(short)(itab[(mk1<<2)+mk2]-diff));\n"
"}\n"
"if( dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"int sum=0;\n"
"for ( i =0; i<16; i++ )\n"
"{\n"
"sum += v[i] * itab[i] ;\n"
"}\n"
"dst[dst_offset+dy*dstStep+dx] = convert_uchar_sat( (sum + (1 << (INTER_REMAP_COEF_BITS-1))) >> INTER_REMAP_COEF_BITS ) ;\n"
"}\n"
"}\n"
"}\n"
"__kernel void warpAffineNN_C4_D0(__global uchar4 const * restrict src, __global uchar4 * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = (AB_SCALE >> 1);\n"
"int X0 = rint(M[0] * dx * AB_SCALE);\n"
"int Y0 = rint(M[3] * dx * AB_SCALE);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"int sx0 = (short)(X0 >> AB_BITS);\n"
"int sy0 = (short)(Y0 >> AB_BITS);\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>2)+dy*(dstStep>>2)+dx]= (sx0>=0 && sx0<src_cols && sy0>=0 && sy0<src_rows) ? src[(src_offset>>2)+sy0*(srcStep>>2)+sx0] : (uchar4)0;\n"
"}\n"
"}\n"
"__kernel void warpAffineLinear_C4_D0(__global uchar4 const * restrict src, __global uchar4 * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = AB_SCALE/INTER_TAB_SIZE/2;\n"
"src_offset = (src_offset>>2);\n"
"srcStep = (srcStep>>2);\n"
"int tmp = (dx << AB_BITS);\n"
"int X0 = rint(M[0] * tmp);\n"
"int Y0 = rint(M[3] * tmp);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"X0 = X0 >> (AB_BITS - INTER_BITS);\n"
"Y0 = Y0 >> (AB_BITS - INTER_BITS);\n"
"short sx0 = (short)(X0 >> INTER_BITS);\n"
"short sy0 = (short)(Y0 >> INTER_BITS);\n"
"short ax0 = (short)(X0 & (INTER_TAB_SIZE-1));\n"
"short ay0 = (short)(Y0 & (INTER_TAB_SIZE-1));\n"
"int4 v0, v1, v2, v3;\n"
"v0 = (sx0 >= 0 && sx0 < src_cols && sy0 >= 0 && sy0 < src_rows) ? convert_int4(src[src_offset+sy0 * srcStep + sx0]) : 0;\n"
"v1 = (sx0+1 >= 0 && sx0+1 < src_cols && sy0 >= 0 && sy0 < src_rows) ? convert_int4(src[src_offset+sy0 * srcStep + sx0+1]) : 0;\n"
"v2 = (sx0 >= 0 && sx0 < src_cols && sy0+1 >= 0 && sy0+1 < src_rows) ? convert_int4(src[src_offset+(sy0+1) * srcStep + sx0]) : 0;\n"
"v3 = (sx0+1 >= 0 && sx0+1 < src_cols && sy0+1 >= 0 && sy0+1 < src_rows) ? convert_int4(src[src_offset+(sy0+1) * srcStep + sx0+1]) : 0;\n"
"int itab0, itab1, itab2, itab3;\n"
"float taby, tabx;\n"
"taby = 1.f/INTER_TAB_SIZE*ay0;\n"
"tabx = 1.f/INTER_TAB_SIZE*ax0;\n"
"itab0 = convert_short_sat(rint( (1.0f-taby)*(1.0f-tabx) * INTER_REMAP_COEF_SCALE ));\n"
"itab1 = convert_short_sat(rint( (1.0f-taby)*tabx * INTER_REMAP_COEF_SCALE ));\n"
"itab2 = convert_short_sat(rint( taby*(1.0f-tabx) * INTER_REMAP_COEF_SCALE ));\n"
"itab3 = convert_short_sat(rint( taby*tabx * INTER_REMAP_COEF_SCALE ));\n"
"int4 val;\n"
"val = v0 * itab0 +  v1 * itab1 + v2 * itab2 + v3 * itab3;\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>2)+dy*(dstStep>>2)+dx] =  convert_uchar4_sat ( (val + (1 << (INTER_REMAP_COEF_BITS-1))) >> INTER_REMAP_COEF_BITS ) ;\n"
"}\n"
"}\n"
"__kernel void warpAffineCubic_C4_D0(__global uchar4 const * restrict src, __global uchar4 * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = ((AB_SCALE>>INTER_BITS)>>1);\n"
"src_offset = (src_offset>>2);\n"
"srcStep = (srcStep>>2);\n"
"dst_offset = (dst_offset>>2);\n"
"dstStep = (dstStep>>2);\n"
"int tmp = (dx << AB_BITS);\n"
"int X0 = rint(M[0] * tmp);\n"
"int Y0 = rint(M[3] * tmp);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"X0 = X0 >> (AB_BITS - INTER_BITS);\n"
"Y0 = Y0 >> (AB_BITS - INTER_BITS);\n"
"int sx = (short)(X0 >> INTER_BITS) - 1;\n"
"int sy = (short)(Y0 >> INTER_BITS) - 1;\n"
"int ay = (short)(Y0 & (INTER_TAB_SIZE-1));\n"
"int ax = (short)(X0 & (INTER_TAB_SIZE-1));\n"
"uchar4 v[16];\n"
"int i,j;\n"
"#pragma unroll 4\n"
"for(i=0; i<4; i++)\n"
"for(j=0; j<4; j++)\n"
"{\n"
"v[i*4+j] = (sx+j >= 0 && sx+j < src_cols && sy+i >= 0 && sy+i < src_rows) ? (src[src_offset+(sy+i) * srcStep + (sx+j)])  : (uchar4)0;\n"
"}\n"
"int itab[16];\n"
"float tab1y[4], tab1x[4];\n"
"float axx, ayy;\n"
"ayy = INTER_SCALE * ay;\n"
"axx = INTER_SCALE * ax;\n"
"interpolateCubic(ayy, tab1y);\n"
"interpolateCubic(axx, tab1x);\n"
"int isum = 0;\n"
"#pragma unroll 16\n"
"for( i=0; i<16; i++ )\n"
"{\n"
"float tmp;\n"
"tmp = tab1y[(i>>2)] * tab1x[(i&3)] * INTER_REMAP_COEF_SCALE;\n"
"itab[i] = rint(tmp);\n"
"isum += itab[i];\n"
"}\n"
"if( isum != INTER_REMAP_COEF_SCALE )\n"
"{\n"
"int k1, k2;\n"
"int diff = isum - INTER_REMAP_COEF_SCALE;\n"
"int Mk1=2, Mk2=2, mk1=2, mk2=2;\n"
"for( k1 = 2; k1 < 4; k1++ )\n"
"for( k2 = 2; k2 < 4; k2++ )\n"
"{\n"
"if( itab[(k1<<2)+k2] < itab[(mk1<<2)+mk2] )\n"
"mk1 = k1, mk2 = k2;\n"
"else if( itab[(k1<<2)+k2] > itab[(Mk1<<2)+Mk2] )\n"
"Mk1 = k1, Mk2 = k2;\n"
"}\n"
"diff<0 ? (itab[(Mk1<<2)+Mk2]=(short)(itab[(Mk1<<2)+Mk2]-diff)) : (itab[(mk1<<2)+mk2]=(short)(itab[(mk1<<2)+mk2]-diff));\n"
"}\n"
"if( dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"int4 sum=0;\n"
"for ( i =0; i<16; i++ )\n"
"{\n"
"sum += convert_int4(v[i]) * itab[i];\n"
"}\n"
"dst[dst_offset+dy*dstStep+dx] = convert_uchar4_sat( (sum + (1 << (INTER_REMAP_COEF_BITS-1))) >> INTER_REMAP_COEF_BITS ) ;\n"
"}\n"
"}\n"
"}\n"
"__kernel void warpAffineNN_C1_D5(__global float * src, __global float * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = AB_SCALE/2;\n"
"int X0 = rint(M[0] * dx * AB_SCALE);\n"
"int Y0 = rint(M[3] * dx * AB_SCALE);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"short sx0 = (short)(X0 >> AB_BITS);\n"
"short sy0 = (short)(Y0 >> AB_BITS);\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>2)+dy*dstStep+dx]= (sx0>=0 && sx0<src_cols && sy0>=0 && sy0<src_rows) ? src[(src_offset>>2)+sy0*srcStep+sx0] : 0;\n"
"}\n"
"}\n"
"__kernel void warpAffineLinear_C1_D5(__global float * src, __global float * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = AB_SCALE/INTER_TAB_SIZE/2;\n"
"src_offset = (src_offset>>2);\n"
"int X0 = rint(M[0] * dx * AB_SCALE);\n"
"int Y0 = rint(M[3] * dx * AB_SCALE);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"X0 = X0 >> (AB_BITS - INTER_BITS);\n"
"Y0 = Y0 >> (AB_BITS - INTER_BITS);\n"
"short sx0 = (short)(X0 >> INTER_BITS);\n"
"short sy0 = (short)(Y0 >> INTER_BITS);\n"
"short ax0 = (short)(X0 & (INTER_TAB_SIZE-1));\n"
"short ay0 = (short)(Y0 & (INTER_TAB_SIZE-1));\n"
"float v0, v1, v2, v3;\n"
"v0 = (sx0 >= 0 && sx0 < src_cols && sy0 >= 0 && sy0 < src_rows) ? src[src_offset+sy0 * srcStep + sx0] : 0;\n"
"v1 = (sx0+1 >= 0 && sx0+1 < src_cols && sy0 >= 0 && sy0 < src_rows) ? src[src_offset+sy0 * srcStep + sx0+1] : 0;\n"
"v2 = (sx0 >= 0 && sx0 < src_cols && sy0+1 >= 0 && sy0+1 < src_rows) ? src[src_offset+(sy0+1) * srcStep + sx0] : 0;\n"
"v3 = (sx0+1 >= 0 && sx0+1 < src_cols && sy0+1 >= 0 && sy0+1 < src_rows) ? src[src_offset+(sy0+1) * srcStep + sx0+1] : 0;\n"
"float tab[4];\n"
"float taby[2], tabx[2];\n"
"taby[0] = 1.0f - 1.f/INTER_TAB_SIZE*ay0;\n"
"taby[1] = 1.f/INTER_TAB_SIZE*ay0;\n"
"tabx[0] = 1.0f - 1.f/INTER_TAB_SIZE*ax0;\n"
"tabx[1] = 1.f/INTER_TAB_SIZE*ax0;\n"
"tab[0] = taby[0] * tabx[0];\n"
"tab[1] = taby[0] * tabx[1];\n"
"tab[2] = taby[1] * tabx[0];\n"
"tab[3] = taby[1] * tabx[1];\n"
"float sum = 0;\n"
"sum += v0 * tab[0] +  v1 * tab[1] +  v2 * tab[2] +  v3 * tab[3];\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>2)+dy*dstStep+dx] = sum;\n"
"}\n"
"}\n"
"__kernel void warpAffineCubic_C1_D5(__global float * src, __global float * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = AB_SCALE/INTER_TAB_SIZE/2;\n"
"src_offset = (src_offset>>2);\n"
"dst_offset = (dst_offset>>2);\n"
"int X0 = rint(M[0] * dx * AB_SCALE);\n"
"int Y0 = rint(M[3] * dx * AB_SCALE);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"X0 = X0 >> (AB_BITS - INTER_BITS);\n"
"Y0 = Y0 >> (AB_BITS - INTER_BITS);\n"
"short sx = (short)(X0 >> INTER_BITS) - 1;\n"
"short sy = (short)(Y0 >> INTER_BITS) - 1;\n"
"short ay = (short)(Y0 & (INTER_TAB_SIZE-1));\n"
"short ax = (short)(X0 & (INTER_TAB_SIZE-1));\n"
"float v[16];\n"
"int i;\n"
"for(i=0; i<16;  i++)\n"
"v[i] = (sx+(i&3) >= 0 && sx+(i&3) < src_cols && sy+(i>>2) >= 0 && sy+(i>>2) < src_rows) ? src[src_offset+(sy+(i>>2)) * srcStep + (sx+(i&3))] : 0;\n"
"float tab[16];\n"
"float tab1y[4], tab1x[4];\n"
"float axx, ayy;\n"
"ayy = 1.f/INTER_TAB_SIZE * ay;\n"
"axx = 1.f/INTER_TAB_SIZE * ax;\n"
"interpolateCubic(ayy, tab1y);\n"
"interpolateCubic(axx, tab1x);\n"
"#pragma unroll 4\n"
"for( i=0; i<16; i++ )\n"
"{\n"
"tab[i] = tab1y[(i>>2)] * tab1x[(i&3)];\n"
"}\n"
"if( dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"float sum = 0;\n"
"#pragma unroll 4\n"
"for ( i =0; i<16; i++ )\n"
"{\n"
"sum += v[i] * tab[i];\n"
"}\n"
"dst[dst_offset+dy*dstStep+dx] = sum;\n"
"}\n"
"}\n"
"}\n"
"__kernel void warpAffineNN_C4_D5(__global float4 * src, __global float4 * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = AB_SCALE/2;\n"
"int X0 = rint(M[0] * dx * AB_SCALE);\n"
"int Y0 = rint(M[3] * dx * AB_SCALE);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"short sx0 = (short)(X0 >> AB_BITS);\n"
"short sy0 = (short)(Y0 >> AB_BITS);\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>4)+dy*(dstStep>>2)+dx]= (sx0>=0 && sx0<src_cols && sy0>=0 && sy0<src_rows) ? src[(src_offset>>4)+sy0*(srcStep>>2)+sx0] : (float4)0;\n"
"}\n"
"}\n"
"__kernel void warpAffineLinear_C4_D5(__global float4 * src, __global float4 * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = AB_SCALE/INTER_TAB_SIZE/2;\n"
"src_offset = (src_offset>>4);\n"
"dst_offset = (dst_offset>>4);\n"
"srcStep = (srcStep>>2);\n"
"dstStep = (dstStep>>2);\n"
"int X0 = rint(M[0] * dx * AB_SCALE);\n"
"int Y0 = rint(M[3] * dx * AB_SCALE);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"X0 = X0 >> (AB_BITS - INTER_BITS);\n"
"Y0 = Y0 >> (AB_BITS - INTER_BITS);\n"
"short sx0 = (short)(X0 >> INTER_BITS);\n"
"short sy0 = (short)(Y0 >> INTER_BITS);\n"
"short ax0 = (short)(X0 & (INTER_TAB_SIZE-1));\n"
"short ay0 = (short)(Y0 & (INTER_TAB_SIZE-1));\n"
"float4 v0, v1, v2, v3;\n"
"v0 = (sx0 >= 0 && sx0 < src_cols && sy0 >= 0 && sy0 < src_rows) ? src[src_offset+sy0 * srcStep + sx0] : (float4)0;\n"
"v1 = (sx0+1 >= 0 && sx0+1 < src_cols && sy0 >= 0 && sy0 < src_rows) ? src[src_offset+sy0 * srcStep + sx0+1] : (float4)0;\n"
"v2 = (sx0 >= 0 && sx0 < src_cols && sy0+1 >= 0 && sy0+1 < src_rows) ? src[src_offset+(sy0+1) * srcStep + sx0] : (float4)0;\n"
"v3 = (sx0+1 >= 0 && sx0+1 < src_cols && sy0+1 >= 0 && sy0+1 < src_rows) ? src[src_offset+(sy0+1) * srcStep + sx0+1] : (float4)0;\n"
"float tab[4];\n"
"float taby[2], tabx[2];\n"
"taby[0] = 1.0f - 1.f/INTER_TAB_SIZE*ay0;\n"
"taby[1] = 1.f/INTER_TAB_SIZE*ay0;\n"
"tabx[0] = 1.0f - 1.f/INTER_TAB_SIZE*ax0;\n"
"tabx[1] = 1.f/INTER_TAB_SIZE*ax0;\n"
"tab[0] = taby[0] * tabx[0];\n"
"tab[1] = taby[0] * tabx[1];\n"
"tab[2] = taby[1] * tabx[0];\n"
"tab[3] = taby[1] * tabx[1];\n"
"float4 sum = 0;\n"
"sum += v0 * tab[0] +  v1 * tab[1] +  v2 * tab[2] +  v3 * tab[3];\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[dst_offset+dy*dstStep+dx] = sum;\n"
"}\n"
"}\n"
"__kernel void warpAffineCubic_C4_D5(__global float4 * src, __global float4 * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"int round_delta = AB_SCALE/INTER_TAB_SIZE/2;\n"
"src_offset = (src_offset>>4);\n"
"dst_offset = (dst_offset>>4);\n"
"srcStep = (srcStep>>2);\n"
"dstStep = (dstStep>>2);\n"
"int X0 = rint(M[0] * dx * AB_SCALE);\n"
"int Y0 = rint(M[3] * dx * AB_SCALE);\n"
"X0 += rint((M[1]*dy + M[2]) * AB_SCALE) + round_delta;\n"
"Y0 += rint((M[4]*dy + M[5]) * AB_SCALE) + round_delta;\n"
"X0 = X0 >> (AB_BITS - INTER_BITS);\n"
"Y0 = Y0 >> (AB_BITS - INTER_BITS);\n"
"short sx = (short)(X0 >> INTER_BITS) - 1;\n"
"short sy = (short)(Y0 >> INTER_BITS) - 1;\n"
"short ay = (short)(Y0 & (INTER_TAB_SIZE-1));\n"
"short ax = (short)(X0 & (INTER_TAB_SIZE-1));\n"
"float4 v[16];\n"
"int i;\n"
"for(i=0; i<16;  i++)\n"
"v[i] = (sx+(i&3) >= 0 && sx+(i&3) < src_cols && sy+(i>>2) >= 0 && sy+(i>>2) < src_rows) ? src[src_offset+(sy+(i>>2)) * srcStep + (sx+(i&3))] : (float4)0;\n"
"float tab[16];\n"
"float tab1y[4], tab1x[4];\n"
"float axx, ayy;\n"
"ayy = 1.f/INTER_TAB_SIZE * ay;\n"
"axx = 1.f/INTER_TAB_SIZE * ax;\n"
"interpolateCubic(ayy, tab1y);\n"
"interpolateCubic(axx, tab1x);\n"
"#pragma unroll 4\n"
"for( i=0; i<16; i++ )\n"
"{\n"
"tab[i] = tab1y[(i>>2)] * tab1x[(i&3)];\n"
"}\n"
"if( dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"float4 sum = 0;\n"
"#pragma unroll 4\n"
"for ( i =0; i<16; i++ )\n"
"{\n"
"sum += v[i] * tab[i];\n"
"}\n"
"dst[dst_offset+dy*dstStep+dx] = sum;\n"
"}\n"
"}\n"
"}\n"
, "0a1ddf381453d856788b2d2f92df08a8"};
const struct ProgramEntry imgproc_warpPerspective={"imgproc_warpPerspective",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"typedef double F;\n"
"typedef double4 F4;\n"
"#define convert_F4 convert_double4\n"
"#else\n"
"typedef float F;\n"
"typedef float4 F4;\n"
"#define convert_F4 convert_float4\n"
"#endif\n"
"#define INTER_BITS 5\n"
"#define INTER_TAB_SIZE (1 << INTER_BITS)\n"
"#define INTER_SCALE 1.f/INTER_TAB_SIZE\n"
"#define AB_BITS max(10, (int)INTER_BITS)\n"
"#define AB_SCALE (1 << AB_BITS)\n"
"#define INTER_REMAP_COEF_BITS 15\n"
"#define INTER_REMAP_COEF_SCALE (1 << INTER_REMAP_COEF_BITS)\n"
"void interpolateCubic( float x, float* coeffs )\n"
"{\n"
"const float A = -0.75f;\n"
"coeffs[0] = ((A*(x + 1.f) - 5.0f*A)*(x + 1.f) + 8.0f*A)*(x + 1.f) - 4.0f*A;\n"
"coeffs[1] = ((A + 2.f)*x - (A + 3.f))*x*x + 1.f;\n"
"coeffs[2] = ((A + 2.f)*(1.f - x) - (A + 3.f))*(1.f - x)*(1.f - x) + 1.f;\n"
"coeffs[3] = 1.f - coeffs[0] - coeffs[1] - coeffs[2];\n"
"}\n"
"__kernel void warpPerspectiveNN_C1_D0(__global uchar const * restrict src, __global uchar * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"dx = (dx<<2) - (dst_offset&3);\n"
"F4 DX = (F4)(dx, dx+1, dx+2, dx+3);\n"
"F4 X0 = M[0]*DX + M[1]*dy + M[2];\n"
"F4 Y0 = M[3]*DX + M[4]*dy + M[5];\n"
"F4 W = M[6]*DX + M[7]*dy + M[8],one=1,zero=0;\n"
"W = (W!=zero) ? one/W : zero;\n"
"short4 X = convert_short4_sat_rte(X0*W);\n"
"short4 Y = convert_short4_sat_rte(Y0*W);\n"
"int4 sx = convert_int4(X);\n"
"int4 sy = convert_int4(Y);\n"
"int4 DXD = (int4)(dx, dx+1, dx+2, dx+3);\n"
"__global uchar4 * d = (__global uchar4 *)(dst+dst_offset+dy*dstStep+dx);\n"
"uchar4 dval = *d;\n"
"int4 dcon = DXD >= 0 && DXD < dst_cols && dy >= 0 && dy < dst_rows;\n"
"int4 scon = sx >= 0 && sx < src_cols && sy >= 0 && sy < src_rows;\n"
"int4 spos = src_offset + sy * srcStep + sx;\n"
"uchar4 sval;\n"
"sval.s0 = scon.s0 ? src[spos.s0] : 0;\n"
"sval.s1 = scon.s1 ? src[spos.s1] : 0;\n"
"sval.s2 = scon.s2 ? src[spos.s2] : 0;\n"
"sval.s3 = scon.s3 ? src[spos.s3] : 0;\n"
"dval = convert_uchar4(dcon) != (uchar4)(0,0,0,0) ? sval : dval;\n"
"*d = dval;\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveLinear_C1_D0(__global const uchar * restrict src, __global uchar * dst,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, int srcStep,\n"
"int dstStep, int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? INTER_TAB_SIZE/W : 0.0f;\n"
"int X = rint(X0*W);\n"
"int Y = rint(Y0*W);\n"
"int sx = convert_short_sat(X >> INTER_BITS);\n"
"int sy = convert_short_sat(Y >> INTER_BITS);\n"
"int ay = (short)(Y & (INTER_TAB_SIZE-1));\n"
"int ax = (short)(X & (INTER_TAB_SIZE-1));\n"
"uchar v[4];\n"
"int i;\n"
"#pragma unroll 4\n"
"for(i=0; i<4;  i++)\n"
"v[i] = (sx+(i&1) >= 0 && sx+(i&1) < src_cols && sy+(i>>1) >= 0 && sy+(i>>1) < src_rows) ? src[src_offset + (sy+(i>>1)) * srcStep + (sx+(i&1))] : (uchar)0;\n"
"short itab[4];\n"
"float tab1y[2], tab1x[2];\n"
"tab1y[0] = 1.0f - 1.f/INTER_TAB_SIZE*ay;\n"
"tab1y[1] = 1.f/INTER_TAB_SIZE*ay;\n"
"tab1x[0] = 1.0f - 1.f/INTER_TAB_SIZE*ax;\n"
"tab1x[1] = 1.f/INTER_TAB_SIZE*ax;\n"
"#pragma unroll 4\n"
"for(i=0; i<4;  i++)\n"
"{\n"
"float v = tab1y[(i>>1)] * tab1x[(i&1)];\n"
"itab[i] = convert_short_sat_rte( v * INTER_REMAP_COEF_SCALE );\n"
"}\n"
"if(dx >=0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"int sum = 0;\n"
"for ( i =0; i<4; i++ )\n"
"{\n"
"sum += v[i] * itab[i] ;\n"
"}\n"
"dst[dst_offset+dy*dstStep+dx] = convert_uchar_sat ( (sum + (1 << (INTER_REMAP_COEF_BITS-1))) >> INTER_REMAP_COEF_BITS ) ;\n"
"}\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveCubic_C1_D0(__global uchar * src, __global uchar * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? INTER_TAB_SIZE/W : 0.0f;\n"
"int X = rint(X0*W);\n"
"int Y = rint(Y0*W);\n"
"short sx = convert_short_sat(X >> INTER_BITS) - 1;\n"
"short sy = convert_short_sat(Y >> INTER_BITS) - 1;\n"
"short ay = (short)(Y & (INTER_TAB_SIZE-1));\n"
"short ax = (short)(X & (INTER_TAB_SIZE-1));\n"
"uchar v[16];\n"
"int i, j;\n"
"#pragma unroll 4\n"
"for(i=0; i<4;  i++)\n"
"for(j=0; j<4;  j++)\n"
"{\n"
"v[i*4+j] = (sx+j >= 0 && sx+j < src_cols && sy+i >= 0 && sy+i < src_rows) ? src[src_offset+(sy+i) * srcStep + (sx+j)] : (uchar)0;\n"
"}\n"
"short itab[16];\n"
"float tab1y[4], tab1x[4];\n"
"float axx, ayy;\n"
"ayy = 1.f/INTER_TAB_SIZE * ay;\n"
"axx = 1.f/INTER_TAB_SIZE * ax;\n"
"interpolateCubic(ayy, tab1y);\n"
"interpolateCubic(axx, tab1x);\n"
"int isum = 0;\n"
"#pragma unroll 16\n"
"for( i=0; i<16; i++ )\n"
"{\n"
"F v = tab1y[(i>>2)] * tab1x[(i&3)];\n"
"isum += itab[i] = convert_short_sat( rint( v * INTER_REMAP_COEF_SCALE ) );\n"
"}\n"
"if( isum != INTER_REMAP_COEF_SCALE )\n"
"{\n"
"int k1, k2;\n"
"int diff = isum - INTER_REMAP_COEF_SCALE;\n"
"int Mk1=2, Mk2=2, mk1=2, mk2=2;\n"
"for( k1 = 2; k1 < 4; k1++ )\n"
"for( k2 = 2; k2 < 4; k2++ )\n"
"{\n"
"if( itab[(k1<<2)+k2] < itab[(mk1<<2)+mk2] )\n"
"mk1 = k1, mk2 = k2;\n"
"else if( itab[(k1<<2)+k2] > itab[(Mk1<<2)+Mk2] )\n"
"Mk1 = k1, Mk2 = k2;\n"
"}\n"
"diff<0 ? (itab[(Mk1<<2)+Mk2]=(short)(itab[(Mk1<<2)+Mk2]-diff)) : (itab[(mk1<<2)+mk2]=(short)(itab[(mk1<<2)+mk2]-diff));\n"
"}\n"
"if( dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"int sum=0;\n"
"for ( i =0; i<16; i++ )\n"
"{\n"
"sum += v[i] * itab[i] ;\n"
"}\n"
"dst[dst_offset+dy*dstStep+dx] = convert_uchar_sat( (sum + (1 << (INTER_REMAP_COEF_BITS-1))) >> INTER_REMAP_COEF_BITS ) ;\n"
"}\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveNN_C4_D0(__global uchar4 const * restrict src, __global uchar4 * dst,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, int srcStep,\n"
"int dstStep, int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? 1.f/W : 0.0f;\n"
"short sx = convert_short_sat_rte(X0*W);\n"
"short sy = convert_short_sat_rte(Y0*W);\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>2)+dy*(dstStep>>2)+dx]= (sx>=0 && sx<src_cols && sy>=0 && sy<src_rows) ? src[(src_offset>>2)+sy*(srcStep>>2)+sx] : (uchar4)0;\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveLinear_C4_D0(__global uchar4 const * restrict src, __global uchar4 * dst,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, int srcStep,\n"
"int dstStep, int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"src_offset = (src_offset>>2);\n"
"srcStep = (srcStep>>2);\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? INTER_TAB_SIZE/W : 0.0f;\n"
"int X = rint(X0*W);\n"
"int Y = rint(Y0*W);\n"
"short sx = convert_short_sat(X >> INTER_BITS);\n"
"short sy = convert_short_sat(Y >> INTER_BITS);\n"
"short ay = (short)(Y & (INTER_TAB_SIZE-1));\n"
"short ax = (short)(X & (INTER_TAB_SIZE-1));\n"
"int4 v0, v1, v2, v3;\n"
"v0 = (sx >= 0 && sx < src_cols && sy >= 0 && sy < src_rows) ? convert_int4(src[src_offset+sy * srcStep + sx]) : (int4)0;\n"
"v1 = (sx+1 >= 0 && sx+1 < src_cols && sy >= 0 && sy < src_rows) ? convert_int4(src[src_offset+sy * srcStep + sx+1]) : (int4)0;\n"
"v2 = (sx >= 0 && sx < src_cols && sy+1 >= 0 && sy+1 < src_rows) ? convert_int4(src[src_offset+(sy+1) * srcStep + sx]) : (int4)0;\n"
"v3 = (sx+1 >= 0 && sx+1 < src_cols && sy+1 >= 0 && sy+1 < src_rows) ? convert_int4(src[src_offset+(sy+1) * srcStep + sx+1]) : (int4)0;\n"
"int itab0, itab1, itab2, itab3;\n"
"float taby, tabx;\n"
"taby = 1.f/INTER_TAB_SIZE*ay;\n"
"tabx = 1.f/INTER_TAB_SIZE*ax;\n"
"itab0 = convert_short_sat(rint( (1.0f-taby)*(1.0f-tabx) * INTER_REMAP_COEF_SCALE ));\n"
"itab1 = convert_short_sat(rint( (1.0f-taby)*tabx * INTER_REMAP_COEF_SCALE ));\n"
"itab2 = convert_short_sat(rint( taby*(1.0f-tabx) * INTER_REMAP_COEF_SCALE ));\n"
"itab3 = convert_short_sat(rint( taby*tabx * INTER_REMAP_COEF_SCALE ));\n"
"int4 val;\n"
"val = v0 * itab0 +  v1 * itab1 + v2 * itab2 + v3 * itab3;\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>2)+dy*(dstStep>>2)+dx] =  convert_uchar4_sat ( (val + (1 << (INTER_REMAP_COEF_BITS-1))) >> INTER_REMAP_COEF_BITS ) ;\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveCubic_C4_D0(__global uchar4 const * restrict src, __global uchar4 * dst,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, int srcStep,\n"
"int dstStep, int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"src_offset = (src_offset>>2);\n"
"srcStep = (srcStep>>2);\n"
"dst_offset = (dst_offset>>2);\n"
"dstStep = (dstStep>>2);\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? INTER_TAB_SIZE/W : 0.0f;\n"
"int X = rint(X0*W);\n"
"int Y = rint(Y0*W);\n"
"short sx = convert_short_sat(X >> INTER_BITS) - 1;\n"
"short sy = convert_short_sat(Y >> INTER_BITS) - 1;\n"
"short ay = (short)(Y & (INTER_TAB_SIZE-1));\n"
"short ax = (short)(X & (INTER_TAB_SIZE-1));\n"
"uchar4 v[16];\n"
"int i,j;\n"
"#pragma unroll 4\n"
"for(i=0; i<4; i++)\n"
"for(j=0; j<4; j++)\n"
"{\n"
"v[i*4+j] = (sx+j >= 0 && sx+j < src_cols && sy+i >= 0 && sy+i < src_rows) ? (src[src_offset+(sy+i) * srcStep + (sx+j)])  : (uchar4)0;\n"
"}\n"
"int itab[16];\n"
"float tab1y[4], tab1x[4];\n"
"float axx, ayy;\n"
"ayy = INTER_SCALE * ay;\n"
"axx = INTER_SCALE * ax;\n"
"interpolateCubic(ayy, tab1y);\n"
"interpolateCubic(axx, tab1x);\n"
"int isum = 0;\n"
"#pragma unroll 16\n"
"for( i=0; i<16; i++ )\n"
"{\n"
"float tmp;\n"
"tmp = tab1y[(i>>2)] * tab1x[(i&3)] * INTER_REMAP_COEF_SCALE;\n"
"itab[i] = rint(tmp);\n"
"isum += itab[i];\n"
"}\n"
"if( isum != INTER_REMAP_COEF_SCALE )\n"
"{\n"
"int k1, k2;\n"
"int diff = isum - INTER_REMAP_COEF_SCALE;\n"
"int Mk1=2, Mk2=2, mk1=2, mk2=2;\n"
"for( k1 = 2; k1 < 4; k1++ )\n"
"for( k2 = 2; k2 < 4; k2++ )\n"
"{\n"
"if( itab[(k1<<2)+k2] < itab[(mk1<<2)+mk2] )\n"
"mk1 = k1, mk2 = k2;\n"
"else if( itab[(k1<<2)+k2] > itab[(Mk1<<2)+Mk2] )\n"
"Mk1 = k1, Mk2 = k2;\n"
"}\n"
"diff<0 ? (itab[(Mk1<<2)+Mk2]=(short)(itab[(Mk1<<2)+Mk2]-diff)) : (itab[(mk1<<2)+mk2]=(short)(itab[(mk1<<2)+mk2]-diff));\n"
"}\n"
"if( dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"int4 sum=0;\n"
"for ( i =0; i<16; i++ )\n"
"{\n"
"sum += convert_int4(v[i]) * itab[i];\n"
"}\n"
"dst[dst_offset+dy*dstStep+dx] = convert_uchar4_sat( (sum + (1 << (INTER_REMAP_COEF_BITS-1))) >> INTER_REMAP_COEF_BITS ) ;\n"
"}\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveNN_C1_D5(__global float * src, __global float * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? 1.f/W : 0.0f;\n"
"short sx = convert_short_sat_rte(X0*W);\n"
"short sy = convert_short_sat_rte(Y0*W);\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>2)+dy*dstStep+dx]= (sx>=0 && sx<src_cols && sy>=0 && sy<src_rows) ? src[(src_offset>>2)+sy*srcStep+sx] : 0;\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveLinear_C1_D5(__global float * src, __global float * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"src_offset = (src_offset>>2);\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? INTER_TAB_SIZE/W : 0.0f;\n"
"int X = rint(X0*W);\n"
"int Y = rint(Y0*W);\n"
"short sx = convert_short_sat(X >> INTER_BITS);\n"
"short sy = convert_short_sat(Y >> INTER_BITS);\n"
"short ay = (short)(Y & (INTER_TAB_SIZE-1));\n"
"short ax = (short)(X & (INTER_TAB_SIZE-1));\n"
"float v0, v1, v2, v3;\n"
"v0 = (sx >= 0 && sx < src_cols && sy >= 0 && sy < src_rows) ? src[src_offset+sy * srcStep + sx] : (float)0;\n"
"v1 = (sx+1 >= 0 && sx+1 < src_cols && sy >= 0 && sy < src_rows) ? src[src_offset+sy * srcStep + sx+1] : (float)0;\n"
"v2 = (sx >= 0 && sx < src_cols && sy+1 >= 0 && sy+1 < src_rows) ? src[src_offset+(sy+1) * srcStep + sx] : (float)0;\n"
"v3 = (sx+1 >= 0 && sx+1 < src_cols && sy+1 >= 0 && sy+1 < src_rows) ? src[src_offset+(sy+1) * srcStep + sx+1] : (float)0;\n"
"float tab[4];\n"
"float taby[2], tabx[2];\n"
"taby[0] = 1.0f - 1.f/INTER_TAB_SIZE*ay;\n"
"taby[1] = 1.f/INTER_TAB_SIZE*ay;\n"
"tabx[0] = 1.0f - 1.f/INTER_TAB_SIZE*ax;\n"
"tabx[1] = 1.f/INTER_TAB_SIZE*ax;\n"
"tab[0] = taby[0] * tabx[0];\n"
"tab[1] = taby[0] * tabx[1];\n"
"tab[2] = taby[1] * tabx[0];\n"
"tab[3] = taby[1] * tabx[1];\n"
"float sum = 0;\n"
"sum += v0 * tab[0] +  v1 * tab[1] +  v2 * tab[2] +  v3 * tab[3];\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>2)+dy*dstStep+dx] = sum;\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveCubic_C1_D5(__global float * src, __global float * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"src_offset = (src_offset>>2);\n"
"dst_offset = (dst_offset>>2);\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? INTER_TAB_SIZE/W : 0.0f;\n"
"int X = rint(X0*W);\n"
"int Y = rint(Y0*W);\n"
"short sx = convert_short_sat(X >> INTER_BITS) - 1;\n"
"short sy = convert_short_sat(Y >> INTER_BITS) - 1;\n"
"short ay = (short)(Y & (INTER_TAB_SIZE-1));\n"
"short ax = (short)(X & (INTER_TAB_SIZE-1));\n"
"float v[16];\n"
"int i;\n"
"for(i=0; i<16;  i++)\n"
"v[i] = (sx+(i&3) >= 0 && sx+(i&3) < src_cols && sy+(i>>2) >= 0 && sy+(i>>2) < src_rows) ? src[src_offset+(sy+(i>>2)) * srcStep + (sx+(i&3))] : (float)0;\n"
"float tab[16];\n"
"float tab1y[4], tab1x[4];\n"
"float axx, ayy;\n"
"ayy = 1.f/INTER_TAB_SIZE * ay;\n"
"axx = 1.f/INTER_TAB_SIZE * ax;\n"
"interpolateCubic(ayy, tab1y);\n"
"interpolateCubic(axx, tab1x);\n"
"#pragma unroll 4\n"
"for( i=0; i<16; i++ )\n"
"{\n"
"tab[i] = tab1y[(i>>2)] * tab1x[(i&3)];\n"
"}\n"
"if( dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"float sum = 0;\n"
"#pragma unroll 4\n"
"for ( i =0; i<16; i++ )\n"
"{\n"
"sum += v[i] * tab[i];\n"
"}\n"
"dst[dst_offset+dy*dstStep+dx] = sum;\n"
"}\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveNN_C4_D5(__global float4 * src, __global float4 * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W =(W != 0.0f)? 1.f/W : 0.0f;\n"
"short sx = convert_short_sat_rte(X0*W);\n"
"short sy = convert_short_sat_rte(Y0*W);\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[(dst_offset>>4)+dy*(dstStep>>2)+dx]= (sx>=0 && sx<src_cols && sy>=0 && sy<src_rows) ? src[(src_offset>>4)+sy*(srcStep>>2)+sx] : (float)0;\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveLinear_C4_D5(__global float4 * src, __global float4 * dst, int src_cols, int src_rows,\n"
"int dst_cols, int dst_rows, int srcStep, int dstStep,\n"
"int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows)\n"
"{\n"
"src_offset = (src_offset>>4);\n"
"dst_offset = (dst_offset>>4);\n"
"srcStep = (srcStep>>2);\n"
"dstStep = (dstStep>>2);\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? INTER_TAB_SIZE/W : 0.0f;\n"
"int X = rint(X0*W);\n"
"int Y = rint(Y0*W);\n"
"short sx0 = convert_short_sat(X >> INTER_BITS);\n"
"short sy0 = convert_short_sat(Y >> INTER_BITS);\n"
"short ay0 = (short)(Y & (INTER_TAB_SIZE-1));\n"
"short ax0 = (short)(X & (INTER_TAB_SIZE-1));\n"
"float4 v0, v1, v2, v3;\n"
"v0 = (sx0 >= 0 && sx0 < src_cols && sy0 >= 0 && sy0 < src_rows) ? src[src_offset+sy0 * srcStep + sx0] : (float4)0;\n"
"v1 = (sx0+1 >= 0 && sx0+1 < src_cols && sy0 >= 0 && sy0 < src_rows) ? src[src_offset+sy0 * srcStep + sx0+1] : (float4)0;\n"
"v2 = (sx0 >= 0 && sx0 < src_cols && sy0+1 >= 0 && sy0+1 < src_rows) ? src[src_offset+(sy0+1) * srcStep + sx0] : (float4)0;\n"
"v3 = (sx0+1 >= 0 && sx0+1 < src_cols && sy0+1 >= 0 && sy0+1 < src_rows) ? src[src_offset+(sy0+1) * srcStep + sx0+1] : (float4)0;\n"
"float tab[4];\n"
"float taby[2], tabx[2];\n"
"taby[0] = 1.0f - 1.f/INTER_TAB_SIZE*ay0;\n"
"taby[1] = 1.f/INTER_TAB_SIZE*ay0;\n"
"tabx[0] = 1.0f - 1.f/INTER_TAB_SIZE*ax0;\n"
"tabx[1] = 1.f/INTER_TAB_SIZE*ax0;\n"
"tab[0] = taby[0] * tabx[0];\n"
"tab[1] = taby[0] * tabx[1];\n"
"tab[2] = taby[1] * tabx[0];\n"
"tab[3] = taby[1] * tabx[1];\n"
"float4 sum = 0;\n"
"sum += v0 * tab[0] +  v1 * tab[1] +  v2 * tab[2] +  v3 * tab[3];\n"
"if(dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"dst[dst_offset+dy*dstStep+dx] = sum;\n"
"}\n"
"}\n"
"__kernel void warpPerspectiveCubic_C4_D5(__global float4 * src, __global float4 * dst,\n"
"int src_cols, int src_rows, int dst_cols, int dst_rows, int srcStep,\n"
"int dstStep, int src_offset, int dst_offset,  __constant F * M, int threadCols )\n"
"{\n"
"int dx = get_global_id(0);\n"
"int dy = get_global_id(1);\n"
"if( dx < threadCols && dy < dst_rows )\n"
"{\n"
"src_offset = (src_offset>>4);\n"
"dst_offset = (dst_offset>>4);\n"
"srcStep = (srcStep>>2);\n"
"dstStep = (dstStep>>2);\n"
"F X0 = M[0]*dx + M[1]*dy + M[2];\n"
"F Y0 = M[3]*dx + M[4]*dy + M[5];\n"
"F W = M[6]*dx + M[7]*dy + M[8];\n"
"W = (W != 0.0f) ? INTER_TAB_SIZE/W : 0.0f;\n"
"int X = rint(X0*W);\n"
"int Y = rint(Y0*W);\n"
"short sx = convert_short_sat(X >> INTER_BITS)-1;\n"
"short sy = convert_short_sat(Y >> INTER_BITS)-1;\n"
"short ay = (short)(Y & (INTER_TAB_SIZE-1));\n"
"short ax = (short)(X & (INTER_TAB_SIZE-1));\n"
"float4 v[16];\n"
"int i;\n"
"for(i=0; i<16;  i++)\n"
"v[i] = (sx+(i&3) >= 0 && sx+(i&3) < src_cols && sy+(i>>2) >= 0 && sy+(i>>2) < src_rows) ? src[src_offset+(sy+(i>>2)) * srcStep + (sx+(i&3))] : (float4)0;\n"
"float tab[16];\n"
"float tab1y[4], tab1x[4];\n"
"float axx, ayy;\n"
"ayy = 1.f/INTER_TAB_SIZE * ay;\n"
"axx = 1.f/INTER_TAB_SIZE * ax;\n"
"interpolateCubic(ayy, tab1y);\n"
"interpolateCubic(axx, tab1x);\n"
"#pragma unroll 4\n"
"for( i=0; i<16; i++ )\n"
"{\n"
"tab[i] = tab1y[(i>>2)] * tab1x[(i&3)];\n"
"}\n"
"if( dx >= 0 && dx < dst_cols && dy >= 0 && dy < dst_rows)\n"
"{\n"
"float4 sum = 0;\n"
"#pragma unroll 4\n"
"for ( i =0; i<16; i++ )\n"
"{\n"
"sum += v[i] * tab[i];\n"
"}\n"
"dst[dst_offset+dy*dstStep+dx] = sum;\n"
"}\n"
"}\n"
"}\n"
, "13ff30fed80ece6c6828a26c11a07de7"};
const struct ProgramEntry interpolate_frames={"interpolate_frames",
"#pragma OPENCL EXTENSION cl_khr_global_int32_base_atomics : enable\n"
"#pragma OPENCL EXTENSION cl_khr_local_int32_base_atomics : enable\n"
"__constant sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;\n"
"void atomic_addf(volatile __global float *source, const float operand) {\n"
"union {\n"
"unsigned int intVal;\n"
"float floatVal;\n"
"} newVal;\n"
"union {\n"
"unsigned int intVal;\n"
"float floatVal;\n"
"} prevVal;\n"
"do {\n"
"prevVal.floatVal = *source;\n"
"newVal.floatVal = prevVal.floatVal + operand;\n"
"} while (atomic_cmpxchg((volatile __global unsigned int *)source, prevVal.intVal, newVal.intVal) != prevVal.intVal);\n"
"}\n"
"__kernel void memsetKernel(\n"
"float val,\n"
"__global float * image,\n"
"int width,\n"
"int height,\n"
"int step,\n"
"int offset\n"
")\n"
"{\n"
"if(get_global_id(0) >= width || get_global_id(1) >= height)\n"
"{\n"
"return;\n"
"}\n"
"image += offset;\n"
"image[get_global_id(0) + get_global_id(1) * step] = val;\n"
"}\n"
"__kernel void normalizeKernel(\n"
"__global float * buffer,\n"
"int width,\n"
"int height,\n"
"int step,\n"
"int f_offset,\n"
"int d_offset\n"
")\n"
"{\n"
"__global float * factors = buffer + f_offset;\n"
"__global float * dst     = buffer + d_offset;\n"
"int j = get_global_id(0);\n"
"int i = get_global_id(1);\n"
"if(j >= width || i >= height)\n"
"{\n"
"return;\n"
"}\n"
"float scale = factors[step * i + j];\n"
"float invScale = (scale == 0.0f) ? 1.0f : (1.0f / scale);\n"
"dst[step * i + j] *= invScale;\n"
"}\n"
"__kernel void forwardWarpKernel(\n"
"__global const float * src,\n"
"__global float * buffer,\n"
"__global const float * u,\n"
"__global const float * v,\n"
"const int w,\n"
"const int h,\n"
"const int flow_stride,\n"
"const int image_stride,\n"
"const int factor_offset,\n"
"const int dst_offset,\n"
"const float time_scale\n"
")\n"
"{\n"
"int j = get_global_id(0);\n"
"int i = get_global_id(1);\n"
"if (i >= h || j >= w) return;\n"
"volatile __global float * normalization_factor = (volatile __global float *) buffer + factor_offset;\n"
"volatile __global float * dst = (volatile __global float *)buffer + dst_offset;\n"
"int flow_row_offset  = i * flow_stride;\n"
"int image_row_offset = i * image_stride;\n"
"float cx = u[flow_row_offset + j] * time_scale + (float)j + 1.0f;\n"
"float cy = v[flow_row_offset + j] * time_scale + (float)i + 1.0f;\n"
"float px;\n"
"float py;\n"
"float dx = modf(cx, &px);\n"
"float dy = modf(cy, &py);\n"
"int tx;\n"
"int ty;\n"
"tx = (int) px;\n"
"ty = (int) py;\n"
"float value = src[image_row_offset + j];\n"
"float weight;\n"
"if (!((tx >= w) || (tx < 0) || (ty >= h) || (ty < 0)))\n"
"{\n"
"weight = dx * dy;\n"
"atomic_addf(dst + ty * image_stride + tx, value * weight);\n"
"atomic_addf(normalization_factor + ty * image_stride + tx, weight);\n"
"}\n"
"tx -= 1;\n"
"if (!((tx >= w) || (tx < 0) || (ty >= h) || (ty < 0)))\n"
"{\n"
"weight = (1.0f - dx) * dy;\n"
"atomic_addf(dst + ty * image_stride + tx, value * weight);\n"
"atomic_addf(normalization_factor + ty * image_stride + tx, weight);\n"
"}\n"
"ty -= 1;\n"
"if (!((tx >= w) || (tx < 0) || (ty >= h) || (ty < 0)))\n"
"{\n"
"weight = (1.0f - dx) * (1.0f - dy);\n"
"atomic_addf(dst + ty * image_stride + tx, value * weight);\n"
"atomic_addf(normalization_factor + ty * image_stride + tx, weight);\n"
"}\n"
"tx += 1;\n"
"if (!((tx >= w) || (tx < 0) || (ty >= h) || (ty < 0)))\n"
"{\n"
"weight = dx * (1.0f - dy);\n"
"atomic_addf(dst + ty * image_stride + tx, value * weight);\n"
"atomic_addf(normalization_factor + ty * image_stride + tx, weight);\n"
"}\n"
"}\n"
"enum\n"
"{\n"
"O0_OS = 0,\n"
"O1_OS,\n"
"U_OS,\n"
"V_OS,\n"
"UR_OS,\n"
"VR_OS\n"
"};\n"
"__kernel void blendFramesKernel(\n"
"image2d_t tex_src0,\n"
"image2d_t tex_src1,\n"
"__global float * buffer,\n"
"__global float * out,\n"
"int w,\n"
"int h,\n"
"int step,\n"
"float theta\n"
")\n"
"{\n"
"__global float * u  = buffer + h * step * U_OS;\n"
"__global float * v  = buffer + h * step * V_OS;\n"
"__global float * ur = buffer + h * step * UR_OS;\n"
"__global float * vr = buffer + h * step * VR_OS;\n"
"__global float * o0 = buffer + h * step * O0_OS;\n"
"__global float * o1 = buffer + h * step * O1_OS;\n"
"int ix = get_global_id(0);\n"
"int iy = get_global_id(1);\n"
"if(ix >= w || iy >= h) return;\n"
"int pos = ix + step * iy;\n"
"float _u  = u[pos];\n"
"float _v  = v[pos];\n"
"float _ur = ur[pos];\n"
"float _vr = vr[pos];\n"
"float x = (float)ix + 0.5f;\n"
"float y = (float)iy + 0.5f;\n"
"bool b0 = o0[pos] > 1e-4f;\n"
"bool b1 = o1[pos] > 1e-4f;\n"
"float2 coord0 = (float2)(x - _u * theta, y - _v * theta);\n"
"float2 coord1 = (float2)(x + _u * (1.0f - theta), y + _v * (1.0f - theta));\n"
"if (b0 && b1)\n"
"{\n"
"out[pos] = read_imagef(tex_src0, sampler, coord0).x * (1.0f - theta) +\n"
"read_imagef(tex_src1, sampler, coord1).x * theta;\n"
"}\n"
"else if (b0)\n"
"{\n"
"out[pos] = read_imagef(tex_src0, sampler, coord0).x;\n"
"}\n"
"else\n"
"{\n"
"out[pos] = read_imagef(tex_src1, sampler, coord1).x;\n"
"}\n"
"}\n"
, "984886a43f456d32a2f199a31ba3d12a"};
const struct ProgramEntry kernel_radix_sort_by_key={"kernel_radix_sort_by_key",
"#pragma OPENCL EXTENSION cl_khr_byte_addressable_store : enable\n"
"#ifndef N\n"
"#define N 4\n"
"#endif\n"
"#ifndef K_T\n"
"#define K_T float\n"
"#endif\n"
"#ifndef V_T\n"
"#define V_T float\n"
"#endif\n"
"#ifndef IS_GT\n"
"#define IS_GT 0\n"
"#endif\n"
"uint convertKey(uint converted_key)\n"
"{\n"
"#ifdef K_FLT\n"
"unsigned int mask = (converted_key & 0x80000000) ? 0xffffffff : 0x80000000;\n"
"converted_key ^= mask;\n"
"#elif defined(K_INT)\n"
"const uint SIGN_MASK = 1u << ((sizeof(int) * 8) - 1);\n"
"converted_key ^= SIGN_MASK;\n"
"#else\n"
"#endif\n"
"return converted_key;\n"
"}\n"
"kernel\n"
"void naiveScanAddition(\n"
"__global int * input,\n"
"__global int * output,\n"
"int size\n"
")\n"
"{\n"
"if(get_global_id(0) == 0)\n"
"{\n"
"output[0] = 0;\n"
"for(int i = 1; i < size; i ++)\n"
"{\n"
"output[i] = output[i - 1] + input[i - 1];\n"
"}\n"
"}\n"
"}\n"
"kernel\n"
"void histogramRadixN (\n"
"__global K_T* unsortedKeys,\n"
"__global int * buckets,\n"
"uint shiftCount\n"
")\n"
"{\n"
"const int RADIX_T     = N;\n"
"const int RADICES_T   = (1 << RADIX_T);\n"
"const int NUM_OF_ELEMENTS_PER_WORK_ITEM_T = RADICES_T;\n"
"const int MASK_T      = (1 << RADIX_T) - 1;\n"
"int localBuckets[16] = {0,0,0,0,0,0,0,0,\n"
"0,0,0,0,0,0,0,0};\n"
"int globalId    = get_global_id(0);\n"
"int numOfGroups = get_num_groups(0);\n"
"for(int i = 0; i < NUM_OF_ELEMENTS_PER_WORK_ITEM_T; ++i)\n"
"{\n"
"uint value = convertKey(as_uint(unsortedKeys[mad24(globalId, NUM_OF_ELEMENTS_PER_WORK_ITEM_T, i)]));\n"
"value = (value >> shiftCount) & MASK_T;\n"
"#if IS_GT\n"
"localBuckets[RADICES_T - value - 1]++;\n"
"#else\n"
"localBuckets[value]++;\n"
"#endif\n"
"}\n"
"for(int i = 0; i < NUM_OF_ELEMENTS_PER_WORK_ITEM_T; ++i)\n"
"{\n"
"buckets[mad24(i, RADICES_T * numOfGroups, globalId) ] = localBuckets[i];\n"
"}\n"
"}\n"
"kernel\n"
"void permuteRadixN (\n"
"__global K_T*  unsortedKeys,\n"
"__global V_T*  unsortedVals,\n"
"__global int* scanedBuckets,\n"
"uint shiftCount,\n"
"__global K_T*  sortedKeys,\n"
"__global V_T*  sortedVals\n"
")\n"
"{\n"
"const int RADIX_T     = N;\n"
"const int RADICES_T   = (1 << RADIX_T);\n"
"const int MASK_T = (1<<RADIX_T)  -1;\n"
"int globalId  = get_global_id(0);\n"
"int numOfGroups = get_num_groups(0);\n"
"const int NUM_OF_ELEMENTS_PER_WORK_GROUP_T = numOfGroups << N;\n"
"int  localIndex[16];\n"
"for(int i = 0; i < RADICES_T; ++i)\n"
"{\n"
"#if IS_GT\n"
"localIndex[i] = scanedBuckets[mad24(RADICES_T - i - 1, NUM_OF_ELEMENTS_PER_WORK_GROUP_T, globalId)];\n"
"#else\n"
"localIndex[i] = scanedBuckets[mad24(i, NUM_OF_ELEMENTS_PER_WORK_GROUP_T, globalId)];\n"
"#endif\n"
"}\n"
"for(int i = 0; i < RADICES_T; ++i)\n"
"{\n"
"int old_idx = mad24(globalId, RADICES_T, i);\n"
"K_T  ovalue = unsortedKeys[old_idx];\n"
"uint value = convertKey(as_uint(ovalue));\n"
"uint maskedValue = (value >> shiftCount) & MASK_T;\n"
"uint index = localIndex[maskedValue];\n"
"sortedKeys[index] = ovalue;\n"
"sortedVals[index] = unsortedVals[old_idx];\n"
"localIndex[maskedValue] = index + 1;\n"
"}\n"
"}\n"
, "0e6fe5592aca6ddfade79641efe19a59"};
const struct ProgramEntry kernel_sort_by_key={"kernel_sort_by_key",
"#ifndef K_T\n"
"#define K_T float\n"
"#endif\n"
"#ifndef V_T\n"
"#define V_T float\n"
"#endif\n"
"#ifndef IS_GT\n"
"#define IS_GT false\n"
"#endif\n"
"#if IS_GT\n"
"#define my_comp(x,y) ((x) > (y))\n"
"#else\n"
"#define my_comp(x,y) ((x) < (y))\n"
"#endif\n"
"__kernel\n"
"void bitonicSort\n"
"(\n"
"__global K_T * keys,\n"
"__global V_T * vals,\n"
"int count,\n"
"int stage,\n"
"int passOfStage\n"
")\n"
"{\n"
"const int threadId = get_global_id(0);\n"
"if(threadId >= count / 2)\n"
"{\n"
"return;\n"
"}\n"
"const int pairDistance = 1 << (stage - passOfStage);\n"
"const int blockWidth   = 2 * pairDistance;\n"
"int leftId = min( (threadId % pairDistance)\n"
"+ (threadId / pairDistance) * blockWidth, count );\n"
"int rightId = min( leftId + pairDistance, count );\n"
"int temp;\n"
"const V_T lval = vals[leftId];\n"
"const V_T rval = vals[rightId];\n"
"const K_T lkey = keys[leftId];\n"
"const K_T rkey = keys[rightId];\n"
"int sameDirectionBlockWidth = 1 << stage;\n"
"if((threadId/sameDirectionBlockWidth) % 2 == 1)\n"
"{\n"
"temp = rightId;\n"
"rightId = leftId;\n"
"leftId = temp;\n"
"}\n"
"const bool compareResult = my_comp(lkey, rkey);\n"
"if(compareResult)\n"
"{\n"
"keys[rightId] = rkey;\n"
"keys[leftId]  = lkey;\n"
"vals[rightId] = rval;\n"
"vals[leftId]  = lval;\n"
"}\n"
"else\n"
"{\n"
"keys[rightId] = lkey;\n"
"keys[leftId]  = rkey;\n"
"vals[rightId] = lval;\n"
"vals[leftId]  = rval;\n"
"}\n"
"}\n"
"__kernel\n"
"void selectionSortLocal\n"
"(\n"
"__global K_T * keys,\n"
"__global V_T * vals,\n"
"const int count,\n"
"__local  K_T * scratch\n"
")\n"
"{\n"
"int          i  = get_local_id(0);\n"
"int numOfGroups = get_num_groups(0);\n"
"int groupID     = get_group_id(0);\n"
"int         wg  = get_local_size(0);\n"
"int n;\n"
"int offset   = groupID * wg;\n"
"int same     = 0;\n"
"vals      += offset;\n"
"keys      += offset;\n"
"n = (groupID == (numOfGroups-1))? (count - wg*(numOfGroups-1)) : wg;\n"
"int clamped_i= min(i, n - 1);\n"
"K_T key1 = keys[clamped_i], key2;\n"
"V_T val1 = vals[clamped_i];\n"
"scratch[i] = key1;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(i >= n)\n"
"{\n"
"return;\n"
"}\n"
"int pos = 0;\n"
"for (int j=0;j<n;++j)\n"
"{\n"
"key2  = scratch[j];\n"
"if(my_comp(key2, key1))\n"
"pos++;\n"
"else\n"
"{\n"
"if(my_comp(key1, key2))\n"
"continue;\n"
"else\n"
"{\n"
"same++;\n"
"}\n"
"}\n"
"}\n"
"for (int j=0; j< same; j++)\n"
"{\n"
"vals[pos + j] = val1;\n"
"keys[pos + j] = key1;\n"
"}\n"
"}\n"
"__kernel\n"
"void selectionSortFinal\n"
"(\n"
"__global K_T * keys,\n"
"__global V_T * vals,\n"
"const int count\n"
")\n"
"{\n"
"const int          i  = get_local_id(0);\n"
"const int numOfGroups = get_num_groups(0);\n"
"const int         wg  = get_local_size(0);\n"
"int pos = 0, same = 0;\n"
"const int offset = get_group_id(0) * wg;\n"
"const int remainder = count - wg*(numOfGroups-1);\n"
"if((offset + i ) >= count)\n"
"return;\n"
"V_T val1 = vals[offset + i];\n"
"K_T key1 = keys[offset + i];\n"
"K_T key2;\n"
"for(int j=0; j<numOfGroups-1; j++ )\n"
"{\n"
"for(int k=0; k<wg; k++)\n"
"{\n"
"key2 = keys[j*wg + k];\n"
"if(my_comp(key1, key2))\n"
"break;\n"
"else\n"
"{\n"
"if(my_comp(key2, key1))\n"
"pos++;\n"
"else\n"
"same++;\n"
"}\n"
"}\n"
"}\n"
"for(int k=0; k<remainder; k++)\n"
"{\n"
"key2 = keys[(numOfGroups-1)*wg + k];\n"
"if(my_comp(key1, key2))\n"
"break;\n"
"else\n"
"{\n"
"if(my_comp(key2, key1))\n"
"pos++;\n"
"else\n"
"same++;\n"
"}\n"
"}\n"
"for (int j=0; j< same; j++)\n"
"{\n"
"vals[pos + j] = val1;\n"
"keys[pos + j] = key1;\n"
"}\n"
"}\n"
, "dcb847ed205163090b935d35efe4b6e6"};
const struct ProgramEntry kernel_stablesort_by_key={"kernel_stablesort_by_key",
"#ifndef K_T\n"
"#define K_T float\n"
"#endif\n"
"#ifndef V_T\n"
"#define V_T float\n"
"#endif\n"
"#ifndef IS_GT\n"
"#define IS_GT false\n"
"#endif\n"
"#if IS_GT\n"
"#define my_comp(x,y) ((x) > (y))\n"
"#else\n"
"#define my_comp(x,y) ((x) < (y))\n"
"#endif\n"
"uint lowerBoundBinary( global K_T* data, uint left, uint right, K_T searchVal)\n"
"{\n"
"uint firstIndex = left;\n"
"uint lastIndex = right;\n"
"while( firstIndex < lastIndex )\n"
"{\n"
"uint midIndex = ( firstIndex + lastIndex ) / 2;\n"
"K_T midValue = data[ midIndex ];\n"
"if( my_comp( midValue, searchVal ) )\n"
"{\n"
"firstIndex = midIndex+1;\n"
"}\n"
"else\n"
"{\n"
"lastIndex = midIndex;\n"
"}\n"
"}\n"
"return firstIndex;\n"
"}\n"
"uint upperBoundBinary( global K_T* data, uint left, uint right, K_T searchVal)\n"
"{\n"
"uint upperBound = lowerBoundBinary( data, left, right, searchVal );\n"
"if( upperBound != right )\n"
"{\n"
"K_T upperValue = data[ upperBound ];\n"
"while( !my_comp( upperValue, searchVal ) && !my_comp( searchVal, upperValue) && (upperBound != right) )\n"
"{\n"
"upperBound++;\n"
"upperValue = data[ upperBound ];\n"
"}\n"
"}\n"
"return upperBound;\n"
"}\n"
"kernel void merge(\n"
"global K_T*   iKey_ptr,\n"
"global V_T*   iValue_ptr,\n"
"global K_T*   oKey_ptr,\n"
"global V_T*   oValue_ptr,\n"
"const uint    srcVecSize,\n"
"const uint    srcLogicalBlockSize,\n"
"local K_T*    key_lds,\n"
"local V_T*    val_lds\n"
")\n"
"{\n"
"size_t globalID     = get_global_id( 0 );\n"
"if( globalID >= srcVecSize )\n"
"return;\n"
"uint srcBlockNum   = globalID / srcLogicalBlockSize;\n"
"uint srcBlockIndex = globalID % srcLogicalBlockSize;\n"
"uint dstLogicalBlockSize = srcLogicalBlockSize<<1;\n"
"uint leftBlockIndex = globalID & ~((dstLogicalBlockSize) - 1 );\n"
"leftBlockIndex += (srcBlockNum & 0x1) ? 0 : srcLogicalBlockSize;\n"
"leftBlockIndex = min( leftBlockIndex, srcVecSize );\n"
"uint rightBlockIndex = min( leftBlockIndex + srcLogicalBlockSize, srcVecSize );\n"
"uint insertionIndex = 0;\n"
"if( (srcBlockNum & 0x1) == 0 )\n"
"{\n"
"insertionIndex = lowerBoundBinary( iKey_ptr, leftBlockIndex, rightBlockIndex, iKey_ptr[ globalID ] ) - leftBlockIndex;\n"
"}\n"
"else\n"
"{\n"
"insertionIndex = upperBoundBinary( iKey_ptr, leftBlockIndex, rightBlockIndex, iKey_ptr[ globalID ] ) - leftBlockIndex;\n"
"}\n"
"uint dstBlockIndex = srcBlockIndex + insertionIndex;\n"
"uint dstBlockNum = srcBlockNum/2;\n"
"oKey_ptr[ (dstBlockNum*dstLogicalBlockSize)+dstBlockIndex ] = iKey_ptr[ globalID ];\n"
"oValue_ptr[ (dstBlockNum*dstLogicalBlockSize)+dstBlockIndex ] = iValue_ptr[ globalID ];\n"
"}\n"
"kernel void blockInsertionSort(\n"
"global K_T*   key_ptr,\n"
"global V_T*   value_ptr,\n"
"const uint    vecSize,\n"
"local K_T*    key_lds,\n"
"local V_T*    val_lds\n"
")\n"
"{\n"
"int gloId    = get_global_id( 0 );\n"
"int groId    = get_group_id( 0 );\n"
"int locId    = get_local_id( 0 );\n"
"int wgSize   = get_local_size( 0 );\n"
"bool in_range = gloId < (int)vecSize;\n"
"K_T key;\n"
"V_T val;\n"
"if (in_range)\n"
"{\n"
"key = key_ptr[ gloId ];\n"
"val = value_ptr[ gloId ];\n"
"key_lds[ locId ] = key;\n"
"val_lds[ locId ] = val;\n"
"}\n"
"barrier( CLK_LOCAL_MEM_FENCE );\n"
"if( locId == 0 && in_range )\n"
"{\n"
"int endIndex = vecSize - ( groId * wgSize );\n"
"endIndex = min( endIndex, wgSize );\n"
"for( int currIndex = 1; currIndex < endIndex; ++currIndex )\n"
"{\n"
"key = key_lds[ currIndex ];\n"
"val = val_lds[ currIndex ];\n"
"int scanIndex = currIndex;\n"
"K_T ldsKey = key_lds[scanIndex - 1];\n"
"while( scanIndex > 0 && my_comp( key, ldsKey ) )\n"
"{\n"
"V_T ldsVal = val_lds[scanIndex - 1];\n"
"key_lds[ scanIndex ] = ldsKey;\n"
"val_lds[ scanIndex ] = ldsVal;\n"
"scanIndex = scanIndex - 1;\n"
"ldsKey = key_lds[ max( 0, scanIndex - 1 ) ];\n"
"}\n"
"key_lds[ scanIndex ] = key;\n"
"val_lds[ scanIndex ] = val;\n"
"}\n"
"}\n"
"barrier( CLK_LOCAL_MEM_FENCE );\n"
"if(in_range)\n"
"{\n"
"key = key_lds[ locId ];\n"
"key_ptr[ gloId ] = key;\n"
"val = val_lds[ locId ];\n"
"value_ptr[ gloId ] = val;\n"
"}\n"
"}\n"
, "51ab9beffb4c03717063811491652aa2"};
const struct ProgramEntry kmeans_kernel={"kmeans_kernel",
"float distance_(__global const float * center, __global const float * src, int feature_length)\n"
"{\n"
"float res = 0;\n"
"float4 v0, v1, v2;\n"
"int i = 0;\n"
"#ifdef L1_DIST\n"
"float4 sum = (float4)(0.0f);\n"
"#endif\n"
"for ( ; i <= feature_length - 4; i += 4)\n"
"{\n"
"v0 = vload4(0, center + i);\n"
"v1 = vload4(0, src + i);\n"
"v2 = v1 - v0;\n"
"#ifdef L1_DIST\n"
"v0 = fabs(v2);\n"
"sum += v0;\n"
"#else\n"
"res += dot(v2, v2);\n"
"#endif\n"
"}\n"
"#ifdef L1_DIST\n"
"res = sum.x + sum.y + sum.z + sum.w;\n"
"#endif\n"
"for ( ; i < feature_length; ++i)\n"
"{\n"
"float t0 = src[i];\n"
"float t1 = center[i];\n"
"#ifdef L1_DIST\n"
"res += fabs(t0 - t1);\n"
"#else\n"
"float t2 = t0 - t1;\n"
"res += t2 * t2;\n"
"#endif\n"
"}\n"
"return res;\n"
"}\n"
"__kernel void distanceToCenters(__global const float * src, __global const float * centers,\n"
"__global float * dists, int feature_length,\n"
"int src_step, int centers_step,\n"
"int features_count, int centers_count,\n"
"int src_offset, int centers_offset)\n"
"{\n"
"int gid = get_global_id(0);\n"
"if (gid < (features_count * centers_count))\n"
"{\n"
"int feature_index = gid / centers_count;\n"
"int center_index = gid % centers_count;\n"
"int center_idx = mad24(center_index, centers_step, centers_offset);\n"
"int src_idx = mad24(feature_index, src_step, src_offset);\n"
"dists[gid] = distance_(centers + center_idx, src + src_idx, feature_length);\n"
"}\n"
"}\n"
, "f860c405407c40547fd9e1af945944ad"};
const struct ProgramEntry knearest={"knearest",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define TYPE double\n"
"#else\n"
"#define TYPE float\n"
"#endif\n"
"#define CV_SWAP(a,b,t) ((t) = (a), (a) = (b), (b) = (t))\n"
"__kernel void knn_find_nearest(__global float* sample, int sample_row, int sample_col, int sample_step,\n"
"int k, __global float* samples_ocl, int sample_ocl_row, int sample_ocl_step,\n"
"__global float* _results, int _results_step, int _regression, int K1,\n"
"int sample_ocl_col, int nThreads, __local float* nr)\n"
"{\n"
"int k1 = 0;\n"
"int k2 = 0;\n"
"bool regression = false;\n"
"if(_regression)\n"
"regression = true;\n"
"TYPE inv_scale;\n"
"#ifdef DOUBLE_SUPPORT\n"
"inv_scale = 1.0/K1;\n"
"#else\n"
"inv_scale = 1.0f/K1;\n"
"#endif\n"
"int y = get_global_id(1);\n"
"int j, j1;\n"
"int threadY = (y % nThreads);\n"
"__local float* dd = nr + nThreads * k;\n"
"if(y >= sample_row)\n"
"{\n"
"return;\n"
"}\n"
"for(j = 0; j < sample_ocl_row; j++)\n"
"{\n"
"TYPE sum;\n"
"#ifdef DOUBLE_SUPPORT\n"
"sum = 0.0;\n"
"#else\n"
"sum = 0.0f;\n"
"#endif\n"
"float si;\n"
"int t, ii, ii1;\n"
"for(t = 0; t < sample_col - 16; t += 16)\n"
"{\n"
"float16 t0 = vload16(0, sample + y * sample_step + t) - vload16(0, samples_ocl + j * sample_ocl_step + t);\n"
"t0 *= t0;\n"
"sum += t0.s0 + t0.s1 + t0.s2 + t0.s3 + t0.s4 + t0.s5 + t0.s6 + t0.s7 +\n"
"t0.s8 + t0.s9 + t0.sa + t0.sb + t0.sc + t0.sd + t0.se + t0.sf;\n"
"}\n"
"for(; t < sample_col; t++)\n"
"{\n"
"#ifdef DOUBLE_SUPPORT\n"
"double t0 = sample[y * sample_step + t] - samples_ocl[j * sample_ocl_step + t];\n"
"#else\n"
"float t0 = sample[y * sample_step + t] - samples_ocl[j * sample_ocl_step + t];\n"
"#endif\n"
"sum = sum + t0 * t0;\n"
"}\n"
"si = (float)sum;\n"
"for(ii = k1 - 1; ii >= 0; ii--)\n"
"{\n"
"if(as_int(si) > as_int(dd[ii * nThreads + threadY]))\n"
"break;\n"
"}\n"
"if(ii < k - 1)\n"
"{\n"
"for(ii1 = k2 - 1; ii1 > ii; ii1--)\n"
"{\n"
"dd[(ii1 + 1) * nThreads + threadY] = dd[ii1 * nThreads + threadY];\n"
"nr[(ii1 + 1) * nThreads + threadY] = nr[ii1 * nThreads + threadY];\n"
"}\n"
"dd[(ii + 1) * nThreads + threadY] = si;\n"
"nr[(ii + 1) * nThreads + threadY] = samples_ocl[sample_col + j * sample_ocl_step];\n"
"}\n"
"k1 = (k1 + 1) < k ? (k1 + 1) : k;\n"
"k2 = k1 < (k - 1) ? k1 : (k - 1);\n"
"}\n"
"if (regression)\n"
"{\n"
"TYPE s;\n"
"#ifdef DOUBLE_SUPPORT\n"
"s = 0.0;\n"
"#else\n"
"s = 0.0f;\n"
"#endif\n"
"for(j = 0; j < K1; j++)\n"
"s += nr[j * nThreads + threadY];\n"
"_results[y * _results_step] = (float)(s * inv_scale);\n"
"}\n"
"else\n"
"{\n"
"int prev_start = 0, best_count = 0, cur_count;\n"
"float best_val;\n"
"for(j = K1 - 1; j > 0; j--)\n"
"{\n"
"bool swap_f1 = false;\n"
"for(j1 = 0; j1 < j; j1++)\n"
"{\n"
"if(nr[j1 * nThreads + threadY] > nr[(j1 + 1) * nThreads + threadY])\n"
"{\n"
"int t;\n"
"CV_SWAP(nr[j1 * nThreads + threadY], nr[(j1 + 1) * nThreads + threadY], t);\n"
"swap_f1 = true;\n"
"}\n"
"}\n"
"if(!swap_f1)\n"
"break;\n"
"}\n"
"best_val = 0;\n"
"for(j = 1; j <= K1; j++)\n"
"if(j == K1 || nr[j * nThreads + threadY] != nr[(j - 1) * nThreads + threadY])\n"
"{\n"
"cur_count = j - prev_start;\n"
"if(best_count < cur_count)\n"
"{\n"
"best_count = cur_count;\n"
"best_val = nr[(j - 1) * nThreads + threadY];\n"
"}\n"
"prev_start = j;\n"
"}\n"
"_results[y * _results_step] = best_val;\n"
"}\n"
"}\n"
, "21d1d481592261bb0d7daeef8c69e121"};
const struct ProgramEntry match_template={"match_template",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define TYPE_IMAGE_SQSUM double\n"
"#else\n"
"#define TYPE_IMAGE_SQSUM float\n"
"#endif\n"
"#ifndef CN4\n"
"#define CN4 1\n"
"#else\n"
"#define CN4 4\n"
"#endif\n"
"#define SQSUMS_PTR(ox, oy) mad24(gidy + oy, img_sqsums_step, (gidx + img_sqsums_offset + ox) * CN4)\n"
"#define SUMS_PTR(ox, oy) mad24(gidy + oy, img_sums_step, gidx + img_sums_offset + ox)\n"
"float normAcc(float num, float denum)\n"
"{\n"
"if(fabs(num) < denum)\n"
"{\n"
"return num / denum;\n"
"}\n"
"if(fabs(num) < denum * 1.125f)\n"
"{\n"
"return num > 0 ? 1 : -1;\n"
"}\n"
"return 0;\n"
"}\n"
"float normAcc_SQDIFF(float num, float denum)\n"
"{\n"
"if(fabs(num) < denum)\n"
"{\n"
"return num / denum;\n"
"}\n"
"if(fabs(num) < denum * 1.125f)\n"
"{\n"
"return num > 0 ? 1 : -1;\n"
"}\n"
"return 1;\n"
"}\n"
"__kernel\n"
"void normalizeKernel_C1_D0\n"
"(\n"
"__global const float * img_sqsums,\n"
"__global float * res,\n"
"ulong tpl_sqsum,\n"
"int res_rows,\n"
"int res_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int img_sqsums_offset,\n"
"int img_sqsums_step,\n"
"int res_offset,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"img_sqsums_step /= sizeof(*img_sqsums);\n"
"img_sqsums_offset /= sizeof(*img_sqsums);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"float image_sqsum_ = (float)(\n"
"(img_sqsums[SQSUMS_PTR(tpl_cols, tpl_rows)] - img_sqsums[SQSUMS_PTR(tpl_cols, 0)]) -\n"
"(img_sqsums[SQSUMS_PTR(0, tpl_rows)] - img_sqsums[SQSUMS_PTR(0, 0)]));\n"
"res[res_idx] = normAcc(res[res_idx], sqrt(image_sqsum_ * tpl_sqsum));\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Prepared_SQDIFF_C1_D0\n"
"(\n"
"__global const TYPE_IMAGE_SQSUM * img_sqsums,\n"
"__global float * res,\n"
"ulong tpl_sqsum,\n"
"int res_rows,\n"
"int res_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int img_sqsums_offset,\n"
"int img_sqsums_step,\n"
"int res_offset,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"img_sqsums_step /= sizeof(*img_sqsums);\n"
"img_sqsums_offset /= sizeof(*img_sqsums);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"float image_sqsum_ = (float)(\n"
"(img_sqsums[SQSUMS_PTR(tpl_cols, tpl_rows)] - img_sqsums[SQSUMS_PTR(tpl_cols, 0)]) -\n"
"(img_sqsums[SQSUMS_PTR(0, tpl_rows)] - img_sqsums[SQSUMS_PTR(0, 0)]));\n"
"res[res_idx] = image_sqsum_ - 2.f * res[res_idx] + tpl_sqsum;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Prepared_SQDIFF_NORMED_C1_D0\n"
"(\n"
"__global const float * img_sqsums,\n"
"__global float * res,\n"
"ulong tpl_sqsum,\n"
"int res_rows,\n"
"int res_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int img_sqsums_offset,\n"
"int img_sqsums_step,\n"
"int res_offset,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"img_sqsums_step /= sizeof(*img_sqsums);\n"
"img_sqsums_offset /= sizeof(*img_sqsums);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"float image_sqsum_ = (float)(\n"
"(img_sqsums[SQSUMS_PTR(tpl_cols, tpl_rows)] - img_sqsums[SQSUMS_PTR(tpl_cols, 0)]) -\n"
"(img_sqsums[SQSUMS_PTR(0, tpl_rows)] - img_sqsums[SQSUMS_PTR(0, 0)]));\n"
"res[res_idx] = normAcc_SQDIFF(image_sqsum_ - 2.f * res[res_idx] + tpl_sqsum,\n"
"sqrt(image_sqsum_ * tpl_sqsum));\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Naive_SQDIFF_C1_D0\n"
"(\n"
"__global const uchar * img,\n"
"__global const uchar * tpl,\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int img_offset,\n"
"int tpl_offset,\n"
"int res_offset,\n"
"int img_step,\n"
"int tpl_step,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int i,j;\n"
"int delta;\n"
"int sum = 0;\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"for(i = 0; i < tpl_rows; i ++)\n"
"{\n"
"__global const uchar * img_ptr = img + mad24(gidy + i, img_step, gidx + img_offset);\n"
"__global const uchar * tpl_ptr = tpl + mad24(i, tpl_step, tpl_offset);\n"
"for(j = 0; j < tpl_cols; j ++)\n"
"{\n"
"delta = img_ptr[j] - tpl_ptr[j];\n"
"sum   = mad24(delta, delta, sum);\n"
"}\n"
"}\n"
"res[res_idx] = sum;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Naive_SQDIFF_C1_D5\n"
"(\n"
"__global const float * img,\n"
"__global const float * tpl,\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int img_offset,\n"
"int tpl_offset,\n"
"int res_offset,\n"
"int img_step,\n"
"int tpl_step,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int i,j;\n"
"float delta;\n"
"float sum = 0;\n"
"img_step   /= sizeof(*img);\n"
"img_offset /= sizeof(*img);\n"
"tpl_step   /= sizeof(*tpl);\n"
"tpl_offset /= sizeof(*tpl);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"for(i = 0; i < tpl_rows; i ++)\n"
"{\n"
"__global const float * img_ptr = img + mad24(gidy + i, img_step, gidx + img_offset);\n"
"__global const float * tpl_ptr = tpl + mad24(i, tpl_step, tpl_offset);\n"
"for(j = 0; j < tpl_cols; j ++)\n"
"{\n"
"delta = img_ptr[j] - tpl_ptr[j];\n"
"sum   = mad(delta, delta, sum);\n"
"}\n"
"}\n"
"res[res_idx] = sum;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Naive_SQDIFF_C4_D0\n"
"(\n"
"__global const uchar4 * img,\n"
"__global const uchar4 * tpl,\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int img_offset,\n"
"int tpl_offset,\n"
"int res_offset,\n"
"int img_step,\n"
"int tpl_step,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int i,j;\n"
"int4 delta;\n"
"int4 sum = (int4)(0, 0, 0, 0);\n"
"img_step   /= sizeof(*img);\n"
"img_offset /= sizeof(*img);\n"
"tpl_step   /= sizeof(*tpl);\n"
"tpl_offset /= sizeof(*tpl);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"for(i = 0; i < tpl_rows; i ++)\n"
"{\n"
"__global const uchar4 * img_ptr = img + mad24(gidy + i, img_step, gidx + img_offset);\n"
"__global const uchar4 * tpl_ptr = tpl + mad24(i, tpl_step, tpl_offset);\n"
"for(j = 0; j < tpl_cols; j ++)\n"
"{\n"
"delta.x = img_ptr[j].x - tpl_ptr[j].x;\n"
"delta.y = img_ptr[j].y - tpl_ptr[j].y;\n"
"delta.z = img_ptr[j].z - tpl_ptr[j].z;\n"
"delta.w = img_ptr[j].w - tpl_ptr[j].w;\n"
"sum   = mad24(delta, delta, sum);\n"
"}\n"
"}\n"
"res[res_idx] = sum.x + sum.y + sum.z + sum.w;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Naive_SQDIFF_C4_D5\n"
"(\n"
"__global const float4 * img,\n"
"__global const float4 * tpl,\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int img_offset,\n"
"int tpl_offset,\n"
"int res_offset,\n"
"int img_step,\n"
"int tpl_step,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int i,j;\n"
"float4 delta;\n"
"float4 sum = (float4)(0, 0, 0, 0);\n"
"img_step   /= sizeof(*img);\n"
"img_offset /= sizeof(*img);\n"
"tpl_step   /= sizeof(*tpl);\n"
"tpl_offset /= sizeof(*tpl);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"for(i = 0; i < tpl_rows; i ++)\n"
"{\n"
"__global const float4 * img_ptr = img + mad24(gidy + i, img_step, gidx + img_offset);\n"
"__global const float4 * tpl_ptr = tpl + mad24(i, tpl_step, tpl_offset);\n"
"for(j = 0; j < tpl_cols; j ++)\n"
"{\n"
"delta.x = img_ptr[j].x - tpl_ptr[j].x;\n"
"delta.y = img_ptr[j].y - tpl_ptr[j].y;\n"
"delta.z = img_ptr[j].z - tpl_ptr[j].z;\n"
"delta.w = img_ptr[j].w - tpl_ptr[j].w;\n"
"sum   = mad(delta, delta, sum);\n"
"}\n"
"}\n"
"res[res_idx] = sum.x + sum.y + sum.z + sum.w;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Naive_CCORR_C1_D0\n"
"(\n"
"__global const uchar * img,\n"
"__global const uchar * tpl,\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int img_offset,\n"
"int tpl_offset,\n"
"int res_offset,\n"
"int img_step,\n"
"int tpl_step,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int i,j;\n"
"int sum = 0;\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"for(i = 0; i < tpl_rows; i ++)\n"
"{\n"
"__global const uchar * img_ptr = img + mad24(gidy + i, img_step, gidx + img_offset);\n"
"__global const uchar * tpl_ptr = tpl + mad24(i, tpl_step, tpl_offset);\n"
"for(j = 0; j < tpl_cols; j ++)\n"
"{\n"
"sum = mad24(convert_int(img_ptr[j]), convert_int(tpl_ptr[j]), sum);\n"
"}\n"
"}\n"
"res[res_idx] = (float)sum;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Naive_CCORR_C1_D5\n"
"(\n"
"__global const float * img,\n"
"__global const float * tpl,\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int img_offset,\n"
"int tpl_offset,\n"
"int res_offset,\n"
"int img_step,\n"
"int tpl_step,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int i,j;\n"
"float sum = 0;\n"
"img_step   /= sizeof(*img);\n"
"img_offset /= sizeof(*img);\n"
"tpl_step   /= sizeof(*tpl);\n"
"tpl_offset /= sizeof(*tpl);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"for(i = 0; i < tpl_rows; i ++)\n"
"{\n"
"__global const float * img_ptr = img + mad24(gidy + i, img_step, gidx + img_offset);\n"
"__global const float * tpl_ptr = tpl + mad24(i, tpl_step, tpl_offset);\n"
"for(j = 0; j < tpl_cols; j ++)\n"
"{\n"
"sum = mad(img_ptr[j], tpl_ptr[j], sum);\n"
"}\n"
"}\n"
"res[res_idx] = sum;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Naive_CCORR_C4_D0\n"
"(\n"
"__global const uchar4 * img,\n"
"__global const uchar4 * tpl,\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int img_offset,\n"
"int tpl_offset,\n"
"int res_offset,\n"
"int img_step,\n"
"int tpl_step,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int i,j;\n"
"int4 sum = (int4)(0, 0, 0, 0);\n"
"img_step   /= sizeof(*img);\n"
"img_offset /= sizeof(*img);\n"
"tpl_step   /= sizeof(*tpl);\n"
"tpl_offset /= sizeof(*tpl);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"for(i = 0; i < tpl_rows; i ++)\n"
"{\n"
"__global const uchar4 * img_ptr = img + mad24(gidy + i, img_step, gidx + img_offset);\n"
"__global const uchar4 * tpl_ptr = tpl + mad24(i, tpl_step, tpl_offset);\n"
"for(j = 0; j < tpl_cols; j ++)\n"
"{\n"
"sum   = mad24(convert_int4(img_ptr[j]), convert_int4(tpl_ptr[j]), sum);\n"
"}\n"
"}\n"
"res[res_idx] = (float)(sum.x + sum.y + sum.z + sum.w);\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Naive_CCORR_C4_D5\n"
"(\n"
"__global const float4 * img,\n"
"__global const float4 * tpl,\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int img_offset,\n"
"int tpl_offset,\n"
"int res_offset,\n"
"int img_step,\n"
"int tpl_step,\n"
"int res_step\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"int i,j;\n"
"float4 sum = (float4)(0, 0, 0, 0);\n"
"img_step   /= sizeof(*img);\n"
"img_offset /= sizeof(*img);\n"
"tpl_step   /= sizeof(*tpl);\n"
"tpl_offset /= sizeof(*tpl);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"for(i = 0; i < tpl_rows; i ++)\n"
"{\n"
"__global const float4 * img_ptr = img + mad24(gidy + i, img_step, gidx + img_offset);\n"
"__global const float4 * tpl_ptr = tpl + mad24(i, tpl_step, tpl_offset);\n"
"for(j = 0; j < tpl_cols; j ++)\n"
"{\n"
"sum = mad(convert_float4(img_ptr[j]), convert_float4(tpl_ptr[j]), sum);\n"
"}\n"
"}\n"
"res[res_idx] = sum.x + sum.y + sum.z + sum.w;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Prepared_CCOFF_C1_D0\n"
"(\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int res_offset,\n"
"int res_step,\n"
"__global const uint * img_sums,\n"
"int img_sums_offset,\n"
"int img_sums_step,\n"
"float tpl_sum\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"img_sums_offset   /= sizeof(*img_sums);\n"
"img_sums_step     /= sizeof(*img_sums);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"float sum = (float)((img_sums[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums[SUMS_PTR(tpl_cols, 0)])\n"
"-(img_sums[SUMS_PTR(0, tpl_rows)] - img_sums[SUMS_PTR(0, 0)]));\n"
"res[res_idx] -= sum * tpl_sum;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Prepared_CCOFF_C4_D0\n"
"(\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int res_offset,\n"
"int res_step,\n"
"__global const uint * img_sums_c0,\n"
"__global const uint * img_sums_c1,\n"
"__global const uint * img_sums_c2,\n"
"__global const uint * img_sums_c3,\n"
"int img_sums_offset,\n"
"int img_sums_step,\n"
"float tpl_sum_c0,\n"
"float tpl_sum_c1,\n"
"float tpl_sum_c2,\n"
"float tpl_sum_c3\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"img_sums_offset   /= sizeof(*img_sums_c0);\n"
"img_sums_step     /= sizeof(*img_sums_c0);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"float ccorr = res[res_idx];\n"
"ccorr -= tpl_sum_c0*(float)(\n"
"(img_sums_c0[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums_c0[SUMS_PTR(tpl_cols, 0)])\n"
"- (img_sums_c0[SUMS_PTR(0, tpl_rows)] - img_sums_c0[SUMS_PTR(0, 0)]));\n"
"ccorr -= tpl_sum_c1*(float)(\n"
"(img_sums_c1[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums_c1[SUMS_PTR(tpl_cols, 0)])\n"
"- (img_sums_c1[SUMS_PTR(0, tpl_rows)] - img_sums_c1[SUMS_PTR(0, 0)]));\n"
"ccorr -= tpl_sum_c2*(float)(\n"
"(img_sums_c2[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums_c2[SUMS_PTR(tpl_cols, 0)])\n"
"- (img_sums_c2[SUMS_PTR(0, tpl_rows)] - img_sums_c2[SUMS_PTR(0, 0)]));\n"
"ccorr -= tpl_sum_c3*(float)(\n"
"(img_sums_c3[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums_c3[SUMS_PTR(tpl_cols, 0)])\n"
"- (img_sums_c3[SUMS_PTR(0, tpl_rows)] - img_sums_c3[SUMS_PTR(0, 0)]));\n"
"res[res_idx] = ccorr;\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Prepared_CCOFF_NORMED_C1_D0\n"
"(\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int res_offset,\n"
"int res_step,\n"
"float weight,\n"
"__global const uint * img_sums,\n"
"int img_sums_offset,\n"
"int img_sums_step,\n"
"__global const float * img_sqsums,\n"
"int img_sqsums_offset,\n"
"int img_sqsums_step,\n"
"float tpl_sum,\n"
"float tpl_sqsum\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"img_sqsums_step   /= sizeof(*img_sqsums);\n"
"img_sqsums_offset /= sizeof(*img_sqsums);\n"
"img_sums_offset   /= sizeof(*img_sums);\n"
"img_sums_step     /= sizeof(*img_sums);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"float image_sum_ =  (float)(\n"
"(img_sums[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums[SUMS_PTR(tpl_cols, 0)])\n"
"- (img_sums[SUMS_PTR(0, tpl_rows)] - img_sums[SUMS_PTR(0, 0)]));\n"
"float image_sqsum_ = (float)(\n"
"(img_sqsums[SQSUMS_PTR(tpl_cols, tpl_rows)] - img_sqsums[SQSUMS_PTR(tpl_cols, 0)]) -\n"
"(img_sqsums[SQSUMS_PTR(0, tpl_rows)] - img_sqsums[SQSUMS_PTR(0, 0)]));\n"
"res[res_idx] = normAcc(res[res_idx] - image_sum_ * tpl_sum,\n"
"sqrt(tpl_sqsum * (image_sqsum_ - weight * image_sum_ * image_sum_)));\n"
"}\n"
"}\n"
"__kernel\n"
"void matchTemplate_Prepared_CCOFF_NORMED_C4_D0\n"
"(\n"
"__global float * res,\n"
"int img_rows,\n"
"int img_cols,\n"
"int tpl_rows,\n"
"int tpl_cols,\n"
"int res_rows,\n"
"int res_cols,\n"
"int res_offset,\n"
"int res_step,\n"
"float weight,\n"
"__global const uint * img_sums_c0,\n"
"__global const uint * img_sums_c1,\n"
"__global const uint * img_sums_c2,\n"
"__global const uint * img_sums_c3,\n"
"int img_sums_offset,\n"
"int img_sums_step,\n"
"__global const float * img_sqsums_c0,\n"
"__global const float * img_sqsums_c1,\n"
"__global const float * img_sqsums_c2,\n"
"__global const float * img_sqsums_c3,\n"
"int img_sqsums_offset,\n"
"int img_sqsums_step,\n"
"float tpl_sum_c0,\n"
"float tpl_sum_c1,\n"
"float tpl_sum_c2,\n"
"float tpl_sum_c3,\n"
"float tpl_sqsum\n"
")\n"
"{\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"img_sqsums_step   /= sizeof(*img_sqsums_c0);\n"
"img_sqsums_offset /= sizeof(*img_sqsums_c0);\n"
"img_sums_offset   /= sizeof(*img_sums_c0);\n"
"img_sums_step     /= sizeof(*img_sums_c0);\n"
"res_step   /= sizeof(*res);\n"
"res_offset /= sizeof(*res);\n"
"int res_idx = mad24(gidy, res_step, res_offset + gidx);\n"
"if(gidx < res_cols && gidy < res_rows)\n"
"{\n"
"float image_sum_c0 =  (float)(\n"
"(img_sums_c0[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums_c0[SUMS_PTR(tpl_cols, 0)])\n"
"- (img_sums_c0[SUMS_PTR(0, tpl_rows)] - img_sums_c0[SUMS_PTR(0, 0)]));\n"
"float image_sum_c1 =  (float)(\n"
"(img_sums_c1[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums_c1[SUMS_PTR(tpl_cols, 0)])\n"
"- (img_sums_c1[SUMS_PTR(0, tpl_rows)] - img_sums_c1[SUMS_PTR(0, 0)]));\n"
"float image_sum_c2 =  (float)(\n"
"(img_sums_c2[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums_c2[SUMS_PTR(tpl_cols, 0)])\n"
"- (img_sums_c2[SUMS_PTR(0, tpl_rows)] - img_sums_c2[SUMS_PTR(0, 0)]));\n"
"float image_sum_c3 =  (float)(\n"
"(img_sums_c3[SUMS_PTR(tpl_cols, tpl_rows)] - img_sums_c3[SUMS_PTR(tpl_cols, 0)])\n"
"- (img_sums_c3[SUMS_PTR(0, tpl_rows)] - img_sums_c3[SUMS_PTR(0, 0)]));\n"
"float image_sqsum_c0 = (float)(\n"
"(img_sqsums_c0[SQSUMS_PTR(tpl_cols, tpl_rows)] - img_sqsums_c0[SQSUMS_PTR(tpl_cols, 0)]) -\n"
"(img_sqsums_c0[SQSUMS_PTR(0, tpl_rows)] - img_sqsums_c0[SQSUMS_PTR(0, 0)]));\n"
"float image_sqsum_c1 = (float)(\n"
"(img_sqsums_c1[SQSUMS_PTR(tpl_cols, tpl_rows)] - img_sqsums_c1[SQSUMS_PTR(tpl_cols, 0)]) -\n"
"(img_sqsums_c1[SQSUMS_PTR(0, tpl_rows)] - img_sqsums_c1[SQSUMS_PTR(0, 0)]));\n"
"float image_sqsum_c2 = (float)(\n"
"(img_sqsums_c2[SQSUMS_PTR(tpl_cols, tpl_rows)] - img_sqsums_c2[SQSUMS_PTR(tpl_cols, 0)]) -\n"
"(img_sqsums_c2[SQSUMS_PTR(0, tpl_rows)] - img_sqsums_c2[SQSUMS_PTR(0, 0)]));\n"
"float image_sqsum_c3 = (float)(\n"
"(img_sqsums_c3[SQSUMS_PTR(tpl_cols, tpl_rows)] - img_sqsums_c3[SQSUMS_PTR(tpl_cols, 0)]) -\n"
"(img_sqsums_c3[SQSUMS_PTR(0, tpl_rows)] - img_sqsums_c3[SQSUMS_PTR(0, 0)]));\n"
"float num = res[res_idx] -\n"
"image_sum_c0 * tpl_sum_c0 -\n"
"image_sum_c1 * tpl_sum_c1 -\n"
"image_sum_c2 * tpl_sum_c2 -\n"
"image_sum_c3 * tpl_sum_c3;\n"
"float denum = sqrt( tpl_sqsum * (\n"
"image_sqsum_c0 - weight * image_sum_c0 * image_sum_c0 +\n"
"image_sqsum_c1 - weight * image_sum_c1 * image_sum_c1 +\n"
"image_sqsum_c2 - weight * image_sum_c2 * image_sum_c2 +\n"
"image_sqsum_c3 - weight * image_sum_c0 * image_sum_c3)\n"
");\n"
"res[res_idx] = normAcc(num, denum);\n"
"}\n"
"}\n"
"__kernel\n"
"void extractFirstChannel\n"
"(\n"
"const __global float4* img,\n"
"__global float* res,\n"
"int rows,\n"
"int cols,\n"
"int img_offset,\n"
"int res_offset,\n"
"int img_step,\n"
"int res_step\n"
")\n"
"{\n"
"img_step   /= sizeof(float4);\n"
"res_step   /= sizeof(float);\n"
"img_offset /= sizeof(float4);\n"
"res_offset /= sizeof(float);\n"
"img += img_offset;\n"
"res += res_offset;\n"
"int gidx = get_global_id(0);\n"
"int gidy = get_global_id(1);\n"
"if(gidx < cols && gidy < rows)\n"
"{\n"
"res[gidx + gidy * res_step] = img[gidx + gidy * img_step].x;\n"
"}\n"
"}\n"
, "2f026d4f003285067e2fc4c6fc5866ba"};
const struct ProgramEntry meanShift={"meanShift",
"short2 do_mean_shift(int x0, int y0, __global uchar4* out,int out_step,\n"
"__global uchar4* in, int in_step, int dst_off, int src_off,\n"
"int cols, int rows, int sp, int sr, int maxIter, float eps)\n"
"{\n"
"int isr2 = sr*sr;\n"
"in_step = in_step >> 2;\n"
"out_step = out_step >> 2;\n"
"src_off = src_off >> 2;\n"
"dst_off = dst_off >> 2;\n"
"int idx = src_off + y0 * in_step + x0;\n"
"uchar4 c = in[idx];\n"
"int base = dst_off + get_global_id(1)*out_step + get_global_id(0) ;\n"
"for( int iter = 0; iter < maxIter; iter++ )\n"
"{\n"
"int count = 0;\n"
"int4 s = (int4)0;\n"
"int sx = 0, sy = 0;\n"
"int minx = (x0-sp)>0 ? x0-sp : 0;\n"
"int miny = (y0-sp)>0 ? y0-sp : 0;\n"
"int maxx = (x0+sp)<cols ? x0+sp : cols-1;\n"
"int maxy = (y0+sp)<rows ? y0+sp : rows-1;\n"
"for( int y = miny; y <= maxy; y++)\n"
"{\n"
"int rowCount = 0;\n"
"int x = minx;\n"
"for( ; x+3 <= maxx; x+=4 )\n"
"{\n"
"int id = src_off + y*in_step + x;\n"
"uchar16 t = (uchar16)(in[id],in[id+1],in[id+2],in[id+3]);\n"
"int norm2_1 = (t.s0 - c.x) * (t.s0 - c.x) + (t.s1 - c.y) * (t.s1 - c.y) +\n"
"(t.s2 - c.z) * (t.s2 - c.z);\n"
"int norm2_2 = (t.s4 - c.x) * (t.s4 - c.x) + (t.s5 - c.y) * (t.s5 - c.y) +\n"
"(t.s6 - c.z) * (t.s6 - c.z);\n"
"int norm2_3 = (t.s8 - c.x) * (t.s8 - c.x) + (t.s9 - c.y) * (t.s9 - c.y) +\n"
"(t.sa - c.z) * (t.sa - c.z);\n"
"int norm2_4 = (t.sc - c.x) * (t.sc - c.x) + (t.sd - c.y) * (t.sd - c.y) +\n"
"(t.se - c.z) * (t.se - c.z);\n"
"if( norm2_1 <= isr2 )\n"
"{\n"
"s.x += t.s0; s.y += t.s1; s.z += t.s2;\n"
"sx += x; rowCount++;\n"
"}\n"
"if( norm2_2 <= isr2 )\n"
"{\n"
"s.x += t.s4; s.y += t.s5; s.z += t.s6;\n"
"sx += x+1; rowCount++;\n"
"}\n"
"if( norm2_3 <= isr2 )\n"
"{\n"
"s.x += t.s8; s.y += t.s9; s.z += t.sa;\n"
"sx += x+2; rowCount++;\n"
"}\n"
"if( norm2_4 <= isr2 )\n"
"{\n"
"s.x += t.sc; s.y += t.sd; s.z += t.se;\n"
"sx += x+3; rowCount++;\n"
"}\n"
"}\n"
"if(x == maxx)\n"
"{\n"
"int id = src_off + y*in_step + x;\n"
"uchar4 t = in[id];\n"
"int norm2 = (t.s0 - c.x) * (t.s0 - c.x) + (t.s1 - c.y) * (t.s1 - c.y) +\n"
"(t.s2 - c.z) * (t.s2 - c.z);\n"
"if( norm2 <= isr2 )\n"
"{\n"
"s.x += t.s0; s.y += t.s1; s.z += t.s2;\n"
"sx += x; rowCount++;\n"
"}\n"
"}\n"
"if(x+1 == maxx)\n"
"{\n"
"int id = src_off + y*in_step + x;\n"
"uchar8 t = (uchar8)(in[id],in[id+1]);\n"
"int norm2_1 = (t.s0 - c.x) * (t.s0 - c.x) + (t.s1 - c.y) * (t.s1 - c.y) +\n"
"(t.s2 - c.z) * (t.s2 - c.z);\n"
"int norm2_2 = (t.s4 - c.x) * (t.s4 - c.x) + (t.s5 - c.y) * (t.s5 - c.y) +\n"
"(t.s6 - c.z) * (t.s6 - c.z);\n"
"if( norm2_1 <= isr2 )\n"
"{\n"
"s.x += t.s0; s.y += t.s1; s.z += t.s2;\n"
"sx += x; rowCount++;\n"
"}\n"
"if( norm2_2 <= isr2 )\n"
"{\n"
"s.x += t.s4; s.y += t.s5; s.z += t.s6;\n"
"sx += x+1; rowCount++;\n"
"}\n"
"}\n"
"if(x+2 == maxx)\n"
"{\n"
"int id = src_off + y*in_step + x;\n"
"uchar16 t = (uchar16)(in[id],in[id+1],in[id+2],in[id+3]);\n"
"int norm2_1 = (t.s0 - c.x) * (t.s0 - c.x) + (t.s1 - c.y) * (t.s1 - c.y) +\n"
"(t.s2 - c.z) * (t.s2 - c.z);\n"
"int norm2_2 = (t.s4 - c.x) * (t.s4 - c.x) + (t.s5 - c.y) * (t.s5 - c.y) +\n"
"(t.s6 - c.z) * (t.s6 - c.z);\n"
"int norm2_3 = (t.s8 - c.x) * (t.s8 - c.x) + (t.s9 - c.y) * (t.s9 - c.y) +\n"
"(t.sa - c.z) * (t.sa - c.z);\n"
"if( norm2_1 <= isr2 )\n"
"{\n"
"s.x += t.s0; s.y += t.s1; s.z += t.s2;\n"
"sx += x; rowCount++;\n"
"}\n"
"if( norm2_2 <= isr2 )\n"
"{\n"
"s.x += t.s4; s.y += t.s5; s.z += t.s6;\n"
"sx += x+1; rowCount++;\n"
"}\n"
"if( norm2_3 <= isr2 )\n"
"{\n"
"s.x += t.s8; s.y += t.s9; s.z += t.sa;\n"
"sx += x+2; rowCount++;\n"
"}\n"
"}\n"
"if(rowCount == 0)\n"
"continue;\n"
"count += rowCount;\n"
"if(y == 0)\n"
"continue;\n"
"sy += y*rowCount;\n"
"}\n"
"if( count == 0 )\n"
"break;\n"
"int x1 = sx/count;\n"
"int y1 = sy/count;\n"
"s.x = s.x/count;\n"
"s.y = s.y/count;\n"
"s.z = s.z/count;\n"
"int4 tmp = s - convert_int4(c);\n"
"int norm2 = tmp.x * tmp.x + tmp.y *  tmp.y +\n"
"tmp.z * tmp.z;\n"
"bool stopFlag = (x1 == x0 && y1 == y0) || (abs(x1-x0) + abs(y1-y0) + norm2 <= eps);\n"
"x0 = x1;\n"
"y0 = y1;\n"
"c.x = s.x;\n"
"c.y = s.y;\n"
"c.z = s.z;\n"
"if( stopFlag )\n"
"break;\n"
"}\n"
"out[base] = c;\n"
"return (short2)((short)x0, (short)y0);\n"
"}\n"
"__kernel void meanshift_kernel(__global uchar4* out, int out_step,\n"
"__global uchar4* in, int in_step,\n"
"int dst_off, int src_off, int cols, int rows,\n"
"int sp, int sr, int maxIter, float eps)\n"
"{\n"
"int x0 = get_global_id(0);\n"
"int y0 = get_global_id(1);\n"
"if( x0 < cols && y0 < rows )\n"
"do_mean_shift(x0, y0, out, out_step, in, in_step, dst_off, src_off,\n"
"cols, rows, sp, sr, maxIter, eps);\n"
"}\n"
"__kernel void meanshiftproc_kernel( __global uchar4* in, __global uchar4* outr,\n"
"__global short2* outsp, int instep, int outrstep,\n"
"int outspstep, int in_off, int outr_off, int outsp_off,\n"
"int cols, int rows, int sp, int sr, int maxIter, float eps )\n"
"{\n"
"int x0 = get_global_id(0);\n"
"int y0 = get_global_id(1);\n"
"if( x0 < cols && y0 < rows )\n"
"{\n"
"outsp_off >>= 2;\n"
"outspstep >>= 2;\n"
"int basesp = outsp_off + y0 * outspstep + x0;\n"
"outsp[basesp] = do_mean_shift(x0, y0, outr, outrstep, in, instep, outr_off, in_off, cols, rows, sp, sr, maxIter, eps);\n"
"}\n"
"}\n"
, "14dbf4c2ad30df918cadb74aa130aa77"};
const struct ProgramEntry merge_mat={"merge_mat",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void merge_vector_C2_D0(__global uchar *mat_dst,  int dst_step,  int dst_offset,\n"
"__global uchar *mat_src0, int src0_step, int src0_offset,\n"
"__global uchar *mat_src1, int src1_step, int src1_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"x = x << 1;\n"
"#define dst_align  ((dst_offset & 3) >> 1)\n"
"int src0_index = mad24(y, src0_step, src0_offset + x - dst_align);\n"
"int src1_index = mad24(y, src1_step, src1_offset + x - dst_align);\n"
"int dst_start  = mad24(y, dst_step, dst_offset);\n"
"int dst_end    = mad24(y, dst_step, dst_offset + dst_step1);\n"
"int dst_index  = mad24(y, dst_step, dst_offset + (x << 1) & (int)0xfffffffc);\n"
"__global uchar4 * dst  = (__global uchar4 *)(mat_dst + dst_index);\n"
"__global uchar  * src0 = mat_src0 + src0_index;\n"
"__global uchar  * src1 = src0     + 1;\n"
"__global uchar  * src2 = mat_src1 + src1_index;\n"
"__global uchar  * src3 = src2     + 1;\n"
"uchar4 dst_data = *dst;\n"
"uchar  data_0   = *(src0);\n"
"uchar  data_1   = *(src1);\n"
"uchar  data_2   = *(src2);\n"
"uchar  data_3   = *(src3);\n"
"uchar4 tmp_data = (uchar4)(data_0, data_2, data_1, data_3);\n"
"tmp_data.xy = dst_index + 0 >= dst_start ? tmp_data.xy : dst_data.xy;\n"
"tmp_data.zw = dst_index + 2 <  dst_end   ? tmp_data.zw : dst_data.zw;\n"
"*dst = tmp_data;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D1(__global char *mat_dst,  int dst_step,  int dst_offset,\n"
"__global char *mat_src0, int src0_step, int src0_offset,\n"
"__global char *mat_src1, int src1_step, int src1_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"x = x << 1;\n"
"#define dst_align  ((dst_offset & 3) >> 1)\n"
"int src0_index = mad24(y, src0_step, src0_offset + x - dst_align);\n"
"int src1_index = mad24(y, src1_step, src1_offset + x - dst_align);\n"
"int dst_start  = mad24(y, dst_step, dst_offset);\n"
"int dst_end    = mad24(y, dst_step, dst_offset + dst_step1);\n"
"int dst_index  = mad24(y, dst_step, dst_offset + (x << 1) & (int)0xfffffffc);\n"
"__global char4 * dst  = (__global char4 *)(mat_dst + dst_index);\n"
"__global char  * src0 = mat_src0 + src0_index;\n"
"__global char  * src1 = src0     + 1;\n"
"__global char  * src2 = mat_src1 + src1_index;\n"
"__global char  * src3 = src2     + 1;\n"
"char4 dst_data = *dst;\n"
"char  data_0   = *(src0);\n"
"char  data_1   = *(src1);\n"
"char  data_2   = *(src2);\n"
"char  data_3   = *(src3);\n"
"char4 tmp_data = (char4)(data_0, data_2, data_1, data_3);\n"
"tmp_data.xy = dst_index + 0 >= dst_start ? tmp_data.xy : dst_data.xy;\n"
"tmp_data.zw = dst_index + 2 <  dst_end   ? tmp_data.zw : dst_data.zw;\n"
"*dst = tmp_data;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D2(__global ushort *mat_dst,  int dst_step,  int dst_offset,\n"
"__global ushort *mat_src0, int src0_step, int src0_offset,\n"
"__global ushort *mat_src1, int src1_step, int src1_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"__global ushort*  src0 = (__global ushort * )((__global uchar *)mat_src0 + src0_index + (x << 1));\n"
"__global ushort*  src1 = (__global ushort * )((__global uchar *)mat_src1 + src1_index + (x << 1));\n"
"__global ushort2* dist = (__global ushort2 *)((__global uchar *)mat_dst  + dst_index  + (x << 2));\n"
"ushort  src0_data = *src0;\n"
"ushort  src1_data = *src1;\n"
"*dist = (ushort2)(src0_data, src1_data);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D3(__global short *mat_dst,  int dst_step,  int dst_offset,\n"
"__global short *mat_src0, int src0_step, int src0_offset,\n"
"__global short *mat_src1, int src1_step, int src1_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"__global short*  src0 = (__global short * )((__global uchar *)mat_src0 + src0_index + (x << 1));\n"
"__global short*  src1 = (__global short * )((__global uchar *)mat_src1 + src1_index + (x << 1));\n"
"__global short2* dist = (__global short2 *)((__global uchar *)mat_dst  + dst_index   + (x << 2));\n"
"short  src0_data = *src0;\n"
"short  src1_data = *src1;\n"
"*dist = (short2)(src0_data, src1_data);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D4(__global int *mat_dst,  int dst_step,  int dst_offset,\n"
"__global int *mat_src0, int src0_step, int src0_offset,\n"
"__global int *mat_src1, int src1_step, int src1_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"int src0 = *((__global int *)((__global uchar *)mat_src0 + src0_index + (x << 2)));\n"
"int src1 = *((__global int *)((__global uchar *)mat_src1 + src1_index + (x << 2)));\n"
"*((__global int2 *)((__global uchar *)mat_dst  + dst_index + (x << 3))) = (int2)(src0, src1);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D5(__global float *mat_dst,  int dst_step,  int dst_offset,\n"
"__global float *mat_src0, int src0_step, int src0_offset,\n"
"__global float *mat_src1, int src1_step, int src1_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"float src0 = *((__global float *)((__global uchar *)mat_src0 + src0_index + (x << 2)));\n"
"float src1 = *((__global float *)((__global uchar *)mat_src1 + src1_index + (x << 2)));\n"
"*((__global float2 *)((__global uchar *)mat_dst  + dst_index + (x << 3))) = (float2)(src0, src1);\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void merge_vector_C2_D6(__global double *mat_dst,  int dst_step,  int dst_offset,\n"
"__global double *mat_src0, int src0_step, int src0_offset,\n"
"__global double *mat_src1, int src1_step, int src1_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"double src0 = *((__global double *)((__global uchar *)mat_src0 + src0_index + (x << 3)));\n"
"double src1 = *((__global double *)((__global uchar *)mat_src1 + src1_index + (x << 3)));\n"
"*((__global double2 *)((__global uchar *)mat_dst  + dst_index + (x << 4))) = (double2)(src0, src1);\n"
"}\n"
"}\n"
"#endif\n"
"__kernel void merge_vector_C3_D0(__global uchar *mat_dst,  int dst_step,  int dst_offset,\n"
"__global uchar *mat_src0, int src0_step, int src0_offset,\n"
"__global uchar *mat_src1, int src1_step, int src1_offset,\n"
"__global uchar *mat_src2, int src2_step, int src2_offset, int offset_cols,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"x = x << 2;\n"
"int src0_index = mad24(y, src0_step, x + src0_offset - offset_cols);\n"
"int src1_index = mad24(y, src1_step, x + src1_offset - offset_cols);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset - offset_cols);\n"
"int dst_start = mad24(y, dst_step, dst_offset);\n"
"int dst_end   = mad24(y, dst_step, dst_offset + dst_step1);\n"
"int dst_index = mad24(y, dst_step, dst_offset + 3 * x - offset_cols * 3);\n"
"uchar data0_0 = *(mat_src0 + src0_index + 0);\n"
"uchar data0_1 = *(mat_src0 + src0_index + 1);\n"
"uchar data0_2 = *(mat_src0 + src0_index + 2);\n"
"uchar data0_3 = *(mat_src0 + src0_index + 3);\n"
"uchar data1_0 = *(mat_src1 + src1_index + 0);\n"
"uchar data1_1 = *(mat_src1 + src1_index + 1);\n"
"uchar data1_2 = *(mat_src1 + src1_index + 2);\n"
"uchar data1_3 = *(mat_src1 + src1_index + 3);\n"
"uchar data2_0 = *(mat_src2 + src2_index + 0);\n"
"uchar data2_1 = *(mat_src2 + src2_index + 1);\n"
"uchar data2_2 = *(mat_src2 + src2_index + 2);\n"
"uchar data2_3 = *(mat_src2 + src2_index + 3);\n"
"uchar4 tmp_data0 = (uchar4)(data0_0, data1_0, data2_0, data0_1);\n"
"uchar4 tmp_data1 = (uchar4)(data1_1, data2_1, data0_2, data1_2);\n"
"uchar4 tmp_data2 = (uchar4)(data2_2, data0_3, data1_3, data2_3);\n"
"uchar4 dst_data0 = *((__global uchar4*)(mat_dst + dst_index + 0));\n"
"uchar4 dst_data1 = *((__global uchar4*)(mat_dst + dst_index + 4));\n"
"uchar4 dst_data2 = *((__global uchar4*)(mat_dst + dst_index + 8));\n"
"tmp_data0.x = ((dst_index + 0  >= dst_start) && (dst_index + 0  < dst_end)) ? tmp_data0.x : dst_data0.x;\n"
"tmp_data0.y = ((dst_index + 1  >= dst_start) && (dst_index + 1  < dst_end)) ? tmp_data0.y : dst_data0.y;\n"
"tmp_data0.z = ((dst_index + 2  >= dst_start) && (dst_index + 2  < dst_end)) ? tmp_data0.z : dst_data0.z;\n"
"tmp_data0.w = ((dst_index + 3  >= dst_start) && (dst_index + 3  < dst_end)) ? tmp_data0.w : dst_data0.w;\n"
"tmp_data1.x = ((dst_index + 4  >= dst_start) && (dst_index + 4  < dst_end)) ? tmp_data1.x : dst_data1.x;\n"
"tmp_data1.y = ((dst_index + 5  >= dst_start) && (dst_index + 5  < dst_end)) ? tmp_data1.y : dst_data1.y;\n"
"tmp_data1.z = ((dst_index + 6  >= dst_start) && (dst_index + 6  < dst_end)) ? tmp_data1.z : dst_data1.z;\n"
"tmp_data1.w = ((dst_index + 7  >= dst_start) && (dst_index + 7  < dst_end)) ? tmp_data1.w : dst_data1.w;\n"
"tmp_data2.x = ((dst_index + 8  >= dst_start) && (dst_index + 8  < dst_end)) ? tmp_data2.x : dst_data2.x;\n"
"tmp_data2.y = ((dst_index + 9  >= dst_start) && (dst_index + 9  < dst_end)) ? tmp_data2.y : dst_data2.y;\n"
"tmp_data2.z = ((dst_index + 10 >= dst_start) && (dst_index + 10 < dst_end)) ? tmp_data2.z : dst_data2.z;\n"
"tmp_data2.w = ((dst_index + 11 >= dst_start) && (dst_index + 11 < dst_end)) ? tmp_data2.w : dst_data2.w;\n"
"*((__global uchar4*)(mat_dst + dst_index + 0)) = tmp_data0;\n"
"*((__global uchar4*)(mat_dst + dst_index + 4)) = tmp_data1;\n"
"*((__global uchar4*)(mat_dst + dst_index + 8)) = tmp_data2;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D1(__global char *mat_dst,  int dst_step,  int dst_offset,\n"
"__global char *mat_src0, int src0_step, int src0_offset,\n"
"__global char *mat_src1, int src1_step, int src1_offset,\n"
"__global char *mat_src2, int src2_step, int src2_offset, int offset_cols,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"x = x << 2;\n"
"int src0_index = mad24(y, src0_step, x + src0_offset - offset_cols);\n"
"int src1_index = mad24(y, src1_step, x + src1_offset - offset_cols);\n"
"int src2_index = mad24(y, src2_step, x + src2_offset - offset_cols);\n"
"int dst_start = mad24(y, dst_step, dst_offset);\n"
"int dst_end   = mad24(y, dst_step, dst_offset + dst_step1);\n"
"int dst_index = mad24(y, dst_step, dst_offset + 3 * x - offset_cols * 3);\n"
"char data0_0 = *(mat_src0 + src0_index + 0);\n"
"char data0_1 = *(mat_src0 + src0_index + 1);\n"
"char data0_2 = *(mat_src0 + src0_index + 2);\n"
"char data0_3 = *(mat_src0 + src0_index + 3);\n"
"char data1_0 = *(mat_src1 + src1_index + 0);\n"
"char data1_1 = *(mat_src1 + src1_index + 1);\n"
"char data1_2 = *(mat_src1 + src1_index + 2);\n"
"char data1_3 = *(mat_src1 + src1_index + 3);\n"
"char data2_0 = *(mat_src2 + src2_index + 0);\n"
"char data2_1 = *(mat_src2 + src2_index + 1);\n"
"char data2_2 = *(mat_src2 + src2_index + 2);\n"
"char data2_3 = *(mat_src2 + src2_index + 3);\n"
"char4 tmp_data0 = (char4)(data0_0, data1_0, data2_0, data0_1);\n"
"char4 tmp_data1 = (char4)(data1_1, data2_1, data0_2, data1_2);\n"
"char4 tmp_data2 = (char4)(data2_2, data0_3, data1_3, data2_3);\n"
"char4 dst_data0 = *((__global char4*)(mat_dst + dst_index + 0));\n"
"char4 dst_data1 = *((__global char4*)(mat_dst + dst_index + 4));\n"
"char4 dst_data2 = *((__global char4*)(mat_dst + dst_index + 8));\n"
"tmp_data0.x = ((dst_index + 0  >= dst_start) && (dst_index + 0  < dst_end)) ? tmp_data0.x : dst_data0.x;\n"
"tmp_data0.y = ((dst_index + 1  >= dst_start) && (dst_index + 1  < dst_end)) ? tmp_data0.y : dst_data0.y;\n"
"tmp_data0.z = ((dst_index + 2  >= dst_start) && (dst_index + 2  < dst_end)) ? tmp_data0.z : dst_data0.z;\n"
"tmp_data0.w = ((dst_index + 3  >= dst_start) && (dst_index + 3  < dst_end)) ? tmp_data0.w : dst_data0.w;\n"
"tmp_data1.x = ((dst_index + 4  >= dst_start) && (dst_index + 4  < dst_end)) ? tmp_data1.x : dst_data1.x;\n"
"tmp_data1.y = ((dst_index + 5  >= dst_start) && (dst_index + 5  < dst_end)) ? tmp_data1.y : dst_data1.y;\n"
"tmp_data1.z = ((dst_index + 6  >= dst_start) && (dst_index + 6  < dst_end)) ? tmp_data1.z : dst_data1.z;\n"
"tmp_data1.w = ((dst_index + 7  >= dst_start) && (dst_index + 7  < dst_end)) ? tmp_data1.w : dst_data1.w;\n"
"tmp_data2.x = ((dst_index + 8  >= dst_start) && (dst_index + 8  < dst_end)) ? tmp_data2.x : dst_data2.x;\n"
"tmp_data2.y = ((dst_index + 9  >= dst_start) && (dst_index + 9  < dst_end)) ? tmp_data2.y : dst_data2.y;\n"
"tmp_data2.z = ((dst_index + 10 >= dst_start) && (dst_index + 10 < dst_end)) ? tmp_data2.z : dst_data2.z;\n"
"tmp_data2.w = ((dst_index + 11 >= dst_start) && (dst_index + 11 < dst_end)) ? tmp_data2.w : dst_data2.w;\n"
"*((__global char4*)(mat_dst + dst_index + 0)) = tmp_data0;\n"
"*((__global char4*)(mat_dst + dst_index + 4)) = tmp_data1;\n"
"*((__global char4*)(mat_dst + dst_index + 8)) = tmp_data2;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D2(__global ushort *mat_dst,  int dst_step,  int dst_offset,\n"
"__global ushort *mat_src0, int src0_step, int src0_offset,\n"
"__global ushort *mat_src1, int src1_step, int src1_offset,\n"
"__global ushort *mat_src2, int src2_step, int src2_offset, int offset_cols,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"x = x << 1;\n"
"int src0_index = mad24(y, src0_step, (x << 1) + src0_offset - offset_cols);\n"
"int src1_index = mad24(y, src1_step, (x << 1) + src1_offset - offset_cols);\n"
"int src2_index = mad24(y, src2_step, (x << 1) + src2_offset - offset_cols);\n"
"int dst_start = mad24(y, dst_step, dst_offset);\n"
"int dst_end   = mad24(y, dst_step, dst_offset + dst_step1);\n"
"int dst_index = mad24(y, dst_step, dst_offset + 6 * x - offset_cols * 6);\n"
"ushort data0_0 = *((__global ushort *)((__global char *)mat_src0 + src0_index + 0));\n"
"ushort data0_1 = *((__global ushort *)((__global char *)mat_src0 + src0_index + 2));\n"
"ushort data1_0 = *((__global ushort *)((__global char *)mat_src1 + src1_index + 0));\n"
"ushort data1_1 = *((__global ushort *)((__global char *)mat_src1 + src1_index + 2));\n"
"ushort data2_0 = *((__global ushort *)((__global char *)mat_src2 + src2_index + 0));\n"
"ushort data2_1 = *((__global ushort *)((__global char *)mat_src2 + src2_index + 2));\n"
"ushort2 tmp_data0 = (ushort2)(data0_0, data1_0);\n"
"ushort2 tmp_data1 = (ushort2)(data2_0, data0_1);\n"
"ushort2 tmp_data2 = (ushort2)(data1_1, data2_1);\n"
"ushort2 dst_data0 = *((__global ushort2*)((__global char *)mat_dst + dst_index + 0));\n"
"ushort2 dst_data1 = *((__global ushort2*)((__global char *)mat_dst + dst_index + 4));\n"
"ushort2 dst_data2 = *((__global ushort2*)((__global char *)mat_dst + dst_index + 8));\n"
"tmp_data0.x = ((dst_index + 0  >= dst_start) && (dst_index + 0  < dst_end)) ? tmp_data0.x : dst_data0.x;\n"
"tmp_data0.y = ((dst_index + 2  >= dst_start) && (dst_index + 2  < dst_end)) ? tmp_data0.y : dst_data0.y;\n"
"tmp_data1.x = ((dst_index + 4  >= dst_start) && (dst_index + 4  < dst_end)) ? tmp_data1.x : dst_data1.x;\n"
"tmp_data1.y = ((dst_index + 6  >= dst_start) && (dst_index + 6  < dst_end)) ? tmp_data1.y : dst_data1.y;\n"
"tmp_data2.x = ((dst_index + 8  >= dst_start) && (dst_index + 8  < dst_end)) ? tmp_data2.x : dst_data2.x;\n"
"tmp_data2.y = ((dst_index + 10 >= dst_start) && (dst_index + 10 < dst_end)) ? tmp_data2.y : dst_data2.y;\n"
"*((__global ushort2*)((__global char *)mat_dst + dst_index + 0)) = tmp_data0;\n"
"*((__global ushort2*)((__global char *)mat_dst + dst_index + 4)) = tmp_data1;\n"
"*((__global ushort2*)((__global char *)mat_dst + dst_index + 8)) = tmp_data2;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D3(__global short *mat_dst,  int dst_step,  int dst_offset,\n"
"__global short *mat_src0, int src0_step, int src0_offset,\n"
"__global short *mat_src1, int src1_step, int src1_offset,\n"
"__global short *mat_src2, int src2_step, int src2_offset, int offset_cols,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"x = x << 1;\n"
"int src0_index = mad24(y, src0_step, (x << 1) + src0_offset - offset_cols);\n"
"int src1_index = mad24(y, src1_step, (x << 1) + src1_offset - offset_cols);\n"
"int src2_index = mad24(y, src2_step, (x << 1) + src2_offset - offset_cols);\n"
"int dst_start = mad24(y, dst_step, dst_offset);\n"
"int dst_end   = mad24(y, dst_step, dst_offset + dst_step1);\n"
"int dst_index = mad24(y, dst_step, dst_offset + 6 * x - offset_cols * 6);\n"
"short data0_0 = *((__global short *)((__global char *)mat_src0 + src0_index + 0));\n"
"short data0_1 = *((__global short *)((__global char *)mat_src0 + src0_index + 2));\n"
"short data1_0 = *((__global short *)((__global char *)mat_src1 + src1_index + 0));\n"
"short data1_1 = *((__global short *)((__global char *)mat_src1 + src1_index + 2));\n"
"short data2_0 = *((__global short *)((__global char *)mat_src2 + src2_index + 0));\n"
"short data2_1 = *((__global short *)((__global char *)mat_src2 + src2_index + 2));\n"
"short2 tmp_data0 = (short2)(data0_0, data1_0);\n"
"short2 tmp_data1 = (short2)(data2_0, data0_1);\n"
"short2 tmp_data2 = (short2)(data1_1, data2_1);\n"
"short2 dst_data0 = *((__global short2*)((__global char *)mat_dst + dst_index + 0));\n"
"short2 dst_data1 = *((__global short2*)((__global char *)mat_dst + dst_index + 4));\n"
"short2 dst_data2 = *((__global short2*)((__global char *)mat_dst + dst_index + 8));\n"
"tmp_data0.x = ((dst_index + 0  >= dst_start) && (dst_index + 0  < dst_end)) ? tmp_data0.x : dst_data0.x;\n"
"tmp_data0.y = ((dst_index + 2  >= dst_start) && (dst_index + 2  < dst_end)) ? tmp_data0.y : dst_data0.y;\n"
"tmp_data1.x = ((dst_index + 4  >= dst_start) && (dst_index + 4  < dst_end)) ? tmp_data1.x : dst_data1.x;\n"
"tmp_data1.y = ((dst_index + 6  >= dst_start) && (dst_index + 6  < dst_end)) ? tmp_data1.y : dst_data1.y;\n"
"tmp_data2.x = ((dst_index + 8  >= dst_start) && (dst_index + 8  < dst_end)) ? tmp_data2.x : dst_data2.x;\n"
"tmp_data2.y = ((dst_index + 10 >= dst_start) && (dst_index + 10 < dst_end)) ? tmp_data2.y : dst_data2.y;\n"
"*((__global short2*)((__global char *)mat_dst + dst_index + 0)) = tmp_data0;\n"
"*((__global short2*)((__global char *)mat_dst + dst_index + 4)) = tmp_data1;\n"
"*((__global short2*)((__global char *)mat_dst + dst_index + 8)) = tmp_data2;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D4(__global int *mat_dst,  int dst_step,  int dst_offset,\n"
"__global int *mat_src0, int src0_step, int src0_offset,\n"
"__global int *mat_src1, int src1_step, int src1_offset,\n"
"__global int *mat_src2, int src2_step, int src2_offset, int offset_cols,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"__global int* src0 = (__global int * )((__global uchar *)mat_src0 + src0_index + (x << 2));\n"
"__global int* src1 = (__global int * )((__global uchar *)mat_src1 + src1_index + (x << 2));\n"
"__global int* src2 = (__global int * )((__global uchar *)mat_src2 + src2_index + (x << 2));\n"
"__global int* dist0 = (__global int *)((__global uchar *)mat_dst  + dst_index  + 3 * (x << 2));\n"
"__global int* dist1 = dist0 + 1;\n"
"__global int* dist2 = dist0 + 2;\n"
"int  src0_data = *src0;\n"
"int  src1_data = *src1;\n"
"int  src2_data = *src2;\n"
"*dist0 = src0_data;\n"
"*dist1 = src1_data;\n"
"*dist2 = src2_data;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D5(__global float *mat_dst,  int dst_step,  int dst_offset,\n"
"__global float *mat_src0, int src0_step, int src0_offset,\n"
"__global float *mat_src1, int src1_step, int src1_offset,\n"
"__global float *mat_src2, int src2_step, int src2_offset, int offset_cols,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"__global float* src0 = (__global float * )((__global uchar *)mat_src0 + src0_index + (x << 2));\n"
"__global float* src1 = (__global float * )((__global uchar *)mat_src1 + src1_index + (x << 2));\n"
"__global float* src2 = (__global float * )((__global uchar *)mat_src2 + src2_index + (x << 2));\n"
"__global float* dist0 = (__global float *)((__global uchar *)mat_dst  + dst_index  + 3 * (x << 2));\n"
"__global float* dist1 = dist0 + 1;\n"
"__global float* dist2 = dist0 + 2;\n"
"float  src0_data = *src0;\n"
"float  src1_data = *src1;\n"
"float  src2_data = *src2;\n"
"*dist0 = src0_data;\n"
"*dist1 = src1_data;\n"
"*dist2 = src2_data;\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void merge_vector_C3_D6(__global double *mat_dst,  int dst_step,  int dst_offset,\n"
"__global double *mat_src0, int src0_step, int src0_offset,\n"
"__global double *mat_src1, int src1_step, int src1_offset,\n"
"__global double *mat_src2, int src2_step, int src2_offset, int offset_cols,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"__global double* src0 = (__global double * )((__global uchar *)mat_src0 + src0_index + (x << 3));\n"
"__global double* src1 = (__global double * )((__global uchar *)mat_src1 + src1_index + (x << 3));\n"
"__global double* src2 = (__global double * )((__global uchar *)mat_src2 + src2_index + (x << 3));\n"
"__global double* dist0 = (__global double *)((__global uchar *)mat_dst  + dst_index  + 3 * (x << 3));\n"
"__global double* dist1 = dist0 + 1;\n"
"__global double* dist2 = dist0 + 2;\n"
"double  src0_data = *src0;\n"
"double  src1_data = *src1;\n"
"double  src2_data = *src2;\n"
"*dist0 = src0_data;\n"
"*dist1 = src1_data;\n"
"*dist2 = src2_data;\n"
"}\n"
"}\n"
"#endif\n"
"__kernel void merge_vector_C4_D0(__global uchar *mat_dst,  int dst_step,  int dst_offset,\n"
"__global uchar *mat_src0, int src0_step, int src0_offset,\n"
"__global uchar *mat_src1, int src1_step, int src1_offset,\n"
"__global uchar *mat_src2, int src2_step, int src2_offset,\n"
"__global uchar *mat_src3, int src3_step, int src3_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int src3_index = mad24(y, src3_step, src3_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"uchar src0 = *(mat_src0 + src0_index + x );\n"
"uchar src1 = *(mat_src1 + src1_index + x);\n"
"uchar src2 = *(mat_src2 + src2_index + x);\n"
"uchar src3 = *(mat_src3 + src3_index + x);\n"
"*((__global uchar4 *)(mat_dst  + dst_index + (x << 2))) = (uchar4)(src0, src1, src2, src3);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D1(__global char *mat_dst,  int dst_step,  int dst_offset,\n"
"__global char *mat_src0, int src0_step, int src0_offset,\n"
"__global char *mat_src1, int src1_step, int src1_offset,\n"
"__global char *mat_src2, int src2_step, int src2_offset,\n"
"__global char *mat_src3, int src3_step, int src3_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int src3_index = mad24(y, src3_step, src3_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"char src0 = *(mat_src0 + src0_index + x );\n"
"char src1 = *(mat_src1 + src1_index + x);\n"
"char src2 = *(mat_src2 + src2_index + x);\n"
"char src3 = *(mat_src3 + src3_index + x);\n"
"*((__global char4 *)(mat_dst  + dst_index + (x << 2))) = (char4)(src0, src1, src2, src3);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D2(__global ushort *mat_dst,  int dst_step,  int dst_offset,\n"
"__global ushort *mat_src0, int src0_step, int src0_offset,\n"
"__global ushort *mat_src1, int src1_step, int src1_offset,\n"
"__global ushort *mat_src2, int src2_step, int src2_offset,\n"
"__global ushort *mat_src3, int src3_step, int src3_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int src3_index = mad24(y, src3_step, src3_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"ushort src0 = *((__global ushort *)((__global uchar *)mat_src0 + src0_index + (x << 1)));\n"
"ushort src1 = *((__global ushort *)((__global uchar *)mat_src1 + src1_index + (x << 1)));\n"
"ushort src2 = *((__global ushort *)((__global uchar *)mat_src2 + src2_index + (x << 1)));\n"
"ushort src3 = *((__global ushort *)((__global uchar *)mat_src3 + src3_index + (x << 1)));\n"
"*((__global ushort4 *)((__global uchar *)mat_dst  + dst_index + (x << 3))) = (ushort4)(src0, src1, src2, src3);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D3(__global short *mat_dst,  int dst_step,  int dst_offset,\n"
"__global short *mat_src0, int src0_step, int src0_offset,\n"
"__global short *mat_src1, int src1_step, int src1_offset,\n"
"__global short *mat_src2, int src2_step, int src2_offset,\n"
"__global short *mat_src3, int src3_step, int src3_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int src3_index = mad24(y, src3_step, src3_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"short src0 = *((__global short *)((__global uchar *)mat_src0 + src0_index + (x << 1)));\n"
"short src1 = *((__global short *)((__global uchar *)mat_src1 + src1_index + (x << 1)));\n"
"short src2 = *((__global short *)((__global uchar *)mat_src2 + src2_index + (x << 1)));\n"
"short src3 = *((__global short *)((__global uchar *)mat_src3 + src3_index + (x << 1)));\n"
"*((__global short4 *)((__global uchar *)mat_dst  + dst_index + (x << 3))) = (short4)(src0, src1, src2, src3);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D4(__global int *mat_dst,  int dst_step,  int dst_offset,\n"
"__global int *mat_src0, int src0_step, int src0_offset,\n"
"__global int *mat_src1, int src1_step, int src1_offset,\n"
"__global int *mat_src2, int src2_step, int src2_offset,\n"
"__global int *mat_src3, int src3_step, int src3_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int src3_index = mad24(y, src3_step, src3_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"int src0 = *((__global int *)((__global uchar *)mat_src0 + src0_index + (x << 2)));\n"
"int src1 = *((__global int *)((__global uchar *)mat_src1 + src1_index + (x << 2)));\n"
"int src2 = *((__global int *)((__global uchar *)mat_src2 + src2_index + (x << 2)));\n"
"int src3 = *((__global int *)((__global uchar *)mat_src3 + src3_index + (x << 2)));\n"
"*((__global int4 *)((__global uchar *)mat_dst  + dst_index + (x << 4))) = (int4)(src0, src1, src2, src3);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D5(__global float *mat_dst,  int dst_step,  int dst_offset,\n"
"__global float *mat_src0, int src0_step, int src0_offset,\n"
"__global float *mat_src1, int src1_step, int src1_offset,\n"
"__global float *mat_src2, int src2_step, int src2_offset,\n"
"__global float *mat_src3, int src3_step, int src3_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int src3_index = mad24(y, src3_step, src3_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"float src0 = *((__global float *)((__global uchar *)mat_src0 + src0_index + (x << 2)));\n"
"float src1 = *((__global float *)((__global uchar *)mat_src1 + src1_index + (x << 2)));\n"
"float src2 = *((__global float *)((__global uchar *)mat_src2 + src2_index + (x << 2)));\n"
"float src3 = *((__global float *)((__global uchar *)mat_src3 + src3_index + (x << 2)));\n"
"*((__global float4 *)((__global uchar *)mat_dst  + dst_index + (x << 4))) = (float4)(src0, src1, src2, src3);\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void merge_vector_C4_D6(__global double *mat_dst,  int dst_step,  int dst_offset,\n"
"__global double *mat_src0, int src0_step, int src0_offset,\n"
"__global double *mat_src1, int src1_step, int src1_offset,\n"
"__global double *mat_src2, int src2_step, int src2_offset,\n"
"__global double *mat_src3, int src3_step, int src3_offset,\n"
"int rows, int cols, int dst_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"int src0_index = mad24(y, src0_step, src0_offset);\n"
"int src1_index = mad24(y, src1_step, src1_offset);\n"
"int src2_index = mad24(y, src2_step, src2_offset);\n"
"int src3_index = mad24(y, src3_step, src3_offset);\n"
"int dst_index  = mad24(y, dst_step , dst_offset);\n"
"double src0 = *((__global double *)((__global uchar *)mat_src0 + src0_index + (x << 3)));\n"
"double src1 = *((__global double *)((__global uchar *)mat_src1 + src1_index + (x << 3)));\n"
"double src2 = *((__global double *)((__global uchar *)mat_src2 + src2_index + (x << 3)));\n"
"double src3 = *((__global double *)((__global uchar *)mat_src3 + src3_index + (x << 3)));\n"
"*((__global double4 *)((__global uchar *)mat_dst  + dst_index + (x << 5))) = (double4)(src0, src1, src2, src3);\n"
"}\n"
"}\n"
"#endif\n"
"__kernel void merge_vector_C2_D0_1(int rows, int cols,\n"
"__global uchar *mat_dst,  int dst_step,\n"
"__global uchar *mat_src0, int src0_step,\n"
"__global uchar *mat_src1, int src1_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global uchar4  *src0_y = (__global uchar4 * )(mat_src0 + y * src0_step);\n"
"__global uchar4  *src1_y = (__global uchar4 * )(mat_src1 + y * src1_step);\n"
"__global uchar8 *dst_y  = (__global uchar8 *)(mat_dst  + y * dst_step);\n"
"uchar4 value1 = src0_y[x];\n"
"uchar4 value2 = src1_y[x];\n"
"uchar8 value;\n"
"value.even = value1;\n"
"value.odd = value2;\n"
"dst_y[x] = value;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D1_1(int rows, int cols,\n"
"__global char *mat_dst,  int dst_step,\n"
"__global char *mat_src0, int src0_step,\n"
"__global char *mat_src1, int src1_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global char4  *src0_y = (__global char4 * )(mat_src0 + y * src0_step);\n"
"__global char4  *src1_y = (__global char4 * )(mat_src1 + y * src1_step);\n"
"__global char8 *dst_y  = (__global char8 *)(mat_dst  + y * dst_step);\n"
"char4 value1 = src0_y[x];\n"
"char4 value2 = src1_y[x];\n"
"char8 value;\n"
"value.even = value1;\n"
"value.odd = value2;\n"
"dst_y[x] = value;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D2_1(int rows, int cols,\n"
"__global ushort *mat_dst,  int dst_step,\n"
"__global ushort *mat_src0, int src0_step,\n"
"__global ushort *mat_src1, int src1_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global ushort2  *src0_y = (__global ushort2 *)((__global uchar *)mat_src0 + y * src0_step);\n"
"__global ushort2  *src1_y = (__global ushort2 *)((__global uchar *)mat_src1 + y * src1_step);\n"
"__global ushort4  *dst_y  = (__global ushort4 *)((__global uchar *)mat_dst  + y * dst_step);\n"
"ushort2 value1 = src0_y[x];\n"
"ushort2 value2 = src1_y[x];\n"
"ushort4 value;\n"
"value.even = value1;\n"
"value.odd = value2;\n"
"dst_y[x] = value;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D3_1(int rows, int cols,\n"
"__global short *mat_dst,  int dst_step,\n"
"__global short *mat_src0, int src0_step,\n"
"__global short *mat_src1, int src1_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global short2  *src0_y = (__global short2 *)((__global uchar *)mat_src0 + y * src0_step);\n"
"__global short2  *src1_y = (__global short2 *)((__global uchar *)mat_src1 + y * src1_step);\n"
"__global short4 *dst_y   = (__global short4 *)((__global uchar *)mat_dst  + y * dst_step);\n"
"short2 value1 = src0_y[x];\n"
"short2 value2 = src1_y[x];\n"
"short4 value;\n"
"value.even = value1;\n"
"value.odd = value2;\n"
"dst_y[x] = value;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D4_1(int rows, int cols,\n"
"__global int *mat_dst,  int dst_step,\n"
"__global int *mat_src0, int src0_step,\n"
"__global int *mat_src1, int src1_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global int  *src0_y = (__global int *)((__global uchar *)mat_src0 + y * src0_step);\n"
"__global int  *src1_y = (__global int *)((__global uchar *)mat_src1 + y * src1_step);\n"
"__global int2  *dst_y  = (__global int2 *)((__global uchar *)mat_dst  + y * dst_step);\n"
"int value1 = src0_y[x];\n"
"int value2 = src1_y[x];\n"
"int2 value;\n"
"value.even = value1;\n"
"value.odd = value2;\n"
"dst_y[x] = value;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C2_D5_1(int rows, int cols,\n"
"__global float *mat_dst,  int dst_step,\n"
"__global float *mat_src0, int src0_step,\n"
"__global float *mat_src1, int src1_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global float  *src0_y = (__global float *)((__global uchar *)mat_src0 + y * src0_step);\n"
"__global float  *src1_y = (__global float *)((__global uchar *)mat_src1 + y * src1_step);\n"
"__global float2  *dst_y  = (__global float2 *)((__global uchar *)mat_dst  + y * dst_step);\n"
"float value1 = src0_y[x];\n"
"float value2 = src1_y[x];\n"
"dst_y[x] = (float2)(value1, value2);\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void merge_vector_C2_D6_1(int rows, int cols,\n"
"__global double *mat_dst,  int dst_step,\n"
"__global double *mat_src0, int src0_step,\n"
"__global double *mat_src1, int src1_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global double  *src0_y = (__global double *)((__global uchar *)mat_src0 + y * src0_step);\n"
"__global double  *src1_y = (__global double *)((__global uchar *)mat_src1 + y * src1_step);\n"
"__global double2 *dst_y  = (__global double2 *)((__global uchar *)mat_dst  + y * dst_step);\n"
"double value1 = src0_y[x];\n"
"double value2 = src1_y[x];\n"
"dst_y[x] = (double2)(value1, value2);\n"
"}\n"
"}\n"
"#endif\n"
"__kernel void merge_vector_C3_D0_1(int rows, int cols,\n"
"__global uchar *mat_dst,  int dst_step,\n"
"__global uchar *mat_src0, int src0_step,\n"
"__global uchar *mat_src1, int src1_step,\n"
"__global uchar *mat_src2, int src2_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global uchar4  *src0_y = (__global uchar4 * )(mat_src0 + y * src0_step);\n"
"__global uchar4  *src1_y = (__global uchar4 * )(mat_src1 + y * src1_step);\n"
"__global uchar4  *src2_y = (__global uchar4 * )(mat_src2 + y * src0_step);\n"
"__global uchar4 *dst_y  = (__global uchar4 *)(mat_dst  + y * dst_step);\n"
"uchar4 value0 = src0_y[x];\n"
"uchar4 value1 = src1_y[x];\n"
"uchar4 value2 = src2_y[x];\n"
"dst_y[3 * x + 0] = (uchar4)(value0.s0, value1.s0, value2.s0,\n"
"value0.s1);\n"
"dst_y[3 * x + 1] = (uchar4)(value1.s1, value2.s1,\n"
"value0.s2, value1.s2);\n"
"dst_y[3 * x + 2] = (uchar4)(value2.s2,\n"
"value0.s3, value1.s3, value2.s3);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D1_1(int rows, int cols,\n"
"__global char *mat_dst,  int dst_step,\n"
"__global char *mat_src0, int src0_step,\n"
"__global char *mat_src1, int src1_step,\n"
"__global char *mat_src2, int src2_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global char4  *src0_y = (__global char4 * )(mat_src0 + y * src0_step);\n"
"__global char4  *src1_y = (__global char4 * )(mat_src1 + y * src1_step);\n"
"__global char4  *src2_y = (__global char4 * )(mat_src2 + y * src0_step);\n"
"__global char4 *dst_y  = (__global char4 *)(mat_dst  + y * dst_step);\n"
"char4 value0 = src0_y[x];\n"
"char4 value1 = src1_y[x];\n"
"char4 value2 = src2_y[x];\n"
"dst_y[3 * x + 0] = (char4)(value0.s0, value1.s0, value2.s0,\n"
"value0.s1);\n"
"dst_y[3 * x + 1] = (char4)(value1.s1, value2.s1,\n"
"value0.s2, value1.s2);\n"
"dst_y[3 * x + 2] = (char4)(value2.s2,\n"
"value0.s3, value1.s3, value2.s3);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D2_1(int rows, int cols,\n"
"__global ushort *mat_dst,  int dst_step,\n"
"__global ushort *mat_src0, int src0_step,\n"
"__global ushort *mat_src1, int src1_step,\n"
"__global ushort *mat_src2, int src2_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global ushort2  *src0_y = (__global ushort2 * )((__global char *)mat_src0 + y * src0_step);\n"
"__global ushort2  *src1_y = (__global ushort2 * )((__global char *)mat_src1 + y * src1_step);\n"
"__global ushort2  *src2_y = (__global ushort2 * )((__global char *)mat_src2 + y * src0_step);\n"
"__global ushort2 *dst_y  = (__global ushort2 *)((__global char *)mat_dst  + y * dst_step);\n"
"ushort2 value0 = src0_y[x];\n"
"ushort2 value1 = src1_y[x];\n"
"ushort2 value2 = src2_y[x];\n"
"dst_y[3 * x + 0] = (ushort2)(value0.x, value1.x);\n"
"dst_y[3 * x + 1] = (ushort2)(value2.x, value0.y);\n"
"dst_y[3 * x + 2] = (ushort2)(value1.y, value2.y);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D3_1(int rows, int cols,\n"
"__global short *mat_dst,  int dst_step,\n"
"__global short *mat_src0, int src0_step,\n"
"__global short *mat_src1, int src1_step,\n"
"__global short *mat_src2, int src2_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global short2  *src0_y = (__global short2 * )((__global char *)mat_src0 + y * src0_step);\n"
"__global short2  *src1_y = (__global short2 * )((__global char *)mat_src1 + y * src1_step);\n"
"__global short2  *src2_y = (__global short2 * )((__global char *)mat_src2 + y * src0_step);\n"
"__global short2 *dst_y  = (__global short2 *)((__global char *)mat_dst  + y * dst_step);\n"
"short2 value0 = src0_y[x];\n"
"short2 value1 = src1_y[x];\n"
"short2 value2 = src2_y[x];\n"
"dst_y[3 * x + 0] = (short2)(value0.x, value1.x);\n"
"dst_y[3 * x + 1] = (short2)(value2.x, value0.y);\n"
"dst_y[3 * x + 2] = (short2)(value1.y, value2.y);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D4_1(int rows, int cols,\n"
"__global int *mat_dst,  int dst_step,\n"
"__global int *mat_src0, int src0_step,\n"
"__global int *mat_src1, int src1_step,\n"
"__global int *mat_src2, int src2_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global int  *src0_y = (__global int * )((__global char *)mat_src0 + y * src0_step);\n"
"__global int  *src1_y = (__global int * )((__global char *)mat_src1 + y * src1_step);\n"
"__global int  *src2_y = (__global int * )((__global char *)mat_src2 + y * src0_step);\n"
"__global int *dst_y  = (__global int *)((__global char *)mat_dst  + y * dst_step);\n"
"int value0 = src0_y[x];\n"
"int value1 = src1_y[x];\n"
"int value2 = src2_y[x];\n"
"dst_y[3 * x + 0] = value0;\n"
"dst_y[3 * x + 1] = value1;\n"
"dst_y[3 * x + 2] = value2;\n"
"}\n"
"}\n"
"__kernel void merge_vector_C3_D5_1(int rows, int cols,\n"
"__global float *mat_dst,  int dst_step,\n"
"__global float *mat_src0, int src0_step,\n"
"__global float *mat_src1, int src1_step,\n"
"__global float *mat_src2, int src2_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global float  *src0_y = (__global float * )((__global char *)mat_src0 + y * src0_step);\n"
"__global float  *src1_y = (__global float * )((__global char *)mat_src1 + y * src1_step);\n"
"__global float  *src2_y = (__global float * )((__global char *)mat_src2 + y * src0_step);\n"
"__global float *dst_y  = (__global float *)((__global char *)mat_dst  + y * dst_step);\n"
"float value0 = src0_y[x];\n"
"float value1 = src1_y[x];\n"
"float value2 = src2_y[x];\n"
"dst_y[3 * x + 0] = value0;\n"
"dst_y[3 * x + 1] = value1;\n"
"dst_y[3 * x + 2] = value2;\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void merge_vector_C3_D6_1(int rows, int cols,\n"
"__global double *mat_dst,  int dst_step,\n"
"__global double *mat_src0, int src0_step,\n"
"__global double *mat_src1, int src1_step,\n"
"__global double *mat_src2, int src2_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global double  *src0_y = (__global double * )((__global char *)mat_src0 + y * src0_step);\n"
"__global double  *src1_y = (__global double * )((__global char *)mat_src1 + y * src1_step);\n"
"__global double  *src2_y = (__global double * )((__global char *)mat_src2 + y * src0_step);\n"
"__global double *dst_y  = (__global double *)((__global char *)mat_dst  + y * dst_step);\n"
"double value0 = src0_y[x];\n"
"double value1 = src1_y[x];\n"
"double value2 = src2_y[x];\n"
"dst_y[3 * x + 0] = value0;\n"
"dst_y[3 * x + 1] = value1;\n"
"dst_y[3 * x + 2] = value2;\n"
"}\n"
"}\n"
"#endif\n"
"__kernel void merge_vector_C4_D0_1(int rows, int cols,\n"
"__global uchar *mat_dst,  int dst_step,\n"
"__global uchar *mat_src0, int src0_step,\n"
"__global uchar *mat_src1, int src1_step,\n"
"__global uchar *mat_src2, int src2_step,\n"
"__global uchar *mat_src3, int src3_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global uchar4  *src0_y = (__global uchar4 * )(mat_src0 + y * src0_step);\n"
"__global uchar4  *src1_y = (__global uchar4 * )(mat_src1 + y * src1_step);\n"
"__global uchar4  *src2_y = (__global uchar4 * )(mat_src2 + y * src0_step);\n"
"__global uchar4  *src3_y = (__global uchar4 * )(mat_src3 + y * src1_step);\n"
"__global uchar16 *dst_y  = (__global uchar16 *)(mat_dst  + y * dst_step);\n"
"uchar4 value0 = src0_y[x];\n"
"uchar4 value1 = src1_y[x];\n"
"uchar4 value2 = src2_y[x];\n"
"uchar4 value3 = src3_y[x];\n"
"dst_y[x] = (uchar16)(value0.x, value1.x, value2.x, value3.x,\n"
"value0.y, value1.y, value2.y, value3.y,\n"
"value0.z, value1.z, value2.z, value3.z,\n"
"value0.w, value1.w, value2.w, value3.w);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D1_1(int rows, int cols,\n"
"__global char *mat_dst,  int dst_step,\n"
"__global char *mat_src0, int src0_step,\n"
"__global char *mat_src1, int src1_step,\n"
"__global char *mat_src2, int src2_step,\n"
"__global char *mat_src3, int src3_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global char4  *src0_y = (__global char4 * )(mat_src0 + y * src0_step);\n"
"__global char4  *src1_y = (__global char4 * )(mat_src1 + y * src1_step);\n"
"__global char4  *src2_y = (__global char4 * )(mat_src2 + y * src0_step);\n"
"__global char4  *src3_y = (__global char4 * )(mat_src3 + y * src1_step);\n"
"__global char16 *dst_y  = (__global char16 *)(mat_dst  + y * dst_step);\n"
"char4 value0 = src0_y[x];\n"
"char4 value1 = src1_y[x];\n"
"char4 value2 = src2_y[x];\n"
"char4 value3 = src3_y[x];\n"
"dst_y[x] = (char16)(value0.x, value1.x, value2.x, value3.x,\n"
"value0.y, value1.y, value2.y, value3.y,\n"
"value0.z, value1.z, value2.z, value3.z,\n"
"value0.w, value1.w, value2.w, value3.w);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D2_1(int rows, int cols,\n"
"__global ushort *mat_dst,  int dst_step,\n"
"__global ushort *mat_src0, int src0_step,\n"
"__global ushort *mat_src1, int src1_step,\n"
"__global ushort *mat_src2, int src2_step,\n"
"__global ushort *mat_src3, int src3_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global ushort2  *src0_y = (__global ushort2 * )((__global uchar*)mat_src0 + y * src0_step);\n"
"__global ushort2  *src1_y = (__global ushort2 * )((__global uchar*)mat_src1 + y * src1_step);\n"
"__global ushort2  *src2_y = (__global ushort2 * )((__global uchar*)mat_src2 + y * src0_step);\n"
"__global ushort2  *src3_y = (__global ushort2 * )((__global uchar*)mat_src3 + y * src1_step);\n"
"__global ushort8 *dst_y  = (__global ushort8 *)((__global uchar*)mat_dst  + y * dst_step);\n"
"ushort2 value0 = src0_y[x];\n"
"ushort2 value1 = src1_y[x];\n"
"ushort2 value2 = src2_y[x];\n"
"ushort2 value3 = src3_y[x];\n"
"dst_y[x] = (ushort8)(value0.x, value1.x, value2.x, value3.x,\n"
"value0.y, value1.y, value2.y, value3.y);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D3_1(int rows, int cols,\n"
"__global short *mat_dst,  int dst_step,\n"
"__global short *mat_src0, int src0_step,\n"
"__global short *mat_src1, int src1_step,\n"
"__global short *mat_src2, int src2_step,\n"
"__global short *mat_src3, int src3_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global short2  *src0_y = (__global short2 * )((__global uchar*)mat_src0 + y * src0_step);\n"
"__global short2  *src1_y = (__global short2 * )((__global uchar*)mat_src1 + y * src1_step);\n"
"__global short2  *src2_y = (__global short2 * )((__global uchar*)mat_src2 + y * src0_step);\n"
"__global short2  *src3_y = (__global short2 * )((__global uchar*)mat_src3 + y * src1_step);\n"
"__global short8 *dst_y  = (__global short8 *)((__global uchar*)mat_dst  + y * dst_step);\n"
"short2 value0 = src0_y[x];\n"
"short2 value1 = src1_y[x];\n"
"short2 value2 = src2_y[x];\n"
"short2 value3 = src3_y[x];\n"
"dst_y[x] = (short8)(value0.x, value1.x, value2.x, value3.x,\n"
"value0.y, value1.y, value2.y, value3.y);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D4_1(int rows, int cols,\n"
"__global int *mat_dst,  int dst_step,\n"
"__global int *mat_src0, int src0_step,\n"
"__global int *mat_src1, int src1_step,\n"
"__global int *mat_src2, int src2_step,\n"
"__global int *mat_src3, int src3_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global int *src0_y = (__global int * )((__global uchar*)mat_src0 + y * src0_step);\n"
"__global int *src1_y = (__global int * )((__global uchar*)mat_src1 + y * src1_step);\n"
"__global int *src2_y = (__global int * )((__global uchar*)mat_src2 + y * src0_step);\n"
"__global int *src3_y = (__global int * )((__global uchar*)mat_src3 + y * src1_step);\n"
"__global int4 *dst_y  = (__global int4 *)((__global uchar*)mat_dst  + y * dst_step);\n"
"int value0 = src0_y[x];\n"
"int value1 = src1_y[x];\n"
"int value2 = src2_y[x];\n"
"int value3 = src3_y[x];\n"
"dst_y[x] = (int4)(value0, value1, value2, value3);\n"
"}\n"
"}\n"
"__kernel void merge_vector_C4_D5_1(int rows, int cols,\n"
"__global float *mat_dst,  int dst_step,\n"
"__global float *mat_src0, int src0_step,\n"
"__global float *mat_src1, int src1_step,\n"
"__global float *mat_src2, int src2_step,\n"
"__global float *mat_src3, int src3_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global float *src0_y = (__global float * )((__global uchar*)mat_src0 + y * src0_step);\n"
"__global float *src1_y = (__global float * )((__global uchar*)mat_src1 + y * src1_step);\n"
"__global float *src2_y = (__global float * )((__global uchar*)mat_src2 + y * src0_step);\n"
"__global float *src3_y = (__global float * )((__global uchar*)mat_src3 + y * src1_step);\n"
"__global float4 *dst_y  = (__global float4 *)((__global uchar*)mat_dst  + y * dst_step);\n"
"float value0 = src0_y[x];\n"
"float value1 = src1_y[x];\n"
"float value2 = src2_y[x];\n"
"float value3 = src3_y[x];\n"
"dst_y[x] = (float4)(value0, value1, value2, value3);\n"
"}\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"__kernel void merge_vector_C4_D6_1(int rows, int cols,\n"
"__global double *mat_dst,  int dst_step,\n"
"__global double *mat_src0, int src0_step,\n"
"__global double *mat_src1, int src1_step,\n"
"__global double *mat_src2, int src2_step,\n"
"__global double *mat_src3, int src3_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ((x < cols) && (y < rows))\n"
"{\n"
"__global double *src0_y = (__global double * )((__global uchar*)mat_src0 + y * src0_step);\n"
"__global double *src1_y = (__global double * )((__global uchar*)mat_src1 + y * src1_step);\n"
"__global double *src2_y = (__global double * )((__global uchar*)mat_src2 + y * src0_step);\n"
"__global double *src3_y = (__global double * )((__global uchar*)mat_src3 + y * src1_step);\n"
"__global double4 *dst_y  = (__global double4 *)((__global uchar*)mat_dst  + y * dst_step);\n"
"double value0 = src0_y[x];\n"
"double value1 = src1_y[x];\n"
"double value2 = src2_y[x];\n"
"double value3 = src3_y[x];\n"
"dst_y[x] = (double4)(value0, value1, value2, value3);\n"
"}\n"
"}\n"
"#endif\n"
, "131c0e27e47b2163871bfd35ae8f659b"};
const struct ProgramEntry moments={"moments",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"typedef double T;\n"
"#else\n"
"typedef long T;\n"
"#endif\n"
"#define DST_ROW_00     0\n"
"#define DST_ROW_10     1\n"
"#define DST_ROW_01     2\n"
"#define DST_ROW_20     3\n"
"#define DST_ROW_11     4\n"
"#define DST_ROW_02     5\n"
"#define DST_ROW_30     6\n"
"#define DST_ROW_21     7\n"
"#define DST_ROW_12     8\n"
"#define DST_ROW_03     9\n"
"__kernel void icvContourMoments(int contour_total,\n"
"__global float* reader_oclmat_data,\n"
"__global T* dst_a,\n"
"int dst_step)\n"
"{\n"
"T xi_1, yi_1, xi_12, yi_12, xi, yi, xi2, yi2, dxy, xii_1, yii_1;\n"
"int idx = get_global_id(0);\n"
"if (idx < 0 || idx >= contour_total)\n"
"return;\n"
"xi_1 = (T)(*(reader_oclmat_data + (get_global_id(0) << 1)));\n"
"yi_1 = (T)(*(reader_oclmat_data + (get_global_id(0) << 1) + 1));\n"
"xi_12 = xi_1 * xi_1;\n"
"yi_12 = yi_1 * yi_1;\n"
"if(idx == contour_total - 1)\n"
"{\n"
"xi = (T)(*(reader_oclmat_data));\n"
"yi = (T)(*(reader_oclmat_data + 1));\n"
"}\n"
"else\n"
"{\n"
"xi = (T)(*(reader_oclmat_data + (idx + 1) * 2));\n"
"yi = (T)(*(reader_oclmat_data + (idx + 1) * 2 + 1));\n"
"}\n"
"xi2 = xi * xi;\n"
"yi2 = yi * yi;\n"
"dxy = xi_1 * yi - xi * yi_1;\n"
"xii_1 = xi_1 + xi;\n"
"yii_1 = yi_1 + yi;\n"
"dst_step /= sizeof(T);\n"
"*( dst_a + DST_ROW_00 * dst_step + idx) = dxy;\n"
"*( dst_a + DST_ROW_10 * dst_step + idx) = dxy * xii_1;\n"
"*( dst_a + DST_ROW_01 * dst_step + idx) = dxy * yii_1;\n"
"*( dst_a + DST_ROW_20 * dst_step + idx) = dxy * (xi_1 * xii_1 + xi2);\n"
"*( dst_a + DST_ROW_11 * dst_step + idx) = dxy * (xi_1 * (yii_1 + yi_1) + xi * (yii_1 + yi));\n"
"*( dst_a + DST_ROW_02 * dst_step + idx) = dxy * (yi_1 * yii_1 + yi2);\n"
"*( dst_a + DST_ROW_30 * dst_step + idx) = dxy * xii_1 * (xi_12 + xi2);\n"
"*( dst_a + DST_ROW_03 * dst_step + idx) = dxy * yii_1 * (yi_12 + yi2);\n"
"*( dst_a + DST_ROW_21 * dst_step + idx) =\n"
"dxy * (xi_12 * (3 * yi_1 + yi) + 2 * xi * xi_1 * yii_1 +\n"
"xi2 * (yi_1 + 3 * yi));\n"
"*( dst_a + DST_ROW_12 * dst_step + idx) =\n"
"dxy * (yi_12 * (3 * xi_1 + xi) + 2 * yi * yi_1 * xii_1 +\n"
"yi2 * (xi_1 + 3 * xi));\n"
"}\n"
"#if defined (DOUBLE_SUPPORT)\n"
"#define WT double\n"
"#define WT4 double4\n"
"#define convert_T4 convert_double4\n"
"#define convert_T convert_double\n"
"#else\n"
"#define WT float\n"
"#define WT4 float4\n"
"#define convert_T4 convert_float4\n"
"#define convert_T convert_float\n"
"#endif\n"
"#ifdef CV_8UC1\n"
"#define TT uchar\n"
"#elif defined CV_16UC1\n"
"#define TT ushort\n"
"#elif defined CV_16SC1\n"
"#define TT short\n"
"#elif defined CV_32FC1\n"
"#define TT float\n"
"#elif defined CV_64FC1\n"
"#ifdef DOUBLE_SUPPORT\n"
"#define TT double\n"
"#else\n"
"#define TT float\n"
"#endif\n"
"#endif\n"
"__kernel void CvMoments(__global TT* src_data, int src_rows, int src_cols, int src_step,\n"
"__global WT* dst_m,\n"
"int dst_cols, int dst_step, int binary)\n"
"{\n"
"int dy = get_global_id(1);\n"
"int ly = get_local_id(1);\n"
"int gidx = get_group_id(0);\n"
"int gidy = get_group_id(1);\n"
"int x_rest = src_cols % 256;\n"
"int y_rest = src_rows % 256;\n"
"__local int codxy[256];\n"
"codxy[ly] = ly;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"WT4 x0 = (WT4)(0.f);\n"
"WT4 x1 = (WT4)(0.f);\n"
"WT4 x2 = (WT4)(0.f);\n"
"WT4 x3 = (WT4)(0.f);\n"
"__global TT* row = src_data + gidy * src_step + ly * src_step + gidx * 256;\n"
"WT4 p;\n"
"WT4 x;\n"
"WT4 xp;\n"
"WT4 xxp;\n"
"WT py = 0.f, sy = 0.f;\n"
"if(dy < src_rows)\n"
"{\n"
"if((x_rest > 0) && (gidx == ((int)get_num_groups(0) - 1)))\n"
"{\n"
"int i;\n"
"for(i = 0; i < x_rest - 4; i += 4)\n"
"{\n"
"p = convert_T4(vload4(0, row + i));\n"
"x = convert_T4(vload4(0, codxy + i));\n"
"xp = x * p;\n"
"xxp = xp * x;\n"
"x0 += p;\n"
"x1 += xp;\n"
"x2 += xxp;\n"
"x3 += convert_T4(xxp * x);\n"
"}\n"
"x0.s0 = x0.s0 + x0.s1 + x0.s2 + x0.s3;\n"
"x1.s0 = x1.s0 + x1.s1 + x1.s2 + x1.s3;\n"
"x2.s0 = x2.s0 + x2.s1 + x2.s2 + x2.s3;\n"
"x3.s0 = x3.s0 + x3.s1 + x3.s2 + x3.s3;\n"
"WT x0_ = 0;\n"
"WT x1_ = 0;\n"
"WT x2_ = 0;\n"
"WT x3_ = 0;\n"
"for(; i < x_rest; i++)\n"
"{\n"
"WT p_ = 0;\n"
"p_ = row[i];\n"
"WT x_ = convert_T(codxy[i]);\n"
"WT xp_ = x_ * p_;\n"
"WT xxp_ = xp_ * x_;\n"
"x0_ += p_;\n"
"x1_ += xp_;\n"
"x2_ += xxp_;\n"
"x3_ += xxp_ * x_;\n"
"}\n"
"x0.s0 += x0_;\n"
"x1.s0 += x1_;\n"
"x2.s0 += x2_;\n"
"x3.s0 += x3_;\n"
"}else\n"
"{\n"
"for(int i = 0; i < 256; i += 4)\n"
"{\n"
"p = convert_T4(vload4(0, row + i));\n"
"x = convert_T4(vload4(0, codxy + i));\n"
"xp = x * p;\n"
"xxp = xp * x;\n"
"x0 += p;\n"
"x1 += xp;\n"
"x2 += xxp;\n"
"x3 += convert_T4(xxp * x);\n"
"}\n"
"x0.s0 = x0.s0 + x0.s1 + x0.s2 + x0.s3;\n"
"x1.s0 = x1.s0 + x1.s1 + x1.s2 + x1.s3;\n"
"x2.s0 = x2.s0 + x2.s1 + x2.s2 + x2.s3;\n"
"x3.s0 = x3.s0 + x3.s1 + x3.s2 + x3.s3;\n"
"}\n"
"py = ly * x0.s0;\n"
"sy = ly * ly;\n"
"}\n"
"__local WT mom[10][256];\n"
"if((y_rest > 0) && (gidy == ((int)get_num_groups(1) - 1)))\n"
"{\n"
"if(ly < y_rest)\n"
"{\n"
"mom[9][ly] = py * sy;\n"
"mom[8][ly] = x1.s0 * sy;\n"
"mom[7][ly] = x2.s0 * ly;\n"
"mom[6][ly] = x3.s0;\n"
"mom[5][ly] = x0.s0 * sy;\n"
"mom[4][ly] = x1.s0 * ly;\n"
"mom[3][ly] = x2.s0;\n"
"mom[2][ly] = py;\n"
"mom[1][ly] = x1.s0;\n"
"mom[0][ly] = x0.s0;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 10)\n"
"for(int i = 1; i < y_rest; i++)\n"
"mom[ly][0] = mom[ly][i] + mom[ly][0];\n"
"}\n"
"else\n"
"{\n"
"mom[9][ly] = py * sy;\n"
"mom[8][ly] = x1.s0 * sy;\n"
"mom[7][ly] = x2.s0 * ly;\n"
"mom[6][ly] = x3.s0;\n"
"mom[5][ly] = x0.s0 * sy;\n"
"mom[4][ly] = x1.s0 * ly;\n"
"mom[3][ly] = x2.s0;\n"
"mom[2][ly] = py;\n"
"mom[1][ly] = x1.s0;\n"
"mom[0][ly] = x0.s0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 128)\n"
"{\n"
"mom[0][ly] = mom[0][ly] + mom[0][ly + 128];\n"
"mom[1][ly] = mom[1][ly] + mom[1][ly + 128];\n"
"mom[2][ly] = mom[2][ly] + mom[2][ly + 128];\n"
"mom[3][ly] = mom[3][ly] + mom[3][ly + 128];\n"
"mom[4][ly] = mom[4][ly] + mom[4][ly + 128];\n"
"mom[5][ly] = mom[5][ly] + mom[5][ly + 128];\n"
"mom[6][ly] = mom[6][ly] + mom[6][ly + 128];\n"
"mom[7][ly] = mom[7][ly] + mom[7][ly + 128];\n"
"mom[8][ly] = mom[8][ly] + mom[8][ly + 128];\n"
"mom[9][ly] = mom[9][ly] + mom[9][ly + 128];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 64)\n"
"{\n"
"mom[0][ly] = mom[0][ly] + mom[0][ly + 64];\n"
"mom[1][ly] = mom[1][ly] + mom[1][ly + 64];\n"
"mom[2][ly] = mom[2][ly] + mom[2][ly + 64];\n"
"mom[3][ly] = mom[3][ly] + mom[3][ly + 64];\n"
"mom[4][ly] = mom[4][ly] + mom[4][ly + 64];\n"
"mom[5][ly] = mom[5][ly] + mom[5][ly + 64];\n"
"mom[6][ly] = mom[6][ly] + mom[6][ly + 64];\n"
"mom[7][ly] = mom[7][ly] + mom[7][ly + 64];\n"
"mom[8][ly] = mom[8][ly] + mom[8][ly + 64];\n"
"mom[9][ly] = mom[9][ly] + mom[9][ly + 64];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 32)\n"
"{\n"
"mom[0][ly] = mom[0][ly] + mom[0][ly + 32];\n"
"mom[1][ly] = mom[1][ly] + mom[1][ly + 32];\n"
"mom[2][ly] = mom[2][ly] + mom[2][ly + 32];\n"
"mom[3][ly] = mom[3][ly] + mom[3][ly + 32];\n"
"mom[4][ly] = mom[4][ly] + mom[4][ly + 32];\n"
"mom[5][ly] = mom[5][ly] + mom[5][ly + 32];\n"
"mom[6][ly] = mom[6][ly] + mom[6][ly + 32];\n"
"mom[7][ly] = mom[7][ly] + mom[7][ly + 32];\n"
"mom[8][ly] = mom[8][ly] + mom[8][ly + 32];\n"
"mom[9][ly] = mom[9][ly] + mom[9][ly + 32];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 16)\n"
"{\n"
"mom[0][ly] = mom[0][ly] + mom[0][ly + 16];\n"
"mom[1][ly] = mom[1][ly] + mom[1][ly + 16];\n"
"mom[2][ly] = mom[2][ly] + mom[2][ly + 16];\n"
"mom[3][ly] = mom[3][ly] + mom[3][ly + 16];\n"
"mom[4][ly] = mom[4][ly] + mom[4][ly + 16];\n"
"mom[5][ly] = mom[5][ly] + mom[5][ly + 16];\n"
"mom[6][ly] = mom[6][ly] + mom[6][ly + 16];\n"
"mom[7][ly] = mom[7][ly] + mom[7][ly + 16];\n"
"mom[8][ly] = mom[8][ly] + mom[8][ly + 16];\n"
"mom[9][ly] = mom[9][ly] + mom[9][ly + 16];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 8)\n"
"{\n"
"mom[0][ly] = mom[0][ly] + mom[0][ly + 8];\n"
"mom[1][ly] = mom[1][ly] + mom[1][ly + 8];\n"
"mom[2][ly] = mom[2][ly] + mom[2][ly + 8];\n"
"mom[3][ly] = mom[3][ly] + mom[3][ly + 8];\n"
"mom[4][ly] = mom[4][ly] + mom[4][ly + 8];\n"
"mom[5][ly] = mom[5][ly] + mom[5][ly + 8];\n"
"mom[6][ly] = mom[6][ly] + mom[6][ly + 8];\n"
"mom[7][ly] = mom[7][ly] + mom[7][ly + 8];\n"
"mom[8][ly] = mom[8][ly] + mom[8][ly + 8];\n"
"mom[9][ly] = mom[9][ly] + mom[9][ly + 8];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 4)\n"
"{\n"
"mom[0][ly] = mom[0][ly] + mom[0][ly + 4];\n"
"mom[1][ly] = mom[1][ly] + mom[1][ly + 4];\n"
"mom[2][ly] = mom[2][ly] + mom[2][ly + 4];\n"
"mom[3][ly] = mom[3][ly] + mom[3][ly + 4];\n"
"mom[4][ly] = mom[4][ly] + mom[4][ly + 4];\n"
"mom[5][ly] = mom[5][ly] + mom[5][ly + 4];\n"
"mom[6][ly] = mom[6][ly] + mom[6][ly + 4];\n"
"mom[7][ly] = mom[7][ly] + mom[7][ly + 4];\n"
"mom[8][ly] = mom[8][ly] + mom[8][ly + 4];\n"
"mom[9][ly] = mom[9][ly] + mom[9][ly + 4];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 2)\n"
"{\n"
"mom[0][ly] = mom[0][ly] + mom[0][ly + 2];\n"
"mom[1][ly] = mom[1][ly] + mom[1][ly + 2];\n"
"mom[2][ly] = mom[2][ly] + mom[2][ly + 2];\n"
"mom[3][ly] = mom[3][ly] + mom[3][ly + 2];\n"
"mom[4][ly] = mom[4][ly] + mom[4][ly + 2];\n"
"mom[5][ly] = mom[5][ly] + mom[5][ly + 2];\n"
"mom[6][ly] = mom[6][ly] + mom[6][ly + 2];\n"
"mom[7][ly] = mom[7][ly] + mom[7][ly + 2];\n"
"mom[8][ly] = mom[8][ly] + mom[8][ly + 2];\n"
"mom[9][ly] = mom[9][ly] + mom[9][ly + 2];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 1)\n"
"{\n"
"mom[0][ly] = mom[0][ly] + mom[0][ly + 1];\n"
"mom[1][ly] = mom[1][ly] + mom[1][ly + 1];\n"
"mom[2][ly] = mom[2][ly] + mom[2][ly + 1];\n"
"mom[3][ly] = mom[3][ly] + mom[3][ly + 1];\n"
"mom[4][ly] = mom[4][ly] + mom[4][ly + 1];\n"
"mom[5][ly] = mom[5][ly] + mom[5][ly + 1];\n"
"mom[6][ly] = mom[6][ly] + mom[6][ly + 1];\n"
"mom[7][ly] = mom[7][ly] + mom[7][ly + 1];\n"
"mom[8][ly] = mom[8][ly] + mom[8][ly + 1];\n"
"mom[9][ly] = mom[9][ly] + mom[9][ly + 1];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(binary)\n"
"{\n"
"WT s = 1.0f/255;\n"
"if(ly < 10)\n"
"mom[ly][0] *= s;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"WT xm = (gidx * 256) * mom[0][0];\n"
"WT ym = (gidy * 256) * mom[0][0];\n"
"if(ly == 0)\n"
"{\n"
"mom[0][1] = mom[0][0];\n"
"mom[1][1] = mom[1][0] + xm;\n"
"mom[2][1] = mom[2][0] + ym;\n"
"mom[3][1] = mom[3][0] + gidx * 256 * (mom[1][0] * 2 + xm);\n"
"mom[4][1] = mom[4][0] + gidx * 256 * (mom[2][0] + ym) + gidy * 256 * mom[1][0];\n"
"mom[5][1] = mom[5][0] + gidy * 256 * (mom[2][0] * 2 + ym);\n"
"mom[6][1] = mom[6][0] + gidx * 256 * (3 * mom[3][0] + 256 * gidx * (3 * mom[1][0] + xm));\n"
"mom[7][1] = mom[7][0] + gidx * 256 * (2 * (mom[4][0] + 256 * gidy * mom[1][0]) + 256 * gidx * (mom[2][0] + ym)) + 256 * gidy * mom[3][0];\n"
"mom[8][1] = mom[8][0] + gidy * 256 * (2 * (mom[4][0] + 256 * gidx * mom[2][0]) + 256 * gidy * (mom[1][0] + xm)) + 256 * gidx * mom[5][0];\n"
"mom[9][1] = mom[9][0] + gidy * 256 * (3 * mom[5][0] + 256 * gidy * (3 * mom[2][0] + ym));\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(ly < 10)\n"
"dst_m[10 * gidy * dst_step + ly * dst_step + gidx] = mom[ly][1];\n"
"}\n"
, "9145a57effb2e86f802a70722027b627"};
const struct ProgramEntry objdetect_hog={"objdetect_hog",
"#define CELL_WIDTH 8\n"
"#define CELL_HEIGHT 8\n"
"#define CELLS_PER_BLOCK_X 2\n"
"#define CELLS_PER_BLOCK_Y 2\n"
"#define NTHREADS 256\n"
"#define CV_PI_F 3.1415926535897932384626433832795f\n"
"#ifdef INTEL_DEVICE\n"
"#define QANGLE_TYPE    int\n"
"#define QANGLE_TYPE2  int2\n"
"#else\n"
"#define QANGLE_TYPE    uchar\n"
"#define QANGLE_TYPE2  uchar2\n"
"#endif\n"
"__kernel void compute_hists_lut_kernel(\n"
"const int cblock_stride_x, const int cblock_stride_y,\n"
"const int cnbins, const int cblock_hist_size, const int img_block_width,\n"
"const int blocks_in_group, const int blocks_total,\n"
"const int grad_quadstep, const int qangle_step,\n"
"__global const float* grad, __global const QANGLE_TYPE* qangle,\n"
"__global const float* gauss_w_lut,\n"
"__global float* block_hists, __local float* smem)\n"
"{\n"
"const int lx = get_local_id(0);\n"
"const int lp = lx / 24; \n"
"const int gid = get_group_id(0) * blocks_in_group + lp;\n"
"const int gidY = gid / img_block_width;\n"
"const int gidX = gid - gidY * img_block_width;\n"
"const int lidX = lx - lp * 24;\n"
"const int lidY = get_local_id(1);\n"
"const int cell_x = lidX / 12;\n"
"const int cell_y = lidY;\n"
"const int cell_thread_x = lidX - cell_x * 12;\n"
"__local float* hists = smem + lp * cnbins * (CELLS_PER_BLOCK_X *\n"
"CELLS_PER_BLOCK_Y * 12 + CELLS_PER_BLOCK_X * CELLS_PER_BLOCK_Y);\n"
"__local float* final_hist = hists + cnbins *\n"
"(CELLS_PER_BLOCK_X * CELLS_PER_BLOCK_Y * 12);\n"
"const int offset_x = gidX * cblock_stride_x + (cell_x << 2) + cell_thread_x;\n"
"const int offset_y = gidY * cblock_stride_y + (cell_y << 2);\n"
"__global const float* grad_ptr = (gid < blocks_total) ?\n"
"grad + offset_y * grad_quadstep + (offset_x << 1) : grad;\n"
"__global const QANGLE_TYPE* qangle_ptr = (gid < blocks_total) ?\n"
"qangle + offset_y * qangle_step + (offset_x << 1) : qangle;\n"
"__local float* hist = hists + 12 * (cell_y * CELLS_PER_BLOCK_Y + cell_x) +\n"
"cell_thread_x;\n"
"for (int bin_id = 0; bin_id < cnbins; ++bin_id)\n"
"hist[bin_id * 48] = 0.f;\n"
"const int dist_x = -4 + cell_thread_x - 4 * cell_x;\n"
"const int dist_center_x = dist_x - 4 * (1 - 2 * cell_x);\n"
"const int dist_y_begin = -4 - 4 * lidY;\n"
"for (int dist_y = dist_y_begin; dist_y < dist_y_begin + 12; ++dist_y)\n"
"{\n"
"float2 vote = (float2) (grad_ptr[0], grad_ptr[1]);\n"
"QANGLE_TYPE2 bin = (QANGLE_TYPE2) (qangle_ptr[0], qangle_ptr[1]);\n"
"grad_ptr += grad_quadstep;\n"
"qangle_ptr += qangle_step;\n"
"int dist_center_y = dist_y - 4 * (1 - 2 * cell_y);\n"
"int idx = (dist_center_y + 8) * 16 + (dist_center_x + 8);\n"
"float gaussian = gauss_w_lut[idx];\n"
"idx = (dist_y + 8) * 16 + (dist_x + 8);\n"
"float interp_weight = gauss_w_lut[256+idx];\n"
"hist[bin.x * 48] += gaussian * interp_weight * vote.x;\n"
"hist[bin.y * 48] += gaussian * interp_weight * vote.y;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"volatile __local float* hist_ = hist;\n"
"for (int bin_id = 0; bin_id < cnbins; ++bin_id, hist_ += 48)\n"
"{\n"
"if (cell_thread_x < 6)\n"
"hist_[0] += hist_[6];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (cell_thread_x < 3)\n"
"hist_[0] += hist_[3];\n"
"#ifdef CPU\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"#endif\n"
"if (cell_thread_x == 0)\n"
"final_hist[(cell_x * 2 + cell_y) * cnbins + bin_id] =\n"
"hist_[0] + hist_[1] + hist_[2];\n"
"}\n"
"#ifdef CPU\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"#endif\n"
"int tid = (cell_y * CELLS_PER_BLOCK_Y + cell_x) * 12 + cell_thread_x;\n"
"if ((tid < cblock_hist_size) && (gid < blocks_total))\n"
"{\n"
"__global float* block_hist = block_hists +\n"
"(gidY * img_block_width + gidX) * cblock_hist_size;\n"
"block_hist[tid] = final_hist[tid];\n"
"}\n"
"}\n"
"__kernel void normalize_hists_36_kernel(__global float* block_hists,\n"
"const float threshold, __local float *squares)\n"
"{\n"
"const int tid = get_local_id(0);\n"
"const int gid = get_global_id(0);\n"
"const int bid = tid / 36;      \n"
"const int boffset = bid * 36;  \n"
"const int hid = tid - boffset; \n"
"float elem = block_hists[gid];\n"
"squares[tid] = elem * elem;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"__local float* smem = squares + boffset;\n"
"float sum = smem[hid];\n"
"if (hid < 18)\n"
"smem[hid] = sum = sum + smem[hid + 18];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (hid < 9)\n"
"smem[hid] = sum = sum + smem[hid + 9];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (hid < 4)\n"
"smem[hid] = sum + smem[hid + 4];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum = smem[0] + smem[1] + smem[2] + smem[3] + smem[8];\n"
"elem = elem / (sqrt(sum) + 3.6f);\n"
"elem = min(elem, threshold);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"squares[tid] = elem * elem;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum = smem[hid];\n"
"if (hid < 18)\n"
"smem[hid] = sum = sum + smem[hid + 18];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (hid < 9)\n"
"smem[hid] = sum = sum + smem[hid + 9];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (hid < 4)\n"
"smem[hid] = sum + smem[hid + 4];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum = smem[0] + smem[1] + smem[2] + smem[3] + smem[8];\n"
"block_hists[gid] = elem / (sqrt(sum) + 1e-3f);\n"
"}\n"
"float reduce_smem(volatile __local float* smem, int size)\n"
"{\n"
"unsigned int tid = get_local_id(0);\n"
"float sum = smem[tid];\n"
"if (size >= 512) { if (tid < 256) smem[tid] = sum = sum + smem[tid + 256];\n"
"barrier(CLK_LOCAL_MEM_FENCE); }\n"
"if (size >= 256) { if (tid < 128) smem[tid] = sum = sum + smem[tid + 128];\n"
"barrier(CLK_LOCAL_MEM_FENCE); }\n"
"if (size >= 128) { if (tid < 64) smem[tid] = sum = sum + smem[tid + 64];\n"
"barrier(CLK_LOCAL_MEM_FENCE); }\n"
"#ifdef CPU\n"
"if (size >= 64) { if (tid < 32) smem[tid] = sum = sum + smem[tid + 32];\n"
"barrier(CLK_LOCAL_MEM_FENCE); }\n"
"if (size >= 32) { if (tid < 16) smem[tid] = sum = sum + smem[tid + 16];\n"
"barrier(CLK_LOCAL_MEM_FENCE); }\n"
"if (size >= 16) { if (tid < 8) smem[tid] = sum = sum + smem[tid + 8];\n"
"barrier(CLK_LOCAL_MEM_FENCE); }\n"
"if (size >= 8) { if (tid < 4) smem[tid] = sum = sum + smem[tid + 4];\n"
"barrier(CLK_LOCAL_MEM_FENCE); }\n"
"if (size >= 4) { if (tid < 2) smem[tid] = sum = sum + smem[tid + 2];\n"
"barrier(CLK_LOCAL_MEM_FENCE); }\n"
"if (size >= 2) { if (tid < 1) smem[tid] = sum = sum + smem[tid + 1];\n"
"barrier(CLK_LOCAL_MEM_FENCE); }\n"
"#else\n"
"if (tid < 32)\n"
"{\n"
"if (size >= 64) smem[tid] = sum = sum + smem[tid + 32];\n"
"#if WAVE_SIZE < 32\n"
"} barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 16) {\n"
"#endif\n"
"if (size >= 32) smem[tid] = sum = sum + smem[tid + 16];\n"
"if (size >= 16) smem[tid] = sum = sum + smem[tid + 8];\n"
"if (size >= 8) smem[tid] = sum = sum + smem[tid + 4];\n"
"if (size >= 4) smem[tid] = sum = sum + smem[tid + 2];\n"
"if (size >= 2) smem[tid] = sum = sum + smem[tid + 1];\n"
"}\n"
"#endif\n"
"return sum;\n"
"}\n"
"__kernel void normalize_hists_kernel(\n"
"const int nthreads, const int block_hist_size, const int img_block_width,\n"
"__global float* block_hists, const float threshold, __local float *squares)\n"
"{\n"
"const int tid = get_local_id(0);\n"
"const int gidX = get_group_id(0);\n"
"const int gidY = get_group_id(1);\n"
"__global float* hist = block_hists + (gidY * img_block_width + gidX) *\n"
"block_hist_size + tid;\n"
"float elem = 0.f;\n"
"if (tid < block_hist_size)\n"
"elem = hist[0];\n"
"squares[tid] = elem * elem;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"float sum = reduce_smem(squares, nthreads);\n"
"float scale = 1.0f / (sqrt(sum) + 0.1f * block_hist_size);\n"
"elem = min(elem * scale, threshold);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"squares[tid] = elem * elem;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum = reduce_smem(squares, nthreads);\n"
"scale = 1.0f / (sqrt(sum) + 1e-3f);\n"
"if (tid < block_hist_size)\n"
"hist[0] = elem * scale;\n"
"}\n"
"__kernel void classify_hists_180_kernel(\n"
"const int cdescr_width, const int cdescr_height, const int cblock_hist_size,\n"
"const int img_win_width, const int img_block_width,\n"
"const int win_block_stride_x, const int win_block_stride_y,\n"
"__global const float * block_hists, __global const float* coefs,\n"
"float free_coef, float threshold, __global uchar* labels)\n"
"{\n"
"const int tid = get_local_id(0);\n"
"const int gidX = get_group_id(0);\n"
"const int gidY = get_group_id(1);\n"
"__global const float* hist = block_hists + (gidY * win_block_stride_y *\n"
"img_block_width + gidX * win_block_stride_x) * cblock_hist_size;\n"
"float product = 0.f;\n"
"for (int i = 0; i < cdescr_height; i++)\n"
"{\n"
"product += coefs[i * cdescr_width + tid] *\n"
"hist[i * img_block_width * cblock_hist_size + tid];\n"
"}\n"
"__local float products[180];\n"
"products[tid] = product;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 90) products[tid] = product = product + products[tid + 90];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 45) products[tid] = product = product + products[tid + 45];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"volatile __local float* smem = products;\n"
"#ifdef CPU\n"
"if (tid < 13) smem[tid] = product = product + smem[tid + 32];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 16) smem[tid] = product = product + smem[tid + 16];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<8) smem[tid] = product = product + smem[tid + 8];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<4) smem[tid] = product = product + smem[tid + 4];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<2) smem[tid] = product = product + smem[tid + 2];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"#else\n"
"if (tid < 13)\n"
"{\n"
"smem[tid] = product = product + smem[tid + 32];\n"
"}\n"
"#if WAVE_SIZE < 32\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"#endif\n"
"if (tid < 16)\n"
"{\n"
"smem[tid] = product = product + smem[tid + 16];\n"
"smem[tid] = product = product + smem[tid + 8];\n"
"smem[tid] = product = product + smem[tid + 4];\n"
"smem[tid] = product = product + smem[tid + 2];\n"
"}\n"
"#endif\n"
"if (tid == 0){\n"
"product = product + smem[tid + 1];\n"
"labels[gidY * img_win_width + gidX] = (product + free_coef >= threshold);\n"
"}\n"
"}\n"
"__kernel void classify_hists_252_kernel(\n"
"const int cdescr_width, const int cdescr_height, const int cblock_hist_size,\n"
"const int img_win_width, const int img_block_width,\n"
"const int win_block_stride_x, const int win_block_stride_y,\n"
"__global const float * block_hists, __global const float* coefs,\n"
"float free_coef, float threshold, __global uchar* labels)\n"
"{\n"
"const int tid = get_local_id(0);\n"
"const int gidX = get_group_id(0);\n"
"const int gidY = get_group_id(1);\n"
"__global const float* hist = block_hists + (gidY * win_block_stride_y *\n"
"img_block_width + gidX * win_block_stride_x) * cblock_hist_size;\n"
"float product = 0.f;\n"
"if (tid < cdescr_width)\n"
"{\n"
"for (int i = 0; i < cdescr_height; i++)\n"
"product += coefs[i * cdescr_width + tid] *\n"
"hist[i * img_block_width * cblock_hist_size + tid];\n"
"}\n"
"__local float products[NTHREADS];\n"
"products[tid] = product;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 128) products[tid] = product = product + products[tid + 128];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 64) products[tid] = product = product + products[tid + 64];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"volatile __local float* smem = products;\n"
"#ifdef CPU\n"
"if(tid<32) smem[tid] = product = product + smem[tid + 32];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<16) smem[tid] = product = product + smem[tid + 16];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<8) smem[tid] = product = product + smem[tid + 8];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<4) smem[tid] = product = product + smem[tid + 4];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<2) smem[tid] = product = product + smem[tid + 2];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"#else\n"
"if (tid < 32)\n"
"{\n"
"smem[tid] = product = product + smem[tid + 32];\n"
"#if WAVE_SIZE < 32\n"
"} barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 16) {\n"
"#endif\n"
"smem[tid] = product = product + smem[tid + 16];\n"
"smem[tid] = product = product + smem[tid + 8];\n"
"smem[tid] = product = product + smem[tid + 4];\n"
"smem[tid] = product = product + smem[tid + 2];\n"
"}\n"
"#endif\n"
"if (tid == 0){\n"
"product = product + smem[tid + 1];\n"
"labels[gidY * img_win_width + gidX] = (product + free_coef >= threshold);\n"
"}\n"
"}\n"
"__kernel void classify_hists_kernel(\n"
"const int cdescr_size, const int cdescr_width, const int cblock_hist_size,\n"
"const int img_win_width, const int img_block_width,\n"
"const int win_block_stride_x, const int win_block_stride_y,\n"
"__global const float * block_hists, __global const float* coefs,\n"
"float free_coef, float threshold, __global uchar* labels)\n"
"{\n"
"const int tid = get_local_id(0);\n"
"const int gidX = get_group_id(0);\n"
"const int gidY = get_group_id(1);\n"
"__global const float* hist = block_hists + (gidY * win_block_stride_y *\n"
"img_block_width + gidX * win_block_stride_x) * cblock_hist_size;\n"
"float product = 0.f;\n"
"for (int i = tid; i < cdescr_size; i += NTHREADS)\n"
"{\n"
"int offset_y = i / cdescr_width;\n"
"int offset_x = i - offset_y * cdescr_width;\n"
"product += coefs[i] *\n"
"hist[offset_y * img_block_width * cblock_hist_size + offset_x];\n"
"}\n"
"__local float products[NTHREADS];\n"
"products[tid] = product;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 128) products[tid] = product = product + products[tid + 128];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 64) products[tid] = product = product + products[tid + 64];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"volatile __local float* smem = products;\n"
"#ifdef CPU\n"
"if(tid<32) smem[tid] = product = product + smem[tid + 32];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<16) smem[tid] = product = product + smem[tid + 16];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<8) smem[tid] = product = product + smem[tid + 8];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<4) smem[tid] = product = product + smem[tid + 4];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(tid<2) smem[tid] = product = product + smem[tid + 2];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"#else\n"
"if (tid < 32)\n"
"{\n"
"smem[tid] = product = product + smem[tid + 32];\n"
"#if WAVE_SIZE < 32\n"
"} barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 16) {\n"
"#endif\n"
"smem[tid] = product = product + smem[tid + 16];\n"
"smem[tid] = product = product + smem[tid + 8];\n"
"smem[tid] = product = product + smem[tid + 4];\n"
"smem[tid] = product = product + smem[tid + 2];\n"
"}\n"
"#endif\n"
"if (tid == 0){\n"
"smem[tid] = product = product + smem[tid + 1];\n"
"labels[gidY * img_win_width + gidX] = (product + free_coef >= threshold);\n"
"}\n"
"}\n"
"__kernel void extract_descrs_by_rows_kernel(\n"
"const int cblock_hist_size, const int descriptors_quadstep,\n"
"const int cdescr_size, const int cdescr_width, const int img_block_width,\n"
"const int win_block_stride_x, const int win_block_stride_y,\n"
"__global const float* block_hists, __global float* descriptors)\n"
"{\n"
"int tid = get_local_id(0);\n"
"int gidX = get_group_id(0);\n"
"int gidY = get_group_id(1);\n"
"__global const float* hist = block_hists + (gidY * win_block_stride_y *\n"
"img_block_width + gidX * win_block_stride_x) * cblock_hist_size;\n"
"__global float* descriptor = descriptors +\n"
"(gidY * get_num_groups(0) + gidX) * descriptors_quadstep;\n"
"for (int i = tid; i < cdescr_size; i += NTHREADS)\n"
"{\n"
"int offset_y = i / cdescr_width;\n"
"int offset_x = i - offset_y * cdescr_width;\n"
"descriptor[i] = hist[offset_y * img_block_width * cblock_hist_size + offset_x];\n"
"}\n"
"}\n"
"__kernel void extract_descrs_by_cols_kernel(\n"
"const int cblock_hist_size, const int descriptors_quadstep, const int cdescr_size,\n"
"const int cnblocks_win_x, const int cnblocks_win_y, const int img_block_width,\n"
"const int win_block_stride_x, const int win_block_stride_y,\n"
"__global const float* block_hists, __global float* descriptors)\n"
"{\n"
"int tid = get_local_id(0);\n"
"int gidX = get_group_id(0);\n"
"int gidY = get_group_id(1);\n"
"__global const float* hist = block_hists +  (gidY * win_block_stride_y *\n"
"img_block_width + gidX * win_block_stride_x) * cblock_hist_size;\n"
"__global float* descriptor = descriptors +\n"
"(gidY * get_num_groups(0) + gidX) * descriptors_quadstep;\n"
"for (int i = tid; i < cdescr_size; i += NTHREADS)\n"
"{\n"
"int block_idx = i / cblock_hist_size;\n"
"int idx_in_block = i - block_idx * cblock_hist_size;\n"
"int y = block_idx / cnblocks_win_x;\n"
"int x = block_idx - y * cnblocks_win_x;\n"
"descriptor[(x * cnblocks_win_y + y) * cblock_hist_size + idx_in_block] =\n"
"hist[(y * img_block_width  + x) * cblock_hist_size + idx_in_block];\n"
"}\n"
"}\n"
"__kernel void compute_gradients_8UC4_kernel(\n"
"const int height, const int width,\n"
"const int img_step, const int grad_quadstep, const int qangle_step,\n"
"const __global uchar4 * img, __global float * grad, __global QANGLE_TYPE * qangle,\n"
"const float angle_scale, const char correct_gamma, const int cnbins)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int tid = get_local_id(0);\n"
"const int gSizeX = get_local_size(0);\n"
"const int gidY = get_group_id(1);\n"
"__global const uchar4* row = img + gidY * img_step;\n"
"__local float sh_row[(NTHREADS + 2) * 3];\n"
"uchar4 val;\n"
"if (x < width)\n"
"val = row[x];\n"
"else\n"
"val = row[width - 2];\n"
"sh_row[tid + 1] = val.x;\n"
"sh_row[tid + 1 + (NTHREADS + 2)] = val.y;\n"
"sh_row[tid + 1 + 2 * (NTHREADS + 2)] = val.z;\n"
"if (tid == 0)\n"
"{\n"
"val = row[max(x - 1, 1)];\n"
"sh_row[0] = val.x;\n"
"sh_row[(NTHREADS + 2)] = val.y;\n"
"sh_row[2 * (NTHREADS + 2)] = val.z;\n"
"}\n"
"if (tid == gSizeX - 1)\n"
"{\n"
"val = row[min(x + 1, width - 2)];\n"
"sh_row[gSizeX + 1] = val.x;\n"
"sh_row[gSizeX + 1 + (NTHREADS + 2)] = val.y;\n"
"sh_row[gSizeX + 1 + 2 * (NTHREADS + 2)] = val.z;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (x < width)\n"
"{\n"
"float3 a = (float3) (sh_row[tid], sh_row[tid + (NTHREADS + 2)],\n"
"sh_row[tid + 2 * (NTHREADS + 2)]);\n"
"float3 b = (float3) (sh_row[tid + 2], sh_row[tid + 2 + (NTHREADS + 2)],\n"
"sh_row[tid + 2 + 2 * (NTHREADS + 2)]);\n"
"float3 dx;\n"
"if (correct_gamma == 1)\n"
"dx = sqrt(b) - sqrt(a);\n"
"else\n"
"dx = b - a;\n"
"float3 dy = (float3) 0.f;\n"
"if (gidY > 0 && gidY < height - 1)\n"
"{\n"
"a = convert_float3(img[(gidY - 1) * img_step + x].xyz);\n"
"b = convert_float3(img[(gidY + 1) * img_step + x].xyz);\n"
"if (correct_gamma == 1)\n"
"dy = sqrt(b) - sqrt(a);\n"
"else\n"
"dy = b - a;\n"
"}\n"
"float best_dx = dx.x;\n"
"float best_dy = dy.x;\n"
"float mag0 = dx.x * dx.x + dy.x * dy.x;\n"
"float mag1 = dx.y * dx.y + dy.y * dy.y;\n"
"if (mag0 < mag1)\n"
"{\n"
"best_dx = dx.y;\n"
"best_dy = dy.y;\n"
"mag0 = mag1;\n"
"}\n"
"mag1 = dx.z * dx.z + dy.z * dy.z;\n"
"if (mag0 < mag1)\n"
"{\n"
"best_dx = dx.z;\n"
"best_dy = dy.z;\n"
"mag0 = mag1;\n"
"}\n"
"mag0 = sqrt(mag0);\n"
"float ang = (atan2(best_dy, best_dx) + CV_PI_F) * angle_scale - 0.5f;\n"
"int hidx = (int)floor(ang);\n"
"ang -= hidx;\n"
"hidx = (hidx + cnbins) % cnbins;\n"
"qangle[(gidY * qangle_step + x) << 1] = hidx;\n"
"qangle[((gidY * qangle_step + x) << 1) + 1] = (hidx + 1) % cnbins;\n"
"grad[(gidY * grad_quadstep + x) << 1] = mag0 * (1.f - ang);\n"
"grad[((gidY * grad_quadstep + x) << 1) + 1] = mag0 * ang;\n"
"}\n"
"}\n"
"__kernel void compute_gradients_8UC1_kernel(\n"
"const int height, const int width,\n"
"const int img_step, const int grad_quadstep, const int qangle_step,\n"
"__global const uchar * img, __global float * grad, __global QANGLE_TYPE * qangle,\n"
"const float angle_scale, const char correct_gamma, const int cnbins)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int tid = get_local_id(0);\n"
"const int gSizeX = get_local_size(0);\n"
"const int gidY = get_group_id(1);\n"
"__global const uchar* row = img + gidY * img_step;\n"
"__local float sh_row[NTHREADS + 2];\n"
"if (x < width)\n"
"sh_row[tid + 1] = row[x];\n"
"else\n"
"sh_row[tid + 1] = row[width - 2];\n"
"if (tid == 0)\n"
"sh_row[0] = row[max(x - 1, 1)];\n"
"if (tid == gSizeX - 1)\n"
"sh_row[gSizeX + 1] = row[min(x + 1, width - 2)];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (x < width)\n"
"{\n"
"float dx;\n"
"if (correct_gamma == 1)\n"
"dx = sqrt(sh_row[tid + 2]) - sqrt(sh_row[tid]);\n"
"else\n"
"dx = sh_row[tid + 2] - sh_row[tid];\n"
"float dy = 0.f;\n"
"if (gidY > 0 && gidY < height - 1)\n"
"{\n"
"float a = (float) img[ (gidY + 1) * img_step + x ];\n"
"float b = (float) img[ (gidY - 1) * img_step + x ];\n"
"if (correct_gamma == 1)\n"
"dy = sqrt(a) - sqrt(b);\n"
"else\n"
"dy = a - b;\n"
"}\n"
"float mag = sqrt(dx * dx + dy * dy);\n"
"float ang = (atan2(dy, dx) + CV_PI_F) * angle_scale - 0.5f;\n"
"int hidx = (int)floor(ang);\n"
"ang -= hidx;\n"
"hidx = (hidx + cnbins) % cnbins;\n"
"qangle[ (gidY * qangle_step + x) << 1 ]     = hidx;\n"
"qangle[ ((gidY * qangle_step + x) << 1) + 1 ] = (hidx + 1) % cnbins;\n"
"grad[ (gidY * grad_quadstep + x) << 1 ]       = mag * (1.f - ang);\n"
"grad[ ((gidY * grad_quadstep + x) << 1) + 1 ]   = mag * ang;\n"
"}\n"
"}\n"
, "9fce6b301b44c107c666aacfb0b0eaf2"};
const struct ProgramEntry operator_convertTo={"operator_convertTo",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void convert_to(\n"
"__global const srcT* restrict srcMat,\n"
"__global dstT* dstMat,\n"
"int cols1, int rows,\n"
"int sstep1, int soffset1,\n"
"int dstep1, int doffset1,\n"
"float alpha, float beta)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"int srcidx = mad24(y, sstep1, x + soffset1);\n"
"int dstidx = mad24(y, dstep1, x + doffset1);\n"
"if ( (x < cols1) && (y < rows) )\n"
"{\n"
"float temp_src = convert_float(srcMat[srcidx]);\n"
"dstMat[dstidx] = convertToDstType(temp_src*alpha+beta);\n"
"}\n"
"}\n"
, "3200cfd5ac5217f6e3d92e8af4e31487"};
const struct ProgramEntry operator_copyToM={"operator_copyToM",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void copy_to_with_mask(\n"
"__global const GENTYPE* restrict srcMat,\n"
"__global GENTYPE* dstMat,\n"
"__global const uchar* restrict maskMat,\n"
"int cols,\n"
"int rows,\n"
"int srcStep_in_pixel,\n"
"int srcoffset_in_pixel,\n"
"int dstStep_in_pixel,\n"
"int dstoffset_in_pixel,\n"
"int maskStep,\n"
"int maskoffset)\n"
"{\n"
"int x=get_global_id(0);\n"
"int y=get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int maskidx = mad24(y,maskStep,x+ maskoffset);\n"
"if ( maskMat[maskidx])\n"
"{\n"
"int srcidx = mad24(y,srcStep_in_pixel,x+ srcoffset_in_pixel);\n"
"int dstidx = mad24(y,dstStep_in_pixel,x+ dstoffset_in_pixel);\n"
"dstMat[dstidx] = srcMat[srcidx];\n"
"}\n"
"}\n"
"}\n"
, "c6b06af957485640edb1940b4f8853fc"};
const struct ProgramEntry operator_setTo={"operator_setTo",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void set_to_without_mask_C1_D0(__global uchar * scalar,__global uchar * dstMat,\n"
"int cols,int rows,int dstStep_in_pixel,int offset_in_pixel)\n"
"{\n"
"int x=get_global_id(0)<<2;\n"
"int y=get_global_id(1);\n"
"int idx = mad24(y,dstStep_in_pixel,x+ offset_in_pixel);\n"
"uchar4 out;\n"
"out.x = out.y = out.z = out.w = scalar[0];\n"
"if ( (x+3 < cols) && (y < rows)&& ((offset_in_pixel&3) == 0))\n"
"{\n"
"*(__global uchar4*)(dstMat+idx) = out;\n"
"}\n"
"else\n"
"{\n"
"if((x+3 < cols) && (y < rows))\n"
"{\n"
"dstMat[idx] = out.x;\n"
"dstMat[idx+1] = out.y;\n"
"dstMat[idx+2] = out.z;\n"
"dstMat[idx+3] = out.w;\n"
"}\n"
"if((x+2 < cols) && (y < rows))\n"
"{\n"
"dstMat[idx] = out.x;\n"
"dstMat[idx+1] = out.y;\n"
"dstMat[idx+2] = out.z;\n"
"}\n"
"else if((x+1 < cols) && (y < rows))\n"
"{\n"
"dstMat[idx] = out.x;\n"
"dstMat[idx+1] = out.y;\n"
"}\n"
"else if((x < cols) && (y < rows))\n"
"{\n"
"dstMat[idx] = out.x;\n"
"}\n"
"}\n"
"}\n"
"__kernel void set_to_without_mask(__global GENTYPE * scalar,__global GENTYPE * dstMat,\n"
"int cols, int rows, int dstStep_in_pixel, int offset_in_pixel)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if ( (x < cols) & (y < rows))\n"
"{\n"
"int idx = mad24(y, dstStep_in_pixel, x + offset_in_pixel);\n"
"dstMat[idx] = scalar[0];\n"
"}\n"
"}\n"
, "a19d7ffed8829cb4d606327c9d41db89"};
const struct ProgramEntry operator_setToM={"operator_setToM",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"__kernel void set_to_with_mask(\n"
"__global GENTYPE * scalar,\n"
"__global GENTYPE * dstMat,\n"
"int cols,\n"
"int rows,\n"
"int dstStep_in_pixel,\n"
"int dstoffset_in_pixel,\n"
"__global const uchar * restrict maskMat,\n"
"int maskStep,\n"
"int maskoffset)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (x < cols && y < rows)\n"
"{\n"
"int maskidx = mad24(y,maskStep,x+ maskoffset);\n"
"if (maskMat[maskidx])\n"
"{\n"
"int dstidx = mad24(y,dstStep_in_pixel,x+ dstoffset_in_pixel);\n"
"dstMat[dstidx] = scalar[0];\n"
"}\n"
"}\n"
"}\n"
, "9a888db2d6921485d70785f94e5a9393"};
const struct ProgramEntry optical_flow_farneback={"optical_flow_farneback",
"#define tx  (int)get_local_id(0)\n"
"#define ty  get_local_id(1)\n"
"#define bx  get_group_id(0)\n"
"#define bdx (int)get_local_size(0)\n"
"#define BORDER_SIZE 5\n"
"#define MAX_KSIZE_HALF 100\n"
"#ifndef polyN\n"
"#define polyN 5\n"
"#endif\n"
"__kernel void polynomialExpansion(__global float * dst,\n"
"__global __const float * src,\n"
"__global __const float * c_g,\n"
"__global __const float * c_xg,\n"
"__global __const float * c_xxg,\n"
"__local float * smem,\n"
"const float4 ig,\n"
"const int height, const int width,\n"
"int dstStep, int srcStep)\n"
"{\n"
"const int y = get_global_id(1);\n"
"const int x = bx * (bdx - 2*polyN) + tx - polyN;\n"
"dstStep /= sizeof(*dst);\n"
"srcStep /= sizeof(*src);\n"
"int xWarped;\n"
"__local float *row = smem + tx;\n"
"if (y < height && y >= 0)\n"
"{\n"
"xWarped = min(max(x, 0), width - 1);\n"
"row[0] = src[mad24(y, srcStep, xWarped)] * c_g[0];\n"
"row[bdx] = 0.f;\n"
"row[2*bdx] = 0.f;\n"
"#pragma unroll\n"
"for (int k = 1; k <= polyN; ++k)\n"
"{\n"
"float t0 = src[mad24(max(y - k, 0), srcStep, xWarped)];\n"
"float t1 = src[mad24(min(y + k, height - 1), srcStep, xWarped)];\n"
"row[0] += c_g[k] * (t0 + t1);\n"
"row[bdx] += c_xg[k] * (t1 - t0);\n"
"row[2*bdx] += c_xxg[k] * (t0 + t1);\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (y < height && y >= 0 && tx >= polyN && tx + polyN < bdx && x < width)\n"
"{\n"
"float b1 = c_g[0] * row[0];\n"
"float b3 = c_g[0] * row[bdx];\n"
"float b5 = c_g[0] * row[2*bdx];\n"
"float b2 = 0, b4 = 0, b6 = 0;\n"
"#pragma unroll\n"
"for (int k = 1; k <= polyN; ++k)\n"
"{\n"
"b1 += (row[k] + row[-k]) * c_g[k];\n"
"b4 += (row[k] + row[-k]) * c_xxg[k];\n"
"b2 += (row[k] - row[-k]) * c_xg[k];\n"
"b3 += (row[k + bdx] + row[-k + bdx]) * c_g[k];\n"
"b6 += (row[k + bdx] - row[-k + bdx]) * c_xg[k];\n"
"b5 += (row[k + 2*bdx] + row[-k + 2*bdx]) * c_g[k];\n"
"}\n"
"dst[mad24(y, dstStep, xWarped)] = b3*ig.s0;\n"
"dst[mad24(height + y, dstStep, xWarped)] = b2*ig.s0;\n"
"dst[mad24(2*height + y, dstStep, xWarped)] = b1*ig.s1 + b5*ig.s2;\n"
"dst[mad24(3*height + y, dstStep, xWarped)] = b1*ig.s1 + b4*ig.s2;\n"
"dst[mad24(4*height + y, dstStep, xWarped)] = b6*ig.s3;\n"
"}\n"
"}\n"
"int idx_row_low(const int y, const int last_row)\n"
"{\n"
"return abs(y) % (last_row + 1);\n"
"}\n"
"int idx_row_high(const int y, const int last_row)\n"
"{\n"
"return abs(last_row - abs(last_row - y)) % (last_row + 1);\n"
"}\n"
"int idx_row(const int y, const int last_row)\n"
"{\n"
"return idx_row_low(idx_row_high(y, last_row), last_row);\n"
"}\n"
"int idx_col_low(const int x, const int last_col)\n"
"{\n"
"return abs(x) % (last_col + 1);\n"
"}\n"
"int idx_col_high(const int x, const int last_col)\n"
"{\n"
"return abs(last_col - abs(last_col - x)) % (last_col + 1);\n"
"}\n"
"int idx_col(const int x, const int last_col)\n"
"{\n"
"return idx_col_low(idx_col_high(x, last_col), last_col);\n"
"}\n"
"__kernel void gaussianBlur(__global float * dst,\n"
"__global const float * src,\n"
"__global const float * c_gKer,\n"
"__local float * smem,\n"
"const int height,  const int width,\n"
"int dstStep, int srcStep,\n"
"const int ksizeHalf)\n"
"{\n"
"const int y = get_global_id(1);\n"
"const int x = get_global_id(0);\n"
"dstStep /= sizeof(*dst);\n"
"srcStep /= sizeof(*src);\n"
"__local float *row = smem + ty * (bdx + 2*ksizeHalf);\n"
"if (y < height)\n"
"{\n"
"for (int i = tx; i < bdx + 2*ksizeHalf; i += bdx)\n"
"{\n"
"int xExt = (int)(bx * bdx) + i - ksizeHalf;\n"
"xExt = idx_col(xExt, width - 1);\n"
"row[i] = src[mad24(y, srcStep, xExt)] * c_gKer[0];\n"
"for (int j = 1; j <= ksizeHalf; ++j)\n"
"row[i] += (src[mad24(idx_row_low(y - j, height - 1), srcStep, xExt)]\n"
"+ src[mad24(idx_row_high(y + j, height - 1), srcStep, xExt)]) * c_gKer[j];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (y < height && y >= 0 && x < width && x >= 0)\n"
"{\n"
"row += tx + ksizeHalf;\n"
"float res = row[0] * c_gKer[0];\n"
"for (int i = 1; i <= ksizeHalf; ++i)\n"
"res += (row[-i] + row[i]) * c_gKer[i];\n"
"dst[mad24(y, dstStep, x)] = res;\n"
"}\n"
"}\n"
"__constant float c_border[BORDER_SIZE + 1] = { 0.14f, 0.14f, 0.4472f, 0.4472f, 0.4472f, 1.f };\n"
"__kernel void updateMatrices(__global float * M,\n"
"__global const float * flowx, __global const float * flowy,\n"
"__global const float * R0, __global const float * R1,\n"
"const int height, const int width,\n"
"int mStep, int xStep,  int yStep, int R0Step, int R1Step)\n"
"{\n"
"const int y = get_global_id(1);\n"
"const int x = get_global_id(0);\n"
"mStep /= sizeof(*M);\n"
"xStep /= sizeof(*flowx);\n"
"yStep /= sizeof(*flowy);\n"
"R0Step /= sizeof(*R0);\n"
"R1Step /= sizeof(*R1);\n"
"if (y < height && y >= 0 && x < width && x >= 0)\n"
"{\n"
"float dx = flowx[mad24(y, xStep, x)];\n"
"float dy = flowy[mad24(y, yStep, x)];\n"
"float fx = x + dx;\n"
"float fy = y + dy;\n"
"int x1 = convert_int(floor(fx));\n"
"int y1 = convert_int(floor(fy));\n"
"fx -= x1;\n"
"fy -= y1;\n"
"float r2, r3, r4, r5, r6;\n"
"if (x1 >= 0 && y1 >= 0 && x1 < width - 1 && y1 < height - 1)\n"
"{\n"
"float a00 = (1.f - fx) * (1.f - fy);\n"
"float a01 = fx * (1.f - fy);\n"
"float a10 = (1.f - fx) * fy;\n"
"float a11 = fx * fy;\n"
"r2 = a00 * R1[mad24(y1, R1Step, x1)] +\n"
"a01 * R1[mad24(y1, R1Step, x1 + 1)] +\n"
"a10 * R1[mad24(y1 + 1, R1Step, x1)] +\n"
"a11 * R1[mad24(y1 + 1, R1Step, x1 + 1)];\n"
"r3 = a00 * R1[mad24(height + y1, R1Step, x1)] +\n"
"a01 * R1[mad24(height + y1, R1Step, x1 + 1)] +\n"
"a10 * R1[mad24(height + y1 + 1, R1Step, x1)] +\n"
"a11 * R1[mad24(height + y1 + 1, R1Step, x1 + 1)];\n"
"r4 = a00 * R1[mad24(2*height + y1, R1Step, x1)] +\n"
"a01 * R1[mad24(2*height + y1, R1Step, x1 + 1)] +\n"
"a10 * R1[mad24(2*height + y1 + 1, R1Step, x1)] +\n"
"a11 * R1[mad24(2*height + y1 + 1, R1Step, x1 + 1)];\n"
"r5 = a00 * R1[mad24(3*height + y1, R1Step, x1)] +\n"
"a01 * R1[mad24(3*height + y1, R1Step, x1 + 1)] +\n"
"a10 * R1[mad24(3*height + y1 + 1, R1Step, x1)] +\n"
"a11 * R1[mad24(3*height + y1 + 1, R1Step, x1 + 1)];\n"
"r6 = a00 * R1[mad24(4*height + y1, R1Step, x1)] +\n"
"a01 * R1[mad24(4*height + y1, R1Step, x1 + 1)] +\n"
"a10 * R1[mad24(4*height + y1 + 1, R1Step, x1)] +\n"
"a11 * R1[mad24(4*height + y1 + 1, R1Step, x1 + 1)];\n"
"r4 = (R0[mad24(2*height + y, R0Step, x)] + r4) * 0.5f;\n"
"r5 = (R0[mad24(3*height + y, R0Step, x)] + r5) * 0.5f;\n"
"r6 = (R0[mad24(4*height + y, R0Step, x)] + r6) * 0.25f;\n"
"}\n"
"else\n"
"{\n"
"r2 = r3 = 0.f;\n"
"r4 = R0[mad24(2*height + y, R0Step, x)];\n"
"r5 = R0[mad24(3*height + y, R0Step, x)];\n"
"r6 = R0[mad24(4*height + y, R0Step, x)] * 0.5f;\n"
"}\n"
"r2 = (R0[mad24(y, R0Step, x)] - r2) * 0.5f;\n"
"r3 = (R0[mad24(height + y, R0Step, x)] - r3) * 0.5f;\n"
"r2 += r4*dy + r6*dx;\n"
"r3 += r6*dy + r5*dx;\n"
"float scale =\n"
"c_border[min(x, BORDER_SIZE)] *\n"
"c_border[min(y, BORDER_SIZE)] *\n"
"c_border[min(width - x - 1, BORDER_SIZE)] *\n"
"c_border[min(height - y - 1, BORDER_SIZE)];\n"
"r2 *= scale;\n"
"r3 *= scale;\n"
"r4 *= scale;\n"
"r5 *= scale;\n"
"r6 *= scale;\n"
"M[mad24(y, mStep, x)] = r4*r4 + r6*r6;\n"
"M[mad24(height + y, mStep, x)] = (r4 + r5)*r6;\n"
"M[mad24(2*height + y, mStep, x)] = r5*r5 + r6*r6;\n"
"M[mad24(3*height + y, mStep, x)] = r4*r2 + r6*r3;\n"
"M[mad24(4*height + y, mStep, x)] = r6*r2 + r5*r3;\n"
"}\n"
"}\n"
"__kernel void boxFilter5(__global float * dst,\n"
"__global const float * src,\n"
"__local float * smem,\n"
"const int height,  const int width,\n"
"int dstStep, int srcStep,\n"
"const int ksizeHalf)\n"
"{\n"
"const int y = get_global_id(1);\n"
"const int x = get_global_id(0);\n"
"const float boxAreaInv = 1.f / ((1 + 2*ksizeHalf) * (1 + 2*ksizeHalf));\n"
"const int smw = bdx + 2*ksizeHalf;\n"
"__local float *row = smem + 5 * ty * smw;\n"
"dstStep /= sizeof(*dst);\n"
"srcStep /= sizeof(*src);\n"
"if (y < height)\n"
"{\n"
"for (int i = tx; i < bdx + 2*ksizeHalf; i += bdx)\n"
"{\n"
"int xExt = (int)(bx * bdx) + i - ksizeHalf;\n"
"xExt = min(max(xExt, 0), width - 1);\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"row[k*smw + i] = src[mad24(k*height + y, srcStep, xExt)];\n"
"for (int j = 1; j <= ksizeHalf; ++j)\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"row[k*smw + i] +=\n"
"src[mad24(k*height + max(y - j, 0), srcStep, xExt)] +\n"
"src[mad24(k*height + min(y + j, height - 1), srcStep, xExt)];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (y < height && y >= 0 && x < width && x >= 0)\n"
"{\n"
"row += tx + ksizeHalf;\n"
"float res[5];\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"res[k] = row[k*smw];\n"
"for (int i = 1; i <= ksizeHalf; ++i)\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"res[k] += row[k*smw - i] + row[k*smw + i];\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"dst[mad24(k*height + y, dstStep, x)] = res[k] * boxAreaInv;\n"
"}\n"
"}\n"
"__kernel void updateFlow(__global float4 * flowx, __global float4 * flowy,\n"
"__global const float4 * M,\n"
"const int height, const int width,\n"
"int xStep, int yStep, int mStep)\n"
"{\n"
"const int y = get_global_id(1);\n"
"const int x = get_global_id(0);\n"
"xStep /= sizeof(*flowx);\n"
"yStep /= sizeof(*flowy);\n"
"mStep /= sizeof(*M);\n"
"if (y < height && y >= 0 && x < width && x >= 0)\n"
"{\n"
"float4 g11 = M[mad24(y, mStep, x)];\n"
"float4 g12 = M[mad24(height + y, mStep, x)];\n"
"float4 g22 = M[mad24(2*height + y, mStep, x)];\n"
"float4 h1 =  M[mad24(3*height + y, mStep, x)];\n"
"float4 h2 =  M[mad24(4*height + y, mStep, x)];\n"
"float4 detInv = (float4)(1.f) / (g11*g22 - g12*g12 + (float4)(1e-3f));\n"
"flowx[mad24(y, xStep, x)] = (g11*h2 - g12*h1) * detInv;\n"
"flowy[mad24(y, yStep, x)] = (g22*h1 - g12*h2) * detInv;\n"
"}\n"
"}\n"
"__kernel void gaussianBlur5(__global float * dst,\n"
"__global const float * src,\n"
"__global const float * c_gKer,\n"
"__local float * smem,\n"
"const int height,  const int width,\n"
"int dstStep, int srcStep,\n"
"const int ksizeHalf)\n"
"{\n"
"const int y = get_global_id(1);\n"
"const int x = get_global_id(0);\n"
"const int smw = bdx + 2*ksizeHalf;\n"
"__local volatile float *row = smem + 5 * ty * smw;\n"
"dstStep /= sizeof(*dst);\n"
"srcStep /= sizeof(*src);\n"
"if (y < height)\n"
"{\n"
"for (int i = tx; i < bdx + 2*ksizeHalf; i += bdx)\n"
"{\n"
"int xExt = (int)(bx * bdx) + i - ksizeHalf;\n"
"xExt = idx_col(xExt, width - 1);\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"row[k*smw + i] = src[mad24(k*height + y, srcStep, xExt)] * c_gKer[0];\n"
"for (int j = 1; j <= ksizeHalf; ++j)\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"row[k*smw + i] +=\n"
"(src[mad24(k*height + idx_row_low(y - j, height - 1), srcStep, xExt)] +\n"
"src[mad24(k*height + idx_row_high(y + j, height - 1), srcStep, xExt)]) * c_gKer[j];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (y < height && y >= 0 && x < width && x >= 0)\n"
"{\n"
"row += tx + ksizeHalf;\n"
"float res[5];\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"res[k] = row[k*smw] * c_gKer[0];\n"
"for (int i = 1; i <= ksizeHalf; ++i)\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"res[k] += (row[k*smw - i] + row[k*smw + i]) * c_gKer[i];\n"
"#pragma unroll\n"
"for (int k = 0; k < 5; ++k)\n"
"dst[mad24(k*height + y, dstStep, x)] = res[k];\n"
"}\n"
"}\n"
, "4ea04a3f4d11332d5b2176a64df4ffac"};
const struct ProgramEntry pyr_down={"pyr_down",
"int idx_row_low(int y, int last_row)\n"
"{\n"
"return abs(y) % (last_row + 1);\n"
"}\n"
"int idx_row_high(int y, int last_row)\n"
"{\n"
"return abs(last_row - (int)abs(last_row - y)) % (last_row + 1);\n"
"}\n"
"int idx_row(int y, int last_row)\n"
"{\n"
"return idx_row_low(idx_row_high(y, last_row), last_row);\n"
"}\n"
"int idx_col_low(int x, int last_col)\n"
"{\n"
"return abs(x) % (last_col + 1);\n"
"}\n"
"int idx_col_high(int x, int last_col)\n"
"{\n"
"return abs(last_col - (int)abs(last_col - x)) % (last_col + 1);\n"
"}\n"
"int idx_col(int x, int last_col)\n"
"{\n"
"return idx_col_low(idx_col_high(x, last_col), last_col);\n"
"}\n"
"__kernel void pyrDown_C1_D0(__global uchar * srcData, int srcStep, int srcRows, int srcCols, __global uchar *dst, int dstStep, int dstCols)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_group_id(1);\n"
"__local float smem[256 + 4];\n"
"float sum;\n"
"const int src_y = 2*y;\n"
"const int last_row = srcRows - 1;\n"
"const int last_col = srcCols - 1;\n"
"if (src_y >= 2 && src_y < srcRows - 2 && x >= 2 && x < srcCols - 2)\n"
"{\n"
"sum =       0.0625f * (((srcData + (src_y - 2) * srcStep))[x]);\n"
"sum = sum + 0.25f   * (((srcData + (src_y - 1) * srcStep))[x]);\n"
"sum = sum + 0.375f  * (((srcData + (src_y    ) * srcStep))[x]);\n"
"sum = sum + 0.25f   * (((srcData + (src_y + 1) * srcStep))[x]);\n"
"sum = sum + 0.0625f * (((srcData + (src_y + 2) * srcStep))[x]);\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"sum =       0.0625f * (((srcData + (src_y - 2) * srcStep))[left_x]);\n"
"sum = sum + 0.25f   * (((srcData + (src_y - 1) * srcStep))[left_x]);\n"
"sum = sum + 0.375f  * (((srcData + (src_y    ) * srcStep))[left_x]);\n"
"sum = sum + 0.25f   * (((srcData + (src_y + 1) * srcStep))[left_x]);\n"
"sum = sum + 0.0625f * (((srcData + (src_y + 2) * srcStep))[left_x]);\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"sum =       0.0625f * (((srcData + (src_y - 2) * srcStep))[right_x]);\n"
"sum = sum + 0.25f   * (((srcData + (src_y - 1) * srcStep))[right_x]);\n"
"sum = sum + 0.375f  * (((srcData + (src_y    ) * srcStep))[right_x]);\n"
"sum = sum + 0.25f   * (((srcData + (src_y + 1) * srcStep))[right_x]);\n"
"sum = sum + 0.0625f * (((srcData + (src_y + 2) * srcStep))[right_x]);\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"int col = idx_col(x, last_col);\n"
"sum =       0.0625f * (((srcData + idx_row(src_y - 2, last_row) * srcStep))[col]);\n"
"sum = sum + 0.25f   * (((srcData + idx_row(src_y - 1, last_row) * srcStep))[col]);\n"
"sum = sum + 0.375f  * (((srcData + idx_row(src_y    , last_row) * srcStep))[col]);\n"
"sum = sum + 0.25f   * (((srcData + idx_row(src_y + 1, last_row) * srcStep))[col]);\n"
"sum = sum + 0.0625f * (((srcData + idx_row(src_y + 2, last_row) * srcStep))[col]);\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"col = idx_col(left_x, last_col);\n"
"sum =       0.0625f * (((srcData + idx_row(src_y - 2, last_row) * srcStep))[col]);\n"
"sum = sum + 0.25f   * (((srcData + idx_row(src_y - 1, last_row) * srcStep))[col]);\n"
"sum = sum + 0.375f  * (((srcData + idx_row(src_y    , last_row) * srcStep))[col]);\n"
"sum = sum + 0.25f   * (((srcData + idx_row(src_y + 1, last_row) * srcStep))[col]);\n"
"sum = sum + 0.0625f * (((srcData + idx_row(src_y + 2, last_row) * srcStep))[col]);\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"col = idx_col(right_x, last_col);\n"
"sum =       0.0625f * (((srcData + idx_row(src_y - 2, last_row) * srcStep))[col]);\n"
"sum = sum + 0.25f   * (((srcData + idx_row(src_y - 1, last_row) * srcStep))[col]);\n"
"sum = sum + 0.375f  * (((srcData + idx_row(src_y    , last_row) * srcStep))[col]);\n"
"sum = sum + 0.25f   * (((srcData + idx_row(src_y + 1, last_row) * srcStep))[col]);\n"
"sum = sum + 0.0625f * (((srcData + idx_row(src_y + 2, last_row) * srcStep))[col]);\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (get_local_id(0) < 128)\n"
"{\n"
"const int tid2 = get_local_id(0) * 2;\n"
"sum =       0.0625f * smem[2 + tid2 - 2];\n"
"sum = sum + 0.25f   * smem[2 + tid2 - 1];\n"
"sum = sum + 0.375f  * smem[2 + tid2    ];\n"
"sum = sum + 0.25f   * smem[2 + tid2 + 1];\n"
"sum = sum + 0.0625f * smem[2 + tid2 + 2];\n"
"const int dst_x = (get_group_id(0) * get_local_size(0) + tid2) / 2;\n"
"if (dst_x < dstCols)\n"
"dst[y * dstStep + dst_x] = convert_uchar_sat_rte(sum);\n"
"}\n"
"}\n"
"__kernel void pyrDown_C4_D0(__global uchar4 * srcData, int srcStep, int srcRows, int srcCols, __global uchar4 *dst, int dstStep, int dstCols)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_group_id(1);\n"
"__local float4 smem[256 + 4];\n"
"float4 sum;\n"
"const int src_y = 2*y;\n"
"const int last_row = srcRows - 1;\n"
"const int last_col = srcCols - 1;\n"
"float4 co1 = 0.375f;\n"
"float4 co2 = 0.25f;\n"
"float4 co3 = 0.0625f;\n"
"if (src_y >= 2 && src_y < srcRows - 2 && x >= 2 && x < srcCols - 2)\n"
"{\n"
"sum =       co3 * convert_float4((((srcData + (src_y - 2) * srcStep / 4))[x]));\n"
"sum = sum + co2 * convert_float4((((srcData + (src_y - 1) * srcStep / 4))[x]));\n"
"sum = sum + co1 * convert_float4((((srcData + (src_y    ) * srcStep / 4))[x]));\n"
"sum = sum + co2 * convert_float4((((srcData + (src_y + 1) * srcStep / 4))[x]));\n"
"sum = sum + co3 * convert_float4((((srcData + (src_y + 2) * srcStep / 4))[x]));\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"sum =       co3 * convert_float4((((srcData + (src_y - 2) * srcStep / 4))[left_x]));\n"
"sum = sum + co2 * convert_float4((((srcData + (src_y - 1) * srcStep / 4))[left_x]));\n"
"sum = sum + co1 * convert_float4((((srcData + (src_y    ) * srcStep / 4))[left_x]));\n"
"sum = sum + co2 * convert_float4((((srcData + (src_y + 1) * srcStep / 4))[left_x]));\n"
"sum = sum + co3 * convert_float4((((srcData + (src_y + 2) * srcStep / 4))[left_x]));\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"sum =       co3 * convert_float4((((srcData + (src_y - 2) * srcStep / 4))[right_x]));\n"
"sum = sum + co2 * convert_float4((((srcData + (src_y - 1) * srcStep / 4))[right_x]));\n"
"sum = sum + co1 * convert_float4((((srcData + (src_y    ) * srcStep / 4))[right_x]));\n"
"sum = sum + co2 * convert_float4((((srcData + (src_y + 1) * srcStep / 4))[right_x]));\n"
"sum = sum + co3 * convert_float4((((srcData + (src_y + 2) * srcStep / 4))[right_x]));\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"int col = idx_col(x, last_col);\n"
"sum =       co3 * convert_float4((((srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col]));\n"
"sum = sum + co2 * convert_float4((((srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col]));\n"
"sum = sum + co1 * convert_float4((((srcData + idx_row(src_y    , last_row) * srcStep / 4))[col]));\n"
"sum = sum + co2 * convert_float4((((srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col]));\n"
"sum = sum + co3 * convert_float4((((srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col]));\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"col = idx_col(left_x, last_col);\n"
"sum =       co3 * convert_float4((((srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col]));\n"
"sum = sum + co2 * convert_float4((((srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col]));\n"
"sum = sum + co1 * convert_float4((((srcData + idx_row(src_y    , last_row) * srcStep / 4))[col]));\n"
"sum = sum + co2 * convert_float4((((srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col]));\n"
"sum = sum + co3 * convert_float4((((srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col]));\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"col = idx_col(right_x, last_col);\n"
"sum =       co3 * convert_float4((((srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col]));\n"
"sum = sum + co2 * convert_float4((((srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col]));\n"
"sum = sum + co1 * convert_float4((((srcData + idx_row(src_y    , last_row) * srcStep / 4))[col]));\n"
"sum = sum + co2 * convert_float4((((srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col]));\n"
"sum = sum + co3 * convert_float4((((srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col]));\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (get_local_id(0) < 128)\n"
"{\n"
"const int tid2 = get_local_id(0) * 2;\n"
"sum =       co3 * smem[2 + tid2 - 2];\n"
"sum = sum + co2 * smem[2 + tid2 - 1];\n"
"sum = sum + co1 * smem[2 + tid2    ];\n"
"sum = sum + co2 * smem[2 + tid2 + 1];\n"
"sum = sum + co3 * smem[2 + tid2 + 2];\n"
"const int dst_x = (get_group_id(0) * get_local_size(0) + tid2) / 2;\n"
"if (dst_x < dstCols)\n"
"dst[y * dstStep / 4 + dst_x] = convert_uchar4_sat_rte(sum);\n"
"}\n"
"}\n"
"__kernel void pyrDown_C1_D2(__global ushort * srcData, int srcStep, int srcRows, int srcCols, __global ushort *dst, int dstStep, int dstCols)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_group_id(1);\n"
"__local float smem[256 + 4];\n"
"float sum;\n"
"const int src_y = 2*y;\n"
"const int last_row = srcRows - 1;\n"
"const int last_col = srcCols - 1;\n"
"if (src_y >= 2 && src_y < srcRows - 2 && x >= 2 && x < srcCols - 2)\n"
"{\n"
"sum =       0.0625f * ((__global ushort*)((__global char*)srcData + (src_y - 2) * srcStep))[x];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + (src_y - 1) * srcStep))[x];\n"
"sum = sum + 0.375f  * ((__global ushort*)((__global char*)srcData + (src_y    ) * srcStep))[x];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + (src_y + 1) * srcStep))[x];\n"
"sum = sum + 0.0625f * ((__global ushort*)((__global char*)srcData + (src_y + 2) * srcStep))[x];\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"sum =       0.0625f * ((__global ushort*)((__global char*)srcData + (src_y - 2) * srcStep))[left_x];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + (src_y - 1) * srcStep))[left_x];\n"
"sum = sum + 0.375f  * ((__global ushort*)((__global char*)srcData + (src_y    ) * srcStep))[left_x];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + (src_y + 1) * srcStep))[left_x];\n"
"sum = sum + 0.0625f * ((__global ushort*)((__global char*)srcData + (src_y + 2) * srcStep))[left_x];\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"sum =       0.0625f * ((__global ushort*)((__global char*)srcData + (src_y - 2) * srcStep))[right_x];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + (src_y - 1) * srcStep))[right_x];\n"
"sum = sum + 0.375f  * ((__global ushort*)((__global char*)srcData + (src_y    ) * srcStep))[right_x];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + (src_y + 1) * srcStep))[right_x];\n"
"sum = sum + 0.0625f * ((__global ushort*)((__global char*)srcData + (src_y + 2) * srcStep))[right_x];\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"int col = idx_col(x, last_col);\n"
"sum =       0.0625f * ((__global ushort*)((__global char*)srcData + idx_row(src_y - 2, last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + idx_row(src_y - 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.375f  * ((__global ushort*)((__global char*)srcData + idx_row(src_y    , last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + idx_row(src_y + 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.0625f * ((__global ushort*)((__global char*)srcData + idx_row(src_y + 2, last_row) * srcStep))[col];\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"col = idx_col(left_x, last_col);\n"
"sum =       0.0625f * ((__global ushort*)((__global char*)srcData + idx_row(src_y - 2, last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + idx_row(src_y - 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.375f  * ((__global ushort*)((__global char*)srcData + idx_row(src_y    , last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + idx_row(src_y + 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.0625f * ((__global ushort*)((__global char*)srcData + idx_row(src_y + 2, last_row) * srcStep))[col];\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"col = idx_col(right_x, last_col);\n"
"sum =       0.0625f * ((__global ushort*)((__global char*)srcData + idx_row(src_y - 2, last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + idx_row(src_y - 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.375f  * ((__global ushort*)((__global char*)srcData + idx_row(src_y    , last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global ushort*)((__global char*)srcData + idx_row(src_y + 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.0625f * ((__global ushort*)((__global char*)srcData + idx_row(src_y + 2, last_row) * srcStep))[col];\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (get_local_id(0) < 128)\n"
"{\n"
"const int tid2 = get_local_id(0) * 2;\n"
"sum =       0.0625f * smem[2 + tid2 - 2];\n"
"sum = sum + 0.25f   * smem[2 + tid2 - 1];\n"
"sum = sum + 0.375f  * smem[2 + tid2    ];\n"
"sum = sum + 0.25f   * smem[2 + tid2 + 1];\n"
"sum = sum + 0.0625f * smem[2 + tid2 + 2];\n"
"const int dst_x = (get_group_id(0) * get_local_size(0) + tid2) / 2;\n"
"if (dst_x < dstCols)\n"
"dst[y * dstStep / 2 + dst_x] = convert_ushort_sat_rte(sum);\n"
"}\n"
"}\n"
"__kernel void pyrDown_C4_D2(__global ushort4 * srcData, int srcStep, int srcRows, int srcCols, __global ushort4 *dst, int dstStep, int dstCols)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_group_id(1);\n"
"__local float4 smem[256 + 4];\n"
"float4 sum;\n"
"const int src_y = 2*y;\n"
"const int last_row = srcRows - 1;\n"
"const int last_col = srcCols - 1;\n"
"float4 co1 = 0.375f;\n"
"float4 co2 = 0.25f;\n"
"float4 co3 = 0.0625f;\n"
"if (src_y >= 2 && src_y < srcRows - 2 && x >= 2 && x < srcCols - 2)\n"
"{\n"
"sum =       co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y - 2) * srcStep / 4))[x]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y - 1) * srcStep / 4))[x]);\n"
"sum = sum + co1 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y    ) * srcStep / 4))[x]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y + 1) * srcStep / 4))[x]);\n"
"sum = sum + co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y + 2) * srcStep / 4))[x]);\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"sum =       co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y - 2) * srcStep / 4))[left_x]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y - 1) * srcStep / 4))[left_x]);\n"
"sum = sum + co1 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y    ) * srcStep / 4))[left_x]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y + 1) * srcStep / 4))[left_x]);\n"
"sum = sum + co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y + 2) * srcStep / 4))[left_x]);\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"sum =       co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y - 2) * srcStep / 4))[right_x]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y - 1) * srcStep / 4))[right_x]);\n"
"sum = sum + co1 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y    ) * srcStep / 4))[right_x]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y + 1) * srcStep / 4))[right_x]);\n"
"sum = sum + co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + (src_y + 2) * srcStep / 4))[right_x]);\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"int col = idx_col(x, last_col);\n"
"sum =       co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co1 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y    , last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col]);\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"col = idx_col(left_x, last_col);\n"
"sum =       co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co1 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y    , last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col]);\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"col = idx_col(right_x, last_col);\n"
"sum =       co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co1 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y    , last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co3 * convert_float4(((__global ushort4*)((__global char4*)srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col]);\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (get_local_id(0) < 128)\n"
"{\n"
"const int tid2 = get_local_id(0) * 2;\n"
"sum =       co3 * smem[2 + tid2 - 2];\n"
"sum = sum + co2 * smem[2 + tid2 - 1];\n"
"sum = sum + co1 * smem[2 + tid2    ];\n"
"sum = sum + co2 * smem[2 + tid2 + 1];\n"
"sum = sum + co3 * smem[2 + tid2 + 2];\n"
"const int dst_x = (get_group_id(0) * get_local_size(0) + tid2) / 2;\n"
"if (dst_x < dstCols)\n"
"dst[y * dstStep / 8 + dst_x] = convert_ushort4_sat_rte(sum);\n"
"}\n"
"}\n"
"__kernel void pyrDown_C1_D3(__global short * srcData, int srcStep, int srcRows, int srcCols, __global short *dst, int dstStep, int dstCols)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_group_id(1);\n"
"__local float smem[256 + 4];\n"
"float sum;\n"
"const int src_y = 2*y;\n"
"const int last_row = srcRows - 1;\n"
"const int last_col = srcCols - 1;\n"
"if (src_y >= 2 && src_y < srcRows - 2 && x >= 2 && x < srcCols - 2)\n"
"{\n"
"sum =       0.0625f * ((__global short*)((__global char*)srcData + (src_y - 2) * srcStep))[x];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + (src_y - 1) * srcStep))[x];\n"
"sum = sum + 0.375f  * ((__global short*)((__global char*)srcData + (src_y    ) * srcStep))[x];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + (src_y + 1) * srcStep))[x];\n"
"sum = sum + 0.0625f * ((__global short*)((__global char*)srcData + (src_y + 2) * srcStep))[x];\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"sum =       0.0625f * ((__global short*)((__global char*)srcData + (src_y - 2) * srcStep))[left_x];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + (src_y - 1) * srcStep))[left_x];\n"
"sum = sum + 0.375f  * ((__global short*)((__global char*)srcData + (src_y    ) * srcStep))[left_x];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + (src_y + 1) * srcStep))[left_x];\n"
"sum = sum + 0.0625f * ((__global short*)((__global char*)srcData + (src_y + 2) * srcStep))[left_x];\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"sum =       0.0625f * ((__global short*)((__global char*)srcData + (src_y - 2) * srcStep))[right_x];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + (src_y - 1) * srcStep))[right_x];\n"
"sum = sum + 0.375f  * ((__global short*)((__global char*)srcData + (src_y    ) * srcStep))[right_x];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + (src_y + 1) * srcStep))[right_x];\n"
"sum = sum + 0.0625f * ((__global short*)((__global char*)srcData + (src_y + 2) * srcStep))[right_x];\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"int col = idx_col(x, last_col);\n"
"sum =       0.0625f * ((__global short*)((__global char*)srcData + idx_row(src_y - 2, last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + idx_row(src_y - 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.375f  * ((__global short*)((__global char*)srcData + idx_row(src_y    , last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + idx_row(src_y + 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.0625f * ((__global short*)((__global char*)srcData + idx_row(src_y + 2, last_row) * srcStep))[col];\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"col = idx_col(left_x, last_col);\n"
"sum =       0.0625f * ((__global short*)((__global char*)srcData + idx_row(src_y - 2, last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + idx_row(src_y - 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.375f  * ((__global short*)((__global char*)srcData + idx_row(src_y    , last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + idx_row(src_y + 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.0625f * ((__global short*)((__global char*)srcData + idx_row(src_y + 2, last_row) * srcStep))[col];\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"col = idx_col(right_x, last_col);\n"
"sum =       0.0625f * ((__global short*)((__global char*)srcData + idx_row(src_y - 2, last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + idx_row(src_y - 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.375f  * ((__global short*)((__global char*)srcData + idx_row(src_y    , last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global short*)((__global char*)srcData + idx_row(src_y + 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.0625f * ((__global short*)((__global char*)srcData + idx_row(src_y + 2, last_row) * srcStep))[col];\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (get_local_id(0) < 128)\n"
"{\n"
"const int tid2 = get_local_id(0) * 2;\n"
"sum =       0.0625f * smem[2 + tid2 - 2];\n"
"sum = sum + 0.25f   * smem[2 + tid2 - 1];\n"
"sum = sum + 0.375f  * smem[2 + tid2    ];\n"
"sum = sum + 0.25f   * smem[2 + tid2 + 1];\n"
"sum = sum + 0.0625f * smem[2 + tid2 + 2];\n"
"const int dst_x = (get_group_id(0) * get_local_size(0) + tid2) / 2;\n"
"if (dst_x < dstCols)\n"
"dst[y * dstStep / 2 + dst_x] = convert_short_sat_rte(sum);\n"
"}\n"
"}\n"
"__kernel void pyrDown_C4_D3(__global short4 * srcData, int srcStep, int srcRows, int srcCols, __global short4 *dst, int dstStep, int dstCols)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_group_id(1);\n"
"__local float4 smem[256 + 4];\n"
"float4 sum;\n"
"const int src_y = 2*y;\n"
"const int last_row = srcRows - 1;\n"
"const int last_col = srcCols - 1;\n"
"float4 co1 = 0.375f;\n"
"float4 co2 = 0.25f;\n"
"float4 co3 = 0.0625f;\n"
"if (src_y >= 2 && src_y < srcRows - 2 && x >= 2 && x < srcCols - 2)\n"
"{\n"
"sum =       co3 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y - 2) * srcStep / 4))[x]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y - 1) * srcStep / 4))[x]);\n"
"sum = sum + co1 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y    ) * srcStep / 4))[x]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y + 1) * srcStep / 4))[x]);\n"
"sum = sum + co3 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y + 2) * srcStep / 4))[x]);\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"sum =       co3 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y - 2) * srcStep / 4))[left_x]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y - 1) * srcStep / 4))[left_x]);\n"
"sum = sum + co1 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y    ) * srcStep / 4))[left_x]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y + 1) * srcStep / 4))[left_x]);\n"
"sum = sum + co3 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y + 2) * srcStep / 4))[left_x]);\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"sum =       co3 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y - 2) * srcStep / 4))[right_x]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y - 1) * srcStep / 4))[right_x]);\n"
"sum = sum + co1 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y    ) * srcStep / 4))[right_x]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y + 1) * srcStep / 4))[right_x]);\n"
"sum = sum + co3 * convert_float4(((__global short4*)((__global char4*)srcData + (src_y + 2) * srcStep / 4))[right_x]);\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"int col = idx_col(x, last_col);\n"
"sum =       co3 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co1 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y    , last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co3 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col]);\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"col = idx_col(left_x, last_col);\n"
"sum =       co3 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co1 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y    , last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co3 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col]);\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"col = idx_col(right_x, last_col);\n"
"sum =       co3 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co1 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y    , last_row) * srcStep / 4))[col]);\n"
"sum = sum + co2 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col]);\n"
"sum = sum + co3 * convert_float4(((__global short4*)((__global char4*)srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col]);\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (get_local_id(0) < 128)\n"
"{\n"
"const int tid2 = get_local_id(0) * 2;\n"
"sum =       co3 * smem[2 + tid2 - 2];\n"
"sum = sum + co2 * smem[2 + tid2 - 1];\n"
"sum = sum + co1 * smem[2 + tid2    ];\n"
"sum = sum + co2 * smem[2 + tid2 + 1];\n"
"sum = sum + co3 * smem[2 + tid2 + 2];\n"
"const int dst_x = (get_group_id(0) * get_local_size(0) + tid2) / 2;\n"
"if (dst_x < dstCols)\n"
"dst[y * dstStep / 8 + dst_x] = convert_short4_sat_rte(sum);\n"
"}\n"
"}\n"
"__kernel void pyrDown_C1_D5(__global float * srcData, int srcStep, int srcRows, int srcCols, __global float *dst, int dstStep, int dstCols)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_group_id(1);\n"
"__local float smem[256 + 4];\n"
"float sum;\n"
"const int src_y = 2*y;\n"
"const int last_row = srcRows - 1;\n"
"const int last_col = srcCols - 1;\n"
"if (src_y >= 2 && src_y < srcRows - 2 && x >= 2 && x < srcCols - 2)\n"
"{\n"
"sum =       0.0625f * ((__global float*)((__global char*)srcData + (src_y - 2) * srcStep))[x];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + (src_y - 1) * srcStep))[x];\n"
"sum = sum + 0.375f  * ((__global float*)((__global char*)srcData + (src_y    ) * srcStep))[x];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + (src_y + 1) * srcStep))[x];\n"
"sum = sum + 0.0625f * ((__global float*)((__global char*)srcData + (src_y + 2) * srcStep))[x];\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"sum =       0.0625f * ((__global float*)((__global char*)srcData + (src_y - 2) * srcStep))[left_x];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + (src_y - 1) * srcStep))[left_x];\n"
"sum = sum + 0.375f  * ((__global float*)((__global char*)srcData + (src_y    ) * srcStep))[left_x];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + (src_y + 1) * srcStep))[left_x];\n"
"sum = sum + 0.0625f * ((__global float*)((__global char*)srcData + (src_y + 2) * srcStep))[left_x];\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"sum =       0.0625f * ((__global float*)((__global char*)srcData + (src_y - 2) * srcStep))[right_x];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + (src_y - 1) * srcStep))[right_x];\n"
"sum = sum + 0.375f  * ((__global float*)((__global char*)srcData + (src_y    ) * srcStep))[right_x];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + (src_y + 1) * srcStep))[right_x];\n"
"sum = sum + 0.0625f * ((__global float*)((__global char*)srcData + (src_y + 2) * srcStep))[right_x];\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"int col = idx_col(x, last_col);\n"
"sum =       0.0625f * ((__global float*)((__global char*)srcData + idx_row(src_y - 2, last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + idx_row(src_y - 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.375f  * ((__global float*)((__global char*)srcData + idx_row(src_y    , last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + idx_row(src_y + 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.0625f * ((__global float*)((__global char*)srcData + idx_row(src_y + 2, last_row) * srcStep))[col];\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"col = idx_col(left_x, last_col);\n"
"sum =       0.0625f * ((__global float*)((__global char*)srcData + idx_row(src_y - 2, last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + idx_row(src_y - 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.375f  * ((__global float*)((__global char*)srcData + idx_row(src_y    , last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + idx_row(src_y + 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.0625f * ((__global float*)((__global char*)srcData + idx_row(src_y + 2, last_row) * srcStep))[col];\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"col = idx_col(right_x, last_col);\n"
"sum =       0.0625f * ((__global float*)((__global char*)srcData + idx_row(src_y - 2, last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + idx_row(src_y - 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.375f  * ((__global float*)((__global char*)srcData + idx_row(src_y    , last_row) * srcStep))[col];\n"
"sum = sum + 0.25f   * ((__global float*)((__global char*)srcData + idx_row(src_y + 1, last_row) * srcStep))[col];\n"
"sum = sum + 0.0625f * ((__global float*)((__global char*)srcData + idx_row(src_y + 2, last_row) * srcStep))[col];\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (get_local_id(0) < 128)\n"
"{\n"
"const int tid2 = get_local_id(0) * 2;\n"
"sum =       0.0625f * smem[2 + tid2 - 2];\n"
"sum = sum + 0.25f   * smem[2 + tid2 - 1];\n"
"sum = sum + 0.375f  * smem[2 + tid2    ];\n"
"sum = sum + 0.25f   * smem[2 + tid2 + 1];\n"
"sum = sum + 0.0625f * smem[2 + tid2 + 2];\n"
"const int dst_x = (get_group_id(0) * get_local_size(0) + tid2) / 2;\n"
"if (dst_x < dstCols)\n"
"dst[y * dstStep / 4 + dst_x] = sum;\n"
"}\n"
"}\n"
"__kernel void pyrDown_C4_D5(__global float4 * srcData, int srcStep, int srcRows, int srcCols, __global float4 *dst, int dstStep, int dstCols)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_group_id(1);\n"
"__local float4 smem[256 + 4];\n"
"float4 sum;\n"
"const int src_y = 2*y;\n"
"const int last_row = srcRows - 1;\n"
"const int last_col = srcCols - 1;\n"
"float4 co1 = 0.375f;\n"
"float4 co2 = 0.25f;\n"
"float4 co3 = 0.0625f;\n"
"if (src_y >= 2 && src_y < srcRows - 2 && x >= 2 && x < srcCols - 2)\n"
"{\n"
"sum =       co3 * ((__global float4*)((__global char4*)srcData + (src_y - 2) * srcStep / 4))[x];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + (src_y - 1) * srcStep / 4))[x];\n"
"sum = sum + co1 * ((__global float4*)((__global char4*)srcData + (src_y    ) * srcStep / 4))[x];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + (src_y + 1) * srcStep / 4))[x];\n"
"sum = sum + co3 * ((__global float4*)((__global char4*)srcData + (src_y + 2) * srcStep / 4))[x];\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"sum =       co3 * ((__global float4*)((__global char4*)srcData + (src_y - 2) * srcStep / 4))[left_x];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + (src_y - 1) * srcStep / 4))[left_x];\n"
"sum = sum + co1 * ((__global float4*)((__global char4*)srcData + (src_y    ) * srcStep / 4))[left_x];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + (src_y + 1) * srcStep / 4))[left_x];\n"
"sum = sum + co3 * ((__global float4*)((__global char4*)srcData + (src_y + 2) * srcStep / 4))[left_x];\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"sum =       co3 * ((__global float4*)((__global char4*)srcData + (src_y - 2) * srcStep / 4))[right_x];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + (src_y - 1) * srcStep / 4))[right_x];\n"
"sum = sum + co1 * ((__global float4*)((__global char4*)srcData + (src_y    ) * srcStep / 4))[right_x];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + (src_y + 1) * srcStep / 4))[right_x];\n"
"sum = sum + co3 * ((__global float4*)((__global char4*)srcData + (src_y + 2) * srcStep / 4))[right_x];\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"int col = idx_col(x, last_col);\n"
"sum =       co3 * ((__global float4*)((__global char4*)srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col];\n"
"sum = sum + co1 * ((__global float4*)((__global char4*)srcData + idx_row(src_y    , last_row) * srcStep / 4))[col];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col];\n"
"sum = sum + co3 * ((__global float4*)((__global char4*)srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col];\n"
"smem[2 + get_local_id(0)] = sum;\n"
"if (get_local_id(0) < 2)\n"
"{\n"
"const int left_x = x - 2;\n"
"col = idx_col(left_x, last_col);\n"
"sum =       co3 * ((__global float4*)((__global char4*)srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col];\n"
"sum = sum + co1 * ((__global float4*)((__global char4*)srcData + idx_row(src_y    , last_row) * srcStep / 4))[col];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col];\n"
"sum = sum + co3 * ((__global float4*)((__global char4*)srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col];\n"
"smem[get_local_id(0)] = sum;\n"
"}\n"
"if (get_local_id(0) > 253)\n"
"{\n"
"const int right_x = x + 2;\n"
"col = idx_col(right_x, last_col);\n"
"sum =       co3 * ((__global float4*)((__global char4*)srcData + idx_row(src_y - 2, last_row) * srcStep / 4))[col];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + idx_row(src_y - 1, last_row) * srcStep / 4))[col];\n"
"sum = sum + co1 * ((__global float4*)((__global char4*)srcData + idx_row(src_y    , last_row) * srcStep / 4))[col];\n"
"sum = sum + co2 * ((__global float4*)((__global char4*)srcData + idx_row(src_y + 1, last_row) * srcStep / 4))[col];\n"
"sum = sum + co3 * ((__global float4*)((__global char4*)srcData + idx_row(src_y + 2, last_row) * srcStep / 4))[col];\n"
"smem[4 + get_local_id(0)] = sum;\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (get_local_id(0) < 128)\n"
"{\n"
"const int tid2 = get_local_id(0) * 2;\n"
"sum =       co3 * smem[2 + tid2 - 2];\n"
"sum = sum + co2 * smem[2 + tid2 - 1];\n"
"sum = sum + co1 * smem[2 + tid2    ];\n"
"sum = sum + co2 * smem[2 + tid2 + 1];\n"
"sum = sum + co3 * smem[2 + tid2 + 2];\n"
"const int dst_x = (get_group_id(0) * get_local_size(0) + tid2) / 2;\n"
"if (dst_x < dstCols)\n"
"dst[y * dstStep / 16 + dst_x] = sum;\n"
"}\n"
"}\n"
, "a852332a866d8849b7d1bfdd7017b87f"};
const struct ProgramEntry pyr_up={"pyr_up",
"__kernel void pyrUp(__global Type* src, __global Type* dst,\n"
"int srcRows, int dstRows, int srcCols, int dstCols,\n"
"int srcOffset, int dstOffset, int srcStep, int dstStep)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_global_id(1);\n"
"const int lsizex = get_local_size(0);\n"
"const int lsizey = get_local_size(1);\n"
"const int tidx = get_local_id(0);\n"
"const int tidy = get_local_id(1);\n"
"__local floatType s_srcPatch[10][10];\n"
"__local floatType s_dstPatch[20][16];\n"
"if( tidx < 10 && tidy < 10 )\n"
"{\n"
"int srcx = mad24((int)get_group_id(0), lsizex>>1, tidx) - 1;\n"
"int srcy = mad24((int)get_group_id(1), lsizey>>1, tidy) - 1;\n"
"srcx = abs(srcx);\n"
"srcx = min(srcCols - 1,srcx);\n"
"srcy = abs(srcy);\n"
"srcy = min(srcRows -1 ,srcy);\n"
"s_srcPatch[tidy][tidx] = convertToFloat(src[srcx + srcy * srcStep]);\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"floatType sum = (floatType)0;\n"
"const floatType evenFlag = (floatType)((tidx & 1) == 0);\n"
"const floatType oddFlag = (floatType)((tidx & 1) != 0);\n"
"const bool  eveny = ((tidy & 1) == 0);\n"
"const floatType co1 = (floatType)0.375f;\n"
"const floatType co2 = (floatType)0.25f;\n"
"const floatType co3 = (floatType)0.0625f;\n"
"if(eveny)\n"
"{\n"
"sum =       ( evenFlag* co3 ) * s_srcPatch[1 + (tidy >> 1)][1 + ((tidx - 2) >> 1)];\n"
"sum = sum + ( oddFlag * co2 ) * s_srcPatch[1 + (tidy >> 1)][1 + ((tidx - 1) >> 1)];\n"
"sum = sum + ( evenFlag* co1 ) * s_srcPatch[1 + (tidy >> 1)][1 + ((tidx    ) >> 1)];\n"
"sum = sum + ( oddFlag * co2 ) * s_srcPatch[1 + (tidy >> 1)][1 + ((tidx + 1) >> 1)];\n"
"sum = sum + ( evenFlag* co3 ) * s_srcPatch[1 + (tidy >> 1)][1 + ((tidx + 2) >> 1)];\n"
"}\n"
"s_dstPatch[2 + tidy][tidx] = sum;\n"
"if (tidy < 2)\n"
"{\n"
"sum = 0;\n"
"if (eveny)\n"
"{\n"
"sum =       (evenFlag * co3 ) * s_srcPatch[lsizey-16][1 + ((tidx - 2) >> 1)];\n"
"sum = sum + ( oddFlag * co2 ) * s_srcPatch[lsizey-16][1 + ((tidx - 1) >> 1)];\n"
"sum = sum + (evenFlag * co1 ) * s_srcPatch[lsizey-16][1 + ((tidx    ) >> 1)];\n"
"sum = sum + ( oddFlag * co2 ) * s_srcPatch[lsizey-16][1 + ((tidx + 1) >> 1)];\n"
"sum = sum + (evenFlag * co3 ) * s_srcPatch[lsizey-16][1 + ((tidx + 2) >> 1)];\n"
"}\n"
"s_dstPatch[tidy][tidx] = sum;\n"
"}\n"
"if (tidy > 13)\n"
"{\n"
"sum = 0;\n"
"if (eveny)\n"
"{\n"
"sum =       (evenFlag * co3) * s_srcPatch[lsizey-7][1 + ((tidx - 2) >> 1)];\n"
"sum = sum + ( oddFlag * co2) * s_srcPatch[lsizey-7][1 + ((tidx - 1) >> 1)];\n"
"sum = sum + (evenFlag * co1) * s_srcPatch[lsizey-7][1 + ((tidx    ) >> 1)];\n"
"sum = sum + ( oddFlag * co2) * s_srcPatch[lsizey-7][1 + ((tidx + 1) >> 1)];\n"
"sum = sum + (evenFlag * co3) * s_srcPatch[lsizey-7][1 + ((tidx + 2) >> 1)];\n"
"}\n"
"s_dstPatch[4 + tidy][tidx] = sum;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"sum =       co3 * s_dstPatch[2 + tidy - 2][tidx];\n"
"sum = sum + co2 * s_dstPatch[2 + tidy - 1][tidx];\n"
"sum = sum + co1 * s_dstPatch[2 + tidy    ][tidx];\n"
"sum = sum + co2 * s_dstPatch[2 + tidy + 1][tidx];\n"
"sum = sum + co3 * s_dstPatch[2 + tidy + 2][tidx];\n"
"if ((x < dstCols) && (y < dstRows))\n"
"dst[x + y * dstStep] = convertToType(4.0f * sum);\n"
"}\n"
, "66198bcfcc6a241a5e4d6cadf0cd3dc0"};
const struct ProgramEntry pyrlk={"pyrlk",
"#define  BUFFER  64\n"
"#define  BUFFER2  BUFFER>>1\n"
"#ifndef WAVE_SIZE\n"
"#define WAVE_SIZE 1\n"
"#endif\n"
"#ifdef CPU\n"
"void reduce3(float val1, float val2, float val3,  __local float* smem1,  __local float* smem2,  __local float* smem3, int tid)\n"
"{\n"
"smem1[tid] = val1;\n"
"smem2[tid] = val2;\n"
"smem3[tid] = val3;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for(int i = BUFFER2; i > 0; i >>= 1)\n"
"{\n"
"if(tid < i)\n"
"{\n"
"smem1[tid] += smem1[tid + i];\n"
"smem2[tid] += smem2[tid + i];\n"
"smem3[tid] += smem3[tid + i];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"void reduce2(float val1, float val2, volatile __local float* smem1, volatile __local float* smem2, int tid)\n"
"{\n"
"smem1[tid] = val1;\n"
"smem2[tid] = val2;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for(int i = BUFFER2; i > 0; i >>= 1)\n"
"{\n"
"if(tid < i)\n"
"{\n"
"smem1[tid] += smem1[tid + i];\n"
"smem2[tid] += smem2[tid + i];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"void reduce1(float val1, volatile __local float* smem1, int tid)\n"
"{\n"
"smem1[tid] = val1;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for(int i = BUFFER2; i > 0; i >>= 1)\n"
"{\n"
"if(tid < i)\n"
"{\n"
"smem1[tid] += smem1[tid + i];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
"#else\n"
"void reduce3(float val1, float val2, float val3,\n"
"__local volatile float* smem1, __local volatile float* smem2, __local volatile float* smem3, int tid)\n"
"{\n"
"smem1[tid] = val1;\n"
"smem2[tid] = val2;\n"
"smem3[tid] = val3;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 32)\n"
"{\n"
"smem1[tid] += smem1[tid + 32];\n"
"smem2[tid] += smem2[tid + 32];\n"
"smem3[tid] += smem3[tid + 32];\n"
"#if WAVE_SIZE < 32\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 16)\n"
"{\n"
"#endif\n"
"smem1[tid] += smem1[tid + 16];\n"
"smem2[tid] += smem2[tid + 16];\n"
"smem3[tid] += smem3[tid + 16];\n"
"#if WAVE_SIZE <16\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 8)\n"
"{\n"
"#endif\n"
"smem1[tid] += smem1[tid + 8];\n"
"smem2[tid] += smem2[tid + 8];\n"
"smem3[tid] += smem3[tid + 8];\n"
"smem1[tid] += smem1[tid + 4];\n"
"smem2[tid] += smem2[tid + 4];\n"
"smem3[tid] += smem3[tid + 4];\n"
"smem1[tid] += smem1[tid + 2];\n"
"smem2[tid] += smem2[tid + 2];\n"
"smem3[tid] += smem3[tid + 2];\n"
"smem1[tid] += smem1[tid + 1];\n"
"smem2[tid] += smem2[tid + 1];\n"
"smem3[tid] += smem3[tid + 1];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"void reduce2(float val1, float val2, __local volatile float* smem1, __local volatile float* smem2, int tid)\n"
"{\n"
"smem1[tid] = val1;\n"
"smem2[tid] = val2;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 32)\n"
"{\n"
"smem1[tid] += smem1[tid + 32];\n"
"smem2[tid] += smem2[tid + 32];\n"
"#if WAVE_SIZE < 32\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 16)\n"
"{\n"
"#endif\n"
"smem1[tid] += smem1[tid + 16];\n"
"smem2[tid] += smem2[tid + 16];\n"
"#if WAVE_SIZE <16\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 8)\n"
"{\n"
"#endif\n"
"smem1[tid] += smem1[tid + 8];\n"
"smem2[tid] += smem2[tid + 8];\n"
"smem1[tid] += smem1[tid + 4];\n"
"smem2[tid] += smem2[tid + 4];\n"
"smem1[tid] += smem1[tid + 2];\n"
"smem2[tid] += smem2[tid + 2];\n"
"smem1[tid] += smem1[tid + 1];\n"
"smem2[tid] += smem2[tid + 1];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"void reduce1(float val1, __local volatile float* smem1, int tid)\n"
"{\n"
"smem1[tid] = val1;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 32)\n"
"{\n"
"smem1[tid] += smem1[tid + 32];\n"
"#if WAVE_SIZE < 32\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 16)\n"
"{\n"
"#endif\n"
"smem1[tid] += smem1[tid + 16];\n"
"#if WAVE_SIZE <16\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (tid < 8)\n"
"{\n"
"#endif\n"
"smem1[tid] += smem1[tid + 8];\n"
"smem1[tid] += smem1[tid + 4];\n"
"smem1[tid] += smem1[tid + 2];\n"
"smem1[tid] += smem1[tid + 1];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"#endif\n"
"#define SCALE (1.0f / (1 << 20))\n"
"#define  THRESHOLD  0.01f\n"
"__constant sampler_t sampler    = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;\n"
"void SetPatch(image2d_t I, float x, float y,\n"
"float* Pch, float* Dx, float* Dy,\n"
"float* A11, float* A12, float* A22)\n"
"{\n"
"*Pch = read_imagef(I, sampler, (float2)(x, y)).x;\n"
"float dIdx = 3.0f * read_imagef(I, sampler, (float2)(x + 1, y - 1)).x + 10.0f * read_imagef(I, sampler, (float2)(x + 1, y)).x + 3.0f * read_imagef(I, sampler, (float2)(x + 1, y + 1)).x -\n"
"(3.0f * read_imagef(I, sampler, (float2)(x - 1, y - 1)).x + 10.0f * read_imagef(I, sampler, (float2)(x - 1, y)).x + 3.0f * read_imagef(I, sampler, (float2)(x - 1, y + 1)).x);\n"
"float dIdy = 3.0f * read_imagef(I, sampler, (float2)(x - 1, y + 1)).x + 10.0f * read_imagef(I, sampler, (float2)(x, y + 1)).x + 3.0f * read_imagef(I, sampler, (float2)(x + 1, y + 1)).x -\n"
"(3.0f * read_imagef(I, sampler, (float2)(x - 1, y - 1)).x + 10.0f * read_imagef(I, sampler, (float2)(x, y - 1)).x + 3.0f * read_imagef(I, sampler, (float2)(x + 1, y - 1)).x);\n"
"*Dx = dIdx;\n"
"*Dy = dIdy;\n"
"*A11 += dIdx * dIdx;\n"
"*A12 += dIdx * dIdy;\n"
"*A22 += dIdy * dIdy;\n"
"}\n"
"void GetPatch(image2d_t J, float x, float y,\n"
"float* Pch, float* Dx, float* Dy,\n"
"float* b1, float* b2)\n"
"{\n"
"float J_val = read_imagef(J, sampler, (float2)(x, y)).x;\n"
"float diff = (J_val - *Pch) * 32.0f;\n"
"*b1 += diff**Dx;\n"
"*b2 += diff**Dy;\n"
"}\n"
"void GetError(image2d_t J, const float x, const float y, const float* Pch, float* errval)\n"
"{\n"
"float diff = read_imagef(J, sampler, (float2)(x,y)).x-*Pch;\n"
"*errval += fabs(diff);\n"
"}\n"
"void SetPatch4(image2d_t I, const float x, const float y,\n"
"float4* Pch, float4* Dx, float4* Dy,\n"
"float* A11, float* A12, float* A22)\n"
"{\n"
"*Pch = read_imagef(I, sampler, (float2)(x, y));\n"
"float4 dIdx = 3.0f * read_imagef(I, sampler, (float2)(x + 1, y - 1)) + 10.0f * read_imagef(I, sampler, (float2)(x + 1, y)) + 3.0f * read_imagef(I, sampler, (float2)(x + 1, y + 1)) -\n"
"(3.0f * read_imagef(I, sampler, (float2)(x - 1, y - 1)) + 10.0f * read_imagef(I, sampler, (float2)(x - 1, y)) + 3.0f * read_imagef(I, sampler, (float2)(x - 1, y + 1)));\n"
"float4 dIdy = 3.0f * read_imagef(I, sampler, (float2)(x - 1, y + 1)) + 10.0f * read_imagef(I, sampler, (float2)(x, y + 1)) + 3.0f * read_imagef(I, sampler, (float2)(x + 1, y + 1)) -\n"
"(3.0f * read_imagef(I, sampler, (float2)(x - 1, y - 1)) + 10.0f * read_imagef(I, sampler, (float2)(x, y - 1)) + 3.0f * read_imagef(I, sampler, (float2)(x + 1, y - 1)));\n"
"*Dx = dIdx;\n"
"*Dy = dIdy;\n"
"float4 sqIdx = dIdx * dIdx;\n"
"*A11 += sqIdx.x + sqIdx.y + sqIdx.z;\n"
"sqIdx = dIdx * dIdy;\n"
"*A12 += sqIdx.x + sqIdx.y + sqIdx.z;\n"
"sqIdx = dIdy * dIdy;\n"
"*A22 += sqIdx.x + sqIdx.y + sqIdx.z;\n"
"}\n"
"void GetPatch4(image2d_t J, const float x, const float y,\n"
"const float4* Pch, const float4* Dx, const float4* Dy,\n"
"float* b1, float* b2)\n"
"{\n"
"float4 J_val = read_imagef(J, sampler, (float2)(x, y));\n"
"float4 diff = (J_val - *Pch) * 32.0f;\n"
"float4 xdiff = diff* *Dx;\n"
"*b1 += xdiff.x + xdiff.y + xdiff.z;\n"
"xdiff = diff* *Dy;\n"
"*b2 += xdiff.x + xdiff.y + xdiff.z;\n"
"}\n"
"void GetError4(image2d_t J, const float x, const float y, const float4* Pch, float* errval)\n"
"{\n"
"float4 diff = read_imagef(J, sampler, (float2)(x,y))-*Pch;\n"
"*errval += fabs(diff.x) + fabs(diff.y) + fabs(diff.z);\n"
"}\n"
"#define  GRIDSIZE  3\n"
"__kernel void lkSparse_C1_D5(image2d_t I, image2d_t J,\n"
"__global const float2* prevPts, int prevPtsStep, __global float2* nextPts, int nextPtsStep, __global uchar* status, __global float* err,\n"
"const int level, const int rows, const int cols, int PATCH_X, int PATCH_Y, int cn, int c_winSize_x, int c_winSize_y, int c_iters, char calcErr)\n"
"{\n"
"__local float smem1[BUFFER];\n"
"__local float smem2[BUFFER];\n"
"__local float smem3[BUFFER];\n"
"unsigned int xid=get_local_id(0);\n"
"unsigned int yid=get_local_id(1);\n"
"unsigned int gid=get_group_id(0);\n"
"unsigned int xsize=get_local_size(0);\n"
"unsigned int ysize=get_local_size(1);\n"
"int xBase, yBase, k;\n"
"float2 c_halfWin = (float2)((c_winSize_x - 1)>>1, (c_winSize_y - 1)>>1);\n"
"const int tid = mad24(yid, xsize, xid);\n"
"float2 prevPt = prevPts[gid] / (float2)(1 << level);\n"
"if (prevPt.x < 0 || prevPt.x >= cols || prevPt.y < 0 || prevPt.y >= rows)\n"
"{\n"
"if (tid == 0 && level == 0)\n"
"{\n"
"status[gid] = 0;\n"
"}\n"
"return;\n"
"}\n"
"prevPt -= c_halfWin;\n"
"float A11 = 0;\n"
"float A12 = 0;\n"
"float A22 = 0;\n"
"float I_patch[GRIDSIZE][GRIDSIZE];\n"
"float dIdx_patch[GRIDSIZE][GRIDSIZE];\n"
"float dIdy_patch[GRIDSIZE][GRIDSIZE];\n"
"yBase=yid;\n"
"{\n"
"xBase=xid;\n"
"SetPatch(I, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[0][0], &dIdx_patch[0][0], &dIdy_patch[0][0],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"SetPatch(I, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[0][1], &dIdx_patch[0][1], &dIdy_patch[0][1],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"SetPatch(I, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[0][2], &dIdx_patch[0][2], &dIdy_patch[0][2],\n"
"&A11, &A12, &A22);\n"
"}\n"
"yBase+=ysize;\n"
"{\n"
"xBase=xid;\n"
"SetPatch(I, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[1][0], &dIdx_patch[1][0], &dIdy_patch[1][0],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"SetPatch(I, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[1][1], &dIdx_patch[1][1], &dIdy_patch[1][1],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"SetPatch(I, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[1][2], &dIdx_patch[1][2], &dIdy_patch[1][2],\n"
"&A11, &A12, &A22);\n"
"}\n"
"yBase+=ysize;\n"
"if(yBase<c_winSize_y)\n"
"{\n"
"xBase=xid;\n"
"SetPatch(I, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[2][0], &dIdx_patch[2][0], &dIdy_patch[2][0],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"SetPatch(I, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[2][1], &dIdx_patch[2][1], &dIdy_patch[2][1],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"SetPatch(I, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[2][2], &dIdx_patch[2][2], &dIdy_patch[2][2],\n"
"&A11, &A12, &A22);\n"
"}\n"
"reduce3(A11, A12, A22, smem1, smem2, smem3, tid);\n"
"A11 = smem1[0];\n"
"A12 = smem2[0];\n"
"A22 = smem3[0];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"float D = A11 * A22 - A12 * A12;\n"
"if (D < 1.192092896e-07f)\n"
"{\n"
"if (tid == 0 && level == 0)\n"
"status[gid] = 0;\n"
"return;\n"
"}\n"
"A11 /= D;\n"
"A12 /= D;\n"
"A22 /= D;\n"
"prevPt = nextPts[gid] * 2.0f - c_halfWin;\n"
"for (k = 0; k < c_iters; ++k)\n"
"{\n"
"if (prevPt.x < -c_halfWin.x || prevPt.x >= cols || prevPt.y < -c_halfWin.y || prevPt.y >= rows)\n"
"{\n"
"if (tid == 0 && level == 0)\n"
"status[gid] = 0;\n"
"return;\n"
"}\n"
"float b1 = 0;\n"
"float b2 = 0;\n"
"yBase=yid;\n"
"{\n"
"xBase=xid;\n"
"GetPatch(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[0][0], &dIdx_patch[0][0], &dIdy_patch[0][0],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"GetPatch(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[0][1], &dIdx_patch[0][1], &dIdy_patch[0][1],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetPatch(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[0][2], &dIdx_patch[0][2], &dIdy_patch[0][2],\n"
"&b1, &b2);\n"
"}\n"
"yBase+=ysize;\n"
"{\n"
"xBase=xid;\n"
"GetPatch(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[1][0], &dIdx_patch[1][0], &dIdy_patch[1][0],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"GetPatch(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[1][1], &dIdx_patch[1][1], &dIdy_patch[1][1],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetPatch(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[1][2], &dIdx_patch[1][2], &dIdy_patch[1][2],\n"
"&b1, &b2);\n"
"}\n"
"yBase+=ysize;\n"
"if(yBase<c_winSize_y)\n"
"{\n"
"xBase=xid;\n"
"GetPatch(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[2][0], &dIdx_patch[2][0], &dIdy_patch[2][0],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"GetPatch(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[2][1], &dIdx_patch[2][1], &dIdy_patch[2][1],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetPatch(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[2][2], &dIdx_patch[2][2], &dIdy_patch[2][2],\n"
"&b1, &b2);\n"
"}\n"
"reduce2(b1, b2, smem1, smem2, tid);\n"
"b1 = smem1[0];\n"
"b2 = smem2[0];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"float2 delta;\n"
"delta.x = A12 * b2 - A22 * b1;\n"
"delta.y = A12 * b1 - A11 * b2;\n"
"prevPt += delta;\n"
"if (fabs(delta.x) < THRESHOLD && fabs(delta.y) < THRESHOLD)\n"
"break;\n"
"}\n"
"D = 0.0f;\n"
"if (calcErr)\n"
"{\n"
"yBase=yid;\n"
"{\n"
"xBase=xid;\n"
"GetError(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[0][0], &D);\n"
"xBase+=xsize;\n"
"GetError(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[0][1], &D);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetError(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[0][2], &D);\n"
"}\n"
"yBase+=ysize;\n"
"{\n"
"xBase=xid;\n"
"GetError(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[1][0], &D);\n"
"xBase+=xsize;\n"
"GetError(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[1][1], &D);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetError(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[1][2], &D);\n"
"}\n"
"yBase+=ysize;\n"
"if(yBase<c_winSize_y)\n"
"{\n"
"xBase=xid;\n"
"GetError(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[2][0], &D);\n"
"xBase+=xsize;\n"
"GetError(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[2][1], &D);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetError(J, prevPt.x + xBase + 0.5f, prevPt.y + yBase + 0.5f,\n"
"&I_patch[2][2], &D);\n"
"}\n"
"reduce1(D, smem1, tid);\n"
"}\n"
"if (tid == 0)\n"
"{\n"
"prevPt += c_halfWin;\n"
"nextPts[gid] = prevPt;\n"
"if (calcErr)\n"
"err[gid] = smem1[0] / (float)(c_winSize_x * c_winSize_y);\n"
"}\n"
"}\n"
"__kernel void lkSparse_C4_D5(image2d_t I, image2d_t J,\n"
"__global const float2* prevPts, int prevPtsStep, __global float2* nextPts, int nextPtsStep, __global uchar* status, __global float* err,\n"
"const int level, const int rows, const int cols, int PATCH_X, int PATCH_Y, int cn, int c_winSize_x, int c_winSize_y, int c_iters, char calcErr)\n"
"{\n"
"__local float smem1[BUFFER];\n"
"__local float smem2[BUFFER];\n"
"__local float smem3[BUFFER];\n"
"unsigned int xid=get_local_id(0);\n"
"unsigned int yid=get_local_id(1);\n"
"unsigned int gid=get_group_id(0);\n"
"unsigned int xsize=get_local_size(0);\n"
"unsigned int ysize=get_local_size(1);\n"
"int xBase, yBase, k;\n"
"float2 c_halfWin = (float2)((c_winSize_x - 1)>>1, (c_winSize_y - 1)>>1);\n"
"const int tid = mad24(yid, xsize, xid);\n"
"float2 nextPt = prevPts[gid]/(float2)(1<<level);\n"
"if (nextPt.x < 0 || nextPt.x >= cols || nextPt.y < 0 || nextPt.y >= rows)\n"
"{\n"
"if (tid == 0 && level == 0)\n"
"{\n"
"status[gid] = 0;\n"
"}\n"
"return;\n"
"}\n"
"nextPt -= c_halfWin;\n"
"float A11 = 0.0f;\n"
"float A12 = 0.0f;\n"
"float A22 = 0.0f;\n"
"float4 I_patch[8];\n"
"float4 dIdx_patch[8];\n"
"float4 dIdy_patch[8];\n"
"float4 I_add,Dx_add,Dy_add;\n"
"yBase=yid;\n"
"{\n"
"xBase=xid;\n"
"SetPatch4(I, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[0], &dIdx_patch[0], &dIdy_patch[0],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"SetPatch4(I, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[1], &dIdx_patch[1], &dIdy_patch[1],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"SetPatch4(I, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[2], &dIdx_patch[2], &dIdy_patch[2],\n"
"&A11, &A12, &A22);\n"
"}\n"
"yBase+=ysize;\n"
"{\n"
"xBase=xid;\n"
"SetPatch4(I, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[3], &dIdx_patch[3], &dIdy_patch[3],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"SetPatch4(I, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[4], &dIdx_patch[4], &dIdy_patch[4],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"SetPatch4(I, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[5], &dIdx_patch[5], &dIdy_patch[5],\n"
"&A11, &A12, &A22);\n"
"}\n"
"yBase+=ysize;\n"
"if(yBase<c_winSize_y)\n"
"{\n"
"xBase=xid;\n"
"SetPatch4(I, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[6], &dIdx_patch[6], &dIdy_patch[6],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"SetPatch4(I, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[7], &dIdx_patch[7], &dIdy_patch[7],\n"
"&A11, &A12, &A22);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"SetPatch4(I, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_add, &Dx_add, &Dy_add,\n"
"&A11, &A12, &A22);\n"
"}\n"
"reduce3(A11, A12, A22, smem1, smem2, smem3, tid);\n"
"A11 = smem1[0];\n"
"A12 = smem2[0];\n"
"A22 = smem3[0];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"float D = A11 * A22 - A12 * A12;\n"
"if (D < 1.192092896e-07f)\n"
"{\n"
"if (tid == 0 && level == 0)\n"
"status[gid] = 0;\n"
"return;\n"
"}\n"
"A11 /= D;\n"
"A12 /= D;\n"
"A22 /= D;\n"
"nextPt = nextPts[gid] * 2.0f - c_halfWin;\n"
"for (k = 0; k < c_iters; ++k)\n"
"{\n"
"if (nextPt.x < -c_halfWin.x || nextPt.x >= cols || nextPt.y < -c_halfWin.y || nextPt.y >= rows)\n"
"{\n"
"if (tid == 0 && level == 0)\n"
"status[gid] = 0;\n"
"return;\n"
"}\n"
"float b1 = 0;\n"
"float b2 = 0;\n"
"yBase=yid;\n"
"{\n"
"xBase=xid;\n"
"GetPatch4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[0], &dIdx_patch[0], &dIdy_patch[0],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"GetPatch4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[1], &dIdx_patch[1], &dIdy_patch[1],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetPatch4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[2], &dIdx_patch[2], &dIdy_patch[2],\n"
"&b1, &b2);\n"
"}\n"
"yBase+=ysize;\n"
"{\n"
"xBase=xid;\n"
"GetPatch4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[3], &dIdx_patch[3], &dIdy_patch[3],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"GetPatch4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[4], &dIdx_patch[4], &dIdy_patch[4],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetPatch4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[5], &dIdx_patch[5], &dIdy_patch[5],\n"
"&b1, &b2);\n"
"}\n"
"yBase+=ysize;\n"
"if(yBase<c_winSize_y)\n"
"{\n"
"xBase=xid;\n"
"GetPatch4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[6], &dIdx_patch[6], &dIdy_patch[6],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"GetPatch4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[7], &dIdx_patch[7], &dIdy_patch[7],\n"
"&b1, &b2);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetPatch4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_add, &Dx_add, &Dy_add,\n"
"&b1, &b2);\n"
"}\n"
"reduce2(b1, b2, smem1, smem2, tid);\n"
"b1 = smem1[0];\n"
"b2 = smem2[0];\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"float2 delta;\n"
"delta.x = A12 * b2 - A22 * b1;\n"
"delta.y = A12 * b1 - A11 * b2;\n"
"nextPt +=delta;\n"
"if (fabs(delta.x) < THRESHOLD && fabs(delta.y) < THRESHOLD)\n"
"break;\n"
"}\n"
"D = 0.0f;\n"
"if (calcErr)\n"
"{\n"
"yBase=yid;\n"
"{\n"
"xBase=xid;\n"
"GetError4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[0], &D);\n"
"xBase+=xsize;\n"
"GetError4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[1], &D);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetError4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[2], &D);\n"
"}\n"
"yBase+=ysize;\n"
"{\n"
"xBase=xid;\n"
"GetError4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[3], &D);\n"
"xBase+=xsize;\n"
"GetError4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[4], &D);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetError4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[5], &D);\n"
"}\n"
"yBase+=ysize;\n"
"if(yBase<c_winSize_y)\n"
"{\n"
"xBase=xid;\n"
"GetError4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[6], &D);\n"
"xBase+=xsize;\n"
"GetError4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_patch[7], &D);\n"
"xBase+=xsize;\n"
"if(xBase<c_winSize_x)\n"
"GetError4(J, nextPt.x + xBase + 0.5f, nextPt.y + yBase + 0.5f,\n"
"&I_add, &D);\n"
"}\n"
"reduce1(D, smem1, tid);\n"
"}\n"
"if (tid == 0)\n"
"{\n"
"nextPt += c_halfWin;\n"
"nextPts[gid] = nextPt;\n"
"if (calcErr)\n"
"err[gid] = smem1[0] / (float)(3 * c_winSize_x * c_winSize_y);\n"
"}\n"
"}\n"
"__kernel void lkDense_C1_D0(image2d_t I, image2d_t J, __global float* u, int uStep, __global float* v, int vStep, __global const float* prevU, int prevUStep, __global const float* prevV, int prevVStep,\n"
"const int rows, const int cols,  int c_winSize_x, int c_winSize_y, int c_iters, char calcErr)\n"
"{\n"
"int c_halfWin_x = (c_winSize_x - 1) / 2;\n"
"int c_halfWin_y = (c_winSize_y - 1) / 2;\n"
"const int patchWidth  = get_local_size(0) + 2 * c_halfWin_x;\n"
"const int patchHeight = get_local_size(1) + 2 * c_halfWin_y;\n"
"__local int smem[8192];\n"
"__local int* I_patch = smem;\n"
"__local int* dIdx_patch = I_patch + patchWidth * patchHeight;\n"
"__local int* dIdy_patch = dIdx_patch + patchWidth * patchHeight;\n"
"const int xBase = get_group_id(0) * get_local_size(0);\n"
"const int yBase = get_group_id(1) * get_local_size(1);\n"
"sampler_t sampleri    = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;\n"
"for (int i = get_local_id(1); i < patchHeight; i += get_local_size(1))\n"
"{\n"
"for (int j = get_local_id(0); j < patchWidth; j += get_local_size(0))\n"
"{\n"
"float x = xBase - c_halfWin_x + j + 0.5f;\n"
"float y = yBase - c_halfWin_y + i + 0.5f;\n"
"I_patch[i * patchWidth + j] = read_imagei(I, sampleri, (float2)(x, y)).x;\n"
"dIdx_patch[i * patchWidth + j] = 3 * read_imagei(I, sampleri, (float2)(x+1, y-1)).x + 10 * read_imagei(I, sampleri, (float2)(x+1, y)).x + 3 * read_imagei(I, sampleri, (float2)(x+1, y+1)).x -\n"
"(3 * read_imagei(I, sampleri, (float2)(x-1, y-1)).x + 10 * read_imagei(I, sampleri, (float2)(x-1, y)).x + 3 * read_imagei(I, sampleri, (float2)(x-1, y+1)).x);\n"
"dIdy_patch[i * patchWidth + j] = 3 * read_imagei(I, sampleri, (float2)(x-1, y+1)).x + 10 * read_imagei(I, sampleri, (float2)(x, y+1)).x + 3 * read_imagei(I, sampleri, (float2)(x+1, y+1)).x -\n"
"(3 * read_imagei(I, sampleri, (float2)(x-1, y-1)).x + 10 * read_imagei(I, sampleri, (float2)(x, y-1)).x + 3 * read_imagei(I, sampleri, (float2)(x+1, y-1)).x);\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"const int x = get_global_id(0);\n"
"const int y = get_global_id(1);\n"
"if (x >= cols || y >= rows)\n"
"return;\n"
"int A11i = 0;\n"
"int A12i = 0;\n"
"int A22i = 0;\n"
"for (int i = 0; i < c_winSize_y; ++i)\n"
"{\n"
"for (int j = 0; j < c_winSize_x; ++j)\n"
"{\n"
"int dIdx = dIdx_patch[(get_local_id(1) + i) * patchWidth + (get_local_id(0) + j)];\n"
"int dIdy = dIdy_patch[(get_local_id(1) + i) * patchWidth + (get_local_id(0) + j)];\n"
"A11i += dIdx * dIdx;\n"
"A12i += dIdx * dIdy;\n"
"A22i += dIdy * dIdy;\n"
"}\n"
"}\n"
"float A11 = A11i;\n"
"float A12 = A12i;\n"
"float A22 = A22i;\n"
"float D = A11 * A22 - A12 * A12;\n"
"if (D < 1.192092896e-07f)\n"
"{\n"
"return;\n"
"}\n"
"D = 1.f / D;\n"
"A11 *= D;\n"
"A12 *= D;\n"
"A22 *= D;\n"
"float2 nextPt;\n"
"nextPt.x = x + prevU[y/2 * prevUStep / 4 + x/2] * 2.0f;\n"
"nextPt.y = y + prevV[y/2 * prevVStep / 4 + x/2] * 2.0f;\n"
"for (int k = 0; k < c_iters; ++k)\n"
"{\n"
"if (nextPt.x < 0 || nextPt.x >= cols || nextPt.y < 0 || nextPt.y >= rows)\n"
"{\n"
"return;\n"
"}\n"
"int b1 = 0;\n"
"int b2 = 0;\n"
"for (int i = 0; i < c_winSize_y; ++i)\n"
"{\n"
"for (int j = 0; j < c_winSize_x; ++j)\n"
"{\n"
"int iI = I_patch[(get_local_id(1) + i) * patchWidth + get_local_id(0) + j];\n"
"int iJ = read_imagei(J, sampler, (float2)(nextPt.x - c_halfWin_x + j + 0.5f, nextPt.y - c_halfWin_y + i + 0.5f)).x;\n"
"int diff = (iJ - iI) * 32;\n"
"int dIdx = dIdx_patch[(get_local_id(1) + i) * patchWidth + (get_local_id(0) + j)];\n"
"int dIdy = dIdy_patch[(get_local_id(1) + i) * patchWidth + (get_local_id(0) + j)];\n"
"b1 += diff * dIdx;\n"
"b2 += diff * dIdy;\n"
"}\n"
"}\n"
"float2 delta;\n"
"delta.x = A12 * b2 - A22 * b1;\n"
"delta.y = A12 * b1 - A11 * b2;\n"
"nextPt.x += delta.x;\n"
"nextPt.y += delta.y;\n"
"if (fabs(delta.x) < 0.01f && fabs(delta.y) < 0.01f)\n"
"break;\n"
"}\n"
"u[y * uStep / 4 + x] = nextPt.x - x;\n"
"v[y * vStep / 4 + x] = nextPt.y - y;\n"
"if (calcErr)\n"
"{\n"
"int errval = 0;\n"
"for (int i = 0; i < c_winSize_y; ++i)\n"
"{\n"
"for (int j = 0; j < c_winSize_x; ++j)\n"
"{\n"
"int iI = I_patch[(get_local_id(1) + i) * patchWidth + get_local_id(0) + j];\n"
"int iJ = read_imagei(J, sampler, (float2)(nextPt.x - c_halfWin_x + j + 0.5f, nextPt.y - c_halfWin_y + i + 0.5f)).x;\n"
"errval += abs(iJ - iI);\n"
"}\n"
"}\n"
"}\n"
"}\n"
, "516e74880f1fd439f623e7b83bfb3b37"};
const struct ProgramEntry split_mat={"split_mat",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#if DATA_DEPTH == 0\n"
"#define BASE_TYPE uchar\n"
"#elif DATA_DEPTH == 1\n"
"#error data_depth char, use uchar datatype instead\n"
"#elif DATA_DEPTH == 2\n"
"#define BASE_TYPE ushort\n"
"#elif DATA_DEPTH == 3\n"
"#error data_depth short, use ushort datatype instead\n"
"#elif DATA_DEPTH == 4\n"
"#define BASE_TYPE int\n"
"#elif DATA_DEPTH == 5\n"
"#define BASE_TYPE float\n"
"#elif DATA_DEPTH == 6\n"
"#define BASE_TYPE double\n"
"#else\n"
"#error data_depth\n"
"#endif\n"
"#if DATA_CHAN == 2\n"
"#define SRC_VEC_SIZE 2\n"
"#elif DATA_CHAN == 3\n"
"#define SRC_VEC_SIZE 4\n"
"#elif DATA_CHAN == 4\n"
"#define SRC_VEC_SIZE 4\n"
"#else\n"
"#error data_chan\n"
"#endif\n"
"#define __CAT(x, y) x##y\n"
"#define CAT(x, y) __CAT(x, y)\n"
"#define uchar1 uchar\n"
"#define char1 char\n"
"#define ushort1 ushort\n"
"#define short1 short\n"
"#define int1 int\n"
"#define float1 float\n"
"#define double1 double\n"
"#define TYPE BASE_TYPE\n"
"#define SRC_TYPE CAT(BASE_TYPE, SRC_VEC_SIZE)\n"
"#define DST_VEC_TYPE CAT(BASE_TYPE, VEC_SIZE)\n"
"#define vstore1 vstore\n"
"#define VSTORE CAT(vstore, VEC_SIZE)\n"
"#define VSTORE_ALIGNED(ptr, v) *((__global DST_VEC_TYPE*)(ptr)) = (v)\n"
"#define VSTORE_UNALIGNED(ptr, v) VSTORE((v), 0, (__global TYPE*)(ptr))\n"
"#ifdef DST0_ALIGNED\n"
"#define VSTORE_dst0 VSTORE_ALIGNED\n"
"#else\n"
"#define VSTORE_dst0 VSTORE_UNALIGNED\n"
"#endif\n"
"#ifdef DST1_ALIGNED\n"
"#define VSTORE_dst1 VSTORE_ALIGNED\n"
"#else\n"
"#define VSTORE_dst1 VSTORE_UNALIGNED\n"
"#endif\n"
"#ifdef DST2_ALIGNED\n"
"#define VSTORE_dst2 VSTORE_ALIGNED\n"
"#else\n"
"#define VSTORE_dst2 VSTORE_UNALIGNED\n"
"#endif\n"
"#ifdef DST3_ALIGNED\n"
"#define VSTORE_dst3 VSTORE_ALIGNED\n"
"#else\n"
"#define VSTORE_dst3 VSTORE_UNALIGNED\n"
"#endif\n"
"__kernel void split_vector(\n"
"__global SRC_TYPE* src, int srcStepBytes, int2 srcOffset,\n"
"__global TYPE* dst0, int dst0StepBytes, int2 dst0Offset,\n"
"__global TYPE* dst1, int dst1StepBytes, int2 dst1Offset,\n"
"#if DATA_CHAN > 2\n"
"__global TYPE* dst2, int dst2StepBytes, int2 dst2Offset,\n"
"#endif\n"
"#if DATA_CHAN > 3\n"
"__global TYPE* dst3, int dst3StepBytes, int2 dst3Offset,\n"
"#endif\n"
"int2 size)\n"
"{\n"
"int x = get_global_id(0) * VEC_SIZE;\n"
"int y = get_global_id(1);\n"
"if (x < size.x && y < size.y)\n"
"{\n"
"SRC_TYPE srcData[VEC_SIZE];\n"
"int xOffsetLimitBytes = srcOffset.x + size.x * sizeof(SRC_TYPE);\n"
"int xOffsetBytes = srcOffset.x + x * sizeof(SRC_TYPE);\n"
"int yOffsetBytes = (srcOffset.y + y) * srcStepBytes;\n"
"#pragma unroll\n"
"for (int i = 0; i < VEC_SIZE; i++, xOffsetBytes += sizeof(SRC_TYPE))\n"
"{\n"
"srcData[i] = (xOffsetBytes >= xOffsetLimitBytes) ? (SRC_TYPE)0 :\n"
"*(__global SRC_TYPE*)((__global char*)src + yOffsetBytes + xOffsetBytes);\n"
"}\n"
"#if VEC_SIZE == 1\n"
"TYPE dstC0 = srcData[0].s0;\n"
"TYPE dstC1 = srcData[0].s1;\n"
"#if DATA_CHAN > 2\n"
"TYPE dstC2 = srcData[0].s2;\n"
"#endif\n"
"#if DATA_CHAN > 3\n"
"TYPE dstC3 = srcData[0].s3;\n"
"#endif\n"
"# define VEC_TO_ARRAY(v, a) TYPE a[1] = {v};\n"
"#elif VEC_SIZE == 2\n"
"DST_VEC_TYPE dstC0 = (DST_VEC_TYPE)(srcData[0].s0, srcData[1].s0);\n"
"DST_VEC_TYPE dstC1 = (DST_VEC_TYPE)(srcData[0].s1, srcData[1].s1);\n"
"#if DATA_CHAN > 2\n"
"DST_VEC_TYPE dstC2 = (DST_VEC_TYPE)(srcData[0].s2, srcData[1].s2);\n"
"#endif\n"
"#if DATA_CHAN > 3\n"
"DST_VEC_TYPE dstC3 = (DST_VEC_TYPE)(srcData[0].s3, srcData[1].s3);\n"
"#endif\n"
"# define VEC_TO_ARRAY(v, a) TYPE a[2] = {v.s0, v.s1};\n"
"#elif VEC_SIZE == 4\n"
"DST_VEC_TYPE dstC0 = (DST_VEC_TYPE)(srcData[0].s0, srcData[1].s0, srcData[2].s0, srcData[3].s0);\n"
"DST_VEC_TYPE dstC1 = (DST_VEC_TYPE)(srcData[0].s1, srcData[1].s1, srcData[2].s1, srcData[3].s1);\n"
"#if DATA_CHAN > 2\n"
"DST_VEC_TYPE dstC2 = (DST_VEC_TYPE)(srcData[0].s2, srcData[1].s2, srcData[2].s2, srcData[3].s2);\n"
"#endif\n"
"#if DATA_CHAN > 3\n"
"DST_VEC_TYPE dstC3 = (DST_VEC_TYPE)(srcData[0].s3, srcData[1].s3, srcData[2].s3, srcData[3].s3);\n"
"#endif\n"
"# define VEC_TO_ARRAY(v, a) TYPE a[4] = {v.s0, v.s1, v.s2, v.s3};\n"
"#endif\n"
"#ifndef BYPASS_VSTORE\n"
"#define BYPASS_VSTORE false\n"
"#endif\n"
"#define WRITE_VEC_DST(dst, vecValue) \\\n"
"{ \\\n"
"int dst ## xOffsetLimitBytes = dst ## Offset.x + size.x * sizeof(TYPE); \\\n"
"int dst ## xOffsetBytes = dst ## Offset.x + x * sizeof(TYPE); \\\n"
"int dst ## yOffsetBytes = (dst ## Offset.y + y) * dst ## StepBytes; \\\n"
"if (!BYPASS_VSTORE && dst ## xOffsetBytes + (int)sizeof(DST_VEC_TYPE) <= dst ## xOffsetLimitBytes) \\\n"
"{ \\\n"
"VSTORE_ ## dst(((__global char*)dst + dst ## yOffsetBytes + dst ## xOffsetBytes), vecValue); \\\n"
"} \\\n"
"else \\\n"
"{ \\\n"
"VEC_TO_ARRAY(vecValue, vecValue##Array); \\\n"
"for (int i = 0; i < VEC_SIZE; i++, dst ## xOffsetBytes += sizeof(TYPE)) \\\n"
"{ \\\n"
"if (dst ## xOffsetBytes + (int)sizeof(TYPE) <= dst ## xOffsetLimitBytes) \\\n"
"*(__global TYPE*)((__global char*)dst + dst ## yOffsetBytes + dst ## xOffsetBytes) = vecValue##Array[i]; \\\n"
"else \\\n"
"break; \\\n"
"} \\\n"
"} \\\n"
"}\n"
"WRITE_VEC_DST(dst0, dstC0);\n"
"WRITE_VEC_DST(dst1, dstC1);\n"
"#if DATA_CHAN > 2\n"
"WRITE_VEC_DST(dst2, dstC2);\n"
"#endif\n"
"#if DATA_CHAN > 3\n"
"WRITE_VEC_DST(dst3, dstC3);\n"
"#endif\n"
"}\n"
"}\n"
, "8689026266644305bc75b3f61ac6d027"};
const struct ProgramEntry stereobm={"stereobm",
"#define ROWSperTHREAD 21\n"
"#define BLOCK_W       128\n"
"#define N_DISPARITIES 8\n"
"#define STEREO_MIND 0\n"
"#define STEREO_DISP_STEP N_DISPARITIES\n"
"#ifndef radius\n"
"#define radius 64\n"
"#endif\n"
"unsigned int CalcSSD(__local unsigned int *col_ssd)\n"
"{\n"
"unsigned int cache = col_ssd[0];\n"
"#pragma unroll\n"
"for(int i = 1; i <= (radius << 1); i++)\n"
"cache += col_ssd[i];\n"
"return cache;\n"
"}\n"
"uint2 MinSSD(__local unsigned int *col_ssd)\n"
"{\n"
"unsigned int ssd[N_DISPARITIES];\n"
"const int win_size = (radius << 1);\n"
"ssd[0] = CalcSSD(col_ssd + 0 * (BLOCK_W + win_size));\n"
"ssd[1] = CalcSSD(col_ssd + 1 * (BLOCK_W + win_size));\n"
"ssd[2] = CalcSSD(col_ssd + 2 * (BLOCK_W + win_size));\n"
"ssd[3] = CalcSSD(col_ssd + 3 * (BLOCK_W + win_size));\n"
"ssd[4] = CalcSSD(col_ssd + 4 * (BLOCK_W + win_size));\n"
"ssd[5] = CalcSSD(col_ssd + 5 * (BLOCK_W + win_size));\n"
"ssd[6] = CalcSSD(col_ssd + 6 * (BLOCK_W + win_size));\n"
"ssd[7] = CalcSSD(col_ssd + 7 * (BLOCK_W + win_size));\n"
"unsigned int mssd = min(min(min(ssd[0], ssd[1]), min(ssd[4], ssd[5])), min(min(ssd[2], ssd[3]), min(ssd[6], ssd[7])));\n"
"int bestIdx = 0;\n"
"for (int i = 0; i < N_DISPARITIES; i++)\n"
"{\n"
"if (mssd == ssd[i])\n"
"bestIdx = i;\n"
"}\n"
"return (uint2)(mssd, bestIdx);\n"
"}\n"
"void StepDown(int idx1, int idx2, __global unsigned char* imageL,\n"
"__global unsigned char* imageR, int d,   __local unsigned int *col_ssd)\n"
"{\n"
"uint8 imgR1 = convert_uint8(vload8(0, imageR + (idx1 - d - 7)));\n"
"uint8 imgR2 = convert_uint8(vload8(0, imageR + (idx2 - d - 7)));\n"
"uint8 diff1 = (uint8)(imageL[idx1]) - imgR1;\n"
"uint8 diff2 = (uint8)(imageL[idx2]) - imgR2;\n"
"uint8 res = diff2 * diff2 - diff1 * diff1;\n"
"const int win_size = (radius << 1);\n"
"col_ssd[0 * (BLOCK_W + win_size)] += res.s7;\n"
"col_ssd[1 * (BLOCK_W + win_size)] += res.s6;\n"
"col_ssd[2 * (BLOCK_W + win_size)] += res.s5;\n"
"col_ssd[3 * (BLOCK_W + win_size)] += res.s4;\n"
"col_ssd[4 * (BLOCK_W + win_size)] += res.s3;\n"
"col_ssd[5 * (BLOCK_W + win_size)] += res.s2;\n"
"col_ssd[6 * (BLOCK_W + win_size)] += res.s1;\n"
"col_ssd[7 * (BLOCK_W + win_size)] += res.s0;\n"
"}\n"
"void InitColSSD(int x_tex, int y_tex, int im_pitch, __global unsigned char* imageL,\n"
"__global unsigned char* imageR, int d,\n"
"__local unsigned int *col_ssd)\n"
"{\n"
"uint8 leftPixel1;\n"
"uint8 diffa = 0;\n"
"int idx = y_tex * im_pitch + x_tex;\n"
"const int win_size = (radius << 1);\n"
"for(int i = 0; i < (win_size + 1); i++)\n"
"{\n"
"leftPixel1 = (uint8)(imageL[idx]);\n"
"uint8 imgR = convert_uint8(vload8(0, imageR + (idx - d - 7)));\n"
"uint8 res = leftPixel1 - imgR;\n"
"diffa += res * res;\n"
"idx += im_pitch;\n"
"}\n"
"col_ssd[0 * (BLOCK_W + win_size)] = diffa.s7;\n"
"col_ssd[1 * (BLOCK_W + win_size)] = diffa.s6;\n"
"col_ssd[2 * (BLOCK_W + win_size)] = diffa.s5;\n"
"col_ssd[3 * (BLOCK_W + win_size)] = diffa.s4;\n"
"col_ssd[4 * (BLOCK_W + win_size)] = diffa.s3;\n"
"col_ssd[5 * (BLOCK_W + win_size)] = diffa.s2;\n"
"col_ssd[6 * (BLOCK_W + win_size)] = diffa.s1;\n"
"col_ssd[7 * (BLOCK_W + win_size)] = diffa.s0;\n"
"}\n"
"__kernel void stereoKernel(__global unsigned char *left, __global unsigned char *right,\n"
"__global unsigned int *cminSSDImage, int cminSSD_step,\n"
"__global unsigned char *disp, int disp_step,int cwidth, int cheight,\n"
"int img_step, int maxdisp,\n"
"__local unsigned int *col_ssd_cache)\n"
"{\n"
"__local unsigned int *col_ssd = col_ssd_cache + get_local_id(0);\n"
"__local unsigned int *col_ssd_extra = get_local_id(0) < (radius << 1) ? col_ssd + BLOCK_W : 0;\n"
"int X = get_group_id(0) * BLOCK_W + get_local_id(0) + maxdisp + radius;\n"
"#define Y (int)(get_group_id(1) * ROWSperTHREAD + radius)\n"
"__global unsigned int* minSSDImage = cminSSDImage + X + Y * cminSSD_step;\n"
"__global unsigned char* disparImage = disp + X + Y * disp_step;\n"
"int end_row = ROWSperTHREAD < (cheight - Y) ? ROWSperTHREAD:(cheight - Y);\n"
"int y_tex;\n"
"int x_tex = X - radius;\n"
"for(int d = STEREO_MIND; d < maxdisp; d += STEREO_DISP_STEP)\n"
"{\n"
"y_tex = Y - radius;\n"
"InitColSSD(x_tex, y_tex, img_step, left, right, d, col_ssd);\n"
"if (col_ssd_extra > 0)\n"
"if (x_tex + BLOCK_W < cwidth)\n"
"InitColSSD(x_tex + BLOCK_W, y_tex, img_step, left, right, d, col_ssd_extra);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"uint2 minSSD = MinSSD(col_ssd);\n"
"if (X < cwidth - radius && Y < cheight - radius)\n"
"{\n"
"if (minSSD.x < minSSDImage[0])\n"
"{\n"
"disparImage[0] = (unsigned char)(d + minSSD.y);\n"
"minSSDImage[0] = minSSD.x;\n"
"}\n"
"}\n"
"for(int row = 1; row < end_row; row++)\n"
"{\n"
"int idx1 = y_tex * img_step + x_tex;\n"
"int idx2 = min(y_tex + ((radius << 1) + 1), cheight - 1) * img_step + x_tex;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"StepDown(idx1, idx2, left, right, d, col_ssd);\n"
"if (col_ssd_extra > 0)\n"
"if (x_tex + BLOCK_W < cwidth)\n"
"StepDown(idx1, idx2, left + BLOCK_W, right + BLOCK_W, d, col_ssd_extra);\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"uint2 minSSD = MinSSD(col_ssd);\n"
"if (X < cwidth - radius && row < cheight - radius - Y)\n"
"{\n"
"int idx = row * cminSSD_step;\n"
"if (minSSD.x < minSSDImage[idx])\n"
"{\n"
"disparImage[disp_step * row] = (unsigned char)(d + minSSD.y);\n"
"minSSDImage[idx] = minSSD.x;\n"
"}\n"
"}\n"
"y_tex++;\n"
"}\n"
"}\n"
"}\n"
"__kernel void prefilter_xsobel(__global unsigned char *input, __global unsigned char *output,\n"
"int rows, int cols, int prefilterCap)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < cols && y < rows)\n"
"{\n"
"int cov = input[(y-1) * cols + (x-1)] * (-1) + input[(y-1) * cols + (x+1)] * (1) +\n"
"input[(y)   * cols + (x-1)] * (-2) + input[(y)   * cols + (x+1)] * (2) +\n"
"input[(y+1) * cols + (x-1)] * (-1) + input[(y+1) * cols + (x+1)] * (1);\n"
"cov = min(min(max(-prefilterCap, cov), prefilterCap) + prefilterCap, 255);\n"
"output[y * cols + x] = cov & 0xFF;\n"
"}\n"
"}\n"
"float sobel(__global unsigned char *input, int x, int y, int rows, int cols)\n"
"{\n"
"float conv = 0;\n"
"int y1 = y==0? 0 : y-1;\n"
"int x1 = x==0? 0 : x-1;\n"
"if(x < cols && y < rows && x > 0 && y > 0)\n"
"{\n"
"conv = (float)input[(y1)  * cols + (x1)] * (-1) + (float)input[(y1)  * cols + (x+1)] * (1) +\n"
"(float)input[(y)   * cols + (x1)] * (-2) + (float)input[(y)   * cols + (x+1)] * (2) +\n"
"(float)input[(y+1) * cols + (x1)] * (-1) + (float)input[(y+1) * cols + (x+1)] * (1);\n"
"}\n"
"return fabs(conv);\n"
"}\n"
"float CalcSums(__local float *cols, __local float *cols_cache, int winsz)\n"
"{\n"
"unsigned int cache = cols[0];\n"
"for(int i = 1; i <= winsz; i++)\n"
"cache += cols[i];\n"
"return cache;\n"
"}\n"
"#define RpT (2 * ROWSperTHREAD)\n"
"__kernel void textureness_kernel(__global unsigned char *disp, int disp_rows, int disp_cols,\n"
"int disp_step, __global unsigned char *input, int input_rows,\n"
"int input_cols,int winsz, float threshold,\n"
"__local float *cols_cache)\n"
"{\n"
"int winsz2 = winsz/2;\n"
"int n_dirty_pixels = (winsz2) * 2;\n"
"int local_id_x = get_local_id(0);\n"
"int group_size_x = get_local_size(0);\n"
"int group_id_y = get_group_id(1);\n"
"__local float *cols = cols_cache + group_size_x + local_id_x;\n"
"__local float *cols_extra = local_id_x < n_dirty_pixels ? cols + group_size_x : 0;\n"
"int x = get_global_id(0);\n"
"int beg_row = group_id_y * RpT;\n"
"int end_row = min(beg_row + RpT, disp_rows);\n"
"int y = beg_row;\n"
"float sum = 0;\n"
"float sum_extra = 0;\n"
"for(int i = y - winsz2; i <= y + winsz2; ++i)\n"
"{\n"
"sum += sobel(input, x - winsz2, i, input_rows, input_cols);\n"
"if (cols_extra)\n"
"sum_extra += sobel(input, x + group_size_x - winsz2, i, input_rows, input_cols);\n"
"}\n"
"*cols = sum;\n"
"if (cols_extra)\n"
"*cols_extra = sum_extra;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"float sum_win = CalcSums(cols, cols_cache + local_id_x, winsz) * 255;\n"
"if (sum_win < threshold)\n"
"disp[y * disp_step + x] = 0;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"for(int y = beg_row + 1; y < end_row; ++y)\n"
"{\n"
"sum = sum - sobel(input, x - winsz2, y - winsz2 - 1, input_rows, input_cols) +\n"
"sobel(input, x - winsz2, y + winsz2, input_rows, input_cols);\n"
"*cols = sum;\n"
"if (cols_extra)\n"
"{\n"
"sum_extra = sum_extra - sobel(input, x + group_size_x - winsz2, y - winsz2 - 1,input_rows, input_cols)\n"
"+ sobel(input, x + group_size_x - winsz2, y + winsz2, input_rows, input_cols);\n"
"*cols_extra = sum_extra;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if (x < disp_cols)\n"
"{\n"
"float sum_win = CalcSums(cols, cols_cache + local_id_x, winsz) * 255;\n"
"if (sum_win < threshold)\n"
"disp[y * disp_step + x] = 0;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"}\n"
"}\n"
, "5dcc7a3ab0f93796613f382a3c29d5fc"};
const struct ProgramEntry stereobp={"stereobp",
"#if defined (DOUBLE_SUPPORT)\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#endif\n"
"#ifdef T_FLOAT\n"
"#define T float\n"
"#define T4 float4\n"
"#else\n"
"#define T short\n"
"#define T4 short4\n"
"#endif\n"
"T saturate_cast(float v){\n"
"#ifdef T_SHORT\n"
"return convert_short_sat_rte(v);\n"
"#else\n"
"return v;\n"
"#endif\n"
"}\n"
"T4 saturate_cast4(float4 v){\n"
"#ifdef T_SHORT\n"
"return convert_short4_sat_rte(v);\n"
"#else\n"
"return v;\n"
"#endif\n"
"}\n"
"#define FLOAT_MAX 3.402823466e+38f\n"
"typedef struct\n"
"{\n"
"int   cndisp;\n"
"float cmax_data_term;\n"
"float cdata_weight;\n"
"float cmax_disc_term;\n"
"float cdisc_single_jump;\n"
"}con_srtuct_t;\n"
"float pix_diff_1(const uchar4 l, __global const uchar *rs)\n"
"{\n"
"return abs((int)(l.x) - *rs);\n"
"}\n"
"float pix_diff_4(const uchar4 l, __global const uchar *rs)\n"
"{\n"
"uchar4 r;\n"
"r = *((__global uchar4 *)rs);\n"
"const float tr = 0.299f;\n"
"const float tg = 0.587f;\n"
"const float tb = 0.114f;\n"
"float val;\n"
"val  = tb * abs((int)l.x - r.x);\n"
"val += tg * abs((int)l.y - r.y);\n"
"val += tr * abs((int)l.z - r.z);\n"
"return val;\n"
"}\n"
"float pix_diff_3(const uchar4 l, __global const uchar *rs)\n"
"{\n"
"return pix_diff_4(l, rs);\n"
"}\n"
"#ifndef CN\n"
"#define CN 4\n"
"#endif\n"
"#ifndef CNDISP\n"
"#define CNDISP 64\n"
"#endif\n"
"#define CAT(X,Y) X##Y\n"
"#define CAT2(X,Y) CAT(X,Y)\n"
"#define PIX_DIFF CAT2(pix_diff_, CN)\n"
"__kernel void comp_data(__global uchar *left,  int left_rows,  int left_cols,  int left_step,\n"
"__global uchar *right, int right_step,\n"
"__global T *data, int data_step,\n"
"__constant con_srtuct_t *con_st)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y > 0 && y < (left_rows - 1) && x > 0 && x < (left_cols - 1))\n"
"{\n"
"data_step /= sizeof(T);\n"
"const __global uchar* ls = left  + y * left_step  + x * CN;\n"
"const __global uchar* rs = right + y * right_step + x * CN;\n"
"__global T *ds = data + y * data_step + x;\n"
"const unsigned int disp_step = data_step * left_rows;\n"
"const float weightXterm = con_st -> cdata_weight * con_st -> cmax_data_term;\n"
"const uchar4 ls_data = vload4(0, ls);\n"
"for (int disp = 0; disp < con_st -> cndisp; disp++)\n"
"{\n"
"if (x - disp >= 1)\n"
"{\n"
"float val = 0;\n"
"val = PIX_DIFF(ls_data, rs - disp * CN);\n"
"ds[disp * disp_step] =  saturate_cast(fmin(con_st -> cdata_weight * val, weightXterm));\n"
"}\n"
"else\n"
"{\n"
"ds[disp * disp_step] =  saturate_cast(weightXterm);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"__kernel void data_step_down(__global T *src, int src_rows,\n"
"__global T *dst, int dst_rows, int dst_cols,\n"
"int src_step, int dst_step,\n"
"int cndisp)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"src_step /= sizeof(T);\n"
"dst_step /= sizeof(T);\n"
"int4 coor_step = (int4)(src_rows * src_step);\n"
"int4 coor = (int4)(min(2*y+0, src_rows-1) * src_step + 2*x+0,\n"
"min(2*y+1, src_rows-1) * src_step + 2*x+0,\n"
"min(2*y+0, src_rows-1) * src_step + 2*x+1,\n"
"min(2*y+1, src_rows-1) * src_step + 2*x+1);\n"
"for (int d = 0; d < cndisp; ++d)\n"
"{\n"
"float dst_reg;\n"
"dst_reg  = src[coor.x];\n"
"dst_reg += src[coor.y];\n"
"dst_reg += src[coor.z];\n"
"dst_reg += src[coor.w];\n"
"coor += coor_step;\n"
"dst[(d * dst_rows + y) * dst_step + x] = saturate_cast(dst_reg);\n"
"}\n"
"}\n"
"}\n"
"__kernel void level_up_message(__global T *src, int src_rows, int src_step,\n"
"__global T *dst, int dst_rows, int dst_cols, int dst_step,\n"
"int cndisp)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_global_id(1);\n"
"if (x < dst_cols && y < dst_rows)\n"
"{\n"
"src_step /= sizeof(T);\n"
"dst_step /= sizeof(T);\n"
"const int dst_disp_step = dst_step * dst_rows;\n"
"const int src_disp_step = src_step * src_rows;\n"
"__global T       *dstr = dst + y * dst_step + x;\n"
"__global const T *srcr = src + (y / 2 * src_step) + (x / 2);\n"
"for (int d = 0; d < cndisp; ++d)\n"
"dstr[d * dst_disp_step] = srcr[d * src_disp_step];\n"
"}\n"
"}\n"
"void message(__global T *us_, __global T *ds_, __global T *ls_, __global T *rs_,\n"
"const __global T *dt,\n"
"int u_step, int msg_disp_step, int data_disp_step,\n"
"float4 cmax_disc_term, float4 cdisc_single_jump)\n"
"{\n"
"__global T *us = us_ + u_step;\n"
"__global T *ds = ds_ - u_step;\n"
"__global T *ls = ls_ + 1;\n"
"__global T *rs = rs_ - 1;\n"
"float4 minimum = (float4)(FLOAT_MAX);\n"
"T4 t_dst[CNDISP];\n"
"float4 dst_reg;\n"
"float4 prev;\n"
"float4 cur;\n"
"T t_us = us[0];\n"
"T t_ds = ds[0];\n"
"T t_ls = ls[0];\n"
"T t_rs = rs[0];\n"
"T t_dt = dt[0];\n"
"prev = (float4)(t_us + t_ls + t_rs + t_dt,\n"
"t_ds + t_ls + t_rs + t_dt,\n"
"t_us + t_ds + t_rs + t_dt,\n"
"t_us + t_ds + t_ls + t_dt);\n"
"minimum = min(prev, minimum);\n"
"t_dst[0] = saturate_cast4(prev);\n"
"for(int i = 1, idx = msg_disp_step; i < CNDISP; ++i, idx+=msg_disp_step)\n"
"{\n"
"t_us = us[idx];\n"
"t_ds = ds[idx];\n"
"t_ls = ls[idx];\n"
"t_rs = rs[idx];\n"
"t_dt = dt[data_disp_step * i];\n"
"dst_reg = (float4)(t_us + t_ls + t_rs + t_dt,\n"
"t_ds + t_ls + t_rs + t_dt,\n"
"t_us + t_ds + t_rs + t_dt,\n"
"t_us + t_ds + t_ls + t_dt);\n"
"minimum = min(dst_reg, minimum);\n"
"prev += cdisc_single_jump;\n"
"prev = min(prev, dst_reg);\n"
"t_dst[i] = saturate_cast4(prev);\n"
"}\n"
"minimum += cmax_disc_term;\n"
"float4 sum = (float4)(0);\n"
"prev = convert_float4(t_dst[CNDISP - 1]);\n"
"for (int disp = CNDISP - 2; disp >= 0; disp--)\n"
"{\n"
"prev += cdisc_single_jump;\n"
"cur = convert_float4(t_dst[disp]);\n"
"prev = min(prev, cur);\n"
"cur = min(prev, minimum);\n"
"sum += cur;\n"
"t_dst[disp] = saturate_cast4(cur);\n"
"}\n"
"dst_reg = convert_float4(t_dst[CNDISP - 1]);\n"
"dst_reg = min(dst_reg, minimum);\n"
"t_dst[CNDISP - 1] = saturate_cast4(dst_reg);\n"
"sum += dst_reg;\n"
"sum /= (float4)(CNDISP);\n"
"#pragma unroll\n"
"for(int i = 0, idx = 0; i < CNDISP; ++i, idx+=msg_disp_step)\n"
"{\n"
"T4 dst = t_dst[i];\n"
"us_[idx] = dst.x - sum.x;\n"
"ds_[idx] = dst.y - sum.y;\n"
"rs_[idx] = dst.z - sum.z;\n"
"ls_[idx] = dst.w - sum.w;\n"
"}\n"
"}\n"
"__kernel void one_iteration(__global T *u,    int u_step,\n"
"__global T *data, int data_step,\n"
"__global T *d,    __global T *l, __global T *r,\n"
"int t, int cols, int rows,\n"
"float cmax_disc_term, float cdisc_single_jump)\n"
"{\n"
"const int y = get_global_id(1);\n"
"const int x = ((get_global_id(0)) << 1) + ((y + t) & 1);\n"
"if ((y > 0) && (y < rows - 1) && (x > 0) && (x < cols - 1))\n"
"{\n"
"u_step    /= sizeof(T);\n"
"data_step /= sizeof(T);\n"
"__global T *us = u + y * u_step + x;\n"
"__global T *ds = d + y * u_step + x;\n"
"__global T *ls = l + y * u_step + x;\n"
"__global T *rs = r + y * u_step + x;\n"
"const __global  T *dt = data + y * data_step + x;\n"
"int msg_disp_step = u_step * rows;\n"
"int data_disp_step = data_step * rows;\n"
"message(us, ds, ls, rs, dt,\n"
"u_step, msg_disp_step, data_disp_step,\n"
"(float4)(cmax_disc_term), (float4)(cdisc_single_jump));\n"
"}\n"
"}\n"
"__kernel void output(const __global T *u, int u_step,\n"
"const __global T *d, const __global T *l,\n"
"const __global T *r, const __global T *data,\n"
"__global T *disp, int disp_rows, int disp_cols, int disp_step,\n"
"int cndisp)\n"
"{\n"
"const int x = get_global_id(0);\n"
"const int y = get_global_id(1);\n"
"if (y > 0 && y < disp_rows - 1 && x > 0 && x < disp_cols - 1)\n"
"{\n"
"u_step    /= sizeof(T);\n"
"disp_step /= sizeof(T);\n"
"const __global T *us = u + (y + 1) * u_step + x;\n"
"const __global T *ds = d + (y - 1) * u_step + x;\n"
"const __global T *ls = l + y * u_step + (x + 1);\n"
"const __global T *rs = r + y * u_step + (x - 1);\n"
"const __global T *dt = data + y * u_step + x;\n"
"int disp_steps = disp_rows * u_step;\n"
"int best = 0;\n"
"float best_val = FLOAT_MAX;\n"
"for (int d = 0; d < cndisp; ++d)\n"
"{\n"
"float val;\n"
"val  = us[d * disp_steps];\n"
"val += ds[d * disp_steps];\n"
"val += ls[d * disp_steps];\n"
"val += rs[d * disp_steps];\n"
"val += dt[d * disp_steps];\n"
"if (val < best_val)\n"
"{\n"
"best_val = val;\n"
"best = d;\n"
"}\n"
"}\n"
"(disp + y * disp_step)[x] = convert_short_sat(best);\n"
"}\n"
"}\n"
, "c1f26bdbf3637f3bf83d2d9b7adc3c2b"};
const struct ProgramEntry stereocsbp={"stereocsbp",
"__kernel void get_first_k_initial_global_0(__global short *data_cost_selected_, __global short *selected_disp_pyr,\n"
"__global short *ctemp, int h, int w, int nr_plane,\n"
"int cmsg_step1, int cdisp_step1, int cndisp)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < h && x < w)\n"
"{\n"
"__global short *selected_disparity = selected_disp_pyr      + y * cmsg_step1 + x;\n"
"__global short *data_cost_selected = data_cost_selected_    + y * cmsg_step1 + x;\n"
"__global short *data_cost          = ctemp + y * cmsg_step1 + x;\n"
"for(int i = 0; i < nr_plane; i++)\n"
"{\n"
"short minimum = SHRT_MAX;\n"
"int id = 0;\n"
"for(int d = 0; d < cndisp; d++)\n"
"{\n"
"short cur = data_cost[d * cdisp_step1];\n"
"if(cur < minimum)\n"
"{\n"
"minimum = cur;\n"
"id = d;\n"
"}\n"
"}\n"
"data_cost_selected[i  * cdisp_step1] = minimum;\n"
"selected_disparity[i  * cdisp_step1] = id;\n"
"data_cost         [id * cdisp_step1] = SHRT_MAX;\n"
"}\n"
"}\n"
"}\n"
"__kernel void get_first_k_initial_global_1(__global  float *data_cost_selected_, __global float *selected_disp_pyr,\n"
"__global  float *ctemp, int h, int w, int nr_plane,\n"
"int cmsg_step1, int cdisp_step1, int cndisp)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < h && x < w)\n"
"{\n"
"__global   float *selected_disparity = selected_disp_pyr      + y * cmsg_step1 + x;\n"
"__global   float *data_cost_selected = data_cost_selected_    + y * cmsg_step1 + x;\n"
"__global   float *data_cost          = ctemp + y * cmsg_step1 + x;\n"
"for(int i = 0; i < nr_plane; i++)\n"
"{\n"
"float minimum = FLT_MAX;\n"
"int id = 0;\n"
"for(int d = 0; d < cndisp; d++)\n"
"{\n"
"float cur = data_cost[d * cdisp_step1];\n"
"if(cur < minimum)\n"
"{\n"
"minimum = cur;\n"
"id = d;\n"
"}\n"
"}\n"
"data_cost_selected[i  * cdisp_step1] = minimum;\n"
"selected_disparity[i  * cdisp_step1] = id;\n"
"data_cost         [id * cdisp_step1] = FLT_MAX;\n"
"}\n"
"}\n"
"}\n"
"__kernel void get_first_k_initial_local_0(__global  short *data_cost_selected_, __global short *selected_disp_pyr,\n"
"__global  short *ctemp,int h, int w, int nr_plane,\n"
"int cmsg_step1, int cdisp_step1, int cndisp)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < h && x < w)\n"
"{\n"
"__global short *selected_disparity = selected_disp_pyr   + y * cmsg_step1 + x;\n"
"__global short *data_cost_selected = data_cost_selected_ + y * cmsg_step1 + x;\n"
"__global short *data_cost = ctemp + y * cmsg_step1 + x;\n"
"int nr_local_minimum = 0;\n"
"short prev = data_cost[0 * cdisp_step1];\n"
"short cur  = data_cost[1 * cdisp_step1];\n"
"short next = data_cost[2 * cdisp_step1];\n"
"for (int d = 1; d < cndisp - 1 && nr_local_minimum < nr_plane; d++)\n"
"{\n"
"if (cur < prev && cur < next)\n"
"{\n"
"data_cost_selected[nr_local_minimum * cdisp_step1] = cur;\n"
"selected_disparity[nr_local_minimum * cdisp_step1] = d;\n"
"data_cost[d * cdisp_step1] = SHRT_MAX;\n"
"nr_local_minimum++;\n"
"}\n"
"prev = cur;\n"
"cur = next;\n"
"next = data_cost[(d + 1) * cdisp_step1];\n"
"}\n"
"for (int i = nr_local_minimum; i < nr_plane; i++)\n"
"{\n"
"short minimum = SHRT_MAX;\n"
"int id = 0;\n"
"for (int d = 0; d < cndisp; d++)\n"
"{\n"
"cur = data_cost[d * cdisp_step1];\n"
"if (cur < minimum)\n"
"{\n"
"minimum = cur;\n"
"id = d;\n"
"}\n"
"}\n"
"data_cost_selected[i * cdisp_step1] = minimum;\n"
"selected_disparity[i * cdisp_step1] = id;\n"
"data_cost[id * cdisp_step1] = SHRT_MAX;\n"
"}\n"
"}\n"
"}\n"
"__kernel void get_first_k_initial_local_1(__global float *data_cost_selected_, __global float *selected_disp_pyr,\n"
"__global float *ctemp,int h, int w, int nr_plane,\n"
"int cmsg_step1,  int cdisp_step1, int cndisp)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < h && x < w)\n"
"{\n"
"__global float *selected_disparity = selected_disp_pyr   + y * cmsg_step1 + x;\n"
"__global float *data_cost_selected = data_cost_selected_ + y * cmsg_step1 + x;\n"
"__global float *data_cost = ctemp + y * cmsg_step1 + x;\n"
"int nr_local_minimum = 0;\n"
"float prev = data_cost[0 * cdisp_step1];\n"
"float cur  = data_cost[1 * cdisp_step1];\n"
"float next = data_cost[2 * cdisp_step1];\n"
"for (int d = 1; d < cndisp - 1 && nr_local_minimum < nr_plane; d++)\n"
"{\n"
"if (cur < prev && cur < next)\n"
"{\n"
"data_cost_selected[nr_local_minimum * cdisp_step1] = cur;\n"
"selected_disparity[nr_local_minimum * cdisp_step1] = d;\n"
"data_cost[d * cdisp_step1] = FLT_MAX ;\n"
"nr_local_minimum++;\n"
"}\n"
"prev = cur;\n"
"cur = next;\n"
"next = data_cost[(d + 1) * cdisp_step1];\n"
"}\n"
"for (int i = nr_local_minimum; i < nr_plane; i++)\n"
"{\n"
"float minimum = FLT_MAX;\n"
"int id = 0;\n"
"for (int d = 0; d < cndisp; d++)\n"
"{\n"
"cur = data_cost[d * cdisp_step1];\n"
"if (cur < minimum)\n"
"{\n"
"minimum = cur;\n"
"id = d;\n"
"}\n"
"}\n"
"data_cost_selected[i * cdisp_step1] = minimum;\n"
"selected_disparity[i * cdisp_step1] = id;\n"
"data_cost[id * cdisp_step1] = FLT_MAX;\n"
"}\n"
"}\n"
"}\n"
"float compute_3(__global uchar* left, __global uchar* right,\n"
"float cdata_weight,  float cmax_data_term)\n"
"{\n"
"float tb = 0.114f * abs((int)left[0] - right[0]);\n"
"float tg = 0.587f * abs((int)left[1] - right[1]);\n"
"float tr = 0.299f * abs((int)left[2] - right[2]);\n"
"return fmin(cdata_weight * (tr + tg + tb), cdata_weight * cmax_data_term);\n"
"}\n"
"float compute_1(__global uchar* left, __global uchar* right,\n"
"float cdata_weight,  float cmax_data_term)\n"
"{\n"
"return fmin(cdata_weight * abs((int)*left - (int)*right), cdata_weight * cmax_data_term);\n"
"}\n"
"short round_short(float v)\n"
"{\n"
"return convert_short_sat_rte(v);\n"
"}\n"
"__kernel void init_data_cost_0(__global short *ctemp, __global uchar *cleft, __global uchar *cright,\n"
"int h, int w, int level, int channels,\n"
"int cmsg_step1, float cdata_weight, float cmax_data_term, int cdisp_step1,\n"
"int cth, int cimg_step, int cndisp)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < h && x < w)\n"
"{\n"
"int y0 = y << level;\n"
"int yt = (y + 1) << level;\n"
"int x0 = x << level;\n"
"int xt = (x + 1) << level;\n"
"__global short *data_cost = ctemp + y * cmsg_step1 + x;\n"
"for(int d = 0; d < cndisp; ++d)\n"
"{\n"
"float val = 0.0f;\n"
"for(int yi = y0; yi < yt; yi++)\n"
"{\n"
"for(int xi = x0; xi < xt; xi++)\n"
"{\n"
"int xr = xi - d;\n"
"if(d < cth || xr < 0)\n"
"val += cdata_weight * cmax_data_term;\n"
"else\n"
"{\n"
"__global uchar *lle = cleft  + yi * cimg_step + xi * channels;\n"
"__global uchar *lri = cright + yi * cimg_step + xr * channels;\n"
"if(channels == 1)\n"
"val += compute_1(lle, lri, cdata_weight, cmax_data_term);\n"
"else\n"
"val += compute_3(lle, lri, cdata_weight, cmax_data_term);\n"
"}\n"
"}\n"
"}\n"
"data_cost[cdisp_step1 * d] = round_short(val);\n"
"}\n"
"}\n"
"}\n"
"__kernel void init_data_cost_1(__global float *ctemp, __global uchar *cleft, __global uchar *cright,\n"
"int h, int w, int level, int channels,\n"
"int cmsg_step1, float cdata_weight, float cmax_data_term, int cdisp_step1,\n"
"int cth, int cimg_step, int cndisp)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < h && x < w)\n"
"{\n"
"int y0 = y << level;\n"
"int yt = (y + 1) << level;\n"
"int x0 = x << level;\n"
"int xt = (x + 1) << level;\n"
"__global float *data_cost = ctemp + y * cmsg_step1 + x;\n"
"for(int d = 0; d < cndisp; ++d)\n"
"{\n"
"float val = 0.0f;\n"
"for(int yi = y0; yi < yt; yi++)\n"
"{\n"
"for(int xi = x0; xi < xt; xi++)\n"
"{\n"
"int xr = xi - d;\n"
"if(d < cth || xr < 0)\n"
"val += cdata_weight * cmax_data_term;\n"
"else\n"
"{\n"
"__global uchar* lle = cleft  + yi * cimg_step + xi * channels;\n"
"__global uchar* lri = cright + yi * cimg_step + xr * channels;\n"
"if(channels == 1)\n"
"val += compute_1(lle, lri, cdata_weight, cmax_data_term);\n"
"else\n"
"val += compute_3(lle, lri, cdata_weight, cmax_data_term);\n"
"}\n"
"}\n"
"}\n"
"data_cost[cdisp_step1 * d] = val;\n"
"}\n"
"}\n"
"}\n"
"__kernel void init_data_cost_reduce_0(__global short *ctemp, __global uchar *cleft, __global uchar *cright,\n"
"__local float *smem, int level, int rows, int cols, int h, int winsz, int channels,\n"
"int cndisp,int cimg_step, float cdata_weight, float cmax_data_term, int cth,\n"
"int cdisp_step1, int cmsg_step1)\n"
"{\n"
"int x_out = get_group_id(0);\n"
"int y_out = get_group_id(1) % h;\n"
"int d = (get_group_id(1) / h ) * get_local_size(2) + get_local_id(2);\n"
"int tid = get_local_id(0);\n"
"if (d < cndisp)\n"
"{\n"
"int x0 = x_out << level;\n"
"int y0 = y_out << level;\n"
"int len = min(y0 + winsz, rows) - y0;\n"
"float val = 0.0f;\n"
"if (x0 + tid < cols)\n"
"{\n"
"if (x0 + tid - d < 0 || d < cth)\n"
"val = cdata_weight * cmax_data_term * len;\n"
"else\n"
"{\n"
"__global uchar* lle =  cleft + y0 * cimg_step + channels * (x0 + tid    );\n"
"__global uchar* lri = cright + y0 * cimg_step + channels * (x0 + tid - d);\n"
"for(int y = 0; y < len; ++y)\n"
"{\n"
"if(channels == 1)\n"
"val += compute_1(lle, lri, cdata_weight, cmax_data_term);\n"
"else\n"
"val += compute_3(lle, lri, cdata_weight, cmax_data_term);\n"
"lle += cimg_step;\n"
"lri += cimg_step;\n"
"}\n"
"}\n"
"}\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"dline[tid] = val;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 256)\n"
"{\n"
"if (tid < 128)\n"
"dline[tid] += dline[tid + 128];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 128)\n"
"{\n"
"if (tid <  64)\n"
"dline[tid] += dline[tid + 64];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 64)\n"
"if (tid < 32)\n"
"vdline[tid] += vdline[tid + 32];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 32)\n"
"if (tid < 16)\n"
"vdline[tid] += vdline[tid + 16];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d<cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 16)\n"
"if (tid <  8)\n"
"vdline[tid] += vdline[tid + 8];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d<cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 8)\n"
"if (tid <  4)\n"
"vdline[tid] += vdline[tid + 4];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d<cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 4)\n"
"if (tid <  2)\n"
"vdline[tid] += vdline[tid + 2];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d<cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 2)\n"
"if (tid <  1)\n"
"vdline[tid] += vdline[tid + 1];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"__global short* data_cost = ctemp + y_out * cmsg_step1 + x_out;\n"
"if (tid == 0)\n"
"data_cost[cdisp_step1 * d] = convert_short_sat_rte(dline[0]);\n"
"}\n"
"}\n"
"__kernel void init_data_cost_reduce_1(__global float *ctemp, __global uchar *cleft, __global uchar *cright,\n"
"__local float *smem, int level, int rows, int cols, int h, int winsz, int channels,\n"
"int cndisp,int cimg_step, float cdata_weight, float cmax_data_term, int cth,\n"
"int cdisp_step1, int cmsg_step1)\n"
"{\n"
"int x_out = get_group_id(0);\n"
"int y_out = get_group_id(1) % h;\n"
"int d = (get_group_id(1) / h ) * get_local_size(2) + get_local_id(2);\n"
"int tid = get_local_id(0);\n"
"if (d < cndisp)\n"
"{\n"
"int x0 = x_out << level;\n"
"int y0 = y_out << level;\n"
"int len = min(y0 + winsz, rows) - y0;\n"
"float val = 0.0f;\n"
"if (x0 + tid < cols)\n"
"{\n"
"if (x0 + tid - d < 0 || d < cth)\n"
"val = cdata_weight * cmax_data_term * len;\n"
"else\n"
"{\n"
"__global uchar* lle =  cleft + y0 * cimg_step + channels * (x0 + tid    );\n"
"__global uchar* lri = cright + y0 * cimg_step + channels * (x0 + tid - d);\n"
"for(int y = 0; y < len; ++y)\n"
"{\n"
"if(channels == 1)\n"
"val += compute_1(lle, lri, cdata_weight, cmax_data_term);\n"
"else\n"
"val += compute_3(lle, lri, cdata_weight, cmax_data_term);\n"
"lle += cimg_step;\n"
"lri += cimg_step;\n"
"}\n"
"}\n"
"}\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"dline[tid] = val;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 256)\n"
"if (tid < 128)\n"
"dline[tid] += dline[tid + 128];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 128)\n"
"if (tid < 64)\n"
"dline[tid] += dline[tid + 64];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 64)\n"
"if (tid < 32)\n"
"vdline[tid] += vdline[tid + 32];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 32)\n"
"if (tid < 16)\n"
"vdline[tid] += vdline[tid + 16];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 16)\n"
"if (tid < 8)\n"
"vdline[tid] += vdline[tid + 8];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 8)\n"
"if (tid < 4)\n"
"vdline[tid] += vdline[tid + 4];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 4)\n"
"if (tid < 2)\n"
"vdline[tid] += vdline[tid + 2];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 2)\n"
"if (tid < 1)\n"
"vdline[tid] += vdline[tid + 1];\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < cndisp)\n"
"{\n"
"__global float *data_cost = ctemp + y_out * cmsg_step1 + x_out;\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"if (tid == 0)\n"
"data_cost[cdisp_step1 * d] =  dline[0];\n"
"}\n"
"}\n"
"__kernel void compute_data_cost_0(__global const short *selected_disp_pyr, __global short *data_cost_,\n"
"__global uchar *cleft, __global uchar *cright,\n"
"int h, int w, int level, int nr_plane, int channels,\n"
"int cmsg_step1, int cmsg_step2, int cdisp_step1, int cdisp_step2, float cdata_weight,\n"
"float cmax_data_term, int cimg_step, int cth)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < h && x < w)\n"
"{\n"
"int y0 = y << level;\n"
"int yt = (y + 1) << level;\n"
"int x0 = x << level;\n"
"int xt = (x + 1) << level;\n"
"__global const short *selected_disparity = selected_disp_pyr + y/2 * cmsg_step2 + x/2;\n"
"__global       short *data_cost          = data_cost_ + y * cmsg_step1 + x;\n"
"for(int d = 0; d < nr_plane; d++)\n"
"{\n"
"float val = 0.0f;\n"
"for(int yi = y0; yi < yt; yi++)\n"
"{\n"
"for(int xi = x0; xi < xt; xi++)\n"
"{\n"
"int sel_disp = selected_disparity[d * cdisp_step2];\n"
"int xr = xi - sel_disp;\n"
"if (xr < 0 || sel_disp < cth)\n"
"val += cdata_weight * cmax_data_term;\n"
"else\n"
"{\n"
"__global uchar* left_x  = cleft + yi * cimg_step + xi * channels;\n"
"__global uchar* right_x = cright + yi * cimg_step + xr * channels;\n"
"if(channels == 1)\n"
"val += compute_1(left_x, right_x, cdata_weight, cmax_data_term);\n"
"else\n"
"val += compute_3(left_x, right_x, cdata_weight, cmax_data_term);\n"
"}\n"
"}\n"
"}\n"
"data_cost[cdisp_step1 * d] = convert_short_sat_rte(val);\n"
"}\n"
"}\n"
"}\n"
"__kernel void compute_data_cost_1(__global const float *selected_disp_pyr, __global float *data_cost_,\n"
"__global uchar *cleft, __global uchar *cright,\n"
"int h, int w, int level, int nr_plane, int channels,\n"
"int cmsg_step1, int cmsg_step2, int cdisp_step1, int cdisp_step2, float cdata_weight,\n"
"float cmax_data_term, int cimg_step, int cth)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < h && x < w)\n"
"{\n"
"int y0 = y << level;\n"
"int yt = (y + 1) << level;\n"
"int x0 = x << level;\n"
"int xt = (x + 1) << level;\n"
"__global const float *selected_disparity = selected_disp_pyr + y/2 * cmsg_step2 + x/2;\n"
"__global       float *data_cost          = data_cost_ + y * cmsg_step1 + x;\n"
"for(int d = 0; d < nr_plane; d++)\n"
"{\n"
"float val = 0.0f;\n"
"for(int yi = y0; yi < yt; yi++)\n"
"{\n"
"for(int xi = x0; xi < xt; xi++)\n"
"{\n"
"int sel_disp = selected_disparity[d * cdisp_step2];\n"
"int xr = xi - sel_disp;\n"
"if (xr < 0 || sel_disp < cth)\n"
"val += cdata_weight * cmax_data_term;\n"
"else\n"
"{\n"
"__global uchar* left_x  = cleft + yi * cimg_step + xi * channels;\n"
"__global uchar* right_x = cright + yi * cimg_step + xr * channels;\n"
"if(channels == 1)\n"
"val += compute_1(left_x, right_x, cdata_weight, cmax_data_term);\n"
"else\n"
"val += compute_3(left_x, right_x, cdata_weight, cmax_data_term);\n"
"}\n"
"}\n"
"}\n"
"data_cost[cdisp_step1 * d] = val;\n"
"}\n"
"}\n"
"}\n"
"__kernel void compute_data_cost_reduce_0(__global const short* selected_disp_pyr, __global short* data_cost_,\n"
"__global uchar *cleft, __global uchar *cright,__local float *smem,\n"
"int level, int rows, int cols, int h, int nr_plane,\n"
"int channels, int winsz,\n"
"int cmsg_step1, int cmsg_step2, int cdisp_step1, int cdisp_step2,\n"
"float cdata_weight,  float cmax_data_term, int cimg_step,int cth)\n"
"{\n"
"int x_out = get_group_id(0);\n"
"int y_out = get_group_id(1) % h;\n"
"int d = (get_group_id(1)/ h) * get_local_size(2) + get_local_id(2);\n"
"int tid = get_local_id(0);\n"
"__global const short* selected_disparity = selected_disp_pyr + y_out/2 * cmsg_step2 + x_out/2;\n"
"__global short* data_cost = data_cost_ + y_out * cmsg_step1 + x_out;\n"
"if (d < nr_plane)\n"
"{\n"
"int sel_disp = selected_disparity[d * cdisp_step2];\n"
"int x0 = x_out << level;\n"
"int y0 = y_out << level;\n"
"int len = min(y0 + winsz, rows) - y0;\n"
"float val = 0.0f;\n"
"if (x0 + tid < cols)\n"
"{\n"
"if (x0 + tid - sel_disp < 0 || sel_disp < cth)\n"
"val = cdata_weight * cmax_data_term * len;\n"
"else\n"
"{\n"
"__global uchar* lle =  cleft + y0 * cimg_step + channels * (x0 + tid    );\n"
"__global uchar* lri = cright + y0 * cimg_step + channels * (x0 + tid - sel_disp);\n"
"for(int y = 0; y < len; ++y)\n"
"{\n"
"if(channels == 1)\n"
"val += compute_1(lle, lri, cdata_weight, cmax_data_term);\n"
"else\n"
"val += compute_3(lle, lri, cdata_weight, cmax_data_term);\n"
"lle += cimg_step;\n"
"lri += cimg_step;\n"
"}\n"
"}\n"
"}\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"dline[tid] = val;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 64)\n"
"{\n"
"if (tid < 32)\n"
"vdline[tid] += vdline[tid + 32];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 32)\n"
"{\n"
"if (tid < 16)\n"
"vdline[tid] += vdline[tid + 16];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 16)\n"
"{\n"
"if (tid < 8)\n"
"vdline[tid] += vdline[tid + 8];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 8)\n"
"{\n"
"if (tid < 4)\n"
"vdline[tid] += vdline[tid + 4];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 4)\n"
"{\n"
"if (tid < 2)\n"
"vdline[tid] += vdline[tid + 2];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 2)\n"
"{\n"
"if (tid < 1)\n"
"vdline[tid] += vdline[tid + 1];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (tid == 0)\n"
"data_cost[cdisp_step1 * d] = convert_short_sat_rte(vdline[0]);\n"
"}\n"
"}\n"
"__kernel void compute_data_cost_reduce_1(__global const float *selected_disp_pyr, __global float *data_cost_,\n"
"__global uchar *cleft, __global uchar *cright, __local float *smem,\n"
"int level, int rows, int cols, int h, int nr_plane,\n"
"int channels, int winsz,\n"
"int cmsg_step1, int cmsg_step2, int cdisp_step1,int cdisp_step2, float cdata_weight,\n"
"float cmax_data_term, int cimg_step, int cth)\n"
"{\n"
"int x_out = get_group_id(0);\n"
"int y_out = get_group_id(1) % h;\n"
"int d = (get_group_id(1)/ h) * get_local_size(2) + get_local_id(2);\n"
"int tid = get_local_id(0);\n"
"__global const float *selected_disparity = selected_disp_pyr + y_out/2 * cmsg_step2 + x_out/2;\n"
"__global float *data_cost = data_cost_ + y_out * cmsg_step1 + x_out;\n"
"if (d < nr_plane)\n"
"{\n"
"int sel_disp = selected_disparity[d * cdisp_step2];\n"
"int x0 = x_out << level;\n"
"int y0 = y_out << level;\n"
"int len = min(y0 + winsz, rows) - y0;\n"
"float val = 0.0f;\n"
"if (x0 + tid < cols)\n"
"{\n"
"if (x0 + tid - sel_disp < 0 || sel_disp < cth)\n"
"val = cdata_weight * cmax_data_term * len;\n"
"else\n"
"{\n"
"__global uchar* lle =  cleft + y0 * cimg_step + channels * (x0 + tid    );\n"
"__global uchar* lri = cright + y0 * cimg_step + channels * (x0 + tid - sel_disp);\n"
"for(int y = 0; y < len; ++y)\n"
"{\n"
"if(channels == 1)\n"
"val += compute_1(lle, lri, cdata_weight, cmax_data_term);\n"
"else\n"
"val += compute_3(lle, lri, cdata_weight, cmax_data_term);\n"
"lle += cimg_step;\n"
"lri += cimg_step;\n"
"}\n"
"}\n"
"}\n"
"__local float* dline = smem + winsz * get_local_id(2);\n"
"dline[tid] = val;\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 64)\n"
"{\n"
"if (tid < 32)\n"
"vdline[tid] += vdline[tid + 32];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 32)\n"
"{\n"
"if (tid < 16)\n"
"vdline[tid] += vdline[tid + 16];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >= 16)\n"
"{\n"
"if (tid <  8)\n"
"vdline[tid] += vdline[tid + 8];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >=  8)\n"
"{\n"
"if (tid <  4)\n"
"vdline[tid] += vdline[tid + 4];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >=  4)\n"
"{\n"
"if (tid <  2)\n"
"vdline[tid] += vdline[tid + 2];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (winsz >=  2)\n"
"{\n"
"if (tid <  1)\n"
"vdline[tid] += vdline[tid + 1];\n"
"}\n"
"}\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(d < nr_plane)\n"
"{\n"
"__local volatile float* vdline = smem + winsz * get_local_id(2);\n"
"if (tid == 0)\n"
"data_cost[cdisp_step1 * d] = vdline[0];\n"
"}\n"
"}\n"
"void get_first_k_element_increase_0(__global short* u_new, __global short *d_new, __global short *l_new,\n"
"__global short *r_new, __global const short *u_cur, __global const short *d_cur,\n"
"__global const short *l_cur, __global const short *r_cur,\n"
"__global short *data_cost_selected, __global short *disparity_selected_new,\n"
"__global short *data_cost_new, __global const short* data_cost_cur,\n"
"__global const short *disparity_selected_cur,\n"
"int nr_plane, int nr_plane2,\n"
"int cdisp_step1, int cdisp_step2)\n"
"{\n"
"for(int i = 0; i < nr_plane; i++)\n"
"{\n"
"short minimum = SHRT_MAX;\n"
"int id = 0;\n"
"for(int j = 0; j < nr_plane2; j++)\n"
"{\n"
"short cur = data_cost_new[j * cdisp_step1];\n"
"if(cur < minimum)\n"
"{\n"
"minimum = cur;\n"
"id = j;\n"
"}\n"
"}\n"
"data_cost_selected[i * cdisp_step1] = data_cost_cur[id * cdisp_step1];\n"
"disparity_selected_new[i * cdisp_step1] = disparity_selected_cur[id * cdisp_step2];\n"
"u_new[i * cdisp_step1] = u_cur[id * cdisp_step2];\n"
"d_new[i * cdisp_step1] = d_cur[id * cdisp_step2];\n"
"l_new[i * cdisp_step1] = l_cur[id * cdisp_step2];\n"
"r_new[i * cdisp_step1] = r_cur[id * cdisp_step2];\n"
"data_cost_new[id * cdisp_step1] = SHRT_MAX;\n"
"}\n"
"}\n"
"__kernel void init_message_0(__global short *u_new_, __global short *d_new_, __global short *l_new_,\n"
"__global short *r_new_, __global  short *u_cur_, __global const short *d_cur_,\n"
"__global const short *l_cur_, __global const short *r_cur_, __global short *ctemp,\n"
"__global short *selected_disp_pyr_new, __global const short *selected_disp_pyr_cur,\n"
"__global short *data_cost_selected_, __global const short *data_cost_,\n"
"int h, int w, int nr_plane, int h2, int w2, int nr_plane2,\n"
"int cdisp_step1, int cdisp_step2, int cmsg_step1, int cmsg_step2)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y < h && x < w)\n"
"{\n"
"__global const short *u_cur = u_cur_ + min(h2-1, y/2 + 1) * cmsg_step2 + x/2;\n"
"__global const short *d_cur = d_cur_ + max(0, y/2 - 1)    * cmsg_step2 + x/2;\n"
"__global const short *l_cur = l_cur_ + y/2                * cmsg_step2 + min(w2-1, x/2 + 1);\n"
"__global const short *r_cur = r_cur_ + y/2                * cmsg_step2 + max(0, x/2 - 1);\n"
"__global short *data_cost_new = ctemp + y * cmsg_step1 + x;\n"
"__global const short *disparity_selected_cur = selected_disp_pyr_cur + y/2 * cmsg_step2 + x/2;\n"
"__global const short *data_cost = data_cost_ + y * cmsg_step1 + x;\n"
"for(int d = 0; d < nr_plane2; d++)\n"
"{\n"
"int idx2 = d * cdisp_step2;\n"
"short val  = data_cost[d * cdisp_step1] + u_cur[idx2] + d_cur[idx2] + l_cur[idx2] + r_cur[idx2];\n"
"data_cost_new[d * cdisp_step1] = val;\n"
"}\n"
"__global short *data_cost_selected = data_cost_selected_ + y * cmsg_step1 + x;\n"
"__global short *disparity_selected_new = selected_disp_pyr_new + y * cmsg_step1 + x;\n"
"__global short *u_new = u_new_ + y * cmsg_step1 + x;\n"
"__global short *d_new = d_new_ + y * cmsg_step1 + x;\n"
"__global short *l_new = l_new_ + y * cmsg_step1 + x;\n"
"__global short *r_new = r_new_ + y * cmsg_step1 + x;\n"
"u_cur = u_cur_ + y/2 * cmsg_step2 + x/2;\n"
"d_cur = d_cur_ + y/2 * cmsg_step2 + x/2;\n"
"l_cur = l_cur_ + y/2 * cmsg_step2 + x/2;\n"
"r_cur = r_cur_ + y/2 * cmsg_step2 + x/2;\n"
"get_first_k_element_increase_0(u_new, d_new, l_new, r_new, u_cur, d_cur, l_cur, r_cur,\n"
"data_cost_selected, disparity_selected_new, data_cost_new,\n"
"data_cost, disparity_selected_cur, nr_plane, nr_plane2,\n"
"cdisp_step1, cdisp_step2);\n"
"}\n"
"}\n"
"__kernel void init_message_1(__global float *u_new_, __global float *d_new_, __global float *l_new_,\n"
"__global float *r_new_, __global const float *u_cur_, __global const float *d_cur_,\n"
"__global const float *l_cur_, __global const float *r_cur_, __global float *ctemp,\n"
"__global float *selected_disp_pyr_new, __global const float *selected_disp_pyr_cur,\n"
"__global float *data_cost_selected_, __global const float *data_cost_,\n"
"int h, int w, int nr_plane, int h2, int w2, int nr_plane2,\n"
"int cdisp_step1, int cdisp_step2, int cmsg_step1, int cmsg_step2)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"__global const float *u_cur = u_cur_ + min(h2-1, y/2 + 1) * cmsg_step2 + x/2;\n"
"__global const float *d_cur = d_cur_ + max(0, y/2 - 1)    * cmsg_step2 + x/2;\n"
"__global const float *l_cur = l_cur_ + y/2                * cmsg_step2 + min(w2-1, x/2 + 1);\n"
"__global const float *r_cur = r_cur_ + y/2                * cmsg_step2 + max(0, x/2 - 1);\n"
"__global float *data_cost_new = ctemp + y * cmsg_step1 + x;\n"
"__global const float *disparity_selected_cur = selected_disp_pyr_cur + y/2 * cmsg_step2 + x/2;\n"
"__global const float *data_cost = data_cost_ + y * cmsg_step1 + x;\n"
"if (y < h && x < w)\n"
"{\n"
"for(int d = 0; d < nr_plane2; d++)\n"
"{\n"
"int idx2 = d * cdisp_step2;\n"
"float val  = data_cost[d * cdisp_step1] + u_cur[idx2] + d_cur[idx2] + l_cur[idx2] + r_cur[idx2];\n"
"data_cost_new[d * cdisp_step1] = val;\n"
"}\n"
"}\n"
"__global float *data_cost_selected = data_cost_selected_ + y * cmsg_step1 + x;\n"
"__global float *disparity_selected_new = selected_disp_pyr_new + y * cmsg_step1 + x;\n"
"__global float *u_new = u_new_ + y * cmsg_step1 + x;\n"
"__global float *d_new = d_new_ + y * cmsg_step1 + x;\n"
"__global float *l_new = l_new_ + y * cmsg_step1 + x;\n"
"__global float *r_new = r_new_ + y * cmsg_step1 + x;\n"
"barrier(CLK_LOCAL_MEM_FENCE);\n"
"if(y < h && x < w)\n"
"{\n"
"u_cur = u_cur_ + y/2 * cmsg_step2 + x/2;\n"
"d_cur = d_cur_ + y/2 * cmsg_step2 + x/2;\n"
"l_cur = l_cur_ + y/2 * cmsg_step2 + x/2;\n"
"r_cur = r_cur_ + y/2 * cmsg_step2 + x/2;\n"
"for(int i = 0; i < nr_plane; i++)\n"
"{\n"
"float minimum = FLT_MAX;\n"
"int id = 0;\n"
"for(int j = 0; j < nr_plane2; j++)\n"
"{\n"
"float cur = data_cost_new[j * cdisp_step1];\n"
"if(cur < minimum)\n"
"{\n"
"minimum = cur;\n"
"id = j;\n"
"}\n"
"}\n"
"data_cost_selected[i * cdisp_step1] = data_cost[id * cdisp_step1];\n"
"disparity_selected_new[i * cdisp_step1] = disparity_selected_cur[id * cdisp_step2];\n"
"u_new[i * cdisp_step1] = u_cur[id * cdisp_step2];\n"
"d_new[i * cdisp_step1] = d_cur[id * cdisp_step2];\n"
"l_new[i * cdisp_step1] = l_cur[id * cdisp_step2];\n"
"r_new[i * cdisp_step1] = r_cur[id * cdisp_step2];\n"
"data_cost_new[id * cdisp_step1] = FLT_MAX;\n"
"}\n"
"}\n"
"}\n"
"void message_per_pixel_0(__global const short *data, __global short *msg_dst, __global const short *msg1,\n"
"__global const short *msg2, __global const short *msg3,\n"
"__global const short *dst_disp, __global const short *src_disp,\n"
"int nr_plane, __global short *temp,\n"
"float cmax_disc_term, int cdisp_step1, float cdisc_single_jump)\n"
"{\n"
"short minimum = SHRT_MAX;\n"
"for(int d = 0; d < nr_plane; d++)\n"
"{\n"
"int idx = d * cdisp_step1;\n"
"short val  = data[idx] + msg1[idx] + msg2[idx] + msg3[idx];\n"
"if(val < minimum)\n"
"minimum = val;\n"
"msg_dst[idx] = val;\n"
"}\n"
"float sum = 0;\n"
"for(int d = 0; d < nr_plane; d++)\n"
"{\n"
"float cost_min = minimum + cmax_disc_term;\n"
"short src_disp_reg = src_disp[d * cdisp_step1];\n"
"for(int d2 = 0; d2 < nr_plane; d2++)\n"
"cost_min = fmin(cost_min, (msg_dst[d2 * cdisp_step1] +\n"
"cdisc_single_jump * abs(dst_disp[d2 * cdisp_step1] - src_disp_reg)));\n"
"temp[d * cdisp_step1] = convert_short_sat_rte(cost_min);\n"
"sum += cost_min;\n"
"}\n"
"sum /= nr_plane;\n"
"for(int d = 0; d < nr_plane; d++)\n"
"msg_dst[d * cdisp_step1] = convert_short_sat_rte(temp[d * cdisp_step1] - sum);\n"
"}\n"
"void message_per_pixel_1(__global const float *data, __global float *msg_dst, __global const float *msg1,\n"
"__global const float *msg2, __global const float *msg3,\n"
"__global const float *dst_disp, __global const float *src_disp,\n"
"int nr_plane, __global float *temp,\n"
"float cmax_disc_term, int cdisp_step1, float cdisc_single_jump)\n"
"{\n"
"float minimum = FLT_MAX;\n"
"for(int d = 0; d < nr_plane; d++)\n"
"{\n"
"int idx = d * cdisp_step1;\n"
"float val  = data[idx] + msg1[idx] + msg2[idx] + msg3[idx];\n"
"if(val < minimum)\n"
"minimum = val;\n"
"msg_dst[idx] = val;\n"
"}\n"
"float sum = 0;\n"
"for(int d = 0; d < nr_plane; d++)\n"
"{\n"
"float cost_min = minimum + cmax_disc_term;\n"
"float src_disp_reg = src_disp[d * cdisp_step1];\n"
"for(int d2 = 0; d2 < nr_plane; d2++)\n"
"cost_min = fmin(cost_min, (msg_dst[d2 * cdisp_step1] +\n"
"cdisc_single_jump * fabs(dst_disp[d2 * cdisp_step1] - src_disp_reg)));\n"
"temp[d * cdisp_step1] = cost_min;\n"
"sum += cost_min;\n"
"}\n"
"sum /= nr_plane;\n"
"for(int d = 0; d < nr_plane; d++)\n"
"msg_dst[d * cdisp_step1] = temp[d * cdisp_step1] - sum;\n"
"}\n"
"__kernel void compute_message_0(__global short *u_, __global short *d_, __global short *l_, __global short *r_,\n"
"__global const short *data_cost_selected, __global const short *selected_disp_pyr_cur,\n"
"__global short *ctemp, int h, int w, int nr_plane, int i,\n"
"float cmax_disc_term, int cdisp_step1, int cmsg_step1, float cdisc_single_jump)\n"
"{\n"
"int y = get_global_id(1);\n"
"int x = ((get_global_id(0)) << 1) + ((y + i) & 1);\n"
"if (y > 0 && y < h - 1 && x > 0 && x < w - 1)\n"
"{\n"
"__global const short *data = data_cost_selected + y * cmsg_step1 + x;\n"
"__global short *u = u_ + y * cmsg_step1 + x;\n"
"__global short *d = d_ + y * cmsg_step1 + x;\n"
"__global short *l = l_ + y * cmsg_step1 + x;\n"
"__global short *r = r_ + y * cmsg_step1 + x;\n"
"__global const short *disp = selected_disp_pyr_cur + y * cmsg_step1 + x;\n"
"__global short *temp = ctemp + y * cmsg_step1 + x;\n"
"message_per_pixel_0(data, u, r - 1, u + cmsg_step1, l + 1, disp, disp - cmsg_step1, nr_plane, temp,\n"
"cmax_disc_term, cdisp_step1, cdisc_single_jump);\n"
"message_per_pixel_0(data, d, d - cmsg_step1, r - 1, l + 1, disp, disp + cmsg_step1, nr_plane, temp,\n"
"cmax_disc_term, cdisp_step1, cdisc_single_jump);\n"
"message_per_pixel_0(data, l, u + cmsg_step1, d - cmsg_step1, l + 1, disp, disp - 1, nr_plane, temp,\n"
"cmax_disc_term, cdisp_step1, cdisc_single_jump);\n"
"message_per_pixel_0(data, r, u + cmsg_step1, d - cmsg_step1, r - 1, disp, disp + 1, nr_plane, temp,\n"
"cmax_disc_term, cdisp_step1, cdisc_single_jump);\n"
"}\n"
"}\n"
"__kernel void compute_message_1(__global float *u_, __global float *d_, __global float *l_, __global float *r_,\n"
"__global const float *data_cost_selected, __global const float *selected_disp_pyr_cur,\n"
"__global float *ctemp, int h, int w, int nr_plane, int i,\n"
"float cmax_disc_term, int cdisp_step1, int cmsg_step1, float cdisc_single_jump)\n"
"{\n"
"int y = get_global_id(1);\n"
"int x = ((get_global_id(0)) << 1) + ((y + i) & 1);\n"
"if (y > 0 && y < h - 1 && x > 0 && x < w - 1)\n"
"{\n"
"__global const float *data = data_cost_selected + y * cmsg_step1 + x;\n"
"__global float *u = u_ + y * cmsg_step1 + x;\n"
"__global float *d = d_ + y * cmsg_step1 + x;\n"
"__global float *l = l_ + y * cmsg_step1 + x;\n"
"__global float *r = r_ + y * cmsg_step1 + x;\n"
"__global const float *disp = selected_disp_pyr_cur + y * cmsg_step1 + x;\n"
"__global float *temp = ctemp + y * cmsg_step1 + x;\n"
"message_per_pixel_1(data, u, r - 1, u + cmsg_step1, l + 1, disp, disp - cmsg_step1, nr_plane, temp,\n"
"cmax_disc_term, cdisp_step1, cdisc_single_jump);\n"
"message_per_pixel_1(data, d, d - cmsg_step1, r - 1, l + 1, disp, disp + cmsg_step1, nr_plane, temp,\n"
"cmax_disc_term, cdisp_step1, cdisc_single_jump);\n"
"message_per_pixel_1(data, l, u + cmsg_step1, d - cmsg_step1, l + 1, disp, disp - 1, nr_plane, temp,\n"
"cmax_disc_term, cdisp_step1, cdisc_single_jump);\n"
"message_per_pixel_1(data, r, u + cmsg_step1, d - cmsg_step1, r - 1, disp, disp + 1, nr_plane, temp,\n"
"cmax_disc_term, cdisp_step1, cdisc_single_jump);\n"
"}\n"
"}\n"
"__kernel void compute_disp_0(__global const short *u_, __global const short *d_, __global const short *l_,\n"
"__global const short *r_, __global const short * data_cost_selected,\n"
"__global const short *disp_selected_pyr,\n"
"__global short* disp,\n"
"int res_step, int cols, int rows, int nr_plane,\n"
"int cmsg_step1, int cdisp_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y > 0 && y < rows - 1 && x > 0 && x < cols - 1)\n"
"{\n"
"__global const short *data = data_cost_selected + y * cmsg_step1 + x;\n"
"__global const short *disp_selected = disp_selected_pyr + y * cmsg_step1 + x;\n"
"__global const short *u = u_ + (y+1) * cmsg_step1 + (x+0);\n"
"__global const short *d = d_ + (y-1) * cmsg_step1 + (x+0);\n"
"__global const short *l = l_ + (y+0) * cmsg_step1 + (x+1);\n"
"__global const short *r = r_ + (y+0) * cmsg_step1 + (x-1);\n"
"short best = 0;\n"
"short best_val = SHRT_MAX;\n"
"for (int i = 0; i < nr_plane; ++i)\n"
"{\n"
"int idx = i * cdisp_step1;\n"
"short val = data[idx]+ u[idx] + d[idx] + l[idx] + r[idx];\n"
"if (val < best_val)\n"
"{\n"
"best_val = val;\n"
"best = disp_selected[idx];\n"
"}\n"
"}\n"
"disp[res_step * y + x] = best;\n"
"}\n"
"}\n"
"__kernel void compute_disp_1(__global const float *u_, __global const float *d_, __global const float *l_,\n"
"__global const float *r_, __global const float *data_cost_selected,\n"
"__global const float *disp_selected_pyr,\n"
"__global short *disp,\n"
"int res_step, int cols, int rows, int nr_plane,\n"
"int cmsg_step1, int cdisp_step1)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if (y > 0 && y < rows - 1 && x > 0 && x < cols - 1)\n"
"{\n"
"__global const float *data = data_cost_selected + y * cmsg_step1 + x;\n"
"__global const float *disp_selected = disp_selected_pyr + y * cmsg_step1 + x;\n"
"__global const float *u = u_ + (y+1) * cmsg_step1 + (x+0);\n"
"__global const float *d = d_ + (y-1) * cmsg_step1 + (x+0);\n"
"__global const float *l = l_ + (y+0) * cmsg_step1 + (x+1);\n"
"__global const float *r = r_ + (y+0) * cmsg_step1 + (x-1);\n"
"short best = 0;\n"
"short best_val = SHRT_MAX;\n"
"for (int i = 0; i < nr_plane; ++i)\n"
"{\n"
"int idx = i * cdisp_step1;\n"
"float val = data[idx]+ u[idx] + d[idx] + l[idx] + r[idx];\n"
"if (val < best_val)\n"
"{\n"
"best_val = val;\n"
"best = convert_short_sat_rte(disp_selected[idx]);\n"
"}\n"
"}\n"
"disp[res_step * y + x] = best;\n"
"}\n"
"}\n"
, "d203bd312e7d4f9915cdec480d0c54e1"};
const struct ProgramEntry svm={"svm",
"#ifdef DOUBLE_SUPPORT\n"
"#ifdef cl_amd_fp64\n"
"#pragma OPENCL EXTENSION cl_amd_fp64:enable\n"
"#elif defined (cl_khr_fp64)\n"
"#pragma OPENCL EXTENSION cl_khr_fp64:enable\n"
"#endif\n"
"#define TYPE double\n"
"#else\n"
"#define TYPE float\n"
"#endif\n"
"#if defined ADDEXP\n"
"#define EXP(X) exp(X)\n"
"#else\n"
"#define EXP(X) X\n"
"#endif\n"
"#if defined ADDPOW\n"
"#define POW(X,Y) pow(fabs(X),(Y))\n"
"#else\n"
"#define POW(X,Y) X\n"
"#endif\n"
"#define MAX_VAL   (FLT_MAX*1e-3)\n"
"#define BLOCK_SIZE 16\n"
"__kernel void svm_linear(__global float* src, int src_step, __global float* src2, int src2_step, __global TYPE* dst, int dst_step, int src_rows, int src2_cols,\n"
"int width, TYPE alpha, TYPE beta)\n"
"{\n"
"const int  col = get_global_id(0);\n"
"const int  row = get_global_id(1);\n"
"if(row < src_rows && col < src2_cols)\n"
"{\n"
"int t = 0;\n"
"TYPE temp = 0.0;\n"
"for(t = 0; t < width - BLOCK_SIZE; t += BLOCK_SIZE)\n"
"{\n"
"float16 t0 = vload16(0, src + row * src_step + t);\n"
"float16 t1 = vload16(0, src2 + col * src2_step + t);\n"
"t0 *= t1;\n"
"temp += t0.s0 + t0.s1 + t0.s2 + t0.s3 + t0.s4 + t0.s5 + t0.s6 + t0.s7 +\n"
"t0.s8 + t0.s9 + t0.sa + t0.sb + t0.sc + t0.sd + t0.se + t0.sf;\n"
"}\n"
"for(; t < width; t++)\n"
"{\n"
"temp += src[row * src_step + t] * src2[col * src2_step + t];\n"
"}\n"
"TYPE temp1 = (TYPE) (temp * alpha + beta);\n"
"if( temp1 > MAX_VAL )\n"
"{\n"
"dst[row * dst_step + col] = MAX_VAL;\n"
"}\n"
"else\n"
"{\n"
"dst[row * dst_step + col] = temp1;\n"
"}\n"
"}\n"
"}\n"
"__kernel void svm_sigmod(__global float* src, int src_step, __global float* src2, int src2_step, __global TYPE* dst, int dst_step, int src_rows, int src2_cols,\n"
"int width, TYPE alpha, TYPE beta)\n"
"{\n"
"const int  col = get_global_id(0);\n"
"const int  row = get_global_id(1);\n"
"if(row < src_rows && col < src2_cols)\n"
"{\n"
"int t = 0;\n"
"TYPE temp = 0.0;\n"
"for(t = 0; t < width - BLOCK_SIZE; t += BLOCK_SIZE)\n"
"{\n"
"float16 t0 = vload16(0, src + row * src_step + t);\n"
"float16 t1 = vload16(0, src2 + col * src2_step + t);\n"
"t0 *= t1;\n"
"temp += t0.s0 + t0.s1 + t0.s2 + t0.s3 + t0.s4 + t0.s5 + t0.s6 + t0.s7 +\n"
"t0.s8 + t0.s9 + t0.sa + t0.sb + t0.sc + t0.sd + t0.se + t0.sf;\n"
"}\n"
"for(; t < width; t++)\n"
"{\n"
"temp += src[row * src_step + t] * src2[col * src2_step + t];\n"
"}\n"
"TYPE tp = (TYPE) (temp * alpha + beta);\n"
"TYPE e = exp(-fabs(tp));\n"
"TYPE temp1;\n"
"if(tp > 0)\n"
"{\n"
"temp1 = (TYPE)((1. - e) / (1. + e));\n"
"}\n"
"else\n"
"{\n"
"temp1 = (TYPE)((e - 1.) / (e + 1.));\n"
"}\n"
"if( temp1 > MAX_VAL )\n"
"{\n"
"dst[row * dst_step + col] = MAX_VAL;\n"
"}\n"
"else\n"
"{\n"
"dst[row * dst_step + col] = temp1;\n"
"}\n"
"}\n"
"}\n"
"__kernel void svm_poly(__global float* src, int src_step, __global float* src2, int src2_step, __global TYPE* dst, int dst_step, int src_rows, int src2_cols,\n"
"int width, TYPE alpha, TYPE beta, TYPE degree)\n"
"{\n"
"const int  col = get_global_id(0);\n"
"const int  row = get_global_id(1);\n"
"if(row < src_rows && col < src2_cols)\n"
"{\n"
"int t = 0;\n"
"TYPE temp = 0.0;\n"
"for(t = 0; t < width - BLOCK_SIZE; t += BLOCK_SIZE)\n"
"{\n"
"float16 t0 = vload16(0, src + row * src_step + t);\n"
"float16 t1 = vload16(0, src2 + col * src2_step + t);\n"
"t0 *= t1;\n"
"temp += t0.s0 + t0.s1 + t0.s2 + t0.s3 + t0.s4 + t0.s5 + t0.s6 + t0.s7 +\n"
"t0.s8 + t0.s9 + t0.sa + t0.sb + t0.sc + t0.sd + t0.se + t0.sf;\n"
"}\n"
"for(; t < width; t++)\n"
"{\n"
"temp += src[row * src_step + t] * src2[col * src2_step + t];\n"
"}\n"
"TYPE temp1 = (TYPE)(POW((temp * alpha + beta), degree));\n"
"if( temp1 > MAX_VAL )\n"
"{\n"
"dst[row * dst_step + col] = MAX_VAL;\n"
"}\n"
"else\n"
"{\n"
"dst[row * dst_step + col] = temp1;\n"
"}\n"
"}\n"
"}\n"
"__kernel void svm_rbf(__global float* src, int src_step, __global float* src2, int src2_step, __global TYPE* dst, int dst_step, int src_rows, int src2_cols,\n"
"int width, TYPE gamma)\n"
"{\n"
"const int  col = get_global_id(0);\n"
"const int  row = get_global_id(1);\n"
"if(row < src_rows && col < src2_cols)\n"
"{\n"
"int t = 0;\n"
"TYPE temp = 0.0;\n"
"for(t = 0; t < width - BLOCK_SIZE; t += BLOCK_SIZE)\n"
"{\n"
"float16 t0 = vload16(0, src + row * src_step + t);\n"
"float16 t1 = vload16(0, src2 + col * src2_step + t);\n"
"t0 = (t0 - t1) * (t0 - t1);\n"
"temp += t0.s0 + t0.s1 + t0.s2 + t0.s3 + t0.s4 + t0.s5 + t0.s6 + t0.s7 +\n"
"t0.s8 + t0.s9 + t0.sa + t0.sb + t0.sc + t0.sd + t0.se + t0.sf;\n"
"}\n"
"for(; t < width; t++)\n"
"{\n"
"temp += (src[row * src_step + t] - src2[col * src2_step + t]) * (src[row * src_step + t] - src2[col * src2_step + t]);\n"
"}\n"
"TYPE temp1 = EXP((TYPE)(temp * gamma));\n"
"if( temp1 > MAX_VAL )\n"
"{\n"
"dst[row * dst_step + col] = MAX_VAL;\n"
"}\n"
"else\n"
"{\n"
"dst[row * dst_step + col] = temp1;\n"
"}\n"
"}\n"
"}\n"
, "366022531756acf8bbab0f837ce1849a"};
const struct ProgramEntry tvl1flow={"tvl1flow",
"__kernel void centeredGradientKernel(__global const float* src, int src_col, int src_row, int src_step,\n"
"__global float* dx, __global float* dy, int dx_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if((x < src_col)&&(y < src_row))\n"
"{\n"
"int src_x1 = (x + 1) < (src_col -1)? (x + 1) : (src_col - 1);\n"
"int src_x2 = (x - 1) > 0 ? (x -1) : 0;\n"
"dx[y * dx_step+ x] = 0.5f * (src[y * src_step + src_x1] - src[y * src_step+ src_x2]);\n"
"int src_y1 = (y+1) < (src_row - 1) ? (y + 1) : (src_row - 1);\n"
"int src_y2 = (y - 1) > 0 ? (y - 1) : 0;\n"
"dy[y * dx_step+ x] = 0.5f * (src[src_y1 * src_step + x] - src[src_y2 * src_step+ x]);\n"
"}\n"
"}\n"
"float bicubicCoeff(float x_)\n"
"{\n"
"float x = fabs(x_);\n"
"if (x <= 1.0f)\n"
"return x * x * (1.5f * x - 2.5f) + 1.0f;\n"
"else if (x < 2.0f)\n"
"return x * (x * (-0.5f * x + 2.5f) - 4.0f) + 2.0f;\n"
"else\n"
"return 0.0f;\n"
"}\n"
"__kernel void warpBackwardKernel(__global const float* I0, int I0_step, int I0_col, int I0_row,\n"
"image2d_t tex_I1, image2d_t tex_I1x, image2d_t tex_I1y,\n"
"__global const float* u1, int u1_step,\n"
"__global const float* u2,\n"
"__global float* I1w,\n"
"__global float* I1wx, \n"
"__global float* I1wy, \n"
"__global float* grad, \n"
"__global float* rho,\n"
"int I1w_step,\n"
"int u2_step,\n"
"int u1_offset_x,\n"
"int u1_offset_y,\n"
"int u2_offset_x,\n"
"int u2_offset_y)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < I0_col&&y < I0_row)\n"
"{\n"
"float u1Val = u1[(y + u1_offset_y) * u1_step + x + u1_offset_x];\n"
"float u2Val = u2[(y + u2_offset_y) * u2_step + x + u2_offset_x];\n"
"float wx = x + u1Val;\n"
"float wy = y + u2Val;\n"
"int xmin = ceil(wx - 2.0f);\n"
"int xmax = floor(wx + 2.0f);\n"
"int ymin = ceil(wy - 2.0f);\n"
"int ymax = floor(wy + 2.0f);\n"
"float sum  = 0.0f;\n"
"float sumx = 0.0f;\n"
"float sumy = 0.0f;\n"
"float wsum = 0.0f;\n"
"sampler_t sampleri = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;\n"
"for (int cy = ymin; cy <= ymax; ++cy)\n"
"{\n"
"for (int cx = xmin; cx <= xmax; ++cx)\n"
"{\n"
"float w = bicubicCoeff(wx - cx) * bicubicCoeff(wy - cy);\n"
"int2 cood = (int2)(cx, cy);\n"
"sum += w * read_imagef(tex_I1, sampleri, cood).x;\n"
"sumx += w * read_imagef(tex_I1x, sampleri, cood).x;\n"
"sumy += w * read_imagef(tex_I1y, sampleri, cood).x;\n"
"wsum += w;\n"
"}\n"
"}\n"
"float coeff = 1.0f / wsum;\n"
"float I1wVal  = sum  * coeff;\n"
"float I1wxVal = sumx * coeff;\n"
"float I1wyVal = sumy * coeff;\n"
"I1w[y * I1w_step + x]  = I1wVal;\n"
"I1wx[y * I1w_step + x] = I1wxVal;\n"
"I1wy[y * I1w_step + x] = I1wyVal;\n"
"float Ix2 = I1wxVal * I1wxVal;\n"
"float Iy2 = I1wyVal * I1wyVal;\n"
"grad[y * I1w_step + x] = Ix2 + Iy2;\n"
"float I0Val = I0[y * I0_step + x];\n"
"rho[y * I1w_step + x] = I1wVal - I1wxVal * u1Val - I1wyVal * u2Val - I0Val;\n"
"}\n"
"}\n"
"float readImage(__global float *image,  int x,  int y,  int rows,  int cols, int elemCntPerRow)\n"
"{\n"
"int i0 = clamp(x, 0, cols - 1);\n"
"int j0 = clamp(y, 0, rows - 1);\n"
"return image[j0 * elemCntPerRow + i0];\n"
"}\n"
"__kernel void warpBackwardKernelNoImage2d(__global const float* I0, int I0_step, int I0_col, int I0_row,\n"
"__global const float* tex_I1, __global const float* tex_I1x, __global const float* tex_I1y,\n"
"__global const float* u1, int u1_step,\n"
"__global const float* u2,\n"
"__global float* I1w,\n"
"__global float* I1wx, \n"
"__global float* I1wy, \n"
"__global float* grad, \n"
"__global float* rho,\n"
"int I1w_step,\n"
"int u2_step,\n"
"int I1_step,\n"
"int I1x_step)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < I0_col&&y < I0_row)\n"
"{\n"
"float u1Val = u1[y * u1_step + x];\n"
"float u2Val = u2[y * u2_step + x];\n"
"float wx = x + u1Val;\n"
"float wy = y + u2Val;\n"
"int xmin = ceil(wx - 2.0f);\n"
"int xmax = floor(wx + 2.0f);\n"
"int ymin = ceil(wy - 2.0f);\n"
"int ymax = floor(wy + 2.0f);\n"
"float sum  = 0.0f;\n"
"float sumx = 0.0f;\n"
"float sumy = 0.0f;\n"
"float wsum = 0.0f;\n"
"for (int cy = ymin; cy <= ymax; ++cy)\n"
"{\n"
"for (int cx = xmin; cx <= xmax; ++cx)\n"
"{\n"
"float w = bicubicCoeff(wx - cx) * bicubicCoeff(wy - cy);\n"
"int2 cood = (int2)(cx, cy);\n"
"sum += w * readImage(tex_I1, cood.x, cood.y, I0_col, I0_row, I1_step);\n"
"sumx += w * readImage(tex_I1x, cood.x, cood.y, I0_col, I0_row, I1x_step);\n"
"sumy += w * readImage(tex_I1y, cood.x, cood.y, I0_col, I0_row, I1x_step);\n"
"wsum += w;\n"
"}\n"
"}\n"
"float coeff = 1.0f / wsum;\n"
"float I1wVal  = sum  * coeff;\n"
"float I1wxVal = sumx * coeff;\n"
"float I1wyVal = sumy * coeff;\n"
"I1w[y * I1w_step + x]  = I1wVal;\n"
"I1wx[y * I1w_step + x] = I1wxVal;\n"
"I1wy[y * I1w_step + x] = I1wyVal;\n"
"float Ix2 = I1wxVal * I1wxVal;\n"
"float Iy2 = I1wyVal * I1wyVal;\n"
"grad[y * I1w_step + x] = Ix2 + Iy2;\n"
"float I0Val = I0[y * I0_step + x];\n"
"rho[y * I1w_step + x] = I1wVal - I1wxVal * u1Val - I1wyVal * u2Val - I0Val;\n"
"}\n"
"}\n"
"__kernel void estimateDualVariablesKernel(__global const float* u1, int u1_col, int u1_row, int u1_step,\n"
"__global const float* u2,\n"
"__global float* p11, int p11_step,\n"
"__global float* p12,\n"
"__global float* p21,\n"
"__global float* p22,\n"
"float taut,\n"
"int u2_step,\n"
"int u1_offset_x,\n"
"int u1_offset_y,\n"
"int u2_offset_x,\n"
"int u2_offset_y)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < u1_col && y < u1_row)\n"
"{\n"
"int src_x1 = (x + 1) < (u1_col - 1) ? (x + 1) : (u1_col - 1);\n"
"float u1x = u1[(y + u1_offset_y) * u1_step + src_x1 + u1_offset_x] - u1[(y + u1_offset_y) * u1_step + x + u1_offset_x];\n"
"int src_y1 = (y + 1) < (u1_row - 1) ? (y + 1) : (u1_row - 1);\n"
"float u1y = u1[(src_y1 + u1_offset_y) * u1_step + x + u1_offset_x] - u1[(y + u1_offset_y) * u1_step + x + u1_offset_x];\n"
"int src_x2 = (x + 1) < (u1_col - 1) ? (x + 1) : (u1_col - 1);\n"
"float u2x = u2[(y + u2_offset_y) * u2_step + src_x2 + u2_offset_x] - u2[(y + u2_offset_y) * u2_step + x + u2_offset_x];\n"
"int src_y2 = (y + 1) <  (u1_row - 1) ? (y + 1) : (u1_row - 1);\n"
"float u2y = u2[(src_y2 + u2_offset_y) * u2_step + x + u2_offset_x] - u2[(y + u2_offset_y) * u2_step + x + u2_offset_x];\n"
"float g1 = hypot(u1x, u1y);\n"
"float g2 = hypot(u2x, u2y);\n"
"float ng1 = 1.0f + taut * g1;\n"
"float ng2 = 1.0f + taut * g2;\n"
"p11[y * p11_step + x] = (p11[y * p11_step + x] + taut * u1x) / ng1;\n"
"p12[y * p11_step + x] = (p12[y * p11_step + x] + taut * u1y) / ng1;\n"
"p21[y * p11_step + x] = (p21[y * p11_step + x] + taut * u2x) / ng2;\n"
"p22[y * p11_step + x] = (p22[y * p11_step + x] + taut * u2y) / ng2;\n"
"}\n"
"}\n"
"float divergence(__global const float* v1, __global const float* v2, int y, int x, int v1_step, int v2_step)\n"
"{\n"
"if (x > 0 && y > 0)\n"
"{\n"
"float v1x = v1[y * v1_step + x] - v1[y * v1_step + x - 1];\n"
"float v2y = v2[y * v2_step + x] - v2[(y - 1) * v2_step + x];\n"
"return v1x + v2y;\n"
"}\n"
"else\n"
"{\n"
"if (y > 0)\n"
"return v1[y * v1_step + 0] + v2[y * v2_step + 0] - v2[(y - 1) * v2_step + 0];\n"
"else\n"
"{\n"
"if (x > 0)\n"
"return v1[0 * v1_step + x] - v1[0 * v1_step + x - 1] + v2[0 * v2_step + x];\n"
"else\n"
"return v1[0 * v1_step + 0] + v2[0 * v2_step + 0];\n"
"}\n"
"}\n"
"}\n"
"__kernel void estimateUKernel(__global const float* I1wx, int I1wx_col, int I1wx_row, int I1wx_step,\n"
"__global const float* I1wy, \n"
"__global const float* grad, \n"
"__global const float* rho_c, \n"
"__global const float* p11, \n"
"__global const float* p12, \n"
"__global const float* p21, \n"
"__global const float* p22, \n"
"__global float* u1, int u1_step,\n"
"__global float* u2,\n"
"__global float* error, float l_t, float theta, int u2_step,\n"
"int u1_offset_x,\n"
"int u1_offset_y,\n"
"int u2_offset_x,\n"
"int u2_offset_y,\n"
"char calc_error)\n"
"{\n"
"int x = get_global_id(0);\n"
"int y = get_global_id(1);\n"
"if(x < I1wx_col && y < I1wx_row)\n"
"{\n"
"float I1wxVal = I1wx[y * I1wx_step + x];\n"
"float I1wyVal = I1wy[y * I1wx_step + x];\n"
"float gradVal = grad[y * I1wx_step + x];\n"
"float u1OldVal = u1[(y + u1_offset_y) * u1_step + x + u1_offset_x];\n"
"float u2OldVal = u2[(y + u2_offset_y) * u2_step + x + u2_offset_x];\n"
"float rho = rho_c[y * I1wx_step + x] + (I1wxVal * u1OldVal + I1wyVal * u2OldVal);\n"
"float d1 = 0.0f;\n"
"float d2 = 0.0f;\n"
"if (rho < -l_t * gradVal)\n"
"{\n"
"d1 = l_t * I1wxVal;\n"
"d2 = l_t * I1wyVal;\n"
"}\n"
"else if (rho > l_t * gradVal)\n"
"{\n"
"d1 = -l_t * I1wxVal;\n"
"d2 = -l_t * I1wyVal;\n"
"}\n"
"else if (gradVal > 1.192092896e-07f)\n"
"{\n"
"float fi = -rho / gradVal;\n"
"d1 = fi * I1wxVal;\n"
"d2 = fi * I1wyVal;\n"
"}\n"
"float v1 = u1OldVal + d1;\n"
"float v2 = u2OldVal + d2;\n"
"float div_p1 = divergence(p11, p12, y, x, I1wx_step, I1wx_step);\n"
"float div_p2 = divergence(p21, p22, y, x, I1wx_step, I1wx_step);\n"
"float u1NewVal = v1 + theta * div_p1;\n"
"float u2NewVal = v2 + theta * div_p2;\n"
"u1[(y + u1_offset_y) * u1_step + x + u1_offset_x] = u1NewVal;\n"
"u2[(y + u2_offset_y) * u2_step + x + u2_offset_x] = u2NewVal;\n"
"if(calc_error)\n"
"{\n"
"float n1 = (u1OldVal - u1NewVal) * (u1OldVal - u1NewVal);\n"
"float n2 = (u2OldVal - u2NewVal) * (u2OldVal - u2NewVal);\n"
"error[y * I1wx_step + x] = n1 + n2;\n"
"}\n"
"}\n"
"}\n"
, "15d604b56daef7cecff8d9ada2970732"};
}
}
