.\" $XTermId: luit.man,v 1.20 2012/10/06 01:02:25 tom Exp $
.\"
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds AQ \(aq
.el       .ds AQ '
.ie \n(.g .ds `` \(lq
.el       .ds `` ``
.ie \n(.g .ds '' \(rq
.el       .ds '' ''
.de bP
.IP \(bu 4
..
.TH LUIT 1 __vendorversion__
.SH NAME
luit \- Locale and ISO\ 2022 support for Unicode terminals
.SH SYNOPSIS
.B luit
[
.I options
] [
.B \-\-
] [
.I program
[
.I args
] ]
.SH DESCRIPTION
.B Luit
is a filter that can be run between an arbitrary application and a
UTF-8 terminal emulator.
It will convert application output from the
locale's encoding into UTF-8, and convert terminal input from UTF-8
into the locale's encoding.
.PP
An application may also request switching to a different output
encoding using ISO\ 2022 and ISO\ 6429 escape sequences.
Use of this feature is discouraged:
multilingual applications should be modified
to directly generate UTF-8 instead.
.PP
.B Luit
is usually invoked transparently by the terminal emulator.
For information about running
.B luit
from the command line, see EXAMPLES below.
.SH OPTIONS
.TP
.B \-h
Display some summary help and quit.
.TP
.B \-list
List the supported charsets and encodings, then quit.
.IP
To make scripting simpler,
.B luit
ignores spaces, underscores and ASCII minus-signs (dash) embedded in the names.
.B Luit
also ignores case when matching charset and encoding names.
.TP
.B \-V
Print \fBluit\fP's version and quit.
.TP
.B \-v
Be verbose.
Repeating the option, e.g., "\fB\-v\ \-v\fP" makes it more verbose.
.B Luit
does not use \fIgetopt\fP, so "\fB\-vv\fP" does not work.
.TP
.B \-c
Function as a simple converter from standard input to standard output.
.TP
.B \-p
In startup, establish a handshake between parent and child processes.
This is needed for some older systems, e.g., to successfully copy
the terminal settings to the pseudo-terminal.
.TP
.B \-t
Initialize \fBluit\fP using the locale and command-line options,
but do not open a pty connection.
This option is used for testing \fBluit\fP's configuration.
It will exit with success if no errors were detected.
Repeat the \fB-t\fP option to cause warning messages to be treated as errors.
.TP
.B \-x
Exit as soon as the child dies.
This may cause
.B luit
to lose data at the end of the child's output.
.TP
.BI \-argv0 " name"
Set the child's name (as passed in argv[0]).
.TP
.BI \-encoding " encoding"
Set up
.B luit
to use
.I encoding
rather than the current locale's encoding.
.TP
.B +oss
Disable interpretation of single shifts in application output.
.TP
.B +ols
Disable interpretation of locking shifts in application output.
.TP
.B +osl
Disable interpretation of character set selection sequences in
application output.
.TP
.B +ot
Disable interpretation of all sequences and pass all sequences in
application output to the terminal unchanged.
This may lead to interesting results.
.TP
.B \-k7
Generate seven-bit characters for keyboard input.
.TP
.B +kss
Disable generation of single-shifts for keyboard input.
.TP
.B +kssgr
Use GL codes after a single shift for keyboard input.
By default,
GR codes are generated after a single shift when generating eight-bit
keyboard input.
.TP
.B \-kls
Generate locking shifts (SO/SI) for keyboard input.
.TP
.BI \-gl " gn"
Set the initial assignment of GL.
The argument should be one of
.BR g0 ,
.BR g1 ,
.B g2
or
.BR g3 .
The default depends on the locale, but is usually
.BR g0 .
.TP
.BI \-gr " gk"
Set the initial assignment of GR.
The default depends on the locale, and is usually
.B g2
except for EUC locales, where it is
.BR g1 .
.TP
.BI \-g0 " charset"
Set the charset initially selected in G0.
The default depends on the locale, but is usually
.BR ASCII .
.TP
.BI \-g1 " charset"
Set the charset initially selected in G1.
The default depends on the locale.
.TP
.BI \-g2 " charset"
Set the charset initially selected in G2.
The default depends on the locale.
.TP
.BI \-g3 " charset"
Set the charset initially selected in G3.
The default depends on the locale.
.TP
.BI \-ilog " filename"
Log into
.I filename
all the bytes received from the child.
.TP
.BI \-olog " filename"
Log into
.I filename
all the bytes sent to the terminal emulator.
.TP
.BI \-alias " filename"
the locale alias file
.br
(default: __locale_alias__).
.TP
.B \-\-
End of options.
.SH ENVIRONMENT
\fBLuit\fP uses these environment variables:
.TP
LC_ALL
.TP
LC_CTYPE
.TP
LANG
During initialization,
\fBluit\fP calls \fBsetlocale\fP to check if the user's locale is supported
by the operating system.
If \fBsetlocale\fP returns a failure,
\fBluit\fP looks instead at these variables in succession to obtain
any clues from the user's environment for locale preference.
.TP
SHELL
This is normally set by shells other than the Bourne shell,
as a convention.
\fBLuit\fP will use this value (rather than the user's entry in /etc/passwd)
to decide which shell to execute.
If SHELL is not set, \fBluit\fP executes /bin/sh.
.SH EXAMPLES
The most typical use of
.B luit
is to adapt an instance of
.B XTerm
to the locale's encoding.
Current versions of
.B XTerm
invoke
.B luit
automatically when it is needed.
If you are using an older release of
.BR XTerm ,
or a different terminal emulator, you may invoke
.B luit
manually:
.IP
$ xterm \-u8 \-e luit
.PP
If you are running in a UTF-8 locale but need to access a remote
machine that doesn't support UTF-8,
.B luit
can adapt the remote output to your terminal:
.IP
$ LC_ALL=fr_FR luit ssh legacy-machine
.PP
.B Luit
is also useful with applications that hard-wire an encoding that is
different from the one normally used on the system or want to use
legacy escape sequences for multilingual output.
In particular,
versions of
.B Emacs
that do not speak UTF-8 well can use
.B luit
for multilingual output:
.IP
$ luit -encoding 'ISO 8859-1' emacs -nw
.PP
And then, in
.BR Emacs ,
.IP
M-x set-terminal-coding-system RET iso-2022-8bit-ss2 RET
.PP
.SH FILES
.TP
.B __locale_alias__
The file mapping locales to locale encodings.
.SH SECURITY
On systems with SVR4 (\*(``Unix-98\*('') ptys (Linux version 2.2 and later,
SVR4),
.B luit
should be run as the invoking user.
.PP
On systems without SVR4 (\*(``Unix-98\*('') ptys (notably BSD variants),
running
.B luit
as an ordinary user will leave the tty world-writable; this is a
security hole, and \fBluit\fP will generate a warning (but still accept to
run).
A possible solution is to make
.B luit
suid root;
.B luit
should drop privileges sufficiently early to make this safe.
However,
the startup code has not been exhaustively audited, and the author
takes no responsibility for any resulting security issues.
.PP
.B Luit
will refuse to run if it is installed setuid and cannot safely drop
privileges.
.SH BUGS
None of this complexity should be necessary.
Stateless UTF-8
throughout the system is the way to go.
.PP
Charsets with a non-trivial intermediary byte are not yet supported.
.PP
Selecting alternate sets of control characters is not supported and
will never be.
.SH SEE ALSO
xterm(__mansuffix__).
.PP
These are Linux-specific:
.bP
unicode(__miscmansuffix__),
.bP
utf-8(__miscmansuffix__),
.bP
charsets(__miscmansuffix__).
.PP
These are more generally useful:
.nf
.bP
.I Character Code Structure and Extension Techniques (ISO\ 2022, ECMA-35).
.bP
.I Control Functions for Coded Character Sets (ISO\ 6429, ECMA-48).
.fi
.SH AUTHOR
Luit was written by Juliusz Chroboczek <jch@pps.jussieu.fr> for the
XFree86 project.
.PP
Thomas E. Dickey has maintained \fBluit\fP for use by \fBxterm\fP since 2006.
