#|  Logiweb, a system for electronic distribution of mathematics
    Copyright (C) 2004-2010 Klaus Grue

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact: Klaus Grue, DIKU, Universitetsparken 1, DK2100 Copenhagen,
    Denmark, grue@diku.dk, http://logiweb.eu/, http://www.diku.dk/~grue/

    Logiweb is a system for distribution of mathematical definitions,
    lemmas, and proofs. For more on Logiweb, consult http://logiweb.eu/.
|#

#|
=============================================
Logiweb common files
=============================================
Formatting of online documentation
=============================================
|#

(in-package "COMMON-LISP-USER")

#|
(load     "common/test")
(testload "common/def"   :prompt nil :test nil)
(testload "common/maker" :prompt nil :test nil)
(testload "common/conf"  :prompt nil :test nil)
|#

#|
=============================================
Documentation tree
=============================================
|#

(defc docs
'(("System pages" "Logiweb" "Logiweb system pages" "index.html"
   ("Introduction..." nil nil "doc/announce.txt")
   ("Showroom" :same nil "doc/page.html"
    ("Combinations..." nil nil "page/combinations/fixed/body/tex/page.pdf")
    ("Proof..." nil nil "page/multzero/fixed/body/tex/page.pdf")
    ("Base Page..." nil nil "page/base/fixed/index.html")
    ("Proof Checker..." nil nil "page/check/fixed/index.html")
    ("Peano Arithmetic..." nil nil "page/Peano/fixed/index.html"))
   ("Tutorials" :same nil "tutorial/index.html"
    ("T01: Hello world" "Tutorial T01: Hello world" nil "tutorial/t01.html"
     ("Hints for administrators" :same nil "tutorial/admin.html")
     ("Syntax of references" :same nil "tutorial/t01a.html")
     ("Road map" :same nil "tutorial/t01b.html")
     ("Explanation of output" :same nil "tutorial/t01c.html"))
    ("T02: Programming" "Tutorial T02: Programming" nil "tutorial/t02.html")
    ("T03: Proving" "Tutorial T03: Proving" nil "tutorial/t03.html")
    ("T04: Googling" "Tutorial T04: Googling" nil "tutorial/t04.html")
    ("T05: Syntax" "Tutorial T05: Syntax" nil "tutorial/t05.html"))
   ("Man pages" :same nil "doc/man.html"
    ("man lgs..." nil nil "man/lgs.1.html")
    ("man 5 lgs..." nil nil "man/lgs.5.html")
    ("man logiweb..." nil nil "man/logiweb.1.html")
    ("man 7 logiweb..." nil nil "man/logiweb.7.html")
    ("man logiweb.conf..." nil nil "man/logiweb.conf.5.html")
    ("man lgwping..." nil nil "man/lgwping.1.html")
    ("man lgwrelay..." nil nil "man/lgwrelay.1.html")
    ("Directory..." nil nil "man/lgwdir.html"))
   ("Help" "Help index" "Logiweb online help" "doc/index.html"
    ("Overview" :same nil "doc/overview.html")
    ("Browser" "The crossbrowser" nil "doc/browser/index.html"
     ("Main Menu" "Crossbrowser main menu" nil "doc/browser/main.html")
     ("Reference" "Crossbrowser reference windows" nil
      "doc/browser/reference/index.html")
     ("Vector" "Crossbrowser vector windows" nil
      "doc/browser/vector/index.html")
     ("Body" "Crossbrowser body windows" nil
      "doc/browser/body/index.html")
     ("Bibliography" "Crossbrowser bibliography windows" nil
      "doc/browser/bibliography/index.html")
     ("Dictionary" "Crossbrowser dictionary windows" nil
      "doc/browser/dictionary/index.html")
     ("External" "Crossbrowser external formats windows" nil
      "doc/browser/external/index.html")
     ("Expansion" "Crossbrowser expansion windows" nil
      "doc/browser/expansion/index.html")
     ("Codex" "Crossbrowser codex windows" nil
      "doc/browser/codex/index.html")
     ("Diagnose" "Crossbrowser diagnose windows" nil
      "doc/browser/diagnose/index.html")
     ("Source" "Crossbrowser source windows" nil
      "doc/browser/source/index.html"))
    ("Compiler" "The Logiweb compiler" nil "doc/compiler/index.html"
     ("Language" "The Logiweb language" nil "doc/compiler/lgs.html"))
    ("Server" "Servers" nil "doc/server/index.html"
     ("Server States" :same nil "doc/server/state.html")
     ("User Interface" "Relay interface" nil "doc/server/interface.html")
     ("HTTP Interface" "Relay url syntax" nil "doc/server/url.html"))
    ("Misceleneous" :same nil "doc/misc/index.html"
     ("Mixed Endian" "Mixed endian and dot notation" nil "doc/misc/mixed.html")
     ("Kana" "Kana format" nil "doc/misc/kana.html")
     ("Logiweb Time" "Logiweb time" nil "doc/misc/time.html")))
   ("Download" "Logiweb download" nil "release/index.html"
    ("Readme..." nil nil "release/readme")
    ("Download..." nil nil "release/download/latest.tar.gz")
    ("All versions..." nil nil "release/download/lgwdir.html"))
   ("Wiki..." nil nil "wiki/index.html")
   ("Wiki submission" "Submission forms" nil "tutorial/forms.html"
    ("Create form..." nil nil "tutorial/create.html")
    ("Prefilled create form..." nil nil "tutorial/suggest.html")
    ("Submission form..." nil nil "tutorial/submit.html")
    ("Help" " Logiwiki Submission and Header Creation Forms"
     "Logiweb online help" "tutorial/help.html"))
   ("Background" "The Logiweb standards" nil "doc/standard.html"
    ("Semantics" "Loading pages" nil "doc/browser/loading.html")
    ("Protocol" "The Logiweb protocol" nil "doc/server/protocol.html")
    ("Protocol as ID..." nil nil "doc/server/protocol.txt"))
   ("Machine room..." nil nil "server/relay")
   ("Contact" "Contact information" nil "doc/contact/index.html"
    ("Mailing lists" "Moderated mailman mailing lists" nil
     "doc/contact/lists.html")))
  ("Site pages" "Logiweb site" "Logiweb site pages" "site/index.html")))

#|
=============================================
Template
=============================================
|#

(defc template1
"<!--
Logiweb, a system for electronic distribution of mathematics
Copyright (C) 2004-2010 Klaus Grue

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of  
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Contact: Klaus Grue, DIKU, Universitetsparken 1, DK2100 Copenhagen,
Denmark, grue@diku.dk, http://logiweb.eu/, http://www.diku.dk/~grue/
-->

<html>
  <head>
    <title>~1@*~a - ~2@*~a</title>
    <link rel='icon' href='~0@*~adoc/logiweb.ico' type='image/x-icon' />
    <link rel='shortcut icon' href='~0@*~adoc/logiweb.ico'
     type='image/x-icon' />
  </head>
  <body leftmargin='0' rightmargin='0' topmargin='0' bottommargin='0'>
    <table width='100%' height='100%'
     cellpadding='0' cellspacing='0' border='0'>

      <tr bgcolor='#0080FF'>
        <td width= '10'>&nbsp;</td>
        <td width='136' valign='top'><img alt='Logiweb(TM)',
         height='62', width='136', src='~0@*~adoc/logiwide.png'/></td>
        <td width= '10'>&nbsp;</td>
        <td width= '10'>&nbsp;</td>
        <td style='font-size:150%;font-weight:bold;color:white'>
           ~1@*~a
        </td>
        <td width= '10'>&nbsp;</td>
      </tr>

      <tr bgcolor='#E0F0FF' height=62>
        <td>&nbsp;</td>
        <td>&nbsp;</td>
        <td>&nbsp;</td>
        <td bgcolor='white'>&nbsp;</td>
        <td bgcolor='white' style='font-size:150%;font-weight:bold'>
           ~2@*~a
        </td>
        <td bgcolor='white'>&nbsp;</td>
      </tr>

      <tr valign='top' style='height:100%;' bgcolor='#E0F0FF'>
        <td>&nbsp;</td>
        <td>
          <p>")

(defc template2
"          </p>
        </td>
        <td>&nbsp;</td>
        <td bgcolor='white'>&nbsp;</td>
        <td bgcolor='white'>
<!--BodyBegin-->")

(defc template3
"<!--BodyEnd-->
        </td>
        <td bgcolor='white'>&nbsp;</td>
      </tr>
    </table>
  </body>
</html>")

#|
=============================================
Read file
=============================================
|#

(deff read-lines (filename)
 (with-open-file
  (stream filename
   :direction :input
   :if-does-not-exist nil)
  (if (null stream) nil (read-lines1 stream nil))))

(deff read-lines1 (stream result)
 (:let line (read-line stream nil nil))
 (:when (null line) (reverse result))
 (read-lines1 stream (cons line result)))

#|
=============================================
Write file
=============================================
|#

(deff write-line* (filename file)
 (with-open-file
  (stream filename
   :direction :output
   :if-exists :supersede)
  (if (null stream) nil (write-line*1 stream file))))

(deff write-line*1 (stream file)
 (:when (null file) nil)
 (format stream "~a~%" (car file))
 (write-line*1 stream (cdr file)))

#|
=============================================
Add separator to file
=============================================
|#

(deff add-separators (filename file)
 (:let pos1 (position "</h2>" file :test 'search))
 (:let pos2 (position "<address>" file :test 'search :from-end t))
 (:when (or (null pos1) (null pos2) (>= pos1 pos2))
 (format t "Malformed file: ~a~%" filename))
 (append
  (subseq file 0 (+ 1 pos1))
  '("<!--BodyBegin-->")
  (subseq file (+ 1 pos1) pos2)
  '("<!--BodyEnd-->")
  (subseq file pos2)))

(deff add-sep (filename)
 (write-line* filename (add-separators filename (read-lines filename))))

(deff add-seps (&optional (path "../doc"))
 (:let current (cd))
 (cd path)
 (unwind-protect
  (add-seps1* docs)
  (cd current)))

(deff add-seps1 (tree)
 (:let (:menu title2 :title1 filename . tree*) tree)
 (:when (not (stringp filename)) (error "Malformed tree"))
 (add-seps1* tree*)
 (:when (null title2) nil)
 (format t "~a~%" filename)
 (add-sep filename))

(deff add-seps1* (tree*)
 (:when (atom tree*) nil)
 (:let (tree . tree*) tree*)
 (add-seps1 tree)
 (add-seps1* tree*))

#|
=============================================
Add format to file
=============================================
|#

(deff add-formats (&optional (path "../doc"))
 (:let current (cd))
 (cd path)
 (unwind-protect
  (add-formats1* docs "" docs nil 0)
  (cd current)))

(deff add-formats1 (tree title whole index*)
 (:let (menu title2 title1 filename . tree*) tree)
 (:let title2 (if (equalp title2 :same) menu title2))
 (:let title1 (if title1 title1 title))
 (:when (not (stringp filename)) (error "Malformed tree"))
 (add-formats1* tree* title1 whole index* 0)
 (:when (null title2) nil)
 (format t "~a~%" filename)
 (add-format filename title1 title2 whole index*))

(deff remove-from (x y*)
 (:when (atom y*) nil)
 (:let (y . y*) y*)
 (:when (equalp x y) y*)
 (remove-from x y*))

(deff remove-between (x y z)
 (reverse (remove-from y (reverse (remove-from x z)))))

(deff add-formats1* (tree* title1 whole index* index)
 (:when (atom tree*) nil)
 (:let (tree . tree*) tree*)
 (add-formats1 tree title1 whole (cons index index*))
 (add-formats1* tree* title1 whole index* (+ index 1)))

(deff add-format (filename title1 title2 whole index*)
 (:let file (read-lines filename))
 (:let level (count #\/ filename))
 (:let level (apply 'concatenate 'string (repeat level "../")))
 (:let file (add-format1 level title1 title2 whole index* file))
 (write-line* filename file))

(deff add-format1 (level title1 title2 whole index* body)
 (:let body (remove-between "<!--BodyBegin-->" "<!--BodyEnd-->" body))
 (:let menu (make-menu level whole (reverse index*)))
 (:when (atom body) (error "Malformed file"))
 (append
  (list (format nil template1 level title1 title2))
  menu
  (list template2)
  body
  (list template3)))

(deff make-menu (level whole index*)
 (reverse (cdr (make-menu1* level whole index* nil))))

(deff make-menu1* (level tree* index* result)
 (:let (index . index*) index*)
 (:let index (if index index -1))
 (:let result (make-menu2* level tree* index 0 result))
 (:when (equalp index -1) result)
 (:let tree (nth index tree*))
 (:let (:menu :title2 :title1 :filename . tree*) tree)
 (make-menu1* level tree* index* result))

(deff make-menu2* (level tree* index1 index2 result)
 (:when (atom tree*) (cons "<br/>" result))
 (:let (tree . tree*) tree*)
 (:let result (make-menu2 level tree (equalp index1 index2) result))
 (make-menu2* level tree* index1 (+ 1 index2) result))

(defc *ref-format*
 "<a href='~a~a'~a>~a</a><br/>")

(defc *ref-style*
 " style='text-decoration:none;font-size:small;'")

(defc *ref-highlight*
 " style='background:white;text-decoration:none;font-size:small;'")

(deff make-menu2 (level tree highlight result)
 (:let (menu :title2 :title1 filename . :tree*) tree)
 (:let style (if highlight *ref-highlight* *ref-style*))
 (:let line (format nil *ref-format* level filename style menu))
 (cons line result))

#|
=============================================
Old stuff
=============================================

<a href="" style="text-decoration:none">Home</a><br/>
<a href="" style="text-decoration:none">Introduction</a><br/>
<a href="" style="text-decoration:none">Show room</a><br/>
<a href="">Tutorials</a><br/>

<a href="" style="background:white;">DDD</a><br/>

<html>
  <head>
    <title>Logiweb system pages - Tutorials</title>
    <style type="text/css">
      #linkgruppe a{text-decoration:none;}
    </style>
  </head>
  <body leftmargin="0" rightmargin="0" topmargin="0" bottommargin="0">
    <table width="100%" height="100%"
     cellpadding="0" cellspacing="0" border="0">

      <tr bgcolor="#0080FF">
        <td width= "10">&nbsp;</td>
        <td width="136">&nbsp;</td>
        <td width= "10">&nbsp;</td>
        <td width= "10">&nbsp;</td>
        <td style="font-size:150%;font-weight:bold;color:white">&nbsp;</td>
        <td width= "10">&nbsp;</td>
      </tr>

      <tr valign="top" style="height:100%;" bgcolor="#E0F0FF">
        <td>&nbsp;</td>
        <td>
<span id="linkgruppe">
          <p>
            <a href="">AAA</a><br/>
            <a href="">BBB</a><br/>
            <a href="">CCC</a><br/>
            <a href="" style="text-decoration:line-through">DDD</a><br/>
            <a href="">EEE</a><br/>
          <br/>
            <a href="">AAA</a><br/>
            <a href="">BBB</a><br/>
            <a href="">CCC</a><br/>
            <a href="" style="text-decoration:line-through">DDD</a><br/>
            <a href="">EEE</a><br/>
          </p>
        </td>
</span>
        <td>&nbsp;</td>
        <td bgcolor="white">&nbsp;</td>
        <td bgcolor="white"><p><a href="">XXX</a></p></td>
        <td bgcolor="white">&nbsp;</td>
      </tr>
    </table>
<!--
A:link, A:visited, A:active { text-decoration: underline }
-->
  </body>
</html>

|#
