#|  Logiweb, a system for electronic distribution of mathematics
    Copyright (C) 2004-2010 Klaus Grue

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact: Klaus Grue, DIKU, Universitetsparken 1, DK2100 Copenhagen,
    Denmark, grue@diku.dk, http://logiweb.eu/, http://www.diku.dk/~grue/

    Logiweb is a system for distribution of mathematical definitions,
    lemmas, and proofs. For more on Logiweb, consult http://logiweb.eu/.
|#

#|
=============================================
Server states
=============================================
We shall refer to the state of a server as a 'pool' (since 'state' and 'trie' are already used). A 'pool' is recursively defined as an association list of pools.

Pools are also used in the Logiweb compiler. In the Logiweb compiler, pools are merely used to collect options.
|#

(deff pool-get (adr pool)
 (:when (null pool) nil)
 (:when (atom adr) pool)
 (:let (index . adr) adr)
 (pool-get adr (cdr (assoc index pool :test 'equalp))))

(deff pool-put (adr val pool)
 (:when (atom adr) val)
 (:let (index . subadr) adr)
 (:when (atom pool) (acons index (pool-put subadr val nil) nil))
 (:let (head . pool) pool)
 (:let (key . subpool) head)
 (:when (equalp index key) (acons key (pool-put subadr val subpool) pool))
 (cons head (pool-put adr val pool)))

(defc test-pool
 (pool-put '("a" "b") "ab"
  (pool-put '("a" "c") "ac"
   (pool-put '("d") "d"
    (pool-put '("a" "b") :xx nil)))))

(etst (pool-get '("a" "b") test-pool) "ab")
(etst (pool-get '("a" "c") test-pool) "ac")
(etst (pool-get '("d") test-pool) "d")
(etst (pool-get '("e") test-pool) nil)

(deff pool-pop (adr pool)
 (:let (top . stack) (pool-get adr pool))
 (:let pool (pool-put adr stack pool))
 (cons top pool))

(deff pool-push (adr val pool)
 (:let stack (pool-get adr pool))
 (pool-put adr (cons val stack) pool))

(deff pool-cut (adr pool)
 (:let val (pool-get adr pool))
 (:when (null val) (cons val pool))
 (:let pool (pool-put adr nil pool))
 (cons val pool))

(deff pool-get* (pool &rest adr)
 (pool-get adr pool))

(deff pool-put* (pool val &rest adr)
 (pool-put adr val pool))

(deff pool-pop* (pool &rest adr)
 (pool-pop adr pool))

(deff pool-push* (pool val &rest adr)
 (pool-push adr val pool))

(deff pool-cut* (pool &rest adr)
 (pool-cut adr pool))

#|
=============================================
Add to the pool of infomation
=============================================
The *pool* variable contains a pool of information.

(pool-add address value) adds the value to the pool at the given address.
|#

(defvar *pool* nil)

(deff pool-add (pool address value)
 (pool-put address value pool))





