.TH "ZIP_GET_NAME" "3" "February 20, 2013" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_get_name\fR
\- get name of file by index
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIconst\ char\ *\fR
.br
\fBzip_get_name\fR(\fIstruct zip *archive\fR,\ \fIzip_uint64_t index\fR,\ \fIzip_flags_t flags\fR);
.SH "DESCRIPTION"
The
\fBzip_get_name\fR()
function returns the name of the file at position
\fIindex\fR
in
\fIarchive\fR.
The name is in UTF-8 encoding unless
\fRZIP_FL_ENC_RAW\fR
was specified (see below).
.PP
If
\fIflags\fR
is set to
\fRZIP_FL_UNCHANGED\fR,
the original unchanged filename is returned.
The returned string must not be modified or freed, and becomes invalid when
\fIarchive\fR
is closed.
.PP
Additionally, the following
\fIflags\fR
are supported:
.RS 6n
.TP 21n
\fRZIP_FL_ENC_RAW\fR
Return the unmodified names as it is in the ZIP archive.
.TP 21n
\fRZIP_FL_ENC_GUESS\fR
(Default.)
Guess the encoding of the name in the ZIP archive and convert it
to UTF-8, if necessary.
.TP 21n
\fRZIP_FL_ENC_STRICT\fR
Follow the ZIP specification and expect CP-437 encoded names in
the ZIP archive (except if they are explicitly marked as UTF-8).
Convert it to UTF-8.
.RE
\fINote:\fR
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
Upon successful completion, a pointer to the name is returned.
Otherwise,
\fRNULL\fR
and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_get_name\fR()
fails if:
.TP 19n
[\fRZIP_ER_DELETED\fR]
\fIindex\fR
refers to a file that has been deleted
(see
zip_delete(3)).
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR,
or
\fIindex\fR
points to an added file and
\fRZIP_FL_UNCHANGED\fR
is set.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_name_locate(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
