/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.NullView;

class HRuleView
extends InlineView {
    View nullView;
    static int HEIGHT = 4;

    public HRuleView(Element element) {
        super(element);
    }

    public int getBreakWeight(int axis, float pos, float len) {
        if (axis == 0 && this.getEndOffset() - this.getStartOffset() > 1) {
            return 3000;
        }
        return 0;
    }

    public void paint(Graphics g, Shape a) {
        Rectangle bounds = a.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.x + bounds.width;
        int h = bounds.y + (int)Math.round((double)bounds.height * 0.5 - 0.5);
        g.setColor(Color.black);
        g.drawLine(x, y++, w, h++);
        g.setColor(Color.lightGray);
        g.drawLine(x, y, w, h);
    }

    public View breakView(int axis, int offset, float pos, float len) {
        if (this.getEndOffset() - this.getStartOffset() > 1) {
            return new Beginning(this.getElement(), offset);
        }
        return this;
    }

    public float getMaximumSpan(int axis) {
        if (axis == 0) {
            Container container = this.getContainer();
            if (container != null) {
                return this.getContainer().getWidth();
            }
            return 640.0f;
        }
        return HEIGHT;
    }

    public float getPreferredSpan(int axis) {
        return this.getMaximumSpan(axis);
    }

    class Beginning
    extends NullView {
        int breakOffset;

        public int getEndOffset() {
            return this.breakOffset + 1;
        }

        public int getStartOffset() {
            return this.breakOffset;
        }

        public Beginning(Element element, int offset) {
            super(element);
            this.breakOffset = offset;
        }
    }
}

