/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;

public class BasicListUI
extends ListUI {
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    protected FocusListener focusListener;
    protected ListDataListener listDataListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseInputListener mouseInputListener;
    protected PropertyChangeListener propertyChangeListener;
    protected JList list;
    protected int cellHeight;
    protected int cellWidth;
    protected int[] cellHeights;
    protected int updateLayoutStateNeeded = 1;
    protected CellRendererPane rendererPane = new CellRendererPane();
    ListAction action;

    public static ComponentUI createUI(JComponent c) {
        return new BasicListUI();
    }

    protected int getRowHeight(int row) {
        int height = this.cellHeights == null ? this.cellHeight : (row < 0 || row >= this.cellHeights.length ? -1 : this.cellHeights[row]);
        return height;
    }

    public Rectangle getCellBounds(JList l, int index1, int index2) {
        this.maybeUpdateLayoutState();
        if (l != this.list || this.cellWidth == -1) {
            return null;
        }
        int minIndex = Math.min(index1, index2);
        int maxIndex = Math.max(index1, index2);
        Point loc = this.indexToLocation(this.list, minIndex);
        int width = this.cellWidth;
        if (l.getLayoutOrientation() == 0) {
            width = l.getWidth();
        }
        Rectangle bounds = new Rectangle(loc.x, loc.y, width, this.getCellHeight(minIndex));
        int i = minIndex + 1;
        while (i <= maxIndex) {
            Point hiLoc = this.indexToLocation(this.list, i);
            bounds = SwingUtilities.computeUnion(hiLoc.x, hiLoc.y, width, this.getCellHeight(i), bounds);
            ++i;
        }
        return bounds;
    }

    private int getCellHeight(int index) {
        int height = this.cellHeight;
        if (height <= 0) {
            if (this.list.getLayoutOrientation() == 0) {
                height = this.getRowHeight(index);
            } else {
                int j = 0;
                while (j < this.cellHeights.length) {
                    height = Math.max(height, this.cellHeights[j]);
                    ++j;
                }
            }
        }
        return height;
    }

    protected int convertRowToY(int row) {
        int y = 0;
        int i = 0;
        while (i < row) {
            int h = this.getRowHeight(i);
            if (h == -1) {
                return -1;
            }
            y += h;
            ++i;
        }
        return y;
    }

    protected int convertYToRow(int y0) {
        if (this.list.getModel().getSize() == 0) {
            return -1;
        }
        if (y0 < 0) {
            return this.list.getModel().getSize() - 1;
        }
        this.maybeUpdateLayoutState();
        int index = this.list.getModel().getSize() - 1;
        if (this.cellHeight > 0) {
            index = Math.min(y0 / this.cellHeight, index);
        } else {
            int h = 0;
            int row = 0;
            while (row < this.cellHeights.length) {
                if (y0 < (h += this.cellHeights[row])) {
                    index = row;
                    break;
                }
                ++row;
            }
        }
        return index;
    }

    protected void updateLayoutState() {
        int nrows = this.list.getModel().getSize();
        this.cellHeight = -1;
        this.cellWidth = -1;
        if (this.cellHeights == null || this.cellHeights.length != nrows) {
            this.cellHeights = new int[nrows];
        }
        ListCellRenderer rend = this.list.getCellRenderer();
        int fixedCellHeight = this.list.getFixedCellHeight();
        if (fixedCellHeight > 0) {
            this.cellHeight = fixedCellHeight;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            int i = 0;
            while (i < nrows) {
                Component flyweight = rend.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(i), i, this.list.isSelectedIndex(i), this.list.getSelectionModel().getAnchorSelectionIndex() == i);
                Dimension dim = flyweight.getPreferredSize();
                this.cellHeights[i] = dim.height;
                ++i;
            }
        }
        int fixedCellWidth = this.list.getFixedCellWidth();
        if (fixedCellWidth > 0) {
            this.cellWidth = fixedCellWidth;
        } else {
            int i = 0;
            while (i < nrows) {
                Component flyweight = rend.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(i), i, this.list.isSelectedIndex(i), this.list.getSelectionModel().getAnchorSelectionIndex() == i);
                Dimension dim = flyweight.getPreferredSize();
                this.cellWidth = Math.max(this.cellWidth, dim.width);
                ++i;
            }
        }
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0 || !this.list.isValid()) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.list, "List.background", "List.foreground", "List.font");
        this.list.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        this.list.setOpaque(true);
    }

    protected void uninstallDefaults() {
        this.list.setForeground(null);
        this.list.setBackground(null);
        this.list.setSelectionForeground(null);
        this.list.setSelectionBackground(null);
    }

    protected void installListeners() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListener();
        }
        this.list.addFocusListener(this.focusListener);
        if (this.listDataListener == null) {
            this.listDataListener = this.createListDataListener();
        }
        this.list.getModel().addListDataListener(this.listDataListener);
        if (this.listSelectionListener == null) {
            this.listSelectionListener = this.createListSelectionListener();
        }
        this.list.addListSelectionListener(this.listSelectionListener);
        if (this.mouseInputListener == null) {
            this.mouseInputListener = this.createMouseInputListener();
        }
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.list.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.list.removeFocusListener(this.focusListener);
        this.list.getModel().removeListDataListener(this.listDataListener);
        this.list.removeListSelectionListener(this.listSelectionListener);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        InputMap focusInputMap = (InputMap)UIManager.get("List.focusInputMap");
        SwingUtilities.replaceUIInputMap(this.list, 0, focusInputMap);
        ActionMap am = (ActionMap)UIManager.get("List.actionMap");
        if (am == null) {
            am = new ActionMapUIResource();
            ListAction action = new ListAction("selectPreviousRow");
            am.put("selectPreviousRow", action);
            action = new ListAction("selectNextRow");
            am.put("selectNextRow", action);
            action = new ListAction("selectPreviousRowExtendSelection");
            am.put("selectPreviousRowExtendSelection", action);
            action = new ListAction("selectNextRowExtendSelection");
            am.put("selectNextRowExtendSelection", action);
            action = new ListAction("selectPreviousColumn");
            am.put("selectPreviousColumn", action);
            action = new ListAction("selectNextColumn");
            am.put("selectNextColumn", action);
            action = new ListAction("selectPreviousColumnExtendSelection");
            am.put("selectPreviousColumnExtendSelection", action);
            action = new ListAction("selectNextColumnExtendSelection");
            am.put("selectNextColumnExtendSelection", action);
            action = new ListAction("selectFirstRow");
            am.put("selectFirstRow", action);
            action = new ListAction("selectLastRow");
            am.put("selectLastRow", action);
            action = new ListAction("selectFirstRowExtendSelection");
            am.put("selectFirstRowExtendSelection", action);
            action = new ListAction("selectLastRowExtendSelection");
            am.put("selectLastRowExtendSelection", action);
            action = new ListAction("scrollUp");
            am.put("scrollUp", action);
            action = new ListAction("scrollUpExtendSelection");
            am.put("scrollUpExtendSelection", action);
            action = new ListAction("scrollDown");
            am.put("scrollDown", action);
            action = new ListAction("scrollDownExtendSelection");
            am.put("scrollDownExtendSelection", action);
            action = new ListAction("selectAll");
            am.put("selectAll", action);
            action = new ListAction("clearSelection");
            am.put("clearSelection", action);
            am.put("copy", TransferHandler.getCopyAction());
            am.put("cut", TransferHandler.getCutAction());
            am.put("paste", TransferHandler.getPasteAction());
            UIManager.put("List.actionMap", am);
        }
        SwingUtilities.replaceUIActionMap(this.list, am);
    }

    protected void uninstallKeyboardActions() {
        InputMap im = SwingUtilities.getUIInputMap(this.list, 0);
        if (im instanceof UIResource) {
            SwingUtilities.replaceUIInputMap(this.list, 0, null);
        }
        if (SwingUtilities.getUIActionMap(this.list) instanceof UIResource) {
            SwingUtilities.replaceUIActionMap(this.list, null);
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.list = (JList)c;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.maybeUpdateLayoutState();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.list = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        int neededColumns;
        int w;
        int h;
        this.maybeUpdateLayoutState();
        int size = this.list.getModel().getSize();
        int visibleRows = this.list.getVisibleRowCount();
        int layoutOrientation = this.list.getLayoutOrientation();
        int maxCellHeight = this.cellHeight;
        if (maxCellHeight <= 0) {
            int i = 0;
            while (i < this.cellHeights.length) {
                maxCellHeight = Math.max(maxCellHeight, this.cellHeights[i]);
                ++i;
            }
        }
        if (layoutOrientation == 2) {
            if (visibleRows > 0) {
                double modelSize = size;
                int neededColumns2 = (int)Math.ceil(modelSize / (double)visibleRows);
                int adjustedRows = (int)Math.ceil(modelSize / (double)neededColumns2);
                h = maxCellHeight * adjustedRows;
                w = this.cellWidth * neededColumns2;
            } else {
                neededColumns = Math.min(1, this.list.getWidth() / this.cellWidth);
                h = size / neededColumns * maxCellHeight;
                w = neededColumns * this.cellWidth;
            }
        } else if (layoutOrientation == 1) {
            h = visibleRows > 0 ? visibleRows * maxCellHeight : Math.max(this.list.getHeight(), maxCellHeight);
            neededColumns = h / maxCellHeight;
            w = this.cellWidth * neededColumns;
        } else {
            w = this.list.getFixedCellWidth() > 0 ? this.list.getFixedCellWidth() : this.cellWidth;
            h = this.list.getFixedCellHeight() > 0 ? this.list.getFixedCellHeight() * size : maxCellHeight * size;
        }
        Insets insets = this.list.getInsets();
        Dimension retVal = new Dimension(w + insets.left + insets.right, h + insets.top + insets.bottom);
        return retVal;
    }

    protected void paintCell(Graphics g, int row, Rectangle bounds, ListCellRenderer rend, ListModel data, ListSelectionModel sel, int lead) {
        boolean isSel = this.list.isSelectedIndex(row);
        boolean hasFocus = this.list.getLeadSelectionIndex() == row && this.list.hasFocus();
        Component comp = rend.getListCellRendererComponent(this.list, data.getElementAt(row), row, isSel, hasFocus);
        this.rendererPane.paintComponent(g, comp, this.list, bounds);
    }

    public void paint(Graphics g, JComponent c) {
        int nrows = this.list.getModel().getSize();
        if (nrows == 0) {
            return;
        }
        this.maybeUpdateLayoutState();
        ListCellRenderer render = this.list.getCellRenderer();
        ListModel model = this.list.getModel();
        ListSelectionModel sel = this.list.getSelectionModel();
        int lead = sel.getLeadSelectionIndex();
        Rectangle clip = g.getClipBounds();
        int startIndex = this.locationToIndex(this.list, new Point(clip.x, clip.y));
        int endIndex = this.locationToIndex(this.list, new Point(clip.x + clip.width, clip.y + clip.height));
        int row = startIndex;
        while (row <= endIndex) {
            Rectangle bounds = this.getCellBounds(this.list, row, row);
            if (bounds != null && bounds.intersects(clip)) {
                this.paintCell(g, row, bounds, render, model, sel, lead);
            }
            ++row;
        }
    }

    public int locationToIndex(JList l, Point location) {
        int layoutOrientation = this.list.getLayoutOrientation();
        int index = -1;
        switch (layoutOrientation) {
            case 0: {
                index = this.convertYToRow(location.y);
                break;
            }
            case 2: {
                int maxCellHeight = this.getCellHeight(0);
                int visibleRows = this.list.getHeight() / maxCellHeight;
                int cellsPerRow = -1;
                int numberOfItems = this.list.getModel().getSize();
                cellsPerRow = numberOfItems / visibleRows + 1;
                int cellsPerColumn = numberOfItems / cellsPerRow + 1;
                int gridX = Math.min(location.x / this.cellWidth, cellsPerRow - 1);
                int gridY = Math.min(location.y / maxCellHeight, cellsPerColumn);
                index = gridX + gridY * cellsPerRow;
                break;
            }
            case 1: {
                int maxCellHeight2 = this.getCellHeight(0);
                int visibleRows2 = this.list.getHeight() / maxCellHeight2;
                int numberOfItems2 = this.list.getModel().getSize();
                int cellsPerRow2 = numberOfItems2 / visibleRows2 + 1;
                int gridX2 = Math.min(location.x / this.cellWidth, cellsPerRow2 - 1);
                int gridY2 = Math.min(location.y / maxCellHeight2, visibleRows2);
                index = gridY2 + gridX2 * visibleRows2;
            }
        }
        return index;
    }

    public Point indexToLocation(JList l, int index) {
        int layoutOrientation = this.list.getLayoutOrientation();
        Point loc = null;
        switch (layoutOrientation) {
            case 0: {
                loc = new Point(0, this.convertRowToY(index));
                break;
            }
            case 2: {
                int maxCellHeight = this.getCellHeight(0);
                int visibleRows = this.list.getHeight() / maxCellHeight;
                int numberOfCellsPerRow = -1;
                int numberOfItems = this.list.getModel().getSize();
                numberOfCellsPerRow = numberOfItems / visibleRows + 1;
                int gridX = index % numberOfCellsPerRow;
                int gridY = index / numberOfCellsPerRow;
                int locX = gridX * this.cellWidth;
                int locY = gridY * maxCellHeight;
                loc = new Point(locX, locY);
                break;
            }
            case 1: {
                int maxCellHeight2 = this.getCellHeight(0);
                int visibleRows2 = this.list.getHeight() / maxCellHeight2;
                if (visibleRows2 > 0) {
                    int gridY2 = index % visibleRows2;
                    int gridX2 = index / visibleRows2;
                    int locX2 = gridX2 * this.cellWidth;
                    int locY2 = gridY2 * maxCellHeight2;
                    loc = new Point(locX2, locY2);
                    break;
                }
                loc = new Point(0, this.convertRowToY(index));
            }
        }
        return loc;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void selectNextIndex() {
        int index = this.list.getSelectionModel().getLeadSelectionIndex();
        if (index < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(++index);
        }
        this.list.ensureIndexIsVisible(index);
    }

    protected void selectPreviousIndex() {
        int index = this.list.getSelectionModel().getLeadSelectionIndex();
        if (index > 0) {
            this.list.setSelectedIndex(--index);
        }
        this.list.ensureIndexIsVisible(index);
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public ActionListenerProxy(ActionListener li, String cmd) {
            this.target = li;
            this.bindingCommandName = cmd;
        }

        public void actionPerformed(ActionEvent e) {
            ActionEvent derivedEvent = new ActionEvent(e.getSource(), e.getID(), this.bindingCommandName, e.getModifiers());
            this.target.actionPerformed(derivedEvent);
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent e) {
            this.repaintCellFocus();
        }

        protected void repaintCellFocus() {
        }
    }

    private class ListAction
    extends AbstractAction {
        ListAction(String cmd) {
            this.putValue("ActionCommandKey", cmd);
        }

        public void actionPerformed(ActionEvent e) {
            int lead = BasicListUI.this.list.getLeadSelectionIndex();
            int max = BasicListUI.this.list.getModel().getSize() - 1;
            DefaultListSelectionModel selModel = (DefaultListSelectionModel)BasicListUI.this.list.getSelectionModel();
            String command = e.getActionCommand();
            if (max == -1) {
                return;
            }
            if (command.equals("selectNextRow")) {
                BasicListUI.this.selectNextIndex();
            } else if (command.equals("selectPreviousRow")) {
                BasicListUI.this.selectPreviousIndex();
            } else if (command.equals("clearSelection")) {
                BasicListUI.this.list.clearSelection();
            } else if (command.equals("selectAll")) {
                BasicListUI.this.list.setSelectionInterval(0, max);
                BasicListUI.this.list.addSelectionInterval(lead, lead);
            } else if (command.equals("selectLastRow")) {
                BasicListUI.this.list.setSelectedIndex(BasicListUI.this.list.getModel().getSize() - 1);
            } else if (command.equals("selectLastRowChangeLead")) {
                selModel.moveLeadSelectionIndex(BasicListUI.this.list.getModel().getSize() - 1);
            } else if (command.equals("scrollDownExtendSelection")) {
                int target = lead == BasicListUI.this.list.getLastVisibleIndex() ? Math.min(max, lead + (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getLastVisibleIndex();
                selModel.setLeadSelectionIndex(target);
            } else if (command.equals("scrollDownChangeLead")) {
                int target = lead == BasicListUI.this.list.getLastVisibleIndex() ? Math.min(max, lead + (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getLastVisibleIndex();
                selModel.moveLeadSelectionIndex(target);
            } else if (command.equals("scrollUpExtendSelection")) {
                int target = lead == BasicListUI.this.list.getFirstVisibleIndex() ? Math.max(0, lead - (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getFirstVisibleIndex();
                selModel.setLeadSelectionIndex(target);
            } else if (command.equals("scrollUpChangeLead")) {
                int target = lead == BasicListUI.this.list.getFirstVisibleIndex() ? Math.max(0, lead - (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getFirstVisibleIndex();
                selModel.moveLeadSelectionIndex(target);
            } else if (command.equals("selectNextRowExtendSelection")) {
                selModel.setLeadSelectionIndex(Math.min(lead + 1, max));
            } else if (command.equals("selectFirstRow")) {
                BasicListUI.this.list.setSelectedIndex(0);
            } else if (command.equals("selectFirstRowChangeLead")) {
                selModel.moveLeadSelectionIndex(0);
            } else if (command.equals("selectFirstRowExtendSelection")) {
                selModel.setLeadSelectionIndex(0);
            } else if (command.equals("selectPreviousRowExtendSelection")) {
                selModel.setLeadSelectionIndex(Math.max(0, lead - 1));
            } else if (command.equals("scrollUp")) {
                int target = lead == BasicListUI.this.list.getFirstVisibleIndex() ? Math.max(0, lead - (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getFirstVisibleIndex();
                BasicListUI.this.list.setSelectedIndex(target);
            } else if (command.equals("selectLastRowExtendSelection")) {
                selModel.setLeadSelectionIndex(BasicListUI.this.list.getModel().getSize() - 1);
            } else if (command.equals("scrollDown")) {
                int target = lead == BasicListUI.this.list.getLastVisibleIndex() ? Math.min(max, lead + (BasicListUI.this.list.getLastVisibleIndex() - BasicListUI.this.list.getFirstVisibleIndex() + 1)) : BasicListUI.this.list.getLastVisibleIndex();
                BasicListUI.this.list.setSelectedIndex(target);
            } else if (command.equals("selectNextRowChangeLead")) {
                if (selModel.getSelectionMode() != 2) {
                    BasicListUI.this.selectNextIndex();
                } else {
                    selModel.moveLeadSelectionIndex(Math.min(max, lead + 1));
                }
            } else if (command.equals("selectPreviousRowChangeLead")) {
                if (selModel.getSelectionMode() != 2) {
                    BasicListUI.this.selectPreviousIndex();
                } else {
                    selModel.moveLeadSelectionIndex(Math.max(0, lead - 1));
                }
            } else if (command.equals("addToSelection")) {
                BasicListUI.this.list.addSelectionInterval(lead, lead);
            } else if (command.equals("extendTo")) {
                selModel.setSelectionInterval(selModel.getAnchorSelectionIndex(), lead);
            } else if (command.equals("toggleAndAnchor")) {
                if (!BasicListUI.this.list.isSelectedIndex(lead)) {
                    BasicListUI.this.list.addSelectionInterval(lead, lead);
                } else {
                    BasicListUI.this.list.removeSelectionInterval(lead, lead);
                }
                selModel.setAnchorSelectionIndex(lead);
            }
            BasicListUI.this.list.ensureIndexIsVisible(BasicListUI.this.list.getLeadSelectionIndex());
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent e) {
            BasicListUI.this.updateLayoutStateNeeded |= 1;
            BasicListUI.this.list.revalidate();
        }

        public void intervalAdded(ListDataEvent e) {
            BasicListUI.this.updateLayoutStateNeeded |= 1;
            BasicListUI.this.list.revalidate();
        }

        public void intervalRemoved(ListDataEvent e) {
            BasicListUI.this.updateLayoutStateNeeded |= 1;
            BasicListUI.this.list.revalidate();
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            int index2;
            int index1 = e.getFirstIndex();
            Rectangle damaged = BasicListUI.this.getCellBounds(BasicListUI.this.list, index1, index2 = e.getLastIndex());
            if (damaged != null) {
                BasicListUI.this.list.repaint(damaged);
            }
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent event) {
            Point click = event.getPoint();
            int index = BasicListUI.this.locationToIndex(BasicListUI.this.list, click);
            if (index == -1) {
                return;
            }
            if (event.isShiftDown()) {
                if (BasicListUI.this.list.getSelectionMode() == 0) {
                    BasicListUI.this.list.setSelectedIndex(index);
                } else if (BasicListUI.this.list.getSelectionMode() == 1) {
                    BasicListUI.this.list.setSelectionInterval(BasicListUI.this.list.getAnchorSelectionIndex(), index);
                } else if (BasicListUI.this.list.isSelectedIndex(BasicListUI.this.list.getAnchorSelectionIndex())) {
                    BasicListUI.this.list.getSelectionModel().setLeadSelectionIndex(index);
                } else {
                    BasicListUI.this.list.addSelectionInterval(BasicListUI.this.list.getAnchorSelectionIndex(), index);
                }
            } else if (event.isControlDown()) {
                if (BasicListUI.this.list.getSelectionMode() == 0) {
                    BasicListUI.this.list.setSelectedIndex(index);
                } else if (BasicListUI.this.list.isSelectedIndex(index)) {
                    BasicListUI.this.list.removeSelectionInterval(index, index);
                } else {
                    BasicListUI.this.list.addSelectionInterval(index, index);
                }
            } else {
                BasicListUI.this.list.setSelectedIndex(index);
            }
            BasicListUI.this.list.ensureIndexIsVisible(BasicListUI.this.list.getLeadSelectionIndex());
        }

        public void mousePressed(MouseEvent event) {
            BasicListUI.this.list.requestFocusInWindow();
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseDragged(MouseEvent event) {
            Point click = event.getPoint();
            int index = BasicListUI.this.locationToIndex(BasicListUI.this.list, click);
            if (index == -1) {
                return;
            }
            if (!event.isShiftDown() && !event.isControlDown()) {
                BasicListUI.this.list.setSelectedIndex(index);
            }
            BasicListUI.this.list.ensureIndexIsVisible(BasicListUI.this.list.getLeadSelectionIndex());
        }

        public void mouseMoved(MouseEvent event) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("model")) {
                if (e.getOldValue() != null && e.getOldValue() instanceof ListModel) {
                    ListModel oldModel = (ListModel)e.getOldValue();
                    oldModel.removeListDataListener(BasicListUI.this.listDataListener);
                }
                if (e.getNewValue() != null && e.getNewValue() instanceof ListModel) {
                    ListModel newModel = (ListModel)e.getNewValue();
                    newModel.addListDataListener(BasicListUI.this.listDataListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
            } else if (e.getPropertyName().equals("selectionModel")) {
                BasicListUI.this.updateLayoutStateNeeded |= 2;
            } else if (e.getPropertyName().equals("font")) {
                BasicListUI.this.updateLayoutStateNeeded |= 4;
            } else if (e.getPropertyName().equals("fixedCellWidth")) {
                BasicListUI.this.updateLayoutStateNeeded |= 8;
            } else if (e.getPropertyName().equals("fixedCellHeight")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x10;
            } else if (e.getPropertyName().equals("prototypeCellValue")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x20;
            } else if (e.getPropertyName().equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
            }
        }
    }
}

