/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractSpinnerModel;

public class SpinnerDateModel
extends AbstractSpinnerModel
implements Serializable {
    private Calendar date;
    private Comparable start;
    private Comparable end;
    private int calendarField;
    private static final long serialVersionUID = -4802518107105940612L;

    public SpinnerDateModel() {
        this(new Date(), null, null, 5);
    }

    public SpinnerDateModel(Date value, Comparable start, Comparable end, int calendarField) {
        if (value == null) {
            throw new IllegalArgumentException("Null 'value' argument.");
        }
        if (start != null && start.compareTo(value) > 0) {
            throw new IllegalArgumentException("Require value on or after start.");
        }
        if (end != null && end.compareTo(value) < 0) {
            throw new IllegalArgumentException("Require value on or before end.");
        }
        this.date = Calendar.getInstance();
        this.date.setTime(value);
        this.start = start;
        this.end = end;
        this.setCalendarField(calendarField);
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public Date getDate() {
        return this.date.getTime();
    }

    public Comparable getStart() {
        return this.start;
    }

    public Comparable getEnd() {
        return this.end;
    }

    public Object getValue() {
        return this.date.getTime();
    }

    public Object getNextValue() {
        Calendar nextCal = Calendar.getInstance();
        nextCal.setTime(this.date.getTime());
        nextCal.roll(this.calendarField, true);
        Date nextDate = nextCal.getTime();
        if (this.end != null && this.end.compareTo(nextDate) < 0) {
            return null;
        }
        return nextDate;
    }

    public Object getPreviousValue() {
        Calendar prevCal = Calendar.getInstance();
        prevCal.setTime(this.date.getTime());
        prevCal.roll(this.calendarField, false);
        Date prevDate = prevCal.getTime();
        if (this.start != null && this.start.compareTo(prevDate) > 0) {
            return null;
        }
        return prevDate;
    }

    public void setCalendarField(int calendarField) {
        if (calendarField < 0 || calendarField >= 17 || calendarField == 15 || calendarField == 16) {
            throw new IllegalArgumentException("Illegal calendarField");
        }
        if (this.calendarField != calendarField) {
            this.calendarField = calendarField;
            this.fireStateChanged();
        }
    }

    public void setStart(Comparable start) {
        if (this.start != start) {
            this.start = start;
            this.fireStateChanged();
        }
    }

    public void setEnd(Comparable end) {
        if (this.end != end) {
            this.end = end;
            this.fireStateChanged();
        }
    }

    public void setValue(Object value) {
        if (!(value instanceof Date) || value == null) {
            throw new IllegalArgumentException("Value not a date.");
        }
        if (!this.date.getTime().equals(value)) {
            this.date.setTime((Date)value);
            this.fireStateChanged();
        }
    }
}

