/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import gnu.java.io.Base64InputStream;
import gnu.java.security.OID;
import gnu.java.security.pkcs.PKCS7SignedData;
import gnu.java.security.pkcs.SignerInfo;
import gnu.java.security.provider.Gnu;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final String META_INF = "META-INF/";
    private static final String PKCS7_DSA_SUFFIX = ".DSA";
    private static final String PKCS7_RSA_SUFFIX = ".RSA";
    private static final String DIGEST_KEY_SUFFIX = "-Digest";
    private static final String SF_SUFFIX = ".SF";
    static final Gnu provider = new Gnu();
    private static final OID MD2_OID = new OID("1.2.840.113549.2.2");
    private static final OID MD4_OID = new OID("1.2.840.113549.2.4");
    private static final OID MD5_OID = new OID("1.2.840.113549.2.5");
    private static final OID SHA1_OID = new OID("1.3.14.3.2.26");
    private static final OID DSA_ENCRYPTION_OID = new OID("1.2.840.10040.4.1");
    private static final OID RSA_ENCRYPTION_OID = new OID("1.2.840.113549.1.1.1");
    private Manifest manifest;
    boolean verify;
    private boolean manifestRead = false;
    boolean signaturesRead = false;
    HashMap verified = new HashMap();
    HashMap entryCerts;
    private HashMap digestAlgorithms = new HashMap();
    static boolean DEBUG = false;

    static void debug(Object msg) {
        System.err.print(JarFile.class.getName());
        System.err.print(" >>> ");
        System.err.println(msg);
    }

    public JarFile(String fileName) throws FileNotFoundException, IOException {
        this(fileName, true);
    }

    public JarFile(String fileName, boolean verify) throws FileNotFoundException, IOException {
        super(fileName);
        if (verify) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file) throws FileNotFoundException, IOException {
        this(file, true);
    }

    public JarFile(File file, boolean verify) throws FileNotFoundException, IOException {
        super(file);
        if (verify) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file, boolean verify, int mode) throws FileNotFoundException, IOException, IllegalArgumentException {
        super(file, mode);
        if (verify) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    private void verify() {
        if (this.manifest == null) {
            this.verify = false;
            return;
        }
        this.verify = true;
    }

    private Manifest readManifest() {
        try {
            ZipEntry manEntry = super.getEntry(MANIFEST_NAME);
            if (manEntry != null) {
                InputStream in = super.getInputStream(manEntry);
                this.manifestRead = true;
                return new Manifest(in);
            }
            this.manifestRead = true;
            return null;
        }
        catch (IOException iOException) {
            this.manifestRead = true;
            return null;
        }
    }

    public Enumeration<JarEntry> entries() throws IllegalStateException {
        return new JarEnumeration(super.entries(), this);
    }

    @Override
    public synchronized ZipEntry getEntry(String name) {
        ZipEntry entry = super.getEntry(name);
        if (entry != null) {
            Manifest manifest;
            JarEntry jarEntry = new JarEntry(entry);
            try {
                manifest = this.getManifest();
            }
            catch (IOException iOException) {
                manifest = null;
            }
            if (manifest != null) {
                jarEntry.attr = manifest.getAttributes(name);
            }
            if (this.verify && !this.signaturesRead) {
                try {
                    this.readSignatures();
                }
                catch (IOException ioe) {
                    if (DEBUG) {
                        JarFile.debug(ioe);
                        ioe.printStackTrace();
                    }
                    this.signaturesRead = true;
                }
            }
            jarEntry.jarfile = this;
            return jarEntry;
        }
        return null;
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry entry) throws ZipException, IOException {
        if (!this.verified.containsKey(entry.getName()) && this.verify) {
            if (DEBUG) {
                JarFile.debug("reading and verifying " + entry);
            }
            return new EntryInputStream(entry, super.getInputStream(entry), this);
        }
        if (DEBUG) {
            JarFile.debug("reading already verified entry " + entry);
        }
        if (this.verify && this.verified.get(entry.getName()) == Boolean.FALSE) {
            throw new ZipException("digest for " + entry + " is invalid");
        }
        return super.getInputStream(entry);
    }

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    public synchronized Manifest getManifest() throws IOException {
        if (!this.manifestRead) {
            this.manifest = this.readManifest();
        }
        return this.manifest;
    }

    void readSignatures() throws IOException {
        int len;
        HashMap<String, PKCS7SignedData> pkcs7Dsa = new HashMap<String, PKCS7SignedData>();
        HashMap<String, PKCS7SignedData> pkcs7Rsa = new HashMap<String, PKCS7SignedData>();
        HashMap<String, Manifest> sigFiles = new HashMap<String, Manifest>();
        Enumeration<? extends ZipEntry> e = super.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String name = ze.getName();
            if (!name.startsWith(META_INF)) continue;
            String alias = name.substring(META_INF.length());
            if (alias.lastIndexOf(46) >= 0) {
                alias = alias.substring(0, alias.lastIndexOf(46));
            }
            if (name.endsWith(PKCS7_DSA_SUFFIX) || name.endsWith(PKCS7_RSA_SUFFIX)) {
                if (DEBUG) {
                    JarFile.debug("reading PKCS7 info from " + name + ", alias=" + alias);
                }
                PKCS7SignedData sig = null;
                try {
                    sig = new PKCS7SignedData(super.getInputStream(ze));
                }
                catch (CertificateException ce) {
                    IOException ioe = new IOException("certificate parsing error");
                    ioe.initCause(ce);
                    throw ioe;
                }
                catch (CRLException crle) {
                    IOException ioe = new IOException("CRL parsing error");
                    ioe.initCause(crle);
                    throw ioe;
                }
                if (name.endsWith(PKCS7_DSA_SUFFIX)) {
                    pkcs7Dsa.put(alias, sig);
                    continue;
                }
                if (!name.endsWith(PKCS7_RSA_SUFFIX)) continue;
                pkcs7Rsa.put(alias, sig);
                continue;
            }
            if (!name.endsWith(SF_SUFFIX)) continue;
            if (DEBUG) {
                JarFile.debug("reading signature file for " + alias + ": " + name);
            }
            Manifest sf = new Manifest(super.getInputStream(ze));
            sigFiles.put(alias, sf);
            if (!DEBUG) continue;
            JarFile.debug("result: " + sf);
        }
        HashSet validCerts = new HashSet();
        HashMap entryCerts = new HashMap();
        Iterator it = sigFiles.entrySet().iterator();
        while (it.hasNext()) {
            Iterator it2;
            Set signerInfos;
            Certificate[] certs;
            Map.Entry e2 = it.next();
            String alias = (String)e2.getKey();
            PKCS7SignedData sig = (PKCS7SignedData)pkcs7Dsa.get(alias);
            if (sig != null) {
                certs = sig.getCertificates();
                signerInfos = sig.getSignerInfos();
                it2 = signerInfos.iterator();
                while (it2.hasNext()) {
                    this.verify(certs, (SignerInfo)it2.next(), alias, validCerts);
                }
            }
            if ((sig = (PKCS7SignedData)pkcs7Rsa.get(alias)) != null) {
                certs = sig.getCertificates();
                signerInfos = sig.getSignerInfos();
                it2 = signerInfos.iterator();
                while (it2.hasNext()) {
                    this.verify(certs, (SignerInfo)it2.next(), alias, validCerts);
                }
            }
            if (validCerts.isEmpty()) {
                it.remove();
                continue;
            }
            entryCerts.put(e2.getValue(), new HashSet(validCerts));
            validCerts.clear();
        }
        InputStream in = super.getInputStream(super.getEntry(MANIFEST_NAME));
        ByteArrayOutputStream baStream = new ByteArrayOutputStream();
        byte[] ba = new byte[1024];
        while ((len = in.read(ba)) >= 0) {
            baStream.write(ba, 0, len);
        }
        in.close();
        HashMap<String, String> hmManifestEntries = new HashMap<String, String>();
        Pattern p = Pattern.compile("Name: (.+?\r?\n(?: .+?\r?\n)*).+?-Digest: .+?\r?\n\r?\n");
        Matcher m = p.matcher(baStream.toString());
        while (m.find()) {
            String fileName = m.group(1).replaceAll("\r?\n ?", "");
            hmManifestEntries.put(fileName, m.group());
        }
        this.entryCerts = new HashMap();
        for (Map.Entry e3 : entryCerts.entrySet()) {
            Manifest sigfile = (Manifest)e3.getKey();
            Map<String, Attributes> entries = sigfile.getEntries();
            Set certificates = (Set)e3.getValue();
            for (Map.Entry<String, Attributes> e2 : entries.entrySet()) {
                Set s;
                Attributes attr;
                String entryname = String.valueOf(e2.getKey());
                if (!this.verifyHashes(entryname, attr = e2.getValue(), hmManifestEntries)) continue;
                if (DEBUG) {
                    JarFile.debug("entry " + entryname + " has certificates " + certificates);
                }
                if ((s = (Set)this.entryCerts.get(entryname)) != null) {
                    s.addAll(certificates);
                    continue;
                }
                this.entryCerts.put(entryname, new HashSet(certificates));
            }
        }
        this.signaturesRead = true;
    }

    private void verify(Certificate[] certs, SignerInfo signerInfo, String alias, Set validCerts) {
        Signature sig;
        block22: {
            sig = null;
            try {
                OID alg = signerInfo.getDigestEncryptionAlgorithmId();
                if (alg.equals(DSA_ENCRYPTION_OID)) {
                    if (!signerInfo.getDigestAlgorithmId().equals(SHA1_OID)) {
                        return;
                    }
                    sig = Signature.getInstance("SHA1withDSA", provider);
                    break block22;
                }
                if (alg.equals(RSA_ENCRYPTION_OID)) {
                    OID hash = signerInfo.getDigestAlgorithmId();
                    if (hash.equals(MD2_OID)) {
                        sig = Signature.getInstance("md2WithRsaEncryption", provider);
                        break block22;
                    }
                    if (hash.equals(MD4_OID)) {
                        sig = Signature.getInstance("md4WithRsaEncryption", provider);
                        break block22;
                    }
                    if (hash.equals(MD5_OID)) {
                        sig = Signature.getInstance("md5WithRsaEncryption", provider);
                        break block22;
                    }
                    if (hash.equals(SHA1_OID)) {
                        sig = Signature.getInstance("sha1WithRsaEncryption", provider);
                        break block22;
                    }
                    return;
                }
                if (DEBUG) {
                    JarFile.debug("unsupported signature algorithm: " + alg);
                }
                return;
            }
            catch (NoSuchAlgorithmException nsae) {
                if (DEBUG) {
                    JarFile.debug(nsae);
                    nsae.printStackTrace();
                }
                return;
            }
        }
        ZipEntry sigFileEntry = super.getEntry(META_INF + alias + SF_SUFFIX);
        if (sigFileEntry == null) {
            return;
        }
        int i = 0;
        while (i < certs.length) {
            X509Certificate cert;
            if (certs[i] instanceof X509Certificate && (cert = (X509Certificate)certs[i]).getIssuerX500Principal().equals(signerInfo.getIssuer()) && cert.getSerialNumber().equals(signerInfo.getSerialNumber())) {
                try {
                    sig.initVerify(cert.getPublicKey());
                    InputStream in = super.getInputStream(sigFileEntry);
                    if (in != null) {
                        byte[] buf = new byte[1024];
                        int len = 0;
                        while ((len = in.read(buf)) != -1) {
                            sig.update(buf, 0, len);
                        }
                        if (sig.verify(signerInfo.getEncryptedDigest())) {
                            if (DEBUG) {
                                JarFile.debug("signature for " + cert.getSubjectDN() + " is good");
                            }
                            validCerts.add(cert);
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (InvalidKeyException invalidKeyException) {
                }
                catch (SignatureException signatureException) {}
            }
            ++i;
        }
    }

    private boolean verifyHashes(String entry, Attributes attr, HashMap hmManifestEntries) {
        int verified = 0;
        String stringEntry = (String)hmManifestEntries.get(entry);
        if (stringEntry == null) {
            if (DEBUG) {
                JarFile.debug("could not find " + entry + " in manifest");
            }
            return false;
        }
        byte[] entryBytes = stringEntry.getBytes();
        for (Map.Entry<Object, Object> e : attr.entrySet()) {
            block11: {
                String key = String.valueOf(e.getKey());
                if (!key.endsWith(DIGEST_KEY_SUFFIX)) continue;
                String alg = key.substring(0, key.length() - DIGEST_KEY_SUFFIX.length());
                byte[] hash = Base64InputStream.decode((String)e.getValue());
                MessageDigest md = (MessageDigest)this.digestAlgorithms.get(alg);
                if (md == null) {
                    md = MessageDigest.getInstance(alg, provider);
                    this.digestAlgorithms.put(alg, md);
                }
                md.reset();
                byte[] hash2 = md.digest(entryBytes);
                if (DEBUG) {
                    JarFile.debug("verifying SF entry " + entry + " alg: " + md.getAlgorithm() + " expect=" + new BigInteger(hash).toString(16) + " comp=" + new BigInteger(hash2).toString(16));
                }
                if (Arrays.equals(hash, hash2)) break block11;
                return false;
            }
            try {
                ++verified;
            }
            catch (IOException ioe) {
                if (DEBUG) {
                    JarFile.debug(ioe);
                    ioe.printStackTrace();
                }
                return false;
            }
            catch (NoSuchAlgorithmException nsae) {
                if (DEBUG) {
                    JarFile.debug(nsae);
                    nsae.printStackTrace();
                }
                return false;
            }
        }
        return verified > 0;
    }

    private static class EntryInputStream
    extends FilterInputStream {
        private final JarFile jarfile;
        private final long length;
        private long pos;
        private final ZipEntry entry;
        private final byte[][] hashes;
        private final MessageDigest[] md;
        private boolean checked;

        EntryInputStream(ZipEntry entry, InputStream in, JarFile jar) throws IOException {
            super(in);
            this.entry = entry;
            this.jarfile = jar;
            this.length = entry.getSize();
            this.pos = 0L;
            this.checked = false;
            Manifest manifest = this.jarfile.getManifest();
            Attributes attr = manifest != null ? manifest.getAttributes(entry.getName()) : null;
            if (DEBUG) {
                JarFile.debug("verifying entry " + entry + " attr=" + attr);
            }
            if (attr == null) {
                this.hashes = new byte[0][];
                this.md = new MessageDigest[0];
            } else {
                LinkedList hashes = new LinkedList();
                LinkedList<MessageDigest> md = new LinkedList<MessageDigest>();
                for (Map.Entry<Object, Object> e : attr.entrySet()) {
                    String key = String.valueOf(e.getKey());
                    if (key == null || !key.endsWith(JarFile.DIGEST_KEY_SUFFIX)) continue;
                    hashes.add(Base64InputStream.decode((String)e.getValue()));
                    try {
                        int length = key.length() - JarFile.DIGEST_KEY_SUFFIX.length();
                        String alg = key.substring(0, length);
                        md.add(MessageDigest.getInstance(alg, provider));
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        IOException ioe = new IOException("no such message digest: " + key);
                        ioe.initCause(nsae);
                        throw ioe;
                    }
                }
                if (DEBUG) {
                    JarFile.debug("digests=" + md);
                }
                this.hashes = (byte[][])hashes.toArray((T[])new byte[hashes.size()][]);
                this.md = md.toArray((T[])new MessageDigest[md.size()]);
            }
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readLimit) {
        }

        public void reset() {
        }

        public int read() throws IOException {
            int b = super.read();
            if (b == -1) {
                this.eof();
                return -1;
            }
            int i = 0;
            while (i < this.md.length) {
                this.md[i].update((byte)b);
                ++i;
            }
            ++this.pos;
            if (this.length > 0L && this.pos >= this.length) {
                this.eof();
            }
            return b;
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int count = super.read(buf, off, (int)Math.min((long)len, this.length != 0L ? this.length - this.pos : Integer.MAX_VALUE));
            if (count == -1 || this.length > 0L && this.pos >= this.length) {
                this.eof();
                return -1;
            }
            int i = 0;
            while (i < this.md.length) {
                this.md[i].update(buf, off, count);
                ++i;
            }
            this.pos += (long)count;
            if (this.length != 0L && this.pos >= this.length) {
                this.eof();
            }
            return count;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public long skip(long bytes) throws IOException {
            byte[] b = new byte[1024];
            long amount = 0L;
            while (amount < bytes) {
                int l = this.read(b, 0, (int)Math.min((long)b.length, bytes - amount));
                if (l == -1) break;
                amount += (long)l;
            }
            return amount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eof() throws IOException {
            if (this.checked) {
                return;
            }
            this.checked = true;
            int i = 0;
            while (i < this.md.length) {
                byte[] hash = this.md[i].digest();
                if (DEBUG) {
                    JarFile.debug("verifying " + this.md[i].getAlgorithm() + " expect=" + new BigInteger(this.hashes[i]).toString(16) + " comp=" + new BigInteger(hash).toString(16));
                }
                if (!Arrays.equals(hash, this.hashes[i])) {
                    JarFile jarFile = this.jarfile;
                    synchronized (jarFile) {
                        if (DEBUG) {
                            JarFile.debug(this.entry + " could NOT be verified");
                        }
                        this.jarfile.verified.put(this.entry.getName(), Boolean.FALSE);
                    }
                    return;
                }
                ++i;
            }
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                if (DEBUG) {
                    JarFile.debug(this.entry + " has been VERIFIED");
                }
                this.jarfile.verified.put(this.entry.getName(), Boolean.TRUE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JarEnumeration
    implements Enumeration<JarEntry> {
        private final Enumeration<? extends ZipEntry> entries;
        private final JarFile jarfile;

        JarEnumeration(Enumeration<? extends ZipEntry> e, JarFile f) {
            this.entries = e;
            this.jarfile = f;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entries.hasMoreElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JarEntry nextElement() {
            Manifest manifest;
            ZipEntry zip = this.entries.nextElement();
            JarEntry jar = new JarEntry(zip);
            try {
                manifest = this.jarfile.getManifest();
            }
            catch (IOException iOException) {
                manifest = null;
            }
            if (manifest != null) {
                jar.attr = manifest.getAttributes(jar.getName());
            }
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                if (this.jarfile.verify && !this.jarfile.signaturesRead) {
                    try {
                        this.jarfile.readSignatures();
                    }
                    catch (IOException ioe) {
                        if (DEBUG) {
                            JarFile.debug(ioe);
                            ioe.printStackTrace();
                        }
                        this.jarfile.signaturesRead = true;
                    }
                }
            }
            jar.jarfile = this.jarfile;
            return jar;
        }
    }
}

