/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.x509.X500DistinguishedName;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CertSelectorImpl
implements CertSelector {
    private Set issuerNames = new HashSet();
    private Set subjectNames = new HashSet();

    public void addIssuerName(byte[] issuerName) throws IOException {
        this.issuerNames.add(new X500DistinguishedName(issuerName));
    }

    public void addIssuerName(String issuerName) {
        this.issuerNames.add(new X500DistinguishedName(issuerName));
    }

    public void addIssuerName(Principal issuerName) throws IOException {
        if (issuerName instanceof X500DistinguishedName) {
            this.issuerNames.add(issuerName);
        } else if (issuerName instanceof X500Principal) {
            this.issuerNames.add(new X500DistinguishedName(((X500Principal)issuerName).getEncoded()));
        } else {
            this.issuerNames.add(new X500DistinguishedName(issuerName.getName()));
        }
    }

    public Collection getIssuerNames() {
        return Collections.unmodifiableSet(this.issuerNames);
    }

    public void addSubjectName(byte[] subjectName) throws IOException {
        this.subjectNames.add(new X500DistinguishedName(subjectName));
    }

    public void addSubjectName(String subjectName) throws IOException {
        this.subjectNames.add(new X500DistinguishedName(subjectName));
    }

    public void addSubjectName(Principal subjectName) throws IOException {
        if (subjectName instanceof X500DistinguishedName) {
            this.subjectNames.add(subjectName);
        } else if (subjectName instanceof X500Principal) {
            this.subjectNames.add(new X500DistinguishedName(((X500Principal)subjectName).getEncoded()));
        } else {
            this.subjectNames.add(new X500DistinguishedName(subjectName.getName()));
        }
    }

    public Collection getSubjectNames() {
        return Collections.unmodifiableSet(this.subjectNames);
    }

    public Object clone() {
        X509CertSelectorImpl copy = new X509CertSelectorImpl();
        copy.issuerNames.addAll(this.issuerNames);
        copy.subjectNames.addAll(this.subjectNames);
        return copy;
    }

    public boolean match(Certificate cert) {
        boolean matchSubject;
        boolean matchIssuer;
        block8: {
            if (!(cert instanceof X509Certificate)) {
                return false;
            }
            matchIssuer = false;
            matchSubject = false;
            try {
                Principal p = ((X509Certificate)cert).getIssuerDN();
                X500DistinguishedName thisName = null;
                thisName = p instanceof X500DistinguishedName ? (X500DistinguishedName)p : (p instanceof X500Principal ? new X500DistinguishedName(((X500Principal)p).getEncoded()) : new X500DistinguishedName(p.getName()));
                if (this.issuerNames.isEmpty()) {
                    matchIssuer = true;
                } else {
                    for (X500DistinguishedName name : this.issuerNames) {
                        if (!thisName.equals(name)) continue;
                        matchIssuer = true;
                        break;
                    }
                }
                p = ((X509Certificate)cert).getSubjectDN();
                thisName = null;
                thisName = p instanceof X500DistinguishedName ? (X500DistinguishedName)p : (p instanceof X500Principal ? new X500DistinguishedName(((X500Principal)p).getEncoded()) : new X500DistinguishedName(p.getName()));
                if (this.subjectNames.isEmpty()) {
                    matchSubject = true;
                    break block8;
                }
                for (X500DistinguishedName name : this.subjectNames) {
                    if (!thisName.equals(name)) continue;
                    matchSubject = true;
                    break;
                }
            }
            catch (Exception exception) {}
        }
        return matchIssuer && matchSubject;
    }
}

